/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.model.table;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.table.GridData;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.wrapper.SimplePlanOrder;
import kd.mmc.mrp.utils.MRPUtil;
import kd.mmc.mrp.utils.bitset.BitSetFactory;
import kd.mmc.mrp.utils.bitset.IntBitSet;

public class DataBalanceTable
implements Serializable {
    private static final long serialVersionUID = 1L;
    private HashMap<Integer, RSMapping> allMappings = new HashMap(7);
    private List<RSMapping> unVisitedMappings = new ArrayList<RSMapping>(7);
    private List<RSMapping> mappings = new ArrayList<RSMapping>(7);
    private List<RSMapping> splitMappings = new ArrayList<RSMapping>(7);
    private Map<String, RSMapping> mergedMappings = new HashMap<String, RSMapping>(7);
    private TreeMap<Long, Map<String, List<RSMapping>>> groupMappings = new TreeMap();
    private List<RSMapping> exceptionMappings = new ArrayList<RSMapping>(7);

    public synchronized int getNewRequireIndex() {
        if (this.allMappings.isEmpty()) {
            return 0;
        }
        ArrayList<Integer> allIndexs = new ArrayList<Integer>(this.allMappings.keySet());
        allIndexs.sort(Integer::compareTo);
        return (Integer)allIndexs.get(allIndexs.size() - 1) + 1;
    }

    public synchronized void addMapping(RequireRowData require, List<RowData> supplys, MatchType mt) {
        RSMapping mapping = this.allMappings.get(require.getRowIdx());
        BigDecimal srcVal = MRPUtil.convert(require.getValue(DefaultField.RequireField.QTY.getName()), BigDecimal.ZERO);
        if (mapping != null) {
            BigDecimal netDemandQty = srcVal;
            if (mapping.supplys != null) {
                if (supplys != null) {
                    Iterator<RowData> iter = supplys.iterator();
                    while (iter.hasNext()) {
                        RowData supply = iter.next();
                        BigDecimal sQty = MRPUtil.convert(supply.getValue(DefaultField.SupplyField.QTY.getName()), BigDecimal.ZERO);
                        if (sQty.compareTo(BigDecimal.ZERO) == 0) {
                            iter.remove();
                            continue;
                        }
                        netDemandQty = netDemandQty.subtract(sQty);
                    }
                    mapping.supplys.addAll(supplys);
                }
            } else if (supplys != null) {
                mapping.supplys = supplys;
            }
            require.update(DefaultField.RequireField.QTY.getName(), (Object)netDemandQty);
            String msg = MRPUtil.mergeException(mapping.require.getString(DefaultField.RequireField.EXCEPTIONMESSAGE.getName()), require.getString(DefaultField.RequireField.EXCEPTIONMESSAGE.getName()), "\r\n");
            String num = MRPUtil.mergeException(mapping.require.getString(DefaultField.RequireField.EXCEPTIONNUMBER.getName()), require.getString(DefaultField.RequireField.EXCEPTIONNUMBER.getName()), ",");
            mapping.require.update(DefaultField.RequireField.EXCEPTIONMESSAGE.getName(), (Object)msg);
            mapping.require.update(DefaultField.RequireField.EXCEPTIONNUMBER.getName(), (Object)num);
        } else {
            List<RSMapping> mappings;
            Map<String, List<RSMapping>> group;
            BigDecimal netDemandQty = srcVal;
            if (supplys != null) {
                Iterator<RowData> iter = supplys.iterator();
                while (iter.hasNext()) {
                    RowData supply = iter.next();
                    BigDecimal sQty = MRPUtil.convert(supply.getValue(DefaultField.SupplyField.QTY.getName()), BigDecimal.ZERO);
                    if (sQty.compareTo(BigDecimal.ZERO) == 0) {
                        iter.remove();
                        continue;
                    }
                    netDemandQty = netDemandQty.subtract(sQty);
                }
                require.update(DefaultField.RequireField.QTY.getName(), (Object)netDemandQty);
            }
            mapping = new RSMapping();
            mapping.require = require;
            mapping.supplys = supplys;
            mapping.isCopied = false;
            String exp = String.valueOf(require.getValue(DefaultField.RequireField.EXCEPTIONNUMBER.getName()));
            if (MRPUtil.removeException(exp)) {
                this.exceptionMappings.add(mapping);
            } else {
                this.unVisitedMappings.add(mapping);
            }
            this.allMappings.put(require.getRowIdx(), mapping);
            Long date = (Long)require.getValue(DefaultField.RequireField.DATE.getName());
            if (!this.groupMappings.containsKey(date)) {
                group = new TreeMap<String, List<RSMapping>>();
                this.groupMappings.put(date, group);
            } else {
                group = this.groupMappings.get(date);
            }
            String supplyOrgId = String.valueOf(require.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()));
            if (!group.containsKey(supplyOrgId)) {
                mappings = new ArrayList<RSMapping>();
                group.put(supplyOrgId, mappings);
            } else {
                mappings = group.get(supplyOrgId);
            }
            mappings.add(mapping);
            require.update(DefaultField.RequireField.__SUPPLY_QTY__.getName(), (Object)srcVal);
        }
        mapping.mt = mt;
    }

    public void removeRsMapping(int requireIdx, RSMapping rsMapping) {
        this.allMappings.remove(requireIdx);
        this.removeForLast(rsMapping, this.unVisitedMappings);
        this.removeForLast(rsMapping, this.exceptionMappings);
    }

    private void removeForLast(RSMapping rsMapping, List<RSMapping> mappings) {
        int removeIdx = -1;
        for (int i = mappings.size() - 1; i >= 0; --i) {
            if (mappings.get(i) != rsMapping) continue;
            removeIdx = i;
            break;
        }
        if (removeIdx >= 0) {
            mappings.remove(removeIdx);
        }
    }

    public TreeMap<Long, Map<String, List<RSMapping>>> getGroupMappings() {
        return this.groupMappings;
    }

    public Iterator<RSMapping> getUnVisitedMappings(int startIdx, int endIdx) {
        return this.unVisitedMappings.subList(startIdx, endIdx).iterator();
    }

    public List<RSMapping> getUnVisitedMappings() {
        return this.unVisitedMappings;
    }

    public int getUnVisitedSize() {
        return this.unVisitedMappings.size();
    }

    public List<RSMapping> getMappings() {
        return this.mappings;
    }

    public Iterator<RSMapping> getMappings(int startIdx, int endIdx) {
        return this.mappings.subList(startIdx, endIdx).iterator();
    }

    public void finish() {
        this.mappings.addAll(this.unVisitedMappings);
        this.mappings.addAll(this.mergedMappings.values());
        this.mappings.addAll(this.splitMappings);
        this.mappings.addAll(this.exceptionMappings);
        this.unVisitedMappings = new ArrayList<RSMapping>(7);
        this.mergedMappings = new HashMap<String, RSMapping>(7);
        this.splitMappings = new ArrayList<RSMapping>(7);
        this.exceptionMappings = new ArrayList<RSMapping>(7);
    }

    public RSMapping getMappingByRequireRowIdx(int rowIdx) {
        return this.allMappings.get(rowIdx);
    }

    public List<RSMapping> getMergeMappings() {
        ArrayList<RSMapping> mappings = new ArrayList<RSMapping>();
        mappings.addAll(this.mergedMappings.values());
        mappings.addAll(this.splitMappings);
        return mappings;
    }

    public List<RSMapping> getExceptionMappings() {
        return this.exceptionMappings;
    }

    public void setExceptionMappings(List<RSMapping> exceptionMappings) {
        this.exceptionMappings = exceptionMappings;
    }

    public synchronized RSMapping cloneMapping(RSMapping mapping) {
        RSMapping newMapping = mapping.clone();
        newMapping.isCopied = false;
        mapping.isCopied = true;
        this.splitMappings.add(newMapping);
        return newMapping;
    }

    public void clear() {
        this.allMappings = new HashMap(7);
        this.groupMappings = new TreeMap();
        this.mappings = new ArrayList<RSMapping>(7);
    }

    public static enum MatchType {
        LESS,
        EQUAL,
        MORE;

    }

    public static class RSMapping
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = 1043465666790761083L;
        private RequireRowData require;
        private List<RowData> supplys;
        private MatchType mt;
        private RowData bom;
        private IntBitSet children = BitSetFactory.createIntBitSet();
        private int childrenSize = 0;
        private BigDecimal rQty;
        private boolean isCopied;
        private List<SimplePlanOrder> poList;
        private BigDecimal reducePoQty;
        private List<RequireRowData> cops;
        private boolean isGenPlanOrder = true;
        private boolean isClearRequire = false;
        private boolean isCreateDepentRequire = true;
        private BigDecimal virtualQty = null;
        private List<RSMapping> childMappings;
        private boolean isCalDetail = true;
        private BigDecimal beforeMergedQty;
        private boolean isExceptionData = false;
        private Integer matchHashCode;

        public BigDecimal getBeforeMergedQty() {
            return this.beforeMergedQty;
        }

        public void setBeforeMergedQty(BigDecimal beforeMergedQty) {
            this.beforeMergedQty = beforeMergedQty;
        }

        public boolean isCalDetail() {
            return this.isCalDetail;
        }

        public void setCalDetail(boolean calDetail) {
            this.isCalDetail = calDetail;
        }

        @Deprecated
        public List<RSMapping> getChildMappings() {
            return this.childMappings;
        }

        public void setChildMappings(List<RSMapping> childMappings) {
            this.childMappings = childMappings;
        }

        public boolean isGenPlanOrder() {
            return this.isGenPlanOrder;
        }

        public void setGenPlanOrder(boolean genPlanOrder) {
            this.isGenPlanOrder = genPlanOrder;
        }

        public boolean isCreateDepentRequire() {
            return this.isCreateDepentRequire;
        }

        public void setCreateDepentRequire(boolean createDepentRequire) {
            this.isCreateDepentRequire = createDepentRequire;
        }

        public boolean isClearRequire() {
            return this.isClearRequire;
        }

        public void setClearRequire(boolean clearRequire) {
            this.isClearRequire = clearRequire;
        }

        public List<RequireRowData> getCops() {
            return this.cops;
        }

        public void setCops(List<RequireRowData> cops) {
            this.cops = cops;
        }

        public RequireRowData getRequire() {
            return this.require;
        }

        public void setRequire(RequireRowData require) {
            this.require = require;
        }

        public List<RowData> getSupplys() {
            return this.supplys;
        }

        public void setSupplys(List<RowData> supplys) {
            this.supplys = supplys;
        }

        public MatchType getMt() {
            return this.mt;
        }

        public void setMt(MatchType mt) {
            this.mt = mt;
        }

        public RowData getBom() {
            return this.bom;
        }

        public void setBom(RowData bom) {
            this.bom = bom;
        }

        public Iterator<RequireRowData> getChildrenIterator() {
            final GridData.Grid all = this.require.datas.getDatas();
            final Iterator<Integer> iter = this.children.iterator();
            return new Iterator<RequireRowData>(){

                @Override
                public boolean hasNext() {
                    return iter.hasNext();
                }

                @Override
                public RequireRowData next() {
                    Integer idx = (Integer)iter.next();
                    return new RequireRowData(((RSMapping)this).require.datas, idx, ((RSMapping)this).require.columns, all.get(idx));
                }
            };
        }

        public int getChildrenSize() {
            return this.childrenSize;
        }

        public void addChild(RequireRowData child) {
            int pos = child.rowIdx;
            if (!this.children.get(pos)) {
                this.children.set(pos);
                ++this.childrenSize;
            }
        }

        public void setChildren(List<RequireRowData> children) {
            if (children == null) {
                this.childrenSize = 0;
                this.children = BitSetFactory.createIntBitSet();
            } else {
                for (RequireRowData next : children) {
                    this.addChild(next);
                }
            }
        }

        public void resetChildren(List<Integer> children) {
            this.childrenSize = 0;
            this.children = BitSetFactory.createIntBitSet();
            for (int pos : children) {
                if (this.children.get(pos)) continue;
                this.children.set(pos);
                ++this.childrenSize;
            }
        }

        public BigDecimal getrQty() {
            return this.rQty;
        }

        public BigDecimal getVirtualQty() {
            return this.virtualQty;
        }

        public void setrQty(BigDecimal rQty) {
            this.rQty = rQty;
        }

        public void setVirtualQty(BigDecimal virtualQty) {
            this.virtualQty = virtualQty;
        }

        public boolean isCopied() {
            return this.isCopied;
        }

        public void setCopied(boolean copied) {
            this.isCopied = copied;
        }

        @Deprecated
        public List<SimplePlanOrder> getPoList() {
            return this.poList;
        }

        public void addPo(SimplePlanOrder po) {
            if (this.poList == null) {
                this.poList = new LinkedList<SimplePlanOrder>();
            }
            this.poList.add(po);
        }

        public boolean isExceptionData() {
            return this.isExceptionData;
        }

        public void setExceptionData(boolean exceptionData) {
            this.isExceptionData = exceptionData;
        }

        public void reduce(IMRPEnvProvider runParam, BigDecimal subtrahend) {
            this.rQty = this.rQty.subtract(subtrahend);
            if (this.children != null) {
                Iterator<Integer> iter = this.children.iterator();
                while (iter.hasNext()) {
                    Integer idx = iter.next();
                    RequireRowData child = new RequireRowData(this.require.datas, idx, this.require.columns, this.require.datas.getDatas().get(idx));
                    BigDecimal val = MRPUtil.convert(child.getValue(DefaultField.CommonField.QTY.name()), BigDecimal.ZERO);
                    BigDecimal quota = MRPUtil.convert(child.getValue(DefaultField.RequireField.__REAL_QUATA__.name()), BigDecimal.ZERO);
                    val = val.subtract(MRPUtil.multiply(quota, subtrahend));
                    child.update(DefaultField.CommonField.QTY.name(), (Object)val);
                    RSMapping maping = runParam.calcBalanceDetails().getMappingByRequireRowIdx(child.getRowIdx());
                    if (maping == null) continue;
                    maping.reduce(runParam, val);
                }
            }
        }

        public RSMapping clone() {
            RSMapping info = null;
            try {
                info = (RSMapping)super.clone();
                info.require = info.require.clone();
                info.setVirtualQty(null);
                info.setCalDetail(true);
                info.children = info.children == null ? null : info.children.clone();
                info.poList = info.poList == null ? null : new LinkedList<SimplePlanOrder>(info.poList);
                info.childMappings = info.childMappings == null ? null : new LinkedList<RSMapping>(this.childMappings);
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("clone RSMapping failed", e);
            }
            return info;
        }

        public void setReducePoQty(BigDecimal reducePoQty) {
            this.reducePoQty = reducePoQty;
        }

        public BigDecimal getReducePoQty() {
            return this.reducePoQty == null ? this.rQty : this.reducePoQty;
        }

        public List<RowData> getReduceSupplys() {
            return this.supplys;
        }

        public void setMatchHashCode(Integer matchHashCode) {
            this.matchHashCode = matchHashCode;
        }

        public Integer getMatchHashCode() {
            return this.matchHashCode;
        }
    }
}

