/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.model.table;

import java.util.Iterator;
import java.util.List;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.mmc.mrp.model.table.GridData;
import kd.mmc.mrp.model.table.store.RandomAccessStore;

public class RandomAccessGrid
implements GridData.Grid {
    private RandomAccessStore<Object[]> store = RandomAccessStore.createInst();

    @Override
    public Iterator<Object[]> iterator() {
        return this.store.iterator();
    }

    @Override
    public int size() {
        return this.store.getRowCount();
    }

    @Override
    public void add(Object[] row) {
        this.store.write(row);
    }

    @Override
    public Object[] get(int idx) {
        return this.store.readLine(idx);
    }

    @Override
    public void addAll(List<Object[]> rows) {
        for (Object[] row : rows) {
            this.store.write(row);
        }
    }

    @Override
    public void clear() {
        try {
            this.store.close();
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("FAILED_TO_CLOSE_MRP_STORE", "FAILED_TO_CLOSE_MRP_STORE"), new Object[0]);
        }
        this.store = RandomAccessStore.createInst();
    }

    @Override
    public boolean isEmpty() {
        return this.store.getRowCount() == 0;
    }

    @Override
    public void update(int rowIdx, Object[] row) {
        this.store.update(rowIdx, row);
    }
}

