/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.model.table;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.dataentity.utils.StringUtils;
import kd.mmc.mrp.model.enums.ResType;
import kd.mmc.mrp.model.table.GridData;
import kd.mmc.mrp.model.table.MapWrapper;
import kd.sdk.mmc.mrp.framework.enums.SdkResType;
import kd.sdk.mmc.mrp.framework.res.IRowData;

public class RowData
implements Cloneable,
Serializable,
IRowData {
    private static final long serialVersionUID = 1L;
    protected transient GridData datas;
    protected ResType rowType;
    protected Map<String, Integer> columns;
    protected Object[] values;
    protected Integer rowIdx;

    public RowData(GridData datas, Map<String, Integer> columns, Object[] values, Integer rowIdx, ResType rowType) {
        this.datas = datas;
        this.columns = columns;
        this.values = values;
        this.rowIdx = rowIdx;
        this.rowType = rowType;
    }

    public RowData() {
    }

    public Integer getRowIdx() {
        return this.rowIdx;
    }

    public void setRowIdx(Integer rowIdx) {
        this.rowIdx = rowIdx;
    }

    public Object getValue(String col) {
        if (!this.columns.containsKey(col)) {
            return null;
        }
        return this.values[this.columns.get(col)];
    }

    public Object[] getValues() {
        return this.values;
    }

    public void update(String col, Object newVal) {
        Integer idx = this.columns.get(col);
        if (idx == null) {
            return;
        }
        this.values[idx.intValue()] = newVal;
    }

    public void update(Integer idx, Object newVal) {
        this.values[idx.intValue()] = newVal;
    }

    @Deprecated
    public Map<String, Object> toMap() {
        return new MapWrapper(this.columns, this.values);
    }

    public void updateAll(Object[] values) {
        this.values = values;
    }

    public RowData clone() {
        RowData clone = new RowData(this.datas, this.columns, (Object[])this.values.clone(), this.rowIdx, this.rowType);
        return clone;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.rowType).append(':');
        for (Map.Entry<String, Integer> entry : this.columns.entrySet()) {
            sb.append('[').append(entry.getKey()).append(" : ");
            sb.append(this.values[entry.getValue()]).append(']');
        }
        return sb.toString();
    }

    public Map<Integer, String> getIntToStrCols() {
        Map<Integer, String> collect = this.columns.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (a, b) -> a));
        return collect;
    }

    public Object get(String obj) {
        return this.getValue(obj);
    }

    public Object get(int idx) {
        return this.values[idx];
    }

    public String getString(int index) {
        Object v = this.get(index);
        if (v == null) {
            return null;
        }
        if (v instanceof String) {
            return (String)v;
        }
        return (String)DataType.convertValue((DataType)DataType.StringType, (Object)v);
    }

    public String getString(String field) {
        Object v = this.get(field);
        if (v == null) {
            return null;
        }
        if (v instanceof String) {
            return (String)v;
        }
        return (String)DataType.convertValue((DataType)DataType.StringType, (Object)v);
    }

    public Integer getInteger(int index) {
        Object v = this.get(index);
        if (v == null) {
            return null;
        }
        if (v instanceof Integer) {
            return (Integer)v;
        }
        return (Integer)DataType.convertValue((DataType)DataType.IntegerType, (Object)v);
    }

    public Integer getInteger(String field) {
        Object v = this.get(field);
        if (v == null) {
            return null;
        }
        if (v instanceof Integer) {
            return (Integer)v;
        }
        return (Integer)DataType.convertValue((DataType)DataType.IntegerType, (Object)v);
    }

    public Long getLong(int index) {
        Object v = this.get(index);
        if (v == null) {
            return null;
        }
        if (v instanceof Long) {
            return (Long)v;
        }
        return (Long)DataType.convertValue((DataType)DataType.LongType, (Object)v);
    }

    public Long getLong(String field) {
        Object v = this.get(field);
        if (v == null) {
            return null;
        }
        if (v instanceof Long) {
            return (Long)v;
        }
        if (v instanceof String && StringUtils.isEmpty((CharSequence)v.toString())) {
            return 0L;
        }
        return (Long)DataType.convertValue((DataType)DataType.LongType, (Object)v);
    }

    public Boolean getBoolean(int index) {
        Object v = this.get(index);
        if (v == null) {
            return null;
        }
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        return (Boolean)DataType.convertValue((DataType)DataType.BooleanType, (Object)v);
    }

    public Boolean getBoolean(String field) {
        Object v = this.get(field);
        if (v == null) {
            return null;
        }
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        return (Boolean)DataType.convertValue((DataType)DataType.BooleanType, (Object)v);
    }

    public BigDecimal getBigDecimal(int index) {
        Object v = this.get(index);
        if (v == null) {
            return null;
        }
        if (v instanceof BigDecimal) {
            return (BigDecimal)v;
        }
        return (BigDecimal)DataType.convertValue((DataType)DataType.BigDecimalType, (Object)v);
    }

    public BigDecimal getBigDecimal(String field) {
        Object v = this.get(field);
        if (v == null) {
            return null;
        }
        if (v instanceof BigDecimal) {
            return (BigDecimal)v;
        }
        return (BigDecimal)DataType.convertValue((DataType)DataType.BigDecimalType, (Object)v);
    }

    public Double getDouble(int index) {
        Object v = this.get(index);
        if (v == null) {
            return null;
        }
        if (v instanceof Double) {
            return (Double)v;
        }
        return (Double)DataType.convertValue((DataType)DataType.DoubleType, (Object)v);
    }

    public Double getDouble(String field) {
        Object v = this.get(field);
        if (v == null) {
            return null;
        }
        if (v instanceof Double) {
            return (Double)v;
        }
        return (Double)DataType.convertValue((DataType)DataType.DoubleType, (Object)v);
    }

    public Date getDate(int index) {
        Object v = this.get(index);
        if (v == null) {
            return null;
        }
        if (v instanceof Date) {
            return (Date)v;
        }
        return (Date)DataType.convertValue((DataType)DataType.DateType, (Object)v);
    }

    public Date getDate(String field) {
        Object v = this.get(field);
        if (v == null) {
            return null;
        }
        if (v instanceof Date) {
            return (Date)v;
        }
        if (v instanceof Long) {
            return new Date((Long)v);
        }
        return (Date)DataType.convertValue((DataType)DataType.DateType, (Object)v);
    }

    public Timestamp getTimestamp(int index) {
        Object v = this.get(index);
        if (v == null) {
            return null;
        }
        if (v instanceof Timestamp) {
            return (Timestamp)v;
        }
        return (Timestamp)DataType.convertValue((DataType)DataType.TimestampType, (Object)v);
    }

    public Timestamp getTimestamp(String field) {
        Object v = this.get(field);
        if (v == null) {
            return null;
        }
        if (v instanceof Timestamp) {
            return (Timestamp)v;
        }
        return (Timestamp)DataType.convertValue((DataType)DataType.TimestampType, (Object)v);
    }

    public SdkResType getSdkResType() {
        return this.rowType.getSdkResType();
    }

    public ResType getRowType() {
        return this.rowType;
    }
}

