/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.model.table.res;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.common.enums.CopTypeEnum;
import kd.mmc.mrp.common.util.DynamicObjDataUtil;
import kd.mmc.mrp.common.util.MRPORGUtil;
import kd.mmc.mrp.exception.MRPBizException;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.cache.MRPRedisStore;
import kd.mmc.mrp.framework.consts.Errors;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.framework.fomula.ExprContext;
import kd.mmc.mrp.integrate.entity.BomDataModel;
import kd.mmc.mrp.integrate.entity.CacheDatas;
import kd.mmc.mrp.integrate.entity.MtPlanInfoModel;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.integrate.entity.RequireDataModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.enums.ResType;
import kd.mmc.mrp.model.enums.replace.ReplaceStrategy;
import kd.mmc.mrp.model.struct.ReplaceMaterialStruct;
import kd.mmc.mrp.model.struct.ReplaceStruct;
import kd.mmc.mrp.model.table.ColumnDatas;
import kd.mmc.mrp.model.table.GridData;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.table.res.AbstractResModelDataTable;
import kd.mmc.mrp.model.table.res.TNode;
import kd.mmc.mrp.mservice.GenOrderBomService;
import kd.mmc.mrp.utils.MRPUtil;

public class BOMStructDataTable
extends AbstractResModelDataTable
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<Long, Set<Long>> shareCache = new HashMap<Long, Set<Long>>();
    private Map<String, Map<Long, Set<Long>>> ctrlStrategyCache = new HashMap<String, Map<Long, Set<Long>>>(2);
    private Set<Long> requireOrgs;
    private Set<String> llcMetricsCols;
    private List<Set<String>> llc = new ArrayList<Set<String>>();
    private Set<String> requireMaterials = new HashSet<String>();
    private Map<String, Set<String>> mergeGroups = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> origMergeGroups = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> dependMergeGroups = new HashMap<String, Set<String>>();
    private Set<String> sended = new HashSet<String>();
    private HashMap<String, ReplaceStruct> mainMaterialGroup = new HashMap(0);
    private MRPORGUtil orgUtil = new MRPORGUtil();
    private GridData superBomDatas;
    private Map<Long, Integer> entryId2SuperBom = new HashMap<Long, Integer>();
    private final Set<String> alreadyDynamicRestoreBOMMaterial = new HashSet<String>(16);
    private HashMap<Integer, Map<String, Object>> tinyRowUpdates = new HashMap();
    private MRPRedisStore cache;

    public GridData getSuperBomDatas() {
        return this.superBomDatas;
    }

    @Override
    public String getLogo(Object[] row) {
        String name;
        MtPlanInfoModel planInfoModel = (MtPlanInfoModel)this.runParam.getService(MtPlanInfoModel.class);
        Object value = row[this.getColIdx().get(DefaultField.BOMField.BOMNUMBER.getName())];
        Object seq = row[this.getColIdx().get(DefaultField.BOMField.BOMENTRYSEQ.getName())];
        Object material = row[this.getColIdx().get(DefaultField.BOMField.CHILDMATERIAL.getName())];
        String string = value == null ? null : (name = String.format(ResManager.loadKDString((String)"BOM\u7f16\u7801(%1$s)-\u5206\u5f55\u884c\u53f7(%2$s)-", (String)"BOMStructDataTable_5", (String)"mmc-mrp-mservice", (Object[])new Object[0]), value.toString(), seq == null ? Integer.valueOf(0) : seq));
        if (name == null) {
            value = row[this.getColIdx().get(DefaultField.BOMField.BOMID.getName())];
            String string2 = name = value == null ? null : String.format("BOMID(%s)-", value.toString());
        }
        if (material != null) {
            String[] mData = planInfoModel.getMaterialDataById(String.valueOf(material));
            String number = mData[0];
            name = name + String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u7f16\u7801(%s)-", (String)"BOMStructDataTable_6", (String)"mmc-mrp-mservice", (Object[])new Object[0]), number);
        }
        return name;
    }

    @Override
    public String getAlias4Name(String name) {
        String alias = DefaultField.BOMField.getAlias4Name(name);
        if (alias == null) {
            alias = name;
        }
        return alias;
    }

    @Deprecated
    public BOMStructDataTable() {
        this.superBomDatas = new GridData("MEM-ONLY");
        this.index.put(DefaultField.CommonField.MATERIAL.name(), new ColumnDatas());
        this.index.put(DefaultField.BOMField.__METRICS_KEY__.name(), new ColumnDatas());
    }

    public BOMStructDataTable(CalEnv runParam, Set<String> indexCols, Set<String> llcMetricsCols) {
        super(runParam, indexCols);
        this.index.put(DefaultField.BOMField.PARENT.name(), new ColumnDatas());
        this.index.put(DefaultField.BOMField.__METRICS_KEY__.name(), new ColumnDatas());
        this.llcMetricsCols = llcMetricsCols;
        this.cache = MRPCacheManager.getDStore(runParam.getMRPContextId());
        boolean isEnable = (Boolean)runParam.getCfgValue(EnvCfgItem.ENABLE_BOM_COMPRESS_STORAGE);
        if (isEnable) {
            this.srcDatas = new GridData("MEM-COMPRESS", (IMRPEnvProvider)runParam);
            this.superBomDatas = new GridData("MEM-COMPRESS", (IMRPEnvProvider)runParam);
        } else {
            this.superBomDatas = new GridData((IMRPEnvProvider)runParam);
        }
    }

    public void setLLCMetrics(Set<String> llcMetricsCols) {
        this.llcMetricsCols = llcMetricsCols;
    }

    public Set<String> getLLCMetrics() {
        return this.llcMetricsCols;
    }

    public Set<String> getRequireMaterials() {
        return this.requireMaterials;
    }

    public void setRequireMaterials(Set<String> requireMaterials) {
        this.requireMaterials = requireMaterials;
    }

    public void restoreDatas(List<Object[]> datas) {
        this.restoreDatas(datas.iterator());
    }

    public void restoreDatas(Iterator<Object[]> datas) {
        boolean isDynamicBOM = (Boolean)this.runParam.getCfgValue(EnvCfgItem.DYNAMIC_BOM_RESTORE);
        int j = this.srcDatas.getDatas().size() - 1;
        while (datas.hasNext()) {
            ++j;
            Object[] row = datas.next();
            this.srcDatas.getDatas().add(row);
            Object[] expandRow = row;
            boolean isZipRow = this.isZipRow(row);
            if (isZipRow) {
                if (isDynamicBOM) {
                    int idx = this.getZipRowColIdx(DefaultField.BOMField.ENTRYID.getName());
                    row[0] = this.getCol(DefaultField.BOMField.ENTRYID.getName()).getFirstNoCheck(row[idx]);
                }
                expandRow = this.fetchRow(j).getValues();
            }
            for (Map.Entry entry : this.index.entrySet()) {
                Integer idx = (Integer)this.colIdx.get(entry.getKey());
                if (idx == null) continue;
                ((ColumnDatas)this.index.get(entry.getKey())).put((Comparable)expandRow[idx], j);
            }
            if (isZipRow) continue;
            this.refreshShareSettings(expandRow);
        }
        this.batchRefreshShareSettings();
    }

    public boolean isUsableBom(Long bomFid, Long orgId) {
        Set<Long> value = this.shareCache.get(bomFid);
        return value != null && value.contains(orgId);
    }

    public Map<Long, Set<Long>> getShareCache() {
        return this.shareCache;
    }

    public void setShareCache(Map<Long, Set<Long>> shareCache) {
        this.shareCache = shareCache;
    }

    @Override
    public void applyColValues(Map<Integer, Map<String, Object>> colVals) {
        for (int i = 0; i < this.size(); ++i) {
            Object[] row;
            Map<String, Object> ext = colVals.get(i);
            if (ext == null || this.isZipRow(row = this.srcDatas.getDatas().get(i))) continue;
            for (Map.Entry<String, Object> entry : ext.entrySet()) {
                Object oldVal;
                Integer col = (Integer)this.colIdx.get(entry.getKey());
                if (col == null) continue;
                ColumnDatas cd = (ColumnDatas)this.index.get(String.valueOf(col));
                Object attr = ext.get(entry.getKey());
                if (col == null || (oldVal = row[col]) != null && (!(oldVal instanceof Number) || ((Number)oldVal).intValue() != 0)) continue;
                if (attr != null) {
                    row[col.intValue()] = attr;
                }
                if (cd == null) continue;
                cd.put((Comparable)attr, i);
            }
        }
    }

    @Override
    protected void afterFillRow(Object[] row, String modelId, String resDataName, String resDataId) {
        String purpose;
        if (resDataId != null) {
            row[this.getColIdx().get((Object)DefaultField.CommonField.__MODEL_ID__.name()).intValue()] = resDataId;
        }
        if (resDataName != null) {
            row[this.getColIdx().get((Object)DefaultField.CommonField.__MODEL_NUMBER__.name()).intValue()] = resDataName;
        }
        row[this.getColIdx().get((Object)DefaultField.BOMField.__METRICS_KEY__.name()).intValue()] = this.getMetricsKey(row);
        if (modelId != null) {
            row[this.getColIdx().get((Object)DefaultField.BOMField.__BILL_ENTITY__.name()).intValue()] = modelId;
        }
        row[this.getColIdx().get((Object)DefaultField.BOMField.CHILDQTY.getName()).intValue()] = MRPUtil.toBigDecimal(row[this.getColIdx().get(DefaultField.BOMField.CHILDQTY.getName())]);
        row[this.getColIdx().get((Object)DefaultField.BOMField.CHILDNUMERATOR.getName()).intValue()] = MRPUtil.toBigDecimal(row[this.getColIdx().get(DefaultField.BOMField.CHILDNUMERATOR.getName())]);
        row[this.getColIdx().get((Object)DefaultField.BOMField.CHILDDENOMINATOR.getName()).intValue()] = MRPUtil.toBigDecimal(row[this.getColIdx().get(DefaultField.BOMField.CHILDDENOMINATOR.getName())]);
        row[this.getColIdx().get((Object)DefaultField.BOMField.CHILDFIXEDSCRAP.getName()).intValue()] = MRPUtil.toBigDecimal(row[this.getColIdx().get(DefaultField.BOMField.CHILDFIXEDSCRAP.getName())]);
        row[this.getColIdx().get((Object)DefaultField.BOMField.CHILDSCRAPRATE.getName()).intValue()] = MRPUtil.toBigDecimal(row[this.getColIdx().get(DefaultField.BOMField.CHILDSCRAPRATE.getName())]);
        if (row[this.getColIdx().get(DefaultField.BOMField.CONFIGUREDCODE.getName())] == null) {
            row[this.getColIdx().get((Object)DefaultField.BOMField.CONFIGUREDCODE.getName()).intValue()] = 0L;
        }
        if (row[this.getColIdx().get(DefaultField.BOMField.CHILDPRODUCEDELAYTIME.getName())] == null) {
            row[this.getColIdx().get((Object)DefaultField.BOMField.CHILDPRODUCEDELAYTIME.getName()).intValue()] = 0;
        }
        if ("B".equals(purpose = String.valueOf(row[this.getColIdx().get(DefaultField.BOMField.PURPOSE.getName())]))) {
            row[this.getColIdx().get((Object)DefaultField.BOMField.ISSUPERBOM.getName()).intValue()] = true;
        }
    }

    private String getMetricsKey(Object[] row) {
        StringBuilder keyBuf = new StringBuilder();
        for (String col : this.llcMetricsCols) {
            keyBuf.append(String.valueOf(row[this.getColIdx().get(col)]));
        }
        return keyBuf.toString();
    }

    public void genOrderBomByConfig() {
        HashMap<Long, Set<Long>> org2configs = new HashMap<Long, Set<Long>>(8);
        Map<String, String> valMap = MRPCacheManager.getInst().getSubDataMap(this.runParam, MRPRuntimeConsts.getRequireConfigKey(this.runParam.getMRPContextId()));
        if (valMap != null) {
            for (Map.Entry<String, String> entry : valMap.entrySet()) {
                for (String string : JSON.parseArray((String)entry.getValue(), String.class)) {
                    String[] str = string.split("-");
                    Set configs = org2configs.computeIfAbsent(Long.parseLong(str[1]), k -> new HashSet(16));
                    configs.add(Long.parseLong(str[0]));
                }
            }
        }
        HashSet<Long> entryId2Use = new HashSet<Long>(this.entryId2SuperBom.size());
        boolean mrp_consider_pro_version_to_bom = MRPUtil.convert(this.runParam.getCfgValue(EnvCfgItem.MRP_CONSIDER_PRO_VERSION_TO_BOM), Boolean.FALSE);
        if (!mrp_consider_pro_version_to_bom) {
            GenOrderBomService.genOrderBomByConfigCode((IMRPEnvProvider)this.runParam, org2configs, this.superBomDatas.getDatas(), this.entryId2SuperBom, entryId2Use, this, this.colIdx);
        }
        for (Map.Entry entry : this.entryId2SuperBom.entrySet()) {
            if (entryId2Use.contains(entry.getKey())) continue;
            Object[] bomData = this.superBomDatas.getDatas().get((Integer)entry.getValue());
            this.fill(bomData);
        }
        this.superBomDatas.getDatas().clear();
        this.superBomDatas = null;
        this.entryId2SuperBom.clear();
        this.entryId2SuperBom = null;
    }

    public void initDependentReqStruct(IMRPEnvProvider ctx) {
        RequireDataModel requireDataModel = (RequireDataModel)ctx.getService(RequireDataModel.class);
        Set<String> billNos = requireDataModel.getMaterialFlexNos();
        if (billNos == null || billNos.isEmpty()) {
            return;
        }
        this.origMergeGroups = new HashMap<String, Set<String>>(this.mergeGroups);
        QFilter qFilter = new QFilter("number", "in", billNos);
        HashSet<Long> idSet = new HashSet<Long>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)BOMStructDataTable.class.getName(), (String)"msplan_flexmetricdefine", (String)"id,sourceentity,targetentity", (QFilter[])new QFilter[]{qFilter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String sourceentity = row.getString("sourceentity");
                String targetentity = row.getString("targetentity");
                if (!"bd_material".equals(sourceentity) || !"bd_material".equals(targetentity)) continue;
                idSet.add(row.getLong("id"));
            }
        }
        if (!idSet.isEmpty()) {
            DynamicObject[] dynamicObjects;
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"msplan_flexmetricdefine");
            for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((Object[])idSet.toArray(new Long[0]), (DynamicObjectType)mainEntityType)) {
                DynamicObjectCollection materialColl = dynamicObject.getDynamicObjectCollection("entryentity");
                for (DynamicObject material : materialColl) {
                    if (material.getLong("source_bd_id") == 0L) continue;
                    Long materialId = material.getLong("source_bd_id");
                    HashSet<String> currentReplaceId = new HashSet<String>(materialColl.size());
                    currentReplaceId.add(materialId.toString());
                    DynamicObjectCollection replaceColl = material.getDynamicObjectCollection("subentryentity");
                    for (DynamicObject replace : replaceColl) {
                        if (replace.getLong("target_bd_id") == 0L) continue;
                        Long replaceId = replace.getLong("target_bd_id");
                        currentReplaceId.add(replaceId.toString());
                    }
                    for (String replaceMid : currentReplaceId) {
                        this.mergeGroup(this.mergeGroups, replaceMid, currentReplaceId);
                        this.mergeGroup(this.dependMergeGroups, replaceMid, currentReplaceId);
                    }
                }
            }
        }
    }

    private void mergeGroup(Map<String, Set<String>> mergeGroups, String replaceMid, Set<String> currentReplaceId) {
        if (mergeGroups.get(replaceMid) == null) {
            mergeGroups.put(replaceMid, currentReplaceId);
        } else {
            HashSet<String> mSets = new HashSet<String>(currentReplaceId);
            mSets.addAll((Collection<String>)mergeGroups.get(replaceMid));
            mergeGroups.put(replaceMid, mSets);
        }
    }

    public void refreshLLC(boolean isRefreshReplaceGroup, Collection<String> selectMids) {
        String cacheValue;
        ColumnDatas keyCol = this.getCol(DefaultField.BOMField.__METRICS_KEY__.name());
        HashMap<String, TNode> nodes = new HashMap<String, TNode>();
        HashMap<String, Set> mGroups = new HashMap<String, Set>();
        ArrayList<Set> groups = new ArrayList<Set>(10);
        if (isRefreshReplaceGroup) {
            Iterator<Comparable<Object>> iter = keyCol.iterator();
            while (iter.hasNext()) {
                String key = (String)((Object)iter.next());
                for (Integer rowIdx : keyCol.get(key)) {
                    String cId = String.valueOf(this.getValue(DefaultField.BOMField.CHILDMATERIAL.getName(), rowIdx));
                    Long replaceId = MRPUtil.convert(this.getValue(DefaultField.BOMField.REPLACEPLAN.getName(), rowIdx), 0L);
                    if (replaceId == null || replaceId <= 0L) continue;
                    Set set = mGroups.computeIfAbsent(String.valueOf(replaceId), k -> new HashSet(5));
                    set.add(cId);
                }
            }
            for (Set group : mGroups.values()) {
                if (groups.isEmpty()) {
                    groups.add(group);
                    continue;
                }
                HashSet merge = new HashSet(group);
                ArrayList<Object> copyGroups = new ArrayList<Object>(10);
                for (int i = 0; i < groups.size(); ++i) {
                    Set old = (Set)groups.get(i);
                    boolean bl = false;
                    for (String string : group) {
                        if (!old.contains(string)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) {
                        merge.addAll(old);
                        continue;
                    }
                    copyGroups.add(old);
                }
                if (copyGroups.size() != groups.size()) {
                    copyGroups.add(merge);
                    groups = copyGroups;
                    continue;
                }
                groups.add(group);
            }
            for (Set group : groups) {
                for (String mId : group) {
                    this.mergeGroups.put(mId, group);
                }
            }
        }
        CacheDatas cacheDatas = (CacheDatas)this.runParam.getService(CacheDatas.class);
        ArrayList<Integer> copLists = new ArrayList<Integer>(16);
        Iterator<Comparable<Object>> iter = keyCol.iterator();
        while (iter.hasNext()) {
            String key = (String)((Object)iter.next());
            for (Integer rowIdx : keyCol.get(key)) {
                Object cId;
                String string = String.valueOf(this.getValue(DefaultField.BOMField.MATERIAL.getName(), rowIdx));
                if (string.equals(cId = String.valueOf(this.getValue(DefaultField.BOMField.CHILDMATERIAL.getName(), rowIdx)))) continue;
                if (this.isCoproduct(rowIdx)) {
                    copLists.add(rowIdx);
                    continue;
                }
                if (DynamicObjDataUtil.isNullStringOr0Long((String)cId)) {
                    Long l = MRPUtil.convert(this.getValue(DefaultField.BOMField.FEATURETYPE.getName(), rowIdx), 0L);
                    if (l <= 0L) continue;
                    Set<Long> childs = cacheDatas.getChildByFeatureType(l);
                    for (Long cid : childs) {
                        if (string.equals(cid.toString())) continue;
                        this.buildStruct(nodes, string, cid.toString(), rowIdx);
                    }
                    continue;
                }
                this.buildStruct(nodes, string, (String)cId, rowIdx);
            }
        }
        for (Integer rowIdx : copLists) {
            String pId2 = String.valueOf(this.getValue(DefaultField.BOMField.MATERIAL.getName(), rowIdx));
            String cId = String.valueOf(this.getValue(DefaultField.BOMField.CHILDMATERIAL.getName(), rowIdx));
            this.buildStruct(nodes, pId2, cId, rowIdx);
        }
        if (cacheDatas.isSelectBillPlan() && (cacheValue = MRPCacheManager.getInst().getData(this.runParam, MRPRuntimeConsts.getDependRequireLLCRelationKey(this.runParam.getMRPContextId()))) != null) {
            Map p2childs = (Map)JSON.parseObject((String)cacheValue, (TypeReference)new TypeReference<Map<String, Set<String>>>(){}, (Feature[])new Feature[0]);
            for (Map.Entry entry : p2childs.entrySet()) {
                String string = (String)entry.getKey();
                for (String string2 : (Set)entry.getValue()) {
                    this.buildStruct(nodes, string, string2, 0, false);
                }
            }
        }
        HashSet<String> check = new HashSet<String>(16);
        ArrayList<TNode> cycleChecker = new ArrayList<TNode>();
        for (Set group : groups) {
            check.clear();
            for (String m1 : group) {
                for (String m2 : group) {
                    if (StringUtils.equals((CharSequence)m1, (CharSequence)m2)) continue;
                    TNode tNode = nodes.get(m1);
                    TNode n2 = nodes.get(m2);
                    if (tNode == null || n2 == null) continue;
                    String key1 = String.format("%s\u0001\u0001\u0001%s", m1, m2);
                    String key2 = String.format("%s\u0001\u0001\u0001%s", m2, m1);
                    if (check.contains(key1) || check.contains(key2)) continue;
                    if (TNode.isAncestor(tNode, n2, cycleChecker)) {
                        cycleChecker.add(tNode);
                        String msg = this.appendReplaceErrorMsg(cycleChecker, group, m2);
                        throw new MRPBizException(Errors.getMaterialReplaceError(), msg);
                    }
                    if (TNode.isAncestor(n2, tNode, cycleChecker)) {
                        cycleChecker.add(n2);
                        String msg = this.appendReplaceErrorMsg(cycleChecker, group, m1);
                        throw new MRPBizException(Errors.getMaterialReplaceError(), msg);
                    }
                    check.add(key1);
                    check.add(key2);
                }
            }
        }
        Set[] bitmap = new Set[1000];
        if (selectMids != null && !selectMids.isEmpty()) {
            for (String string : selectMids) {
                this.addLlcByMid(nodes, bitmap, string);
            }
        } else {
            for (Map.Entry entry : nodes.entrySet()) {
                this.addLlc((TNode)entry.getValue(), bitmap, (String)entry.getKey());
            }
        }
        this.llc = new ArrayList<Set<String>>();
        for (Iterator<Object> iterator : bitmap) {
            if (iterator == null) continue;
            this.llc.add((Set<String>)((Object)iterator));
        }
    }

    private boolean isCoproduct(Integer rowIdx) {
        CopTypeEnum copTypeEnum = CopTypeEnum.fromValue((String)String.valueOf(this.getValue(DefaultField.BOMField.COPTYPE.getName(), rowIdx)));
        return copTypeEnum != null;
    }

    private void addLlc(TNode node, Set<String>[] bitmap, String mid) {
        int level = node.getLevel();
        if (level > 999) {
            throw new MRPBizException(Errors.getOverflowMaxLlc());
        }
        Set<String> ids = bitmap[level];
        if (ids == null) {
            bitmap[level] = ids = new HashSet<String>();
        }
        ids.add(mid);
    }

    private void addLlcByMid(HashMap<String, TNode> nodes, Set<String>[] bitmap, String mid) {
        TNode node = nodes.get(mid);
        if (node == null) {
            return;
        }
        this.addLlc(node, bitmap, mid);
        for (TNode child : node.getChildren()) {
            this.addLlcByMid(nodes, bitmap, child.toString());
        }
    }

    public String appendReplaceErrorMsg(List<TNode> cycleChecker, Set<String> group, String cId) {
        ArrayList<String> mIds = new ArrayList<String>(cycleChecker.size());
        for (TNode n : cycleChecker) {
            mIds.add(n.toString());
        }
        return String.format("%s\r\n%s", this.appendMaterialMsg(new ArrayList<String>(group)), this.appendErrorMsg(cId, -1, mIds));
    }

    public String appendMaterialMsg(List<String> mids) {
        int one = 1;
        int zero = 0;
        MtPlanInfoModel planInfoModel = (MtPlanInfoModel)this.runParam.getService(MtPlanInfoModel.class);
        StringBuilder error = new StringBuilder();
        for (String id : mids) {
            if (error.length() > 0) {
                error.append(" -> ");
            }
            String[] pm = planInfoModel.getMaterialDataById(id);
            error.append(ResManager.loadKDString((String)"\u7269\u6599\uff1a", (String)"BOMStructDataTable_7", (String)"mmc-mrp-mservice", (Object[])new Object[0])).append(pm[one]).append('\uff08').append(pm[zero]).append('\uff09');
        }
        return error.toString();
    }

    public String appendErrorMsg(String cId, int rowIdx, List<String> mIds) {
        CacheDatas cacheDatas = (CacheDatas)this.runParam.getService(CacheDatas.class);
        int one = 1;
        int zero = 0;
        StringBuilder error = new StringBuilder();
        String p = cId;
        for (String c : mIds) {
            List<Integer> rows = this.getCol(DefaultField.BOMField.MATERIAL.getName()).get(new BigDecimal(p));
            ColumnDatas col = this.getCol(DefaultField.BOMField.CHILDMATERIAL.getName());
            col.setFilter(MRPUtil.array2Set(rows));
            rows = col.get(new BigDecimal(c));
            error.append("\uff08");
            for (Integer idx : rows) {
                String[] org = cacheDatas.getOrgById(String.valueOf(this.getValue(DefaultField.BOMField.PRODUCTORGUNIT.getName(), idx)));
                String msg = String.format(ResManager.loadKDString((String)"\u3010BOM\u7f16\u7801\uff1a%1$s\uff0c\u7ec4\u7ec7\uff1a%2$s\uff08%3$s\uff09\u3011", (String)"BOMStructDataTable_8", (String)"mmc-mrp-mservice", (Object[])new Object[0]), this.getValue(DefaultField.BOMField.BOMNUMBER.getName(), idx), org[one], org[zero]);
                error.append(msg).append('\uff0c');
            }
            error.deleteCharAt(error.length() - 1);
            error.append("\uff09-> ");
            p = c;
        }
        if (rowIdx >= 0) {
            error.append("\uff08");
            String[] org = cacheDatas.getOrgById(String.valueOf(this.getValue(DefaultField.BOMField.PRODUCTORGUNIT.getName(), rowIdx)));
            String msg = String.format(ResManager.loadKDString((String)"\u3010BOM\u7f16\u7801\uff1a%1$s\uff0c\u7ec4\u7ec7\uff1a%2$s\uff08%3$s\uff09\u3011", (String)"BOMStructDataTable_4", (String)"mmc-mrp-mservice", (Object[])new Object[0]), this.getValue(DefaultField.BOMField.BOMNUMBER.getName(), rowIdx), org[one], org[zero]);
            error.append(msg);
            error.append("\uff09");
        } else {
            error.setLength(error.length() - 3);
        }
        return error.toString();
    }

    private void buildStruct(HashMap<String, TNode> nodes, String pId, String cId, int rowIdx) {
        this.buildStruct(nodes, pId, cId, rowIdx, true);
    }

    private void buildStruct(HashMap<String, TNode> nodes, String pId, String cId, int rowIdx, boolean throwException) {
        TNode cn;
        TNode pn;
        ArrayList<TNode> cycleChecker = new ArrayList<TNode>();
        if (nodes.containsKey(pId)) {
            pn = nodes.get(pId);
            if (nodes.containsKey(cId)) {
                cn = nodes.get(cId);
                int cLevel = cn.getLevel();
                int pLevel = pn.getLevel();
                if (pLevel > cLevel && TNode.isAncestor(pn, cn, cycleChecker)) {
                    if (!throwException || this.isCoproduct(rowIdx)) {
                        return;
                    }
                    ArrayList<String> mIds = new ArrayList<String>(cycleChecker.size());
                    for (TNode n : cycleChecker) {
                        mIds.add(n.toString());
                    }
                    ArrayList<String> all = new ArrayList<String>(2);
                    all.add(pId);
                    all.add(cId);
                    String msg = String.format("%s\r\n%s", this.appendMaterialMsg(all), this.appendErrorMsg(cId, rowIdx, mIds));
                    throw new MRPBizException(Errors.getBomCycleError(), msg);
                }
            } else {
                cn = new TNode(cId);
            }
        } else {
            pn = new TNode(pId);
            cn = nodes.containsKey(cId) ? nodes.get(cId) : new TNode(cId);
        }
        pn.addChild(cn);
        nodes.put(cId, cn);
        nodes.put(pId, pn);
    }

    private boolean isReplaceM(Integer index) {
        return MRPUtil.convert(this.getValue(DefaultField.BOMField.ISREPLACE.getName(), index), Boolean.FALSE);
    }

    private boolean isMainReplaceM(Integer index) {
        return MRPUtil.convert(this.getValue(DefaultField.BOMField.ISREPLACEPLANMM.getName(), index), Boolean.FALSE);
    }

    public void initReplaceInfo(boolean isFlexPropMatch) {
        PlanModel planModel = (PlanModel)this.runParam.getService(PlanModel.class);
        if (!planModel.isReplace()) {
            return;
        }
        HashMap<String, List> idxs = new HashMap<String, List>();
        HashMap<String, Integer> mainIdxs = new HashMap<String, Integer>();
        for (int i = 0; i < this.getSrcDatas().getDatas().size(); ++i) {
            String replacePlan = String.valueOf(this.getValue(DefaultField.BOMField.REPLACEPLAN.getName(), i));
            String bomId = String.valueOf(this.getValue(DefaultField.BOMField.__SUPER_BOMID__.getName(), i));
            if (DynamicObjDataUtil.isNullStringOr0Long((String)bomId)) {
                bomId = String.valueOf(this.getValue(DefaultField.BOMField.BOMID.getName(), i));
            }
            String priority = String.valueOf(this.getValue(DefaultField.BOMField.REPLACEPRIORITY.getName(), i));
            if (replacePlan.equals("null") || replacePlan.equals("0") || bomId.equals("null") || bomId.equals("0") || priority.equals("null")) continue;
            String replacestra = String.valueOf(this.getValue(DefaultField.BOMField.REPLACESTRA.getName(), i));
            if (ReplaceStrategy.MANUAL.getValue().equals(replacestra)) continue;
            String key = MRPRuntimeConsts.getGroupKey(new String[]{bomId, replacePlan, priority});
            List list = idxs.getOrDefault(key, new ArrayList(1));
            String mainM = String.valueOf(this.getValue(DefaultField.BOMField.CHILDMATERIAL.getName(), i));
            StringBuilder materialFlex = new StringBuilder(mainM);
            if (isFlexPropMatch) {
                materialFlex.append('\u0001').append(MRPUtil.convert(this.getValue(DefaultField.BOMField.ENTRYMATERIALFLEXPROP.getName(), i), 0L));
            }
            if (this.isMainReplaceM(i)) {
                mainIdxs.put(key, i);
            } else {
                list.add(materialFlex.toString());
            }
            idxs.put(key, list);
        }
        for (Map.Entry entry : idxs.entrySet()) {
            String[] split = MRPRuntimeConsts.splitDataKey((String)entry.getKey());
            List value = (List)entry.getValue();
            Integer mainIdx = (Integer)mainIdxs.get(entry.getKey());
            if (mainIdx == null) continue;
            String mainM = String.valueOf(this.getValue(DefaultField.BOMField.CHILDMATERIAL.getName(), mainIdx));
            Long mainAuxproperty = 0L;
            if (this.getValue(DefaultField.BOMField.ENTRYMATERIALFLEXPROP.getName(), mainIdx) != null) {
                mainAuxproperty = MRPUtil.convert(this.getValue(DefaultField.BOMField.ENTRYMATERIALFLEXPROP.getName(), mainIdx), 0L);
            }
            ReplaceStruct replaceStruct = this.mainMaterialGroup.getOrDefault(MRPRuntimeConsts.getReplaceKey(split[0], split[1]), new ReplaceStruct());
            this.mainMaterialGroup.put(MRPRuntimeConsts.getReplaceKey(split[0], split[1]), replaceStruct);
            replaceStruct.setReplaceMethod(String.valueOf(this.getValue(DefaultField.BOMField.REPLACEMETHOD.getName(), mainIdx)));
            replaceStruct.setReplaceStra(String.valueOf(this.getValue(DefaultField.BOMField.REPLACESTRA.getName(), mainIdx)));
            ReplaceMaterialStruct mainStruct = new ReplaceMaterialStruct();
            mainStruct.setMaterial(mainM);
            mainStruct.setMaterialAuxproperty(mainAuxproperty);
            String priority = String.valueOf(this.getValue(DefaultField.BOMField.REPLACEPRIORITY.getName(), mainIdx));
            if (!"null".equals(priority)) {
                mainStruct.setPriority(Integer.valueOf(priority));
            }
            mainStruct.setRepMaterials(this.listToMap(value));
            if (!this.isReplaceM(mainIdx)) {
                replaceStruct.setMainReplaceM(mainStruct);
                continue;
            }
            List<ReplaceMaterialStruct> repList = replaceStruct.getReplaceMs();
            if (repList == null) {
                repList = new ArrayList<ReplaceMaterialStruct>();
            }
            repList.add(mainStruct);
            replaceStruct.setReplaceMs(repList);
        }
    }

    private HashMap<String, RequireRowData> listToMap(List<String> value) {
        HashMap<String, RequireRowData> rowDataHashMap = new HashMap<String, RequireRowData>();
        if (value == null) {
            return rowDataHashMap;
        }
        for (String key : value) {
            rowDataHashMap.put(key, null);
        }
        return rowDataHashMap;
    }

    public HashMap<String, ReplaceStruct> getMainMaterialGroup() {
        return this.mainMaterialGroup;
    }

    public void setMainMaterialGroup(HashMap<String, ReplaceStruct> mainMaterialGroup) {
        this.mainMaterialGroup = mainMaterialGroup;
    }

    public List<Set<String>> getLLC() {
        return this.llc;
    }

    public Integer searchBOM(List<Integer> boms, RowData requireData) {
        ExprContext ctx = new ExprContext();
        ctx.addPreDefinedParam("requireData", requireData);
        Long supplyOrg = MRPUtil.convert(requireData.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()), 0L);
        if (supplyOrg <= 0L) {
            supplyOrg = MRPUtil.convert(requireData.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()), 0L);
        }
        Long org = supplyOrg <= 0L ? MRPUtil.convert(requireData.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()), 0L) : supplyOrg;
        int idx = this.getColIdx().get(DefaultField.BOMField.COPTYPE.getName());
        if (!boms.isEmpty()) {
            ArrayList<Integer> newBoms = new ArrayList<Integer>(boms);
            Iterator its = newBoms.iterator();
            while (its.hasNext()) {
                Integer bom = (Integer)its.next();
                Object v = this.fetchRow(bom).get(idx);
                CopTypeEnum copTypeEnum = CopTypeEnum.fromValue((String)String.valueOf(v));
                if (copTypeEnum == null) continue;
                its.remove();
            }
            if (newBoms.isEmpty()) {
                return -1;
            }
            BomDataModel bomDataModel = (BomDataModel)this.runParam.getService(BomDataModel.class);
            Long bomTime = MRPUtil.getExpendBomTime((IMRPEnvProvider)this.runParam, requireData);
            newBoms.sort((o1, o2) -> {
                int oIdx = this.getColIdx().get(DefaultField.BOMField.PRODUCTORGUNIT.getName());
                Long org1 = MRPUtil.convert(this.fetchRow((int)o1).get(oIdx), 0L);
                Long org2 = MRPUtil.convert(this.fetchRow((int)o2).get(oIdx), 0L);
                if (org.equals(org1) && !org.equals(org2)) {
                    return -1;
                }
                if (!org.equals(org1) && org.equals(org2)) {
                    return 1;
                }
                int i = this.getColIdx().get(DefaultField.BOMField.BOMVERSION.getName());
                Long v1 = MRPUtil.convert(this.fetchRow((int)o1).get(i), 0L);
                Long v2 = MRPUtil.convert(this.fetchRow((int)o2).get(i), 0L);
                return bomDataModel.compareBomVersionPriority(v1, v2, bomTime);
            });
            idx = this.getColIdx().get(DefaultField.BOMField.ISSUPERBOM.getName());
            for (Integer bom : newBoms) {
                Boolean isSuperBom = MRPUtil.convert(this.fetchRow(bom).get(idx), Boolean.FALSE);
                if (isSuperBom.booleanValue()) continue;
                return bom;
            }
            return (Integer)newBoms.get(0);
        }
        return -1;
    }

    @Override
    protected Object[][] splitRow(Object[] row) {
        this.refreshShareSettings(row);
        Integer idx = this.getColIdx().get(DefaultField.BOMField.ISSUPERBOM.getName());
        Boolean isSuperBom = MRPUtil.convert(row[idx], Boolean.FALSE);
        boolean mrp_consider_pro_version_to_bom = MRPUtil.convert(this.runParam.getCfgValue(EnvCfgItem.MRP_CONSIDER_PRO_VERSION_TO_BOM), Boolean.FALSE);
        if (!mrp_consider_pro_version_to_bom && isSuperBom != null && isSuperBom.booleanValue()) {
            idx = this.getColIdx().get(DefaultField.BOMField.ENTRYID.getName());
            this.entryId2SuperBom.put(MRPUtil.convert(row[idx], 0L), this.getSuperBomDatas().getDatas().size());
            this.getSuperBomDatas().getDatas().add(row);
            return new Object[0][];
        }
        return new Object[][]{row};
    }

    private void refreshShareSettings(Object[] row) {
        Long superBomId = MRPUtil.convert(row[this.getColIdx().get(DefaultField.BOMField.__SUPER_BOMID__.getName())], 0L);
        Long bomId = superBomId > 0L ? superBomId : MRPUtil.convert(row[this.getColIdx().get(DefaultField.BOMField.BOMID.getName())], 0L);
        Long orgId = Long.valueOf(String.valueOf(row[this.getColIdx().get(DefaultField.BOMField.PRODUCTORGUNIT.getName())]));
        row[this.getColIdx().get((Object)DefaultField.BOMField.PRODUCTORGUNIT.getName()).intValue()] = orgId;
        String bt = MRPUtil.convert(row[this.getColIdx().get(DefaultField.BOMField.__BILL_ENTITY__.getName())], "");
        String ctrlstrategy = MRPUtil.convert(row[this.getColIdx().get(DefaultField.BOMField.CTRLSTRATEGY.getName())], "");
        this.initRequireOrgs();
        if (bt != null && ctrlstrategy != null && this.requireOrgs != null && !this.requireOrgs.isEmpty() && !this.shareCache.containsKey(bomId)) {
            if ("1".equals(ctrlstrategy) || "2".equals(ctrlstrategy) || "6".equals(ctrlstrategy)) {
                String key = bt + '\u0001' + ctrlstrategy;
                Map createOrg2Pks = this.ctrlStrategyCache.computeIfAbsent(key, k -> new HashMap(2));
                Set pks = createOrg2Pks.computeIfAbsent(orgId, k -> new HashSet(16));
                pks.add(bomId);
            } else {
                this.shareCache.put(bomId, this.orgUtil.getRelationOrg(orgId, bomId, bt, ctrlstrategy, this.requireOrgs));
            }
        }
    }

    private void initRequireOrgs() {
        if (this.runParam != null && this.requireOrgs == null) {
            PlanModel planModel = (PlanModel)this.runParam.getService(PlanModel.class);
            this.requireOrgs = new HashSet<Long>();
            for (String rOrgId : planModel.getRequirorgs()) {
                this.requireOrgs.add(Long.valueOf(rOrgId));
            }
        }
    }

    public void batchRefreshShareSettings() {
        if (!this.ctrlStrategyCache.isEmpty()) {
            this.initRequireOrgs();
            for (Map.Entry<String, Map<Long, Set<Long>>> entry : this.ctrlStrategyCache.entrySet()) {
                String[] strs = entry.getKey().split("\u0001");
                Map result = this.orgUtil.batchGetRelationOrg(entry.getValue(), strs[0], strs[1], this.requireOrgs);
                for (Map.Entry entryRes : result.entrySet()) {
                    this.shareCache.put((Long)entryRes.getKey(), (Set<Long>)entryRes.getValue());
                }
            }
            this.ctrlStrategyCache.clear();
        }
    }

    @Override
    public RowData fetchRow(int rowIdx) {
        int srcRowIdx = rowIdx;
        Object[] values = this.getSrcDatas().getDatas().get(rowIdx);
        while (this.isZipRow(values)) {
            rowIdx = (Integer)values[0];
            values = this.getSrcDatas().getDatas().get(rowIdx);
        }
        if (srcRowIdx != rowIdx) {
            values = (Object[])values.clone();
            Object[] tinyRow = this.getSrcDatas().getDatas().get(srcRowIdx);
            values[((Integer)this.colIdx.get((Object)DefaultField.BOMField.ENTRYCONFIGUREDCODE.getName())).intValue()] = tinyRow[1];
            values[((Integer)this.colIdx.get((Object)DefaultField.BOMField.CHILDNUMERATOR.getName())).intValue()] = tinyRow[2];
            values[((Integer)this.colIdx.get((Object)DefaultField.BOMField.CHILDDENOMINATOR.getName())).intValue()] = tinyRow[3];
            values[((Integer)this.colIdx.get((Object)DefaultField.BOMField.CHILDQTY.getName())).intValue()] = tinyRow[4];
            values[((Integer)this.colIdx.get((Object)DefaultField.BOMField.CHILDMATERIAL.getName())).intValue()] = tinyRow[5];
            values[((Integer)this.colIdx.get((Object)DefaultField.BOMField.CHILDTYPE.getName())).intValue()] = tinyRow[6];
            values[((Integer)this.colIdx.get((Object)DefaultField.BOMField.__SUPER_BOMID__.getName())).intValue()] = tinyRow[7];
            values[((Integer)this.colIdx.get((Object)DefaultField.BOMField.BOMID.getName())).intValue()] = tinyRow[8];
            values[((Integer)this.colIdx.get((Object)DefaultField.BOMField.CONFIGUREDCODE.getName())).intValue()] = tinyRow[9];
            values[((Integer)this.colIdx.get((Object)DefaultField.BOMField.MATERIAL.getName())).intValue()] = tinyRow[10];
            values[((Integer)this.colIdx.get((Object)DefaultField.BOMField.ENTRYID.getName())).intValue()] = tinyRow[11];
            Map<String, Object> updates = this.tinyRowUpdates.get(rowIdx);
            if (updates != null) {
                Object[] ref = values;
                updates.forEach((k, v) -> {
                    ref[((Integer)this.colIdx.get((Object)k)).intValue()] = v;
                });
            }
        }
        return new RowData(this.srcDatas, this.getColIdx(), values, rowIdx, ResType.BOM);
    }

    public List<RowData> fetchRow(Collection<Integer> rows) {
        ArrayList<RowData> datas = new ArrayList<RowData>(rows.size());
        for (Integer next : rows) {
            datas.add(this.fetchRow(next));
        }
        return datas;
    }

    @Override
    public Object getValue(String colLabel, int rowIdx) {
        Integer idx = (Integer)this.colIdx.get(colLabel);
        if (idx == null) {
            return null;
        }
        if (this.isZipRow(rowIdx)) {
            RowData row = this.fetchRow(rowIdx);
            return row.get(idx);
        }
        return this.srcDatas.getDatas().get(rowIdx)[idx];
    }

    @Override
    public void updateValue(String colLabel, Integer rowIdx, Object newVal) {
        Object old;
        if (this.isZipRow(rowIdx)) {
            Object[] tinyRow = this.srcDatas.getDatas().get(rowIdx);
            int idx = this.getZipRowColIdx(colLabel);
            if (idx > 0) {
                old = tinyRow[idx];
                tinyRow[idx] = newVal;
            } else {
                Map updates = this.tinyRowUpdates.getOrDefault(rowIdx, new HashMap(4));
                if (!updates.containsKey(colLabel)) {
                    RowData bomData = this.fetchRow(rowIdx);
                    old = bomData.getValue(colLabel);
                    if (!Objects.equals(old, newVal)) {
                        updates.put(colLabel, newVal);
                        this.tinyRowUpdates.put(rowIdx, updates);
                    }
                } else {
                    old = updates.put(colLabel, newVal);
                }
            }
        } else {
            Integer col = (Integer)this.colIdx.get(colLabel);
            old = this.srcDatas.getDatas().get(rowIdx)[col];
            this.srcDatas.getDatas().updateValue(rowIdx, col, newVal);
        }
        ColumnDatas column = (ColumnDatas)this.index.get(colLabel);
        if (column != null) {
            column.remove(old, rowIdx);
            column.put((Comparable)newVal, rowIdx);
        }
    }

    @Override
    protected boolean isValidDate(CalEnv runParam, Object[] rowData) {
        return super.isValidDate(runParam, rowData);
    }

    @Override
    public void clear() {
        super.clear();
        if (this.superBomDatas != null) {
            this.superBomDatas.getDatas().clear();
        }
        if (this.entryId2SuperBom != null) {
            this.entryId2SuperBom.clear();
        }
        this.alreadyDynamicRestoreBOMMaterial.clear();
        this.tinyRowUpdates.clear();
    }

    public boolean isInReplaceGroup(String mId) {
        return this.mergeGroups.containsKey(mId);
    }

    public boolean isDependReplaceGroup(String mId) {
        return this.dependMergeGroups.containsKey(mId) && !this.origMergeGroups.containsKey(mId);
    }

    public boolean isSendedByReplaceGroup(String mId) {
        return this.sended.contains(mId);
    }

    public Set<String> getReplaceGroupAndTagSended(String mId) {
        Set<String> ids = this.mergeGroups.get(mId);
        this.sended.addAll(ids);
        return ids;
    }

    public void addMergeGroup(Collection<Set<String>> groups) {
        for (Set<String> group : groups) {
            for (String mId : group) {
                this.mergeGroups.put(mId, group);
            }
        }
    }

    @Override
    protected boolean setDefaultData(Object[] rowData) {
        int idx = this.getColIdx().get(DefaultField.BOMField.ISCOPDATA.getName());
        if (1 == MRPUtil.convert(rowData[idx], 0)) {
            idx = this.getColIdx().get(DefaultField.BOMField.CHILDMATERIAL.getName());
            if (MRPUtil.convert(rowData[idx], 0L) <= 0L) {
                return false;
            }
            idx = this.getColIdx().get(DefaultField.BOMField.CHILDTYPE.getName());
            rowData[idx] = "A";
            idx = this.getColIdx().get(DefaultField.BOMField.CHILDAMTTYPE.getName());
            rowData[idx] = "A";
        }
        return super.setDefaultData(rowData);
    }

    @Override
    protected boolean isIgnoreNullValue(String notNullCol, Object[] row) {
        int idx = this.getColIdx().get(DefaultField.BOMField.CHILDTYPE.getName());
        String childType = MRPUtil.convert(row[idx], "");
        if ("B".equals(childType) && DefaultField.BOMField.CHILDMATERIAL.getName().equals(notNullCol)) {
            return true;
        }
        return super.isIgnoreNullValue(notNullCol, row);
    }

    public Set<String> getAlreadyDynamicRestoreBOMMaterial() {
        return this.alreadyDynamicRestoreBOMMaterial;
    }

    public int zipFill(Object[] row, int origIdx) {
        int rowIdx = this.srcDatas.getDatas().size();
        for (Map.Entry entry : this.colIdx.entrySet()) {
            if (!this.index.containsKey(entry.getKey())) continue;
            ((ColumnDatas)this.index.get(entry.getKey())).put((Comparable)row[(Integer)this.colIdx.get(entry.getKey())], rowIdx);
        }
        if (origIdx == -1) {
            this.srcDatas.getDatas().add(row);
        } else {
            Object[] tinyRow = new Object[]{origIdx, row[(Integer)this.colIdx.get(DefaultField.BOMField.ENTRYCONFIGUREDCODE.getName())], row[(Integer)this.colIdx.get(DefaultField.BOMField.CHILDNUMERATOR.getName())], row[(Integer)this.colIdx.get(DefaultField.BOMField.CHILDDENOMINATOR.getName())], row[(Integer)this.colIdx.get(DefaultField.BOMField.CHILDQTY.getName())], row[(Integer)this.colIdx.get(DefaultField.BOMField.CHILDMATERIAL.getName())], row[(Integer)this.colIdx.get(DefaultField.BOMField.CHILDTYPE.getName())], row[(Integer)this.colIdx.get(DefaultField.BOMField.__SUPER_BOMID__.getName())], row[(Integer)this.colIdx.get(DefaultField.BOMField.BOMID.getName())], row[(Integer)this.colIdx.get(DefaultField.BOMField.CONFIGUREDCODE.getName())], row[(Integer)this.colIdx.get(DefaultField.BOMField.MATERIAL.getName())], row[(Integer)this.colIdx.get(DefaultField.BOMField.ENTRYID.getName())]};
            this.srcDatas.getDatas().add(tinyRow);
        }
        return this.srcDatas.getDatas().size() - 1;
    }

    public boolean isZipRow(int rowIdx) {
        Object[] row = this.srcDatas.getDatas().get(rowIdx);
        return this.isZipRow(row);
    }

    private boolean isZipRow(Object[] row) {
        return row.length < 30;
    }

    private int getZipRowColIdx(String colLabel) {
        int idx = -1;
        if (DefaultField.BOMField.ENTRYCONFIGUREDCODE.getName().equals(colLabel)) {
            idx = 1;
        } else if (DefaultField.BOMField.CHILDNUMERATOR.getName().equals(colLabel)) {
            idx = 2;
        } else if (DefaultField.BOMField.CHILDDENOMINATOR.getName().equals(colLabel)) {
            idx = 3;
        } else if (DefaultField.BOMField.CHILDQTY.getName().equals(colLabel)) {
            idx = 4;
        } else if (DefaultField.BOMField.CHILDMATERIAL.getName().equals(colLabel)) {
            idx = 5;
        } else if (DefaultField.BOMField.CHILDTYPE.getName().equals(colLabel)) {
            idx = 6;
        } else if (DefaultField.BOMField.__SUPER_BOMID__.getName().equals(colLabel)) {
            idx = 7;
        } else if (DefaultField.BOMField.BOMID.getName().equals(colLabel)) {
            idx = 8;
        } else if (DefaultField.BOMField.CONFIGUREDCODE.getName().equals(colLabel)) {
            idx = 9;
        } else if (DefaultField.BOMField.MATERIAL.getName().equals(colLabel)) {
            idx = 10;
        } else if (DefaultField.BOMField.ENTRYID.getName().equals(colLabel)) {
            idx = 11;
        }
        return idx;
    }
}

