/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.model.table.res;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mmc.mrp.common.util.DynamicObjDataUtil;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.MRPWorkCalendarManager;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.integrate.entity.CacheDatas;
import kd.mmc.mrp.integrate.entity.MtPlanInfoModel;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.integrate.entity.RequireDataModel;
import kd.mmc.mrp.integrate.entity.RunLogModel;
import kd.mmc.mrp.model.date.OrgBasedCalendarModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.enums.MultiThreadCacheKey;
import kd.mmc.mrp.model.enums.ResType;
import kd.mmc.mrp.model.enums.strategy.OORBillResolveStrategy;
import kd.mmc.mrp.model.struct.SupplyStruct;
import kd.mmc.mrp.model.table.ColumnDatas;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.table.res.AbstractResModelDataTable;
import kd.mmc.mrp.model.table.res.SafeInvRequire;
import kd.mmc.mrp.utils.MRPUtil;

public class RequirementDataTable
extends AbstractResModelDataTable
implements Serializable {
    private static final Log logger = LogFactory.getLog(RequirementDataTable.class);
    private static final long serialVersionUID = 1L;
    private StringBuilder buffer = new StringBuilder();
    private int llc = 0;
    private HashMap<String, SafeInvRequire> latestSafeInvRequires = new HashMap();
    private List<Object[]> safeInvs;
    private HashSet<Integer> lockRows = new HashSet();
    private int lockPos = 0;
    private Map<String, Long> selectDatas = new HashMap<String, Long>();
    private Map<String, Map<Long, BigDecimal>> mid2billQtyRatio = new HashMap<String, Map<Long, BigDecimal>>(2);
    private Map<String, Set<String>> bill2billEntrys = new HashMap<String, Set<String>>(2);

    public Map<String, Set<String>> getBill2billEntrys() {
        return this.bill2billEntrys;
    }

    public RequirementDataTable(CalEnv runParam, Set<String> indexCols) {
        super(runParam, indexCols);
        this.filterKeyName = MultiThreadCacheKey.KEY_REQUIRE_FILTER;
        this.index.put(DefaultField.RequireField.__PRIORITY_LEVEL__.name(), new ColumnDatas());
    }

    public void setLLC(int llc) {
        this.llc = llc;
    }

    @Override
    public String getLogo(Object[] row) {
        String name;
        Object value = row[this.getColIdx().get(DefaultField.RequireField.BILLNUMBER.getName())];
        Object seq = row[this.getColIdx().get(DefaultField.RequireField.BILLENTRYSEQ.getName())];
        Object material = row[this.getColIdx().get(DefaultField.RequireField.MATERIAL.getName())];
        String string = value == null ? null : (name = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801(%1$s)-\u5206\u5f55\u884c\u53f7(%2$s)-", (String)"RequirementDataTable_0", (String)"mmc-mrp-mservice", (Object[])new Object[0]), value.toString(), seq == null ? Integer.valueOf(0) : seq));
        if (name == null) {
            value = row[this.getColIdx().get(DefaultField.RequireField.BILLID.getName())];
            String string2 = name = value == null ? null : String.format(ResManager.loadKDString((String)"\u5355\u636eID(%s)-", (String)"RequirementDataTable_1", (String)"mmc-mrp-mservice", (Object[])new Object[0]), value.toString());
        }
        if (material != null) {
            MtPlanInfoModel planInfoModel = (MtPlanInfoModel)this.runParam.getService(MtPlanInfoModel.class);
            String[] mData = planInfoModel.getMaterialDataById(String.valueOf(material));
            String number = mData[0];
            name = name + String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801(%s)-", (String)"RequirementDataTable_2", (String)"mmc-mrp-mservice", (Object[])new Object[0]), number);
        }
        return name;
    }

    @Override
    public String getAlias4Name(String name) {
        String alias = DefaultField.RequireField.getAlias4Name(name);
        if (alias == null) {
            alias = name;
        }
        return alias;
    }

    @Override
    protected void afterFillRow(Object[] row, String modelId, String resDataName, String resDataId) {
        row[this.getColIdx().get((Object)DefaultField.RequireField.__REAL_QUATA__.getName()).intValue()] = BigDecimal.ZERO;
        row[this.getColIdx().get((Object)DefaultField.RequireField.__SUPPLY_QTY__.getName()).intValue()] = BigDecimal.ZERO;
        row[this.getColIdx().get((Object)DefaultField.RequireField.__INV_PO_QTY__.getName()).intValue()] = BigDecimal.ZERO;
        if (row[this.getColIdx().get(DefaultField.CommonField.__MODEL_ID__.name())] == null) {
            row[this.getColIdx().get((Object)DefaultField.CommonField.__MODEL_ID__.name()).intValue()] = resDataId;
        }
        if (row[this.getColIdx().get(DefaultField.CommonField.__MODEL_NUMBER__.name())] == null) {
            row[this.getColIdx().get((Object)DefaultField.CommonField.__MODEL_NUMBER__.name()).intValue()] = resDataName;
        }
        if (row[this.getColIdx().get(DefaultField.RequireField.__PRIORITY_LEVEL__.getName())] == null) {
            row[this.getColIdx().get((Object)DefaultField.RequireField.__PRIORITY_LEVEL__.getName()).intValue()] = 0;
        }
        if (StringUtils.isNotBlank((CharSequence)modelId)) {
            row[this.getColIdx().get((Object)DefaultField.RequireField.BILL_ENTITY.getName()).intValue()] = modelId;
        }
        row[this.getColIdx().get((Object)DefaultField.RequireField.__ORIGIN_DEMAND_DATE__.getName()).intValue()] = row[this.getColIdx().get(DefaultField.RequireField.DATE.getName())];
        Integer idx = this.getColIdx().get(DefaultField.RequireField.PRODUCTIONORGUNIT.getName());
        String productStorageOrgUnitID = String.valueOf(row[idx]);
        PlanModel planModel = (PlanModel)this.runParam.getService(PlanModel.class);
        row[this.getColIdx().get((Object)DefaultField.RequireField.QTY.getName()).intValue()] = MRPUtil.toBigDecimal(row[this.getColIdx().get(DefaultField.RequireField.QTY.getName())]);
        if (row[this.getColIdx().get(DefaultField.RequireField.CONFIGUREDCODE.getName())] == null) {
            row[this.getColIdx().get((Object)DefaultField.RequireField.CONFIGUREDCODE.getName()).intValue()] = 0L;
        }
        if (row[this.getColIdx().get(DefaultField.RequireField.TRACKNUMBER.getName())] == null) {
            row[this.getColIdx().get((Object)DefaultField.RequireField.TRACKNUMBER.getName()).intValue()] = 0L;
        }
        row[this.getColIdx().get((Object)DefaultField.RequireField.INV_IS_TRACK_MATCH.getName()).intValue()] = true;
        this.buildReuireSourceNumber(row);
    }

    @Override
    protected Object[][] splitRow(Object[] row) {
        return super.splitRow(row);
    }

    @Override
    public StringBuilder fill(List<String> cols, List<Object[]> rows, String modelId, String resDataId, String resDataName, String modelName) {
        RunLogModel runLogModel = (RunLogModel)this.runParam.getService(RunLogModel.class);
        PlanModel planModel = (PlanModel)this.runParam.getService(PlanModel.class);
        String jsonStr = MRPCacheManager.getInst().getSubData(this.runParam, "selectbills", MRPRuntimeConsts.getSelectBillDataKey(this.runParam.getMRPContextId(), resDataId));
        if (jsonStr != null) {
            List list = JSON.parseArray((String)jsonStr, Object[].class);
            list.forEach(obj -> {
                String key = String.valueOf(obj[0]) + "\u0001" + String.valueOf(obj[1]);
                if (!obj[3].equals(0)) {
                    if (obj[3] instanceof Integer) {
                        this.selectDatas.put(key, (long)((Integer)obj[3]));
                    } else {
                        this.selectDatas.put(key, (Long)obj[3]);
                    }
                }
            });
        }
        StringBuilder ret = super.fill(cols, rows, modelId, resDataId, resDataName, modelName);
        if (this.safeInvs == null) {
            return ret;
        }
        if ("1".equals(this.runParam.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("mrprunner-safeInvs-require-fill, size: %s", this.safeInvs.size()));
        }
        for (Object[] rowData : this.safeInvs) {
            if ("1".equals(this.runParam.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                logger.warn(String.format("mrprunner-safeInvs-data: %s", new RequireRowData(this.srcDatas, 0, this.colIdx, rowData)));
            }
            Integer idx = this.getColIdx().get(DefaultField.RequireField.SUPPLYORGUNIT.getName());
            Object val = rowData[idx];
            String supplyStorageOrgUnitID = String.valueOf(val);
            idx = this.getColIdx().get(DefaultField.RequireField.DATE.getName());
            Date requireDate = MRPUtil.normalize(new Date((Long)rowData[idx]));
            idx = this.getColIdx().get(DefaultField.RequireField.INVALIDDATE.getName());
            Date invalidDate = rowData[idx] == null ? runLogModel.getPlanDate() : MRPUtil.normalize(new Date((Long)rowData[idx]));
            this.checkStorageRequire(requireDate, invalidDate, supplyStorageOrgUnitID, rowData);
        }
        if (planModel.getOORDataResolveStrategy() == OORBillResolveStrategy.RECORDEXCEPTIONTAG) {
            for (Object[] rowData : this.safeInvs) {
                this.fill(new RowData(this.srcDatas, this.colIdx, rowData, -1, ResType.REQUIRE));
                this.afterFillRow(rowData, modelId, resDataName, resDataId);
            }
        } else {
            for (SafeInvRequire sr : this.latestSafeInvRequires.values()) {
                this.fill(new RowData(this.srcDatas, this.colIdx, sr.rowData, -1, ResType.REQUIRE));
                this.afterFillRow(sr.rowData, modelId, resDataName, resDataId);
            }
        }
        this.latestSafeInvRequires.clear();
        this.safeInvs.clear();
        this.safeInvs = null;
        return ret;
    }

    private Map<Long, BigDecimal> getSelectPlanBillQtyRatioMap(String product) {
        return this.mid2billQtyRatio.computeIfAbsent(product, s -> {
            String cacheValue = MRPCacheManager.getInst().getData(this.runParam, MRPRuntimeConsts.getDependSupplyKey(this.runParam.getMRPContextId(), product));
            return cacheValue != null ? (Map)JSON.parseObject((String)cacheValue, (TypeReference)new TypeReference<Map<Long, BigDecimal>>(){}, (Feature[])new Feature[0]) : new HashMap(0);
        });
    }

    @Override
    protected boolean isValidDate(CalEnv runParam, Object[] rowData, String modelId, String resDataId) {
        Set<String> cacheValue;
        boolean ret;
        PlanModel planModel = (PlanModel)runParam.getService(PlanModel.class);
        RunLogModel runLogModel = (RunLogModel)runParam.getService(RunLogModel.class);
        CacheDatas cacheDatas = (CacheDatas)runParam.getService(CacheDatas.class);
        RequireDataModel requireDataModel = (RequireDataModel)runParam.getService(RequireDataModel.class);
        if (MRPUtil.isRemoveHisBill(runParam, MRPUtil.convert(rowData[this.getColIdx().get(DefaultField.RequireField.BILLID.getName())], 0L), modelId, this.llc)) {
            return false;
        }
        Integer isDependIdx = this.getColIdx().get(DefaultField.RequireField.ISDEPENDENT.getName());
        boolean isToDependRequire = MRPUtil.convert(rowData[isDependIdx], Boolean.FALSE);
        if (cacheDatas.isSelectBillPlan() && isToDependRequire && StringUtils.isNotBlank((CharSequence)resDataId)) {
            Set<String> dependDataSourceIds = cacheDatas.getDependDataSourceIds();
            if (dependDataSourceIds.contains(resDataId)) {
                Long supplybillid;
                BigDecimal billRatio;
                String product;
                Map<Long, BigDecimal> billQtyRatioMap;
                Integer productIdx = this.getColIdx().get(DefaultField.RequireField.PRODUCT.getName());
                boolean isRemove = true;
                if (productIdx != null && (billQtyRatioMap = this.getSelectPlanBillQtyRatioMap(product = String.valueOf(rowData[productIdx]))) != null && !billQtyRatioMap.isEmpty() && (billRatio = billQtyRatioMap.get(supplybillid = MRPUtil.convert(rowData[this.getColIdx().get(DefaultField.RequireField.SUPPLYBILLID.getName())], 0L))) != null) {
                    BigDecimal qty = MRPUtil.convert(rowData[this.getColIdx().get(DefaultField.RequireField.QTY.getName())], BigDecimal.ZERO);
                    rowData[this.getColIdx().get((Object)DefaultField.RequireField.QTY.getName()).intValue()] = MRPUtil.multiply(qty, billRatio);
                    isRemove = false;
                }
                Long id = MRPUtil.convert(rowData[this.getColIdx().get(DefaultField.RequireField.BILLID.getName())], 0L);
                Long entryId = MRPUtil.convert(rowData[this.getColIdx().get(DefaultField.RequireField.BILLENTRYID.getName())], 0L);
                if (isRemove && !cacheDatas.isSelectBillRequire(resDataId, id, entryId)) {
                    return false;
                }
            } else {
                rowData[isDependIdx.intValue()] = 0;
            }
        }
        Long planscope = runLogModel.getRunLogPlanScope();
        if ("1".equals(runParam.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("mrprunner-safeInvs-require-init, rowdata: %s", new RequireRowData(this.srcDatas, 0, this.colIdx, rowData)));
        }
        Integer idx = this.getColIdx().get(DefaultField.RequireField.DATE.getName());
        Date requireDate = MRPUtil.normalize(new Date(MRPUtil.convert(rowData[idx], 0L)));
        rowData[idx.intValue()] = requireDate.getTime();
        if (rowData[this.getColIdx().get(DefaultField.RequireField.TOP_REQUIRE_DATE.getName())] == null) {
            rowData[this.getColIdx().get((Object)DefaultField.RequireField.TOP_REQUIRE_DATE.getName()).intValue()] = requireDate.getTime();
        }
        if (MRPUtil.convert(rowData[this.getColIdx().get(DefaultField.RequireField.ISSTOCK.getName())], Boolean.FALSE).booleanValue()) {
            boolean issafestock = (Boolean)planModel.getPlanDataByParam("issafestock", true);
            if (!issafestock) {
                rowData[this.getColIdx().get((Object)DefaultField.RequireField.EXCEPTIONNUMBER.getName()).intValue()] = "83";
                rowData[this.getColIdx().get((Object)DefaultField.RequireField.EXCEPTIONMESSAGE.getName()).intValue()] = ResManager.loadKDString((String)"\u8ba1\u5212\u65b9\u6848\u672a\u5f00\u542f\u8003\u8651\u5b89\u5168\u5e93\u5b58\uff0c\u52a8\u6001\u5b89\u5168\u5e93\u5b58\u88ab\u6392\u9664\u3002", (String)"RequirementDataTable_9", (String)"mmc-mrp-mservice", (Object[])new Object[0]);
                return planModel.getOORDataResolveStrategy() == OORBillResolveStrategy.RECORDEXCEPTIONTAG;
            }
            if ("REQUIRE_ADJUST".equals(runParam.getCfgValue(EnvCfgItem.SAFE_INV_REQUIRE_APPLY_MODE))) {
                return true;
            }
            if (this.safeInvs == null) {
                this.safeInvs = new ArrayList<Object[]>();
            }
            this.safeInvs.add(rowData);
            return false;
        }
        idx = this.getColIdx().get(DefaultField.RequireField.PRODUCTIONORGUNIT.getName());
        String productStorageOrgUnitID = String.valueOf(rowData[idx]);
        idx = this.getColIdx().get(DefaultField.RequireField.SUPPLYORGUNIT.getName());
        Object val = rowData[idx];
        String supplyStorageOrgUnitID = String.valueOf(val);
        if (DynamicObjDataUtil.isNullStringOr0Long((String)supplyStorageOrgUnitID)) {
            if (!planModel.getRequirorgs().contains(productStorageOrgUnitID)) {
                rowData[this.getColIdx().get((Object)DefaultField.RequireField.EXCEPTIONNUMBER.getName()).intValue()] = "83";
                rowData[this.getColIdx().get((Object)DefaultField.RequireField.EXCEPTIONMESSAGE.getName()).intValue()] = ResManager.loadKDString((String)"\u9700\u6c42\u5355\u636e\u7684\u9700\u6c42\u7ec4\u7ec7\u8d85\u51fa\u8ba1\u7b97\u8303\u56f4\u3002", (String)"RequirementDataTable_3", (String)"mmc-mrp-mservice", (Object[])new Object[0]);
                return planModel.getOORDataResolveStrategy() == OORBillResolveStrategy.RECORDEXCEPTIONTAG;
            }
            supplyStorageOrgUnitID = productStorageOrgUnitID;
        } else if (!planModel.getRequirorgs().contains(supplyStorageOrgUnitID)) {
            rowData[this.getColIdx().get((Object)DefaultField.RequireField.EXCEPTIONNUMBER.getName()).intValue()] = "83";
            rowData[this.getColIdx().get((Object)DefaultField.RequireField.EXCEPTIONMESSAGE.getName()).intValue()] = ResManager.loadKDString((String)"\u9700\u6c42\u5355\u636e\u7684\u4f9b\u5e94\u7ec4\u7ec7\u8d85\u51fa\u8ba1\u7b97\u8303\u56f4\u3002", (String)"RequirementDataTable_4", (String)"mmc-mrp-mservice", (Object[])new Object[0]);
            return planModel.getOORDataResolveStrategy() == OORBillResolveStrategy.RECORDEXCEPTIONTAG;
        }
        MRPWorkCalendarManager manager = runParam.dateManager();
        OrgBasedCalendarModel sOcm = manager.get(supplyStorageOrgUnitID, productStorageOrgUnitID);
        int dayseq = sOcm.getWorkDaySeq(requireDate);
        Date startDate = manager.getBeginDateRequire(supplyStorageOrgUnitID, productStorageOrgUnitID);
        Date endDate = manager.getEndDateOutLook(supplyStorageOrgUnitID, productStorageOrgUnitID);
        int startseq = sOcm.getWorkDaySeq(startDate);
        int endseq = sOcm.getWorkDaySeq(endDate);
        boolean bl = ret = startseq <= dayseq && endseq >= dayseq;
        if (!ret) {
            rowData[this.getColIdx().get((Object)DefaultField.RequireField.EXCEPTIONNUMBER.getName()).intValue()] = "84";
            rowData[this.getColIdx().get((Object)DefaultField.RequireField.EXCEPTIONMESSAGE.getName()).intValue()] = ResManager.loadKDString((String)"\u9700\u6c42\u5355\u636e\u7684\u9700\u6c42\u65f6\u95f4\u8d85\u51fa\u8ba1\u5212\u65e5\u5386\u8ba1\u7b97\u8303\u56f4\u3002", (String)"RequirementDataTable_5", (String)"mmc-mrp-mservice", (Object[])new Object[0]);
            return planModel.getOORDataResolveStrategy() == OORBillResolveStrategy.RECORDEXCEPTIONTAG;
        }
        Integer planOutLook = planModel.getPlanOutLook();
        if (dayseq > manager.getPlanDatePeriod(supplyStorageOrgUnitID, productStorageOrgUnitID) + planOutLook) {
            rowData[this.getColIdx().get((Object)DefaultField.RequireField.EXCEPTIONNUMBER.getName()).intValue()] = "84";
            rowData[this.getColIdx().get((Object)DefaultField.RequireField.EXCEPTIONMESSAGE.getName()).intValue()] = ResManager.loadKDString((String)"\u9700\u6c42\u5355\u636e\u7684\u9700\u6c42\u65f6\u95f4\u8d85\u51fa\u5c55\u671b\u671f\u8ba1\u7b97\u8303\u56f4\u3002", (String)"RequirementDataTable_6", (String)"mmc-mrp-mservice", (Object[])new Object[0]);
            return planModel.getOORDataResolveStrategy() == OORBillResolveStrategy.RECORDEXCEPTIONTAG;
        }
        if (!this.selectDatas.isEmpty()) {
            Integer billId = this.getColIdx().get(DefaultField.RequireField.BILLID.getName());
            Integer billEntryId = this.getColIdx().get(DefaultField.RequireField.BILLENTRYID.getName());
            String id = MRPUtil.convert(rowData[billId], "0");
            String entryId = MRPUtil.convert(rowData[billEntryId], "0");
            idx = this.getColIdx().get(DefaultField.RequireField.DATE.getName());
            if (this.selectDatas.containsKey(id + "\u0001" + entryId)) {
                rowData[idx.intValue()] = this.selectDatas.get(id + "\u0001" + entryId);
            }
        }
        SupplyStruct ss = planModel.getPriorityRelations().get(supplyStorageOrgUnitID);
        if (planscope > 0L && ss != null && !planscope.equals(ss.getPlanScope())) {
            rowData[this.getColIdx().get((Object)DefaultField.RequireField.EXCEPTIONNUMBER.getName()).intValue()] = "83";
            rowData[this.getColIdx().get((Object)DefaultField.RequireField.EXCEPTIONMESSAGE.getName()).intValue()] = ResManager.loadKDString((String)"\u9700\u6c42\u5355\u636e\u7684\u9700\u6c42\u7ec4\u7ec7\u8d85\u51fa\u8ba1\u7b97\u8303\u56f4\u3002", (String)"RequirementDataTable_3", (String)"mmc-mrp-mservice", (Object[])new Object[0]);
            return planModel.getOORDataResolveStrategy() == OORBillResolveStrategy.RECORDEXCEPTIONTAG;
        }
        Long materialId = MRPUtil.convert(rowData[this.getColIdx().get(DefaultField.RequireField.MATERIAL.getName())], 0L);
        Long dataOrg = MRPUtil.convert(rowData[this.getColIdx().get(DefaultField.RequireField.PRODUCTIONORGUNIT.getName())], 0L);
        Long supplyOrg = MRPUtil.convert(rowData[this.getColIdx().get(DefaultField.RequireField.SUPPLYORGUNIT.getName())], 0L);
        if (supplyOrg > 0L && !supplyOrg.equals(dataOrg)) {
            dataOrg = supplyOrg;
        }
        String exp = MRPUtil.convert(rowData[this.getColIdx().get(DefaultField.RequireField.EXCEPTIONNUMBER.getName())], "");
        if (cacheDatas.isSelectMaterialPlan4PlanScope() && !MRPUtil.hasException(exp) && (cacheValue = cacheDatas.getSelectMaterialPlanScope(runParam, dataOrg.toString(), materialId.toString())) == null) {
            rowData[this.getColIdx().get((Object)DefaultField.RequireField.EXCEPTIONNUMBER.getName()).intValue()] = "83";
            rowData[this.getColIdx().get((Object)DefaultField.RequireField.EXCEPTIONMESSAGE.getName()).intValue()] = ResManager.loadKDString((String)"\u9700\u6c42\u5355\u636e\u7684\u9700\u6c42\u7ec4\u7ec7\u8d85\u51fa\u8ba1\u7b97\u8303\u56f4\u3002", (String)"RequirementDataTable_3", (String)"mmc-mrp-mservice", (Object[])new Object[0]);
            return planModel.getOORDataResolveStrategy() == OORBillResolveStrategy.RECORDEXCEPTIONTAG;
        }
        if (requireDataModel.isIs_single_calc()) {
            idx = this.getColIdx().get(DefaultField.RequireField.__IS_EXPANDABLE__.getName());
            rowData[idx.intValue()] = false;
        }
        if (cacheDatas.isSelectBillPlan() && !MRPUtil.convert(rowData[this.getColIdx().get(DefaultField.RequireField.__ISDEPENDENT__.getName())], Boolean.FALSE).booleanValue()) {
            Long billId = MRPUtil.convert(rowData[this.getColIdx().get(DefaultField.RequireField.BILLID.getName())], 0L);
            Long billEntryId = MRPUtil.convert(rowData[this.getColIdx().get(DefaultField.RequireField.BILLENTRYID.getName())], 0L);
            Set entrys = this.getBill2billEntrys().computeIfAbsent(billId.toString(), k -> new HashSet(2));
            if (billEntryId <= 0L) {
                entrys.add("");
                entrys.add("0");
            } else {
                entrys.add(billEntryId.toString());
            }
        }
        return true;
    }

    private void buildReuireSourceNumber(Object[] rowData) {
        if (rowData[this.getColIdx().get(DefaultField.RequireField.__REQUIRE_SOURCE__.getName())] != null) {
            return;
        }
        String rt = String.valueOf(rowData[this.getColIdx().get(DefaultField.RequireField.REQUIRETYPE.getName())]);
        Long ts = (Long)rowData[this.getColIdx().get(DefaultField.RequireField.DATE.getName())];
        Date date = new Date(ts);
        String dateStr = MRPUtil.createSimpleDateFormat().format(date);
        this.buffer.setLength(0);
        if ("ORDER".equals(rt)) {
            if (rowData[this.getColIdx().get(DefaultField.RequireField.BILLNUMBER.getName())] != null) {
                this.buffer.append(rowData[this.getColIdx().get(DefaultField.RequireField.BILLNUMBER.getName())]);
            } else {
                this.buffer.append(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e", (String)"RequirementDataTable_7", (String)"mmc-mrp-mservice", (Object[])new Object[0]));
            }
            this.appendValue(rowData, DefaultField.RequireField.BILLENTRYSEQ, this.buffer);
        }
        if ("SOP".equals(rt)) {
            this.buffer.append("SOP");
            this.appendValue(rowData, DefaultField.RequireField.MATERIALNUMBER, this.buffer);
        }
        if ("ID".equals(rt)) {
            this.buffer.append("ID");
            this.appendValue(rowData, DefaultField.RequireField.MATERIALNUMBER, this.buffer);
        }
        if ("SS".equals(rt)) {
            this.buffer.append("SS");
            this.appendValue(rowData, DefaultField.RequireField.MATERIALNUMBER, this.buffer);
        }
        if ("OH".equals(rt)) {
            this.buffer.append("OH");
            this.appendValue(rowData, DefaultField.RequireField.MATERIALNUMBER, this.buffer);
        }
        if ("WIP".equals(rt)) {
            this.buffer.append("WIP");
            this.appendValue(rowData, DefaultField.RequireField.BILLNUMBER, this.buffer);
            this.appendValue(rowData, DefaultField.RequireField.PRODUCTORGNUMBER, this.buffer);
        }
        if (this.buffer.length() == 0) {
            return;
        }
        this.buffer.append("_");
        this.buffer.append(dateStr);
        this.buffer.append("_");
        this.buffer.append(this.size());
        rowData[this.getColIdx().get((Object)DefaultField.RequireField.__REQUIRE_SOURCE__.getName()).intValue()] = this.buffer.toString();
    }

    private void appendValue(Object[] require, DefaultField.RequireField field, StringBuilder buffer) {
        buffer.append("_");
        if (require[this.getColIdx().get(field.getName())] != null) {
            buffer.append(require[this.getColIdx().get(field.getName())]);
        } else {
            buffer.append(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e", (String)"RequirementDataTable_7", (String)"mmc-mrp-mservice", (Object[])new Object[0]));
        }
    }

    @Override
    public Integer size() {
        return super.size();
    }

    @Override
    public RequireRowData fetchRow(int rowIdx) {
        return new RequireRowData(this.srcDatas, rowIdx, this.getColIdx(), this.getSrcDatas().getDatas().get(rowIdx));
    }

    public List<RequireRowData> fetchRow(Collection<Integer> rows) {
        ArrayList<RequireRowData> datas = new ArrayList<RequireRowData>(rows.size());
        for (Integer next : rows) {
            datas.add(new RequireRowData(this.srcDatas, next, this.getColIdx(), this.getSrcDatas().getDatas().get(next)));
        }
        return datas;
    }

    @Override
    public void clear() {
        super.clear();
        this.latestSafeInvRequires.clear();
        this.lockRows.clear();
        this.lockPos = 0;
        this.mid2billQtyRatio.clear();
    }

    @Override
    public Object getValue(String colLabel, int rowIdx) {
        return super.getValue(colLabel, rowIdx);
    }

    @Override
    public synchronized int fill(RowData data) {
        Object[] row = data.getValues();
        int rowIdx = this.getSrcDatas().getDatas().size();
        for (Map.Entry<String, Integer> entry : this.getColIdx().entrySet()) {
            if (!this.index.containsKey(entry.getKey())) continue;
            ((ColumnDatas)this.index.get(entry.getKey())).put((Comparable)row[this.getColIdx().get(entry.getKey())], rowIdx);
        }
        this.getSrcDatas().getDatas().add(row);
        return this.getSrcDatas().getDatas().size() - 1;
    }

    @Override
    public ColumnDatas getCol(String colLabel) {
        ColumnDatas col = super.getCol(colLabel);
        col.setRemovedRows(this.lockRows);
        return col;
    }

    public void lockAll() {
        for (int i = this.lockPos; i < this.getSrcDatas().getDatas().size(); ++i) {
            this.lockRows.add(i);
        }
        this.lockPos = this.getSrcDatas().getDatas().size();
    }

    public void lock(Integer rowIdx) {
        this.lockRows.add(rowIdx);
    }

    public boolean isLock(Integer rowIdx) {
        return this.lockRows.contains(rowIdx);
    }

    public boolean noLock() {
        return this.lockRows.isEmpty();
    }

    private void checkStorageRequire(Date requireDate, Date invalidDate, String supplyStorageOrgUnitID, Object[] rowData) {
        RunLogModel runLogModel = (RunLogModel)this.runParam.getService(RunLogModel.class);
        SafeInvRequire sr = this.latestSafeInvRequires.get(supplyStorageOrgUnitID);
        if (sr == null) {
            sr = new SafeInvRequire();
            sr.rowData = rowData;
            sr.distance = requireDate.compareTo(runLogModel.getPlanDate()) <= 0 && invalidDate.compareTo(runLogModel.getPlanDate()) >= 0 ? 0 : Math.abs((int)((runLogModel.getPlanDate().getTime() - requireDate.getTime()) / 86400000L));
            this.latestSafeInvRequires.put(supplyStorageOrgUnitID, sr);
        } else {
            int distance = -1;
            distance = requireDate.compareTo(runLogModel.getPlanDate()) <= 0 && invalidDate.compareTo(runLogModel.getPlanDate()) >= 0 ? 0 : Math.abs((int)((runLogModel.getPlanDate().getTime() - requireDate.getTime()) / 86400000L));
            if (sr.distance > distance) {
                sr.rowData[this.getColIdx().get((Object)DefaultField.RequireField.EXCEPTIONNUMBER.getName()).intValue()] = "83";
                sr.rowData[this.getColIdx().get((Object)DefaultField.RequireField.EXCEPTIONMESSAGE.getName()).intValue()] = ResManager.loadKDString((String)"\u5b89\u5168\u5e93\u5b58\u65f6\u95f4\u8303\u56f4\u65e0\u6548\uff0c\u9700\u6c42\u88ab\u6392\u9664\u3002", (String)"RequirementDataTable_8", (String)"mmc-mrp-mservice", (Object[])new Object[0]);
                sr.rowData = rowData;
                sr.distance = distance;
            } else {
                rowData[this.getColIdx().get((Object)DefaultField.RequireField.EXCEPTIONNUMBER.getName()).intValue()] = "83";
                rowData[this.getColIdx().get((Object)DefaultField.RequireField.EXCEPTIONMESSAGE.getName()).intValue()] = ResManager.loadKDString((String)"\u5b89\u5168\u5e93\u5b58\u65f6\u95f4\u8303\u56f4\u65e0\u6548\uff0c\u9700\u6c42\u88ab\u6392\u9664\u3002", (String)"RequirementDataTable_8", (String)"mmc-mrp-mservice", (Object[])new Object[0]);
            }
        }
    }
}

