/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.model.table.store.spill;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mmc.mrp.model.table.store.spill.IMRPDataSpillResolver;
import org.apache.commons.io.FilenameUtils;

public class DataSpillDiskResolver<T>
implements IMRPDataSpillResolver<T> {
    public static final String MRP_TMP_DIR = FilenameUtils.normalize((String)(System.getProperty("java.io.tmpdir") + File.separator + "mrp"));
    private static final byte[] empty_bs = new byte[0];
    private static int NORMALIZE_LENGTH = 12;
    private final String fileName = MRP_TMP_DIR + File.separator + UUID.randomUUID().toString().replaceAll("-", "") + ".dat";
    private final String indexFileName = MRP_TMP_DIR + File.separator + UUID.randomUUID().toString().replaceAll("-", "") + ".idx";
    private RandomAccessFile buffer;
    private RandomAccessFile indexBuffer;
    private Map<Integer, Integer> updates = new HashMap<Integer, Integer>();
    private long lastFilePos = 0L;
    private int spillCnt = 0;
    private int prefix = -1;

    @Override
    public void close() throws Exception {
        if (this.buffer != null) {
            this.buffer.close();
            new File(this.fileName).delete();
            this.indexBuffer.close();
            new File(this.indexFileName).delete();
            this.prefix = -1;
        }
    }

    @Override
    public void write(int rowIdx, T row) throws IOException {
        try (TraceSpan ts = Tracer.create((String)"MRPDataResolver.spillWrite", (String)"spillWrite");){
            if (this.buffer == null) {
                this.prefix = rowIdx;
                this.buffer = new RandomAccessFile(this.ensureFile(this.fileName), "rw");
            }
            ++this.spillCnt;
            byte[] bytes = this.encode(row);
            this.buffer.write(bytes);
            if (this.indexBuffer == null) {
                this.indexBuffer = new RandomAccessFile(this.ensureFile(this.indexFileName), "rw");
            }
            this.lastFilePos += (long)bytes.length;
            this.indexBuffer.writeBytes(this.normalizeStrLen(this.lastFilePos));
        }
    }

    private String normalizeStrLen(long len) {
        char[] chars = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'};
        char[] src = Long.toHexString(len).toCharArray();
        if (src.length > chars.length) {
            throw new RuntimeException("mrprunner-overflow-failed: file size exceeded");
        }
        System.arraycopy(src, 0, chars, chars.length - src.length, src.length);
        return new String(chars);
    }

    private File ensureFile(String fp) throws IOException {
        File file = new File(fp);
        if (file.exists()) {
            file.delete();
        } else {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        return file;
    }

    @Override
    public T read(int rowIdx) throws IOException {
        try (TraceSpan ts = Tracer.create((String)"MRPDataResolver.spillRead", (String)"spillRead");){
            Object row;
            if (this.buffer == null) {
                T t = null;
                return t;
            }
            Integer newRowIdx = this.updates.get(rowIdx);
            if (newRowIdx != null) {
                rowIdx = newRowIdx;
            }
            long pos = this.indexBuffer.getFilePointer();
            long filePos = this.buffer.getFilePointer();
            byte[] bytes = new byte[NORMALIZE_LENGTH];
            long len = -1L;
            if (rowIdx < this.prefix) {
                throw new RuntimeException(String.format("mrprunner-load-spill-data-error: wrong rowIdx(%s), may be in memory?", rowIdx));
            }
            if (rowIdx == this.prefix) {
                this.indexBuffer.seek(0L);
                this.indexBuffer.read(bytes);
                len = Long.valueOf(new String(bytes), 16);
                this.buffer.seek(0L);
            } else {
                this.indexBuffer.seek((rowIdx - this.prefix - 1) * NORMALIZE_LENGTH);
                this.indexBuffer.read(bytes);
                len = Long.valueOf(new String(bytes), 16);
                this.buffer.seek(len);
                this.indexBuffer.read(bytes);
                len = Long.valueOf(new String(bytes), 16) - len;
            }
            this.indexBuffer.seek(pos);
            bytes = new byte[(int)len];
            this.buffer.read(bytes);
            this.buffer.seek(filePos);
            Object object = row = this.decode(bytes);
            return (T)object;
        }
    }

    @Override
    public void update(int rowIdx, T row) throws IOException {
        if (this.buffer == null) {
            return;
        }
        int newRowIdx = this.spillCnt++;
        this.write(newRowIdx, row);
        this.updates.put(rowIdx, newRowIdx);
    }

    /*
     * Exception decompiling
     */
    private byte[] encode(Object val) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private final Object decode(byte[] bs) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Iterator<T> iterator() {
        InnerIterator iter = new InnerIterator();
        try {
            this.indexBuffer.seek(0L);
        }
        catch (IOException e) {
            throw new RuntimeException("mrprunner-spill-file-iter-failed", e);
        }
        return iter;
    }

    public String toString() {
        return "path: " + this.fileName + ", spill size: " + this.spillCnt;
    }

    private class InnerIterator
    implements Iterator<T> {
        private int idx = 0;
        private byte[] bytes = new byte[DataSpillDiskResolver.access$100()];

        private InnerIterator() {
        }

        @Override
        public boolean hasNext() {
            int len;
            try {
                len = DataSpillDiskResolver.this.indexBuffer.read(this.bytes);
            }
            catch (IOException e) {
                throw new RuntimeException("mrprunner-spill-file-iter-failed", e);
            }
            return len == NORMALIZE_LENGTH;
        }

        @Override
        public T next() {
            try {
                return DataSpillDiskResolver.this.read(DataSpillDiskResolver.this.prefix + this.idx++);
            }
            catch (IOException e) {
                throw new KDBizException((Throwable)e, new ErrorCode("FAILED_TO_READ_SPILL_DATAS", "FAILED_TO_READ_SPILL_DATAS"), new Object[0]);
            }
        }
    }
}

