/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.model.table.utils;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.dataentity.utils.StringUtils;
import kd.mmc.mrp.common.consts.PlanScopeRelationConst;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.MRPWorkCalendarManager;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.cache.MRPRedisStore;
import kd.mmc.mrp.framework.fomula.Expr;
import kd.mmc.mrp.framework.fomula.ExprContext;
import kd.mmc.mrp.integrate.entity.CacheDatas;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.integrate.entity.PlanScopeModel;
import kd.mmc.mrp.integrate.entity.ResDataModelCollection;
import kd.mmc.mrp.model.date.OrgBasedCalendarModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.enums.strategy.BillAdjustStrategy;
import kd.mmc.mrp.model.enums.strategy.BillSplitStrategy;
import kd.mmc.mrp.model.enums.strategy.MaterialAttribute;
import kd.mmc.mrp.model.struct.InvRealBalanceStruct;
import kd.mmc.mrp.model.struct.InvSupplyStruct;
import kd.mmc.mrp.model.struct.PriorityStruct;
import kd.mmc.mrp.model.struct.SupplyStruct;
import kd.mmc.mrp.model.table.AdjustParameter;
import kd.mmc.mrp.model.table.AdjustSuggestTable;
import kd.mmc.mrp.model.table.DataBalanceTable;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.table.res.FlexFieldDataTable;
import kd.mmc.mrp.model.table.res.SupplymentDataTable;
import kd.mmc.mrp.model.table.utils.DataMatchUtils;
import kd.mmc.mrp.model.wrapper.FieldMapping;
import kd.mmc.mrp.utils.MRPUtil;

public class DataBalanceUtil {
    public static List<Integer> singleSamePeriodOccupy(RequireRowData requireData, IMRPEnvProvider ctx) {
        Boolean isFastEnable;
        ArrayList<Integer> occupys = new ArrayList<Integer>();
        BigDecimal rQty = MRPUtil.toBigDecimal(requireData.getValue(DefaultField.RequireField.QTY.getName()));
        if (rQty.compareTo(BigDecimal.ZERO) == 0) {
            requireData.setNewQrequireQty(BigDecimal.ZERO);
            return occupys;
        }
        SupplymentDataTable supplyTbl = ctx.supplyDatas();
        Date requireDate = new Date((Long)requireData.getValue(DefaultField.RequireField.DATE.getName()));
        Timestamp today = new Timestamp(MRPUtil.normalize(ctx.getPlanDate()).getTime());
        if (!ctx.isAllowPast() && requireDate.getTime() < today.getTime()) {
            requireDate = new Date(today.getTime());
            requireData.update(DefaultField.RequireField.DATE.getName(), (Object)today.getTime());
        }
        String requireProductOrgUnitID = String.valueOf(requireData.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
        String requireSupplyOrgId = String.valueOf(requireData.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()));
        MRPWorkCalendarManager wcm = ctx.dateManager();
        OrgBasedCalendarModel rOcm = wcm.get(requireSupplyOrgId, requireProductOrgUnitID);
        requireDate = rOcm.getDate(requireDate, true).getTime();
        int requirePeriod = rOcm.getWorkDaySeq(requireDate);
        List<Integer> supplys = DataMatchUtils.findSupplysUtil(false, requireData, ctx);
        if (supplys.isEmpty()) {
            requireData.setNewQrequireQty(rQty);
            return occupys;
        }
        Object strategy = requireData.getValue(DefaultField.RequireField.PLAN_STRATEGY.getName());
        if (strategy == null) {
            strategy = requireData.getValue(DefaultField.RequireField.DEFAULT_PLAN_STRATEGY.getName());
        }
        if (!(isFastEnable = (Boolean)ctx.getCfgValue(EnvCfgItem.ENABLE_FAST_SUPLLY_SEARCH_MODE)).booleanValue()) {
            supplys = supplyTbl.sortByPriority(requireSupplyOrgId, supplys, strategy == null ? null : String.valueOf(strategy));
            supplys.sort(new DataMatchUtils.SupplySortComparator(ctx));
        }
        List<RowData> supplyDatas = supplyTbl.fetchRow(supplys);
        boolean isBalanced = false;
        HashSet<String> reqOrgs = ctx.getRequirorgs();
        for (int i = 0; i < supplyDatas.size(); ++i) {
            RowData supply = supplyDatas.get(i);
            if (supply.getValue(DefaultField.SupplyField.__EXCEPTIONNUMBER__.getName()) != null || MRPUtil.convert(supply.getValue(DefaultField.SupplyField.__IS_OCCUPIED__.getName()), Boolean.FALSE).booleanValue()) continue;
            Date supplyDate = new Date((Long)supply.getValue(DefaultField.SupplyField.DATE.getName()));
            String requireProductOrgUnitID1 = String.valueOf(requireData.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
            String supplyProductOrgUnitID = String.valueOf(supply.getValue(DefaultField.SupplyField.SUPPLYORGUNIT.getName()));
            if (!reqOrgs.contains(supplyProductOrgUnitID) && !reqOrgs.contains(requireProductOrgUnitID1)) {
                supplyProductOrgUnitID = String.valueOf(requireData.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()));
            }
            int supplyPeriod = -1;
            if (MRPUtil.convert(supply.getValue(DefaultField.SupplyField.ISSTORAGEDATA.getName()), 0) != 0) {
                supplyPeriod = requirePeriod;
                BigDecimal dt = MRPUtil.toBigDecimal(supply.getValue(DefaultField.SupplyField.__WASTE_STORAGE_DEAL_TIME__.getName()));
                if (dt != null) {
                    int n = dt.setScale(0, RoundingMode.CEILING).intValue();
                    supplyPeriod = rOcm.getWorkDaySeq(new Date()) + n;
                    supply.update(DefaultField.SupplyField.DATE.getName(), (Object)(MRPUtil.normalize(new Date()).getTime() + (long)n * 86400000L));
                    if (requirePeriod < supplyPeriod) continue;
                    supplyPeriod = requirePeriod;
                }
            } else {
                OrgBasedCalendarModel sOcm = wcm.get(supplyProductOrgUnitID, requireProductOrgUnitID1);
                supplyPeriod = sOcm.getWorkDaySeq(supplyDate);
            }
            if (supplyPeriod != requirePeriod || rQty.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal sQty = MRPUtil.toBigDecimal(supply.getValue(DefaultField.SupplyField.QTY.getName()));
            rQty = rQty.subtract(sQty);
            String modelID = (String)supply.getValue(DefaultField.SupplyField.BILL_ENTITY.getName());
            BillSplitStrategy ajustType = ctx.strategys().getOrDefault(modelID, BillSplitStrategy.PART);
            int cmp = rQty.compareTo(BigDecimal.ZERO);
            if (cmp >= 0) {
                occupys.add(supplys.get(i));
            } else if (BillSplitStrategy.PART == ajustType) {
                if (MRPUtil.convert(supply.getValue(DefaultField.SupplyField.ISSTORAGEDATA.getName()), Boolean.FALSE).booleanValue()) {
                    RowData[] datas = supplyTbl.splitStorage(supply, sQty.add(rQty));
                    supplyTbl.fill(datas);
                    occupys.add(supplys.get(i));
                } else {
                    int split = supplyTbl.fill(supplyTbl.split(supply, sQty.add(rQty), ctx));
                    occupys.add(split);
                }
            } else if (BillSplitStrategy.WHOLE == ajustType || BillSplitStrategy.NONE == ajustType) {
                occupys.add(supplys.get(i));
            }
            if (cmp > 0) continue;
            isBalanced = true;
            break;
        }
        requireData.getOccupys().addAll(occupys);
        requireData.setBalanced(isBalanced);
        if (isBalanced) {
            requireData.setNewQrequireQty(BigDecimal.ZERO);
        } else {
            requireData.setNewQrequireQty(rQty);
        }
        return occupys;
    }

    public static DataBalanceTable.MatchType singleModifyOccupy(RequireRowData requireData, IMRPEnvProvider ctx, List<RowData> occupyData) {
        Boolean isFastEnable;
        int planOutLook = ctx.getPlanOutLook();
        MRPWorkCalendarManager wcm = ctx.dateManager();
        SupplymentDataTable supplyTbl = ctx.supplyDatas();
        AdjustParameter adjustParameter = DataBalanceUtil.getAdjustParameter(ctx, requireData);
        int advanceAdjust = adjustParameter.getAdvanceAdjust();
        int delayAdjust = adjustParameter.getDelayAdjust();
        int tolerOfDelay = adjustParameter.getTolerOfDelay();
        int tolerOfForward = adjustParameter.getTolerOfForward();
        BigDecimal rQty = requireData.getNewQrequireQty();
        if (rQty == null) {
            rQty = new BigDecimal(String.valueOf(requireData.getValue(DefaultField.RequireField.QTY.getName())));
        }
        if (rQty.compareTo(BigDecimal.ZERO) == 0 || requireData.isBalanced()) {
            return null;
        }
        Date requireDate = new Date((Long)requireData.getValue(DefaultField.RequireField.DATE.getName()));
        String supplyOrgId = String.valueOf(requireData.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()));
        String requireProductOrgUnitID = String.valueOf(requireData.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
        OrgBasedCalendarModel requireCal = wcm.get(supplyOrgId, requireProductOrgUnitID);
        int periodAdjust = wcm.getPlanDatePeriod(supplyOrgId, requireProductOrgUnitID) + planOutLook;
        int requirePeriod = requireCal.getWorkDaySeq(requireDate);
        if (requirePeriod > periodAdjust) {
            occupyData.addAll(supplyTbl.fetchRow(requireData.getOccupys(), true));
            return DataBalanceTable.MatchType.LESS;
        }
        List<Integer> supplys = DataMatchUtils.findSupplysUtil(false, requireData, ctx);
        if (supplys.isEmpty()) {
            occupyData.addAll(supplyTbl.fetchRow(requireData.getOccupys(), true));
            return DataBalanceTable.MatchType.LESS;
        }
        Object strategy = requireData.getValue(DefaultField.RequireField.PLAN_STRATEGY.getName());
        if (strategy == null) {
            strategy = requireData.getValue(DefaultField.RequireField.DEFAULT_PLAN_STRATEGY.getName());
        }
        if (!(isFastEnable = (Boolean)ctx.getCfgValue(EnvCfgItem.ENABLE_FAST_SUPLLY_SEARCH_MODE)).booleanValue()) {
            supplys = supplyTbl.sortByPriority(supplyOrgId, supplys, strategy == null ? null : String.valueOf(strategy));
            supplys.sort(new DataMatchUtils.SupplySortComparator(ctx));
        }
        List<RowData> supplyDatas = supplyTbl.fetchRow(supplys);
        BigDecimal sumSQty = BigDecimal.ZERO;
        boolean isSurplus = false;
        HashSet<String> reqOrgs = ctx.getRequirorgs();
        for (int idx = 0; idx < supplyDatas.size(); ++idx) {
            AdjustSuggestTable suggestTable;
            RowData supply = supplyDatas.get(idx);
            if ("tmp_safe_inv".equals(supply.getValue(DefaultField.SupplyField.BILL_ENTITY.getName())) || supply.getValue(DefaultField.SupplyField.__EXCEPTIONNUMBER__.getName()) != null || MRPUtil.convert(supply.getValue(DefaultField.SupplyField.__IS_OCCUPIED__.getName()), Boolean.FALSE).booleanValue()) continue;
            Date supplyDate = new Date((Long)supply.getValue(DefaultField.SupplyField.DATE.getName()));
            String supplyProductOrgUnitID = String.valueOf(supply.getValue(DefaultField.SupplyField.SUPPLYORGUNIT.getName()));
            if (!reqOrgs.contains(supplyProductOrgUnitID) && !reqOrgs.contains(requireProductOrgUnitID)) {
                supplyProductOrgUnitID = supplyOrgId;
            }
            int advancePeriodAdjust = wcm.getPlanDatePeriod(supplyProductOrgUnitID, requireProductOrgUnitID) + advanceAdjust;
            int delayPeriodAdjust = wcm.getPlanDatePeriod(supplyProductOrgUnitID, requireProductOrgUnitID) - delayAdjust;
            int supplyPeriod = wcm.get(supplyProductOrgUnitID, requireProductOrgUnitID).getWorkDaySeq(supplyDate);
            if (supplyPeriod > advancePeriodAdjust || supplyPeriod < delayPeriodAdjust || (suggestTable = DataBalanceUtil.getAdjustSuggestTable(ctx, requireData, supply, requirePeriod, supplyPeriod, tolerOfDelay, tolerOfForward, requireCal)) == null) continue;
            BigDecimal sQty = MRPUtil.toBigDecimal(supply.getValue(DefaultField.SupplyField.QTY.getName()));
            int balance = rQty.compareTo(sumSQty = sumSQty.add(sQty));
            if (balance > 0) {
                DataBalanceUtil.lessOrEqualsDataBalance(ctx, supply, suggestTable);
                requireData.getOccupys().add(supplys.get(idx));
                continue;
            }
            isSurplus = true;
            if (balance == 0) {
                DataBalanceUtil.lessOrEqualsDataBalance(ctx, supply, suggestTable);
                requireData.getOccupys().add(supplys.get(idx));
                break;
            }
            BigDecimal unUsedQty = sumSQty.subtract(rQty);
            int idx2 = DataBalanceUtil.surplusDataBalance(ctx, supply, suggestTable, supplyTbl, unUsedQty);
            if (idx2 >= 0) {
                requireData.getOccupys().add(idx2);
                break;
            }
            requireData.getOccupys().add(supplys.get(idx));
            break;
        }
        DataBalanceTable.MatchType matchType = null;
        occupyData.addAll(supplyTbl.fetchRow(requireData.getOccupys(), true));
        matchType = !isSurplus ? DataBalanceTable.MatchType.LESS : DataBalanceTable.MatchType.EQUAL;
        supplyTbl.lock(requireData.getOccupys(), requireData.getRowIdx());
        return matchType;
    }

    public static void lessOrEqualsDataBalance(IMRPEnvProvider ctx, RowData supply, AdjustSuggestTable suggestTable) {
        String modelID = (String)supply.getValue(DefaultField.SupplyField.BILL_ENTITY.getName());
        BillSplitStrategy ajustType = ctx.strategys().getOrDefault(modelID, BillSplitStrategy.PART);
        BigDecimal sQty = MRPUtil.toBigDecimal(supply.getValue(DefaultField.SupplyField.ORIGINQTY.getName()));
        if (BillSplitStrategy.WHOLE != ajustType) {
            supply.update(DefaultField.SupplyField.__ADJUST_QTY__.name(), (Object)sQty);
            supply.update(DefaultField.SupplyField.__IS_ADJUST__.name(), (Object)(suggestTable.isAdjust() ? 1 : 0));
            supply.update(DefaultField.SupplyField.__ADJUST_FLAG__.name(), (Object)suggestTable.getAdjustFlag());
            supply.update(DefaultField.SupplyField.__ADJUST_PLAN_DATE__.name(), suggestTable.getAdjustPlanDate() == null ? null : Long.valueOf(suggestTable.getAdjustPlanDate().getTime()));
        } else {
            Object tmp = supply.get(DefaultField.SupplyField.__IS_SPLITED__.name());
            if (tmp == null) {
                supply.update(DefaultField.SupplyField.__ADJUST_QTY__.name(), (Object)sQty);
                supply.update(DefaultField.SupplyField.__IS_ADJUST__.name(), (Object)(suggestTable.isAdjust() ? 1 : 0));
                supply.update(DefaultField.SupplyField.__ADJUST_FLAG__.name(), (Object)suggestTable.getAdjustFlag());
                supply.update(DefaultField.SupplyField.__ADJUST_PLAN_DATE__.name(), suggestTable.getAdjustPlanDate() == null ? null : Long.valueOf(suggestTable.getAdjustPlanDate().getTime()));
                supply.update(DefaultField.SupplyField.__IS_SPLITED__.name(), (Object)Boolean.TRUE);
            }
            supply.update(DefaultField.SupplyField.__HAS_WHOLE_ADJUST__.name(), (Object)Boolean.TRUE);
        }
    }

    public static int surplusDataBalance(IMRPEnvProvider ctx, RowData supply, AdjustSuggestTable suggestTable, SupplymentDataTable supplyTbl, BigDecimal unUsedQty) {
        String modelID = (String)supply.getValue(DefaultField.SupplyField.BILL_ENTITY.getName());
        BillSplitStrategy ajustType = ctx.strategys().getOrDefault(modelID, BillSplitStrategy.PART);
        BigDecimal sQty = MRPUtil.toBigDecimal(supply.getValue(DefaultField.SupplyField.QTY.getName()));
        BigDecimal originQty = MRPUtil.toBigDecimal(supply.getValue(DefaultField.SupplyField.ORIGINQTY.getName()));
        int idx2 = -1;
        if (BillSplitStrategy.PART == ajustType) {
            RowData splitCopy = supplyTbl.split(supply, sQty.subtract(unUsedQty), ctx);
            BigDecimal splitCopyOriginQty = MRPUtil.toBigDecimal(splitCopy.getValue(DefaultField.SupplyField.ORIGINQTY.getName()));
            splitCopy.update(DefaultField.SupplyField.__ADJUST_QTY__.name(), (Object)splitCopyOriginQty);
            splitCopy.update(DefaultField.SupplyField.__IS_ADJUST__.name(), (Object)(suggestTable.isAdjust() ? 1 : 0));
            splitCopy.update(DefaultField.SupplyField.__ADJUST_FLAG__.name(), (Object)suggestTable.getAdjustFlag());
            splitCopy.update(DefaultField.SupplyField.__ADJUST_PLAN_DATE__.name(), suggestTable.getAdjustPlanDate() == null ? null : Long.valueOf(suggestTable.getAdjustPlanDate().getTime()));
            idx2 = supplyTbl.fill(splitCopy);
        } else if (BillSplitStrategy.WHOLE == ajustType) {
            RowData splitCopy = supplyTbl.split(supply, sQty.subtract(unUsedQty), ctx);
            Object tmp = supply.get(DefaultField.SupplyField.__IS_SPLITED__.name());
            if (tmp != null) {
                splitCopy.update(DefaultField.SupplyField.__ADJUST_FLAG__.name(), null);
                splitCopy.update(DefaultField.SupplyField.__ADJUST_PLAN_DATE__.name(), null);
                splitCopy.update(DefaultField.SupplyField.__ADJUST_QTY__.name(), (Object)BigDecimal.ZERO);
            } else {
                splitCopy.update(DefaultField.SupplyField.__ADJUST_QTY__.name(), (Object)originQty);
                splitCopy.update(DefaultField.SupplyField.__IS_ADJUST__.name(), (Object)(suggestTable.isAdjust() ? 1 : 0));
                splitCopy.update(DefaultField.SupplyField.__ADJUST_FLAG__.name(), (Object)suggestTable.getAdjustFlag());
                splitCopy.update(DefaultField.SupplyField.__ADJUST_PLAN_DATE__.name(), suggestTable.getAdjustPlanDate() == null ? null : Long.valueOf(suggestTable.getAdjustPlanDate().getTime()));
                supply.update(DefaultField.SupplyField.__IS_SPLITED__.name(), (Object)Boolean.TRUE);
                supply.update(DefaultField.SupplyField.__HAS_WHOLE_ADJUST__.name(), (Object)Boolean.TRUE);
            }
            idx2 = supplyTbl.fill(splitCopy);
        } else if (BillSplitStrategy.NONE == ajustType) {
            RowData splitCopy = supplyTbl.split(supply, sQty.subtract(unUsedQty), ctx);
            BigDecimal splitCopyOriginQty = MRPUtil.toBigDecimal(splitCopy.getValue(DefaultField.SupplyField.ORIGINQTY.getName()));
            splitCopy.update(DefaultField.SupplyField.__IS_ADJUST__.name(), (Object)(suggestTable.isAdjust() ? 1 : 0));
            splitCopy.update(DefaultField.SupplyField.__ADJUST_FLAG__.name(), (Object)suggestTable.getAdjustFlag());
            splitCopy.update(DefaultField.SupplyField.__ADJUST_PLAN_DATE__.name(), suggestTable.getAdjustPlanDate() == null ? null : Long.valueOf(suggestTable.getAdjustPlanDate().getTime()));
            splitCopy.update(DefaultField.SupplyField.__ADJUST_QTY__.name(), (Object)splitCopyOriginQty);
            Object tmp = supply.get(DefaultField.SupplyField.__IS_SPLITED__.name());
            if (tmp == null) {
                supply.update(DefaultField.SupplyField.__IS_SPLITED__.name(), (Object)Boolean.TRUE);
                supply.update(DefaultField.SupplyField.__HAS_WHOLE_ADJUST__.name(), (Object)Boolean.TRUE);
            }
            idx2 = supplyTbl.fill(splitCopy);
        }
        return idx2;
    }

    public static AdjustParameter getAdjustParameter(IMRPEnvProvider ctx, RequireRowData requireData) {
        Object planAdvanceAdjust = ctx.advanceAdjustPeriod();
        Object plandelayAdjust = ctx.delayAdjustPeriod();
        Object planTolerOfDelay = ctx.getTolerOfDelay();
        Object planTolerOfForward = ctx.getTolerOfForward();
        boolean isPlanGramSet = false;
        if (ctx.getAdjustEffectSet() != null && ctx.getAdjustEffectSet().equalsIgnoreCase("B")) {
            isPlanGramSet = true;
        }
        Integer advanceAdjust = DataBalanceUtil.getIntValue(planAdvanceAdjust, null);
        Integer delayAdjust = DataBalanceUtil.getIntValue(plandelayAdjust, null);
        Integer tolerOfDelay = DataBalanceUtil.getIntValue(planTolerOfDelay, null);
        Integer tolerOfForward = DataBalanceUtil.getIntValue(planTolerOfForward, null);
        Object mAdvanceAdjust = requireData.getValue(DefaultField.RequireField.ADVANCE_ADJUST_PERIOD.getName());
        Object mdelayAdjust = requireData.getValue(DefaultField.RequireField.DELAY_ADJUST_PERIOD.getName());
        Object mTolerOfDelay = requireData.getValue(DefaultField.RequireField.TOLER_OF_DELAY.getName());
        Object mTolerOfForward = requireData.getValue(DefaultField.RequireField.TOLER_OF_FORWARD.getName());
        if (!isPlanGramSet || advanceAdjust == null && delayAdjust == null && tolerOfDelay == null && tolerOfForward == null) {
            advanceAdjust = DataBalanceUtil.getIntValue(mAdvanceAdjust, null);
            delayAdjust = DataBalanceUtil.getIntValue(mdelayAdjust, null);
            tolerOfDelay = DataBalanceUtil.getIntValue(mTolerOfDelay, null);
            tolerOfForward = DataBalanceUtil.getIntValue(mTolerOfForward, null);
            if (advanceAdjust == null && delayAdjust == null && tolerOfDelay == null && tolerOfForward == null) {
                advanceAdjust = DataBalanceUtil.getIntValue(planAdvanceAdjust, 0);
                delayAdjust = DataBalanceUtil.getIntValue(plandelayAdjust, 0);
                tolerOfDelay = DataBalanceUtil.getIntValue(planTolerOfDelay, 0);
                tolerOfForward = DataBalanceUtil.getIntValue(planTolerOfForward, 0);
            }
        }
        advanceAdjust = DataBalanceUtil.getIntValue(advanceAdjust, 0);
        delayAdjust = DataBalanceUtil.getIntValue(delayAdjust, 0);
        tolerOfDelay = DataBalanceUtil.getIntValue(tolerOfDelay, 0);
        tolerOfForward = DataBalanceUtil.getIntValue(tolerOfForward, 0);
        AdjustParameter adjustParameter = new AdjustParameter();
        adjustParameter.setAdvanceAdjust(advanceAdjust);
        adjustParameter.setDelayAdjust(delayAdjust);
        adjustParameter.setTolerOfDelay(tolerOfDelay);
        adjustParameter.setTolerOfForward(tolerOfForward);
        return adjustParameter;
    }

    public static AdjustSuggestTable getAdjustSuggestTable(IMRPEnvProvider ctx, RequireRowData requireData, RowData supply, int requirePeriod, int supplyPeriod, Integer tolerOfDelay, Integer tolerOfForward, OrgBasedCalendarModel rOcm) {
        Timestamp today = new Timestamp(ctx.getPlanDate().getTime());
        Date requireDate = new Date((Long)requireData.getValue(DefaultField.RequireField.DATE.getName()));
        Date supplyDate = new Date((Long)supply.getValue(DefaultField.SupplyField.DATE.getName()));
        boolean isAdjust = false;
        int adjustFlag = BillAdjustStrategy.NONE.getValue();
        Timestamp adjustPlanDate = null;
        int mAttr = MRPUtil.convert(requireData.getValue(DefaultField.RequireField.MATERIALATTR.getName()), MaterialAttribute.OTHER.getValue());
        if (!MRPUtil.convert(supply.getValue(DefaultField.SupplyField.ISSTORAGEDATA.getName()), Boolean.FALSE).booleanValue()) {
            if (requirePeriod == supplyPeriod) {
                isAdjust = false;
            } else if (requirePeriod > supplyPeriod) {
                if (requirePeriod - supplyPeriod <= tolerOfDelay) {
                    isAdjust = false;
                    adjustFlag = BillAdjustStrategy.DELAY_OCCUPY.getValue();
                } else {
                    isAdjust = true;
                    adjustFlag = BillAdjustStrategy.DELAY.getValue();
                    adjustPlanDate = mAttr == MaterialAttribute.PURCHASEDPART.getValue() ? new Timestamp(requireDate.getTime()) : new Timestamp(rOcm.getDate(requireDate, true).getTimeInMillis());
                }
            } else if (supplyPeriod - requirePeriod <= tolerOfForward) {
                isAdjust = false;
                adjustFlag = BillAdjustStrategy.ADVANCE_OCCUPY.getValue();
            } else {
                isAdjust = true;
                adjustFlag = BillAdjustStrategy.ADVANCE.getValue();
                adjustPlanDate = mAttr == MaterialAttribute.PURCHASEDPART.getValue() ? new Timestamp(requireDate.getTime()) : new Timestamp(rOcm.getDate(requireDate, true).getTimeInMillis());
            }
            if (!ctx.isAllowPast()) {
                if (adjustFlag == BillAdjustStrategy.ADVANCE.getValue()) {
                    if (supplyDate.compareTo(today) < 0) {
                        adjustFlag = BillAdjustStrategy.DELAY.getValue();
                        adjustPlanDate = today;
                    } else if (adjustPlanDate != null && adjustPlanDate.compareTo(today) <= 0) {
                        adjustPlanDate = today;
                        if (supplyDate.compareTo(today) == 0) {
                            isAdjust = false;
                            adjustFlag = BillAdjustStrategy.NONE.getValue();
                        }
                    }
                } else if (adjustFlag == BillAdjustStrategy.DELAY.getValue() && adjustPlanDate != null && adjustPlanDate.compareTo(today) < 0) {
                    adjustPlanDate = today;
                }
            }
        }
        AdjustSuggestTable suggestTable = new AdjustSuggestTable();
        suggestTable.setAdjust(isAdjust);
        suggestTable.setAdjustFlag(adjustFlag);
        suggestTable.setAdjustPlanDate(adjustPlanDate);
        String modelID = (String)supply.getValue(DefaultField.SupplyField.BILL_ENTITY.getName());
        BillSplitStrategy ajustType = ctx.strategys().getOrDefault(modelID, BillSplitStrategy.PART);
        if (BillSplitStrategy.NONE == ajustType && suggestTable.isAdjust()) {
            return null;
        }
        return suggestTable;
    }

    private static Integer getIntValue(Object value, Integer defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return (Integer)value;
    }

    public static void clearRequireData(RequireRowData dependent) {
        dependent.update(DefaultField.RequireField.__END_DATE__.getName(), null);
        dependent.update(DefaultField.RequireField.__START_DATE__.getName(), null);
        dependent.update(DefaultField.RequireField.DEMANDMERGERULE.getName(), null);
        dependent.update(DefaultField.RequireField.__MATERIALPLAN__.getName(), null);
        dependent.update(DefaultField.RequireField.__PLAN_USER__.getName(), null);
        dependent.update(DefaultField.RequireField.REQUIREOPERAOTR.getName(), null);
        dependent.update(DefaultField.RequireField.__PLAN_TAG__.getName(), null);
        dependent.update(DefaultField.RequireField.DEFAULT_PLAN_STRATEGY.getName(), null);
        dependent.update(DefaultField.RequireField.DELAY_ADJUST_PERIOD.getName(), null);
        dependent.update(DefaultField.RequireField.ADVANCE_ADJUST_PERIOD.getName(), null);
        dependent.update(DefaultField.RequireField.TOLER_OF_FORWARD.getName(), null);
        dependent.update(DefaultField.RequireField.TOLER_OF_DELAY.getName(), null);
        dependent.update(DefaultField.RequireField.__IS_MERGE_.getName(), null);
        dependent.update(DefaultField.RequireField.__MERGE_REQBILL_NUM_.getName(), null);
        dependent.update(DefaultField.RequireField.__MERGE_REQBILL_ID_.getName(), null);
        dependent.update(DefaultField.RequireField.__MERGE_REQBILL_ENTRYID_.getName(), null);
        dependent.update(DefaultField.RequireField.__MERGE_REQBILL_ENTRYSEQ_.getName(), null);
        dependent.update(DefaultField.RequireField.__MERGE_REQQTY_.getName(), null);
        dependent.update(DefaultField.RequireField.__REPLACE_STRUCT__.getName(), null);
        dependent.update(DefaultField.RequireField.EXCEPTIONMESSAGE.getName(), null);
        dependent.update(DefaultField.RequireField.EXCEPTIONNUMBER.getName(), null);
        dependent.update(DefaultField.RequireField.__SRC_DATE__.getName(), null);
        dependent.update(DefaultField.RequireField.PLAN_STRATEGY.getName(), null);
        dependent.update(DefaultField.RequireField.IS_TRACK_MATCH.getName(), null);
        dependent.update(DefaultField.RequireField.__QUOTA_SUPPLIER__.getName(), null);
        dependent.update(DefaultField.RequireField.CONFIGPROPERTIES.getName(), null);
        dependent.update(DefaultField.RequireField.__REQUIRE_ORG_CHAIN__.getName(), null);
        dependent.update(DefaultField.RequireField.PLANMODE.getName(), null);
        dependent.update(DefaultField.RequireField.__ORIGIN_REQUIRE_ORG__.getName(), null);
        dependent.update(DefaultField.RequireField.__INVLEVEL_BILLNUMBER__.getName(), null);
        dependent.update(DefaultField.RequireField.__INVLEVEL_REQUIRE__.getName(), null);
        dependent.update(DefaultField.RequireField.__INV_PO_QTY__.getName(), null);
        dependent.update(DefaultField.RequireField.__PO_ID__.getName(), null);
        dependent.update(DefaultField.RequireField.BATCHPOLICY.getName(), null);
        dependent.update(DefaultField.RequireField.BATCHINCREMENT.getName(), null);
        dependent.update(DefaultField.RequireField.BATCHINCQTY.getName(), null);
        dependent.update(DefaultField.RequireField.__BATCHPOLICY_BILLNUMBER__.getName(), null);
        dependent.update(DefaultField.RequireField.BATCHPOLICYRICHDATE.getName(), null);
        dependent.update(DefaultField.RequireField.BATCHPOLICYRICHQTY.getName(), null);
        dependent.update(DefaultField.RequireField.MINBATCHQTY.getName(), null);
        dependent.update(DefaultField.RequireField.MAXBATCHQTY.getName(), null);
        dependent.update(DefaultField.RequireField.PARTITIONQTY.getName(), null);
        dependent.update(DefaultField.RequireField.SEPARATORSYMBOL.getName(), null);
        dependent.update(DefaultField.RequireField.INTERVALPERIOD.getName(), null);
        dependent.update(DefaultField.RequireField.FIXEDPERIOD.getName(), null);
        dependent.update(DefaultField.RequireField.DYNAMICCYCLE.getName(), null);
        dependent.update(DefaultField.RequireField.SPECIFIEDPERIOD.getName(), null);
        dependent.update(DefaultField.RequireField.__IS_INTERNAL_GROSS_DEMAND__.getName(), null);
        dependent.update(DefaultField.RequireField.RESERVEDTYPE.getName(), null);
        dependent.update(DefaultField.RequireField.YIELD.getName(), null);
        dependent.update(DefaultField.RequireField.SUPPLY_TRACKNUMBER.getName(), null);
        dependent.update(DefaultField.RequireField.SUPPLY_MATERIALFLEXPROPS.getName(), null);
        dependent.update(DefaultField.RequireField.LEADTYPE.getName(), null);
        dependent.update(DefaultField.RequireField.INSPECTLEADDAYS.getName(), null);
        dependent.update(DefaultField.RequireField.FIXEDLEADDAYS.getName(), null);
        dependent.update(DefaultField.RequireField.DYNAMICLEADDAYS.getName(), null);
        dependent.update(DefaultField.RequireField.PREPROCESSDAYS.getName(), null);
        dependent.update(DefaultField.RequireField.POSTPROCESSDAYS.getName(), null);
        dependent.update(DefaultField.RequireField.DYNAMICBATCH.getName(), null);
        dependent.update(DefaultField.RequireField.DEMANDPLANSCOPE.getName(), null);
        dependent.update(DefaultField.RequireField.PLANSCOPE.getName(), null);
        dependent.update(DefaultField.RequireField.WAREHOUSE.getName(), null);
        dependent.update(DefaultField.RequireField.MATERIALPLAN_CREATEORG.getName(), null);
        dependent.update(DefaultField.RequireField.MATERIALMFTINFO.getName(), null);
        dependent.update(DefaultField.RequireField.MFTVERSION.getName(), null);
        dependent.update(DefaultField.RequireField.WORKCENTER.getName(), null);
        dependent.update(DefaultField.RequireField.IN_STORAGE_ORG.getName(), null);
        dependent.update(DefaultField.RequireField.IN_STORAGE_WAREHOUSE.getName(), null);
        dependent.update(DefaultField.RequireField.IN_STORAGE_SHIPPING.getName(), null);
        dependent.update(DefaultField.RequireField.SUPPLIER_ORG.getName(), null);
        dependent.update(DefaultField.RequireField.SUPPLIER_WAREHOUSE.getName(), null);
        dependent.update(DefaultField.RequireField.SUPPLIER_SHIPPING.getName(), null);
        dependent.update(DefaultField.RequireField.SUPPLY_NETWORK.getName(), null);
        dependent.update(DefaultField.RequireField.DEMAND_SUPPLY_STRATEGY.getName(), null);
        dependent.update(DefaultField.RequireField.SUPPLY_STRATEGY.getName(), null);
        dependent.update(DefaultField.RequireField.REORDERPOINT.getName(), null);
        dependent.update(DefaultField.RequireField.MAX.getName(), null);
        dependent.update(DefaultField.RequireField.MIN.getName(), null);
        dependent.update(DefaultField.RequireField.IS_INCLUDEREQUIRE.getName(), null);
        dependent.update(DefaultField.RequireField.IS_INV_WATER_LEVEL.getName(), null);
        dependent.update(DefaultField.RequireField.DEMAND_PLANMODE.getName(), null);
        dependent.update(DefaultField.RequireField.IS_VIRTUAL_REQUIRE.getName(), null);
        dependent.update(DefaultField.RequireField.ISSTOCKALLOT.getName(), null);
        dependent.update(DefaultField.RequireField.__SUPPLY_IDX__.getName(), null);
    }

    public static RequireRowData fillDependentRequire(RowData bomEntryRow, RequireRowData dependent, IMRPEnvProvider ctx) {
        RequireRowData row = new RequireRowData(ctx.requireDatas().getSrcDatas(), ctx.requireDatas().fill(dependent), dependent);
        row.setBomRow(bomEntryRow);
        return row;
    }

    public static boolean isMatch(IMRPEnvProvider ctx, RequireRowData requireData, RowData supplyData, Map<Integer, Boolean> cache) {
        return DataBalanceUtil.isMatch(ctx, requireData, supplyData, false, cache);
    }

    public static boolean isMatch(IMRPEnvProvider ctx, RequireRowData requireData, RowData supplyData, boolean isRequire, Map<Integer, Boolean> cache) {
        List<FieldMapping> fieldMappings = ctx.r2s();
        return DataBalanceUtil.isMatch(ctx, requireData, supplyData, fieldMappings, isRequire, cache);
    }

    public static boolean validateFlexPropsMatch(IMRPEnvProvider ctx, RequireRowData requireData, RowData supplyData) {
        MRPRedisStore store = MRPCacheManager.getDStore(ctx.getMRPContextId());
        FlexFieldDataTable flexFieldDataTable = ctx.getFlexDataTable();
        Set<String> materialFlexFields = flexFieldDataTable.reloadMterialExtendPropSettings(store, requireData.getString(DefaultField.RequireField.MATERIAL.getName()));
        long requireFlexedProp = requireData.getLong(DefaultField.RequireField.MATERIALFLEXPROPS.getName()) == null ? 0L : requireData.getLong(DefaultField.RequireField.MATERIALFLEXPROPS.getName());
        long supplyFlexedProp = supplyData.getLong(DefaultField.SupplyField.MATERIALFLEXPROPS.getName()) == null ? 0L : supplyData.getLong(DefaultField.SupplyField.MATERIALFLEXPROPS.getName());
        Map<?, ?> requireMap = flexFieldDataTable.doMapGet(MRPUtil.convert((Object)requireFlexedProp, 0L));
        Map<?, ?> supplyMap = flexFieldDataTable.doMapGet(MRPUtil.convert((Object)supplyFlexedProp, 0L));
        return DataBalanceUtil.getFlexProps(materialFlexFields, requireMap, supplyMap);
    }

    public static boolean isMatchFlex(IMRPEnvProvider ctx, RequireRowData requireData, Long requireFlexedProp, Long supplyFlexedProp) {
        MRPRedisStore store = MRPCacheManager.getDStore(ctx.getMRPContextId());
        FlexFieldDataTable flexFieldDataTable = ctx.getFlexDataTable();
        Set<String> materialFlexFields = flexFieldDataTable.reloadMterialExtendPropSettings(store, requireData.getString(DefaultField.RequireField.MATERIAL.getName()));
        Map<?, ?> requireMap = flexFieldDataTable.doMapGet(MRPUtil.convert((Object)requireFlexedProp, 0L));
        Map<?, ?> supplyMap = flexFieldDataTable.doMapGet(MRPUtil.convert((Object)supplyFlexedProp, 0L));
        return DataBalanceUtil.getFlexProps(materialFlexFields, requireMap, supplyMap);
    }

    private static boolean getFlexProps(Set<String> fields, Map requireMap, Map supplyMap) {
        if (fields.isEmpty()) {
            return true;
        }
        for (String materialExtProp : fields) {
            if (DataBalanceUtil.equals(requireMap.get(materialExtProp), supplyMap.get(materialExtProp))) continue;
            return false;
        }
        return true;
    }

    private static boolean equals(Object one, Object other) {
        if (one == null && other == null) {
            return true;
        }
        if (one == null || other == null) {
            return false;
        }
        return one.equals(other);
    }

    public static boolean isMatch(IMRPEnvProvider ctx, RequireRowData requireData, RowData supplyData, List<FieldMapping> fieldMappings) {
        return DataBalanceUtil.isMatch(ctx, requireData, supplyData, fieldMappings, false, new HashMap<Integer, Boolean>());
    }

    public static boolean isMatch(IMRPEnvProvider ctx, RequireRowData requireData, RowData supplyData, List<FieldMapping> fieldMappings, boolean isRequire, Map<Integer, Boolean> cache) {
        String str;
        boolean useCache = (Boolean)ctx.getCfgValue(EnvCfgItem.BATCH_ALGO_USE_CACHE);
        Integer key = 0;
        boolean isFlexPropMatch = (Boolean)ctx.getCfgValue(EnvCfgItem.ENABLE_MATERIAL_EXT_PROPS);
        if (useCache && cache.containsKey(key = Integer.valueOf((str = DataBalanceUtil.appendCacheKey(requireData, supplyData, fieldMappings, isRequire, isFlexPropMatch)).hashCode()))) {
            return cache.get(key);
        }
        PlanModel planModel = (PlanModel)ctx.getService(PlanModel.class);
        boolean isCenterWarehouseCycle = planModel.isCenterWarehouse() && DataBalanceUtil.isCenterWarehouseCycleMatch(ctx, requireData, supplyData);
        CacheDatas cacheDatas = (CacheDatas)ctx.getService(CacheDatas.class);
        Long productStorageOrgUnitID = DataBalanceUtil.getPlanScopeRequireOrg(requireData);
        String material = String.valueOf(requireData.getValue(DefaultField.RequireField.MATERIAL.getName()));
        String cacheKey = PlanScopeRelationConst.getRedisPlanScopeRelationKey((String)productStorageOrgUnitID.toString(), (String)material);
        SupplyStruct ss = planModel.getPriorityRelations().getOrDefault(productStorageOrgUnitID.toString(), new SupplyStruct());
        boolean isMatch = true;
        for (FieldMapping relation : fieldMappings) {
            Object supVal;
            Object reqVal = requireData.getValue(relation.getFrom());
            if (DataBalanceUtil.isEqual(reqVal, supVal = supplyData.getValue(isRequire ? relation.getFrom() : relation.getTo())) || isCenterWarehouseCycle && (StringUtils.equalsIgnoreCase((CharSequence)relation.getFrom(), (CharSequence)DefaultField.RequireField.SUPPLYORGUNIT.getName()) || StringUtils.equalsIgnoreCase((CharSequence)relation.getFrom(), (CharSequence)DefaultField.RequireField.PRODUCTIONORGUNIT.getName()))) continue;
            if (!isRequire && StringUtils.equalsIgnoreCase((CharSequence)relation.getFrom(), (CharSequence)DefaultField.RequireField.PLANSCOPE.getName())) {
                Long planScope = DataBalanceUtil.getSupplyPlanScope(ctx, ss, productStorageOrgUnitID, material, isCenterWarehouseCycle, cacheKey, supplyData);
                if (planScope != null && DataBalanceUtil.isEqual(reqVal, planScope)) continue;
                isMatch = false;
                break;
            }
            Expr formula = relation.getValueFormula();
            if (formula == null) {
                isMatch = false;
                break;
            }
            ExprContext exprCtx = new ExprContext();
            exprCtx.addPreDefinedParam("requireData", requireData.toMap());
            exprCtx.addPreDefinedParam("supplyData", supplyData.toMap());
            Object result = formula.execute(exprCtx);
            if (!MRPUtil.isTrue(result)) continue;
            isMatch = false;
            break;
        }
        if (isMatch && !isRequire) {
            String requireProductOrgUnitID = String.valueOf(requireData.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()));
            isMatch = DataBalanceUtil.isEnableStorageSupply(ctx, supplyData, requireProductOrgUnitID, isCenterWarehouseCycle);
        }
        if (isMatch && isFlexPropMatch) {
            long requireFlexedProp = MRPUtil.convert(requireData.getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName()), 0L);
            long supplyFlexedProp = isRequire ? MRPUtil.convert(supplyData.getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName()), 0L).longValue() : MRPUtil.convert(supplyData.getValue(DefaultField.SupplyField.MATERIALFLEXPROPS.getName()), 0L).longValue();
            isMatch = DataBalanceUtil.isMatchFlex(ctx, requireData, requireFlexedProp, supplyFlexedProp);
        }
        if (useCache) {
            cache.put(key, isMatch);
        }
        return isMatch;
    }

    public static boolean isEnableStorageSupply(IMRPEnvProvider ctx, RowData supplyData, String requireProductOrgUnitID, boolean isCenterWarehouseCycle) {
        Boolean isStorageSupply = MRPUtil.convert(supplyData.getValue(DefaultField.SupplyField.ISSTORAGEDATA.getName()), Boolean.FALSE);
        if (isStorageSupply.booleanValue()) {
            PlanModel planModel = (PlanModel)ctx.getService(PlanModel.class);
            ResDataModelCollection service = (ResDataModelCollection)ctx.getService(ResDataModelCollection.class);
            SupplymentDataTable supplyTbl = service.getSupply().getTable();
            SupplyStruct struct = planModel.getPriorityRelations().get(requireProductOrgUnitID);
            InvRealBalanceStruct invacc = new InvRealBalanceStruct(ctx, supplyTbl.getColIdx(), supplyData.getValues());
            return service.isStorageSupplyMatch(supplyTbl, struct, invacc, supplyData.getValues(), isCenterWarehouseCycle, planModel, 0, new ArrayList<PriorityStruct>());
        }
        return true;
    }

    public static Integer createCacheKey(RowData supplyData, List<FieldMapping> fieldMappings) {
        return DataBalanceUtil.createDataCacheKey(supplyData, fieldMappings, new Object[0]);
    }

    public static Integer createDataCacheKey(RowData supplyData, List<FieldMapping> fieldMappings, Object ... others) {
        return DataBalanceUtil.createDataCacheKey(true, supplyData, fieldMappings, others);
    }

    public static Integer createDataCacheKey(boolean isRequire, RowData supplyData, List<FieldMapping> fieldMappings, Object ... others) {
        StringBuilder supplyKey = new StringBuilder();
        for (FieldMapping relation : fieldMappings) {
            Object supVal = supplyData.getValue(isRequire ? relation.getFrom() : relation.getTo());
            if (supplyKey.length() > 0) {
                supplyKey.append('\u0001');
            }
            supplyKey.append(StringUtils.isBlank((Object)supVal) ? "0" : supVal.toString());
        }
        if (others != null) {
            for (Object o : others) {
                supplyKey.append('\u0001').append(String.valueOf(o));
            }
        }
        return supplyKey.toString().hashCode();
    }

    private static String appendCacheKey(RequireRowData requireData, RowData supplyData, List<FieldMapping> fieldMappings, boolean isRequire, boolean isFlexPropMatch) {
        StringBuilder requireKey = new StringBuilder();
        for (FieldMapping relation : fieldMappings) {
            Object reqVal = requireData.getValue(relation.getFrom());
            if (requireKey.length() > 0) {
                requireKey.append('\u0001');
            }
            requireKey.append(StringUtils.isBlank((Object)reqVal) ? "0" : reqVal.toString());
            Object supVal = supplyData.getValue(isRequire ? relation.getFrom() : relation.getTo());
            if (requireKey.length() > 0) {
                requireKey.append('\u0001');
            }
            requireKey.append(StringUtils.isBlank((Object)supVal) ? "0" : supVal.toString());
        }
        if (isFlexPropMatch) {
            long supplyFlexedProp;
            long requireFlexedProp = MRPUtil.convert(requireData.getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName()), 0L);
            long l = supplyFlexedProp = isRequire ? MRPUtil.convert(supplyData.getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName()), 0L).longValue() : MRPUtil.convert(supplyData.getValue(DefaultField.SupplyField.MATERIALFLEXPROPS.getName()), 0L).longValue();
            if (requireKey.length() > 0) {
                requireKey.append('\u0001');
            }
            requireKey.append(requireFlexedProp).append('\u0001').append(supplyFlexedProp);
        }
        return requireKey.toString();
    }

    public static Long getPlanScopeRequireOrg(RowData requireData) {
        Long originOrg;
        Long demadPlanScope = MRPUtil.convert(requireData.getValue(DefaultField.RequireField.DEMANDPLANSCOPE.getName()), 0L);
        Long supplyorgunit = MRPUtil.convert(requireData.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()), 0L);
        Long productStorageOrgUnitID = demadPlanScope > 0L ? ((originOrg = MRPUtil.convert((Object)requireData.getLong(DefaultField.RequireField.__ORIGIN_REQUIRE_ORG__.getName()), 0L)) > 0L ? originOrg : MRPUtil.convert(requireData.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()), 0L)) : (supplyorgunit > 0L ? supplyorgunit : MRPUtil.convert(requireData.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()), 0L));
        return productStorageOrgUnitID;
    }

    public static Long getSupplyPlanScope(IMRPEnvProvider ctx, SupplyStruct ss, Long productStorageOrgUnitID, String material, boolean isCenterWarehouseCycle, String cacheKey, RowData supplyData) {
        Long planScope = MRPUtil.convert(supplyData.getValue(DefaultField.SupplyField.PLANSCOPE.getName()), 0L);
        Long warehouse = MRPUtil.convert(supplyData.getValue(DefaultField.SupplyField.WAREHOUSE.getName()), 0L);
        return DataBalanceUtil.getPlanScopeByWareHouse(ctx, ss, productStorageOrgUnitID, material, isCenterWarehouseCycle, cacheKey, planScope, warehouse);
    }

    public static Long getPlanScopeByWareHouse(IMRPEnvProvider ctx, SupplyStruct ss, Long productStorageOrgUnitID, String material, boolean isCenterWarehouseCycle, String cacheKey, Long planScope, Long warehouse) {
        return DataBalanceUtil.getPlanScopeByWareHouse(ctx, ss, productStorageOrgUnitID, material, isCenterWarehouseCycle, cacheKey, planScope, warehouse, true);
    }

    public static Long getPlanScopeByWareHouse(IMRPEnvProvider ctx, SupplyStruct ss, Long productStorageOrgUnitID, String material, boolean isCenterWarehouseCycle, String cacheKey, Long planScope, Long warehouse, boolean checkWarehouse) {
        PlanScopeModel planScopeModel = (PlanScopeModel)ctx.getService(PlanScopeModel.class);
        return planScopeModel.getPlanScopeByWareHouse(ctx, ss, productStorageOrgUnitID, material, isCenterWarehouseCycle, cacheKey, planScope, warehouse, checkWarehouse);
    }

    public static boolean materialPlanScopeIsEnable(String cacheValue) {
        if (cacheValue == null) {
            return false;
        }
        Object[] data = (Object[])JSON.parseObject((String)cacheValue, Object[].class);
        return MRPUtil.convert(data[17], Boolean.FALSE);
    }

    public static boolean isCenterWarehouseCycleMatch(IMRPEnvProvider ctx, RowData requireData, RowData supplyData) {
        String requireOrg = requireData.getString(DefaultField.RequireField.SUPPLYORGUNIT.getName());
        String supplyOrg = supplyData.getString(DefaultField.SupplyField.SUPPLYORGUNIT.getName());
        SupplyStruct ssr = ctx.getPriorityRelations().get(requireOrg);
        SupplyStruct sss = ctx.getPriorityRelations().get(supplyOrg);
        if (ssr != null && ssr.getInvSupplys() != null && sss != null && sss.getInvSupplys() != null) {
            for (Map.Entry<String, InvSupplyStruct> itemR : ssr.getInvSupplys().entrySet()) {
                if (!itemR.getValue().isContainsCenterWarehouse()) continue;
                String keyR = String.format("%s\u0001%s", itemR.getValue().getCenterWarehouseId(), itemR.getValue().getCenterLocationId() == null ? "" : itemR.getValue().getCenterLocationId());
                for (Map.Entry<String, InvSupplyStruct> itemS : sss.getInvSupplys().entrySet()) {
                    if (!itemS.getValue().isContainsCenterWarehouse()) continue;
                    String keyS = String.format("%s\u0001%s", itemS.getValue().getCenterWarehouseId(), itemS.getValue().getCenterLocationId() == null ? "" : itemS.getValue().getCenterLocationId());
                    return StringUtils.equals((CharSequence)keyS, (CharSequence)keyR);
                }
            }
        }
        return false;
    }

    public static boolean isInPeriod(RequireRowData requireRow, RowData supplyRow, IMRPEnvProvider ctx) {
        Boolean isStorageSupply = MRPUtil.convert(supplyRow.getValue(DefaultField.SupplyField.ISSTORAGEDATA.getName()), Boolean.FALSE);
        if (isStorageSupply.booleanValue()) {
            return true;
        }
        AdjustParameter adjustParameter = DataBalanceUtil.getAdjustParameter(ctx, requireRow);
        int advanceAdjust = adjustParameter.getAdvanceAdjust();
        int delayAdjust = adjustParameter.getDelayAdjust();
        Date supplyDate = new Date(supplyRow.getLong(DefaultField.SupplyField.DATE.getName()));
        Date requireDate = new Date(requireRow.getLong(DefaultField.RequireField.DATE.getName()));
        String supplyProductOrgUnitID = String.valueOf(supplyRow.getValue(DefaultField.SupplyField.SUPPLYORGUNIT.getName()));
        String requireOrgID = String.valueOf(requireRow.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
        OrgBasedCalendarModel sOcm = ctx.dateManager().get(requireOrgID, supplyProductOrgUnitID);
        int period = sOcm.getWorkDaySeq(requireDate);
        int advancePeriodAdjust = period + advanceAdjust;
        int delayPeriodAdjust = period - delayAdjust;
        int supplyPeriod = sOcm.getWorkDaySeq(supplyDate);
        return supplyPeriod <= advancePeriodAdjust && supplyPeriod >= delayPeriodAdjust;
    }

    public static boolean isInPeriod1(RequireRowData requireRow, RowData supplyRow, IMRPEnvProvider ctx) {
        Boolean isStorageSupply = MRPUtil.convert(supplyRow.getValue(DefaultField.SupplyField.ISSTORAGEDATA.getName()), Boolean.FALSE);
        if (isStorageSupply.booleanValue()) {
            return true;
        }
        AdjustParameter adjustParameter = DataBalanceUtil.getAdjustParameter(ctx, requireRow);
        int advanceAdjust = adjustParameter.getAdvanceAdjust();
        int delayAdjust = adjustParameter.getDelayAdjust();
        Date supplyDate = new Date(supplyRow.getLong(DefaultField.SupplyField.DATE.getName()));
        Long require = requireRow.getLong(DefaultField.RequireField.__ORIGIN_DEMAND_DATE__.getName());
        Date requireDate = new Date(require != null ? require : requireRow.getLong(DefaultField.RequireField.DATE.getName()));
        String supplyProductOrgUnitID = String.valueOf(supplyRow.getValue(DefaultField.SupplyField.SUPPLYORGUNIT.getName()));
        String requireOrgID = String.valueOf(requireRow.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
        OrgBasedCalendarModel sOcm = ctx.dateManager().get(requireOrgID, supplyProductOrgUnitID);
        int period = sOcm.getWorkDaySeq(requireDate);
        int advancePeriodAdjust = period + advanceAdjust;
        int delayPeriodAdjust = period - delayAdjust;
        int supplyPeriod = sOcm.getWorkDaySeq(supplyDate);
        return supplyPeriod <= advancePeriodAdjust && supplyPeriod >= delayPeriodAdjust;
    }

    public static boolean isEqual(Object reqVal, Object supVal) {
        if (reqVal == null && supVal == null) {
            return true;
        }
        if (reqVal == null) {
            if (supVal instanceof Number) {
                return Objects.equals(0L, MRPUtil.convert(supVal, 0L));
            }
            return StringUtils.isBlank((Object)supVal);
        }
        if (supVal == null) {
            if (reqVal instanceof Number) {
                return Objects.equals(0L, MRPUtil.convert(reqVal, 0L));
            }
            return StringUtils.isBlank((Object)reqVal);
        }
        if (supVal.getClass() != reqVal.getClass()) {
            if (supVal instanceof String) {
                reqVal = DataType.convertValue((DataType)DataType.StringType, (Object)reqVal);
            } else if (supVal instanceof Long) {
                reqVal = DataType.convertValue((DataType)DataType.LongType, (Object)reqVal);
            } else if (supVal instanceof Integer) {
                supVal = DataType.convertValue((DataType)DataType.LongType, (Object)supVal);
                reqVal = DataType.convertValue((DataType)DataType.LongType, (Object)reqVal);
            }
        }
        return ((Comparable)supVal).compareTo(reqVal) == 0;
    }

    public static BigDecimal getDetailQty(BigDecimal rQty, BigDecimal virtualQty, RequireRowData require) {
        Boolean isInvLevel = MRPUtil.convert(require.getValue(DefaultField.RequireField.__INVLEVEL_REQUIRE__.getName()), Boolean.FALSE);
        if (virtualQty == null) {
            if (require.getValue(DefaultField.RequireField.BATCHPOLICYRICHQTY.getName()) != null) {
                BigDecimal richQty = MRPUtil.convert(require.getValue(DefaultField.RequireField.BATCHPOLICYRICHQTY.getName()), BigDecimal.ZERO);
                virtualQty = rQty.subtract(richQty);
            } else {
                virtualQty = isInvLevel != null && isInvLevel != false ? MRPUtil.convert(require.getValue(DefaultField.RequireField.__INV_PO_QTY__.getName()), BigDecimal.ZERO) : rQty;
            }
        }
        return virtualQty;
    }

    public static Integer createPeriodCacheKey(IMRPEnvProvider ctx, RequireRowData requireData, RowData supply) {
        StringBuilder sb = new StringBuilder();
        sb.append(requireData.getValue(DefaultField.RequireField.DATE.getName()));
        sb.append(requireData.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()));
        sb.append(requireData.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
        sb.append(supply.getValue(DefaultField.SupplyField.SUPPLYORGUNIT.getName()));
        sb.append(supply.getValue(DefaultField.SupplyField.ISSTORAGEDATA.getName()));
        sb.append(supply.getValue(DefaultField.SupplyField.DATE.getName()));
        sb.append(supply.getValue(DefaultField.SupplyField.__WASTE_STORAGE_DEAL_TIME__.getName()));
        return sb.toString().hashCode();
    }

    public static boolean isPeriodMatch(IMRPEnvProvider ctx, RequireRowData requireData, RowData supply) {
        Integer supplyPeriod;
        MRPWorkCalendarManager wcm = ctx.dateManager();
        Date requireDate = new Date((Long)requireData.getValue(DefaultField.RequireField.DATE.getName()));
        String requireProductOrgUnitID = String.valueOf(requireData.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()));
        String requireOrgUnitID = String.valueOf(requireData.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
        String supplyProductOrgUnitID = String.valueOf(supply.getValue(DefaultField.SupplyField.SUPPLYORGUNIT.getName()));
        String requireOrgID = String.valueOf(requireData.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
        int planOutLook = ctx.getPlanOutLook();
        OrgBasedCalendarModel rOcm = wcm.get(requireProductOrgUnitID, requireOrgUnitID);
        OrgBasedCalendarModel sOcm = wcm.get(supplyProductOrgUnitID, requireOrgID);
        int periodAdjust = wcm.getPlanDatePeriod(requireProductOrgUnitID, requireOrgUnitID) + planOutLook;
        int requirePeriod = rOcm.getWorkDaySeq(requireDate);
        if (requirePeriod > periodAdjust) {
            return false;
        }
        int period = sOcm.getWorkDaySeq(requireDate);
        AdjustParameter adjustParameter = DataBalanceUtil.getAdjustParameter(ctx, requireData);
        int advanceAdjust = adjustParameter.getAdvanceAdjust();
        int delayAdjust = adjustParameter.getDelayAdjust();
        int advancePeriodAdjust = period + advanceAdjust;
        int delayPeriodAdjust = period - delayAdjust;
        Date supplyDate = new Date((Long)supply.getValue(DefaultField.SupplyField.DATE.getName()));
        if (MRPUtil.convert(supply.getValue(DefaultField.SupplyField.ISSTORAGEDATA.getName()), 0) != 0) {
            supplyPeriod = requirePeriod;
            BigDecimal dt = MRPUtil.toBigDecimal(supply.getValue(DefaultField.SupplyField.__WASTE_STORAGE_DEAL_TIME__.getName()));
            if (dt != null) {
                int n = dt.setScale(0, RoundingMode.CEILING).intValue();
                supplyPeriod = sOcm.getWorkDaySeq(sOcm.getDate(new Date(), false, n).getTime());
                supply.update(DefaultField.SupplyField.DATE.getName(), (Object)(MRPUtil.normalize(new Date()).getTime() + (long)n * 86400000L));
                if (requirePeriod < supplyPeriod) {
                    return false;
                }
                supplyPeriod = requirePeriod;
            }
        } else {
            supplyPeriod = sOcm.getWorkDaySeq(supplyDate);
        }
        return supplyPeriod <= advancePeriodAdjust && supplyPeriod >= delayPeriodAdjust;
    }
}

