/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.model.table.utils;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRValByCondition;
import kd.bos.entity.botp.CRValByConditions;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.krpc.common.utils.Stack;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mmc.mrp.common.consts.PlanScopeRelationConst;
import kd.mmc.mrp.common.util.SerializableUtils;
import kd.mmc.mrp.framework.IMRPDataMatchPlugin;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.fomula.Expr;
import kd.mmc.mrp.framework.fomula.ExprContext;
import kd.mmc.mrp.framework.fomula.token.MethodToken;
import kd.mmc.mrp.integrate.entity.CacheDatas;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.integrate.entity.RequireDataModel;
import kd.mmc.mrp.integrate.entity.SupplyDataModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.enums.ResType;
import kd.mmc.mrp.model.struct.ReplaceMaterialStruct;
import kd.mmc.mrp.model.struct.ReplaceStruct;
import kd.mmc.mrp.model.struct.SupplyStruct;
import kd.mmc.mrp.model.table.ColumnDatas;
import kd.mmc.mrp.model.table.DataBalanceTable;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.table.res.SupplymentDataTable;
import kd.mmc.mrp.model.table.utils.DataBalanceUtil;
import kd.mmc.mrp.model.wrapper.FieldMapping;
import kd.mmc.mrp.utils.MRPUtil;
import kd.mmc.mrp.utils.bitset.BitSetFactory;
import kd.mmc.mrp.utils.bitset.IntBitSet;
import org.apache.commons.lang.math.NumberUtils;

public class DataMatchUtils {
    private static Log logger = LogFactory.getLog(DataMatchUtils.class);
    public static ThreadPool fast_match_pool;
    public static final Pattern REQ_FIELD_SELECTOR;
    private static final String leftBracket = "(";
    private static final String rightBracket = ")";
    private static final String ADD = "+";
    private static final String SUBTRACT = "-";
    private static final String MULTIPLY = "*";
    private static final String DIVIDE = "/";
    private static final Map<String, Map<String, String>> priorityMap;

    public static List<Integer> findSupplysUtil(boolean isCenterWarehouseCycle, RowData requireData, IMRPEnvProvider ctx) {
        return DataMatchUtils.findSupplysUtil(isCenterWarehouseCycle, requireData, ctx, false);
    }

    public static List<Integer> findSupplysUtil(boolean isCenterWarehouseCycle, RowData requireData, IMRPEnvProvider ctx, boolean considerNullValueMatch) {
        try (TraceSpan ts = Tracer.create((String)"DataMatchUtils.findSupplysUtil", (String)"findSupplysUtil");){
            List<Integer> list = DataMatchUtils.findSupplysUtilImpl(isCenterWarehouseCycle, requireData, ctx, considerNullValueMatch);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static List<Integer> findSupplysUtilImpl(boolean isCenterWarehouseCycle, RowData requireData, IMRPEnvProvider ctx, boolean considerNullValueMatch) {
        planModel = (PlanModel)ctx.getService(PlanModel.class);
        isCenterWarehouseCycle = isCenterWarehouseCycle != false && planModel.isCenterWarehouse() != false;
        supplyTbl = ctx.supplyDatas();
        r = requireData.toMap();
        isReplace = ctx.isReplace();
        json = (String)requireData.getValue(DefaultField.RequireField.__REPLACE_STRUCT__.getName());
        replaceStruct = json == null ? null : (ReplaceStruct)SerializableUtils.fromSerializedString((String)json, ReplaceStruct.class);
        isReplace = isReplace != false && replaceStruct != null;
        orgRelation = null;
        flexMetricRelation = null;
        planScopeRelation = null;
        flexSeparator = null;
        levelTypes = null;
        rowDatas = new ArrayList<RowData>();
        rowDatas.add(requireData);
        if (isReplace) {
            list = replaceStruct.getReplaceMs() == null ? Collections.emptyList() : replaceStruct.getReplaceMs();
            for (ReplaceMaterialStruct var18_19 : list) {
                if (var18_19.getRequireRowData() == null) continue;
                rowDatas.add(var18_19.getRequireRowData());
            }
        }
        allRet = new ArrayList<Integer>(7);
        isDependentReplace = ctx.isReplace();
        var18_20 = MRPUtil.convert(ctx.getLocalParams("__MRP_PRODUCT_SUBSTITUTE__"), false);
        if (!isDependentReplace && var18_20) {
            return allRet;
        }
        isFastEnable = (Boolean)ctx.getCfgValue(EnvCfgItem.ENABLE_FAST_SUPLLY_SEARCH_MODE);
        batch = (Integer)ctx.getCfgValue(EnvCfgItem.FAST_SUPLLY_SEARCH_CNT);
        if (isFastEnable.booleanValue()) {
            var21_23 = DataMatchUtils.class;
            // MONITORENTER : kd.mmc.mrp.model.table.utils.DataMatchUtils.class
            if (DataMatchUtils.fast_match_pool == null) {
                tCount = (Integer)ctx.getCfgValue(EnvCfgItem.MRP_THREAD_COUNT);
                DataMatchUtils.fast_match_pool = ThreadPools.newCachedThreadPool((String)"mmc-mrp-DataMatchUtils-findSupplysUtil-fastMatch", (int)tCount, (int)1000);
            }
            // MONITOREXIT : var21_23
        }
        searchMId = (String)ctx.getCfgValue(EnvCfgItem.FAST_SUPLLY_SEARCH_MATERIAL_ID);
        var22_25 = rowDatas.iterator();
        block61: while (var22_25.hasNext() != false) {
            block117: {
                block119: {
                    block118: {
                        row = (RowData)var22_25.next();
                        supplys = null;
                        isDepentReq = MRPUtil.convert(row.getValue(DefaultField.RequireField.ISDEPENTREQ.getName()), false);
                        fieldMappingList = new ArrayList<FieldMapping>(ctx.r2s(isDepentReq != false && var18_20 != false));
                        localCache = null;
                        hash = null;
                        key = new StringBuilder();
                        quickSupplys = null;
                        if (!isFastEnable.booleanValue()) ** GOTO lbl70
                        var31_34 = ctx;
                        // MONITORENTER : var31_34
                        localCache = (HashMap<Integer, List<Integer>>)ctx.getLocalParams("kd.mmc.mrp.model.table.utils.DataMatchUtils.findSupplysUtilImpl");
                        if (localCache == null) {
                            localCache = new HashMap<Integer, List<Integer>>(7);
                            ctx.putLocalParam("kd.mmc.mrp.model.table.utils.DataMatchUtils.findSupplysUtilImpl", localCache);
                        }
                        // MONITOREXIT : var31_34
                        i = 0;
                        while (true) {
                            block124: {
                                block125: {
                                    block123: {
                                        if (i >= fieldMappingList.size()) break block123;
                                        relation = (FieldMapping)fieldMappingList.get(i);
                                        key.append(relation.getFrom()).append(": ").append(row.getValue(relation.getFrom())).append("-");
                                        fStr = relation.getFormulaValue();
                                        if (fStr == null || fStr.trim().length() == 0) break block124;
                                        m = DataMatchUtils.REQ_FIELD_SELECTOR.matcher(fStr);
                                        break block125;
                                    }
                                    hash = key.toString().hashCode();
                                    quickSupplys = (List)localCache.get(hash);
lbl70:
                                    // 2 sources

                                    if (quickSupplys == null) {
                                        break;
                                    }
                                    if (searchMId.equals(row.getString(DefaultField.RequireField.MATERIAL.getName()))) {
                                        DataMatchUtils.logger.warn(String.format("mrprunner-fastMatch-origin, billno=[%s], key=[%s], hash=[%s], supplys=[%s]", new Object[]{row.getString(DefaultField.RequireField.BILLNUMBER.getName()), key.toString(), hash, DataMatchUtils.list2String(supplyTbl, quickSupplys)}));
                                    }
                                    copy = new ArrayList<Integer>(quickSupplys.size());
                                    ts = Tracer.create((String)"DataMatchUtils.findSupplysUtil-fastMatch-filter", (String)"findSupplysUtil-fastMatch-filter");
                                    var33_39 = null;
                                    try {
                                        for (Integer next : quickSupplys) {
                                            if (MRPUtil.convert(supplyTbl.getValue(DefaultField.SupplyField.__IS_OCCUPIED__.getName(), next), Boolean.FALSE).booleanValue()) continue;
                                            copy.add(next);
                                        }
                                    }
                                    catch (Throwable var34_48) {
                                        var33_39 = var34_48;
                                        throw var34_48;
                                    }
                                    finally {
                                        if (ts != null) {
                                            if (var33_39 != null) {
                                                try {
                                                    ts.close();
                                                }
                                                catch (Throwable var34_47) {
                                                    var33_39.addSuppressed(var34_47);
                                                }
                                            } else {
                                                ts.close();
                                            }
                                        }
                                    }
                                    allRet.addAll(copy);
                                    if (!searchMId.equals(row.getString(DefaultField.RequireField.MATERIAL.getName()))) continue block61;
                                    DataMatchUtils.logger.warn(String.format("mrprunner-fastMatch-filter, billno=[%s], key=[%s], hash=[%s], supplys=[%s]", new Object[]{row.getString(DefaultField.RequireField.BILLNUMBER.getName()), key.toString(), hash, DataMatchUtils.list2String(supplyTbl, copy)}));
                                    continue block61;
                                }
                                while (m.find()) {
                                    field = new StringBuilder();
                                    pos = m.end();
                                    while (pos < fStr.length() && (Character.isLetterOrDigit(c = fStr.charAt(pos++)) || c == '_')) {
                                        field.append(c);
                                    }
                                    f = field.toString().toUpperCase(Locale.ENGLISH);
                                    v = row.getValue(f) == null ? row.getValue("ENTRYENTITY." + f) : row.getValue(f);
                                    key.append(relation.getFrom()).append(": ").append(v).append("-");
                                }
                            }
                            ++i;
                        }
                        for (i = 0; i < fieldMappingList.size(); ++i) {
                            relation = (FieldMapping)fieldMappingList.get(i);
                            formula = relation.getValueFormula();
                            sCol = supplyTbl.getCol(relation.getTo());
                            if (isFastEnable.booleanValue()) {
                                sCol.setFastBatch(batch);
                            }
                            if (isCenterWarehouseCycle && (StringUtils.equalsIgnoreCase((CharSequence)relation.getFrom(), (CharSequence)DefaultField.RequireField.SUPPLYORGUNIT.getName()) || StringUtils.equalsIgnoreCase((CharSequence)relation.getFrom(), (CharSequence)DefaultField.RequireField.PRODUCTIONORGUNIT.getName()))) {
                                orgRelation = relation;
                                continue;
                            }
                            if (StringUtils.equalsIgnoreCase((CharSequence)relation.getFrom(), (CharSequence)DefaultField.RequireField.PLANSCOPE.getName())) {
                                planScopeRelation = relation;
                                continue;
                            }
                            if (!"5".equals(relation.getConverttype())) {
                                value = row.getValue(relation.getFrom());
                                supplys = sCol.getAsBitSet(r, supplyTbl, supplys, value, formula, considerNullValueMatch != false && relation.isNullValueMatch() != false);
                            }
                            if ("5".equals(relation.getConverttype()) && supplys != null && isDependentReplace && var18_20 && isDepentReq) {
                                flexMetricRelation = relation;
                                flexSupplys = BitSetFactory.createIntBitSet();
                                iter = supplys.iterator();
                                while (iter.hasNext()) {
                                    idx = iter.next();
                                    supply = supplyTbl.fetchRow(idx);
                                    supplyData = supply.toMap();
                                    exprCtx = new ExprContext();
                                    exprCtx.addPreDefinedParam("requireData", requireData);
                                    exprCtx.addPreDefinedParam("supplyData", supplyData);
                                    exprCtx.addPreDefinedParam("__MRP_CTX_ID__", ctx);
                                    result = (Object[])formula.execute(exprCtx);
                                    if (MRPUtil.isTrue(result[0])) {
                                        flexSupplys.set(idx);
                                    }
                                    flexSeparator = (String)result[1];
                                    levelTypes = (Object[])result[2];
                                }
                                supplys = flexSupplys;
                                continue;
                            }
                            if (!"5".equals(relation.getConverttype()) || !var18_20) continue;
                            supplys = null;
                        }
                        ret = new ArrayList<Integer>(supplys == null ? 0 : supplys.cardinate());
                        if (supplys != null) {
                            bomIter = supplys.iterator();
                            while (bomIter.hasNext()) {
                                idx = bomIter.next();
                                ret.add((Integer)idx);
                            }
                        }
                        ts = Tracer.create((String)"DataMatchUtils.findSupplysUtil-storageCheck", (String)"findSupplysUtil-storageCheck");
                        idx = null;
                        try {
                            if (orgRelation != null && !ret.isEmpty()) {
                                iterator = ret.iterator();
                                while (iterator.hasNext()) {
                                    supplyData = supplyTbl.fetchRow((Integer)iterator.next());
                                    isMatch = DataMatchUtils.isMatch4Relation(row, supplyData, orgRelation);
                                    if (isMatch || DataBalanceUtil.isCenterWarehouseCycleMatch(ctx, row, supplyData)) continue;
                                    iterator.remove();
                                }
                            }
                        }
                        catch (Throwable iterator) {
                            idx = iterator;
                            throw iterator;
                        }
                        finally {
                            if (ts != null) {
                                if (idx != null) {
                                    try {
                                        ts.close();
                                    }
                                    catch (Throwable iterator) {
                                        idx.addSuppressed(iterator);
                                    }
                                } else {
                                    ts.close();
                                }
                            }
                        }
                        ts = Tracer.create((String)"DataMatchUtils.findSupplysUtil-planScopeCheck", (String)"findSupplysUtil-planScopeCheck");
                        idx = null;
                        try {
                            if (!planModel.isEnablePlanScope() || planScopeRelation == null || ret.isEmpty()) break block117;
                            productStorageOrgUnitID = DataBalanceUtil.getPlanScopeRequireOrg(row);
                            material = String.valueOf(row.getValue(DefaultField.RequireField.MATERIAL.getName()));
                            cacheKey = PlanScopeRelationConst.getRedisPlanScopeRelationKey((String)productStorageOrgUnitID.toString(), (String)material);
                            ss = planModel.getPriorityRelations().getOrDefault(productStorageOrgUnitID.toString(), new SupplyStruct());
                            planScopeRelation.setTo(DefaultField.SupplyField.DYNAMIC_PLANSCOPE.getName());
                            size = ret.size() / batch + 1;
                            if (size > 1 && isFastEnable.booleanValue()) {
                                newRet = new ArrayList<Integer>(ret.size());
                                list = new ArrayList<Iterator<Integer>>(size);
                                from = 0;
                                for (i = 0; i < size; ++i) {
                                    to = from + batch;
                                    if (to > ret.size()) {
                                        to = ret.size();
                                    }
                                    if (from >= to) continue;
                                    list.add(new ArrayList<Integer>(ret.subList(from, to)).iterator());
                                    from += batch.intValue();
                                }
                                tasks = new ArrayList<Future>(list.size());
                                for (Iterator var44_76 : list) {
                                    task = DataMatchUtils.fast_match_pool.submit((Callable)new TaskWorker(var44_76, newRet, supplyTbl, ctx, ss, productStorageOrgUnitID, (String)material, isCenterWarehouseCycle, cacheKey, row, planScopeRelation), RequestContext.get());
                                    tasks.add(task);
                                }
                                var43_72 = tasks.iterator();
                                break block118;
                            }
                            iterator = ret.iterator();
                            while (iterator.hasNext()) {
                                supplyData = supplyTbl.fetchRow(iterator.next());
                                planScope = DataBalanceUtil.getSupplyPlanScope(ctx, ss, productStorageOrgUnitID, (String)material, isCenterWarehouseCycle, cacheKey, supplyData);
                                if (planScope == null) {
                                    iterator.remove();
                                    continue;
                                }
                                supplyData.update(DefaultField.SupplyField.DYNAMIC_PLANSCOPE.getName(), (Object)planScope);
                                isMatch = DataMatchUtils.isMatch4Relation(row, supplyData, planScopeRelation);
                                if (isMatch) continue;
                                iterator.remove();
                            }
                            break block119;
                        }
                        catch (Throwable productStorageOrgUnitID) {
                            idx = productStorageOrgUnitID;
                            throw productStorageOrgUnitID;
                        }
                    }
                    while (var43_72.hasNext()) {
                        var44_77 = (Future)var43_72.next();
                        try {
                            var44_77.get();
                        }
                        catch (Throwable e) {
                            throw new RuntimeException("mrprunner-fast-match-failed.", e);
                        }
                    }
                    ret = newRet;
                }
                planScopeRelation.setTo(DefaultField.SupplyField.PLANSCOPE.getName());
                break block117;
                finally {
                    if (ts != null) {
                        if (idx != null) {
                            try {
                                ts.close();
                            }
                            catch (Throwable productStorageOrgUnitID) {
                                idx.addSuppressed(productStorageOrgUnitID);
                            }
                        } else {
                            ts.close();
                        }
                    }
                }
            }
            ts = Tracer.create((String)"DataMatchUtils.findSupplysUtil-flexCheck", (String)"findSupplysUtil-flexCheck");
            idx = null;
            try {
                ret = ctx.getFlexDataTable().findSupplys(row, ret);
                if (flexMetricRelation != null && !ret.isEmpty()) {
                    MethodToken.sortSupplys(ctx, flexMetricRelation, requireData, ret, levelTypes, flexSeparator);
                }
                if ((plugin = ctx.getMatchResolver()) != null) {
                    ret = plugin.resolveSupplys(ctx, row, ret);
                }
            }
            catch (Throwable plugin) {
                idx = plugin;
                throw plugin;
            }
            finally {
                if (ts != null) {
                    if (idx != null) {
                        try {
                            ts.close();
                        }
                        catch (Throwable plugin) {
                            idx.addSuppressed(plugin);
                        }
                    } else {
                        ts.close();
                    }
                }
            }
            if (isFastEnable.booleanValue()) {
                strategy = row.getValue(DefaultField.RequireField.PLAN_STRATEGY.getName());
                if (strategy == null) {
                    strategy = row.getValue(DefaultField.RequireField.DEFAULT_PLAN_STRATEGY.getName());
                }
                requireProductOrgUnitID = String.valueOf(row.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()));
                ts = Tracer.create((String)"DataMatchUtils.findSupplysUtil-preSort-priority", (String)"findSupplysUtil-preSort-priority");
                material = null;
                try {
                    ret = ctx.sortByPriority(supplyTbl, requireProductOrgUnitID, ret, strategy == null ? null : String.valueOf(strategy), isCenterWarehouseCycle);
                }
                catch (Throwable var36_55) {
                    material = var36_55;
                    throw var36_55;
                }
                finally {
                    if (ts != null) {
                        if (material != null) {
                            try {
                                ts.close();
                            }
                            catch (Throwable var36_54) {
                                material.addSuppressed(var36_54);
                            }
                        } else {
                            ts.close();
                        }
                    }
                }
                ts = Tracer.create((String)"DataMatchUtils.findSupplysUtil-preSort-values", (String)"findSupplysUtil-preSort-values");
                material = null;
                try {
                    ret.sort(new SupplySortComparator(ctx));
                    localCache.put(hash, ret);
                    if (searchMId.equals(row.getString(DefaultField.RequireField.MATERIAL.getName()))) {
                        DataMatchUtils.logger.warn(String.format("mrprunner-firstMatch, billno=[%s], key=[%s], hash=[%s], supplys=[%s]", new Object[]{row.getString(DefaultField.RequireField.BILLNUMBER.getName()), key.toString(), hash, DataMatchUtils.list2String(supplyTbl, ret)}));
                    }
                }
                catch (Throwable var36_57) {
                    material = var36_57;
                    throw var36_57;
                }
                finally {
                    if (ts != null) {
                        if (material != null) {
                            try {
                                ts.close();
                            }
                            catch (Throwable var36_56) {
                                material.addSuppressed(var36_56);
                            }
                        } else {
                            ts.close();
                        }
                    }
                }
            }
            allRet.addAll(ret);
        }
        return allRet;
    }

    private static String list2String(SupplymentDataTable supplyTbl, List<Integer> list) {
        StringBuilder sb = new StringBuilder();
        for (Integer idx : list) {
            sb.append(idx).append(",");
            Boolean isInvData = MRPUtil.convert(supplyTbl.getValue(DefaultField.SupplyField.ISSTORAGEDATA.getName(), idx), Boolean.FALSE);
            if (!isInvData.booleanValue()) continue;
            logger.warn(String.format("mrprunner-fastMatch-storage: idx: %s, data: %s", idx, supplyTbl.fetchRow(idx).toString()));
        }
        return sb.toString();
    }

    public static boolean isMatch4Relation(RowData require, RowData supply, FieldMapping orgRelation) {
        Object reqVal = require.getValue(orgRelation.getFrom());
        Object supVal = supply.getValue(orgRelation.getTo());
        boolean isMatch = true;
        if (!DataBalanceUtil.isEqual(reqVal, supVal)) {
            Expr formula = orgRelation.getValueFormula();
            if (formula == null) {
                isMatch = false;
            } else {
                ExprContext exprCtx = new ExprContext();
                exprCtx.addPreDefinedParam("requireData", require.toMap());
                exprCtx.addPreDefinedParam("supplyData", supply.toMap());
                Object result = formula.execute(exprCtx);
                if (MRPUtil.isTrue(result)) {
                    isMatch = false;
                }
            }
        }
        return isMatch;
    }

    public static int findBOM(IMRPEnvProvider ctx, StringBuilder keyBuffer, Map<String, Integer> bomCache, RowData requireData) {
        int ret;
        Map<String, Object> r = requireData.toMap();
        keyBuffer.setLength(0);
        FieldMapping mFm = null;
        FieldMapping orgRequireFm = null;
        FieldMapping orgSupplyFm = null;
        ArrayList<FieldMapping> mappings = new ArrayList<FieldMapping>(ctx.b2r());
        Iterator iter = mappings.iterator();
        ArrayList<FieldMapping> userDefines = new ArrayList<FieldMapping>(3);
        while (iter.hasNext()) {
            FieldMapping relation = (FieldMapping)iter.next();
            Object value = requireData.getValue(relation.getFrom());
            keyBuffer.append(String.valueOf(value));
            if (DefaultField.RequireField.MATERIAL.getName().equals(relation.getFrom())) {
                mFm = relation;
                iter.remove();
                continue;
            }
            if (DefaultField.RequireField.SUPPLYORGUNIT.getName().equals(relation.getFrom())) {
                orgSupplyFm = relation;
                iter.remove();
                continue;
            }
            if (DefaultField.RequireField.PRODUCTIONORGUNIT.getName().equals(relation.getFrom())) {
                orgRequireFm = relation;
                iter.remove();
                continue;
            }
            userDefines.add(relation);
        }
        boolean isFlexPropMatch = (Boolean)ctx.getCfgValue(EnvCfgItem.ENABLE_MATERIAL_EXT_PROPS);
        if (isFlexPropMatch && requireData.get(DefaultField.RequireField.MATERIALFLEXPROPS.getName()) != null) {
            keyBuffer.append(String.valueOf(requireData.get(DefaultField.RequireField.MATERIALFLEXPROPS.getName())));
        }
        ctx.getFlexDataTable().appendBOMCacheKey(requireData, keyBuffer);
        if (bomCache.containsKey(keyBuffer.toString())) {
            return bomCache.get(keyBuffer.toString());
        }
        if (mFm == null) {
            return -1;
        }
        IntBitSet boms = DataMatchUtils.search(ctx, requireData, r, null, mFm);
        if (boms.cardinate() == 0) {
            return -1;
        }
        if ((boms = DataMatchUtils.searchByOrg(ctx, requireData, r, boms, orgRequireFm)).cardinate() == 0) {
            return -1;
        }
        if ((boms = DataMatchUtils.searchByOrg(ctx, requireData, r, boms, orgSupplyFm)).cardinate() == 0) {
            return -1;
        }
        for (FieldMapping relation : userDefines) {
            if ((boms = DataMatchUtils.search(ctx, requireData, r, boms, relation)).cardinate() != 0) continue;
            return -1;
        }
        List<Integer> arr = ColumnDatas.toList(boms);
        arr = ctx.getFlexDataTable().findBOM(requireData, arr);
        IMRPDataMatchPlugin plugin = ctx.getMatchResolver();
        if (plugin != null) {
            arr = plugin.resolveBoms(ctx, requireData, arr);
        }
        if ((ret = ctx.bomDatas().searchBOM(arr, requireData).intValue()) >= 0) {
            bomCache.put(keyBuffer.toString(), ret);
        }
        return ret;
    }

    private static IntBitSet searchByOrg(IMRPEnvProvider ctx, RowData requireData, Map<String, Object> r, IntBitSet boms, FieldMapping orgFm) {
        if (orgFm != null) {
            IntBitSet boms2 = DataMatchUtils.search(ctx, requireData, r, boms, orgFm);
            Long orgId = MRPUtil.convert(requireData.getValue(orgFm.getFrom()), 0L);
            Iterator<Integer> bomIter = boms.iterator();
            while (bomIter.hasNext()) {
                int bomIdx = bomIter.next();
                Long bomFid = MRPUtil.convert(ctx.bomDatas().getValue(DefaultField.BOMField.__SUPER_BOMID__.getName(), bomIdx), 0L);
                if (bomFid <= 0L) {
                    bomFid = MRPUtil.convert(ctx.bomDatas().getValue(DefaultField.BOMField.BOMID.getName(), bomIdx), 0L);
                }
                if (!ctx.bomDatas().isUsableBom(bomFid, orgId)) continue;
                boms2.set(bomIdx);
            }
            boms = boms2;
        }
        return boms;
    }

    private static IntBitSet search(IMRPEnvProvider ctx, RowData require, Map<String, Object> r, IntBitSet boms, FieldMapping fm) {
        Object value = require.getValue(fm.getFrom());
        ColumnDatas sCol = ctx.bomDatas().getCol(fm.getTo());
        return sCol.getAsBitSet(r, ctx.bomDatas(), boms, value, fm.getValueFormula());
    }

    public static List<Integer> findBOMChildren(IMRPEnvProvider ctx, Map<String, List<Integer>> bomChildrenCache, String bomFID) {
        if (bomChildrenCache.containsKey(bomFID)) {
            return new ArrayList<Integer>((Collection)bomChildrenCache.get(bomFID));
        }
        ctx.bomDatas().setFilter(null);
        List<Integer> ret = ctx.bomDatas().getCol(DefaultField.BOMField.BOMID.getName()).get(new BigDecimal(bomFID));
        bomChildrenCache.put(bomFID, ret);
        return new ArrayList<Integer>(ret);
    }

    public static RowData rsMappingToSupply(IMRPEnvProvider ctx, DataBalanceTable.RSMapping rsMapping) {
        ArrayList<DataBalanceTable.RSMapping> dealMappings = new ArrayList<DataBalanceTable.RSMapping>(1);
        dealMappings.add(rsMapping);
        RequireRowData requireRowData = rsMapping.getRequire();
        List<FieldMapping> r2s = ctx.r2s();
        List<Map<String, Object>> result = ctx.createMappingSaver().saveMapping(ctx, dealMappings);
        if (rsMapping.getPoList() != null) {
            rsMapping.getPoList().clear();
        }
        if (result != null && !result.isEmpty()) {
            RowData supply = DataMatchUtils.po2SupplyData(ctx, result.get(0));
            for (FieldMapping relation : r2s) {
                if (StringUtils.equalsIgnoreCase((CharSequence)relation.getFrom(), (CharSequence)DefaultField.RequireField.MATERIAL.getName()) || StringUtils.equalsIgnoreCase((CharSequence)relation.getFrom(), (CharSequence)DefaultField.RequireField.SUPPLYORGUNIT.getName()) || StringUtils.equalsIgnoreCase((CharSequence)relation.getFrom(), (CharSequence)DefaultField.RequireField.PRODUCTIONORGUNIT.getName()) || StringUtils.isBlank((CharSequence)relation.getFrom()) || StringUtils.isBlank((CharSequence)relation.getTo())) continue;
                supply.update(relation.getTo().toUpperCase(Locale.ENGLISH), requireRowData.getValue(relation.getFrom().toUpperCase(Locale.ENGLISH)));
            }
            RequireDataModel requireDataModel = (RequireDataModel)ctx.getService(RequireDataModel.class);
            ctx.supplyDatas().afterFillRowImpl(supply.getValues(), requireDataModel.getOutputType(), ResManager.loadKDString((String)"\u65b0\u5efa\u8ba1\u5212\u8ba2\u5355", (String)"DataMatchUtils_0", (String)"mmc-mrp-mservice", (Object[])new Object[0]), null);
            ctx.loadSupplyMaterialExtProps(supply);
            return supply;
        }
        return DataMatchUtils.getEmptySupplyData(ctx);
    }

    public static RowData requireToSupply(IMRPEnvProvider ctx, RequireRowData require, BigDecimal qty) {
        if (qty != null) {
            require.update(DefaultField.RequireField.QTY.getName(), (Object)qty);
        }
        DataBalanceTable.RSMapping mapping = new DataBalanceTable.RSMapping();
        mapping.setRequire(require);
        mapping.setCopied(false);
        BigDecimal rQty = MRPUtil.toBigDecimal(require.getValue(DefaultField.RequireField.QTY.getName()));
        mapping.setrQty(rQty.compareTo(BigDecimal.ZERO) <= 0 ? BigDecimal.ONE : rQty);
        mapping.setMt(DataBalanceTable.MatchType.LESS);
        return DataMatchUtils.rsMappingToSupply(ctx, mapping);
    }

    public static RowData requireToSupply(IMRPEnvProvider ctx, RequireRowData require) {
        return DataMatchUtils.requireToSupply(ctx, require, null);
    }

    private static RowData getEmptySupplyData(IMRPEnvProvider ctx) {
        SupplyDataModel supplyDataModel = (SupplyDataModel)ctx.getService(SupplyDataModel.class);
        Map<String, Integer> columns = supplyDataModel.getTable().getColIdx();
        Object[] values = new Object[columns.size()];
        return new RowData(supplyDataModel.getTable().getSrcDatas(), columns, values, -1, ResType.SUPPLY);
    }

    public static RowData po2SupplyData(IMRPEnvProvider ctx, Map<String, Object> poHeader) {
        SupplyDataModel supplyDataModel = (SupplyDataModel)ctx.getService(SupplyDataModel.class);
        List<FieldMapping> po2s = supplyDataModel.getPo2s();
        RequireDataModel requireDataModel = (RequireDataModel)ctx.getService(RequireDataModel.class);
        String outputEntity = requireDataModel.getOutputType();
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)outputEntity);
        Map allFields = mainEntityType.getAllFields();
        RowData supply = DataMatchUtils.getEmptySupplyData(ctx);
        String from = null;
        String to = null;
        String formulaValue = null;
        block0: for (FieldMapping fieldMapping : po2s) {
            from = fieldMapping.getFrom();
            to = fieldMapping.getTo();
            formulaValue = fieldMapping.getFormulaValue();
            if ("3".equals(fieldMapping.getConverttype())) {
                supply.update(to.toUpperCase(Locale.ENGLISH), (Object)formulaValue);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)from) && StringUtils.isNotBlank((CharSequence)to)) {
                supply.update(to.toUpperCase(Locale.ENGLISH), poHeader.get(from.toLowerCase(Locale.ENGLISH)));
                continue;
            }
            if ("2".equals(fieldMapping.getConverttype())) {
                String json = fieldMapping.getFormulaValue();
                CRValByConditions valByConditions = (CRValByConditions)SerializationUtils.fromJsonString((String)json, CRValByConditions.class);
                List conditionList = valByConditions.getItems();
                for (CRValByCondition condition : conditionList) {
                    FilterCondition filterCondition = condition.getCondition().getFilterCondition();
                    FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, filterCondition);
                    UserService userService = new UserService();
                    filterBuilder.setUserService((IUserService)userService);
                    filterBuilder.buildFilter(false);
                    QFilter filterBuilderQFilter = filterBuilder.getQFilter();
                    String expression = null;
                    if (condition.getFormula() == null || StringUtils.isEmpty((CharSequence)condition.getFormula().getExpression())) continue;
                    expression = condition.getFormula().getExpression();
                    expression = expression.replace(outputEntity + '.', "").trim();
                    if (filterBuilderQFilter != null && !DataMatchUtils.checkQFilter(filterBuilderQFilter, ctx, poHeader, allFields)) continue;
                    supply.update(to.toUpperCase(Locale.ENGLISH), DataMatchUtils.getFormValue(poHeader, expression, ctx, allFields));
                    continue block0;
                }
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)to) || !StringUtils.isNotBlank((CharSequence)formulaValue)) continue;
            formulaValue = formulaValue.replace(outputEntity + '.', "").trim();
            supply.update(to.toUpperCase(Locale.ENGLISH), DataMatchUtils.getFormValue(poHeader, formulaValue, ctx, allFields));
        }
        supply.update(DefaultField.SupplyField.INV_IS_TRACK_MATCH.getName(), (Object)true);
        return supply;
    }

    private static boolean checkQFilter(QFilter qFilter, IMRPEnvProvider ctx, Map<String, Object> poHeader, Map<String, IDataEntityProperty> allFields) {
        List list = qFilter.getNests(false);
        String property = qFilter.getProperty();
        Object value = qFilter.getValue();
        if (value != null && poHeader.containsKey(value.toString().split("\\.")[0])) {
            value = DataMatchUtils.getFormValue(poHeader, value.toString(), ctx, allFields);
        }
        if (value instanceof Timestamp) {
            value = ((Timestamp)value).getTime();
        } else if (value instanceof Date) {
            value = ((Date)value).getTime();
        }
        Object formValue = DataMatchUtils.getFormValue(poHeader, property, ctx, allFields);
        boolean check = false;
        if (StringUtils.equals((CharSequence)"=", (CharSequence)qFilter.getCP())) {
            check = StringUtils.equals((CharSequence)DataMatchUtils.objectValueToString(formValue), (CharSequence)DataMatchUtils.objectValueToString(value));
        } else if (StringUtils.equals((CharSequence)"!=", (CharSequence)qFilter.getCP()) || StringUtils.equals((CharSequence)"<>", (CharSequence)qFilter.getCP())) {
            check = !StringUtils.equals((CharSequence)DataMatchUtils.objectValueToString(formValue), (CharSequence)DataMatchUtils.objectValueToString(value));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"like", (CharSequence)qFilter.getCP()) || StringUtils.equalsIgnoreCase((CharSequence)"ftlike", (CharSequence)qFilter.getCP())) {
            check = StringUtils.contains((CharSequence)DataMatchUtils.objectValueToString(formValue), (CharSequence)DataMatchUtils.objectValueToString(value));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"not like", (CharSequence)qFilter.getCP())) {
            check = !StringUtils.contains((CharSequence)DataMatchUtils.objectValueToString(formValue), (CharSequence)DataMatchUtils.objectValueToString(value));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"is null", (CharSequence)qFilter.getCP())) {
            check = StringUtils.isBlank((Object)formValue);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"is not null", (CharSequence)qFilter.getCP())) {
            check = StringUtils.isNotBlank((Object)formValue);
        } else if (StringUtils.equals((CharSequence)">", (CharSequence)qFilter.getCP())) {
            check = DataMatchUtils.objectValueToString(formValue).compareTo(DataMatchUtils.objectValueToString(value)) > 0;
        } else if (StringUtils.equals((CharSequence)">=", (CharSequence)qFilter.getCP())) {
            check = DataMatchUtils.objectValueToString(formValue).compareTo(DataMatchUtils.objectValueToString(value)) >= 0;
        } else if (StringUtils.equals((CharSequence)"<", (CharSequence)qFilter.getCP())) {
            check = DataMatchUtils.objectValueToString(formValue).compareTo(DataMatchUtils.objectValueToString(value)) < 0;
        } else if (StringUtils.equals((CharSequence)"<=", (CharSequence)qFilter.getCP())) {
            check = DataMatchUtils.objectValueToString(formValue).compareTo(DataMatchUtils.objectValueToString(value)) <= 0;
        } else if ((StringUtils.equalsIgnoreCase((CharSequence)"in", (CharSequence)qFilter.getCP()) || StringUtils.equalsIgnoreCase((CharSequence)"not in", (CharSequence)qFilter.getCP())) && value instanceof Collection) {
            boolean isIn = StringUtils.equalsIgnoreCase((CharSequence)"in", (CharSequence)qFilter.getCP());
            boolean isContains = false;
            for (Object v : (Collection)value) {
                if (!StringUtils.equals((CharSequence)DataMatchUtils.objectValueToString(formValue), (CharSequence)DataMatchUtils.objectValueToString(v))) continue;
                isContains = true;
                break;
            }
            check = isIn == isContains;
        }
        for (QFilter.QFilterNest qFilterNest : list) {
            if (qFilterNest.isAnd()) {
                check = check && DataMatchUtils.checkQFilter(qFilterNest.getFilter(), ctx, poHeader, allFields);
                continue;
            }
            if (check) continue;
            check = DataMatchUtils.checkQFilter(qFilterNest.getFilter(), ctx, poHeader, allFields);
        }
        return check;
    }

    private static String objectValueToString(Object value) {
        return value == null ? "" : value.toString();
    }

    private static Object getFormValue(Map<String, Object> poHeader, String formulaValue, IMRPEnvProvider ctx, Map<String, IDataEntityProperty> allFields) {
        if (poHeader.containsKey(formulaValue.toLowerCase(Locale.ENGLISH))) {
            return poHeader.get(formulaValue.toLowerCase(Locale.ENGLISH));
        }
        Object value = null;
        String[] strs = formulaValue.split("\\.");
        IDataEntityProperty property = allFields.get(strs[0].toLowerCase(Locale.ENGLISH));
        if (strs.length == 2 && poHeader.containsKey(strs[0].toLowerCase(Locale.ENGLISH)) && property != null) {
            Object F7Id = poHeader.get(strs[0].toLowerCase(Locale.ENGLISH));
            CacheDatas cacheDatas = (CacheDatas)ctx.getService(CacheDatas.class);
            if (F7Id != null && property instanceof BasedataProp) {
                F7Id = NumberUtils.isNumber((String)F7Id.toString()) ? MRPUtil.convert(F7Id, 0L) : F7Id.toString();
                DynamicObject data = cacheDatas.reloadDataById(((BasedataProp)property).getBaseEntityId(), F7Id, strs[1].toLowerCase(Locale.ENGLISH));
                if (data != null) {
                    value = data.get(strs[1].toLowerCase(Locale.ENGLISH));
                }
            }
        } else {
            value = DataMatchUtils.evaluateExpression(poHeader, formulaValue);
        }
        return value;
    }

    private static String priority(String op1, String op2) {
        return priorityMap.get(op1).get(op2);
    }

    private static void process(Map<String, Object> valueMap, String token, Stack<BigDecimal> numStack, Stack<String> optStack) {
        while (!token.equals("#") || !"#".equals(optStack.peek())) {
            if (DataMatchUtils.isNumber(token)) {
                numStack.push((Object)MRPUtil.toBigDecimal(token));
                break;
            }
            if (valueMap.containsKey(token)) {
                numStack.push((Object)MRPUtil.toBigDecimal(valueMap.get(token)));
                break;
            }
            String priority = DataMatchUtils.priority((String)optStack.peek(), token);
            if ("<".equals(priority)) {
                optStack.push((Object)token);
                break;
            }
            if ("=".equals(priority)) {
                optStack.pop();
                break;
            }
            BigDecimal res = DataMatchUtils.calculate((String)optStack.pop(), (BigDecimal)numStack.pop(), (BigDecimal)numStack.pop());
            numStack.push((Object)res);
        }
    }

    public static boolean isNumber(String token) {
        int LEN = token.length();
        for (int ix = 0; ix < LEN; ++ix) {
            char ch = token.charAt(ix);
            if (ch == '.' || DataMatchUtils.isNumber(ch)) continue;
            return false;
        }
        return true;
    }

    private static boolean isNumber(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private static BigDecimal calculate(String opt, BigDecimal n1, BigDecimal n2) {
        if (ADD.equals(opt)) {
            return n2.add(n1);
        }
        if (SUBTRACT.equals(opt)) {
            return n2.subtract(n1);
        }
        if (MULTIPLY.equals(opt)) {
            return n2.multiply(n1);
        }
        if (DIVIDE.equals(opt)) {
            return n2.divide(n1, 10, 1);
        }
        throw new RuntimeException("unsupported operator:" + opt);
    }

    public static Object evaluateExpression(Map<String, Object> valueMap, String formulaValue) {
        String formula = formulaValue.toLowerCase(Locale.ENGLISH).replaceAll("\\s*", "");
        if (StringUtils.equalsIgnoreCase((CharSequence)formula, (CharSequence)"now()")) {
            return System.currentTimeMillis();
        }
        char[] newFormula = new char[formula.length() * 2 + 1];
        int index = 0;
        boolean isExpr = false;
        block11: for (int i = 0; i < formula.length(); ++i) {
            String c;
            switch (c = String.valueOf(formula.charAt(i))) {
                case "+": 
                case "-": 
                case "*": 
                case "/": 
                case "(": 
                case ")": {
                    isExpr = true;
                    if (index > 0 && newFormula[index - 1] != ' ') {
                        newFormula[index++] = 32;
                    }
                    newFormula[index++] = formula.charAt(i);
                    newFormula[index++] = 32;
                    continue block11;
                }
                default: {
                    newFormula[index++] = formula.charAt(i);
                }
            }
        }
        if (!isExpr) {
            return formulaValue.replaceAll("'", "").replaceAll("\"", "");
        }
        formula = String.format("%s %s", String.valueOf(newFormula, 0, index), "#");
        Stack numStack = new Stack();
        Stack optStack = new Stack();
        optStack.push((Object)"#");
        StringTokenizer st = new StringTokenizer(formula);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            DataMatchUtils.process(valueMap, token, (Stack<BigDecimal>)numStack, (Stack<String>)optStack);
        }
        return numStack.pop();
    }

    static {
        REQ_FIELD_SELECTOR = Pattern.compile("@requireData\\.#");
        priorityMap = new HashMap<String, Map<String, String>>(4);
        HashMap<String, String> subMap = new HashMap<String, String>();
        subMap.put(ADD, ">");
        subMap.put(SUBTRACT, ">");
        subMap.put(MULTIPLY, "<");
        subMap.put(DIVIDE, "<");
        subMap.put(leftBracket, "<");
        subMap.put(rightBracket, ">");
        subMap.put("#", ">");
        priorityMap.put(ADD, subMap);
        subMap = new HashMap();
        subMap.put(ADD, ">");
        subMap.put(SUBTRACT, ">");
        subMap.put(MULTIPLY, "<");
        subMap.put(DIVIDE, "<");
        subMap.put(leftBracket, "<");
        subMap.put(rightBracket, ">");
        subMap.put("#", ">");
        priorityMap.put(SUBTRACT, subMap);
        subMap = new HashMap();
        subMap.put(ADD, ">");
        subMap.put(SUBTRACT, ">");
        subMap.put(MULTIPLY, ">");
        subMap.put(DIVIDE, ">");
        subMap.put(leftBracket, "<");
        subMap.put(rightBracket, ">");
        subMap.put("#", ">");
        priorityMap.put(MULTIPLY, subMap);
        subMap = new HashMap();
        subMap.put(ADD, ">");
        subMap.put(SUBTRACT, ">");
        subMap.put(MULTIPLY, ">");
        subMap.put(DIVIDE, ">");
        subMap.put(leftBracket, "<");
        subMap.put(rightBracket, ">");
        subMap.put("#", ">");
        priorityMap.put(DIVIDE, subMap);
        subMap = new HashMap();
        subMap.put(ADD, "<");
        subMap.put(SUBTRACT, "<");
        subMap.put(MULTIPLY, "<");
        subMap.put(DIVIDE, "<");
        subMap.put(leftBracket, "<");
        subMap.put(rightBracket, "=");
        priorityMap.put(leftBracket, subMap);
        subMap = new HashMap();
        subMap.put(ADD, ">");
        subMap.put(SUBTRACT, ">");
        subMap.put(MULTIPLY, ">");
        subMap.put(DIVIDE, ">");
        subMap.put(rightBracket, ">");
        subMap.put("#", ">");
        priorityMap.put(rightBracket, subMap);
        subMap = new HashMap();
        subMap.put(ADD, "<");
        subMap.put(SUBTRACT, "<");
        subMap.put(MULTIPLY, "<");
        subMap.put(DIVIDE, "<");
        subMap.put(leftBracket, "<");
        subMap.put("#", "=");
        priorityMap.put("#", subMap);
    }

    private static class TaskWorker
    implements Callable<Void> {
        private Iterator<Integer> iter;
        private List<Integer> newRet;
        private SupplymentDataTable supplyTbl;
        private IMRPEnvProvider ctx;
        private SupplyStruct ss;
        private Long productStorageOrgUnitID;
        private String material;
        private boolean isCenterWarehouseCycle;
        private String cacheKey;
        private RowData row;
        private FieldMapping planScopeRelation;

        public TaskWorker(Iterator<Integer> iter, List<Integer> newRet, SupplymentDataTable supplyTbl, IMRPEnvProvider ctx, SupplyStruct ss, Long productStorageOrgUnitID, String material, boolean isCenterWarehouseCycle, String cacheKey, RowData row, FieldMapping planScopeRelation) {
            this.iter = iter;
            this.newRet = newRet;
            this.supplyTbl = supplyTbl;
            this.ctx = ctx;
            this.ss = ss;
            this.productStorageOrgUnitID = productStorageOrgUnitID;
            this.material = material;
            this.isCenterWarehouseCycle = isCenterWarehouseCycle;
            this.cacheKey = cacheKey;
            this.row = row;
            this.planScopeRelation = planScopeRelation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            while (this.iter.hasNext()) {
                Integer idx = this.iter.next();
                RowData supplyData = this.supplyTbl.fetchRow(idx);
                Long planScope = DataBalanceUtil.getSupplyPlanScope(this.ctx, this.ss, this.productStorageOrgUnitID, this.material, this.isCenterWarehouseCycle, this.cacheKey, supplyData);
                if (planScope == null) continue;
                supplyData.update(DefaultField.SupplyField.DYNAMIC_PLANSCOPE.getName(), (Object)planScope);
                boolean isMatch = DataMatchUtils.isMatch4Relation(this.row, supplyData, this.planScopeRelation);
                if (!isMatch) continue;
                List<Integer> list = this.newRet;
                synchronized (list) {
                    this.newRet.add(idx);
                }
            }
            return null;
        }
    }

    public static class SupplySortComparator
    implements Comparator<Integer> {
        private IMRPEnvProvider ctx;

        public SupplySortComparator(IMRPEnvProvider ctx) {
            this.ctx = ctx;
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            Long date2;
            int priority;
            Integer p1 = (Integer)this.ctx.supplyDatas().getValue(DefaultField.SupplyField.__PRIORITY_LEVEL__.getName(), o1);
            Integer p2 = (Integer)this.ctx.supplyDatas().getValue(DefaultField.SupplyField.__PRIORITY_LEVEL__.getName(), o2);
            if (p1 == null) {
                p1 = -1;
            }
            if (p2 == null) {
                p2 = -1;
            }
            if ((priority = p1.compareTo(p2)) != 0) {
                return -priority;
            }
            Long date1 = (Long)this.ctx.supplyDatas().getValue(DefaultField.SupplyField.DATE.getName(), o1);
            priority = date1.compareTo(date2 = (Long)this.ctx.supplyDatas().getValue(DefaultField.SupplyField.DATE.getName(), o2));
            if (priority != 0) {
                return priority;
            }
            BigDecimal qty1 = MRPUtil.convert(this.ctx.supplyDatas().getValue(DefaultField.SupplyField.QTY.getName(), o1), BigDecimal.ZERO);
            BigDecimal qty2 = MRPUtil.convert(this.ctx.supplyDatas().getValue(DefaultField.SupplyField.QTY.getName(), o2), BigDecimal.ZERO);
            priority = qty1.compareTo(qty2);
            return priority;
        }
    }
}

