/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.model.table.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mrp.common.util.SerializableUtils;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.enums.replace.ReplaceMethod;
import kd.mmc.mrp.model.enums.replace.ReplaceStrategy;
import kd.mmc.mrp.model.enums.strategy.BillAdjustStrategy;
import kd.mmc.mrp.model.enums.strategy.BillSplitStrategy;
import kd.mmc.mrp.model.struct.ReplaceData;
import kd.mmc.mrp.model.struct.ReplaceMaterialStruct;
import kd.mmc.mrp.model.struct.ReplaceStruct;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.table.res.SupplymentDataTable;
import kd.mmc.mrp.model.table.utils.DataBalanceUtil;
import kd.mmc.mrp.utils.MRPUtil;

public class ReplaceUtil {
    private static final Log logger = LogFactory.getLog(ReplaceUtil.class);
    private static final String MRP_REPLACE_LOG = "mrp_replace_log";
    private static final String MAINENTRYENTITY = "mainentryentity";
    private static final String REQENTRYENTITY = "reqentryentity";

    public static BigDecimal calcReplaceMaterialQty(BigDecimal qty, BigDecimal mainChildQty, RequireRowData repRow, IMRPEnvProvider ctx) {
        BigDecimal childQty = MRPUtil.toBigDecimal(repRow.getValue(DefaultField.RequireField.__CHILDQTY__.getName()));
        MRPUtil.UnitPrecisionParam unitPrecisionParam = MRPUtil.getUnitPrecisionParam(repRow.getValue(DefaultField.RequireField.BASEUNIT.getName()), ctx);
        return MRPUtil.multiply(qty, childQty).divide(mainChildQty, unitPrecisionParam.scale, unitPrecisionParam.roundingMode);
    }

    public static void initRequireData4Replace(ReplaceStruct replaceStruct, RequireRowData row) {
        if (replaceStruct != null) {
            RowData bomEntryRow = row.getBomRow();
            int replacepriority = bomEntryRow.getInteger(DefaultField.BOMField.REPLACEPRIORITY.getName());
            String mId = String.valueOf(row.getValue(DefaultField.RequireField.MATERIAL.getName()));
            ReplaceMaterialStruct mStruct = replaceStruct.getMainReplaceM();
            if (mStruct != null && mId.equals(mStruct.getMaterial()) && replacepriority == mStruct.getPriority()) {
                mStruct.setRequireRowData(row);
            } else if (mStruct != null) {
                HashMap<String, RequireRowData> mStructs = mStruct.getRepMaterials();
                if (mStructs.containsKey(mId) && replacepriority == mStruct.getPriority()) {
                    mStructs.put(mId, row);
                } else if (replaceStruct.getReplaceMs() != null) {
                    List<ReplaceMaterialStruct> structs = replaceStruct.getReplaceMs();
                    for (ReplaceMaterialStruct struct : structs) {
                        if (mId.equals(struct.getMaterial()) && replacepriority == struct.getPriority()) {
                            struct.setRequireRowData(row);
                            break;
                        }
                        HashMap<String, RequireRowData> rStructs = struct.getRepMaterials();
                        if (!rStructs.containsKey(mId) || replacepriority != struct.getPriority()) continue;
                        rStructs.put(mId, row);
                        break;
                    }
                }
            }
        }
    }

    public static void initRequireData4ReplaceByAuxProperty(IMRPEnvProvider ctx, ReplaceStruct replaceStruct, RequireRowData row) {
        if (replaceStruct != null) {
            RowData bomEntryRow = row.getBomRow();
            int replacepriority = bomEntryRow.getInteger(DefaultField.BOMField.REPLACEPRIORITY.getName());
            String mId = String.valueOf(row.getValue(DefaultField.RequireField.MATERIAL.getName()));
            Long mFlexId = MRPUtil.convert(bomEntryRow.getValue(DefaultField.BOMField.ENTRYMATERIALFLEXPROP.getName()), 0L);
            ReplaceMaterialStruct mStruct = replaceStruct.getMainReplaceM();
            Long mStructFlexId = replaceStruct.getMainReplaceM().getMaterialAuxproperty();
            if (mStruct != null && mId.equals(mStruct.getMaterial()) && DataBalanceUtil.isMatchFlex(ctx, row, mFlexId, mStructFlexId) && replacepriority == mStruct.getPriority()) {
                mStruct.setRequireRowData(row);
            } else if (mStruct != null) {
                HashMap<String, RequireRowData> mStructs = mStruct.getRepMaterials();
                StringBuilder materialKey = new StringBuilder(mId);
                materialKey.append('\u0001').append(mFlexId);
                for (Map.Entry<String, RequireRowData> mStructsEntry : mStructs.entrySet()) {
                    String[] mArrays;
                    String mStructsKey = mStructsEntry.getKey();
                    if (StringUtils.isBlank((CharSequence)mStructsKey) || !mId.equals((mArrays = mStructsKey.split("[\u0001]"))[0]) || replacepriority != mStruct.getPriority() || !DataBalanceUtil.isMatchFlex(ctx, row, mFlexId, MRPUtil.convert((Object)mArrays[1], 0L))) continue;
                    mStructs.put(materialKey.toString(), row);
                    return;
                }
                if (replaceStruct.getReplaceMs() != null) {
                    List<ReplaceMaterialStruct> structs = replaceStruct.getReplaceMs();
                    for (ReplaceMaterialStruct struct : structs) {
                        if (mId.equals(struct.getMaterial()) && DataBalanceUtil.isMatchFlex(ctx, row, mFlexId, struct.getMaterialAuxproperty()) && replacepriority == struct.getPriority()) {
                            struct.setRequireRowData(row);
                            break;
                        }
                        HashMap<String, RequireRowData> rStructs = struct.getRepMaterials();
                        for (Map.Entry<String, RequireRowData> rStructsEntry : rStructs.entrySet()) {
                            String[] rArrays;
                            String rStructsKey = rStructsEntry.getKey();
                            if (StringUtils.isBlank((CharSequence)rStructsKey) || !mId.equals((rArrays = rStructsKey.split("[\u0001]"))[0]) || replacepriority != struct.getPriority() || !DataBalanceUtil.isMatchFlex(ctx, row, mFlexId, MRPUtil.convert((Object)rArrays[1], 0L))) continue;
                            rStructs.put(materialKey.toString(), row);
                            return;
                        }
                    }
                }
            }
        }
    }

    public static Set<String> getReplaceMaterialCol(RowData requireData) {
        HashSet<String> res = new HashSet<String>(16);
        if (requireData == null) {
            return res;
        }
        String json = (String)requireData.getValue(DefaultField.RequireField.__REPLACE_STRUCT__.getName());
        if (json == null) {
            return res;
        }
        ReplaceStruct replaceStruct = (ReplaceStruct)SerializableUtils.fromSerializedString((String)json, ReplaceStruct.class);
        if (replaceStruct == null) {
            return res;
        }
        ReplaceMaterialStruct mStruct = replaceStruct.getMainReplaceM();
        ReplaceUtil.addReplaceStructMaterials(mStruct, res);
        List<ReplaceMaterialStruct> structs = replaceStruct.getReplaceMs();
        if (structs != null) {
            for (ReplaceMaterialStruct struct : structs) {
                ReplaceUtil.addReplaceStructMaterials(struct, res);
            }
        }
        return res;
    }

    private static void addReplaceStructMaterials(ReplaceMaterialStruct mStruct, Set<String> res) {
        if (mStruct != null) {
            res.add(mStruct.getMaterial());
            if (mStruct.getRepMaterials() != null) {
                for (String key : mStruct.getRepMaterials().keySet()) {
                    String[] strs = key.split("\u0001");
                    res.add(strs[0]);
                }
            }
        }
    }

    public static List<Integer> sortByReplace(SupplymentDataTable supplyTbl, List<Integer> supplys, ReplaceStruct replaceStruct) {
        ReplaceMaterialStruct materialStruct = replaceStruct.getMainReplaceM();
        List<ReplaceMaterialStruct> repList = replaceStruct.getReplaceMs();
        if (repList == null) {
            repList = new ArrayList<ReplaceMaterialStruct>(0);
        }
        repList.sort((o1, o2) -> o1.getPriority() - o2.getPriority());
        ArrayList allSupplys = new ArrayList(repList.size() + 1);
        allSupplys.add(new ArrayList(0));
        HashMap<String, Integer> map = new HashMap<String, Integer>(repList.size() + 1);
        map.put(materialStruct.getMaterial(), 0);
        for (int i = 0; i < repList.size(); ++i) {
            ReplaceMaterialStruct struct = repList.get(i);
            map.put(struct.getMaterial(), i + 1);
            allSupplys.add(new ArrayList(0));
        }
        ArrayList<Integer> ignore = new ArrayList<Integer>(0);
        for (Integer n : supplys) {
            String material = String.valueOf(supplyTbl.getValue(DefaultField.SupplyField.MATERIAL.getName(), n));
            Integer i = (Integer)map.get(material);
            if (i != null) {
                ((List)allSupplys.get(i)).add(n);
                continue;
            }
            ignore.add(n);
        }
        supplys.clear();
        for (List list : allSupplys) {
            supplys.addAll(list);
        }
        supplys.addAll(ignore);
        return supplys;
    }

    public static List<RequireRowData> replaceOp(List<RequireRowData> unFullRequires, SupplymentDataTable supplyTbl, RequireRowData requireData, IMRPEnvProvider ctx) {
        if ("1".equals(ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("ctxid: %s, mrprunner-replaceUtil-start-replaceOp", ctx.getMRPContextId()));
        }
        String json = (String)requireData.getValue(DefaultField.RequireField.__REPLACE_STRUCT__.getName());
        ReplaceStruct replaceStruct = (ReplaceStruct)SerializableUtils.fromSerializedString((String)json, ReplaceStruct.class);
        ReplaceUtil.removeInvalidationData(replaceStruct);
        BigDecimal qty = MRPUtil.toBigDecimal(requireData.getValue(DefaultField.RequireField.QTY.getName()));
        HashMap<String, List<Integer>> supplys = new HashMap<String, List<Integer>>(16);
        for (Integer idx : requireData.getOccupyList()) {
            String material = String.valueOf(supplyTbl.getValue(DefaultField.SupplyField.MATERIAL.getName(), idx));
            List list = supplys.getOrDefault(material, new ArrayList(16));
            list.add(idx);
            supplys.put(material, list);
        }
        ArrayList<RequireRowData> newChildren = new ArrayList<RequireRowData>(16);
        HashMap<RequireRowData, Integer> dict = new HashMap<RequireRowData, Integer>(16);
        List<ReplaceMaterialStruct> repList = replaceStruct.getReplaceMs();
        repList.sort((o1, o2) -> o1.getPriority() - o2.getPriority());
        boolean isFlexPropMatch = (Boolean)ctx.getCfgValue(EnvCfgItem.ENABLE_MATERIAL_EXT_PROPS);
        HashSet<String> mainMaterials = new HashSet<String>(repList.size() + 1);
        if (!isFlexPropMatch) {
            mainMaterials.add(replaceStruct.getMainReplaceM().getMaterial());
            for (ReplaceMaterialStruct struct : repList) {
                mainMaterials.add(struct.getMaterial());
            }
        } else {
            StringBuilder key = new StringBuilder();
            key.append(replaceStruct.getMainReplaceM().getMaterial()).append('\u0001').append(replaceStruct.getMainReplaceM().getMaterialAuxproperty());
            mainMaterials.add(key.toString());
            for (ReplaceMaterialStruct struct : repList) {
                key.setLength(0);
                key.append(struct.getMaterial()).append('\u0001').append(struct.getMaterialAuxproperty());
                mainMaterials.add(key.toString());
            }
        }
        ReplaceStrategy str = ReplaceStrategy.parseString(replaceStruct.getReplaceStra());
        if ("1".equals(ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("ctxid: %s, mrprunner-replaceUtil-replaceOp, ReplaceStrategy: %s, ReplaceMethod: %s", ctx.getMRPContextId(), replaceStruct.getReplaceStra(), replaceStruct.getReplaceMethod()));
        }
        switch (str) {
            case MIX: {
                ReplaceUtil.replaceAndMix(ctx, replaceStruct, requireData, newChildren, dict, false, supplyTbl, supplys);
                break;
            }
            case WHOLE_AND_MIX: {
                if (ReplaceUtil.replaceAndWhole(ctx, replaceStruct, requireData, newChildren, dict, false, supplyTbl, supplys)) break;
                ReplaceUtil.replaceAndMix(ctx, replaceStruct, requireData, newChildren, dict, true, supplyTbl, supplys);
                break;
            }
            default: {
                ReplaceUtil.replaceAndWhole(ctx, replaceStruct, requireData, newChildren, dict, true, supplyTbl, supplys);
            }
        }
        supplyTbl.unlock(requireData.getOccupys());
        ReplaceUtil.createReplaceLog(ctx, replaceStruct, newChildren);
        return ReplaceUtil.handleReplaceData(supplys, mainMaterials, newChildren, unFullRequires, supplyTbl, replaceStruct, qty, isFlexPropMatch, ctx);
    }

    public static void createReplaceLog(IMRPEnvProvider ctx, ReplaceStruct replaceStruct, List<RequireRowData> newChildren) {
        String priority;
        String mid;
        String key3;
        boolean isFlexPropMatch = (Boolean)ctx.getCfgValue(EnvCfgItem.ENABLE_MATERIAL_EXT_PROPS);
        ReplaceMaterialStruct mainStruct = replaceStruct.getMainReplaceM();
        String mainMaterial = mainStruct.getMaterial();
        HashSet<String> mainMs = new HashSet<String>(1);
        String mainKey = mainMaterial;
        if (isFlexPropMatch) {
            mainKey = String.format("%s\u0001%s", mainMaterial, mainStruct.getMaterialAuxproperty());
        }
        mainMs.add(MRPRuntimeConsts.getGroupKey(new String[]{mainKey, mainStruct.getPriority().toString()}));
        HashMap<String, RequireRowData> mainMap = mainStruct.getRepMaterials();
        if (mainMap != null) {
            for (String key2 : mainMap.keySet()) {
                mainMs.add(MRPRuntimeConsts.getGroupKey(new String[]{key2, mainStruct.getPriority().toString()}));
            }
        }
        HashMap<String, ReplaceData> replaceDatas = new HashMap<String, ReplaceData>(1);
        HashMap<String, Set<String>> repMap = new HashMap<String, Set<String>>(1);
        for (ReplaceMaterialStruct struct : replaceStruct.getReplaceMs()) {
            mainKey = struct.getMaterial();
            if (isFlexPropMatch) {
                mainKey = String.format("%s\u0001%s", struct.getMaterial(), struct.getMaterialAuxproperty());
            }
            Set set = repMap.computeIfAbsent(MRPRuntimeConsts.getGroupKey(new String[]{mainKey, struct.getPriority().toString()}), k -> new HashSet());
            if (struct.getRepMaterials() == null) continue;
            for (String key3 : struct.getRepMaterials().keySet()) {
                set.add(MRPRuntimeConsts.getGroupKey(new String[]{key3, struct.getPriority().toString()}));
            }
        }
        for (RequireRowData rowData : newChildren) {
            mid = String.valueOf(rowData.getValue(DefaultField.RequireField.MATERIAL.getName()));
            if (isFlexPropMatch) {
                mid = String.format("%s\u0001%s", mid, MRPUtil.convert(rowData.getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName()), 0L));
            }
            if (!repMap.containsKey(key3 = MRPRuntimeConsts.getGroupKey(new String[]{mid, priority = String.valueOf(rowData.getValue(DefaultField.RequireField.REPLACEPRIORITY.getName()))}))) continue;
            ReplaceData data = new ReplaceData();
            data.setMaterial(mainMaterial);
            data.setReplaceMethod(replaceStruct.getReplaceMethod());
            data.setReplaceStra(replaceStruct.getReplaceStra());
            data.setRequireRowData(rowData);
            replaceDatas.put(key3, data);
        }
        for (RequireRowData rowData : newChildren) {
            mid = String.valueOf(rowData.getValue(DefaultField.RequireField.MATERIAL.getName()));
            if (isFlexPropMatch) {
                mid = String.format("%s\u0001%s", mid, MRPUtil.convert(rowData.getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName()), 0L));
            }
            if (mainMs.contains(key3 = MRPRuntimeConsts.getGroupKey(new String[]{mid, priority = String.valueOf(rowData.getValue(DefaultField.RequireField.REPLACEPRIORITY.getName()))})) || repMap.containsKey(key3)) continue;
            ReplaceUtil.replaceMaterialHandle(repMap, key3, replaceDatas, rowData);
        }
        ReplaceUtil.handleReplaceLog(ctx, replaceDatas, mainStruct);
    }

    public static void replaceMaterialHandle(Map<String, Set<String>> repMap, String key, Map<String, ReplaceData> replaceDatas, RequireRowData rowData) {
        for (Map.Entry<String, Set<String>> entry : repMap.entrySet()) {
            if (!entry.getValue().contains(key)) continue;
            ReplaceData data = replaceDatas.get(entry.getKey());
            if (data == null) break;
            List<RequireRowData> dataList = data.getDataList();
            if (dataList == null) {
                dataList = new ArrayList<RequireRowData>(16);
                data.setDataList(dataList);
            }
            dataList.add(rowData);
            break;
        }
    }

    public static void handleReplaceLog(IMRPEnvProvider ctx, Map<String, ReplaceData> replaceDatas, ReplaceMaterialStruct mainStruct) {
        if (replaceDatas.isEmpty()) {
            return;
        }
        RequireRowData mainRequireData = mainStruct.getRequireRowData();
        Long unitId = MRPUtil.convert(mainRequireData.getValue(DefaultField.RequireField.BASEUNIT.getName()), 0L);
        Long auxpty = MRPUtil.convert(mainRequireData.getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName()), 0L);
        ArrayList<DynamicObject> saves = new ArrayList<DynamicObject>(replaceDatas.size());
        HashMap<String, RequireRowData> map = mainStruct.getRepMaterials();
        for (Map.Entry<String, ReplaceData> entry : replaceDatas.entrySet()) {
            ReplaceData replaceData = entry.getValue();
            String[] key = MRPRuntimeConsts.splitDataKey(entry.getKey());
            RequireRowData rowData = replaceData.getRequireRowData();
            List<RequireRowData> dataList = replaceData.getDataList();
            DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)MRP_REPLACE_LOG);
            data.set("runlogno", (Object)ctx.getRunLogNumber());
            data.set("runlog", ctx.getRunLog().getPkValue());
            data.set("material", (Object)Long.valueOf(replaceData.getMaterial()));
            data.set("repmaterial", (Object)Long.valueOf(key[0]));
            data.set("bomnumber", (Object)String.valueOf(rowData.getValue(DefaultField.RequireField.PARENT_BOMNUMBER.getName())));
            BigDecimal qty = MRPUtil.toBigDecimal(rowData.getValue(DefaultField.RequireField.QTY.getName()));
            data.set("requireqty", (Object)qty);
            data.set("repqty", (Object)qty);
            data.set("unit", (Object)unitId);
            Long repUnitId = MRPUtil.convert(rowData.getValue(DefaultField.RequireField.BASEUNIT.getName()), 0L);
            data.set("requnit", (Object)repUnitId);
            String sourceno = String.valueOf(rowData.getValue(DefaultField.RequireField.__REQUIRE_SOURCE__.getName()));
            data.set("sourceno", (Object)(StringUtils.equals((CharSequence)sourceno, (CharSequence)"null") ? "" : sourceno));
            data.set("billid", (Object)rowData.getString(DefaultField.RequireField.BILLID.getName()));
            data.set("billentryid", (Object)rowData.getString(DefaultField.RequireField.BILLENTRYID.getName()));
            Long replace = MRPUtil.convert(rowData.getValue(DefaultField.RequireField.REPLACEPLAN.getName()), 0L);
            data.set("replace", (Object)replace);
            data.set("replacestra", (Object)replaceData.getReplaceStra());
            data.set("replacemethod", (Object)replaceData.getReplaceMethod());
            data.set("auxpty", (Object)auxpty);
            Long repauxpty = MRPUtil.convert(rowData.getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName()), 0L);
            data.set("repauxpty", (Object)repauxpty);
            ReplaceUtil.buildEntry(map == null ? new ArrayList(0) : map.values(), dataList, data, qty, unitId, repUnitId, mainStruct.getMaterial(), key[0], ctx, mainRequireData, rowData);
            saves.add(data);
        }
        SaveServiceHelper.save((DynamicObject[])saves.toArray(new DynamicObject[0]));
    }

    public static void buildEntry(Collection<RequireRowData> mDataList, Collection<RequireRowData> dataList, DynamicObject data, BigDecimal qty, Long unitId, Long repUnitId, String mid, String reqMid, IMRPEnvProvider ctx, RequireRowData mainRequireData, RequireRowData rowData) {
        if (dataList != null) {
            Long auxpty = MRPUtil.convert(mainRequireData.getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName()), 0L);
            Long repauxpty = MRPUtil.convert(rowData.getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName()), 0L);
            DynamicObjectCollection mainEntry = data.getDynamicObjectCollection(MAINENTRYENTITY);
            DynamicObjectCollection repEntry = data.getDynamicObjectCollection(REQENTRYENTITY);
            BigDecimal mQty = MRPUtil.toBigDecimal(mainRequireData.getValue(DefaultField.RequireField.__CHILDQTY__.getName()));
            ReplaceUtil.buildMaterialEntry(ctx, mainEntry, mid, qty, mQty, unitId, auxpty, mDataList, "entrymaterial", "entryqty", "entryunit", "entryauxpty");
            mQty = MRPUtil.toBigDecimal(rowData.getValue(DefaultField.RequireField.__CHILDQTY__.getName()));
            ReplaceUtil.buildMaterialEntry(ctx, repEntry, reqMid, qty, mQty, repUnitId, repauxpty, dataList, "entryreqmaterial", "entryreqqty", "entryrepunit", "entryrepauxpty");
        }
    }

    private static void buildMaterialEntry(IMRPEnvProvider ctx, DynamicObjectCollection entry, String material, BigDecimal qty, BigDecimal mQty, Long unitId, Long auxpty, Collection<RequireRowData> values, String mKey, String qtyKey, String unitKey, String auxptyKey) {
        DynamicObject m = entry.addNew();
        m.set(mKey, (Object)Long.valueOf(material));
        m.set(qtyKey, (Object)qty);
        m.set(unitKey, (Object)unitId);
        m.set(auxptyKey, (Object)auxpty);
        for (RequireRowData rowData : values) {
            DynamicObject aux = entry.addNew();
            Long mid = MRPUtil.convert(rowData.getValue(DefaultField.RequireField.MATERIAL.getName()), 0L);
            BigDecimal auxQty = ReplaceUtil.calcReplaceMaterialQty(qty, mQty, rowData, ctx);
            Long unit = MRPUtil.convert(rowData.getValue(DefaultField.RequireField.BASEUNIT.getName()), 0L);
            Long auxId = MRPUtil.convert(rowData.getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName()), 0L);
            aux.set(mKey, (Object)mid);
            aux.set(qtyKey, (Object)auxQty);
            aux.set(unitKey, (Object)unit);
            aux.set(auxptyKey, (Object)auxId);
        }
    }

    private static void removeInvalidationData(ReplaceStruct replaceStruct) {
        if (replaceStruct == null) {
            return;
        }
        ReplaceMaterialStruct mainReplaceM = replaceStruct.getMainReplaceM();
        HashMap<String, RequireRowData> map = mainReplaceM.getRepMaterials();
        if (map != null) {
            map.entrySet().removeIf(entry -> entry.getValue() == null);
        }
        List<ReplaceMaterialStruct> repList = replaceStruct.getReplaceMs();
        repList.removeIf(replaceMaterialStruct -> replaceMaterialStruct.getRequireRowData() == null);
        for (ReplaceMaterialStruct struct : repList) {
            HashMap<String, RequireRowData> reqMap = struct.getRepMaterials();
            if (reqMap == null) continue;
            reqMap.entrySet().removeIf(entry -> entry.getValue() == null);
        }
    }

    private static List<RequireRowData> handleReplaceData(Map<String, List<Integer>> supplys, Set<String> mainMaterials, List<RequireRowData> newChildren, List<RequireRowData> unFullRequires, SupplymentDataTable supplyTbl, ReplaceStruct replaceStruct, BigDecimal qty, boolean isFlexPropMatch, IMRPEnvProvider ctx) {
        ReplaceMaterialStruct mainStruct = replaceStruct.getMainReplaceM();
        RequireRowData requireData = mainStruct.getRequireRowData();
        ArrayList<RequireRowData> result = new ArrayList<RequireRowData>(16);
        HashMap<Integer, BigDecimal> hasExecute = new HashMap<Integer, BigDecimal>(16);
        for (RequireRowData requireRowData : newChildren) {
            String material = String.valueOf(requireRowData.getValue(DefaultField.RequireField.MATERIAL.getName()));
            StringBuilder key = new StringBuilder(material);
            if (isFlexPropMatch) {
                Long materialFlexProp = MRPUtil.convert(requireRowData.getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName()), 0L);
                key.append('\u0001').append(materialFlexProp);
            }
            requireRowData.update(DefaultField.RequireField.__PRIORITY_LEVEL__.getName(), requireData.getValue(DefaultField.RequireField.__PRIORITY_LEVEL__.getName()));
            requireRowData.update(DefaultField.RequireField.DATE.getName(), requireData.getValue(DefaultField.RequireField.DATE.getName()));
            requireRowData.update(DefaultField.RequireField.__ORIGIN_DEMAND_DATE__.getName(), requireData.getValue(DefaultField.RequireField.__ORIGIN_DEMAND_DATE__.getName()));
            if (mainMaterials.contains(key.toString())) {
                List<Integer> sup = supplys.get(material);
                if (sup == null) {
                    requireRowData.setBalanced(false);
                    requireRowData.getOccupys().clear();
                    requireRowData.setNewQrequireQty(MRPUtil.toBigDecimal(requireRowData.getValue(DefaultField.RequireField.QTY.getName())));
                } else {
                    requireRowData.getOccupys().clear();
                    BigDecimal rQty = MRPUtil.toBigDecimal(requireRowData.getValue(DefaultField.RequireField.QTY.getName()));
                    boolean isBalanced = false;
                    ListIterator<Integer> iterator = sup.listIterator();
                    while (iterator.hasNext()) {
                        int split;
                        Integer idx = (Integer)iterator.next();
                        RowData supply = supplyTbl.fetchRow(idx);
                        if (isFlexPropMatch && !DataBalanceUtil.validateFlexPropsMatch(ctx, requireRowData, supply)) continue;
                        BigDecimal sQty = MRPUtil.toBigDecimal(supply.getValue(DefaultField.SupplyField.QTY.getName()));
                        if (hasExecute.get(idx) != null) {
                            sQty = (BigDecimal)hasExecute.get(idx);
                        }
                        if (sQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                        rQty = rQty.subtract(sQty);
                        String modelID = (String)supply.getValue(DefaultField.SupplyField.BILL_ENTITY.getName());
                        BillSplitStrategy ajustType = ctx.strategys().getOrDefault(modelID, BillSplitStrategy.PART);
                        int flag = MRPUtil.convert(supply.getValue(DefaultField.SupplyField.__ADJUST_FLAG__.name()), BillAdjustStrategy.NONE.getValue());
                        if (flag == BillAdjustStrategy.NONE.getValue()) {
                            supply.update(DefaultField.SupplyField.__ADJUST_QTY__.getName(), (Object)BigDecimal.ZERO);
                            supply.update(DefaultField.SupplyField.__ADJUST_PLAN_DATE__.getName(), null);
                        } else {
                            supply.update(DefaultField.SupplyField.__ADJUST_QTY__.getName(), (Object)MRPUtil.toBigDecimal(supply.getValue(DefaultField.SupplyField.ORIGINQTY.getName())));
                            supply.update(DefaultField.SupplyField.__ADJUST_PLAN_DATE__.getName(), requireRowData.getValue(DefaultField.RequireField.DATE.getName()));
                        }
                        int cmp = rQty.compareTo(BigDecimal.ZERO);
                        if (cmp >= 0) {
                            requireRowData.getOccupys().add(idx);
                            hasExecute.put(idx, BigDecimal.ZERO);
                        } else if (BillSplitStrategy.PART == ajustType) {
                            RowData rowDataCopy = supplyTbl.split(supply, sQty.add(rQty), ctx);
                            supply.update(DefaultField.SupplyField.__ADJUST_QTY__.getName(), (Object)MRPUtil.toBigDecimal(supply.getValue(DefaultField.SupplyField.ORIGINQTY.getName())));
                            split = supplyTbl.fill(rowDataCopy);
                            supplyTbl.updateValue(DefaultField.SupplyField.__ADJUST_QTY__.getName(), split, MRPUtil.toBigDecimal(rowDataCopy.getValue(DefaultField.SupplyField.ORIGINQTY.getName())));
                            requireRowData.getOccupys().add(split);
                        } else if (BillSplitStrategy.WHOLE == ajustType || BillSplitStrategy.NONE == ajustType) {
                            RowData splitCopy = supplyTbl.split(supply, sQty.add(rQty), ctx);
                            supply.update(DefaultField.SupplyField.__ADJUST_FLAG__.name(), null);
                            supply.update(DefaultField.SupplyField.__ADJUST_PLAN_DATE__.name(), null);
                            supply.update(DefaultField.SupplyField.__ADJUST_QTY__.name(), (Object)BigDecimal.ZERO);
                            supply.update(DefaultField.SupplyField.__HAS_WHOLE_ADJUST__.name(), (Object)Boolean.TRUE);
                            supply.update(DefaultField.SupplyField.__IS_SPLITED__.name(), (Object)Boolean.TRUE);
                            split = supplyTbl.fill(splitCopy);
                            requireRowData.getOccupys().add(split);
                        } else {
                            requireRowData.getOccupys().add(idx);
                        }
                        iterator.remove();
                        if (cmp > 0) continue;
                        isBalanced = true;
                        break;
                    }
                    supplyTbl.lock(requireRowData.getOccupys(), requireRowData.getRowIdx());
                    requireRowData.setBalanced(isBalanced);
                    requireRowData.setNewQrequireQty(rQty);
                }
                result.add(requireRowData);
                continue;
            }
            unFullRequires.add(requireRowData);
        }
        ReplaceUtil.restorePlanOrder(newChildren, replaceStruct, qty, ctx);
        for (List list : supplys.values()) {
            for (Integer idx : list) {
                RowData supply = supplyTbl.fetchRow(idx);
                supply.update(DefaultField.SupplyField.__IS_ADJUST__.name(), null);
                supply.update(DefaultField.SupplyField.__ADJUST_FLAG__.name(), null);
                supply.update(DefaultField.SupplyField.__ADJUST_PLAN_DATE__.name(), null);
                supply.update(DefaultField.SupplyField.__ADJUST_QTY__.name(), (Object)BigDecimal.ZERO);
                supply.update(DefaultField.SupplyField.__HAS_WHOLE_ADJUST__.name(), null);
                supply.update(DefaultField.SupplyField.__IS_SPLITED__.name(), null);
            }
        }
        return result;
    }

    private static void restorePlanOrder(List<RequireRowData> newChildren, ReplaceStruct replaceStruct, BigDecimal qty, IMRPEnvProvider ctx) {
        ReplaceMaterialStruct mainStruct = replaceStruct.getMainReplaceM();
        RequireRowData requireData = mainStruct.getRequireRowData();
        String parentMaterial = String.valueOf(requireData.getValue(DefaultField.RequireField.__PARENT_MATERIAL__.getName()));
        String replaceKey = String.valueOf(requireData.getValue(DefaultField.RequireField.__REPLACE_KEY__.getName()));
        List<RequireRowData> result = ReplaceUtil.restorePlanOrderByReplaceLog(newChildren, replaceStruct, qty, ctx);
        ArrayList<Object[]> resultValues = new ArrayList<Object[]>(result.size());
        for (RequireRowData require : result) {
            resultValues.add(require.getValues());
        }
        MRPCacheManager.getInst().putSubData(ctx, MRPRuntimeConsts.getReplacePlanOrderKey(parentMaterial), MRPRuntimeConsts.getReplacePlanOrderSubKey(ctx.getMRPContextId(), replaceKey, String.valueOf(requireData.getValue(DefaultField.RequireField.__PARENT_BOMID__.getName())), String.valueOf(requireData.getValue(DefaultField.RequireField.REPLACEPLAN.getName()))), JSON.toJSONString(resultValues, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
    }

    private static String getReplaceKey(IMRPEnvProvider ctx, RequireRowData requireData) {
        boolean isFlexPropMatch = (Boolean)ctx.getCfgValue(EnvCfgItem.ENABLE_MATERIAL_EXT_PROPS);
        String mId = String.valueOf(requireData.getValue(DefaultField.RequireField.MATERIAL.getName()));
        Long aux = MRPUtil.convert(requireData.getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName()), 0L);
        return isFlexPropMatch ? String.format("%s\u0001%s", mId, aux) : mId;
    }

    private static List<RequireRowData> restorePlanOrderByReplaceLog(List<RequireRowData> newChildren, ReplaceStruct replaceStruct, BigDecimal qty, IMRPEnvProvider ctx) {
        ArrayList<RequireRowData> result = new ArrayList<RequireRowData>(16);
        ReplaceMaterialStruct mainStruct = replaceStruct.getMainReplaceM();
        RequireRowData requireData = mainStruct.getRequireRowData();
        HashMap<String, RequireRowData> mainAuxDatas = mainStruct.getRepMaterials();
        if (mainAuxDatas == null) {
            mainAuxDatas = new HashMap(0);
        }
        HashMap<String, BigDecimal> mainReqQtys = new HashMap<String, BigDecimal>(mainAuxDatas.size() + 1);
        String repKey = ReplaceUtil.getReplaceKey(ctx, requireData);
        mainReqQtys.put(repKey, qty);
        BigDecimal mQty = MRPUtil.toBigDecimal(requireData.getValue(DefaultField.RequireField.__CHILDQTY__.getName()));
        for (Map.Entry<String, RequireRowData> entry : mainAuxDatas.entrySet()) {
            BigDecimal auxQty = ReplaceUtil.calcReplaceMaterialQty(qty, mQty, entry.getValue(), ctx);
            mainReqQtys.put(entry.getKey(), auxQty);
        }
        HashMap<String, RequireRowData> replaceRows = new HashMap<String, RequireRowData>(16);
        ArrayList<RequireRowData> repResult = new ArrayList<RequireRowData>(16);
        for (RequireRowData rowData : newChildren) {
            String replaceKey = ReplaceUtil.getReplaceKey(ctx, rowData);
            BigDecimal rowQty = MRPUtil.toBigDecimal(rowData.getValue(DefaultField.RequireField.QTY.getName()));
            BigDecimal mainQty = (BigDecimal)mainReqQtys.get(replaceKey);
            if (mainQty == null) {
                replaceRows.put(replaceKey, rowData);
                repResult.add(rowData);
                continue;
            }
            mainQty = mainQty.subtract(rowQty);
            mainReqQtys.put(replaceKey, mainQty);
            result.add(rowData);
        }
        List<ReplaceMaterialStruct> structs = replaceStruct.getReplaceMs();
        ArrayList<List<String>> repStrs = new ArrayList<List<String>>(16);
        for (ReplaceMaterialStruct struct : structs) {
            ArrayList<String> strs;
            String replaceKey = ReplaceUtil.getReplaceKey(ctx, struct.getRequireRowData());
            RequireRowData rowData = (RequireRowData)replaceRows.get(replaceKey);
            HashMap<String, RequireRowData> reps = struct.getRepMaterials();
            if (rowData == null) {
                ReplaceUtil.addReplaceRequire(struct.getRequireRowData(), BigDecimal.ZERO, "", repResult, ctx);
                if (reps == null) continue;
                for (Map.Entry<String, RequireRowData> entry : reps.entrySet()) {
                    if (entry.getValue() == null) continue;
                    ReplaceUtil.addReplaceRequire(entry.getValue(), BigDecimal.ZERO, "", repResult, ctx);
                }
                continue;
            }
            BigDecimal rowQty = MRPUtil.toBigDecimal(rowData.getValue(DefaultField.RequireField.QTY.getName()));
            String[] minfo = ctx.getMaterialDataById(struct.getMaterial());
            ReplaceUtil.addReplaceRequire(requireData, rowQty, minfo[0], result, ctx);
            if (reps == null) {
                strs = new ArrayList<String>(0);
            } else {
                strs = new ArrayList(reps.size());
                for (String mid : reps.keySet()) {
                    if (mid.contains("\u0001")) {
                        mid = mid.split("[\u0001]")[0];
                    }
                    minfo = ctx.getMaterialDataById(mid);
                    strs.add(minfo[0]);
                }
            }
            repStrs.add(strs);
        }
        ReplaceUtil.subMaterialHandle(mainReqQtys, mainAuxDatas, repKey, repStrs, result, ctx);
        result.addAll(repResult);
        return result;
    }

    private static void subMaterialHandle(HashMap<String, BigDecimal> mainReqQtys, HashMap<String, RequireRowData> mainAuxDatas, String replaceKey, List<List<String>> repStrs, List<RequireRowData> result, IMRPEnvProvider ctx) {
        for (Map.Entry<String, BigDecimal> entry : mainReqQtys.entrySet()) {
            RequireRowData rowData;
            if (StringUtils.equals((CharSequence)entry.getKey(), (CharSequence)replaceKey) || (rowData = mainAuxDatas.get(entry.getKey())) == null || entry.getValue().compareTo(BigDecimal.ZERO) <= 0) continue;
            for (List<String> strs : repStrs) {
                String ms = ReplaceUtil.appendRepMaterial(strs);
                ReplaceUtil.addReplaceRequire(rowData, entry.getValue(), ms, result, ctx);
            }
        }
    }

    private static String appendRepMaterial(List<String> strs) {
        StringBuilder sb = new StringBuilder();
        for (String str : strs) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(str);
        }
        return sb.toString();
    }

    private static void addReplaceRequire(RequireRowData requireRowData, BigDecimal rowQty, String replaceMs, List<RequireRowData> result, IMRPEnvProvider ctx) {
        RequireRowData copy = requireRowData.clone();
        copy.update(DefaultField.RequireField.QTY.getName(), (Object)BigDecimal.ZERO);
        copy.update(DefaultField.RequireField.STAND_QTY.getName(), (Object)BigDecimal.ZERO);
        copy.update(DefaultField.RequireField.__REPLACE_QTY__.getName(), (Object)rowQty);
        copy.update(DefaultField.RequireField.__REPLACE_MATERIAL__.getName(), (Object)replaceMs);
        result.add(DataBalanceUtil.fillDependentRequire(null, copy, ctx));
    }

    private static boolean replaceAndWhole(IMRPEnvProvider ctx, ReplaceStruct replaceStruct, RequireRowData requireData, List<RequireRowData> newChildren, HashMap<RequireRowData, Integer> dict, boolean isCreateDependent, SupplymentDataTable supplyTbl, Map<String, List<Integer>> supplys) {
        ReplaceMaterialStruct mStruct = replaceStruct.getMainReplaceM();
        mStruct.setRequireRowData(requireData);
        boolean isBalanced = false;
        if (ReplaceUtil.isBalanced(ctx, requireData, supplyTbl, supplys)) {
            ReplaceUtil.createDependent(ctx, mStruct, newChildren, dict, false, true);
            return true;
        }
        List<ReplaceMaterialStruct> repList = replaceStruct.getReplaceMs();
        for (ReplaceMaterialStruct repStruct : repList) {
            RequireRowData row = repStruct.getRequireRowData();
            if (row == null) continue;
            row.update(DefaultField.RequireField.QTY.getName(), requireData.getValue(DefaultField.RequireField.QTY.getName()));
            if (!ReplaceUtil.isBalanced(ctx, row, supplyTbl, supplys)) continue;
            ReplaceUtil.createDependent(ctx, repStruct, newChildren, dict, true, false);
            isBalanced = true;
            break;
        }
        if (!isBalanced && isCreateDependent) {
            if (ReplaceMethod.REPLACE.getValue().equals(replaceStruct.getReplaceMethod())) {
                ReplaceUtil.createDependent(ctx, mStruct, newChildren, dict, false, true);
            } else if (ReplaceMethod.SUBSTITUTE.getValue().equals(replaceStruct.getReplaceMethod())) {
                ReplaceUtil.createDependent(ctx, replaceStruct.getReplaceMs().get(0), newChildren, dict, true, false);
            }
        }
        return isBalanced;
    }

    private static void replaceAndMix(IMRPEnvProvider ctx, ReplaceStruct replaceStruct, RequireRowData requireData, List<RequireRowData> newChildren, HashMap<RequireRowData, Integer> dict, boolean isMixAndWhole, SupplymentDataTable supplyTbl, Map<String, List<Integer>> supplys) {
        ReplaceMaterialStruct mStruct = replaceStruct.getMainReplaceM();
        mStruct.setRequireRowData(requireData);
        boolean isBalanced = false;
        if (!isMixAndWhole) {
            List<ReplaceMaterialStruct> repList = replaceStruct.getReplaceMs();
            for (ReplaceMaterialStruct repStruct : repList) {
                RequireRowData row = repStruct.getRequireRowData();
                if (row == null) continue;
                row.update(DefaultField.RequireField.QTY.getName(), requireData.getValue(DefaultField.RequireField.QTY.getName()));
            }
        }
        if (!(isBalanced = ReplaceUtil.calMix(ctx, replaceStruct, newChildren, dict, supplyTbl, supplys))) {
            ReplaceMaterialStruct struct;
            BigDecimal qty = requireData.getNewQrequireQty();
            if (ReplaceMethod.REPLACE.getValue().equals(replaceStruct.getReplaceMethod())) {
                if (ReplaceUtil.calNewRequireQty(ctx, mStruct, qty, dict, newChildren, false) != null) {
                    ReplaceUtil.createDependent(ctx, mStruct, newChildren, dict, false, true);
                }
            } else if (ReplaceMethod.SUBSTITUTE.getValue().equals(replaceStruct.getReplaceMethod()) && ReplaceUtil.calNewRequireQty(ctx, struct = replaceStruct.getReplaceMs().get(0), qty, dict, newChildren, true) != null) {
                ReplaceUtil.createDependent(ctx, struct, newChildren, dict, true, false);
            }
        }
    }

    private static boolean calMix(IMRPEnvProvider ctx, ReplaceStruct replaceStruct, List<RequireRowData> newChildren, HashMap<RequireRowData, Integer> dict, SupplymentDataTable supplyTbl, Map<String, List<Integer>> supplys) {
        ReplaceMaterialStruct mStruct = replaceStruct.getMainReplaceM();
        RequireRowData rowData = mStruct.getRequireRowData();
        BigDecimal supplyQty = ReplaceUtil.getSupplyQty(ctx, rowData, supplyTbl, supplys);
        BigDecimal qty = MRPUtil.toBigDecimal(rowData.getValue(DefaultField.RequireField.QTY.getName()));
        BigDecimal newReqQty = qty.subtract(supplyQty);
        if (ReplaceUtil.isBalanced(ctx, rowData, supplyTbl, supplys)) {
            ReplaceUtil.createDependent(ctx, mStruct, newChildren, dict, false, true);
            return true;
        }
        if (supplyQty.compareTo(BigDecimal.ZERO) > 0) {
            rowData.update(DefaultField.RequireField.QTY.getName(), (Object)supplyQty);
            ReplaceUtil.createDependent(ctx, mStruct, newChildren, dict, false, true);
        }
        rowData.setNewQrequireQty(newReqQty);
        for (ReplaceMaterialStruct struct : replaceStruct.getReplaceMs()) {
            RequireRowData row = struct.getRequireRowData();
            if (row == null) continue;
            supplyQty = ReplaceUtil.getSupplyQty(ctx, row, supplyTbl, supplys);
            if (newReqQty.subtract(supplyQty).compareTo(BigDecimal.ZERO) <= 0) {
                row.update(DefaultField.RequireField.QTY.getName(), (Object)newReqQty);
                ReplaceUtil.createDependent(ctx, struct, newChildren, dict, true, false);
                return true;
            }
            newReqQty = newReqQty.subtract(supplyQty);
            if (supplyQty.compareTo(BigDecimal.ZERO) > 0) {
                row.update(DefaultField.RequireField.QTY.getName(), (Object)supplyQty);
                ReplaceUtil.createDependent(ctx, struct, newChildren, dict, true, false);
            }
            rowData.setNewQrequireQty(newReqQty);
        }
        return false;
    }

    private static ReplaceMaterialStruct calNewRequireQty(IMRPEnvProvider ctx, ReplaceMaterialStruct struct, BigDecimal qty, HashMap<RequireRowData, Integer> dict, List<RequireRowData> newChildren, boolean isEqualsReqQty) {
        RequireRowData rowData = struct.getRequireRowData();
        if (rowData == null) {
            return null;
        }
        Integer idx = dict.get(rowData);
        if (idx == null) {
            RequireRowData cloneData = rowData.clone();
            cloneData.setBomRow(rowData.getBomRow());
            cloneData.update(DefaultField.RequireField.QTY.getName(), (Object)qty);
            struct.setRequireRowData(cloneData);
            HashMap<String, RequireRowData> repMap = new HashMap<String, RequireRowData>();
            for (Map.Entry<String, RequireRowData> entry : struct.getRepMaterials().entrySet()) {
                RequireRowData row = entry.getValue();
                RequireRowData cloneRow = row.clone();
                cloneRow.setBomRow(row.getBomRow());
                repMap.put(entry.getKey(), cloneRow);
            }
            struct.setRepMaterials(repMap);
            return struct;
        }
        RequireRowData newData = newChildren.get(idx);
        BigDecimal oldQty = MRPUtil.toBigDecimal(rowData.getValue(DefaultField.RequireField.QTY.getName()));
        qty = qty.add(oldQty);
        rowData.update(DefaultField.RequireField.QTY.getName(), (Object)qty);
        newData.update(DefaultField.RequireField.QTY.getName(), (Object)qty);
        ReplaceUtil.calcStandQty(isEqualsReqQty, qty, rowData);
        ReplaceUtil.calcStandQty(isEqualsReqQty, qty, newData);
        BigDecimal mQty = MRPUtil.toBigDecimal(rowData.getValue(DefaultField.RequireField.__CHILDQTY__.getName()));
        HashMap<String, RequireRowData> repMap = struct.getRepMaterials();
        for (Map.Entry<String, RequireRowData> entry : repMap.entrySet()) {
            RequireRowData repRow = entry.getValue();
            BigDecimal newQty = ReplaceUtil.calcReplaceMaterialQty(qty, mQty, repRow, ctx);
            repRow.update(DefaultField.RequireField.QTY.getName(), (Object)newQty);
            ReplaceUtil.calcStandQty(isEqualsReqQty, newQty, repRow);
            Integer i = dict.get(repRow);
            if (i == null) continue;
            newChildren.get(i).update(DefaultField.RequireField.QTY.getName(), (Object)newQty);
            ReplaceUtil.calcStandQty(isEqualsReqQty, newQty, newChildren.get(i));
        }
        return null;
    }

    private static void createDependent(IMRPEnvProvider ctx, ReplaceMaterialStruct struct, List<RequireRowData> newChildren, HashMap<RequireRowData, Integer> dict, boolean isEqualsReqQty, boolean isMainRequire) {
        RequireRowData rowData = struct.getRequireRowData();
        if (rowData == null) {
            return;
        }
        BigDecimal qty = MRPUtil.toBigDecimal(rowData.getValue(DefaultField.RequireField.QTY.getName()));
        BigDecimal mQty = MRPUtil.toBigDecimal(rowData.getValue(DefaultField.RequireField.__CHILDQTY__.getName()));
        ReplaceUtil.calcStandQty(isEqualsReqQty, qty, rowData);
        RequireRowData newRow = null;
        newRow = isMainRequire ? rowData : DataBalanceUtil.fillDependentRequire(rowData.getBomRow(), rowData, ctx);
        newChildren.add(newRow);
        dict.put(rowData, newChildren.size() - 1);
        HashMap<String, RequireRowData> repMap = struct.getRepMaterials();
        for (Map.Entry<String, RequireRowData> entry : repMap.entrySet()) {
            RequireRowData repRow = entry.getValue();
            BigDecimal newQty = ReplaceUtil.calcReplaceMaterialQty(qty, mQty, repRow, ctx);
            repRow.update(DefaultField.RequireField.QTY.getName(), (Object)newQty);
            ReplaceUtil.calcStandQty(isEqualsReqQty, newQty, repRow);
            RequireRowData data = DataBalanceUtil.fillDependentRequire(repRow.getBomRow(), repRow, ctx);
            newChildren.add(data);
            dict.put(repRow, newChildren.size() - 1);
        }
    }

    private static void calcStandQty(boolean isEqualsReqQty, BigDecimal qty, RequireRowData rowData) {
        rowData.update(DefaultField.RequireField.STAND_QTY.getName(), (Object)qty);
    }

    private static boolean isBalanced(IMRPEnvProvider ctx, RequireRowData rowData, SupplymentDataTable supplyTbl, Map<String, List<Integer>> supplys) {
        BigDecimal supplyQty = ReplaceUtil.getSupplyQty(ctx, rowData, supplyTbl, supplys);
        BigDecimal requireQty = MRPUtil.toBigDecimal(rowData.getValue(DefaultField.RequireField.QTY.getName()));
        return requireQty.compareTo(supplyQty) <= 0;
    }

    private static BigDecimal getSupplyQty(IMRPEnvProvider ctx, RequireRowData rowData, SupplymentDataTable supplyTbl, Map<String, List<Integer>> supplys) {
        String material = String.valueOf(rowData.getValue(DefaultField.RequireField.MATERIAL.getName()));
        if (supplys.get(material) == null) {
            return BigDecimal.ZERO;
        }
        boolean isFlexPropMatch = (Boolean)ctx.getCfgValue(EnvCfgItem.ENABLE_MATERIAL_EXT_PROPS);
        List idxList = supplys.getOrDefault(material, Collections.emptyList());
        BigDecimal sumQty = BigDecimal.ZERO;
        for (Integer idx : idxList) {
            RowData supply = supplyTbl.fetchRow(idx);
            boolean isFlexMatch = DataBalanceUtil.validateFlexPropsMatch(ctx, rowData, supply);
            if (isFlexPropMatch && !isFlexMatch) continue;
            sumQty = sumQty.add(supply.getBigDecimal(DefaultField.SupplyField.QTY.getName()));
        }
        return sumQty;
    }
}

