/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.mservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.table.ColumnDatas;
import kd.mmc.mrp.model.table.GridData;
import kd.mmc.mrp.model.table.res.BOMStructDataTable;
import kd.mmc.mrp.utils.MRPUtil;

public class GenOrderBomService {
    private static final Log logger = LogFactory.getLog(GenOrderBomService.class);
    private static final Object lock = new Object();

    public static void genOrderBomByConfigCode(final IMRPEnvProvider ctx, Map<Long, Set<Long>> org2configs, final GridData.Grid superBomDatas, final Map<Long, Integer> entryId2SuperBom, final Set<Long> entryId2Use, final BOMStructDataTable bomTable, final Map<String, Integer> colIdx) {
        boolean is_call_circular_config_service;
        if (org2configs == null || org2configs.isEmpty()) {
            logger.warn("genOrderBomByConfigCode config isEmpty");
            return;
        }
        if (superBomDatas.isEmpty()) {
            logger.warn(String.format("genOrderBomByConfigCode superBomDatas isEmpty, configId:%s, superBomSize:%s", org2configs, superBomDatas.size()));
            if (bomTable.getSrcDatas().getDatas().isEmpty()) {
                return;
            }
        }
        if (!(is_call_circular_config_service = MRPUtil.convert(ctx.getCfgValue(EnvCfgItem.IS_CALL_CIRCULAR_CONFIG_SERVICE), Boolean.FALSE).booleanValue())) {
            for (Map.Entry<Long, Set<Long>> entry : org2configs.entrySet()) {
                GenOrderBomService.genOrderBomBySingleConfigCode(ctx, "model_mmc", entry.getKey(), null, null, new ArrayList<Long>((Collection)entry.getValue()), superBomDatas, entryId2SuperBom, bomTable, colIdx, entryId2Use);
            }
        } else {
            ExecutorService service = ThreadPools.newExecutorService((String)("mrprunner-configurecode-expand-pool: " + ctx.getMRPContextId()), (int)((Integer)ctx.getCfgValue(EnvCfgItem.MRP_THREAD_COUNT)));
            for (final Map.Entry<Long, Set<Long>> entry : org2configs.entrySet()) {
                service.submit(new Runnable(){

                    @Override
                    public void run() {
                        GenOrderBomService.genOrderBomBySingleConfigCode(ctx, "model_mmc", (Long)entry.getKey(), null, null, new ArrayList<Long>((Collection)entry.getValue()), superBomDatas, entryId2SuperBom, bomTable, colIdx, entryId2Use);
                    }
                });
            }
            service.shutdown();
            try {
                service.awaitTermination((Long)ctx.getCfgValue(EnvCfgItem.MQ_TIMEOUT), TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("mrprunner-configurecode-expand-threadpool-error", e);
            }
        }
    }

    public static Map<Long, List<Long>> genOrderBomBySingleConfigCode(IMRPEnvProvider ctx, String model, Long org, Long matId, Long bomId, List<Long> configIds, GridData.Grid superBomDatas, Map<Long, Integer> entryId2SuperBom, BOMStructDataTable bomTable, Map<String, Integer> colIdx, Set<Long> entryId2Use) {
        try (TraceSpan ts = Tracer.create((String)"GenOrderBomService.genOrderBomBySingleConfigCode", (String)"genOrderBomBySingleConfigCode");){
            Map<Long, List<Long>> map = GenOrderBomService.genOrderBomBySingleConfigCodeImpl(ctx, model, org, matId, bomId, configIds, superBomDatas, entryId2SuperBom, bomTable, colIdx, entryId2Use);
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Long, List<Long>> genOrderBomBySingleConfigCodeImpl(IMRPEnvProvider ctx, String model, Long org, Long matId, Long bomId, List<Long> configIds, GridData.Grid superBomDatas, Map<Long, Integer> entryId2SuperBom, BOMStructDataTable bomTable, Map<String, Integer> colIdx, Set<Long> entryId2Use) {
        HashMap<Long, List<Long>> config2bomIds;
        block5: {
            JSONObject result;
            block4: {
                config2bomIds = new HashMap<Long, List<Long>>(configIds.size());
                JSONObject paramsJson = new JSONObject();
                paramsJson.put("isNeedProRoute", (Object)false);
                paramsJson.put("configCodeList", configIds);
                paramsJson.put("model", (Object)model);
                paramsJson.put("bomId", (Object)bomId);
                paramsJson.put("org", (Object)org);
                paramsJson.put("matId", (Object)matId);
                paramsJson.put("uuid", (Object)ID.genLongId());
                if ("1".equals(ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                    logger.warn(String.format("genOrderBomByConfigCode paramsJson : %s", paramsJson.toJSONString()));
                }
                result = (JSONObject)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pdm", (String)"proConfigListQueryService", (String)"getBatchProdConfigListByFeature", (Object[])new Object[]{paramsJson.toJSONString()});
                String data = result.getString("data");
                String status = result.getString("status");
                if (!"success".equalsIgnoreCase(status) && !"true".equalsIgnoreCase(status)) break block4;
                try {
                    JSONObject resJson = JSONObject.parseObject((String)data);
                    if ("1".equals(ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                        logger.warn(String.format("genOrderBomByConfigCode success data: %s", resJson.toJSONString()));
                    }
                    GenOrderBomService.genOrderBom(resJson, org, ctx, superBomDatas, entryId2SuperBom, bomTable, colIdx, entryId2Use, config2bomIds);
                }
                catch (Throwable throwable) {
                    DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pdm", (String)"proConfigListQueryService", (String)"clearConfigBomExpandCache", (Object[])new Object[]{paramsJson.toJSONString()});
                    throw throwable;
                }
                DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pdm", (String)"proConfigListQueryService", (String)"clearConfigBomExpandCache", (Object[])new Object[]{paramsJson.toJSONString()});
                break block5;
            }
            logger.warn(String.format("genOrderBomByConfigCode failed: %s", result.get((Object)"msg")));
        }
        return config2bomIds;
    }

    private static void genOrderBom(JSONObject resJson, Long orgId, IMRPEnvProvider ctx, GridData.Grid superBomDatas, Map<Long, Integer> entryId2SuperBom, BOMStructDataTable bomTable, Map<String, Integer> colIdx, Set<Long> entryId2Use, Map<Long, List<Long>> config2bomIds) {
        boolean is_record_bom_to_table = MRPUtil.convert(ctx.getCfgValue(EnvCfgItem.IS_RECORD_BOM_TO_TABLE), Boolean.FALSE);
        List configIdKeyList = (List)resJson.getObject("configIdKeyList", List.class);
        String redisCachePath = resJson.getString("redisCachePath");
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(StringUtils.isBlank((CharSequence)redisCachePath) ? "mmc-pdm-configbomsearch" : redisCachePath);
        for (Object configIdKey : configIdKeyList) {
            Map<Long, List<JSONObject>> parentIdMap;
            List<JSONObject> roots;
            String str = String.valueOf(configIdKey);
            Long configId = Long.parseLong(str.substring(0, str.indexOf("_")));
            String cacheValue = (String)cache.get(str);
            JSONObject jsonObject = JSONObject.parseObject((String)cacheValue);
            if (jsonObject == null) continue;
            JSONArray treeEntrys = jsonObject.getJSONArray("treeentryentity");
            if (treeEntrys == null || treeEntrys.isEmpty()) {
                if (!"1".equals(ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) continue;
                String status = jsonObject.getString("success");
                String errorMsg = jsonObject.getString("errorMsg");
                String StackTrace = jsonObject.getString("StackTrace");
                DynamicObject configcode = BusinessDataServiceHelper.loadSingleFromCache((Object)configId, (String)"bd_configuredcode");
                DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org");
                logger.warn(String.format("genOrderBomByConfigCode configempty, key: %s, configno: %s, orgname: %s, status: %s, errorMsg: %s, StackTrace: %s", str, configcode.getString("number"), org.getString("name"), status, errorMsg, StackTrace));
                continue;
            }
            if (is_record_bom_to_table) {
                GenOrderBomService.recordBomToTable(ctx, treeEntrys, configId, str);
            }
            if ((roots = (parentIdMap = GenOrderBomService.groupByParentId(treeEntrys, configId)).get(0L)) == null) continue;
            List bomIds = config2bomIds.computeIfAbsent(configId, k -> new ArrayList(1));
            List<TreeNode> trees = GenOrderBomService.initTree(roots, parentIdMap, superBomDatas, entryId2SuperBom, colIdx, entryId2Use, bomTable);
            for (TreeNode root : trees) {
                bomIds.add(root.getId());
                GenOrderBomService.loadTree(root, bomTable);
            }
        }
    }

    public static void recordBomToTable(IMRPEnvProvider ctx, JSONArray treeEntrys, Long configId, String cacheKey) {
        String runlog = ctx.getRunLogNumber();
        Date date = new Date();
        String MRP_CALCRECORDBOMDATA = "mrp_calcrecordbomdata";
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)MRP_CALCRECORDBOMDATA);
        Map allFields = entityType.getAllFields();
        int batch = 5000;
        ArrayList<DynamicObject> saves = new ArrayList<DynamicObject>(batch);
        for (Object obj : treeEntrys) {
            if (obj == null) continue;
            DynamicObject data = (DynamicObject)entityType.createInstance();
            data.set("runlogno", (Object)runlog);
            data.set("createtime", (Object)date);
            data.set("expendconfigcode", (Object)configId);
            data.set("cachekey", (Object)cacheKey);
            JSONObject tree = obj instanceof JSONObject ? (JSONObject)obj : JSON.parseObject((String)obj.toString());
            for (Map.Entry entry : tree.entrySet()) {
                if (((String)entry.getKey()).equals("id")) {
                    data.set("eid", entry.getValue());
                    continue;
                }
                if (!allFields.containsKey(entry.getKey())) continue;
                data.set((String)entry.getKey(), entry.getValue());
            }
            saves.add(data);
            if (saves.size() != batch) continue;
            SaveServiceHelper.save((DynamicObject[])saves.toArray(new DynamicObject[0]));
            saves.clear();
        }
        if (!saves.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])saves.toArray(new DynamicObject[0]));
            saves.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadTree(TreeNode root, BOMStructDataTable bomTable) {
        int parentIdx = root.getDataIdx();
        for (TreeNode child : root.getChildren()) {
            int childIdx = child.getDataIdx();
            Object object = lock;
            synchronized (object) {
                Long superBomId = MRPUtil.convert(bomTable.getValue(DefaultField.BOMField.__SUPER_BOMID__.getName(), childIdx), 0L);
                if (superBomId == null || superBomId <= 0L) {
                    bomTable.updateValue(DefaultField.BOMField.__SUPER_BOMID__.getName(), childIdx, bomTable.getValue(DefaultField.BOMField.BOMID.getName(), childIdx));
                }
                bomTable.updateValue(DefaultField.BOMField.BOMID.getName(), childIdx, root.getId());
                if (parentIdx >= 0) {
                    bomTable.updateValue(DefaultField.BOMField.MATERIAL.getName(), childIdx, bomTable.getValue(DefaultField.BOMField.CHILDMATERIAL.getName(), parentIdx));
                    bomTable.updateValue(DefaultField.BOMField.CONFIGUREDCODE.getName(), childIdx, bomTable.getValue(DefaultField.BOMField.ENTRYCONFIGUREDCODE.getName(), parentIdx));
                }
                if (root.getConfig() != null) {
                    bomTable.updateValue(DefaultField.BOMField.CONFIGUREDCODE.getName(), childIdx, root.getConfig());
                }
            }
            GenOrderBomService.loadTree(child, bomTable);
        }
    }

    private static List<TreeNode> initTree(List<JSONObject> roots, Map<Long, List<JSONObject>> parentIdMap, GridData.Grid superBomDatas, Map<Long, Integer> entryId2SuperBom, Map<String, Integer> colIdx, Set<Long> entryId2Use, BOMStructDataTable bomTable) {
        ArrayList<TreeNode> allTrees = new ArrayList<TreeNode>(roots.size());
        for (JSONObject N : roots) {
            Long rootId = N.getLong("id");
            Long config = N.getLong("configcode");
            TreeNode root = new TreeNode(0L, rootId, -1);
            root.setConfig(config);
            allTrees.add(root);
            GenOrderBomService.initNodes(root, parentIdMap, superBomDatas, entryId2SuperBom, colIdx, entryId2Use, bomTable);
        }
        return allTrees;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void initNodes(TreeNode root, Map<Long, List<JSONObject>> parentIdMap, GridData.Grid superBomDatas, Map<Long, Integer> entryId2SuperBom, Map<String, Integer> colIdx, Set<Long> entryId2Use, BOMStructDataTable bomTable) {
        Long pid = root.getId();
        List<JSONObject> nodes = parentIdMap.get(pid);
        if (nodes == null) {
            return;
        }
        Iterator<JSONObject> iterator = nodes.iterator();
        while (true) {
            Object[] bomData;
            Object columnDatas;
            int origIdx;
            Long superbomentryId;
            JSONObject node;
            block13: {
                if (!iterator.hasNext()) {
                    return;
                }
                node = iterator.next();
                superbomentryId = node.getLong("superbomentryid");
                Integer dataIdx = entryId2SuperBom.get(superbomentryId);
                origIdx = -1;
                if (dataIdx == null) {
                    columnDatas = bomTable.getCol(DefaultField.BOMField.ENTRYID.getName());
                    origIdx = ((ColumnDatas)columnDatas).getFirstNoCheck(superbomentryId);
                    if (origIdx >= 0) {
                        bomData = bomTable.getSrcDatas().getDatas().get(origIdx);
                        break block13;
                    } else {
                        logger.warn(String.format("genOrderBomByConfigCode not find bomEntry, entryid: %s, node: %s", superbomentryId, node.toJSONString()));
                        continue;
                    }
                }
                bomData = superBomDatas.get(dataIdx);
            }
            columnDatas = lock;
            synchronized (columnDatas) {
                boolean isFirstAdd = false;
                if (entryId2Use != null && entryId2Use.add(superbomentryId)) {
                    isFirstAdd = true;
                } else {
                    bomData = (Object[])bomData.clone();
                    origIdx = -1;
                }
                long configcode = node.getLong("configcode") == null ? 0L : node.getLong("configcode");
                GenOrderBomService.updateBomRowData(bomTable, bomData, colIdx, origIdx, DefaultField.BOMField.ENTRYCONFIGUREDCODE.getName(), configcode);
                GenOrderBomService.updateBomRowData(bomTable, bomData, colIdx, origIdx, DefaultField.BOMField.CHILDNUMERATOR.getName(), node.getBigDecimal("entryqtynumerator"));
                GenOrderBomService.updateBomRowData(bomTable, bomData, colIdx, origIdx, DefaultField.BOMField.CHILDDENOMINATOR.getName(), node.getBigDecimal("entryqtydenominator"));
                BigDecimal entryqty = node.getBigDecimal("entryqtynumerator").divide(node.getBigDecimal("entryqtydenominator"), 10, 5);
                GenOrderBomService.updateBomRowData(bomTable, bomData, colIdx, origIdx, DefaultField.BOMField.CHILDQTY.getName(), entryqty);
                long entrymaterial = node.getLong("entrymaterial_id") == null ? 0L : node.getLong("entrymaterial_id");
                GenOrderBomService.updateBomRowData(bomTable, bomData, colIdx, origIdx, DefaultField.BOMField.CHILDMATERIAL.getName(), entrymaterial);
                String childtype = MRPUtil.convert(bomData[colIdx.get(DefaultField.BOMField.CHILDTYPE.getName())], "");
                if ("B".equals(childtype)) {
                    GenOrderBomService.updateBomRowData(bomTable, bomData, colIdx, origIdx, DefaultField.BOMField.CHILDTYPE.getName(), "A");
                }
                if (origIdx < 0) {
                    int pId = origIdx;
                    if (!isFirstAdd) {
                        pId = bomTable.getCol(DefaultField.BOMField.ENTRYID.getName()).getFirstNoCheck(superbomentryId);
                    }
                    origIdx = bomTable.zipFill(bomData, pId);
                }
            }
            Long id = node.getLong("id");
            TreeNode child = new TreeNode(pid, id, origIdx);
            root.addChild(child);
            GenOrderBomService.initNodes(child, parentIdMap, superBomDatas, entryId2SuperBom, colIdx, entryId2Use, bomTable);
        }
    }

    private static void updateBomRowData(BOMStructDataTable bomTable, Object[] bomData, Map<String, Integer> colIdx, int origIdx, String colName, Object value) {
        bomData[colIdx.get((Object)colName).intValue()] = value;
        if (origIdx >= 0) {
            bomTable.updateValue(colName, origIdx, value);
        }
    }

    private static Map<Long, List<JSONObject>> groupByParentId(JSONArray treeEntrys, Long configId) {
        HashMap<Long, List<JSONObject>> parentIdMap = new HashMap<Long, List<JSONObject>>(16);
        for (Object obj : treeEntrys) {
            if (obj == null) continue;
            JSONObject tree = obj instanceof JSONObject ? (JSONObject)obj : JSON.parseObject((String)obj.toString());
            Long pid = tree.getLong("pid");
            List list = parentIdMap.computeIfAbsent(pid, k -> new ArrayList());
            list.add(tree);
            if (pid != 0L || tree.getLong("configcode") != null && tree.getLong("configcode") > 0L) continue;
            tree.put("configcode", (Object)configId);
        }
        return parentIdMap;
    }

    public static class TreeNode {
        private Long id;
        private Long config;
        private final Long pid;
        private final int dataIdx;
        private final Set<TreeNode> children = new HashSet<TreeNode>();

        public TreeNode(Long pid, Long id, int dataIdx) {
            this.pid = pid;
            this.id = id;
            this.dataIdx = dataIdx;
        }

        public Long getConfig() {
            return this.config;
        }

        public void setConfig(Long config) {
            this.config = config;
        }

        public Long getPid() {
            return this.pid;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public void addChild(TreeNode child) {
            this.children.add(child);
        }

        public Set<TreeNode> getChildren() {
            return this.children;
        }

        public int getDataIdx() {
            return this.dataIdx;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TreeNode treeNode = (TreeNode)o;
            return Objects.equals(this.id, treeNode.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        public String toString() {
            return this.id.toString();
        }
    }
}

