/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.mservice.batchpolicy;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.strategy.MaterialAttribute;
import kd.mmc.mrp.model.table.DataBalanceTable;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.table.utils.DataBalanceUtil;
import kd.mmc.mrp.model.table.utils.DataMatchUtils;
import kd.mmc.mrp.utils.MRPUtil;

public abstract class AbstractBatchProcessor {
    protected IMRPEnvProvider provider;
    protected boolean isClearSupplys = false;

    public AbstractBatchProcessor(IMRPEnvProvider provider) {
        this.provider = provider;
    }

    public BigDecimal productRichMapping(Stack<DataBalanceTable.RSMapping> rsMappingStack, DataBalanceTable.RSMapping mapping, BigDecimal qty) {
        RequireRowData require = mapping.getRequire();
        Long mId = MRPUtil.convert(require.getValue(DefaultField.RequireField.MATERIAL.getName()), 0L);
        DataBalanceTable.RSMapping quoteMapping = rsMappingStack.pop();
        BigDecimal quoteQty = quoteMapping.getrQty();
        DataBalanceTable.RSMapping nsmapping = mapping.clone();
        this.setIsClearSupplys(nsmapping);
        String poNum = quoteMapping.getRequire().getString(DefaultField.RequireField.__BATCHPOLICY_BILLNUMBER__.getName());
        Long poId = quoteMapping.getRequire().getLong(DefaultField.RequireField.__PO_ID__.getName());
        if (quoteQty.compareTo(qty) < 0) {
            nsmapping.setrQty(quoteQty);
            quoteMapping.getRequire().update(DefaultField.RequireField.BATCHPOLICYRICHQTY.getName(), (Object)quoteQty);
        } else {
            nsmapping.setrQty(qty);
            quoteMapping.getRequire().update(DefaultField.RequireField.BATCHPOLICYRICHQTY.getName(), (Object)qty);
        }
        qty = qty.subtract(quoteQty);
        MRPUtil.batchRichUpdateFields(nsmapping, quoteMapping, poNum, poId);
        if (this.provider.getRsMappings().get(mId) != null) {
            List<DataBalanceTable.RSMapping> mappingList = this.provider.getRsMappings().get(mId);
            mappingList.add(nsmapping);
        } else {
            ArrayList<DataBalanceTable.RSMapping> mappingList = new ArrayList<DataBalanceTable.RSMapping>(16);
            mappingList.add(nsmapping);
            this.provider.getRsMappings().put(mId, mappingList);
        }
        return qty;
    }

    public void setCurrentMappingToBatchQty(DataBalanceTable.RSMapping mapping, BigDecimal minBatchQty, Stack<DataBalanceTable.RSMapping> rsMappingStack) {
        this.setCurrentMappingToBatchQty(mapping, null, 0, minBatchQty, rsMappingStack);
    }

    public void setCurrentMappingToBatchQty(DataBalanceTable.RSMapping mapping, Date date, int intervalperiod, BigDecimal batchQty, Stack<DataBalanceTable.RSMapping> rsMappingStack) {
        RequireRowData require = mapping.getRequire();
        if (date != null) {
            MRPUtil.updateDates(0, date, intervalperiod, mapping, this.provider);
        }
        mapping.setVirtualQty(mapping.getBeforeMergedQty());
        mapping.setrQty(batchQty);
        Long reqOrg = require.getLong(DefaultField.RequireField.PRODUCTIONORGUNIT.getName());
        String poNum = MRPUtil.genPONum(this.provider, String.valueOf(reqOrg));
        Long poId = MRPUtil.genLongId();
        mapping.getRequire().update(DefaultField.RequireField.__BATCHPOLICY_BILLNUMBER__.getName(), (Object)poNum);
        mapping.getRequire().update(DefaultField.RequireField.__PO_ID__.getName(), (Object)poId);
        this.setIsClearSupplys(mapping);
        rsMappingStack.push(mapping);
        if (mapping.getChildMappings() != null && !mapping.getChildMappings().isEmpty()) {
            for (DataBalanceTable.RSMapping child : mapping.getChildMappings()) {
                MRPUtil.batchRichUpdateFields(child, mapping, poNum, poId);
            }
        }
    }

    public abstract void splitOrderByMergedMapping(IMRPEnvProvider var1, BigDecimal var2, DataBalanceTable.RSMapping var3, DataBalanceTable.RSMapping var4, String var5, Long var6, List<DataBalanceTable.RSMapping> var7);

    public void splitMappingByBatchQty(DataBalanceTable.RSMapping mapping, BigDecimal mQty, BigDecimal batchQty, Date cycleDate, int intervalperiod, Stack<DataBalanceTable.RSMapping> rsMappingStack) {
        ArrayList<DataBalanceTable.RSMapping> richMapping = new ArrayList<DataBalanceTable.RSMapping>(16);
        RequireRowData require = mapping.getRequire();
        int orders = mQty.divide(batchQty, 0, RoundingMode.FLOOR).intValue();
        BigDecimal lastQty = mQty.subtract(batchQty.multiply(new BigDecimal(orders)));
        for (int o = 0; o < orders; ++o) {
            DataBalanceTable.RSMapping rsmapping = mapping.clone();
            MRPUtil.updateDates(o, cycleDate, intervalperiod, rsmapping, this.provider);
            cycleDate = MRPUtil.addDays(cycleDate, intervalperiod);
            rsmapping.setrQty(batchQty);
            Long reqOrg = require.getLong(DefaultField.RequireField.PRODUCTIONORGUNIT.getName());
            String poNum = MRPUtil.genPONum(this.provider, String.valueOf(reqOrg));
            Long poId = MRPUtil.genLongId();
            rsmapping.getRequire().update(DefaultField.RequireField.__BATCHPOLICY_BILLNUMBER__.getName(), (Object)poNum);
            rsmapping.getRequire().update(DefaultField.RequireField.__PO_ID__.getName(), (Object)poId);
            rsMappingStack.push(rsmapping);
            this.splitOrderByMergedMapping(this.provider, batchQty, mapping, rsmapping, poNum, poId, richMapping);
        }
        if (lastQty.compareTo(BigDecimal.ZERO) > 0) {
            DataBalanceTable.RSMapping rsmapping = mapping.clone();
            MRPUtil.updateDates(orders, cycleDate, intervalperiod, rsmapping, this.provider);
            rsmapping.setrQty(lastQty);
            Long reqOrg = require.getLong(DefaultField.RequireField.PRODUCTIONORGUNIT.getName());
            String poNum = MRPUtil.genPONum(this.provider, String.valueOf(reqOrg));
            Long poId = MRPUtil.genLongId();
            rsmapping.getRequire().update(DefaultField.RequireField.__BATCHPOLICY_BILLNUMBER__.getName(), (Object)poNum);
            rsmapping.getRequire().update(DefaultField.RequireField.__PO_ID__.getName(), (Object)poId);
            rsMappingStack.push(rsmapping);
            this.splitOrderByMergedMapping(this.provider, lastQty, mapping, rsmapping, poNum, poId, richMapping);
        }
        this.provider.calcBalanceDetails().getUnVisitedMappings().remove(mapping);
    }

    public BigDecimal richMappingSupply(DataBalanceTable.RSMapping mapping, Map<Integer, Boolean> cache) {
        RequireRowData require;
        Long mId;
        BigDecimal rQty = mapping.getrQty();
        Map<Long, List<DataBalanceTable.RSMapping>> mappingMap = this.provider.getRsMappings();
        if (mappingMap.get(mId = MRPUtil.convert((require = mapping.getRequire()).getValue(DefaultField.RequireField.MATERIAL.getName()), 0L)) != null) {
            List<DataBalanceTable.RSMapping> mappingList = this.provider.getRsMappings().get(mId);
            Iterator<DataBalanceTable.RSMapping> rsMappingIterator = mappingList.iterator();
            while (rsMappingIterator.hasNext()) {
                Long poId;
                String poNum;
                RowData rowData;
                DataBalanceTable.RSMapping xsMapping = rsMappingIterator.next();
                if (!MRPUtil.convert(xsMapping.getRequire().getValue(DefaultField.RequireField.MATERIALATTR.getName()), MaterialAttribute.OTHER.getValue()).equals(MRPUtil.convert(mapping.getRequire().getValue(DefaultField.RequireField.MATERIALATTR.getName()), MaterialAttribute.OTHER.getValue())) || !MRPUtil.convert(xsMapping.getRequire().getValue(DefaultField.RequireField.__QUOTA_SUPPLIER__.getName()), 0L).equals(MRPUtil.convert(mapping.getRequire().getValue(DefaultField.RequireField.__QUOTA_SUPPLIER__.getName()), 0L)) || !DataBalanceUtil.isMatch(this.provider, require, rowData = DataMatchUtils.rsMappingToSupply(this.provider, xsMapping), cache)) continue;
                BigDecimal richQty = xsMapping.getrQty();
                if (richQty.compareTo(rQty) >= 0) {
                    poNum = xsMapping.getRequire().getString(DefaultField.RequireField.__BATCHPOLICY_BILLNUMBER__.getName());
                    poId = xsMapping.getRequire().getLong(DefaultField.RequireField.__PO_ID__.getName());
                    richQty = richQty.subtract(rQty);
                    mapping.setrQty(rQty);
                    xsMapping.setrQty(richQty);
                    if (richQty.compareTo(BigDecimal.ZERO) <= 0) {
                        rsMappingIterator.remove();
                    }
                    DataBalanceTable.RSMapping newnxMapping = mapping.clone();
                    if (mapping.getBeforeMergedQty() != null && mapping.getBeforeMergedQty().compareTo(BigDecimal.ZERO) > 0) {
                        newnxMapping.setrQty(mapping.getBeforeMergedQty());
                        mapping.setBeforeMergedQty(BigDecimal.ZERO);
                        mapping.setCalDetail(false);
                    }
                    newnxMapping.setGenPlanOrder(false);
                    newnxMapping.setCreateDepentRequire(false);
                    this.setIsClearSupplys(newnxMapping);
                    MRPUtil.batchRichUpdateFields(newnxMapping, xsMapping, poNum, poId);
                    this.provider.calcBalanceDetails().getUnVisitedMappings().add(newnxMapping);
                    if (mapping.getChildMappings() != null && !mapping.getChildMappings().isEmpty()) {
                        for (DataBalanceTable.RSMapping child : mapping.getChildMappings()) {
                            MRPUtil.batchRichUpdateFields(child, xsMapping, poNum, poId);
                        }
                    }
                    this.provider.calcBalanceDetails().getUnVisitedMappings().remove(mapping);
                    return BigDecimal.ZERO;
                }
                if (richQty.compareTo(rQty) >= 0) continue;
                rQty = rQty.subtract(richQty);
                poNum = xsMapping.getRequire().getString(DefaultField.RequireField.__BATCHPOLICY_BILLNUMBER__.getName());
                poId = xsMapping.getRequire().getLong(DefaultField.RequireField.__PO_ID__.getName());
                if (mapping.getChildMappings() != null && mapping.getBeforeMergedQty() != null && mapping.getBeforeMergedQty().compareTo(BigDecimal.ZERO) > 0 && !mapping.getChildMappings().isEmpty()) {
                    DataBalanceTable.RSMapping newnxMapping;
                    boolean isContinue = true;
                    if (xsMapping.getrQty().compareTo(mapping.getBeforeMergedQty()) >= 0 && mapping.getBeforeMergedQty().compareTo(BigDecimal.ZERO) > 0) {
                        newnxMapping = mapping.clone();
                        newnxMapping.setrQty(mapping.getBeforeMergedQty());
                        newnxMapping.setGenPlanOrder(false);
                        newnxMapping.setCreateDepentRequire(false);
                        this.setIsClearSupplys(newnxMapping);
                        MRPUtil.batchRichUpdateFields(newnxMapping, xsMapping, poNum, poId);
                        this.provider.calcBalanceDetails().getUnVisitedMappings().add(newnxMapping);
                        xsMapping.setrQty(xsMapping.getrQty().subtract(mapping.getBeforeMergedQty()));
                        mapping.setBeforeMergedQty(BigDecimal.ZERO);
                        mapping.setCalDetail(false);
                        if (xsMapping.getrQty().compareTo(BigDecimal.ZERO) == 0) {
                            isContinue = false;
                        }
                        if (isContinue) {
                            this.richSupplyChildMappings(mapping, xsMapping, poNum, poId);
                        }
                    } else {
                        mapping.setBeforeMergedQty(mapping.getBeforeMergedQty().subtract(xsMapping.getrQty()));
                        newnxMapping = mapping.clone();
                        newnxMapping.setrQty(xsMapping.getrQty());
                        newnxMapping.setGenPlanOrder(false);
                        this.setIsClearSupplys(newnxMapping);
                        newnxMapping.setCreateDepentRequire(false);
                        MRPUtil.batchRichUpdateFields(newnxMapping, xsMapping, poNum, poId);
                        this.provider.calcBalanceDetails().getUnVisitedMappings().add(newnxMapping);
                    }
                } else if (mapping.getBeforeMergedQty() != null && mapping.getBeforeMergedQty().compareTo(BigDecimal.ZERO) == 0 && !mapping.getChildMappings().isEmpty()) {
                    this.richSupplyChildMappings(mapping, xsMapping, poNum, poId);
                } else {
                    if (mapping.getChildMappings() == null || mapping.getChildMappings().isEmpty()) {
                        mapping.setBeforeMergedQty(rQty);
                    }
                    DataBalanceTable.RSMapping splitMapping = mapping.clone();
                    splitMapping.setrQty(richQty);
                    splitMapping.setGenPlanOrder(false);
                    splitMapping.setCreateDepentRequire(false);
                    if (splitMapping.getPoList() != null) {
                        splitMapping.getPoList().clear();
                    }
                    this.setIsClearSupplys(splitMapping);
                    MRPUtil.batchRichUpdateFields(splitMapping, xsMapping, poNum, poId);
                    this.provider.calcBalanceDetails().getUnVisitedMappings().add(splitMapping);
                }
                rsMappingIterator.remove();
            }
        }
        return rQty;
    }

    public void richSupplyChildMappings(DataBalanceTable.RSMapping mapping, DataBalanceTable.RSMapping xsMapping, String poNum, Long poId) {
        Iterator<DataBalanceTable.RSMapping> childMappingIterator = mapping.getChildMappings().iterator();
        while (childMappingIterator.hasNext() && xsMapping.getrQty().compareTo(BigDecimal.ZERO) > 0) {
            DataBalanceTable.RSMapping child = childMappingIterator.next();
            if (xsMapping.getrQty().compareTo(child.getrQty()) >= 0) {
                xsMapping.setrQty(xsMapping.getrQty().subtract(child.getrQty()));
                childMappingIterator.remove();
                MRPUtil.batchRichUpdateFields(child, xsMapping, poNum, poId);
                continue;
            }
            if (xsMapping.getrQty().compareTo(child.getrQty()) >= 0) continue;
            child.setrQty(child.getrQty().subtract(xsMapping.getrQty()));
            DataBalanceTable.RSMapping newChildMapping = child.clone();
            newChildMapping.setrQty(xsMapping.getrQty());
            newChildMapping.setGenPlanOrder(false);
            newChildMapping.setCreateDepentRequire(false);
            this.setIsClearSupplys(newChildMapping);
            MRPUtil.batchRichUpdateFields(newChildMapping, xsMapping, poNum, poId);
            this.provider.calcBalanceDetails().getUnVisitedMappings().add(newChildMapping);
            xsMapping.setrQty(BigDecimal.ZERO);
            break;
        }
    }

    protected void setIsClearSupplys(DataBalanceTable.RSMapping mapping) {
        if (this.isClearSupplys) {
            mapping.setSupplys(new ArrayList<RowData>());
        } else {
            this.isClearSupplys = true;
        }
    }
}

