/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.mservice.batchpolicy;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.List;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.utils.MRPUtil;

public class BatchCalcService {
    private final boolean isbatchpolicy;

    public BatchCalcService(IMRPEnvProvider ctx) {
        PlanModel planModel = (PlanModel)ctx.getService(PlanModel.class);
        this.isbatchpolicy = (Boolean)planModel.getPlanDataByParam("isbatchpolicy", true);
    }

    public List<BigDecimal> calcBatch(BigDecimal rQty, RequireRowData require) {
        return this.isbatchpolicy ? this.calcBatch(rQty, require, true) : Collections.singletonList(rQty);
    }

    public BigDecimal calcBatchNoSplit(BigDecimal rQty, RequireRowData require) {
        if (this.isbatchpolicy) {
            List<BigDecimal> qtys = this.calcBatch(rQty, require, false);
            return qtys.isEmpty() ? rQty : qtys.get(0);
        }
        return rQty;
    }

    public List<BigDecimal> splitBatchQty(BigDecimal rQty, RequireRowData require) {
        return Collections.singletonList(rQty);
    }

    protected List<BigDecimal> calcBatch(BigDecimal rQty, RequireRowData require, boolean isSplit) {
        return Collections.singletonList(rQty);
    }

    protected void splitMappingByBatchQty(BigDecimal mQty, BigDecimal batchQty, List<BigDecimal> resultQtys) {
        int orders = mQty.divide(batchQty, 0, RoundingMode.FLOOR).intValue();
        BigDecimal lastQty = mQty.subtract(batchQty.multiply(new BigDecimal(orders)));
        for (int o = 0; o < orders; ++o) {
            resultQtys.add(batchQty);
        }
        if (lastQty.compareTo(BigDecimal.ZERO) > 0) {
            resultQtys.add(lastQty);
        }
    }

    protected BigDecimal getMQty(BigDecimal rQty, RequireRowData require) {
        BigDecimal batchincrement = MRPUtil.convert(require.getValue(DefaultField.RequireField.BATCHINCREMENT.getName()), BigDecimal.ZERO);
        BigDecimal batchQty = MRPUtil.convert(require.getValue(DefaultField.RequireField.BATCHINCQTY.getName()), BigDecimal.ZERO);
        rQty = rQty.compareTo(BigDecimal.ZERO) > 0 ? rQty : batchQty;
        return batchQty.compareTo(BigDecimal.ZERO) <= 0 ? rQty : rQty.add(batchincrement).divide(batchQty, 0, RoundingMode.CEILING).multiply(batchQty);
    }
}

