/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.mservice.batchpolicy;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.mservice.batchpolicy.BatchCalcService;
import kd.mmc.mrp.utils.MRPUtil;

public class FixedBatchService
extends BatchCalcService {
    public FixedBatchService(IMRPEnvProvider ctx) {
        super(ctx);
    }

    @Override
    protected List<BigDecimal> calcBatch(BigDecimal rQty, RequireRowData require, boolean isSplit) {
        ArrayList<BigDecimal> resultQtys = new ArrayList<BigDecimal>(2);
        BigDecimal mQty = this.getMQty(rQty, require);
        BigDecimal batchQty = MRPUtil.convert(require.getValue(DefaultField.RequireField.BATCHINCQTY.getName()), BigDecimal.ZERO);
        BigDecimal partitionbase = MRPUtil.convert(require.getValue(DefaultField.RequireField.PARTITIONQTY.getName()), BigDecimal.ZERO);
        if (mQty.compareTo(batchQty) <= 0) {
            mQty = batchQty;
            resultQtys.add(mQty);
        } else if (partitionbase.compareTo(BigDecimal.ZERO) > 0 && isSplit) {
            this.splitMappingByBatchQty(mQty, partitionbase, resultQtys);
        } else {
            resultQtys.add(rQty);
        }
        return resultQtys;
    }

    @Override
    public List<BigDecimal> splitBatchQty(BigDecimal rQty, RequireRowData require) {
        ArrayList<BigDecimal> resultQtys = new ArrayList<BigDecimal>(2);
        BigDecimal partitionbase = MRPUtil.convert(require.getValue(DefaultField.RequireField.PARTITIONQTY.getName()), BigDecimal.ZERO);
        if (partitionbase.compareTo(BigDecimal.ZERO) > 0) {
            this.splitMappingByBatchQty(rQty, partitionbase, resultQtys);
        } else {
            resultQtys.add(rQty);
        }
        return resultQtys;
    }
}

