/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.mservice.fetch;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mrp.business.synnetchange.NetChangeSynHelper;
import kd.mmc.mrp.mservice.api.fetch.INetChangeSynService;
import kd.mmc.mrp.mservice.fetch.NetChangeReleaseComparator;
import kd.mmc.mrp.mservice.netchange.NetChangeOpServiceImpl;

public class NetChangeSynServiceImpl
implements INetChangeSynService {
    private ORM orm = ORM.create();
    private static final String MSMOD_RESERVETRANS = "msmod_reservetrans";
    private static final String MSMOD_RESERVE_RECORD = "msmod_reserve_record";
    private static final String MSPLAN_NET_CHANGE_RECORD = "msplan_net_change_record";
    private static final String MSPLAN_NETCHANGE_TRANS = "msplan_netchange_trans";

    public void syncReserveDatas(QFilter[] deleteQFilter, QFilter[] recordFilter) {
        NetChangeSynHelper.syncReserveDatas((QFilter[])deleteQFilter, (QFilter[])recordFilter);
    }

    public void syncReserveDatas(DynamicObject[] datas) {
        if (datas != null && datas.length > 0) {
            String entityNumber = datas[0].getDataEntityType().getName();
            String dataField = "id";
            if (MSMOD_RESERVE_RECORD.equals(entityNumber)) {
                dataField = "bill_id";
            }
            ArrayList<Long> requireIds = new ArrayList<Long>(datas.length);
            for (DynamicObject data : datas) {
                Long id = data.getLong(dataField);
                requireIds.add(id);
            }
            this.syncReserveDatasByRequireIds(requireIds);
        }
    }

    public void syncReserveDatasByRequireIds(Collection<Long> billIds) {
        QFilter requireFilter = new QFilter("bill_id", "in", billIds);
        QFilter parentIdFilter = new QFilter("parent_id", "=", (Object)0L);
        HashSet<Long> addRecords = new HashSet<Long>(16);
        HashSet<Long> deleteNetChanges = new HashSet<Long>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)NetChangeSynHelper.class.getName(), (String)MSMOD_RESERVE_RECORD, (String)"id", (QFilter[])new QFilter[]{requireFilter}, null);){
            for (Row row : dataSet) {
                addRecords.add(row.getLong("id"));
            }
        }
        dataSet = QueryServiceHelper.queryDataSet((String)NetChangeSynHelper.class.getName(), (String)MSPLAN_NET_CHANGE_RECORD, (String)"id", (QFilter[])new QFilter[]{requireFilter, parentIdFilter}, null);
        var7_7 = null;
        try {
            for (Row row : dataSet) {
                Long id = row.getLong("id");
                if (addRecords.remove(id)) continue;
                deleteNetChanges.add(id);
            }
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (var7_7 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        QFilter idFilter = new QFilter("id", "in", deleteNetChanges);
        QFilter recordFilter = new QFilter("id", "in", addRecords);
        this.syncReserveDatas(new QFilter[]{idFilter}, new QFilter[]{recordFilter});
    }

    public void syncReserveDatasByIds(Collection<Long> ids) {
        QFilter idFilter = new QFilter("id", "in", ids);
        this.syncReserveDatas(new QFilter[]{idFilter}, new QFilter[]{idFilter});
    }

    public void syncCfgDatas(QFilter[] netChangeDeleteFilter, QFilter[] cfgQfilter, QFilter[] queryFilter, boolean isInit) {
        NetChangeSynHelper.syncCfgDatas((QFilter[])netChangeDeleteFilter, (QFilter[])queryFilter, (boolean)isInit);
    }

    private void doUnReleaseOperation(Collection<Long> billIds) {
        QFilter qFilter = new QFilter("billid", "in", billIds);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getSimpleName(), (String)MSMOD_RESERVETRANS, (String)"id", (QFilter[])new QFilter[]{qFilter}, null);){
            for (Row row : dataSet) {
                billIds.remove(row.getLong("id"));
            }
        }
        MainEntityType netChangeType = MetadataServiceHelper.getDataEntityType((String)MSPLAN_NET_CHANGE_RECORD);
        HashSet<Long> afterValues = new HashSet<Long>(16);
        HashMap<Long, DynamicObject> beforeRecords = new HashMap<Long, DynamicObject>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)NetChangeSynServiceImpl.class.getName(), (String)MSPLAN_NETCHANGE_TRANS, (String)"bfrecordid,afrecordid", (QFilter[])new QFilter[]{qFilter}, null);){
            for (Row row : dataSet) {
                Long bfrecordid = row.getLong("bfrecordid");
                Long afrecordid = row.getLong("afrecordid");
                afterValues.add(afrecordid);
                DynamicObject before = (DynamicObject)beforeRecords.get(bfrecordid);
                if (before == null) {
                    before = BusinessDataServiceHelper.loadSingle((Object)bfrecordid, (String)MSPLAN_NET_CHANGE_RECORD, (String)"id,base_qty,qty");
                    beforeRecords.put(bfrecordid, before);
                }
                DynamicObject after = QueryServiceHelper.queryOne((String)MSPLAN_NET_CHANGE_RECORD, (String)"base_qty", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)afrecordid)});
                BigDecimal base_qty = before.getBigDecimal("base_qty");
                base_qty = base_qty.add(after.getBigDecimal("base_qty"));
                before.set("base_qty", (Object)base_qty);
                before.set("qty", (Object)base_qty);
            }
        }
        if (!beforeRecords.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])beforeRecords.values().toArray(new DynamicObject[0]));
        }
        DeleteServiceHelper.delete((IDataEntityType)netChangeType, (Object[])afterValues.toArray(new Long[0]));
        QFilter afterRecordFilter = new QFilter("afrecordid", "in", afterValues);
        DeleteServiceHelper.delete((String)MSPLAN_NETCHANGE_TRANS, (QFilter[])new QFilter[]{afterRecordFilter});
    }

    private void doReleaseOperation(String entityNumber, Collection<Long> billIds) {
        QFilter qFilter = new QFilter("billid", "in", billIds);
        qFilter.and(new QFilter("transbill", "=", (Object)entityNumber));
        HashMap<Long, List> before2afters = new HashMap<Long, List>();
        int size = 0;
        HashMap<Long, String> record2bill = new HashMap<Long, String>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getSimpleName(), (String)MSMOD_RESERVETRANS, (String)"bfrecordid,afrecordid,billid,billentryid", (QFilter[])new QFilter[]{qFilter}, null);){
            for (Row row : dataSet) {
                Long bfrecordid = row.getLong("bfrecordid");
                Long afrecordid = row.getLong("afrecordid");
                List list = before2afters.computeIfAbsent(bfrecordid, k -> new ArrayList());
                list.add(afrecordid);
                Long billid = row.getLong("billid");
                Long billentryid = row.getLong("billentryid");
                record2bill.put(afrecordid, String.format("%s-%s", billid, billentryid));
                ++size;
            }
        }
        Map<Long, List<DynamicObject>> orig2trans = this.getOrig2trans(before2afters.keySet());
        if (orig2trans.isEmpty()) {
            return;
        }
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)MSMOD_RESERVE_RECORD);
        MainEntityType netChangeType = MetadataServiceHelper.getDataEntityType((String)MSPLAN_NET_CHANGE_RECORD);
        Date date = new Date();
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getCurrUserId(), (String)"bos_user", (String)"id");
        HashMap<Long, BigDecimal> updatas = new HashMap<Long, BigDecimal>(16);
        String updateSql = "update t_msplan_change_record set f_qty = ?, f_base_qty = ? where fid = ?";
        ArrayList<DynamicObject> saves = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> saveTrans = new ArrayList<DynamicObject>(16);
        long[] ids = this.orm.genLongIds(MSPLAN_NET_CHANGE_RECORD, size);
        int seq = 0;
        HashMap<String, List> bill2SourceData = new HashMap<String, List>(16);
        for (Map.Entry entry : before2afters.entrySet()) {
            DynamicObject[] afterRecords;
            Long orig = (Long)entry.getKey();
            List<DynamicObject> list = orig2trans.get(orig);
            if (list == null || list.isEmpty()) continue;
            block11: for (DynamicObject afterRecord : afterRecords = BusinessDataServiceHelper.load((Object[])((List)entry.getValue()).toArray(), (DynamicObjectType)mainEntityType)) {
                BigDecimal qty = afterRecord.getBigDecimal("base_qty");
                Long recordId = afterRecord.getLong("id");
                String billAndEntry = record2bill.getOrDefault(recordId, "");
                List bfRows = (List)bill2SourceData.get(billAndEntry);
                if (bfRows == null) {
                    long billId = 0L;
                    long billEntryId = 0L;
                    if (billAndEntry.contains("-")) {
                        String[] targets = billAndEntry.split("-");
                        billId = Long.parseLong(targets[0]);
                        billEntryId = Long.parseLong(targets[1]);
                    }
                    bfRows = BFTrackerServiceHelper.loadSourceRowIds((String)entityNumber, (String)"billentry", (Long[])new Long[]{billId}, (Long[])new Long[]{billEntryId}, (OperateOption)OperateOption.create());
                    bill2SourceData.put(billAndEntry, bfRows);
                }
                boolean isUse = false;
                DynamicObject bal_obj = afterRecord.getDynamicObject("bal_obj");
                String s_billnum = afterRecord.getString("s_billnum");
                Long bal_id = afterRecord.getLong("bal_id");
                Long bal_entryid = afterRecord.getLong("bal_entryid");
                Long s_entryseq = afterRecord.getLong("s_entryseq");
                NetChangeReleaseComparator comparator = new NetChangeReleaseComparator(bfRows, "bal_id", "bal_entryid");
                list.sort(comparator);
                for (DynamicObject netChange : list) {
                    BigDecimal transQty = null;
                    Long netChangeId = netChange.getLong("id");
                    BigDecimal changeQty = netChange.getBigDecimal("base_qty");
                    if (changeQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                    if (changeQty.compareTo(qty) >= 0) {
                        transQty = qty;
                        changeQty = changeQty.subtract(qty);
                    } else {
                        transQty = changeQty;
                        changeQty = BigDecimal.ZERO;
                    }
                    netChange.set("base_qty", (Object)changeQty);
                    netChange.set("qty", (Object)changeQty);
                    updatas.put(netChangeId, changeQty);
                    DynamicObject newNetChange = (DynamicObject)OrmUtils.clone((Object)netChange, (IDataEntityType)netChangeType, (boolean)true, (boolean)true);
                    if (isUse) {
                        newNetChange.set("id", (Object)ids[seq++]);
                        newNetChange.set("parent_id", (Object)recordId);
                    } else {
                        isUse = true;
                        newNetChange.set("id", (Object)recordId);
                        newNetChange.set("parent_id", (Object)0L);
                    }
                    newNetChange.set("base_qty", (Object)transQty);
                    newNetChange.set("qty", (Object)transQty);
                    newNetChange.set("bal_obj", (Object)bal_obj);
                    newNetChange.set("s_billnum", (Object)s_billnum);
                    newNetChange.set("bal_id", (Object)bal_id);
                    newNetChange.set("bal_entryid", (Object)bal_entryid);
                    newNetChange.set("s_entryseq", (Object)s_entryseq);
                    newNetChange.set("creater", (Object)user);
                    newNetChange.set("create_date", (Object)date);
                    saves.add(newNetChange);
                    saveTrans.add(this.genNetChangeTransferRecord(billAndEntry, entityNumber, netChangeId, newNetChange.getLong("id"), "trans", RequestContext.get().getCurrUserId(), date));
                    if ((qty = qty.subtract(transQty)).compareTo(BigDecimal.ZERO) > 0) continue;
                    continue block11;
                }
            }
        }
        if (!saves.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])saves.toArray(new DynamicObject[0]));
        }
        if (!saveTrans.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])saveTrans.toArray(new DynamicObject[0]));
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(updatas.size());
        for (Map.Entry entry : updatas.entrySet()) {
            Object[] p = new Object[]{entry.getValue(), entry.getValue(), entry.getKey()};
            params.add(p);
        }
        if (!params.isEmpty()) {
            DB.executeBatch((DBRoute)new DBRoute("scm"), (String)updateSql, params);
        }
    }

    private Map<Long, List<DynamicObject>> getOrig2trans(Collection<Long> origs) {
        HashMap<Long, List<DynamicObject>> orig2trans = new HashMap<Long, List<DynamicObject>>(origs.size());
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)MSPLAN_NET_CHANGE_RECORD);
        for (Long orig : origs) {
            List<Long> allTransCols = this.getAllTransCols(Collections.singleton(orig));
            allTransCols.add(orig);
            QFilter qFilterId = new QFilter("id", "in", allTransCols);
            QFilter qFilterQty = new QFilter("base_qty", ">", (Object)BigDecimal.ZERO);
            ArrayList<Long> recordIds = new ArrayList<Long>(16);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getSimpleName(), (String)MSPLAN_NET_CHANGE_RECORD, (String)"id", (QFilter[])new QFilter[]{qFilterId, qFilterQty}, null);){
                for (Row row : dataSet) {
                    Long id = row.getLong("id");
                    recordIds.add(id);
                }
            }
            DynamicObject[] datas = BusinessDataServiceHelper.load((Object[])recordIds.toArray(), (DynamicObjectType)mainEntityType);
            orig2trans.put(orig, Arrays.asList(datas));
        }
        return orig2trans;
    }

    private List<Long> getAllTransCols(Collection<Long> origs) {
        ArrayList<Long> allTransCols = new ArrayList<Long>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getSimpleName(), (String)MSPLAN_NET_CHANGE_RECORD, (String)"id", (QFilter[])new QFilter[]{new QFilter("parent_id", "in", origs)}, null);){
            for (Row row : dataSet) {
                Long id = row.getLong("id");
                allTransCols.add(id);
            }
        }
        if (!allTransCols.isEmpty()) {
            allTransCols.addAll(this.getAllTransCols(allTransCols));
        }
        return allTransCols;
    }

    public DynamicObject genNetChangeTransferRecord(String target, String entityNumber, long beforeTransferid, long afterTransferid, String transferType, Long creator, Date createTime) {
        DynamicObject transferObj = this.orm.newDynamicObject(MSPLAN_NETCHANGE_TRANS);
        transferObj.set("transbill", (Object)entityNumber);
        if (target.contains("-")) {
            String[] targets = target.split("[-]");
            transferObj.set("billid", (Object)Long.parseLong(targets[0]));
            transferObj.set("billentryid", (Object)Long.parseLong(targets[1]));
        }
        transferObj.set("bfrecordid", (Object)beforeTransferid);
        transferObj.set("afrecordid", (Object)afterTransferid);
        transferObj.set("transtype", (Object)transferType);
        transferObj.set("creater", (Object)creator);
        transferObj.set("createdate", (Object)createTime);
        return transferObj;
    }

    public void syncReserveDatasBySupplyBill(String entityNumber, Collection<Long> billIds, boolean isRelease) {
        boolean isInChild = this.checkIsChildByModel(entityNumber, "=YNVYZCSQE9");
        boolean isOutChild = this.checkIsChildByModel(entityNumber, "=YNY+STXJX1");
        if (isRelease && isInChild) {
            this.doReleaseOperation(entityNumber, billIds);
        } else if (isInChild) {
            this.doUnReleaseOperation(billIds);
        } else if (isOutChild) {
            if (isRelease) {
                this.dealReleaseOutBills(entityNumber, billIds);
            } else {
                this.dealUnReleaseOutBills(billIds);
            }
        }
    }

    public boolean checkIsChildByModel(String entityNumber, String tplId) {
        return NetChangeOpServiceImpl.isTplExtendEntityByTplId(entityNumber, tplId);
    }

    public void dealUnReleaseOutBills(Collection<Long> billIds) {
        DynamicObject[] releaseOutBills;
        HashMap<Long, BigDecimal> reserveQtyMap = new HashMap<Long, BigDecimal>(16);
        QFilter billFilter = new QFilter("billid", "in", billIds);
        DynamicObject[] dynamicObjectArray = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)NetChangeSynServiceImpl.class.getName(), (String)"msplan_release_record", (String)"reserve_record, billid, entryid, qty", (QFilter[])new QFilter[]{billFilter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                long reserve_record = row.getLong("reserve_record");
                BigDecimal qty = reserveQtyMap.getOrDefault(reserve_record, BigDecimal.ZERO);
                qty = qty.add(row.getBigDecimal("qty"));
                reserveQtyMap.put(reserve_record, qty);
            }
        }
        catch (Throwable object) {
            dynamicObjectArray = object;
            throw object;
        }
        for (DynamicObject releaseOutBill : releaseOutBills = BusinessDataServiceHelper.load((Object[])reserveQtyMap.keySet().toArray(new Long[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)MSPLAN_NET_CHANGE_RECORD))) {
            long id = releaseOutBill.getLong("id");
            BigDecimal qty = releaseOutBill.getBigDecimal("qty");
            BigDecimal reserveQty = reserveQtyMap.getOrDefault(id, BigDecimal.ZERO);
            qty = qty.add(reserveQty);
            releaseOutBill.set("qty", (Object)qty);
            releaseOutBill.set("base_qty", (Object)qty);
        }
        SaveServiceHelper.update((DynamicObject[])releaseOutBills);
        DeleteServiceHelper.delete((String)"msplan_release_record", (QFilter[])new QFilter[]{billFilter});
    }

    public void dealReleaseOutBills(String entityNumber, Collection<Long> billIds) {
        QFilter qFilter = new QFilter("billid", "in", billIds);
        qFilter.and(new QFilter("bill_obj", "=", (Object)entityNumber));
        HashMap<Long, BigDecimal> reserve2ReleaseQty = new HashMap<Long, BigDecimal>();
        HashMap<Long, String> reserve2bill = new HashMap<Long, String>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)NetChangeSynServiceImpl.class.getName(), (String)"msmod_release_record", (String)"reserve_record, billid, entryid, qty", (QFilter[])new QFilter[]{qFilter}, null);){
            for (Row row : dataSet) {
                Long reserve_record = row.getLong("reserve_record");
                Long billid = row.getLong("billid");
                Long entryid = row.getLong("entryid");
                BigDecimal qty = row.getBigDecimal("qty");
                BigDecimal sumQty = reserve2ReleaseQty.getOrDefault(reserve_record, BigDecimal.ZERO);
                sumQty = sumQty.add(qty);
                reserve2ReleaseQty.put(reserve_record, sumQty);
                reserve2bill.put(reserve_record, String.format("%s-%s", billid, entryid));
            }
        }
        Map<Long, List<DynamicObject>> orig2NetChange = this.getOrig2trans(reserve2ReleaseQty.keySet());
        HashMap<String, List> bill2SourceData = new HashMap<String, List>(16);
        Date date = new Date();
        ArrayList<DynamicObject> netChangeReleases = new ArrayList<DynamicObject>(orig2NetChange.size());
        ArrayList<DynamicObject> updates = new ArrayList<DynamicObject>(orig2NetChange.size());
        block10: for (Map.Entry<Long, List<DynamicObject>> entry : orig2NetChange.entrySet()) {
            Long reserveId = entry.getKey();
            List<DynamicObject> list = entry.getValue();
            BigDecimal reserveQty = reserve2ReleaseQty.getOrDefault(reserveId, BigDecimal.ZERO);
            String billAndEntry = reserve2bill.getOrDefault(reserveId, "");
            List bfRows = (List)bill2SourceData.get(billAndEntry);
            if (bfRows == null) {
                long billId = 0L;
                long billEntryId = 0L;
                if (billAndEntry.contains("-")) {
                    String[] targets = billAndEntry.split("-");
                    billId = Long.parseLong(targets[0]);
                    billEntryId = Long.parseLong(targets[1]);
                }
                bfRows = BFTrackerServiceHelper.loadSourceRowIds((String)entityNumber, (String)"billentry", (Long[])new Long[]{billId}, (Long[])new Long[]{billEntryId}, (OperateOption)OperateOption.create());
                bill2SourceData.put(billAndEntry, bfRows);
            }
            NetChangeReleaseComparator comparator = new NetChangeReleaseComparator(bfRows, "bill_id", "billentry_id");
            list.sort(comparator);
            for (DynamicObject netChangeRecord : list) {
                BigDecimal qty = netChangeRecord.getBigDecimal("base_qty");
                if (qty.compareTo(reserveQty) >= 0) {
                    qty = qty.subtract(reserveQty);
                    netChangeReleases.add(this.genReleaseRecord(billAndEntry, entityNumber, netChangeRecord.getLong("id"), reserveQty, RequestContext.get().getCurrUserId(), date));
                    reserveQty = BigDecimal.ZERO;
                } else {
                    reserveQty = reserveQty.subtract(qty);
                    netChangeReleases.add(this.genReleaseRecord(billAndEntry, entityNumber, netChangeRecord.getLong("id"), qty, RequestContext.get().getCurrUserId(), date));
                    qty = BigDecimal.ZERO;
                }
                netChangeRecord.set("qty", (Object)qty);
                netChangeRecord.set("base_qty", (Object)qty);
                updates.add(netChangeRecord);
                if (reserveQty.compareTo(BigDecimal.ZERO) > 0) continue;
                continue block10;
            }
        }
        if (!updates.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])updates.toArray(new DynamicObject[0]));
        }
        if (!netChangeReleases.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])netChangeReleases.toArray(new DynamicObject[0]));
        }
    }

    public DynamicObject genReleaseRecord(String value, String entityNumber, long netChangeRecordId, BigDecimal reserveQty, long creator, Date createTime) {
        String[] ids = value.split("[-]");
        DynamicObject releaseObject = this.orm.newDynamicObject("msplan_release_record");
        long releaseId = this.orm.genLongId("msplan_release_record");
        releaseObject.set("id", (Object)releaseId);
        releaseObject.set("reserve_record", (Object)netChangeRecordId);
        releaseObject.set("bill_obj", (Object)entityNumber);
        releaseObject.set("billid", (Object)ids[0]);
        releaseObject.set("entryid", (Object)ids[1]);
        releaseObject.set("base_qty", (Object)reserveQty);
        releaseObject.set("qty", (Object)reserveQty);
        releaseObject.set("release_type", (Object)"release");
        releaseObject.set("creater", (Object)creator);
        releaseObject.set("create_date", (Object)createTime);
        return releaseObject;
    }

    public DynamicObject getInsertObj(DynamicObject releaseObj, DynamicObject transferObj, BigDecimal reserveQty, Date currentDate, long creator) {
        DynamicObject dynamicObject = this.orm.newDynamicObject(MSPLAN_NET_CHANGE_RECORD);
        long insertId = this.orm.genLongId(MSPLAN_NET_CHANGE_RECORD);
        dynamicObject.set("id", (Object)insertId);
        dynamicObject.set("parent_id", (Object)transferObj.getLong("id"));
        if (transferObj.get("bill_obj") != null) {
            DynamicObject bill_obj = transferObj.getDynamicObject("bill_obj");
            dynamicObject.set("bill_obj", (Object)bill_obj.getString("id"));
        }
        if (transferObj.get("r_sale_org") != null) {
            DynamicObject r_sale_org = transferObj.getDynamicObject("r_sale_org");
            dynamicObject.set("r_sale_org", (Object)r_sale_org.getLong("id"));
        }
        dynamicObject.set("bill_no", transferObj.get("bill_no"));
        dynamicObject.set("bill_id", transferObj.get("bill_id"));
        dynamicObject.set("r_biz_date", transferObj.get("r_biz_date"));
        dynamicObject.set("billentry_id", transferObj.get("billentry_id"));
        dynamicObject.set("billentry_seq", transferObj.get("billentry_seq"));
        dynamicObject.set("bal_obj", (Object)"im_inv_realbalance");
        if (releaseObj.get("s_org") != null) {
            DynamicObject s_org = releaseObj.getDynamicObject("s_org");
            dynamicObject.set("s_org", (Object)s_org.getLong("id"));
        }
        dynamicObject.set("s_billnum", releaseObj.get("s_billnum"));
        dynamicObject.set("bal_id", releaseObj.get("bal_id"));
        dynamicObject.set("bal_entryid", releaseObj.get("bal_entryid"));
        dynamicObject.set("s_entryseq", releaseObj.get("s_entryseq"));
        if (releaseObj.get("s_materiel") != null) {
            DynamicObject s_materiel = releaseObj.getDynamicObject("s_materiel");
            dynamicObject.set("s_materiel", (Object)s_materiel.getLong("id"));
        }
        dynamicObject.set("qty", (Object)reserveQty);
        if (releaseObj.get("s_unit") != null) {
            DynamicObject s_unit = releaseObj.getDynamicObject("s_unit");
            dynamicObject.set("s_unit", (Object)s_unit.getLong("id"));
        }
        dynamicObject.set("base_qty", (Object)reserveQty);
        dynamicObject.set("create_date", (Object)currentDate);
        dynamicObject.set("expiredate", releaseObj.get("expiredate"));
        dynamicObject.set("isweak", transferObj.get("isweak"));
        dynamicObject.set("creater", (Object)creator);
        dynamicObject.set("reservesource", transferObj.get("reservesource"));
        dynamicObject.set("change_type", (Object)Character.valueOf('2'));
        dynamicObject.set("ori_qty", (Object)reserveQty);
        dynamicObject.set("transfertype", transferObj.get("transfertype"));
        dynamicObject.set("priority", transferObj.get("priority"));
        dynamicObject.set("isdepend", transferObj.get("isdepend"));
        return dynamicObject;
    }

    public void genInsertObj(List<DynamicObject> insertObjs, DynamicObject releaseObj, DynamicObject transferObj, BigDecimal reserveQty, Date currentDate, long creator) {
        insertObjs.add(this.getInsertObj(releaseObj, transferObj, reserveQty, currentDate, creator));
    }

    public void synSplitManuFactureOrderRecords(DynamicObject[] datas) {
        if (datas != null && datas.length > 0) {
            Object mftTreeEntryColls;
            HashMap mftOrderEntryMap = new HashMap(16);
            HashSet<Long> mftOrderEntryIds = new HashSet<Long>(16);
            for (DynamicObject dynamicObject : datas) {
                DynamicObjectCollection mftorderBillEntrys = dynamicObject.getDynamicObjectCollection("treeentryentity");
                for (DynamicObject mftOrderEntry : mftorderBillEntrys) {
                    List<DynamicObject> mftOrderEntryList;
                    if (mftOrderEntry.get("srcsplitbillseq") == null) continue;
                    long srcSplitEntryid = mftOrderEntry.getDynamicObject("srcsplitbillseq").getLong("id");
                    mftOrderEntryIds.add(srcSplitEntryid);
                    if (mftOrderEntryMap.get(srcSplitEntryid) == null) {
                        mftOrderEntryList = new ArrayList<DynamicObject>(16);
                        mftOrderEntryList.add(mftOrderEntry);
                        mftOrderEntryMap.put(srcSplitEntryid, mftOrderEntryList);
                        continue;
                    }
                    mftOrderEntryList = (List)mftOrderEntryMap.get(srcSplitEntryid);
                    mftOrderEntryList.add(mftOrderEntry);
                    mftOrderEntryMap.put(srcSplitEntryid, mftOrderEntryList);
                }
            }
            HashSet<Long> mftOrderIds = new HashSet<Long>(16);
            QFilter treeEntryFilter = new QFilter("treeentryentity.id", "in", mftOrderEntryIds);
            Throwable throwable = null;
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)NetChangeSynServiceImpl.class.getName(), (String)"pom_mftorder", (String)"id", (QFilter[])new QFilter[]{treeEntryFilter}, null);){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    mftOrderIds.add(row.getLong("id"));
                }
            }
            catch (Throwable row) {
                Throwable throwable2 = row;
                throw row;
            }
            MainEntityType pom_mftorder = EntityMetadataCache.getDataEntityType((String)"pom_mftorder");
            DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((Object[])mftOrderIds.toArray(), (DynamicObjectType)pom_mftorder);
            HashSet<Long> srcBillEntryDeleteId = new HashSet<Long>(16);
            for (DynamicObject mftOrder3 : dynamicObjectArray) {
                mftTreeEntryColls = mftOrder3.getDynamicObjectCollection("treeentryentity");
                if (mftTreeEntryColls.isEmpty()) continue;
                int index = 0;
                DynamicObject[] dynamicObjectArray2 = mftTreeEntryColls.iterator();
                while (dynamicObjectArray2.hasNext()) {
                    ArrayList<DynamicObject> mftOrderEntryList;
                    DynamicObject mftTreeEntryOrder = (DynamicObject)dynamicObjectArray2.next();
                    Long entryId = mftTreeEntryOrder.getLong("id");
                    if (mftTreeEntryOrder.getBigDecimal("baseqty").compareTo(BigDecimal.ZERO) <= 0) {
                        srcBillEntryDeleteId.add(entryId);
                    }
                    if (mftOrderEntryMap.get(entryId) != null) {
                        mftOrderEntryList = (ArrayList<DynamicObject>)mftOrderEntryMap.get(entryId);
                        mftOrderEntryList.add(index++, mftTreeEntryOrder);
                        continue;
                    }
                    mftOrderEntryList = new ArrayList<DynamicObject>(16);
                    mftOrderEntryList.add(index++, mftTreeEntryOrder);
                    mftOrderEntryMap.put(entryId, mftOrderEntryList);
                }
            }
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)MSPLAN_NET_CHANGE_RECORD);
            QFilter balIdFilter = new QFilter("bal_entryid", "in", mftOrderEntryIds);
            HashSet<Long> idSet = new HashSet<Long>(16);
            DataSet dataSet2 = QueryServiceHelper.queryDataSet((String)NetChangeSynServiceImpl.class.getName(), (String)MSPLAN_NET_CHANGE_RECORD, (String)"id", (QFilter[])new QFilter[]{balIdFilter}, null);
            mftTreeEntryColls = null;
            try {
                while (dataSet2.hasNext()) {
                    Row row = dataSet2.next();
                    idSet.add(row.getLong("id"));
                }
            }
            catch (Throwable row) {
                mftTreeEntryColls = row;
                throw row;
            }
            finally {
                if (dataSet2 != null) {
                    if (mftTreeEntryColls != null) {
                        try {
                            dataSet2.close();
                        }
                        catch (Throwable row) {
                            ((Throwable)mftTreeEntryColls).addSuppressed(row);
                        }
                    } else {
                        dataSet2.close();
                    }
                }
            }
            if (idSet.isEmpty()) {
                return;
            }
            DynamicObject[] netChangeRecords = BusinessDataServiceHelper.load((Object[])idSet.toArray(), (DynamicObjectType)mainEntityType);
            ArrayList<DynamicObject> insertDyns = new ArrayList<DynamicObject>(16);
            ArrayList<DynamicObject> updateDyns = new ArrayList<DynamicObject>(16);
            block24: for (DynamicObject netChangeRecord : netChangeRecords) {
                Long entryId = netChangeRecord.getLong("bal_entryid");
                if (mftOrderEntryMap.get(entryId) == null) continue;
                BigDecimal originQty = netChangeRecord.getBigDecimal("qty");
                List mftOrderEntryList = (List)mftOrderEntryMap.get(entryId);
                int i = 0;
                while (i < mftOrderEntryList.size()) {
                    DynamicObject newMftOrderEntry;
                    DynamicObject mftOrderEntry = (DynamicObject)mftOrderEntryList.get(i);
                    if (mftOrderEntry.getBigDecimal("baseqty").compareTo(BigDecimal.ZERO) <= 0) {
                        ++i;
                        continue;
                    }
                    if (i == 0 && mftOrderEntry.getBigDecimal("baseqty").compareTo(originQty) >= 0) {
                        mftOrderEntry.set("baseqty", (Object)mftOrderEntry.getBigDecimal("baseqty").subtract(originQty));
                        continue block24;
                    }
                    if (i == 0) {
                        BigDecimal baseQty = mftOrderEntry.getBigDecimal("baseqty");
                        netChangeRecord.set("qty", (Object)baseQty);
                        netChangeRecord.set("base_qty", (Object)baseQty);
                        netChangeRecord.set("change_type", (Object)"4");
                        originQty = originQty.subtract(baseQty);
                        mftOrderEntry.set("baseqty", (Object)BigDecimal.ZERO);
                        ++i;
                        updateDyns.add(netChangeRecord);
                        continue;
                    }
                    if (mftOrderEntry.getBigDecimal("baseqty").compareTo(originQty) > 0) {
                        newMftOrderEntry = this.generateCloneNetChangeRecord(netChangeRecord, mftOrderEntry, originQty, mftOrderEntry.getBigDecimal("baseqty").subtract(originQty));
                        insertDyns.add(newMftOrderEntry);
                        continue block24;
                    }
                    originQty = originQty.subtract(mftOrderEntry.getBigDecimal("baseqty"));
                    newMftOrderEntry = this.generateCloneNetChangeRecord(netChangeRecord, mftOrderEntry, mftOrderEntry.getBigDecimal("baseqty"), BigDecimal.ZERO);
                    insertDyns.add(newMftOrderEntry);
                    ++i;
                }
            }
            if (!updateDyns.isEmpty()) {
                SaveServiceHelper.update((DynamicObject[])updateDyns.toArray(new DynamicObject[0]));
            }
            if (!insertDyns.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])insertDyns.toArray(new DynamicObject[0]));
            }
            if (!srcBillEntryDeleteId.isEmpty()) {
                QFilter filter = new QFilter("bal_entryid", "in", srcBillEntryDeleteId);
                DeleteServiceHelper.delete((String)MSPLAN_NET_CHANGE_RECORD, (QFilter[])new QFilter[]{filter});
            }
        }
    }

    public void synSplitPlanOrderRecords(DynamicObject oringinOrder, List<DynamicObject> newOrders) {
        if (oringinOrder != null && !newOrders.isEmpty()) {
            Long oringinOrderId = oringinOrder.getLong("id");
            QFilter bal_idFilter = new QFilter("bal_id", "=", (Object)oringinOrderId);
            HashSet<Long> netChangeIds = new HashSet<Long>(16);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"NetChangeSynServiceImpl_NetChange", (String)MSPLAN_NET_CHANGE_RECORD, (String)"id", (QFilter[])new QFilter[]{bal_idFilter}, null);){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    netChangeIds.add(row.getLong("id"));
                }
            }
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)MSPLAN_NET_CHANGE_RECORD);
            DynamicObject[] netChangeObjs = BusinessDataServiceHelper.load((Object[])netChangeIds.toArray(new Long[0]), (DynamicObjectType)entityType);
            BigDecimal orderQty = oringinOrder.getBigDecimal("orderqty");
            boolean isAlterOriginQty = true;
            if (orderQty.compareTo(BigDecimal.ZERO) > 0) {
                newOrders.add(0, oringinOrder);
                isAlterOriginQty = false;
            }
            ArrayList<DynamicObject> updateObjs = new ArrayList<DynamicObject>(16);
            ArrayList<DynamicObject> insertObjs = new ArrayList<DynamicObject>(16);
            Iterator<DynamicObject> newOrdersIterator = newOrders.iterator();
            DynamicObject splitOrder = newOrdersIterator.next();
            block10: for (DynamicObject netChangeObj : netChangeObjs) {
                BigDecimal splitOrderQty = splitOrder.getBigDecimal("orderqty");
                if (splitOrderQty.compareTo(BigDecimal.ZERO) > 0 && netChangeObj.getBigDecimal("qty").compareTo(splitOrderQty) <= 0) {
                    splitOrderQty = splitOrderQty.subtract(netChangeObj.getBigDecimal("orderqty"));
                    this.updateNetChangeRecordSplitOrder(netChangeObj, splitOrder, netChangeObj.getBigDecimal("orderqty"), isAlterOriginQty);
                    updateObjs.add(netChangeObj);
                    splitOrder.set("orderqty", (Object)splitOrderQty);
                    continue;
                }
                if (splitOrderQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal netChangeQty = netChangeObj.getBigDecimal("qty");
                netChangeQty = netChangeQty.subtract(splitOrderQty);
                this.updateNetChangeRecordSplitOrder(netChangeObj, splitOrder, splitOrderQty, isAlterOriginQty);
                updateObjs.add(netChangeObj);
                splitOrderQty = BigDecimal.ZERO;
                splitOrder.set("orderqty", (Object)splitOrderQty);
                while (newOrdersIterator.hasNext()) {
                    DynamicObject splitNetChangeObj;
                    splitOrder = newOrdersIterator.next();
                    if (splitOrder.getBigDecimal("orderqty").compareTo(netChangeQty) >= 0) {
                        splitNetChangeObj = this.generateSplitNetChangeObj(netChangeObj, splitOrder, netChangeQty);
                        insertObjs.add(splitNetChangeObj);
                        splitOrder.set("orderqty", (Object)splitOrder.getBigDecimal("orderqty").subtract(netChangeQty));
                        continue block10;
                    }
                    splitOrderQty = splitOrder.getBigDecimal("orderqty");
                    splitNetChangeObj = this.generateSplitNetChangeObj(netChangeObj, splitOrder, splitOrderQty);
                    insertObjs.add(splitNetChangeObj);
                    netChangeQty = netChangeQty.subtract(splitOrderQty);
                    splitOrderQty = BigDecimal.ZERO;
                    splitOrder.set("orderqty", (Object)splitOrderQty);
                }
            }
            if (!updateObjs.isEmpty()) {
                SaveServiceHelper.update((DynamicObject[])updateObjs.toArray(new DynamicObject[0]));
            }
            if (!insertObjs.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])insertObjs.toArray(new DynamicObject[0]));
            }
        }
    }

    private DynamicObject generateSplitNetChangeObj(DynamicObject netChangeObj, DynamicObject splitOrder, BigDecimal qty) {
        DynamicObject splitNetChangeObj = (DynamicObject)OrmUtils.clone((IDataEntityBase)netChangeObj, (boolean)true, (boolean)true);
        splitNetChangeObj.set("id", (Object)this.genLongId(MSPLAN_NET_CHANGE_RECORD));
        splitNetChangeObj.set("parent_id", (Object)netChangeObj.getLong("id"));
        splitNetChangeObj.set("s_billnum", (Object)splitOrder.getString("billno"));
        splitNetChangeObj.set("bal_id", (Object)splitOrder.getLong("id"));
        splitNetChangeObj.set("bal_entryid", (Object)splitOrder.getLong("id"));
        splitNetChangeObj.set("qty", (Object)qty);
        splitNetChangeObj.set("base_qty", (Object)qty);
        splitNetChangeObj.set("ori_qty", (Object)qty);
        splitNetChangeObj.set("change_type", (Object)"4");
        return splitNetChangeObj;
    }

    private void updateNetChangeRecordSplitOrder(DynamicObject netChangeObj, DynamicObject splitOrder, BigDecimal qty, boolean isAlterOriginQty) {
        netChangeObj.set("qty", (Object)qty);
        netChangeObj.set("base_qty", (Object)qty);
        netChangeObj.set("s_billnum", (Object)splitOrder.getString("billno"));
        netChangeObj.set("bal_id", (Object)splitOrder.getLong("id"));
        netChangeObj.set("bal_entryid", (Object)splitOrder.getLong("id"));
        netChangeObj.set("change_type", (Object)"4");
        if (isAlterOriginQty) {
            netChangeObj.set("ori_qty", (Object)qty);
        }
    }

    public DynamicObject generateCloneNetChangeRecord(DynamicObject netChangeRecord, DynamicObject mftOrderEntry, BigDecimal qty, BigDecimal richQty) {
        DynamicObject newMftOrderEntry = (DynamicObject)OrmUtils.clone((IDataEntityBase)netChangeRecord, (boolean)true, (boolean)true);
        newMftOrderEntry.set("id", (Object)this.genLongId(MSPLAN_NET_CHANGE_RECORD));
        newMftOrderEntry.set("parent_id", (Object)netChangeRecord.getLong("id"));
        newMftOrderEntry.set("qty", (Object)qty);
        newMftOrderEntry.set("base_qty", (Object)qty);
        newMftOrderEntry.set("ori_qty", (Object)qty);
        DynamicObject parent = (DynamicObject)mftOrderEntry.getParent();
        newMftOrderEntry.set("s_billnum", (Object)parent.getString("billno"));
        newMftOrderEntry.set("bal_id", (Object)parent.getLong("id"));
        newMftOrderEntry.set("bal_entryid", (Object)mftOrderEntry.getLong("id"));
        newMftOrderEntry.set("s_entryseq", (Object)mftOrderEntry.getInt("seq"));
        newMftOrderEntry.set("change_type", (Object)"4");
        mftOrderEntry.set("baseqty", (Object)richQty);
        return newMftOrderEntry;
    }

    public Long genLongId(String entityNumber) {
        return ORM.create().genLongId(entityNumber);
    }
}

