/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.mservice.netchange;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mrp.mservice.api.netchange.INetChangeOpService;
import kd.mmc.mrp.mservice.fetch.NetChangeSynServiceImpl;

public class NetChangeOpServiceImpl
implements INetChangeOpService {
    private static final String MSPLAN_NET_CHANGE_RECORD = "msplan_net_change_record";
    private static final String RESERVE_REQUIRE_MODULE = "msmod_std_request_bill";
    private static final String RESERVE_SUPPLY_MODULE = "msmod_std_inv_field";
    private static final String MRP_PLANORDERTPL = "mrp_planordertpl";
    private static final String MPDM_MFTBILLTPL = "mpdm_mftbilltpl";
    private static final String MPDM_MANUFSTOCKTPL = "mpdm_manufstocktpl";
    private static final Log log = LogFactory.getLog(NetChangeOpServiceImpl.class);
    private static String[] requireFields = new String[]{"bill_obj", "bill_id", "billentry_id", "bill_no", "billentry_seq"};
    private static String[] supplyFields = new String[]{"bal_obj", "bal_id", "bal_entryid", "s_billnum", "s_entryseq"};

    public OperationResult netChangeAlterOp(String entityNumber, Collection<Long> billIds) {
        OperationResult operationResult = new OperationResult();
        operationResult.setSuccess(true);
        try {
            QFilter qFilter = new QFilter("base_qty", ">", (Object)BigDecimal.ZERO);
            QFilter[] qFilters = new QFilter[3];
            qFilters[2] = qFilter;
            qFilters[0] = new QFilter("bill_obj", "=", (Object)entityNumber).and(new QFilter("isdepend", "=", (Object)Boolean.FALSE));
            qFilters[1] = new QFilter("bill_id", "in", billIds);
            String sel = "id,parent_id,change_type,qty,base_qty,transfertype,bill_id,billentry_id,bal_id,bal_entryid,priority";
            DynamicObject[] reqs = BusinessDataServiceHelper.load((String)MSPLAN_NET_CHANGE_RECORD, (String)sel, (QFilter[])qFilters, (String)"priority");
            this.alterOp(entityNumber, reqs, true);
            qFilters[0] = new QFilter("bal_obj", "=", (Object)entityNumber);
            qFilters[1] = new QFilter("bal_id", "in", billIds);
            DynamicObject[] sups = BusinessDataServiceHelper.load((String)MSPLAN_NET_CHANGE_RECORD, (String)sel, (QFilter[])qFilters, (String)"priority");
            this.alterOp(entityNumber, sups, false);
        }
        catch (Exception ex) {
            log.error(String.format("NetChangeAlter_Operate_Error:%s", ex.getMessage()), (Throwable)ex);
            throw ex;
        }
        return operationResult;
    }

    private void alterOp(String entityNumber, DynamicObject[] datas, boolean isRequire) {
        Serializable id;
        if (datas.length <= 0) {
            return;
        }
        DynamicObject type = BusinessDataServiceHelper.loadSingleFromCache((Object)entityNumber, (String)"bos_entityobject");
        HashSet<Long> billIds = new HashSet<Long>(datas.length);
        String idField = isRequire ? "bill_id" : "bal_id";
        String entryIdField = isRequire ? "billentry_id" : "bal_entryid";
        HashMap id2bill = new HashMap(16);
        HashMap<Object, BigDecimal> bill2oriQty = new HashMap<Object, BigDecimal>(16);
        for (DynamicObject data : datas) {
            id = Long.valueOf(data.getLong(idField));
            Long entryId = data.getLong(entryIdField);
            String key = String.format("%s-%s", id, entryId);
            List list = id2bill.computeIfAbsent(key, k -> new ArrayList(16));
            list.add(data);
            billIds.add((Long)id);
            BigDecimal qty = data.getBigDecimal("base_qty");
            qty = qty.add(bill2oriQty.getOrDefault(key, BigDecimal.ZERO));
            bill2oriQty.put(key, qty);
        }
        HashMap<String, BigDecimal> bill2Qty = new HashMap<String, BigDecimal>(16);
        String reserveMapping = this.getSelectFields(entityNumber, true, isRequire);
        String select = StringUtils.isNotBlank((CharSequence)reserveMapping) ? String.format("id,%s", reserveMapping) : "id";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"NetChangeTransferOpAction", (String)entityNumber, (String)select, (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)}, null);
        id = null;
        try {
            RowMeta rowMeta = dataSet.getRowMeta();
            for (Row row : dataSet) {
                String key;
                BigDecimal oriQty;
                BigDecimal qty;
                BigDecimal rQty = null;
                BigDecimal sQty = null;
                Long entryId = 0L;
                Long id2 = row.getLong("id");
                if (rowMeta.getFieldIndex("rqty", false) >= 0) {
                    sQty = rQty = row.getBigDecimal("rqty");
                }
                if (rowMeta.getFieldIndex("sqty", false) >= 0) {
                    sQty = row.getBigDecimal("sqty");
                }
                if (rowMeta.getFieldIndex("entryid", false) >= 0) {
                    entryId = row.getLong("entryid");
                }
                BigDecimal bigDecimal = qty = isRequire ? rQty : sQty;
                if (qty == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684%1$s-\u9884\u7559%2$s\u6a21\u578b\u7684\u9884\u7559\u6620\u5c04\u914d\u7f6e\u3002", (String)"NetChangeOpServiceImpl_1", (String)"mmc-mrp-mservice", (Object[])new Object[0]), type.getString("name"), isRequire ? ResManager.loadKDString((String)"\u9700\u6c42", (String)"NetChangeOpServiceImpl_2", (String)"mmc-mrp-mservice", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4f9b\u5e94", (String)"NetChangeOpServiceImpl_3", (String)"mmc-mrp-mservice", (Object[])new Object[0])));
                }
                if (entryId == 0L) {
                    entryId = id2;
                }
                if (qty.compareTo(oriQty = bill2oriQty.getOrDefault(key = String.format("%s-%s", id2, entryId), BigDecimal.ZERO)) >= 0 || qty.compareTo(BigDecimal.ZERO) < 0) continue;
                bill2Qty.put(key, oriQty.subtract(qty));
            }
        }
        catch (Throwable throwable) {
            id = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (id != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)id).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        ArrayList<DynamicObject> updates = new ArrayList<DynamicObject>(16);
        HashMap<Long, Map<String, BigDecimal>> parent2reserveQty = new HashMap<Long, Map<String, BigDecimal>>(16);
        block11: for (Map.Entry entry : bill2Qty.entrySet()) {
            BigDecimal qty = (BigDecimal)entry.getValue();
            List list = id2bill.getOrDefault(entry.getKey(), Collections.emptyList());
            for (DynamicObject data : list) {
                BigDecimal baseQty = data.getBigDecimal("base_qty");
                String change_type = data.getString("change_type");
                long parentId = data.getLong("parent_id");
                String transfertype = data.getString("transfertype");
                if (parentId > 0L && "2".equals(change_type)) {
                    BigDecimal newQty = baseQty.compareTo(qty) >= 0 ? qty : baseQty;
                    Map transfertype2qty = parent2reserveQty.computeIfAbsent(parentId, k -> new HashMap(4));
                    transfertype2qty.put(transfertype, transfertype2qty.getOrDefault(transfertype, BigDecimal.ZERO).add(newQty));
                }
                updates.add(data);
                if (baseQty.compareTo(qty) >= 0) {
                    data.set("base_qty", (Object)baseQty.subtract(qty));
                    data.set("qty", (Object)baseQty.subtract(qty));
                    continue block11;
                }
                data.set("base_qty", (Object)BigDecimal.ZERO);
                data.set("qty", (Object)BigDecimal.ZERO);
                qty = qty.subtract(baseQty);
            }
        }
        if (!updates.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])updates.toArray(new DynamicObject[0]));
        }
        this.transferRestoreQty(parent2reserveQty);
    }

    public OperationResult[] netChangeCommonOp(String entityNumber, Collection<Long> billIds, String op, OperateOption option) {
        QFilter entityFilter = new QFilter("billobject.number", "=", (Object)entityNumber);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        ArrayList<OperationResult> operationResults = new ArrayList<OperationResult>(2);
        if ("msmod_reserve_service_cfg".equals(entityNumber)) {
            operationResults.add(this.netChangeConfigAutoSynOp(billIds));
            return operationResults.toArray(new OperationResult[0]);
        }
        if ("msmod_reserve_record".equals(entityNumber)) {
            NetChangeOpServiceImpl.synNetChangeRecordsByReserve(billIds);
            this.netChangeRecordRelease(new HashSet<Long>(billIds));
            return operationResults.toArray(new OperationResult[0]);
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)NetChangeSynServiceImpl.class.getName(), (String)"msplan_reservecfg", (String)"group.number as group, billoperation", (QFilter[])new QFilter[]{entityFilter, enableFilter}, null);){
            while (dataSet.hasNext()) {
                Set<String> opeSets;
                Row row = dataSet.next();
                String group = "";
                if (row.get("group") != null) {
                    group = row.getString("group");
                }
                if (!(opeSets = this.getOps(row)).contains(op)) continue;
                switch (group) {
                    case "MMCAutoNetChangeService": {
                        operationResults.add(this.netChangeAutoReserveOp(entityNumber, billIds));
                        break;
                    }
                    case "MMCUnAutoNetChangeService": {
                        operationResults.add(this.netChangeUnAutoReserveOp(entityNumber, billIds));
                        break;
                    }
                    case "MMCNetChangeDeleteService": {
                        operationResults.add(this.netChangeDeleteReserveOp(entityNumber, billIds));
                        break;
                    }
                    case "MMCNetChangeTransferService": {
                        operationResults.add(this.netChangeTransferReserveOp(entityNumber, billIds));
                        break;
                    }
                    case "MMCAutoNetChangeReleaseService": {
                        operationResults.add(this.netChangeReleaseReserveOp(entityNumber, billIds, op, option));
                        break;
                    }
                    case "MMCAutoNetChangeURService": {
                        operationResults.add(this.netChangeUnReleaseReserveOp(entityNumber, billIds, op, option));
                        break;
                    }
                    case "MMCAutoNetChangeAlterService": {
                        operationResults.add(this.netChangeAlterOp(entityNumber, billIds));
                        break;
                    }
                }
            }
        }
        return operationResults.toArray(new OperationResult[0]);
    }

    public OperationResult netChangeDeleteReserveOp(String entityNumber, Collection<Long> billIds) {
        OperationResult operationResult = new OperationResult();
        operationResult.setSuccess(true);
        try {
            if (StringUtils.isBlank((CharSequence)entityNumber)) {
                throw new KDBizException("entity is empty.");
            }
            QFilter requireFilter = new QFilter("bill_obj", "=", (Object)entityNumber);
            requireFilter.and(new QFilter("bill_id", "in", billIds));
            QFilter supplyFilter = new QFilter("bal_obj", "=", (Object)entityNumber);
            supplyFilter.and(new QFilter("bal_id", "in", billIds));
            ArrayList<Long> recordIds = new ArrayList<Long>(16);
            HashMap<Long, Map<String, BigDecimal>> parent2reserveQty = new HashMap<Long, Map<String, BigDecimal>>(16);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"NetChangeDeleteOpAction", (String)MSPLAN_NET_CHANGE_RECORD, (String)"id,parent_id,base_qty,change_type,transfertype", (QFilter[])new QFilter[]{requireFilter.or(supplyFilter)}, null);){
                for (Row row : dataSet) {
                    Long id = row.getLong("id");
                    recordIds.add(id);
                    Long parentId = row.getLong("parent_id");
                    String change_type = row.getString("change_type");
                    String transfertype = row.getString("transfertype");
                    if (parentId <= 0L || parentId.equals(id) || !StringUtils.equalsIgnoreCase((CharSequence)change_type, (CharSequence)"2")) continue;
                    BigDecimal baseQty = row.getBigDecimal("base_qty");
                    Map transfertype2qty = parent2reserveQty.computeIfAbsent(parentId, k -> new HashMap(4));
                    BigDecimal qty = transfertype2qty.getOrDefault(transfertype, BigDecimal.ZERO);
                    transfertype2qty.put(transfertype, qty.add(baseQty));
                }
            }
            DeleteServiceHelper.delete((String)MSPLAN_NET_CHANGE_RECORD, (QFilter[])new QFilter[]{new QFilter("id", "in", recordIds)});
            this.transferRestoreQty(parent2reserveQty);
        }
        catch (Exception ex) {
            log.error(String.format("NetChangeDelete_Operate_Error:%s", ex.getMessage()), (Throwable)ex);
            throw ex;
        }
        return operationResult;
    }

    private void transferRestoreQty(Map<Long, Map<String, BigDecimal>> parent2reserveQty) {
        DynamicObject[] updates;
        for (DynamicObject data : updates = BusinessDataServiceHelper.load((String)MSPLAN_NET_CHANGE_RECORD, (String)"id,qty,base_qty,bill_obj,bal_obj", (QFilter[])new QFilter[]{new QFilter("id", "in", parent2reserveQty.keySet())})) {
            Map transfertype2qty = parent2reserveQty.getOrDefault(data.getLong("id"), new HashMap(0));
            DynamicObject bill_obj = data.getDynamicObject("bill_obj");
            DynamicObject bal_obj = data.getDynamicObject("bal_obj");
            String bill_entity = bill_obj == null ? "" : bill_obj.getString("number");
            String bal_entity = bal_obj == null ? "" : bal_obj.getString("number");
            boolean isRequire = NetChangeOpServiceImpl.isTplExtendEntity(bill_entity, MRP_PLANORDERTPL);
            boolean isSupply = NetChangeOpServiceImpl.isTplExtendEntity(bal_entity, MRP_PLANORDERTPL);
            for (Map.Entry entry : transfertype2qty.entrySet()) {
                String transfertype = (String)entry.getKey();
                BigDecimal qty = (BigDecimal)entry.getValue();
                if (StringUtils.equalsIgnoreCase((CharSequence)transfertype, (CharSequence)"0") && isRequire || StringUtils.equalsIgnoreCase((CharSequence)transfertype, (CharSequence)"1") && isSupply) continue;
                data.set("qty", (Object)data.getBigDecimal("qty").add(qty));
                data.set("base_qty", (Object)data.getBigDecimal("base_qty").add(qty));
            }
        }
        if (updates.length > 0) {
            SaveServiceHelper.update((DynamicObject[])updates);
        }
    }

    public OperationResult netChangeAutoReserveOp(String entityNumber, Collection<Long> billIds) {
        OperationResult operationResult = new OperationResult();
        operationResult.setSuccess(true);
        try {
            Set<Long> ids = this.getRecordIdsByRequireBills(entityNumber, billIds);
            NetChangeSynServiceImpl iNetChangeSynService = new NetChangeSynServiceImpl();
            iNetChangeSynService.syncReserveDatasByRequireIds(billIds);
            this.netChangeRecordRelease(ids);
        }
        catch (Exception ex) {
            log.error(String.format("NetChangeAutoReserve_Operate_Error:%s", ex.getMessage()), (Throwable)ex);
            throw ex;
        }
        return operationResult;
    }

    public OperationResult netChangeReleaseReserveOp(String entityNumber, Collection<Long> billIds, String op, OperateOption option) {
        OperationResult operationResult = new OperationResult();
        operationResult.setSuccess(true);
        try {
            NetChangeSynServiceImpl iNetChangeSynService = new NetChangeSynServiceImpl();
            iNetChangeSynService.syncReserveDatasBySupplyBill(entityNumber, billIds, true);
        }
        catch (Exception ex) {
            log.error(String.format("NetChangeReleaseReserve_Operate_Error:%s", ex.getMessage()), (Throwable)ex);
            throw ex;
        }
        return operationResult;
    }

    public OperationResult netChangeTransferReserveOp(String entityNumber, Collection<Long> billIds) {
        OperationResult operationResult = new OperationResult();
        operationResult.setSuccess(true);
        try {
            List list = BFTrackerServiceHelper.loadSourceRowIds((String)entityNumber, (Long[])billIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
            if (list.isEmpty()) {
                return operationResult;
            }
            MainEntityType billEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
            QFilter changeTypeFilter = new QFilter("change_type", "=", (Object)"2");
            QFilter qtyFilter = new QFilter("base_qty", ">", (Object)0);
            ArrayList<DynamicObject> saves = new ArrayList<DynamicObject>(list.size());
            ArrayList<DynamicObject> updates = new ArrayList<DynamicObject>(list.size());
            String select = this.getSelectFields(entityNumber);
            HashMap<String, Map> entity2Stocks = new HashMap<String, Map>(2);
            String orderEntryKey = "treeentryentity";
            String mftStockEntryKey = "stockentry";
            EntityType entryEntity = (EntityType)billEntityType.getAllEntities().get(mftStockEntryKey);
            String bomEntryIdKey = "bomentryid";
            String planOrderEntryKey = "entryentity";
            String planOrderBomEntryIdKey = "entrybomentryid";
            StringBuilder selectFields = new StringBuilder();
            for (BFRow bFRow : list) {
                selectFields.setLength(0);
                selectFields.append(select);
                BFRowId sourceRow = bFRow.getSId();
                BFRowId targetRow = bFRow.getId();
                TableDefine sourceTable = ConvertMetaServiceHelper.loadTableDefine((Long)sourceRow.getTableId());
                TableDefine targetTable = ConvertMetaServiceHelper.loadTableDefine((Long)targetRow.getTableId());
                if (!entityNumber.equalsIgnoreCase(targetTable.getEntityNumber())) continue;
                if (NetChangeOpServiceImpl.isTplExtendEntity(targetTable.getEntityNumber(), MPDM_MANUFSTOCKTPL) && NetChangeOpServiceImpl.isTplExtendEntity(sourceTable.getEntityNumber(), MPDM_MFTBILLTPL) && entryEntity != null && entryEntity.getProperty(bomEntryIdKey) != null) {
                    Map mftStockPramMap = entity2Stocks.computeIfAbsent(sourceTable.getEntityNumber(), k -> new HashMap(16));
                    mftStockPramMap.put(String.format("%s\u0001%s", sourceRow.getBillId(), sourceRow.getEntryId()), new MftStockPram(targetRow, targetTable, String.format("%s,%s.id as entryid,%s.seq as seq,%s.%s as %s", select, mftStockEntryKey, mftStockEntryKey, mftStockEntryKey, bomEntryIdKey, bomEntryIdKey)));
                    continue;
                }
                boolean isEntryPush = !StringUtils.equalsIgnoreCase((CharSequence)targetTable.getEntityKey(), (CharSequence)targetTable.getEntityNumber());
                QFilter qFilter = new QFilter("id", "=", (Object)targetRow.getBillId());
                if (isEntryPush) {
                    qFilter.and(new QFilter(String.format("%s.id", targetTable.getEntityKey()), "=", (Object)targetRow.getEntryId()));
                    selectFields.append(", ").append(targetTable.getEntityKey()).append(".seq as seq");
                }
                ArrayList<TransFerRecordPram> reqs = new ArrayList<TransFerRecordPram>(1);
                ArrayList<TransFerRecordPram> sups = new ArrayList<TransFerRecordPram>(1);
                this.initTransFerRecordPram(targetTable.getEntityNumber(), selectFields.toString(), qFilter, reqs, sups);
                if (reqs.isEmpty() || sups.isEmpty()) continue;
                TransFerRecordPram reqPram = (TransFerRecordPram)reqs.get(0);
                reqPram.setSourceRow(sourceRow);
                reqPram.setSourceTable(sourceTable);
                reqPram.setTargetRow(targetRow);
                reqPram.setTargetTable(targetTable);
                reqPram.setChangeTypeFilter(changeTypeFilter);
                reqPram.setQtyFilter(qtyFilter);
                reqPram.setFields(requireFields);
                this.initTransFerRecordData(reqPram, "0", saves, updates);
                TransFerRecordPram supPram = (TransFerRecordPram)sups.get(0);
                supPram.setSourceRow(sourceRow);
                supPram.setSourceTable(sourceTable);
                supPram.setTargetRow(targetRow);
                supPram.setTargetTable(targetTable);
                supPram.setChangeTypeFilter(changeTypeFilter);
                supPram.setQtyFilter(qtyFilter);
                supPram.setFields(supplyFields);
                this.initTransFerRecordData(supPram, "1", saves, updates);
            }
            for (Map.Entry entry : entity2Stocks.entrySet()) {
                String entity = (String)entry.getKey();
                Map mftStockPramMap = (Map)entry.getValue();
                Long[] ids = new Long[mftStockPramMap.size()];
                Long[] entryIds = new Long[mftStockPramMap.size()];
                int i = 0;
                for (String key : mftStockPramMap.keySet()) {
                    String[] str = key.split("\u0001");
                    long billId = Long.parseLong(str[0]);
                    long entryId = Long.parseLong(str[1]);
                    ids[i] = billId;
                    entryIds[i] = entryId;
                    ++i;
                }
                List bfRowList = BFTrackerServiceHelper.loadSourceRowIds((String)entity, (String)orderEntryKey, (Long[])ids, (Long[])entryIds, (OperateOption)OperateOption.create());
                if (bfRowList.isEmpty()) continue;
                String selectPlanOrderFields = String.format("%s.id as entryid, %s.%s as %s", planOrderEntryKey, planOrderEntryKey, planOrderBomEntryIdKey, planOrderBomEntryIdKey);
                for (BFRow bf : bfRowList) {
                    BFRowId sourceRow = bf.getSId();
                    MftStockPram mftStockPram = (MftStockPram)mftStockPramMap.get(String.format("%s\u0001%s", bf.getId().getBillId(), bf.getId().getEntryId()));
                    TableDefine sourceTable = ConvertMetaServiceHelper.loadTableDefine((Long)sourceRow.getTableId());
                    if (mftStockPram == null || !NetChangeOpServiceImpl.isTplExtendEntity(sourceTable.getEntityNumber(), MRP_PLANORDERTPL)) continue;
                    ArrayList<TransFerRecordPram> reqs = new ArrayList<TransFerRecordPram>(1);
                    ArrayList<TransFerRecordPram> sups = new ArrayList<TransFerRecordPram>(1);
                    QFilter qFilter = new QFilter("id", "=", (Object)mftStockPram.stockRow.getBillId());
                    this.initTransFerRecordPram(mftStockPram.stockTable.getEntityNumber(), mftStockPram.selectFields, qFilter, reqs, sups);
                    qFilter.__setValue((Object)sourceRow.getBillId());
                    List<Map<String, Object>> planOrders = this.getQueryData(sourceTable.getEntityNumber(), selectPlanOrderFields, qFilter);
                    if (planOrders.isEmpty() || reqs.isEmpty()) continue;
                    block6: for (Map<String, Object> plan : planOrders) {
                        Long bomEntryId = (Long)plan.get(planOrderBomEntryIdKey);
                        Long planEntryId = (Long)plan.get("entryid");
                        if (bomEntryId == null || planEntryId == null || bomEntryId <= 0L || planEntryId <= 0L) continue;
                        BFRowId newSourceRow = new BFRowId(sourceRow.getMainTableId(), sourceRow.getBillId(), sourceRow.getTableId(), planEntryId);
                        Iterator its = reqs.iterator();
                        while (its.hasNext()) {
                            TransFerRecordPram stockPram = (TransFerRecordPram)its.next();
                            if (!bomEntryId.equals(stockPram.bomentryid) || stockPram.entryId == null || stockPram.entryId <= 0L) continue;
                            BFRowId targetRow = new BFRowId(mftStockPram.stockRow.getMainTableId(), mftStockPram.stockRow.getBillId(), mftStockPram.stockRow.getTableId(), stockPram.entryId);
                            stockPram.setSourceRow(newSourceRow);
                            stockPram.setSourceTable(sourceTable);
                            stockPram.setTargetRow(targetRow);
                            stockPram.setTargetTable(mftStockPram.stockTable);
                            stockPram.setChangeTypeFilter(changeTypeFilter);
                            stockPram.setQtyFilter(qtyFilter);
                            stockPram.setFields(requireFields);
                            this.initTransFerRecordData(stockPram, "0", saves, updates);
                            its.remove();
                            continue block6;
                        }
                    }
                }
            }
            if (!saves.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])saves.toArray(new DynamicObject[0]));
            }
            if (!updates.isEmpty()) {
                SaveServiceHelper.update((DynamicObject[])updates.toArray(new DynamicObject[0]));
            }
        }
        catch (Exception ex) {
            log.error(String.format("NetChangeTransferReserve_Operate_Error:%s", ex.getMessage()), (Throwable)ex);
            throw ex;
        }
        return operationResult;
    }

    private String getSelectFields(String entityNumber, boolean includeEntry, boolean isRequire) {
        Map<String, String> requireColMap = this.findBillFieldMappings(entityNumber, RESERVE_REQUIRE_MODULE);
        Map<String, String> supplyColMap = this.findBillFieldMappings(entityNumber, RESERVE_SUPPLY_MODULE);
        String reqQtyField = requireColMap.get("bill_entry.base_qty");
        String supplyQtyField = supplyColMap.get("baseqty");
        String rBillnoField = requireColMap.get("bill_no");
        String sBillnoField = supplyColMap.get("billnum");
        String entryIdField = null;
        if (includeEntry) {
            entryIdField = isRequire ? requireColMap.get("bill_entry") : supplyColMap.get("billentry");
        }
        StringBuilder selectFields = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)reqQtyField)) {
            selectFields.append('(').append(reqQtyField).append(") as rqty");
        }
        if (StringUtils.isNotBlank((CharSequence)supplyQtyField) && !selectFields.toString().contains(supplyQtyField)) {
            if (selectFields.length() > 0) {
                selectFields.append(", ");
            }
            selectFields.append('(').append(supplyQtyField).append(") as sqty");
        }
        if (StringUtils.isNotBlank((CharSequence)rBillnoField) && !selectFields.toString().contains(rBillnoField)) {
            if (selectFields.length() > 0) {
                selectFields.append(", ");
            }
            selectFields.append('(').append(rBillnoField).append(") as rbillno");
        }
        if (StringUtils.isNotBlank((CharSequence)sBillnoField) && !selectFields.toString().contains(sBillnoField)) {
            if (selectFields.length() > 0) {
                selectFields.append(", ");
            }
            selectFields.append('(').append(sBillnoField).append(") as sbillno");
        }
        if (StringUtils.isNotBlank((CharSequence)entryIdField)) {
            if (selectFields.length() > 0) {
                selectFields.append(", ");
            }
            selectFields.append(entryIdField).append(".id as entryid");
        }
        return selectFields.toString();
    }

    private String getSelectFields(String entityNumber) {
        return this.getSelectFields(entityNumber, false, true);
    }

    private List<Map<String, Object>> getQueryData(String entityNumber, String selectFields, QFilter qFilter) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(2);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"NetChangeTransferOpAction", (String)entityNumber, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, null);){
            RowMeta rowMeta = dataSet.getRowMeta();
            for (Row row : dataSet) {
                list.add(rowMeta.toMap(row));
            }
        }
        return list;
    }

    private void initTransFerRecordPram(String entityNumber, String selectFields, QFilter qFilter, List<TransFerRecordPram> reqs, List<TransFerRecordPram> sups) {
        BigDecimal rQty = null;
        BigDecimal sQty = null;
        String rbillno = "";
        String sbillno = "";
        int seq = 0;
        Long entryId = 0L;
        Long bomentryid = 0L;
        for (Map<String, Object> map : this.getQueryData(entityNumber, selectFields, qFilter)) {
            if (map.containsKey("rqty")) {
                sQty = rQty = (BigDecimal)map.get("rqty");
            }
            if (map.containsKey("sqty")) {
                sQty = (BigDecimal)map.get("sqty");
            }
            if (map.containsKey("rbillno")) {
                sbillno = rbillno = (String)map.get("rbillno");
            }
            if (map.containsKey("sbillno")) {
                sbillno = (String)map.get("sbillno");
            }
            if (map.containsKey("seq")) {
                seq = (Integer)map.get("seq");
            }
            if (map.containsKey("entryid")) {
                entryId = (Long)map.get("entryid");
            }
            if (map.containsKey("bomentryid")) {
                bomentryid = (Long)map.get("bomentryid");
            }
            TransFerRecordPram reqPram = new TransFerRecordPram();
            TransFerRecordPram supPram = new TransFerRecordPram();
            reqPram.setSeq(seq);
            reqPram.setQty(rQty);
            reqPram.setBillno(rbillno);
            reqPram.setEntryId(entryId);
            reqPram.setBomentryid(bomentryid);
            supPram.setSeq(seq);
            supPram.setQty(sQty);
            supPram.setBillno(sbillno);
            supPram.setEntryId(entryId);
            supPram.setBomentryid(bomentryid);
            reqs.add(reqPram);
            sups.add(supPram);
        }
    }

    private void initTransFerRecordData(TransFerRecordPram pram, String transfertype, List<DynamicObject> saves, List<DynamicObject> updates) {
        if (this.isNeedTransferRecord(pram)) {
            if (pram.qty == null) {
                DynamicObject type = BusinessDataServiceHelper.loadSingleFromCache((Object)pram.targetTable.getEntityNumber(), (String)"bos_entityobject");
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684%1$s-\u9884\u7559%2$s\u6a21\u578b\u7684\u9884\u7559\u6620\u5c04\u914d\u7f6e\u3002", (String)"NetChangeOpServiceImpl_1", (String)"mmc-mrp-mservice", (Object[])new Object[0]), type.getString("name"), "0".equals(transfertype) ? ResManager.loadKDString((String)"\u9700\u6c42", (String)"NetChangeOpServiceImpl_2", (String)"mmc-mrp-mservice", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4f9b\u5e94", (String)"NetChangeOpServiceImpl_3", (String)"mmc-mrp-mservice", (Object[])new Object[0])));
            }
            if (pram.qty.compareTo(BigDecimal.ZERO) > 0) {
                QFilter qFilterObj = new QFilter(pram.fields[0], "=", (Object)pram.sourceTable.getEntityNumber());
                QFilter qFilterBillId = new QFilter(pram.fields[1], "=", (Object)pram.sourceRow.getBillId());
                QFilter qFilterBillEntryId = new QFilter(pram.fields[2], "=", (Object)pram.sourceRow.getEntryId());
                QFilter qFilterEntryIsNull = new QFilter(pram.fields[2], "=", (Object)0L);
                if (pram.sourceRow.getEntryId().equals(pram.sourceRow.getBillId())) {
                    qFilterBillEntryId.or(qFilterEntryIsNull);
                }
                List<Long> pks = this.getNetChangeRecordIdS(new QFilter[]{pram.qtyFilter, qFilterObj, qFilterBillId, qFilterBillEntryId});
                DynamicObject[] records = BusinessDataServiceHelper.load((Object[])pks.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)MSPLAN_NET_CHANGE_RECORD));
                long[] ids = DB.genGlobalLongIds((int)records.length);
                int k = 0;
                for (DynamicObject record : records) {
                    if (pram.qty.compareTo(BigDecimal.ZERO) <= 0) continue;
                    BigDecimal changeQty = record.getBigDecimal("base_qty").compareTo(pram.qty) < 0 ? record.getBigDecimal("base_qty") : pram.qty;
                    DynamicObject clone = (DynamicObject)OrmUtils.clone((Object)record, (IDataEntityType)record.getDataEntityType(), (boolean)true, (boolean)true);
                    clone.set("id", (Object)ids[k++]);
                    clone.set("parent_id", record.get("id"));
                    clone.set("change_type", (Object)"2");
                    clone.set("transfertype", (Object)transfertype);
                    clone.set("qty", (Object)changeQty);
                    clone.set("base_qty", (Object)changeQty);
                    clone.set("ori_qty", (Object)changeQty);
                    clone.set("create_date", (Object)new Date());
                    clone.set("creater_id", (Object)RequestContext.get().getCurrUserId());
                    clone.set("creater", (Object)BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getCurrUserId(), (String)"bos_user", (String)"id"));
                    DynamicObjectType type = clone.getDynamicObject(pram.fields[0]).getDynamicObjectType();
                    clone.set(pram.fields[0], (Object)BusinessDataServiceHelper.loadSingle((Object)pram.targetTable.getEntityNumber(), (DynamicObjectType)type));
                    clone.set(String.format("%s_id", pram.fields[0]), (Object)pram.targetTable.getEntityNumber());
                    clone.set(pram.fields[1], (Object)pram.targetRow.getBillId());
                    clone.set(pram.fields[2], (Object)pram.targetRow.getEntryId());
                    clone.set(pram.fields[3], (Object)pram.billno);
                    clone.set(pram.fields[4], (Object)pram.seq);
                    record.set("qty", (Object)record.getBigDecimal("qty").subtract(changeQty));
                    record.set("base_qty", (Object)record.getBigDecimal("base_qty").subtract(changeQty));
                    saves.add(clone);
                    updates.add(record);
                    pram.qty = pram.qty.subtract(changeQty);
                }
            }
        } else {
            log.info(String.format("netChangeTransferReserveOp:%s to %s no need %s transfer : billNo:%s, seq:%s, qty:%s.", pram.sourceTable.getEntityNumber(), pram.targetTable.getEntityNumber(), "0".equals(transfertype) ? "require" : "supply", pram.billno, pram.seq, pram.qty));
        }
    }

    private boolean isNeedTransferRecord(TransFerRecordPram pram) {
        QFilter qFilterObj = new QFilter(pram.fields[0], "=", (Object)pram.sourceTable.getEntityNumber());
        QFilter qFilterBillId = new QFilter(pram.fields[1], "=", (Object)pram.sourceRow.getBillId());
        QFilter qFilterBillEntryId = new QFilter(pram.fields[2], "=", (Object)pram.sourceRow.getEntryId());
        QFilter qFilterEntryIsNull = new QFilter(pram.fields[2], "=", (Object)0L);
        if (pram.sourceRow.getEntryId().equals(pram.sourceRow.getBillId())) {
            qFilterBillEntryId.or(qFilterEntryIsNull);
        }
        if (this.getNetChangeRecordId(new QFilter[]{pram.qtyFilter, qFilterObj, qFilterBillId, qFilterBillEntryId}) > 0L) {
            qFilterObj.__setValue((Object)pram.targetTable.getEntityNumber());
            qFilterBillId.__setValue((Object)pram.targetRow.getBillId());
            qFilterBillEntryId = new QFilter(pram.fields[2], "=", (Object)pram.targetRow.getEntryId());
            if (pram.targetRow.getEntryId().equals(pram.targetRow.getBillId())) {
                qFilterBillEntryId.or(qFilterEntryIsNull);
            }
            return this.getNetChangeRecordId(new QFilter[]{pram.changeTypeFilter, qFilterObj, qFilterBillId, qFilterBillEntryId}) <= 0L;
        }
        return false;
    }

    private Long getNetChangeRecordId(QFilter[] qFilters) {
        List<Long> ids = this.getNetChangeRecordIdS(qFilters);
        return ids.isEmpty() ? Long.valueOf(0L) : ids.get(0);
    }

    private List<Long> getNetChangeRecordIdS(QFilter[] qFilters) {
        ArrayList<Long> ids = new ArrayList<Long>(2);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"isNeedTransferRecord", (String)MSPLAN_NET_CHANGE_RECORD, (String)"id", (QFilter[])qFilters, null);){
            while (dataSet.hasNext()) {
                ids.add(dataSet.next().getLong(0));
            }
        }
        return ids;
    }

    private Map<String, String> findBillFieldMappings(String formId, String targetFormId) {
        DynamicObject dbColsMap = null;
        if (StringUtils.isNotBlank((CharSequence)formId) && StringUtils.isNotBlank((CharSequence)targetFormId)) {
            QFilter filter = new QFilter("sourcebill", "=", (Object)formId);
            filter = filter.and(new QFilter("targetobj", "=", (Object)targetFormId));
            filter.and("isenable", "=", (Object)Boolean.TRUE);
            dbColsMap = BusinessDataServiceHelper.loadSingleFromCache((String)"sbs_billfieldmapping", (QFilter[])filter.toArray());
        }
        if (dbColsMap == null) {
            return new HashMap<String, String>();
        }
        String keyCol = "targetobjcol";
        String valCol = "sourcebillcol";
        HashMap<String, String> tempBalColMap = new HashMap<String, String>(16);
        MainEntityType billType = MetadataServiceHelper.getDataEntityType((String)formId);
        DynamicObjectCollection rows = dbColsMap.getDynamicObjectCollection("colsmap");
        for (DynamicObject row : rows) {
            String val = row.getString(valCol);
            if (StringUtils.isBlank((CharSequence)val) || "1".equals(row.getString("selectvalue"))) {
                String formula = row.getString("formula_tag");
                Map formulaMap = (Map)SerializationUtils.fromJsonString((String)formula, Map.class);
                val = (String)formulaMap.get("expression");
                if (StringUtils.isBlank((CharSequence)val)) {
                    tempBalColMap.put(row.getString(keyCol), val);
                    continue;
                }
                val = this.handleForMulaField(billType, val, null);
            }
            tempBalColMap.put(row.getString(keyCol), val);
        }
        return tempBalColMap;
    }

    private String handleForMulaField(MainEntityType billType, String val, String sym) {
        if (StringUtils.isBlank((CharSequence)sym)) {
            sym = "\\+";
        }
        String[] addSpl = val.split(sym);
        for (int i = 0; i < addSpl.length; ++i) {
            String key = addSpl[i].trim();
            String[] split = key.split("-");
            if (split.length > 1) {
                addSpl[i] = this.handleForMulaField(billType, key, "-");
                continue;
            }
            IDataEntityProperty prop = billType.findProperty(key);
            IDataEntityType parent = prop.getParent();
            if (!(parent instanceof EntryType)) continue;
            addSpl[i] = parent.getName() + '.' + key;
        }
        StringBuilder sb = new StringBuilder(addSpl[0]);
        for (int i = 1; i < addSpl.length; ++i) {
            sb.append(sym).append(addSpl[i]);
        }
        return sb.toString();
    }

    public OperationResult netChangeUnAutoReserveOp(String entityNumber, Collection<Long> billIds) {
        OperationResult operationResult = new OperationResult();
        operationResult.setSuccess(true);
        try {
            Set<Long> ids = this.getRecordIdsByRequireBills(entityNumber, billIds);
            NetChangeSynServiceImpl iNetChangeSynService = new NetChangeSynServiceImpl();
            iNetChangeSynService.syncReserveDatasByRequireIds(billIds);
            this.netChangeRecordRelease(ids);
        }
        catch (Exception ex) {
            log.error(String.format("NetChangeUnAutoReserve_Operate_Error:%s", ex.getMessage()), (Throwable)ex);
            throw ex;
        }
        return operationResult;
    }

    private Set<Long> getRecordIdsByRequireBills(String entityNumber, Collection<Long> billIds) {
        HashSet<Long> ids = new HashSet<Long>(16);
        QFilter requireFilter = new QFilter("bill_obj", "=", (Object)entityNumber);
        requireFilter.and(new QFilter("bill_id", "in", billIds));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"NetChangeDeleteOpAction", (String)MSPLAN_NET_CHANGE_RECORD, (String)"id", (QFilter[])new QFilter[]{requireFilter}, null);){
            for (Row row : dataSet) {
                Long id = row.getLong("id");
                ids.add(id);
            }
        }
        return ids;
    }

    private void netChangeRecordRelease(Set<Long> recordIds) {
        QFilter filter = new QFilter("id", "in", recordIds);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"NetChangeDeleteOpAction", (String)MSPLAN_NET_CHANGE_RECORD, (String)"id", (QFilter[])new QFilter[]{filter}, null);){
            for (Row row : dataSet) {
                recordIds.remove(row.getLong("id"));
            }
        }
        if (recordIds.isEmpty()) {
            return;
        }
        QFilter changeType = new QFilter("change_type", "in", (Object)new String[]{"2", "4"});
        filter = new QFilter("parent_id", "in", recordIds);
        HashSet<Long> deleteIds = new HashSet<Long>(4);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"NetChangeDeleteOpAction", (String)MSPLAN_NET_CHANGE_RECORD, (String)"id", (QFilter[])new QFilter[]{filter, changeType}, null);){
            for (Row row : dataSet) {
                deleteIds.add(row.getLong("id"));
            }
        }
        if (!deleteIds.isEmpty()) {
            DeleteServiceHelper.delete((String)MSPLAN_NET_CHANGE_RECORD, (QFilter[])new QFilter[]{new QFilter("id", "in", deleteIds)});
            this.netChangeRecordRelease(deleteIds);
        }
    }

    public OperationResult netChangeUnReleaseReserveOp(String entityNumber, Collection<Long> billIds, String op, OperateOption option) {
        OperationResult operationResult = new OperationResult();
        operationResult.setSuccess(true);
        try {
            NetChangeSynServiceImpl iNetChangeSynService = new NetChangeSynServiceImpl();
            iNetChangeSynService.syncReserveDatasBySupplyBill(entityNumber, billIds, false);
        }
        catch (Exception ex) {
            log.error(String.format("NetChangeUnReleaseReserve_Operate_Error:%s", ex.getMessage()), (Throwable)ex);
            throw ex;
        }
        return operationResult;
    }

    public OperationResult netChangeConfigAutoSynOp(Collection<Long> billIds) {
        OperationResult operationResult = new OperationResult();
        operationResult.setSuccess(true);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"msmod_reserve_service_cfg");
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])billIds.toArray(), (DynamicObjectType)mainEntityType);
        ArrayList<String> billTypeList = new ArrayList<String>(dynamicObjects.length);
        for (DynamicObject data : dynamicObjects) {
            if (data.get("billobject") == null) continue;
            billTypeList.add(data.getString("billobject.id"));
        }
        QFilter netChangeDeleteFilter = new QFilter("billobject", "in", billTypeList);
        QFilter statusFilter = new QFilter("status", "=", (Object)Character.valueOf('C'));
        QFilter resourceTypeFilter = new QFilter("resourcetype", "=", (Object)Character.valueOf('1'));
        QFilter groupFilter = new QFilter("group", "in", (Object)new Long[]{1402037881861730304L, 1402139266611416064L, 1402139420131331072L, 1402139574834039808L, 1402856110217534464L});
        NetChangeSynServiceImpl iNetChangeSynService = new NetChangeSynServiceImpl();
        iNetChangeSynService.syncCfgDatas(new QFilter[]{netChangeDeleteFilter, statusFilter, resourceTypeFilter}, null, new QFilter[]{netChangeDeleteFilter, groupFilter}, false);
        return operationResult;
    }

    public static boolean isTplExtendEntity(String entityNumber, String tplNumber) {
        String oqlTpl = String.format("select fid from T_META_ENTITYDESIGN where fnumber = '%s'", tplNumber);
        String tplId = "";
        try (DataSet dataSet = DB.queryDataSet((String)"isManufStockExtendEntity", (DBRoute)DBRoute.meta, (String)oqlTpl);){
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                tplId = row.getString("fid");
            }
        }
        return NetChangeOpServiceImpl.isTplExtendEntityByTplId(entityNumber, tplId);
    }

    public static boolean isTplExtendEntityByTplId(String entityNumber, String tplId) {
        String oql = String.format("select fparentid from T_META_ENTITYDESIGN where fnumber = '%s'", entityNumber);
        try (DataSet dataSet = DB.queryDataSet((String)"isManufStockExtendEntity", (DBRoute)DBRoute.meta, (String)oql);){
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                String fparentid = row.getString("fparentid");
                boolean bl = NetChangeOpServiceImpl.isTplExtendEntityById(fparentid, tplId);
                return bl;
            }
        }
        return false;
    }

    private static boolean isTplExtendEntityById(String id, String tplId) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return false;
        }
        if (tplId.equals(id)) {
            return true;
        }
        String oql = String.format("select fparentid from T_META_ENTITYDESIGN where fid = '%s'", id);
        try (DataSet dataSet = DB.queryDataSet((String)"isManufStockExtendEntityById", (DBRoute)DBRoute.meta, (String)oql);){
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                String fparentid = row.getString("fparentid");
                boolean bl = NetChangeOpServiceImpl.isTplExtendEntityById(fparentid, tplId);
                return bl;
            }
        }
        return false;
    }

    private static void synNetChangeRecordsByReserve(Collection<Long> billIds) {
        NetChangeSynServiceImpl netChangeSynService = new NetChangeSynServiceImpl();
        if (!billIds.isEmpty()) {
            netChangeSynService.syncReserveDatasByIds(billIds);
        }
    }

    private Set<String> getOps(Row row) {
        HashSet<String> opeSets = new HashSet<String>(16);
        if (row.get("billoperation") != null && !StringUtils.isBlank((CharSequence)row.getString("billoperation"))) {
            String[] billoperations;
            for (String billoperation : billoperations = row.getString("billoperation").split("[,]")) {
                if (StringUtils.isBlank((CharSequence)billoperation)) continue;
                opeSets.add(billoperation);
            }
        }
        return opeSets;
    }

    private static class TransFerRecordPram {
        private BFRowId sourceRow;
        private TableDefine sourceTable;
        private BFRowId targetRow;
        private TableDefine targetTable;
        private QFilter changeTypeFilter;
        private QFilter qtyFilter;
        private BigDecimal qty;
        private String billno;
        private int seq;
        private String[] fields;
        private Long entryId;
        private Long bomentryid;

        public void setSourceRow(BFRowId sourceRow) {
            this.sourceRow = sourceRow;
        }

        public void setSourceTable(TableDefine sourceTable) {
            this.sourceTable = sourceTable;
        }

        public void setTargetRow(BFRowId targetRow) {
            this.targetRow = targetRow;
        }

        public void setTargetTable(TableDefine targetTable) {
            this.targetTable = targetTable;
        }

        public void setChangeTypeFilter(QFilter changeTypeFilter) {
            this.changeTypeFilter = changeTypeFilter;
        }

        public void setQtyFilter(QFilter qtyFilter) {
            this.qtyFilter = qtyFilter;
        }

        public void setQty(BigDecimal qty) {
            this.qty = qty;
        }

        public void setBillno(String billno) {
            this.billno = billno;
        }

        public void setSeq(int seq) {
            this.seq = seq;
        }

        public void setFields(String[] fields) {
            this.fields = fields;
        }

        public void setEntryId(Long entryId) {
            this.entryId = entryId;
        }

        public void setBomentryid(Long bomentryid) {
            this.bomentryid = bomentryid;
        }
    }

    private static class MftStockPram {
        private final BFRowId stockRow;
        private final TableDefine stockTable;
        private final String selectFields;

        public MftStockPram(BFRowId stockRow, TableDefine stockTable, String selectFields) {
            this.stockRow = stockRow;
            this.stockTable = stockTable;
            this.selectFields = selectFields;
        }
    }
}

