/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.mservice.planorder.businessevent;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.business.helper.MessageServiceHelper;
import kd.mmc.mrp.mservice.planorder.PlanOrderServiceImpl;

public class PlanOrderAutoDropPlugin
implements IEventServicePlugin {
    public Object handleEvent(KDBizEvent evt) {
        if (evt instanceof EntityEvent) {
            DynamicObject[] datas;
            EntityEvent entityEvent = (EntityEvent)evt;
            List bussinessKeys = entityEvent.getBusinesskeys();
            if (bussinessKeys.isEmpty()) {
                return evt.getEventId();
            }
            ArrayList<Long> ids = new ArrayList<Long>(bussinessKeys.size());
            for (DynamicObject[] bussinessKey : bussinessKeys) {
                ids.add(Long.parseLong((String)bussinessKey));
            }
            for (DynamicObject data : datas = BusinessDataServiceHelper.load((String)entityEvent.getEntityNumber(), (String)"id,isautodrop", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)})) {
                Long id = data.getLong("id");
                if (data.getBoolean("isautodrop")) continue;
                ids.remove(id);
            }
            if (ids.isEmpty()) {
                return evt.getEventId();
            }
            PlanOrderServiceImpl planOrderService = new PlanOrderServiceImpl();
            int averageNum = ids.size() % 1000 == 0 ? ids.size() / 1000 : ids.size() / 1000 + 1;
            List averagelist = this.averageAssign(ids, averageNum);
            ArrayList failedPlanIdList = new ArrayList();
            for (List list : averagelist) {
                Map<String, Object> result = planOrderService.dropPlanOrder(list);
                Map errorMap = (Map)result.get("error");
                if (errorMap == null || errorMap.isEmpty()) continue;
                failedPlanIdList.addAll(errorMap.keySet());
            }
            if (failedPlanIdList.isEmpty()) {
                return evt.getEventId();
            }
            QFilter[] planProgramFilters = new QFilter[]{new QFilter("senddropfailmsg", "=", (Object)Character.valueOf('1'))};
            DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"mrp_planprogram", (String)"id", (QFilter[])planProgramFilters);
            List planProgramIdList = dynamicObjectCollection.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", failedPlanIdList), new QFilter("planprogram", "in", planProgramIdList)};
            String selectFields = "planoperatenum, proorpurorg, planpersonid";
            DynamicObject[] planOrders = BusinessDataServiceHelper.load((String)"mrp_planorder", (String)selectFields, (QFilter[])filters);
            HashMap<String, Map> numOrgNotifiers = new HashMap<String, Map>(100);
            HashMap<String, Set> numOrgs = new HashMap<String, Set>(16);
            HashMap<Long, DynamicObject> orgs = new HashMap<Long, DynamicObject>(16);
            for (DynamicObject planOrder : planOrders) {
                String planOperateNum = planOrder.getString("planoperatenum");
                DynamicObject supplyOrg = planOrder.getDynamicObject("proorpurorg");
                DynamicObject planPerson = planOrder.getDynamicObject("planpersonid");
                if (StringUtils.isBlank((CharSequence)planOperateNum) || planPerson == null || supplyOrg == null) continue;
                long supplyOrgId = supplyOrg.getLong("id");
                long planPersonId = planPerson.getLong("id");
                Map orgNotifiers = numOrgNotifiers.computeIfAbsent(planOperateNum, v -> new HashMap(16));
                Set notifiers = orgNotifiers.computeIfAbsent(supplyOrgId, v -> new HashSet(16));
                notifiers.add(planPersonId);
                Set orgIds = numOrgs.computeIfAbsent(planOperateNum, v -> new HashSet(16));
                orgIds.add(supplyOrgId);
                orgs.put(supplyOrgId, supplyOrg);
            }
            for (Map.Entry entry : numOrgNotifiers.entrySet()) {
                String num = (String)entry.getKey();
                Map orgNotifiers = (Map)entry.getValue();
                Set orgIds = (Set)numOrgs.get(num);
                MessageServiceHelper.sendMessage((String)num, (Set)orgIds, (Map)orgNotifiers, orgs, (String)"B");
            }
        }
        return evt.getEventId();
    }

    public <T> List<List<T>> averageAssign(List<T> source, int n) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        int remainder = source.size() % n;
        int number = source.size() / n;
        int offset = 0;
        for (int i = 0; i < n; ++i) {
            List<T> value = null;
            if (remainder > 0) {
                value = source.subList(i * number + offset, (i + 1) * number + offset + 1);
                --remainder;
                ++offset;
            } else {
                value = source.subList(i * number + offset, (i + 1) * number + offset);
            }
            if (value == null || value.size() <= 0) continue;
            result.add(value);
        }
        return result;
    }
}

