/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.dataset.schema.RegisterSchema;
import kd.bos.algo.sql.Parser;
import kd.bos.algo.sql.schema.Schema;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.UnresolvedAttribute;
import kd.bos.algo.sql.tree.UnresolvedFuncall;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.utils.MRPUtil;
import kd.mmc.mrp.utils.SqlExprParser;
import kd.mpscmm.msplan.mservice.service.datafetch.model.FetchDataQueryModule;
import kd.mpscmm.msplan.mservice.service.datafetch.util.DataSourceFetchDataUtil;
import org.apache.commons.lang.StringEscapeUtils;

public class DataSourceUtil {
    public static DataSet getDataSetByModel(FetchDataQueryModule queryMD, DataSet ds) {
        return DataSourceFetchDataUtil.getDataSetByModel((FetchDataQueryModule)queryMD, (DataSet)ds);
    }

    public static DataSet getDataSetByModel(Long modelId, Set<Long> masterIdSet) {
        return DataSourceFetchDataUtil.getDataSetByModel((Long)modelId, masterIdSet);
    }

    public static FetchDataQueryModule getQueryModuleByModel(Long modelId, Set<Long> masterIdSet) {
        return DataSourceFetchDataUtil.getQueryModuleByModel((Long)modelId, masterIdSet);
    }

    public static FetchDataQueryModule getQueryModuleByModelFilter(Long modelId, QFilter filter) {
        return DataSourceFetchDataUtil.getQueryModuleByModel((Long)modelId, null, (QFilter)filter);
    }

    public static List<String> checkExpr(String exprStr, String entityName) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        Parser sqlParser = DataSourceUtil.getParser();
        Expr expr = sqlParser.parseExpr(exprStr);
        return DataSourceUtil.resolver(expr, (DynamicObjectType)dataEntityType);
    }

    private static List<String> resolver(Expr expr, DynamicObjectType type) {
        List children;
        ArrayList<String> result = new ArrayList<String>();
        if (expr instanceof UnresolvedAttribute) {
            List nameParts = ((UnresolvedAttribute)expr).getNameParts();
            Iterator iterator = nameParts.iterator();
            StringBuilder sb = new StringBuilder(16);
            DynamicObjectType currentType = type;
            boolean first = true;
            while (iterator.hasNext()) {
                DynamicProperty property;
                String next = (String)iterator.next();
                sb.append(next);
                if (first) {
                    first = false;
                    if (type.getName().equalsIgnoreCase(next)) continue;
                }
                if ((property = currentType.getProperty(next)) == null) {
                    result.add(sb.toString());
                    break;
                }
                if (!iterator.hasNext()) continue;
                if (property instanceof DynamicCollectionProperty) {
                    DynamicCollectionProperty entryProp = (DynamicCollectionProperty)property;
                    currentType = (DynamicObjectType)entryProp.getItemType();
                    sb.append('.');
                    continue;
                }
                if (property instanceof DynamicComplexProperty) {
                    DynamicComplexProperty complexProp = (DynamicComplexProperty)property;
                    currentType = (DynamicObjectType)complexProp.getComplexType();
                    sb.append('.');
                    continue;
                }
                String next1 = (String)iterator.next();
                sb.append('.').append(next1);
                result.add(sb.toString());
                break;
            }
        }
        if ((children = expr.getChildren()) != null) {
            for (Expr child : children) {
                result.addAll(DataSourceUtil.resolver(child, type));
            }
        }
        return result;
    }

    public static List<String> checkFunCall(String exprStr) {
        Parser sqlParser = DataSourceUtil.getParser();
        Expr expr = sqlParser.parseExpr(exprStr);
        return DataSourceUtil.resolver(expr);
    }

    private static Parser getParser() {
        return new SqlExprParser();
    }

    private static List<String> resolver(Expr expr) {
        ArrayList<String> result = new ArrayList<String>();
        List children = expr.getChildren();
        if (expr instanceof UnresolvedFuncall) {
            try {
                UnresolvedFuncall funcall = (UnresolvedFuncall)expr;
                funcall.resolve((Schema)new RegisterSchema());
            }
            catch (Exception e) {
                String msg = e.getMessage();
                msg = msg == null ? "" : msg;
                result.add(msg);
            }
        }
        if (children != null) {
            for (Expr child : children) {
                result.addAll(DataSourceUtil.resolver(child));
            }
        }
        return result;
    }

    public static String getSrcMaterialField(DynamicObject mrpDs, String materialField) {
        DynamicObject transferDyn = mrpDs.getDynamicObject("billfieldtransfer");
        transferDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)transferDyn.getLong("id"), (String)"mrp_billfieldtransfer");
        DynamicObjectCollection fieldMappingAll = transferDyn.getDynamicObjectCollection("entryentity");
        DynamicObject srcBillEntity = transferDyn.getDynamicObject("srcbill");
        MainEntityType srcType = MetadataServiceHelper.getDataEntityType((String)srcBillEntity.getString("id"));
        String srcTypeName = srcType.getName();
        Map allFields = DataSourceFetchDataUtil.getAllEntityProp((MainEntityType)srcType);
        String src = "";
        for (DynamicObject mapping : fieldMappingAll) {
            String destField = mapping.getString("destfieldflag");
            String srcField = mapping.getString("sourcefieldflag");
            String formula = mapping.getString("calculateexc_tag");
            if (!materialField.equalsIgnoreCase(destField)) continue;
            if (StringUtils.isNotBlank((CharSequence)srcField)) {
                src = srcField;
            } else {
                boolean isUnSet = StringUtils.isEmpty((CharSequence)formula);
                JSONObject jo = isUnSet ? null : JSON.parseObject((String)formula);
                String string = src = jo == null ? null : jo.getString("expression");
                if (src == null || StringUtils.isEmpty((CharSequence)src)) {
                    throw new KDBizException(new ErrorCode("EMPTY_FIELD_CONTENT", String.format(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u201c%1$s, id: %2$s\u201d\u7684\u53d6\u6570\u8bbe\u7f6e\u201c%3$s, id: %4$s\u201d\u5b57\u6bb5\u201c%5$s\u201d\u672a\u8bbe\u7f6e\u3002", (String)"DataSourceUtil_0", (String)"mmc-mrp-mservice", (Object[])new Object[0]), mrpDs.getString("name"), mrpDs.getString("id"), transferDyn.getString("name"), transferDyn.getString("id"), destField)), new Object[0]);
                }
                src = src.replace(srcTypeName + ".", "");
            }
            src = DataSourceFetchDataUtil.transMaterial(null, null, (Map)allFields, (String)src);
            break;
        }
        return src;
    }

    public static boolean isDependRequire(DynamicObject mrpDs) {
        DynamicObject billfieldtransfer = mrpDs.getDynamicObject("billfieldtransfer");
        billfieldtransfer = BusinessDataServiceHelper.loadSingle((Object)billfieldtransfer.getPkValue(), (String)"mrp_billfieldtransfer");
        DynamicObjectCollection entryentity = billfieldtransfer.getDynamicObjectCollection("entryentity");
        boolean isContainPro = false;
        boolean isContainSource = false;
        boolean isContainDepend = false;
        for (DynamicObject entry : entryentity) {
            if (DefaultField.RequireField.ISDEPENDENT.getName().equalsIgnoreCase(entry.getString("destfieldflag"))) {
                String condition = entry.getString("calculateexc");
                if (!kd.bos.util.StringUtils.isNotEmpty((String)condition)) continue;
                if ((condition = StringEscapeUtils.unescapeJava((String)condition)).startsWith("\"") || condition.startsWith("'")) {
                    condition = condition.substring(1);
                }
                if (condition.endsWith("\"") || condition.endsWith("'")) {
                    condition = condition.substring(0, condition.length() - 1);
                }
                isContainDepend = MRPUtil.convert((Object)condition, Boolean.FALSE);
                continue;
            }
            if (DefaultField.RequireField.PRODUCT.getName().equalsIgnoreCase(entry.getString("destfieldflag"))) {
                isContainPro = true;
                continue;
            }
            if (!DefaultField.RequireField.SUPPLYBILLID.getName().equalsIgnoreCase(entry.getString("destfieldflag"))) continue;
            isContainSource = true;
        }
        return isContainPro && isContainSource && isContainDepend;
    }
}

