/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.utils.MRPUtil;

public class ReserveUtil {
    public static final String NetChangeRecordEntity = "msplan_net_change_record";
    public static final String MSMOD_RESERVE_RECORD = "msmod_reserve_record";
    private static final String algoKey = "ReserveUtil";
    public static final String REDIS_RESERVE_RECORD = "reserve_record";
    public static final String REDIS_RESERVE_PO_REMOVE = "reserve_record_po_removee";
    public static final String MrpNetChangeDetailEntity = "mrp_net_change_detail";
    private static final String selectFields = "id,bill_obj,bill_no,bill_id,billentry_id,billentry_seq,bal_obj,bal_id,s_billnum,bal_entryid,s_entryseq,s_materiel,base_qty,isweak";
    private static volatile Map<String, Integer> reserveColIndex = null;

    public static void reserveRemoveByBillId(Collection<Long> bills, String runLog) {
        HashSet<Long> recordIds = new HashSet<Long>(bills.size());
        QFilter fs = new QFilter("bill_id", "in", bills);
        fs.or(new QFilter("bal_id", "in", bills));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)NetChangeRecordEntity, (String)"id", (QFilter[])new QFilter[]{fs}, null);){
            for (Row row : dataSet) {
                recordIds.add(row.getLong("id"));
            }
        }
        ReserveUtil.reserveRemove(recordIds, runLog);
    }

    public static void reserveRemove(Collection<Long> recordIds, String runLog) {
        if (recordIds.isEmpty()) {
            return;
        }
        QFilter filter = new QFilter("id", "in", recordIds);
        try (TXHandle tx = TX.requiresNew((String)"netChangeRemove");){
            try {
                ReserveUtil.releaseReserveRecord(recordIds, runLog);
                ReserveUtil.removeReserveRecordByRecordId(new ArrayList<Object>(recordIds));
                DeleteServiceHelper.delete((String)NetChangeRecordEntity, (QFilter[])filter.toArray());
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    public static void removeReserveRecordByRecordId(List<Object> ids) {
        DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"ReserveService", (String)"removeReserveRecordByRecordId", (Object[])new Object[]{ids});
    }

    public static void releaseReserveRecord(Collection<Long> recordIds, String runLog) {
        QFilter filter = new QFilter("id", "in", recordIds);
        String select = "id as record_id,s_materiel,bill_obj,r_sale_org,bill_no,bill_id,r_biz_date,r_biz_date as s_biz_date,billentry_id,billentry_seq,ori_qty,base_qty,base_qty as req_qty,s_baseunit,s_org,bal_obj,bal_id,s_billnum,bal_entryid,s_entryseq,isweak";
        ArrayList<DynamicObject> mrpSaves = new ArrayList<DynamicObject>(recordIds.size());
        Date date = new Date();
        MainEntityType mrpEntityType = MetadataServiceHelper.getDataEntityType((String)MrpNetChangeDetailEntity);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"reserveRemove", (String)NetChangeRecordEntity, (String)select, (QFilter[])new QFilter[]{filter}, null);){
            RowMeta rowMeta = dataSet.getRowMeta();
            Field[] fields = rowMeta.getFields();
            for (Row row : dataSet) {
                DynamicObject reserveDetail = (DynamicObject)mrpEntityType.createInstance();
                for (int i = 0; i < fields.length; ++i) {
                    Object value = row.get(i);
                    String property = fields[i].getAlias();
                    ReserveUtil.setDynamicObjValue(reserveDetail, (EntityType)mrpEntityType, property, value);
                }
                reserveDetail.set("runlog", (Object)runLog);
                reserveDetail.set("type", (Object)"0");
                reserveDetail.set("createtime", (Object)date);
                mrpSaves.add(reserveDetail);
            }
        }
        if (!mrpSaves.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])mrpSaves.toArray(new DynamicObject[0]));
        }
    }

    public static void createReserveRecord(Collection<DynamicObject> records) {
        DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"ReserveService", (String)"createReserveRecord", (Object[])new Object[]{records});
    }

    public static int createReserveRecord(IMRPEnvProvider ctx, List<Map<String, Object>> params, Set<String> removePlanOrders) {
        LinkedHashMap<String, List> req2replace;
        int size = params.size();
        if (params.isEmpty()) {
            return 0;
        }
        Date date = new Date();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)NetChangeRecordEntity);
        MainEntityType mrpEntityType = MetadataServiceHelper.getDataEntityType((String)MrpNetChangeDetailEntity);
        ArrayList<DynamicObject> records = new ArrayList<DynamicObject>(size);
        ArrayList<DynamicObject> reserveDetails = new ArrayList<DynamicObject>(size);
        long[] longIds = ID.genLongIds((int)size);
        LinkedHashMap<String, LinkedHashMap> ocpWeak = new LinkedHashMap<String, LinkedHashMap>();
        LinkedHashMap reserveReplaceDataMap = new LinkedHashMap();
        for (int i = 0; i < size; ++i) {
            Map<String, Object> param = params.get(i);
            String string = String.format("%s-%s", param.get("bill_obj"), param.get("bill_id"));
            if (removePlanOrders.contains(string)) {
                ReserveUtil.changeReserveRecordRBill(param);
            }
            long id = longIds[i];
            DynamicObject bill = (DynamicObject)entityType.createInstance();
            DynamicObject reserveDetail = (DynamicObject)mrpEntityType.createInstance();
            for (Map.Entry entry : param.entrySet()) {
                ReserveUtil.setDynamicObjValue(bill, (EntityType)entityType, (String)entry.getKey(), entry.getValue());
                ReserveUtil.setDynamicObjValue(reserveDetail, (EntityType)mrpEntityType, (String)entry.getKey(), entry.getValue());
            }
            bill.set("id", (Object)id);
            records.add(bill);
            Object weakQty = param.get("ocp_weak_qty");
            if (weakQty != null) {
                String supBillKey = String.format("%s-%s", param.get("bal_id"), param.get("bal_entryid"));
                String reqBillKey = String.format("%s-%s", param.get("bill_id"), param.get("billentry_id"));
                LinkedHashMap req2weak = ocpWeak.computeIfAbsent(supBillKey, k -> new LinkedHashMap());
                BigDecimal qty = req2weak.getOrDefault(reqBillKey, BigDecimal.ZERO);
                qty = qty.add(MRPUtil.toBigDecimal(weakQty));
                req2weak.put(reqBillKey, qty);
                ReserveReplaceData reserveReplaceData = new ReserveReplaceData(bill, reserveDetail, MRPUtil.toBigDecimal(weakQty));
                req2replace = reserveReplaceDataMap.computeIfAbsent(supBillKey, k -> new LinkedHashMap());
                List replaceDataList = req2replace.computeIfAbsent(reqBillKey, k -> new ArrayList(2));
                replaceDataList.add(reserveReplaceData);
            }
            reserveDetail.set("record_id", (Object)id);
            reserveDetail.set("req_qty", reserveDetail.get("base_qty"));
            reserveDetail.set("type", (Object)"1");
            reserveDetail.set("createtime", (Object)date);
            reserveDetail.set("runlog", (Object)ctx.getRunLogNumber());
            reserveDetails.add(reserveDetail);
        }
        HashMap<Long, BigDecimal> updateRecordIds = new HashMap<Long, BigDecimal>(2);
        if (!ocpWeak.isEmpty()) {
            for (Map.Entry entry : ocpWeak.entrySet()) {
                String supKey = (String)entry.getKey();
                LinkedHashMap req2weak = (LinkedHashMap)entry.getValue();
                String[] strs = supKey.split("-");
                Long bal_id = Long.parseLong(strs[0]);
                Long bal_entryid = Long.parseLong(strs[1]);
                QFilter qFilter = new QFilter("bal_id", "=", (Object)bal_id);
                qFilter.and(new QFilter("bal_entryid", "=", (Object)bal_entryid));
                qFilter.and(new QFilter("isweak", "=", (Object)true));
                qFilter.and(new QFilter("base_qty", ">", (Object)0));
                DynamicObjectCollection datas = QueryServiceHelper.query((String)NetChangeRecordEntity, (String)(selectFields + ",priority"), (QFilter[])new QFilter[]{qFilter}, (String)"priority");
                if (datas.size() <= 0) continue;
                ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(datas.size());
                LinkedHashMap<String, List> map = new LinkedHashMap<String, List>(datas.size());
                for (DynamicObject data : datas) {
                    String reqKey = String.format("%s-%s", data.get("bill_id"), data.get("billentry_id"));
                    List l = map.computeIfAbsent(reqKey, k -> new ArrayList(2));
                    l.add(data);
                    BigDecimal base_qty = data.getBigDecimal("base_qty");
                    data.set("base_qty", (Object)base_qty);
                }
                for (Map.Entry entry2 : map.entrySet()) {
                    BigDecimal useWeakQty;
                    String cacheKey = MRPRuntimeConsts.getMetaDynamicInfoKey(ctx.getMRPContextId(), String.format("%s\u0001%s", entry2.getKey(), supKey));
                    String cache = MRPCacheManager.getInst().getSubData(ctx, REDIS_RESERVE_RECORD, cacheKey);
                    BigDecimal bigDecimal = useWeakQty = cache == null ? BigDecimal.ZERO : new BigDecimal(cache);
                    if (useWeakQty.compareTo(BigDecimal.ZERO) <= 0) {
                        list.addAll((Collection)entry2.getValue());
                        continue;
                    }
                    for (DynamicObject data : (List)entry2.getValue()) {
                        BigDecimal qty = data.getBigDecimal("base_qty");
                        if (useWeakQty.compareTo(BigDecimal.ZERO) <= 0) {
                            list.add(data);
                            continue;
                        }
                        if (useWeakQty.compareTo(qty) >= 0) {
                            useWeakQty = useWeakQty.subtract(qty);
                            continue;
                        }
                        qty = qty.subtract(useWeakQty);
                        data.set("base_qty", (Object)qty);
                        useWeakQty = BigDecimal.ZERO;
                        list.add(data);
                    }
                }
                req2replace = reserveReplaceDataMap.getOrDefault(supKey, new LinkedHashMap(0));
                for (Map.Entry entry3 : req2weak.entrySet()) {
                    String billKey = (String)entry3.getKey();
                    BigDecimal weakQty = (BigDecimal)entry3.getValue();
                    List replaceDataList = req2replace.getOrDefault(billKey, new ArrayList(0));
                    ListIterator replaceIts = replaceDataList.listIterator();
                    ReserveReplaceData next = null;
                    ListIterator its = list.listIterator();
                    while (its.hasNext()) {
                        BigDecimal qty;
                        DynamicObject data = (DynamicObject)its.next();
                        String reqKey = String.format("%s-%s", data.get("bill_id"), data.get("billentry_id"));
                        if (billKey.equalsIgnoreCase(reqKey)) continue;
                        if (weakQty.compareTo(BigDecimal.ZERO) <= 0) break;
                        Long id = data.getLong("id");
                        BigDecimal newQty = qty = data.getBigDecimal("base_qty");
                        while (newQty.compareTo(BigDecimal.ZERO) > 0) {
                            BigDecimal ocpQty;
                            if (next == null && replaceIts.hasNext()) {
                                next = (ReserveReplaceData)replaceIts.next();
                            } else if (next == null) break;
                            if (next.ocpWeakQty.compareTo(newQty) >= 0) {
                                next.ocpWeakQty = next.ocpWeakQty.subtract(newQty);
                                ocpQty = newQty;
                                newQty = BigDecimal.ZERO;
                            } else {
                                ocpQty = next.ocpWeakQty;
                                newQty = newQty.subtract(next.ocpWeakQty);
                                next.ocpWeakQty = BigDecimal.ZERO;
                            }
                            ocpQty = ocpQty.add(next.getParent2ocpQty().getOrDefault(id, BigDecimal.ZERO));
                            next.getParent2ocpQty().put(id, ocpQty);
                            if (next.ocpWeakQty.compareTo(BigDecimal.ZERO) > 0) continue;
                            next = null;
                        }
                        if (weakQty.compareTo(qty) >= 0) {
                            updateRecordIds.put(id, qty.add(updateRecordIds.getOrDefault(id, BigDecimal.ZERO)));
                            weakQty = weakQty.subtract(qty);
                            its.remove();
                            continue;
                        }
                        updateRecordIds.put(id, weakQty.add(updateRecordIds.getOrDefault(id, BigDecimal.ZERO)));
                        data.set("base_qty", (Object)qty.subtract(weakQty));
                        weakQty = BigDecimal.ZERO;
                        break;
                    }
                    ReserveUtil.handleReplaceReserveRecord(replaceDataList, records, reserveDetails, ctx.getRunLogNumber());
                }
            }
        }
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew((String)"createNetChangeRecord");){
            try {
                if (!updateRecordIds.isEmpty()) {
                    HashMap<Long, BigDecimal> updateReserveRecordIds = new HashMap<Long, BigDecimal>(updateRecordIds);
                    ReserveUtil.updateRecords(updateRecordIds, NetChangeRecordEntity);
                    ReserveUtil.updateRecords(updateReserveRecordIds, MSMOD_RESERVE_RECORD);
                }
                ReserveUtil.createReserveRecord(ReserveUtil.netChangeRecord2ReserveRecord(records));
                SaveServiceHelper.save((DynamicObject[])records.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])reserveDetails.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        return records.size();
    }

    private static void updateRecords(Map<Long, BigDecimal> updateRecordIds, String entity) {
        Long id;
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entity);
        QFilter qFilter = new QFilter("id", "in", updateRecordIds.keySet());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entity, (String)"id, base_qty", (QFilter[])new QFilter[]{qFilter}, null);){
            for (Row row : dataSet) {
                id = row.getLong("id");
                BigDecimal subQty = updateRecordIds.getOrDefault(id, BigDecimal.ZERO);
                BigDecimal qty = row.getBigDecimal("base_qty");
                qty = qty.subtract(subQty);
                updateRecordIds.put(id, qty);
            }
        }
        String updateSql = String.format("update %s set f_qty = ?,f_base_qty = ? where fid = ?", entityType.getAlias());
        ArrayList<Object[]> ps = new ArrayList<Object[]>(updateRecordIds.size());
        for (Map.Entry<Long, BigDecimal> entry : updateRecordIds.entrySet()) {
            id = entry.getKey();
            BigDecimal qty = entry.getValue();
            Object[] p = new Object[]{qty, qty, id};
            ps.add(p);
        }
        if (!ps.isEmpty()) {
            DB.executeBatch((DBRoute)new DBRoute(entityType.getDBRouteKey()), (String)updateSql, ps);
        }
    }

    public static Collection<DynamicObject> netChangeRecord2ReserveRecord(Collection<DynamicObject> netRecords) {
        return ReserveUtil.netChangeRecord2ReserveRecord(netRecords, false);
    }

    public static Collection<DynamicObject> netChangeRecord2ReserveRecord(Collection<DynamicObject> netRecords, boolean noCheck) {
        ArrayList<DynamicObject> records = new ArrayList<DynamicObject>(netRecords.size());
        if (!netRecords.isEmpty()) {
            MainEntityType reserveEntityType = MetadataServiceHelper.getDataEntityType((String)MSMOD_RESERVE_RECORD);
            for (DynamicObject net : netRecords) {
                DynamicObject bill = (DynamicObject)reserveEntityType.createInstance();
                for (IDataEntityProperty property : net.getDataEntityType().getProperties()) {
                    ReserveUtil.setDynamicObjValueNoF7(bill, (EntityType)reserveEntityType, property.getName(), net.get(property));
                }
                bill.set("bill_source", (Object)"1");
                bill.set("bal_source", (Object)"1");
                bill.set("reserveprctype", (Object)"0");
                bill.set("r_invorg", bill.get("r_sale_org"));
                if (!StringUtils.equalsIgnoreCase((CharSequence)"im_inv_realbalance", (CharSequence)bill.getString("bal_obj"))) {
                    bill.set("ispredict", (Object)true);
                }
                boolean is_gen_reserve = MRPUtil.convert(net.get("isgenreserve"), Boolean.FALSE);
                if (!noCheck && !is_gen_reserve) continue;
                records.add(bill);
            }
        }
        return records;
    }

    private static void handleReplaceReserveRecord(List<ReserveReplaceData> replaceDataList, List<DynamicObject> records, List<DynamicObject> reserveDetails, String runLog) {
        for (ReserveReplaceData replace : replaceDataList) {
            BigDecimal baseQty = replace.record.getBigDecimal("base_qty");
            for (Map.Entry<Long, BigDecimal> parentEntry : replace.getParent2ocpQty().entrySet()) {
                BigDecimal subQty = parentEntry.getValue();
                if ((baseQty = baseQty.subtract(subQty)).compareTo(BigDecimal.ZERO) > 0) {
                    DynamicObject newRecord = (DynamicObject)OrmUtils.clone((Object)replace.record, (IDataEntityType)replace.record.getDataEntityType(), (boolean)true, (boolean)true);
                    long newId = ReserveUtil.getGlobeLongId();
                    newRecord.set("id", (Object)newId);
                    newRecord.set("change_type", (Object)"3");
                    newRecord.set("qty", (Object)subQty);
                    newRecord.set("base_qty", (Object)subQty);
                    newRecord.set("ori_qty", (Object)subQty);
                    newRecord.set("parent_id", (Object)parentEntry.getKey());
                    records.add(newRecord);
                    DynamicObject newMRPRecord = (DynamicObject)OrmUtils.clone((Object)replace.mrpRecord, (IDataEntityType)replace.mrpRecord.getDataEntityType(), (boolean)true, (boolean)true);
                    newMRPRecord.set("record_id", (Object)newId);
                    newMRPRecord.set("base_qty", (Object)subQty);
                    newMRPRecord.set("req_qty", (Object)subQty);
                    newMRPRecord.set("runlog", (Object)runLog);
                    reserveDetails.add(newMRPRecord);
                    continue;
                }
                replace.record.set("change_type", (Object)"3");
                replace.record.set("qty", (Object)subQty);
                replace.record.set("base_qty", (Object)subQty);
                replace.record.set("ori_qty", (Object)subQty);
                replace.record.set("parent_id", (Object)parentEntry.getKey());
                replace.mrpRecord.set("base_qty", (Object)subQty);
                replace.mrpRecord.set("req_qty", (Object)subQty);
            }
            if (baseQty.compareTo(BigDecimal.ZERO) <= 0) continue;
            replace.record.set("base_qty", (Object)baseQty);
            replace.record.set("ori_qty", (Object)baseQty);
            replace.record.set("qty", (Object)baseQty);
            replace.mrpRecord.set("base_qty", (Object)baseQty);
            replace.mrpRecord.set("req_qty", (Object)baseQty);
        }
    }

    public static long getGlobeLongId() {
        return ID.genLongId();
    }

    private static void setDynamicObjValueNoF7(DynamicObject bill, EntityType entityType, String key, Object value) {
        IDataEntityProperty property = entityType.findProperty(key);
        if (property != null) {
            if (value instanceof DynamicObject) {
                bill.set(key, ((DynamicObject)value).getPkValue());
                return;
            }
            Object rev = MRPUtil.convert(value, property);
            bill.set(key, rev);
        }
    }

    public static void setDynamicObjValue(DynamicObject bill, EntityType entityType, String key, Object value) {
        IDataEntityProperty property = entityType.findProperty(key);
        if (property != null) {
            Object rev = MRPUtil.convert(value, property);
            if (property instanceof BasedataProp) {
                BasedataProp propType = (BasedataProp)property;
                String baseEntityId = propType.getBaseEntityId();
                if (StringUtils.isNotBlank((CharSequence)baseEntityId)) {
                    DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)baseEntityId);
                    obj.set("id", rev);
                    bill.set(key, (Object)obj);
                } else {
                    bill.set(key, rev);
                }
            } else {
                bill.set(key, rev);
            }
        }
    }

    public static void changeReserveRecordRBill(Map<String, Object> param) {
        param.put("bill_obj", param.get("ori_bill_obj"));
        param.put("bill_no", param.get("ori_bill_no"));
        param.put("bill_id", param.get("ori_bill_id"));
        param.put("billentry_id", param.get("ori_billentry_id"));
        param.put("billentry_seq", param.get("ori_billentry_seq"));
        param.put("isdepend", true);
    }

    public static Map<String, List<Object[]>> getReserveRecordByMaterials(IMRPEnvProvider ctx, Set<String> enabledMaterialIds) {
        Iterator<String> iter = enabledMaterialIds.iterator();
        HashSet<Long> materials = new HashSet<Long>(1);
        int count = 0;
        int batch = (Integer)ctx.getCfgValue(EnvCfgItem.MRP_MATERIAL_PLANINFO_BATCH);
        String reserve_record_entity = (String)ctx.getCfgValue(EnvCfgItem.RESERVE_RECORD_ENTITY);
        if (StringUtils.isBlank((CharSequence)reserve_record_entity)) {
            reserve_record_entity = NetChangeRecordEntity;
        }
        QFilter[] filters = new QFilter[2];
        filters[1] = new QFilter("base_qty", ">", (Object)BigDecimal.ZERO);
        HashMap<String, List<Object[]>> rowDataMap = new HashMap<String, List<Object[]>>(enabledMaterialIds.size());
        Map<String, Integer> reserveColIndex = ReserveUtil.getReserveColIndex();
        do {
            QFilter qFilterM;
            count = ReserveUtil.batchLoop(iter, materials, batch);
            filters[0] = qFilterM = new QFilter("s_materiel", "in", materials);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)reserve_record_entity, (String)selectFields, (QFilter[])filters, null);){
                for (Row row : dataSet) {
                    Long mid = row.getLong("s_materiel");
                    List list = rowDataMap.computeIfAbsent(mid.toString(), k -> new ArrayList());
                    Object[] values = new Object[reserveColIndex.size()];
                    for (Map.Entry<String, Integer> entry : reserveColIndex.entrySet()) {
                        values[entry.getValue().intValue()] = row.get(entry.getKey());
                    }
                    list.add(values);
                }
            }
        } while (count >= batch);
        return rowDataMap;
    }

    public static Map<String, Integer> getReserveColIndex() {
        if (reserveColIndex == null) {
            int size = 0;
            String[] strs = selectFields.split(",");
            HashMap<String, Integer> map = new HashMap<String, Integer>(strs.length);
            for (String field : strs) {
                map.put(field, size++);
            }
            reserveColIndex = Collections.unmodifiableMap(map);
        }
        return reserveColIndex;
    }

    public static int releaseReserveRecordByMaterials(IMRPEnvProvider ctx, Set<String> enabledMaterialIds, String releaseMode) {
        QFilter qFilterType = new QFilter("reservesource", "=", (Object)"MRP");
        if (StringUtils.equals((CharSequence)"2", (CharSequence)releaseMode)) {
            qFilterType.and(new QFilter("isweak", "=", (Object)true));
        } else if (!StringUtils.equals((CharSequence)"1", (CharSequence)releaseMode)) {
            return 0;
        }
        Iterator<String> iter = enabledMaterialIds.iterator();
        HashSet<Long> materials = new HashSet<Long>(1);
        int count = 0;
        int batch = (Integer)ctx.getCfgValue(EnvCfgItem.MRP_MATERIAL_PLANINFO_BATCH);
        QFilter[] filters = new QFilter[2];
        filters[1] = qFilterType;
        PlanModel planModel = (PlanModel)ctx.getService(PlanModel.class);
        qFilterType.and(new QFilter("r_sale_org", "in", MRPUtil.setStringParseLong(planModel.getRequirorgs())));
        HashSet<Long> recordIds = new HashSet<Long>(16);
        do {
            QFilter qFilterM;
            count = ReserveUtil.batchLoop(iter, materials, batch);
            filters[0] = qFilterM = new QFilter("s_materiel", "in", materials);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)NetChangeRecordEntity, (String)"id", (QFilter[])filters, null);){
                for (Row row : dataSet) {
                    recordIds.add(row.getLong("id"));
                }
            }
        } while (count >= batch);
        ReserveUtil.reserveRemove(recordIds, ctx.getRunLogNumber());
        return recordIds.size();
    }

    public static int releaseReserveRecordByMaterials(IMRPEnvProvider ctx, Set<String> enabledMaterialIds, String releaseMode, String reservesource) {
        QFilter qFilterType = new QFilter("reservesource", "=", (Object)reservesource);
        if (StringUtils.equals((CharSequence)"2", (CharSequence)releaseMode)) {
            qFilterType.and(new QFilter("isweak", "=", (Object)true));
        } else if (!StringUtils.equals((CharSequence)"1", (CharSequence)releaseMode)) {
            return 0;
        }
        Iterator<String> iter = enabledMaterialIds.iterator();
        HashSet<Long> materials = new HashSet<Long>(1);
        int count = 0;
        int batch = (Integer)ctx.getCfgValue(EnvCfgItem.MRP_MATERIAL_PLANINFO_BATCH);
        QFilter[] filters = new QFilter[2];
        filters[1] = qFilterType;
        PlanModel planModel = (PlanModel)ctx.getService(PlanModel.class);
        qFilterType.and(new QFilter("r_sale_org", "in", MRPUtil.setStringParseLong(planModel.getRequirorgs())));
        HashSet<Long> recordIds = new HashSet<Long>(16);
        do {
            QFilter qFilterM;
            count = ReserveUtil.batchLoop(iter, materials, batch);
            filters[0] = qFilterM = new QFilter("s_materiel", "in", materials);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)NetChangeRecordEntity, (String)"id", (QFilter[])filters, null);){
                for (Row row : dataSet) {
                    recordIds.add(row.getLong("id"));
                }
            }
        } while (count >= batch);
        ReserveUtil.reserveRemove(recordIds, ctx.getRunLogNumber());
        return recordIds.size();
    }

    private static int batchLoop(Iterator<String> iter, Set<Long> materials, int batch) {
        int count = 0;
        materials.clear();
        while (iter.hasNext()) {
            String id = iter.next();
            materials.add(Long.valueOf(id));
            if (++count != batch) continue;
            break;
        }
        return count;
    }

    public static void createCPSReserveDatas(PlanModel planModel, List<Map<String, Object>> reserveList, Map<String, String> reserveType, RequireRowData requireRow, RowData supplyRow, HashMap<String, Object> row, RequireRowData topRequireRow) {
        if (!planModel.isReserve()) {
            return;
        }
        if (!"A".equals(planModel.getPlanDataByParam("resultreserve", ""))) {
            return;
        }
        String resDataId = supplyRow.getString(DefaultField.CommonField.__MODEL_ID__.name());
        String reserve = reserveType.get(resDataId);
        if (reserve == null) {
            return;
        }
        if ("1".equals(MRPUtil.convert(requireRow.getValue(DefaultField.RequireField.__ISDEPENDENT__.getName()), ""))) {
            return;
        }
        if (MRPUtil.convert(requireRow.getValue(DefaultField.RequireField.__ISONWORK__.getName()), Boolean.FALSE).booleanValue()) {
            return;
        }
        if ("".equals(reserve) || "A".equals(reserve)) {
            return;
        }
        if ("B".equals(reserve)) {
            BigDecimal netDemand = MRPUtil.convert(topRequireRow.getValue(DefaultField.RequireField.__SUPPLY_QTY__.getName()), BigDecimal.ZERO);
            if (netDemand.compareTo(BigDecimal.ZERO) > 0) {
                return;
            }
        } else if (!"C".equals(reserve)) {
            return;
        }
        Long reqBillId = MRPUtil.convert(requireRow.getValue(DefaultField.RequireField.BILLID.getName()), 0L);
        Long reqBillEntryId = MRPUtil.convert(requireRow.getValue(DefaultField.RequireField.BILLENTRYID.getName()), 0L);
        if (reqBillEntryId == 0L) {
            reqBillEntryId = reqBillId;
        }
        String billEntity = requireRow.getString(DefaultField.RequireField.BILL_ENTITY.getName());
        String billNo = requireRow.getString(DefaultField.RequireField.BILLNUMBER.getName());
        Integer billEntrySeq = requireRow.getInteger(DefaultField.RequireField.BILLENTRYSEQ.getName());
        if (requireRow.getString(DefaultField.RequireField.ORIGIN_BILLENTITY.getName()) != null) {
            billEntity = requireRow.getString(DefaultField.RequireField.ORIGIN_BILLENTITY.getName());
            billNo = requireRow.getString(DefaultField.RequireField.ORIGIN_BILLNUMBER.getName());
            billEntrySeq = requireRow.getInteger(DefaultField.RequireField.ORIGIN_BILLENTRYSEQ.getName());
            reqBillId = MRPUtil.convert(requireRow.getValue(DefaultField.RequireField.ORIGIN_BILLID.getName()), 0L);
            reqBillEntryId = MRPUtil.convert(requireRow.getValue(DefaultField.RequireField.ORIGIN_BILLENTRYID.getName()), reqBillId);
        }
        HashMap<String, Object> resMap = new HashMap<String, Object>(16);
        resMap.put("bill_obj", billEntity);
        resMap.put("r_sale_org", requireRow.getLong(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
        resMap.put("r_biz_date", requireRow.getLong(DefaultField.RequireField.__ORIGIN_DEMAND_DATE__.getName()) == null ? requireRow.getLong(DefaultField.RequireField.DATE.getName()) : requireRow.getLong(DefaultField.RequireField.__ORIGIN_DEMAND_DATE__.getName()));
        resMap.put("bill_no", billNo);
        resMap.put("bill_id", reqBillId);
        resMap.put("billentry_id", reqBillEntryId);
        resMap.put("billentry_seq", billEntrySeq);
        resMap.put("s_org", supplyRow.getLong(DefaultField.SupplyField.SUPPLYORGUNIT.getName()));
        resMap.put("bal_obj", supplyRow.getString(DefaultField.SupplyField.BILL_ENTITY.getName()));
        Long supBillId = MRPUtil.convert(supplyRow.getValue(DefaultField.SupplyField.BILLID.getName()), 0L);
        Long supBillEntryId = MRPUtil.convert(supplyRow.getValue(DefaultField.SupplyField.BILLENTRYID.getName()), 0L);
        if (supBillEntryId == 0L) {
            supBillEntryId = supBillId;
        }
        resMap.put("bal_id", supBillId);
        resMap.put("s_billnum", supplyRow.getString(DefaultField.SupplyField.BILLNUMBER.getName()));
        resMap.put("s_entryseq", supplyRow.getInteger(DefaultField.SupplyField.BILLENTRYSEQ.getName()));
        resMap.put("s_biz_date", supplyRow.getLong(DefaultField.SupplyField.DATE.getName()));
        resMap.put("bal_entryid", supBillEntryId);
        resMap.put("s_materiel", supplyRow.getString(DefaultField.SupplyField.MATERIAL.getName()));
        resMap.put("s_unit", supplyRow.getLong(DefaultField.RequireField.BASEUNIT.getName()));
        resMap.put("s_baseunit", supplyRow.getLong(DefaultField.RequireField.BASEUNIT.getName()));
        BigDecimal qty = MRPUtil.convert(row.get("supplyqty"), BigDecimal.ZERO);
        resMap.put("qty", qty);
        resMap.put("base_qty", qty);
        resMap.put("ori_qty", qty);
        resMap.put("change_type", "1");
        resMap.put("create_date", new Date());
        resMap.put("creater", RequestContext.get().getCurrUserId());
        resMap.put("reservesource", "CPS");
        resMap.put("isgenreserve", true);
        resMap.put("priority", requireRow.getInteger(DefaultField.RequireField.__PRIORITY_LEVEL__.getName()));
        Boolean isStorageSupply = MRPUtil.convert(supplyRow.getValue(DefaultField.SupplyField.ISSTORAGEDATA.getName()), Boolean.FALSE);
        if (isStorageSupply.booleanValue()) {
            resMap.put("s_warehouse", supplyRow.getLong(DefaultField.SupplyField.WAREHOUSE.getName()));
            resMap.put("s_location", supplyRow.getLong(DefaultField.SupplyField.STOCKLOT.getName()));
            resMap.put("s_invstatus", supplyRow.getLong(DefaultField.SupplyField.STOCKSTATUS.getName()));
            resMap.put("s_invtype", supplyRow.getLong(DefaultField.SupplyField.STOCKTYPE.getName()));
        }
        row.put("isreseve", true);
        reserveList.add(resMap);
    }

    public static int releaseReserveRecordByBillIds(IMRPEnvProvider ctx, Set<Long> bills, String releaseMode, String reservesource) {
        if (!StringUtils.equals((CharSequence)"1", (CharSequence)releaseMode)) {
            return 0;
        }
        HashSet<Long> recordIds = new HashSet<Long>(bills.size());
        QFilter[] filters = new QFilter[3];
        filters[0] = new QFilter("bill_id", "in", bills);
        filters[1] = new QFilter("reservesource", "=", (Object)reservesource);
        PlanModel planModel = (PlanModel)ctx.getService(PlanModel.class);
        filters[2] = new QFilter("r_sale_org", "in", MRPUtil.setStringParseLong(planModel.getRequirorgs()));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)NetChangeRecordEntity, (String)"id", (QFilter[])filters, null);){
            for (Row row : dataSet) {
                recordIds.add(row.getLong("id"));
            }
        }
        ReserveUtil.reserveRemove(recordIds, ctx.getRunLogNumber());
        return recordIds.size();
    }

    private static class ReserveReplaceData {
        DynamicObject record;
        DynamicObject mrpRecord;
        BigDecimal ocpWeakQty;
        LinkedHashMap<Long, BigDecimal> parent2ocpQty = new LinkedHashMap();

        ReserveReplaceData(DynamicObject record, DynamicObject mrpRecord, BigDecimal ocpWeakQty) {
            this.record = record;
            this.mrpRecord = mrpRecord;
            this.ocpWeakQty = ocpWeakQty;
        }

        public LinkedHashMap<Long, BigDecimal> getParent2ocpQty() {
            return this.parent2ocpQty;
        }
    }
}

