/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.utils.bitset.impl;

import java.util.Iterator;
import java.util.Set;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mmc.mrp.utils.bitset.IntBitSet;
import kd.mmc.mrp.utils.bitset.impl.RoaringIntBitSet;
import org.roaringbitmap.IntIterator;
import org.roaringbitmap.PeekableIntIterator;

public class FilterRoaringIntBitSet
extends RoaringIntBitSet {
    private static final long serialVersionUID = 462381038799899598L;
    private IntBitSet filter;
    private Set<Integer> removedRows;
    private RoaringIntBitSet host;

    public FilterRoaringIntBitSet(IntBitSet filter, Set<Integer> removedRows, RoaringIntBitSet host) {
        this.filter = filter;
        this.removedRows = removedRows;
        this.host = host;
    }

    @Override
    public void clear() {
        this.host.roar.clear();
    }

    @Override
    public void set(int index) {
        this.host.roar.add(index);
    }

    @Override
    public boolean get(int index) {
        return this.host.roar.contains(index);
    }

    @Override
    public void remove(int index) {
        this.host.roar.remove(index);
    }

    @Override
    public void and(IntBitSet another) {
        this.host.roar.and(((RoaringIntBitSet)another).roar);
    }

    @Override
    public void or(IntBitSet another) {
        this.host.roar.or(((RoaringIntBitSet)another).roar);
    }

    @Override
    public int cardinate() {
        return this.host.roar.getCardinality();
    }

    @Override
    public int memorySize() {
        return this.host.roar.getSizeInBytes();
    }

    @Override
    public Iterator<Integer> iterator() {
        PeekableIntIterator iter = this.host.roar.getIntIterator();
        return new Iterator<Integer>((IntIterator)iter){
            Integer ret = -1;
            final /* synthetic */ IntIterator val$iter;
            {
                this.val$iter = intIterator;
            }

            @Override
            public boolean hasNext() {
                try (TraceSpan ts = Tracer.create((String)"FilterRoaringIntBitSet.hasNext", (String)"hasNext");){
                    boolean bl = this.hasNextImpl();
                    return bl;
                }
            }

            public boolean hasNextImpl() {
                while (this.val$iter.hasNext() && this.ret == -1) {
                    boolean isRemovedRow;
                    try (TraceSpan ts = Tracer.create((String)"FilterRoaringIntBitSet.hasNextImpl", (String)"hasNextImpl");){
                        this.ret = this.val$iter.next();
                    }
                    boolean isEnabeldRow = FilterRoaringIntBitSet.this.filter == null || FilterRoaringIntBitSet.this.filter.get(this.ret);
                    if (!isEnabeldRow || !(isRemovedRow = FilterRoaringIntBitSet.this.removedRows != null && FilterRoaringIntBitSet.this.removedRows.contains(this.ret))) continue;
                    this.ret = -1;
                }
                return this.ret != -1;
            }

            @Override
            public Integer next() {
                Integer idx = this.ret;
                this.ret = -1;
                return idx;
            }
        };
    }

    @Override
    public IntBitSet clone() {
        FilterRoaringIntBitSet intBitSet = new FilterRoaringIntBitSet(this.filter, this.removedRows, this.host);
        return intBitSet;
    }
}

