/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.calcnode.framework.mq.resolver.balance;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mmc.mrp.calcnode.framework.step.MRPCalQty4SupplyOrg;
import kd.mmc.mrp.calcnode.framework.step.MRPInventoryPlanStep;
import kd.mmc.mrp.calcnode.framework.step.MRPMCreatePlanOrder;
import kd.mmc.mrp.calcnode.framework.step.MRPMDataBalanceStep;
import kd.mmc.mrp.calcnode.framework.step.MRPMDependentReqStep;
import kd.mmc.mrp.calcnode.framework.step.MRPMReuqirePriorityLevelCalcStep;
import kd.mmc.mrp.calcnode.framework.step.MRPMSafeInvResolveStep;
import kd.mmc.mrp.calcnode.framework.step.MRPMergeRule;
import kd.mmc.mrp.calcnode.framework.step.MRPYieldCal;
import kd.mmc.mrp.calcnode.framework.step.result.MRPDataBalanceResult;
import kd.mmc.mrp.calcnode.framework.step.result.PlanOrderCreateResult;
import kd.mmc.mrp.common.consts.PlanScopeRelationConst;
import kd.mmc.mrp.common.util.DynamicObjDataUtil;
import kd.mmc.mrp.exception.MRPBizException;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.MultiThreadCacheManager;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.cache.MRPRedisStore;
import kd.mmc.mrp.framework.consts.Errors;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.framework.mq.event.MRPEvent;
import kd.mmc.mrp.framework.mq.resolver.IEventResolver;
import kd.mmc.mrp.framework.runner.AbstractMRPRunner;
import kd.mmc.mrp.integrate.entity.CacheDatas;
import kd.mmc.mrp.integrate.entity.InventoryModel;
import kd.mmc.mrp.integrate.entity.MtPlanInfoModel;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.integrate.entity.RequireDataModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.enums.MultiThreadCacheKey;
import kd.mmc.mrp.model.enums.strategy.BillAdjustStrategy;
import kd.mmc.mrp.model.enums.strategy.BillSplitStrategy;
import kd.mmc.mrp.model.enums.strategy.BillSupplyStrategy;
import kd.mmc.mrp.model.enums.strategy.MaterialAttribute;
import kd.mmc.mrp.model.enums.strategy.MaterialPlanMode;
import kd.mmc.mrp.model.enums.strategy.OORBillResolveStrategy;
import kd.mmc.mrp.model.enums.strategy.PriorityLevelCalcMode;
import kd.mmc.mrp.model.struct.ReserveData;
import kd.mmc.mrp.model.struct.SupplyStruct;
import kd.mmc.mrp.model.table.ColumnDatas;
import kd.mmc.mrp.model.table.DataBalanceTable;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.table.res.BOMStructDataTable;
import kd.mmc.mrp.model.table.res.RequirementDataTable;
import kd.mmc.mrp.model.table.res.SupplymentDataTable;
import kd.mmc.mrp.model.table.utils.DataBalanceUtil;
import kd.mmc.mrp.model.table.utils.InvPlanUtil;
import kd.mmc.mrp.model.table.utils.ReplaceUtil;
import kd.mmc.mrp.model.wrapper.SimplePlanOrder;
import kd.mmc.mrp.utils.ExtPluginUtil;
import kd.mmc.mrp.utils.MRPClearDataUtil;
import kd.mmc.mrp.utils.MRPUtil;
import kd.mmc.mrp.utils.QuotaAllocationUtil;
import kd.mmc.mrp.utils.ReserveUtil;
import kd.mmc.mrp.vo.DynamicCycleVo;
import kd.mmc.mrp.vo.MergeCycleVo;
import kd.mpscmm.msplan.business.inventory.InvLevel;
import kd.sdk.mmc.mrp.extpoint.IMRPCalcNetDemandPlugin;
import kd.sdk.mmc.mrp.extpoint.IMRPClearHistoryDataPlugin;
import kd.sdk.mmc.mrp.framework.res.IResModelDataTable;
import kd.sdk.mmc.mrp.framework.res.IRowData;

public class MRPDataBalanceResolver
implements IEventResolver {
    private static Log logger = LogFactory.getLog(MRPDataBalanceResolver.class);
    protected int llc;
    protected String materialId;
    protected List<String> groupMIds;
    protected RequirementDataTable requireTbl;
    protected SupplymentDataTable supplyTbl;
    protected BOMStructDataTable bomTbl;
    protected IMRPEnvProvider ctx;
    protected MRPEvent event;
    protected int requireCount;
    protected int supplyCount;
    protected int dependentCount;
    private String threadName;
    protected PlanOrderCreateResult result;
    protected String outputType;
    private List<Object[]> reserveDatas;
    private boolean isDynamicBOM;
    private boolean isContainsInvMaterial = false;
    private IMRPCalcNetDemandPlugin imrpCalcNetDemandPlugin;
    protected Map<String, RequireRowData> invPlanKey2Require;
    protected Map<String, Map<String, BigDecimal>> historySupplierQty = new HashMap<String, Map<String, BigDecimal>>(2);
    protected IMRPClearHistoryDataPlugin clearHistoryDataPlugin = null;
    protected boolean isInitClearPlugin = false;
    protected Map<String, Integer> midAndOrg2mAttr = new HashMap<String, Integer>(2);
    protected Map<String, Map<Long, BigDecimal>> mid2billIdQtys = new HashMap<String, Map<Long, BigDecimal>>(2);
    private int detailCnt = 0;
    private int savedBatchCnt = 0;

    private boolean setup() {
        Boolean cfgValue = (Boolean)this.ctx.getCfgValue(EnvCfgItem.INV_LEVEL_CALC);
        this.requireTbl.clear();
        this.supplyTbl.clear();
        this.ctx.calcBalanceDetails().getMappings().clear();
        this.reserveDatas = new ArrayList<Object[]>(16);
        if (this.isDynamicBOM) {
            this.bomTbl.clear();
        }
        StringBuilder groupIds = new StringBuilder();
        if (this.groupMIds != null) {
            Iterator<String> iterator = this.groupMIds.iterator();
            while (iterator.hasNext()) {
                boolean tmp;
                String mId;
                this.materialId = mId = iterator.next();
                groupIds.append(mId).append(",");
                boolean bl = tmp = cfgValue != false && !DynamicObjDataUtil.isNullStringOr0Long((String)this.materialId) && MRPDataBalanceResolver.isInvLevelMaterial(this.ctx, Long.valueOf(this.materialId));
                if (!this.isContainsInvMaterial) {
                    this.isContainsInvMaterial = tmp;
                }
                this.setupSingle();
            }
        } else {
            this.isContainsInvMaterial = cfgValue != false && !DynamicObjDataUtil.isNullStringOr0Long((String)this.materialId) && MRPDataBalanceResolver.isInvLevelMaterial(this.ctx, Long.valueOf(this.materialId));
            this.setupSingle();
        }
        if (groupIds.length() > 30) {
            groupIds = new StringBuilder(groupIds.substring(0, 27));
            groupIds.append("\u2026\u2026");
        }
        String calcTag = String.format("%s~%s~%s~%s~%s~%s", new Date().toLocaleString(), this.requireCount, this.supplyCount, this.isContainsInvMaterial, this.isDynamicBOM, groupIds.length() > 0 ? groupIds : this.materialId);
        try (TraceSpan ts = Tracer.create((String)("MRPDataBalanceResolver." + calcTag), (String)calcTag);){
            boolean bl = this.requireCount != 0 || this.supplyCount != 0 || this.isContainsInvMaterial;
            return bl;
        }
    }

    private void setupSingle() {
        this.requireTbl.setLLC(this.llc);
        this.supplyTbl.setLLC(this.llc);
        Map map = MRPCacheManager.getInst().getSubDataMap((CalEnv)this.ctx, "require-" + this.materialId);
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                String[] splits = MRPRuntimeConsts.splitDataKey((String)((String)entry.getKey()));
                this.ctx.restoreTableDatas(splits[0], splits[1], this.materialId, JSON.parseArray((String)((String)entry.getValue()), Object[].class), true);
            }
        }
        this.event.setParam(MultiThreadCacheKey.KEY_REPLY_RC, (Serializable)this.ctx.requireDatas().size());
        this.initInvLevelRequire(this.ctx, this.materialId);
        CacheDatas cacheDatas = (CacheDatas)this.ctx.getService(CacheDatas.class);
        if (cacheDatas.isSelectBillPlan() && !this.requireTbl.getBill2billEntrys().isEmpty()) {
            this.selectPlanClearOrder(this.requireTbl.getBill2billEntrys());
        }
        if ((map = MRPCacheManager.getInst().getSubDataMap((CalEnv)this.ctx, "supply-" + this.materialId)) != null && map.size() > 0) {
            ArrayList<Map.Entry<String, String>> sorted = new ArrayList<Map.Entry<String, String>>(map.size());
            for (Map.Entry entry : map.entrySet()) {
                sorted.add(entry);
            }
            sorted.sort(new Comparator<Map.Entry<String, String>>(){

                @Override
                public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                    String[] splits1 = MRPRuntimeConsts.splitDataKey((String)o1.getKey());
                    String[] splits2 = MRPRuntimeConsts.splitDataKey((String)o2.getKey());
                    return splits1[1].compareTo(splits2[1]);
                }
            });
            for (Map.Entry entry : sorted) {
                String[] splits = MRPRuntimeConsts.splitDataKey((String)((String)entry.getKey()));
                this.ctx.restoreTableDatas(splits[0], splits[1], this.materialId, JSON.parseArray((String)((String)entry.getValue()), Object[].class), false);
            }
        }
        this.event.setParam(MultiThreadCacheKey.KEY_REPLY_SC, (Serializable)this.ctx.supplyDatas().size());
        String cacheKey = MRPRuntimeConsts.getReserveRecordSplitKey((String)this.ctx.getMRPContextId(), (String)this.materialId);
        String jsonStr = MRPCacheManager.getInst().getSubData((CalEnv)this.ctx, "reserve_record", cacheKey);
        if (StringUtils.isNotBlank((CharSequence)jsonStr)) {
            this.reserveDatas.addAll(JSON.parseArray((String)jsonStr, Object[].class));
        }
        this.requireCount += this.requireTbl.size().intValue();
        this.supplyCount += this.supplyTbl.size().intValue();
        this.ctx.getFlexDataTable().loadFlexValues();
        this.handleDUNMaterial();
    }

    private void selectPlanClearOrder(Map<String, Set<String>> bill2billEntrys) {
        RequireDataModel require = (RequireDataModel)this.ctx.getService(RequireDataModel.class);
        String outputType = require.getOutputType();
        String outputCollaborativeorder = require.getOutputCollaborativeorder();
        PlanModel planModel = (PlanModel)this.ctx.getService(PlanModel.class);
        boolean isautodropplanbill = (Boolean)planModel.getPlanDataByParam("isautodropplanbill", (Object)false);
        ArrayList<String> orderTypes = new ArrayList<String>(4);
        String auditordertype = (String)planModel.getPlanDataByParam("auditordertype", (Object)"");
        for (String type : auditordertype.split(",")) {
            if (!StringUtils.isNotBlank((CharSequence)type)) continue;
            orderTypes.add(type);
        }
        boolean isDeleteAuditBill = isautodropplanbill && !orderTypes.isEmpty();
        HashSet supplyOrgs = new HashSet(planModel.getSupplyorgs());
        QFilter filterRequireOrg = new QFilter("org", "in", (Object)MRPUtil.setStringParseLong((Set)planModel.getRequirorgs()));
        QFilter filterSupplyOrg = new QFilter("proorpurorg", "in", (Object)MRPUtil.setStringParseLong(supplyOrgs));
        List qFilters = MRPClearDataUtil.getMRPClearHistoryDataFilter((IMRPEnvProvider)this.ctx, (QFilter)filterRequireOrg, (QFilter)filterSupplyOrg);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(qFilters);
        QFilter qFilterRequireBill = new QFilter("demandbillid", "in", bill2billEntrys.keySet());
        qFilterList.add(qFilterRequireBill);
        HashSet<Long> deleteIds = new HashSet<Long>(16);
        try (DataSet dataset = this.ctx.getORM().queryDataSet("MRP-PLANORDER-CLEANER", outputType, "id,demandbillid,demandbillentryid", this.getPlanOrderClearFilters(qFilterList), "");){
            this.addClearIds(dataset, deleteIds, "demandbillid", "demandbillentryid", bill2billEntrys);
        }
        if (isDeleteAuditBill) {
            dataset = this.ctx.getORM().queryDataSet("MRP-PLANORDER-CLEANER", outputType, "id,demandbillid,demandbillentryid", this.getPlanOrderClearFilters(MRPClearDataUtil.getDeleteAuditBillFilters((List)qFilters, qFilterList, orderTypes)), "");
            var18_21 = null;
            try {
                this.addClearIds(dataset, deleteIds, "demandbillid", "demandbillentryid", bill2billEntrys);
            }
            catch (Throwable throwable) {
                var18_21 = throwable;
                throw throwable;
            }
            finally {
                if (dataset != null) {
                    if (var18_21 != null) {
                        try {
                            dataset.close();
                        }
                        catch (Throwable throwable) {
                            var18_21.addSuppressed(throwable);
                        }
                    } else {
                        dataset.close();
                    }
                }
            }
        }
        filterRequireOrg.__setProperty("org");
        filterSupplyOrg.__setProperty("supplyorg");
        qFilterRequireBill.__setProperty("demandbillid");
        HashSet<Long> deleteCollIds = new HashSet<Long>(16);
        MRPClearDataUtil.addCollaborativeorderBillStatusFilter(qFilterList);
        try (DataSet dataset = this.ctx.getORM().queryDataSet("MRP-PLANORDER-CLEANER", outputCollaborativeorder, "id,demandbillid,demandbillentryid", this.getCollaborativeOrderClearFilters(qFilterList), "");){
            this.addClearIds(dataset, deleteCollIds, "demandbillid", "demandbillentryid", bill2billEntrys);
        }
        require.getSelectPlanDeleteOrderIds().addAll(deleteIds);
        require.getSelectPlanDeleteCollIds().addAll(deleteCollIds);
        ReserveUtil.reserveRemoveByBillId(deleteIds, (String)this.ctx.getRunLogNumber());
        ReserveUtil.reserveRemoveByBillId(deleteCollIds, (String)this.ctx.getRunLogNumber());
    }

    private void addClearIds(DataSet dataset, Set<Long> deleteIds, String demandbillidField, String demandbillentryidField, Map<String, Set<String>> bill2billEntrys) {
        for (Row row : dataset) {
            Long id = row.getLong("id");
            String demandbillid = row.getString(demandbillidField);
            String demandbillentryid = row.getString(demandbillentryidField);
            Set<String> billEntrys = bill2billEntrys.get(demandbillid);
            if (billEntrys == null || !billEntrys.contains(demandbillentryid.trim())) continue;
            deleteIds.add(id);
        }
    }

    protected IMRPClearHistoryDataPlugin getClearHistoryDataPlugin() {
        if (!this.isInitClearPlugin) {
            this.clearHistoryDataPlugin = (IMRPClearHistoryDataPlugin)ExtPluginUtil.getProxyPlugin(null, IMRPClearHistoryDataPlugin.class, (String)"MRP_CLEARHISTORYDATA_EXT", null);
            this.isInitClearPlugin = true;
        }
        return this.clearHistoryDataPlugin;
    }

    protected QFilter[] getPlanOrderClearFilters(List<QFilter> qFilterList) {
        IMRPClearHistoryDataPlugin clearHistoryDataPlugin = this.getClearHistoryDataPlugin();
        return clearHistoryDataPlugin == null ? qFilterList.toArray(new QFilter[0]) : clearHistoryDataPlugin.getPlanOrderClearFilters(this.ctx.getMrpSdkEnv(), qFilterList);
    }

    protected QFilter[] getCollaborativeOrderClearFilters(List<QFilter> qFilterList) {
        IMRPClearHistoryDataPlugin clearHistoryDataPlugin = this.getClearHistoryDataPlugin();
        return clearHistoryDataPlugin == null ? qFilterList.toArray(new QFilter[0]) : clearHistoryDataPlugin.getCollaborativeOrderClearFilters(this.ctx.getMrpSdkEnv(), qFilterList);
    }

    public static boolean isInvLevelMaterial(IMRPEnvProvider ctx, Long materialId) {
        boolean isMaxMin;
        PlanModel pm = (PlanModel)ctx.getService(PlanModel.class);
        InventoryModel invModel = (InventoryModel)ctx.getService(InventoryModel.class);
        InvLevel invLevel = invModel.getInvLevel();
        Map mtOrgsMap = invModel.getMtOrgsFromCache();
        boolean isReorderPoint = pm.isReorderPoint() && invLevel != null;
        boolean bl = isMaxMin = pm.isMaxMinInventory() && invLevel != null;
        if (isReorderPoint || isMaxMin) {
            Set orgs = (Set)mtOrgsMap.get(materialId);
            if (orgs != null) {
                return !Collections.disjoint(orgs, MRPUtil.setStringParseLong((Set)ctx.getRequirorgs()));
            }
            return false;
        }
        return false;
    }

    private void initInvLevelRequire(IMRPEnvProvider ctx, String materialId) {
        PlanModel pm = (PlanModel)ctx.getService(PlanModel.class);
        MtPlanInfoModel planInfoModel = (MtPlanInfoModel)ctx.getService(MtPlanInfoModel.class);
        boolean isReorderPoint = pm.isReorderPoint();
        boolean isMaxMin = pm.isMaxMinInventory();
        HashSet orgs = ctx.getRequirorgs();
        MRPRedisStore dstore = MRPCacheManager.getDStore((String)ctx.getMRPContextId());
        boolean isEnablePlanScope = pm.isEnablePlanScope();
        if (isReorderPoint || isMaxMin) {
            for (String org : orgs) {
                Map subMap;
                String cacheKey = PlanScopeRelationConst.getRedisPlanScopeRelationKey((String)org, (String)materialId);
                Map info = planInfoModel.getMaterialPlanInfo(materialId, org, false);
                SupplyStruct ss = (SupplyStruct)pm.getPriorityRelations().get(org);
                if (info != null && ss != null) {
                    if (info.get("inv_not_allow_strategy") != null) continue;
                    String planMode = MRPUtil.getString((Map)info, (String)"planmode");
                    BigDecimal qty = null;
                    if (MaterialPlanMode.MAXANDMININV.getValue().equalsIgnoreCase(planMode) && isMaxMin) {
                        qty = (BigDecimal)MRPUtil.convert(info.get("min"), (Object)BigDecimal.ZERO);
                    } else if (MaterialPlanMode.REORDERPOINT.getValue().equalsIgnoreCase(planMode) && isReorderPoint) {
                        qty = (BigDecimal)MRPUtil.convert(info.get("reorderpoint"), (Object)BigDecimal.ZERO);
                    }
                    if (qty != null) {
                        RequireRowData requireRowData = InvPlanUtil.createEmptyRequire((IMRPEnvProvider)ctx, (BigDecimal)qty, (Long)(isEnablePlanScope ? ss.getPlanScope() : 0L), (Long)Long.parseLong(org), (Long)Long.parseLong(materialId), (Long)ctx.getPlanDate().getTime(), (Long)MRPUtil.getLong((Map)info, (String)"id"), (Long)0L, (int)0, (String)"mpdm_materialplan");
                        this.addInvEmptyRequire(ctx, requireRowData, isEnablePlanScope);
                    }
                }
                if (!isEnablePlanScope || (subMap = (Map)dstore.mapGet("mpList_scope", cacheKey)) == null) continue;
                for (Map.Entry entry : subMap.entrySet()) {
                    Object[] data;
                    long planScope = Long.parseLong((String)entry.getKey());
                    if (entry.getValue() == null || !MRPUtil.convert((Object)(data = (Object[])JSON.parseObject((String)((String)entry.getValue()), Object[].class))[17], (Boolean)Boolean.FALSE).booleanValue()) continue;
                    String planMode = (String)MRPUtil.convert((Object)data[0], (Object)"");
                    BigDecimal qty = null;
                    if (MaterialPlanMode.MAXANDMININV.getValue().equalsIgnoreCase(planMode) && isMaxMin) {
                        qty = (BigDecimal)MRPUtil.convert((Object)data[6], (Object)BigDecimal.ZERO);
                    } else if (MaterialPlanMode.REORDERPOINT.getValue().equalsIgnoreCase(planMode) && isReorderPoint) {
                        qty = (BigDecimal)MRPUtil.convert((Object)data[3], (Object)BigDecimal.ZERO);
                    }
                    if (qty == null) continue;
                    RequireRowData requireRowData = InvPlanUtil.createEmptyRequire((IMRPEnvProvider)ctx, (BigDecimal)qty, (Long)planScope, (Long)Long.parseLong(org), (Long)Long.parseLong(materialId), (Long)ctx.getPlanDate().getTime(), (Long)((Long)MRPUtil.convert((Object)data[13], (Object)0L)), (Long)((Long)MRPUtil.convert((Object)data[14], (Object)0L)), (int)((Integer)MRPUtil.convert((Object)data[15], (Object)0)), (String)"msplan_matplanscop");
                    this.addInvEmptyRequire(ctx, requireRowData, isEnablePlanScope);
                }
            }
        }
    }

    private void addInvEmptyRequire(IMRPEnvProvider ctx, RequireRowData requireRowData, boolean isEnablePlanScope) {
        CacheDatas cacheDatas = (CacheDatas)ctx.getService(CacheDatas.class);
        String key = InvPlanUtil.getEmptyRequireKey((RequireRowData)requireRowData, (boolean)isEnablePlanScope);
        requireRowData = this.requireTbl.fetchRow(this.requireTbl.fill((RowData)requireRowData));
        this.invPlanKey2Require.put(key, requireRowData);
        if (cacheDatas.isSelectBillPlan()) {
            Long billId = (Long)MRPUtil.convert((Object)requireRowData.getValue(DefaultField.RequireField.BILLID.getName()), (Object)0L);
            Long billEntryId = (Long)MRPUtil.convert((Object)requireRowData.getValue(DefaultField.RequireField.BILLENTRYID.getName()), (Object)0L);
            Set entrys = this.requireTbl.getBill2billEntrys().computeIfAbsent(billId.toString(), k -> new HashSet(2));
            if (billEntryId <= 0L) {
                entrys.add("");
                entrys.add("0");
            } else {
                entrys.add(billEntryId.toString());
            }
        }
    }

    protected boolean isFabricatedpart(RequireRowData row) {
        int value = (Integer)MRPUtil.convert((Object)row.getValue(DefaultField.RequireField.MATERIALATTR.getName()), (Object)10070);
        return MaterialAttribute.STORAGEPART.getValue() == value;
    }

    protected boolean handleDUNMaterial() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(MRPEvent event, IMRPEnvProvider actx) {
        Throwable throwable;
        TraceSpan ts;
        int sCnt;
        int rCnt;
        long start;
        block30: {
            this.threadName = Thread.currentThread().getName();
            start = System.currentTimeMillis();
            rCnt = 0;
            sCnt = 0;
            try {
                block31: {
                    block32: {
                        Serializable tmp = event.getParam(MultiThreadCacheKey.KEY_MATERIAL_ID_BY_GROUP);
                        if (tmp != null) {
                            this.groupMIds = JSON.parseArray((String)tmp.toString(), String.class);
                        }
                        this.llc = Integer.parseInt(event.getParam(MultiThreadCacheKey.KEY_LLC).toString());
                        this.materialId = event.getParam(MultiThreadCacheKey.KEY_MATERIAL_ID).toString();
                        this.event = event;
                        this.ctx = MRPUtil.clone((IMRPEnvProvider)actx);
                        this.isDynamicBOM = (Boolean)this.ctx.getCfgValue(EnvCfgItem.DYNAMIC_BOM_RESTORE);
                        this.requireTbl = this.ctx.requireDatas();
                        this.supplyTbl = this.ctx.supplyDatas();
                        this.bomTbl = this.ctx.bomDatas();
                        this.imrpCalcNetDemandPlugin = (IMRPCalcNetDemandPlugin)ExtPluginUtil.getProxyPlugin(null, IMRPCalcNetDemandPlugin.class, (String)"MRP_CALCNETDEMAND_EXT", null);
                        this.ctx.setMRPCalcNetDemandPlugin(this.imrpCalcNetDemandPlugin);
                        this.invPlanKey2Require = this.ctx.getInvPlanKey2Require();
                        this.ctx.putLocalParam("__IS_FIRST_DATA_BALANCE__", (Object)"1");
                        ts = Tracer.create((String)"MRPDataBalanceResolver.setup", (String)"setup");
                        throwable = null;
                        try {
                            if (this.setup()) break block30;
                            if (ts == null) break block31;
                            if (throwable == null) break block32;
                        }
                        catch (Throwable resolverTime) {
                            try {
                                throwable = resolverTime;
                                throw resolverTime;
                            }
                            catch (Throwable throwable3) {
                                if (ts == null) throw throwable3;
                                if (throwable == null) {
                                    ts.close();
                                    throw throwable3;
                                }
                                try {
                                    ts.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                        }
                        try {
                            ts.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block31;
                    }
                    ts.close();
                }
                this.ctx.getReserveCacheData().clear();
            }
            catch (Throwable throwable5) {
                this.ctx.getReserveCacheData().clear();
                this.ctx.requireDatas().clear();
                this.ctx.supplyDatas().clear();
                this.ctx.getRichQtyMap().clear();
                this.ctx.getRsMappings().clear();
                this.ctx.getSpecialCycleCache().clear();
                this.ctx.getPo2BomIdx().clear();
                this.ctx.getInvPlanKey2Require().clear();
                this.ctx.getPoNum2InvRequireQty().clear();
                this.ctx.getSupplyOccupyQty().clear();
                this.supplyTbl.clearReserveDataCache();
                this.requireTbl.getBill2billEntrys().clear();
                Thread.currentThread().setName(this.threadName);
                long resolverTime = System.currentTimeMillis() - start;
                if (resolverTime <= 10000L) throw throwable5;
                logger.warn(String.format("mrprunner-slowcal-worker-info :ctxid: %s, mrprunner-event-resolve(%s), evtid: %s,materialId: %s, timecost: %s(S), rCnt: %s, sCnt: %s", event.getMrpContextId(), event.getClass().getName(), event.getEventId(), this.materialId, resolverTime / 1000L, rCnt, sCnt));
                throw throwable5;
            }
            this.ctx.requireDatas().clear();
            this.ctx.supplyDatas().clear();
            this.ctx.getRichQtyMap().clear();
            this.ctx.getRsMappings().clear();
            this.ctx.getSpecialCycleCache().clear();
            this.ctx.getPo2BomIdx().clear();
            this.ctx.getInvPlanKey2Require().clear();
            this.ctx.getPoNum2InvRequireQty().clear();
            this.ctx.getSupplyOccupyQty().clear();
            this.supplyTbl.clearReserveDataCache();
            this.requireTbl.getBill2billEntrys().clear();
            Thread.currentThread().setName(this.threadName);
            long resolverTime = System.currentTimeMillis() - start;
            if (resolverTime <= 10000L) return;
            logger.warn(String.format("mrprunner-slowcal-worker-info :ctxid: %s, mrprunner-event-resolve(%s), evtid: %s,materialId: %s, timecost: %s(S), rCnt: %s, sCnt: %s", event.getMrpContextId(), event.getClass().getName(), event.getEventId(), this.materialId, resolverTime / 1000L, rCnt, sCnt));
            return;
        }
        if (ts != null) {
            if (throwable != null) {
                try {
                    ts.close();
                }
                catch (Throwable resolverTime) {
                    throwable.addSuppressed(resolverTime);
                }
            } else {
                ts.close();
            }
        }
        this.materialId = event.getParam(MultiThreadCacheKey.KEY_MATERIAL_ID).toString();
        rCnt = this.requireTbl.size();
        sCnt = this.supplyTbl.size();
        RequireDataModel requireDataModel = (RequireDataModel)this.ctx.getService(RequireDataModel.class);
        this.outputType = requireDataModel.getOutputType();
        StringBuilder sb = new StringBuilder();
        sb.append("MRPCalcWorker[eid=").append(event.getEventId()).append(", mid=").append(this.materialId).append(", rc=").append(this.requireCount).append(", sc=").append(this.supplyCount).append(", llc=").append(this.llc).append(']');
        sb.append(" start at ").append(new Date().toLocaleString());
        sb.append(this.threadName);
        Thread.currentThread().setName(sb.toString());
        try (TraceSpan ts2 = Tracer.create((String)"MRPDataBalanceResolver.innerexecute", (String)"innerexecute");){
            this.innerexecute();
        }
        event.setParam(MultiThreadCacheKey.KEY_REPLY_DC, (Serializable)this.ctx.requireDatas().size());
        this.ctx.getReserveCacheData().clear();
        this.ctx.requireDatas().clear();
        this.ctx.supplyDatas().clear();
        this.ctx.getRichQtyMap().clear();
        this.ctx.getRsMappings().clear();
        this.ctx.getSpecialCycleCache().clear();
        this.ctx.getPo2BomIdx().clear();
        this.ctx.getInvPlanKey2Require().clear();
        this.ctx.getPoNum2InvRequireQty().clear();
        this.ctx.getSupplyOccupyQty().clear();
        this.supplyTbl.clearReserveDataCache();
        this.requireTbl.getBill2billEntrys().clear();
        Thread.currentThread().setName(this.threadName);
        long resolverTime = System.currentTimeMillis() - start;
        if (resolverTime <= 10000L) return;
        logger.warn(String.format("mrprunner-slowcal-worker-info :ctxid: %s, mrprunner-event-resolve(%s), evtid: %s,materialId: %s, timecost: %s(S), rCnt: %s, sCnt: %s", event.getMrpContextId(), event.getClass().getName(), event.getEventId(), this.materialId, resolverTime / 1000L, rCnt, sCnt));
    }

    protected void innerexecute() {
        long start = System.currentTimeMillis();
        if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("ctxid: %s, mrprunner-setup requiresize: %s, llc: %s, supplysize: %s, mid: %s, timecost: %s(ms)", this.ctx.getMRPContextId(), this.ctx.requireDatas().size(), this.ctx.supplyDatas().size(), this.llc, this.materialId, System.currentTimeMillis() - start));
        }
        start = System.currentTimeMillis();
        List<RequireRowData> requires = null;
        this.ctx.loadSupplyMaterialExtProps();
        if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("ctxid: %s, mrprunner-loadSupplyMaterialExtProps llc: %s, mid: %s, timecost: %s(ms)", this.ctx.getMRPContextId(), this.llc, this.materialId, System.currentTimeMillis() - start));
        }
        if ("REQUIRE_ADJUST".equals(this.ctx.getCfgValue(EnvCfgItem.SAFE_INV_REQUIRE_APPLY_MODE))) {
            start = System.currentTimeMillis();
            this.executeSafeInvRequireAdvanceStep();
            if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                logger.warn(String.format("ctxid: %s, mrprunner-executeSafeInvRequireAdvanceStep llc: %s, mid: %s, timecost: %s(ms), rCnt: %s", this.ctx.getMRPContextId(), this.llc, this.materialId, System.currentTimeMillis() - start, this.requireTbl.size()));
            }
        }
        long redisAccTime = 0L;
        start = System.currentTimeMillis();
        new MRPYieldCal(this.ctx, 0).execute();
        if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("ctxid: %s, mrprunner-MRPYieldCal llc: %s, mid: %s, timecost: %s(ms)", this.ctx.getMRPContextId(), this.llc, this.materialId, System.currentTimeMillis() - start));
        }
        this.supplyTbl.initReserveMapping(this.requireTbl, this.reserveDatas);
        this.reserveDatas = null;
        this.initSupplyData(this.supplyTbl);
        do {
            MRPDataBalanceResult bResult;
            start = System.currentTimeMillis();
            this.ctx.testEnvStatus();
            redisAccTime += System.currentTimeMillis() - start;
            start = System.currentTimeMillis();
            this.ctx.loadRequireMaterialExtProps();
            if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                logger.warn(String.format("ctxid: %s, mrprunner-loadRequireMaterialExtProps llc: %s, mid: %s, timecost: %s(ms), rCnt: %s, sCnt: %s", this.ctx.getMRPContextId(), this.llc, this.materialId, System.currentTimeMillis() - start, this.requireTbl.size(), this.supplyTbl.size()));
            }
            start = System.currentTimeMillis();
            this.executeCalQty4SupplyOrg();
            if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                logger.warn(String.format("ctxid: %s, mrprunner-MRPCalQty4SupplyOrg llc: %s, mid: %s, timecost: %s(ms), rCnt: %s", this.ctx.getMRPContextId(), this.llc, this.materialId, System.currentTimeMillis() - start, this.requireTbl.size()));
            }
            start = System.currentTimeMillis();
            new MRPMergeRule(this.ctx).execute();
            if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                logger.warn(String.format("ctxid: %s, mrprunner-MRPMergeRule llc: %s, mid: %s, timecost: %s(ms), rCnt: %s", this.ctx.getMRPContextId(), this.llc, this.materialId, System.currentTimeMillis() - start, this.requireTbl.size()));
            }
            start = System.currentTimeMillis();
            this.executeRequirePriorityStep();
            if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                logger.warn(String.format("ctxid: %s, mrprunner-MRPMReuqirePriorityLevelCalcStep llc: %s, mid: %s, timecost: %s(ms)", this.ctx.getMRPContextId(), this.llc, this.materialId, System.currentTimeMillis() - start));
            }
            start = System.currentTimeMillis();
            try (TraceSpan ts = Tracer.create((String)"MRPDataBalanceResolver.executeBalanceStep", (String)"executeBalanceStep");){
                bResult = this.executeBalanceStep();
            }
            if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG)) || System.currentTimeMillis() - start > 10000L) {
                logger.warn(String.format("ctxid: %s, mrprunner-executeBalanceStep llc: %s, mid: %s, timecost: %s(ms), rCnt: %s, sCnt: %s, rsMappingCnt: %s", this.ctx.getMRPContextId(), this.llc, this.materialId, System.currentTimeMillis() - start, this.requireCount, this.supplyCount, this.ctx.calcBalanceDetails().getUnVisitedSize()));
            }
            start = System.currentTimeMillis();
            this.ctx.requireDatas().lockAll();
            requires = bResult.getCollaborates();
            this.ctx.putLocalParam("__IS_FIRST_DATA_BALANCE__", (Object)"0");
            if (requires == null || requires.isEmpty()) continue;
            this.ctx.requireDatas().fill(requires.toArray(new RowData[0]));
            if (!"1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) continue;
            logger.warn(String.format("ctxid: %s, llc: %s, collaborate bill count: %s", this.ctx.getMRPContextId(), this.llc, requires.size()));
        } while (requires != null && !requires.isEmpty());
        if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("ctxid: %s, mrprunner-mrpdatabalanceresolver-cacheacctime llc: %s, mid: %s, timecost: %s(ms)", this.ctx.getMRPContextId(), this.llc, this.materialId, redisAccTime));
        }
        this.saveDatas();
        if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("ctxid: %s, mrprunner-saveDatas llc: %s, mid: %s, timecost: %s(ms)", this.ctx.getMRPContextId(), this.llc, this.materialId, System.currentTimeMillis() - start));
        }
    }

    protected void initSupplyData(SupplymentDataTable supplyTbl) {
        if (this.imrpCalcNetDemandPlugin != null) {
            this.imrpCalcNetDemandPlugin.initSupplyDatas(this.ctx.getMrpSdkEnv(), (IResModelDataTable)supplyTbl);
        }
    }

    protected void executeRequirePriorityStep() {
        PriorityLevelCalcMode plcm = this.ctx.getPriorityLevelCalcMode();
        if (this.ctx.requireDatas().size() > 0) {
            if (this.llc == 0 || PriorityLevelCalcMode.RECALC == plcm) {
                new MRPMReuqirePriorityLevelCalcStep(this.ctx).execute();
            } else if (PriorityLevelCalcMode.INHERIT == plcm) {
                new MRPMReuqirePriorityLevelCalcStep(this.ctx, true).execute();
            }
        }
    }

    protected void executeCalQty4SupplyOrg() {
        new MRPCalQty4SupplyOrg(this.ctx).execute();
    }

    private void calcNetDemand(DataBalanceTable.RSMapping mapping) {
        IMRPCalcNetDemandPlugin imrpCalcNetDemandPlugin;
        BigDecimal rQty = MRPUtil.toBigDecimal((Object)mapping.getRequire().getValue(DefaultField.RequireField.__SUPPLY_QTY__.getName()));
        if (mapping.getSupplys() != null) {
            for (RowData s : mapping.getSupplys()) {
                rQty = rQty.subtract(MRPUtil.toBigDecimal((Object)s.getValue(DefaultField.SupplyField.QTY.getName())));
            }
        }
        if ((imrpCalcNetDemandPlugin = this.ctx.getMRPCalcNetDemandPlugin()) != null) {
            rQty = imrpCalcNetDemandPlugin.reCalcNetDemandQty(this.ctx.getMrpSdkEnv(), (IRowData)mapping.getRequire(), rQty, mapping.getSupplys());
        }
        mapping.setrQty(rQty);
        if (rQty.compareTo(BigDecimal.ZERO) <= 0) {
            mapping.setMt(DataBalanceTable.MatchType.EQUAL);
        } else {
            RequireRowData require = mapping.getRequire();
            Long date = (Long)require.getValue(DefaultField.RequireField.DATE.getName());
            date = MRPUtil.getNetRequireDateTimeByCalendar((IMRPEnvProvider)this.ctx, (Long)date, (RequireRowData)require);
            require.update(DefaultField.RequireField.DATE.getName(), (Object)date);
            this.changeMatchType(mapping);
        }
    }

    private void changeMatchType(DataBalanceTable.RSMapping mapping) {
        String exp;
        RequireRowData requireData = mapping.getRequire();
        String string = exp = requireData.getValue(DefaultField.RequireField.EXCEPTIONNUMBER.getName()) == null ? "" : String.valueOf(requireData.getValue(DefaultField.RequireField.EXCEPTIONNUMBER.getName()));
        if (!mapping.getSupplys().isEmpty() && mapping.getMt() == DataBalanceTable.MatchType.EQUAL && !MRPUtil.hasException((String)exp)) {
            mapping.setMt(DataBalanceTable.MatchType.LESS);
        }
    }

    private BigDecimal calcYield(BigDecimal rQty, RequireRowData require) {
        BigDecimal yield = BigDecimal.ONE;
        if (this.ctx.isYield()) {
            Object myield = require.getValue(DefaultField.RequireField.YIELD.getName());
            yield = MRPUtil.toBigDecimal((Object)myield);
        }
        return MRPUtil.calcYield((BigDecimal)yield, (Object)require.getValue(DefaultField.RequireField.BASEUNIT.getName()), (BigDecimal)rQty, (IMRPEnvProvider)this.ctx, (boolean)false);
    }

    protected void calQty(List<DataBalanceTable.RSMapping> calList) {
        for (DataBalanceTable.RSMapping rsMapping : calList) {
            this.calcNetDemand(rsMapping);
            RequireRowData rData = rsMapping.getRequire();
            BigDecimal rQty = rsMapping.getrQty();
            BigDecimal newrQty = this.calcYield(rQty, rData);
            rsMapping.setrQty(newrQty);
        }
    }

    private Map<String, List<DataBalanceTable.RSMapping>> splitRSMappingByMaterial(List<DataBalanceTable.RSMapping> allList) {
        HashMap<String, List<DataBalanceTable.RSMapping>> map = new HashMap<String, List<DataBalanceTable.RSMapping>>(16);
        for (DataBalanceTable.RSMapping mapping : allList) {
            RequireRowData requireRowData = mapping.getRequire();
            String mid = requireRowData.getString(DefaultField.RequireField.MATERIAL.getName());
            List calcList = map.getOrDefault(mid, new ArrayList(16));
            calcList.add(mapping);
            map.put(mid, calcList);
        }
        return map;
    }

    protected void executeBatchpolicy() {
        Map<String, List<DataBalanceTable.RSMapping>> map;
        List allList = this.ctx.calcBalanceDetails().getUnVisitedMappings();
        PlanModel planModel = (PlanModel)this.ctx.getService(PlanModel.class);
        boolean isbatchpolicy = (Boolean)planModel.getPlanDataByParam("isbatchpolicy", (Object)true);
        Throwable object = null;
        try (TraceSpan ts = Tracer.create((String)"MRPDataBalanceResolver.splitRSMappingByMaterial", (String)"splitRSMappingByMaterial");){
            map = this.splitRSMappingByMaterial(allList);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throw throwable;
        }
        for (Map.Entry entry : map.entrySet()) {
            List list = (List)entry.getValue();
            TraceSpan ts2 = Tracer.create((String)"MRPDataBalanceResolver.calQty", (String)"calQty");
            Object object2 = null;
            try {
                this.calQty(list);
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (ts2 != null) {
                    if (object2 != null) {
                        try {
                            ts2.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        ts2.close();
                    }
                }
            }
            List dealMappings = list;
            if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                logger.warn(String.format("ctxid: %s, mrprunner-calcsplit-batch-begin,size: %s,unmapsize: %s", this.ctx.getMRPContextId(), dealMappings.size(), this.ctx.calcBalanceDetails().getUnVisitedMappings().size()));
            }
            HashMap<Long, List<DataBalanceTable.RSMapping>> specialMappings = new HashMap<Long, List<DataBalanceTable.RSMapping>>(3);
            HashMap<Long, List<DataBalanceTable.RSMapping>> fixedMappings = new HashMap<Long, List<DataBalanceTable.RSMapping>>(3);
            HashMap<Long, List<DataBalanceTable.RSMapping>> dynamicMappings = new HashMap<Long, List<DataBalanceTable.RSMapping>>(3);
            HashMap<Long, List<DataBalanceTable.RSMapping>> purSpecialMappings = new HashMap<Long, List<DataBalanceTable.RSMapping>>(3);
            HashMap<Long, List<DataBalanceTable.RSMapping>> purFixedMappings = new HashMap<Long, List<DataBalanceTable.RSMapping>>(3);
            HashMap<Long, List<DataBalanceTable.RSMapping>> purDynamicMappings = new HashMap<Long, List<DataBalanceTable.RSMapping>>(3);
            if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                logger.warn(String.format("ctxid: %s, mrprunner-calcsplit-batch-end,size: %s, unmapsize: %s", this.ctx.getMRPContextId(), dealMappings.size(), this.ctx.calcBalanceDetails().getUnVisitedMappings().size()));
            }
            ArrayList<DataBalanceTable.RSMapping> purQuotaRich = new ArrayList<DataBalanceTable.RSMapping>(16);
            HashMap<Integer, Boolean> cache = new HashMap<Integer, Boolean>(16);
            for (DataBalanceTable.RSMapping rSMapping : dealMappings) {
                Throwable throwable;
                RequireRowData require = rSMapping.getRequire();
                Object strategy = require.getValue(DefaultField.RequireField.PLAN_STRATEGY.getName());
                if (strategy == null) {
                    strategy = require.getValue(DefaultField.RequireField.DEFAULT_PLAN_STRATEGY.getName());
                }
                if (strategy == null && !InvPlanUtil.isInvRequire((IMRPEnvProvider)this.ctx, (RequireRowData)require) && !this.ctx.isSpecialPlan() || MRPUtil.hasException((String)((String)MRPUtil.convert((Object)require.getValue(DefaultField.RequireField.EXCEPTIONNUMBER.getName()), (Object)""))) || InvPlanUtil.isNewInvRequire((IMRPEnvProvider)this.ctx, (RequireRowData)require) || rSMapping.isCopied() || rSMapping.getrQty().compareTo(BigDecimal.ZERO) <= 0) continue;
                String batchpolicy = require.getString(DefaultField.RequireField.BATCHPOLICY.getName());
                boolean ispurquota = this.isPurchaseQuota(require);
                if ("A".equals(batchpolicy) && !ispurquota && isbatchpolicy) {
                    TraceSpan ts3 = Tracer.create((String)"MRPDataBalanceResolver.splitOrdersByDirectLotPolicy", (String)"splitOrdersByDirectLotPolicy");
                    throwable = null;
                    try {
                        MRPUtil.splitOrdersByDirectLotPolicy((IMRPEnvProvider)this.ctx, (DataBalanceTable.RSMapping)rSMapping, cache);
                        continue;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (ts3 == null) continue;
                        if (throwable != null) {
                            try {
                                ts3.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        ts3.close();
                        continue;
                    }
                }
                if ("B".equals(batchpolicy) && !ispurquota && isbatchpolicy) {
                    TraceSpan ts = Tracer.create((String)"MRPDataBalanceResolver.splitOrdersByFixedLotPolicy", (String)"splitOrdersByFixedLotPolicy");
                    throwable = null;
                    try {
                        MRPUtil.splitOrdersByFixedLotPolicy((IMRPEnvProvider)this.ctx, (DataBalanceTable.RSMapping)rSMapping, cache);
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (ts == null) continue;
                        if (throwable != null) {
                            try {
                                ts.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        ts.close();
                        continue;
                    }
                }
                if ("C".equals(batchpolicy)) {
                    if (ispurquota) {
                        this.initCycleMappings(purSpecialMappings, purDynamicMappings, purFixedMappings, rSMapping);
                        continue;
                    }
                    if (!isbatchpolicy) continue;
                    this.initCycleMappings(specialMappings, dynamicMappings, fixedMappings, rSMapping);
                    continue;
                }
                if (!ispurquota) continue;
                if (rSMapping.getBeforeMergedQty() == null) {
                    rSMapping.setBeforeMergedQty(rSMapping.getrQty());
                }
                Map<Long, BigDecimal> supplierRatio = null;
                if (isbatchpolicy) {
                    BigDecimal rQty = QuotaAllocationUtil.richMappingSupply((IMRPEnvProvider)this.ctx, (DataBalanceTable.RSMapping)rSMapping, purQuotaRich, cache);
                    supplierRatio = this.getSupplierRatio(require, rQty);
                    rSMapping.setrQty(rQty);
                }
                TraceSpan ts4 = Tracer.create((String)"MRPDataBalanceResolver.executePurQuotaAllocation", (String)"executePurQuotaAllocation");
                Throwable throwable7 = null;
                try {
                    this.executePurQuotaAllocation(this.ctx, rSMapping, purQuotaRich, cache, supplierRatio);
                }
                catch (Throwable throwable8) {
                    throwable7 = throwable8;
                    throw throwable8;
                }
                finally {
                    if (ts4 == null) continue;
                    if (throwable7 != null) {
                        try {
                            ts4.close();
                        }
                        catch (Throwable throwable9) {
                            throwable7.addSuppressed(throwable9);
                        }
                        continue;
                    }
                    ts4.close();
                }
            }
            if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                logger.warn(String.format("ctxid: %s, mrprunner-calcsplit-executeCycleBatch-begin, unmapsize: %s", this.ctx.getMRPContextId(), this.ctx.calcBalanceDetails().getUnVisitedMappings().size()));
            }
            Throwable throwable = null;
            try (TraceSpan ts5 = Tracer.create((String)"MRPDataBalanceResolver.executeCycleBatch", (String)"executeCycleBatch");){
                this.executeCycleBatch(specialMappings, dynamicMappings, fixedMappings);
            }
            catch (Throwable throwable10) {
                Throwable throwable11 = throwable10;
                throw throwable10;
            }
            if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                logger.warn(String.format("ctxid: %s, mrprunner-calcsplit-executeCycleBatch-end, unmapsize: %s", this.ctx.getMRPContextId(), this.ctx.calcBalanceDetails().getUnVisitedMappings().size()));
            }
            if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                logger.warn(String.format("ctxid: %s, mrprunner-calcsplit-executeCyclePurQuotaAllocation-begin, unmapsize: %s", this.ctx.getMRPContextId(), this.ctx.calcBalanceDetails().getUnVisitedMappings().size()));
            }
            Throwable throwable12 = null;
            try (TraceSpan ts = Tracer.create((String)"MRPDataBalanceResolver.executeCyclePurQuotaAllocation", (String)"executeCyclePurQuotaAllocation");){
                this.executeCyclePurQuotaAllocation(purSpecialMappings, purDynamicMappings, purFixedMappings, purQuotaRich);
            }
            catch (Throwable throwable13) {
                Throwable throwable14 = throwable13;
                throw throwable13;
            }
            if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                logger.warn(String.format("ctxid: %s, mrprunner-calcsplit-executeCyclePurQuotaAllocation-end, unmapsize: %s", this.ctx.getMRPContextId(), this.ctx.calcBalanceDetails().getUnVisitedMappings().size()));
            }
            for (DataBalanceTable.RSMapping rSMapping : purQuotaRich) {
                rSMapping.setGenPlanOrder(false);
                rSMapping.setClearRequire(true);
                rSMapping.getRequire().update(DefaultField.RequireField.QTY.getName(), (Object)rSMapping.getrQty());
                if (rSMapping.getPoList() != null) {
                    rSMapping.getPoList().clear();
                }
                rSMapping.setCreateDepentRequire(false);
                this.ctx.calcBalanceDetails().getUnVisitedMappings().add(rSMapping);
            }
        }
        Map mappingMap = this.ctx.getRsMappings();
        for (Map.Entry entry : mappingMap.entrySet()) {
            List mappingList = (List)entry.getValue();
            for (DataBalanceTable.RSMapping mapping : mappingList) {
                mapping.setGenPlanOrder(false);
                mapping.setClearRequire(true);
                mapping.getRequire().update(DefaultField.RequireField.QTY.getName(), (Object)mapping.getrQty());
                if (mapping.getPoList() != null) {
                    mapping.getPoList().clear();
                }
                mapping.setCreateDepentRequire(false);
                this.ctx.calcBalanceDetails().getUnVisitedMappings().add(mapping);
            }
        }
    }

    protected boolean isPurchaseQuota(RequireRowData require) {
        return QuotaAllocationUtil.isPurchaseQuota((IMRPEnvProvider)this.ctx, (RequireRowData)require);
    }

    protected Map<Long, BigDecimal> getSupplierRatio(RequireRowData require, BigDecimal rQty) {
        return QuotaAllocationUtil.getSupplierRatio((IMRPEnvProvider)this.ctx, (RequireRowData)require, (BigDecimal)rQty, this.historySupplierQty);
    }

    protected void executePurQuotaAllocation(IMRPEnvProvider ctx, DataBalanceTable.RSMapping mapping, List<DataBalanceTable.RSMapping> purQuotaRich, Map<Integer, Boolean> cache, Map<Long, BigDecimal> orgiRatio) {
        Map<Long, BigDecimal> supplierRatio;
        BigDecimal rQty;
        RequireRowData require = mapping.getRequire();
        PlanModel planModel = (PlanModel)ctx.getService(PlanModel.class);
        String batchpolicy = require.getString(DefaultField.RequireField.BATCHPOLICY.getName());
        boolean isbatchpolicy = (Boolean)planModel.getPlanDataByParam("isbatchpolicy", (Object)true);
        BigDecimal bigDecimal = rQty = orgiRatio != null ? mapping.getrQty() : QuotaAllocationUtil.richMappingSupply((IMRPEnvProvider)ctx, (DataBalanceTable.RSMapping)mapping, purQuotaRich, cache);
        if (rQty.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        if (orgiRatio != null && !orgiRatio.isEmpty()) {
            TraceSpan ts;
            Serializable qty;
            ArrayList<DataBalanceTable.RSMapping> mappingList = new ArrayList<DataBalanceTable.RSMapping>(mapping.getChildMappings() != null ? mapping.getChildMappings().size() + 1 : 1);
            mappingList.add(mapping);
            if (mapping.getChildMappings() != null) {
                mappingList.addAll(mapping.getChildMappings());
            }
            ArrayList<DataBalanceTable.RSMapping> parentMappings = new ArrayList<DataBalanceTable.RSMapping>(4);
            int i = 0;
            for (Map.Entry<Long, BigDecimal> entry : orgiRatio.entrySet()) {
                BigDecimal mergeQty;
                DataBalanceTable.RSMapping newRsMapping;
                Long supplier = entry.getKey();
                qty = entry.getValue();
                if (i >= mappingList.size()) {
                    DataBalanceTable.RSMapping clone = QuotaAllocationUtil.createRichEmptyRequire((IMRPEnvProvider)ctx, (DataBalanceTable.RSMapping)mapping, (BigDecimal)qty, (Long)supplier, (boolean)true);
                    parentMappings.add(clone);
                    continue;
                }
                DataBalanceTable.RSMapping orgiMapping = newRsMapping = (DataBalanceTable.RSMapping)mappingList.get(i);
                parentMappings.add(orgiMapping);
                newRsMapping.setGenPlanOrder(true);
                newRsMapping.setCreateDepentRequire(true);
                newRsMapping.setrQty((BigDecimal)qty);
                LinkedList<DataBalanceTable.RSMapping> linkedList = new LinkedList<DataBalanceTable.RSMapping>();
                newRsMapping.setChildMappings(linkedList);
                while (i < mappingList.size() && ((BigDecimal)qty).compareTo(((DataBalanceTable.RSMapping)mappingList.get(i)).getBeforeMergedQty()) >= 0) {
                    newRsMapping = (DataBalanceTable.RSMapping)mappingList.get(i);
                    mergeQty = newRsMapping.getBeforeMergedQty();
                    newRsMapping.getRequire().update(DefaultField.RequireField.__QUOTA_SUPPLIER__.getName(), (Object)supplier);
                    if (newRsMapping != orgiMapping) {
                        newRsMapping.setrQty(mergeQty);
                        linkedList.add(newRsMapping);
                    }
                    qty = ((BigDecimal)qty).subtract(mergeQty);
                    ++i;
                }
                if (i >= mappingList.size()) {
                    if (((BigDecimal)qty).compareTo(BigDecimal.ZERO) <= 0) continue;
                    DataBalanceTable.RSMapping clone = QuotaAllocationUtil.createRichEmptyRequire((IMRPEnvProvider)ctx, (DataBalanceTable.RSMapping)mapping, (BigDecimal)qty, (Long)supplier, (boolean)false);
                    linkedList.add(clone);
                    continue;
                }
                newRsMapping = (DataBalanceTable.RSMapping)mappingList.get(i);
                mergeQty = newRsMapping.getBeforeMergedQty();
                if (((BigDecimal)qty).compareTo(BigDecimal.ZERO) <= 0) continue;
                DataBalanceTable.RSMapping clone = newRsMapping.clone();
                clone.setGenPlanOrder(false);
                clone.setCreateDepentRequire(false);
                clone.setBeforeMergedQty(mergeQty.subtract((BigDecimal)qty));
                ctx.calcBalanceDetails().getUnVisitedMappings().add(clone);
                newRsMapping.setBeforeMergedQty((BigDecimal)qty);
                newRsMapping.getRequire().update(DefaultField.RequireField.__QUOTA_SUPPLIER__.getName(), (Object)supplier);
                newRsMapping.setSupplys(new ArrayList(0));
                if (newRsMapping != orgiMapping) {
                    newRsMapping.setrQty((BigDecimal)qty);
                    linkedList.add(newRsMapping);
                }
                mappingList.set(i, clone);
            }
            if ("A".equals(batchpolicy) || "C".equals(batchpolicy)) {
                for (DataBalanceTable.RSMapping parent : parentMappings) {
                    ts = Tracer.create((String)"MRPDataBalanceResolver.splitOrdersByDirectLotPolicy", (String)"splitOrdersByDirectLotPolicy");
                    qty = null;
                    try {
                        MRPUtil.splitOrdersByDirectLotPolicy((IMRPEnvProvider)ctx, (DataBalanceTable.RSMapping)parent, cache);
                    }
                    catch (Throwable newRsMapping) {
                        qty = newRsMapping;
                        throw newRsMapping;
                    }
                    finally {
                        if (ts == null) continue;
                        if (qty != null) {
                            try {
                                ts.close();
                            }
                            catch (Throwable newRsMapping) {
                                ((Throwable)qty).addSuppressed(newRsMapping);
                            }
                            continue;
                        }
                        ts.close();
                    }
                }
            } else if ("B".equals(batchpolicy)) {
                for (DataBalanceTable.RSMapping parent : parentMappings) {
                    ts = Tracer.create((String)"MRPDataBalanceResolver.splitOrdersByFixedLotPolicy", (String)"splitOrdersByFixedLotPolicy");
                    qty = null;
                    try {
                        MRPUtil.splitOrdersByFixedLotPolicy((IMRPEnvProvider)ctx, (DataBalanceTable.RSMapping)parent, cache);
                    }
                    catch (Throwable newRsMapping) {
                        qty = newRsMapping;
                        throw newRsMapping;
                    }
                    finally {
                        if (ts == null) continue;
                        if (qty != null) {
                            try {
                                ts.close();
                            }
                            catch (Throwable newRsMapping) {
                                ((Throwable)qty).addSuppressed(newRsMapping);
                            }
                            continue;
                        }
                        ts.close();
                    }
                }
            }
            return;
        }
        if (orgiRatio != null) {
            this.exeBatchByPolicy(batchpolicy, mapping, cache);
            return;
        }
        BigDecimal origQty = rQty;
        ArrayList<Map<Long, BigDecimal>> sypplierList = new ArrayList<Map<Long, BigDecimal>>(2);
        int size = 0;
        ArrayList<DataBalanceTable.RSMapping> list = new ArrayList<DataBalanceTable.RSMapping>(16);
        while (!(origQty.compareTo(BigDecimal.ZERO) <= 0 || (supplierRatio = this.getSupplierRatio(require, origQty)).isEmpty() && isbatchpolicy)) {
            if (supplierRatio.isEmpty()) {
                if (QuotaAllocationUtil.isHaveChild((DataBalanceTable.RSMapping)mapping, (boolean)false)) {
                    supplierRatio.put(0L, origQty);
                } else {
                    return;
                }
            }
            for (Map.Entry<Long, BigDecimal> entry : supplierRatio.entrySet()) {
                boolean isFirst = size == 0;
                DataBalanceTable.RSMapping newRsMapping = mapping;
                if (!isFirst) {
                    newRsMapping = mapping.clone();
                    newRsMapping.setSupplys(new ArrayList());
                    ctx.calcBalanceDetails().getUnVisitedMappings().add(newRsMapping);
                }
                newRsMapping.setrQty(entry.getValue());
                newRsMapping.setCalDetail(false);
                list.add(newRsMapping);
                origQty = origQty.subtract(entry.getValue());
                ++size;
            }
            sypplierList.add(supplierRatio);
        }
        if (size > 0) {
            Long reqOrg = require.getLong(DefaultField.RequireField.PRODUCTIONORGUNIT.getName());
            long[] poIds = ID.genLongIds((int)size);
            String[] poNums = ctx.getGenBatch() <= 0 ? MRPUtil.genBatchPONum((IMRPEnvProvider)ctx, (String)String.valueOf(reqOrg), (int)size) : new String[]{};
            int idx = 0;
            for (Map map : sypplierList) {
                for (Map.Entry entry : map.entrySet()) {
                    DataBalanceTable.RSMapping newnxMapping;
                    String poNum;
                    Long supplier = (Long)entry.getKey();
                    BigDecimal qty = (BigDecimal)entry.getValue();
                    Long poId = poIds[idx];
                    String string = poNum = ctx.getGenBatch() <= 0 ? poNums[idx] : MRPUtil.genPONum((IMRPEnvProvider)ctx, (String)String.valueOf(reqOrg));
                    if (qty.compareTo(rQty) >= 0) {
                        qty = qty.subtract(rQty);
                        if (rQty.compareTo(BigDecimal.ZERO) > 0) {
                            if (QuotaAllocationUtil.isHaveChild((DataBalanceTable.RSMapping)mapping, (boolean)false)) {
                                for (DataBalanceTable.RSMapping child : mapping.getChildMappings()) {
                                    QuotaAllocationUtil.setSupplierAndOnlyDetailRSMapping((DataBalanceTable.RSMapping)child, (Long)supplier, (Long)poId, (String)poNum, (boolean)false);
                                }
                                mapping.getChildMappings().clear();
                            }
                            if (QuotaAllocationUtil.checkMergeQtyUpZero((DataBalanceTable.RSMapping)mapping)) {
                                newnxMapping = mapping.clone();
                                newnxMapping.setrQty(mapping.getBeforeMergedQty());
                                QuotaAllocationUtil.setSupplierAndOnlyDetailRSMapping((DataBalanceTable.RSMapping)newnxMapping, (Long)supplier, (Long)poId, (String)poNum, (boolean)false);
                                ctx.calcBalanceDetails().getUnVisitedMappings().add(newnxMapping);
                                mapping.setBeforeMergedQty(BigDecimal.ZERO);
                            }
                        }
                        if (qty.compareTo(BigDecimal.ZERO) > 0) {
                            DataBalanceTable.RSMapping richMapping = mapping.clone();
                            richMapping.setSupplys(new ArrayList());
                            richMapping.setChildMappings(null);
                            richMapping.setrQty(qty);
                            QuotaAllocationUtil.setSupplierRSMapping((DataBalanceTable.RSMapping)richMapping, (Long)supplier, (Long)poId, (String)poNum);
                            richMapping.getRequire().update(DefaultField.RequireField.BATCHPOLICYRICHDATE.getName(), richMapping.getRequire().getValue(DefaultField.RequireField.DATE.getName()));
                            purQuotaRich.add(richMapping);
                        }
                        rQty = BigDecimal.ZERO;
                    } else {
                        rQty = rQty.subtract(qty);
                        if (QuotaAllocationUtil.isHaveChild((DataBalanceTable.RSMapping)mapping, (boolean)true)) {
                            if (QuotaAllocationUtil.checkMergeQtyUpZero((DataBalanceTable.RSMapping)mapping) && qty.compareTo(mapping.getBeforeMergedQty()) >= 0) {
                                qty = qty.subtract(mapping.getBeforeMergedQty());
                                newnxMapping = mapping.clone();
                                newnxMapping.setrQty(mapping.getBeforeMergedQty());
                                QuotaAllocationUtil.setSupplierAndOnlyDetailRSMapping((DataBalanceTable.RSMapping)newnxMapping, (Long)supplier, (Long)poId, (String)poNum, (boolean)false);
                                ctx.calcBalanceDetails().getUnVisitedMappings().add(newnxMapping);
                                mapping.setBeforeMergedQty(BigDecimal.ZERO);
                                QuotaAllocationUtil.setSupplierChildMappings((IMRPEnvProvider)ctx, (DataBalanceTable.RSMapping)mapping, (BigDecimal)qty, (Long)supplier, (Long)poId, (String)poNum);
                            } else {
                                mapping.setBeforeMergedQty(mapping.getBeforeMergedQty().subtract(qty));
                                newnxMapping = mapping.clone();
                                newnxMapping.setrQty(qty);
                                QuotaAllocationUtil.setSupplierAndOnlyDetailRSMapping((DataBalanceTable.RSMapping)newnxMapping, (Long)supplier, (Long)poId, (String)poNum, (boolean)true);
                                ctx.calcBalanceDetails().getUnVisitedMappings().add(newnxMapping);
                            }
                        } else if (QuotaAllocationUtil.isHaveChild((DataBalanceTable.RSMapping)mapping, (boolean)false)) {
                            QuotaAllocationUtil.setSupplierChildMappings((IMRPEnvProvider)ctx, (DataBalanceTable.RSMapping)mapping, (BigDecimal)qty, (Long)supplier, (Long)poId, (String)poNum);
                        } else {
                            mapping.setBeforeMergedQty(rQty);
                            DataBalanceTable.RSMapping splitMapping = mapping.clone();
                            splitMapping.setrQty(qty);
                            QuotaAllocationUtil.setSupplierAndOnlyDetailRSMapping((DataBalanceTable.RSMapping)splitMapping, (Long)supplier, (Long)poId, (String)poNum, (boolean)true);
                            ctx.calcBalanceDetails().getUnVisitedMappings().add(splitMapping);
                        }
                    }
                    QuotaAllocationUtil.setSupplierRSMapping((DataBalanceTable.RSMapping)((DataBalanceTable.RSMapping)list.get(idx)), (Long)supplier, (Long)poId, (String)poNum);
                    ++idx;
                }
            }
        } else {
            this.exeBatchByPolicy(batchpolicy, mapping, cache);
        }
    }

    private void exeBatchByPolicy(String batchpolicy, DataBalanceTable.RSMapping mapping, Map<Integer, Boolean> cache) {
        if ("A".equals(batchpolicy) || "C".equals(batchpolicy)) {
            try (TraceSpan ts = Tracer.create((String)"MRPDataBalanceResolver.splitOrdersByDirectLotPolicy", (String)"splitOrdersByDirectLotPolicy");){
                MRPUtil.splitOrdersByDirectLotPolicy((IMRPEnvProvider)this.ctx, (DataBalanceTable.RSMapping)mapping, cache);
            }
        }
        if ("B".equals(batchpolicy)) {
            try (TraceSpan ts = Tracer.create((String)"MRPDataBalanceResolver.splitOrdersByFixedLotPolicy", (String)"splitOrdersByFixedLotPolicy");){
                MRPUtil.splitOrdersByFixedLotPolicy((IMRPEnvProvider)this.ctx, (DataBalanceTable.RSMapping)mapping, cache);
            }
        }
    }

    protected void executeCyclePurQuotaAllocation(Map<Long, List<DataBalanceTable.RSMapping>> specialMappings, Map<Long, List<DataBalanceTable.RSMapping>> dynamicMappings, Map<Long, List<DataBalanceTable.RSMapping>> fixedMappings, List<DataBalanceTable.RSMapping> purQuotaRich) {
        RequireRowData require;
        for (Map.Entry<Long, List<DataBalanceTable.RSMapping>> specialentry : specialMappings.entrySet()) {
            List<DataBalanceTable.RSMapping> specialList = specialentry.getValue();
            require = specialList.get(0).getRequire();
            long specialperiod = (Long)MRPUtil.convert((Object)require.getValue(DefaultField.RequireField.SPECIFIEDPERIOD.getName()), (Object)0L);
            this.dealPurQuotaSpecialCycles(this.ctx, specialList, specialperiod, purQuotaRich);
        }
        for (Map.Entry<Long, List<DataBalanceTable.RSMapping>> dynamicentry : dynamicMappings.entrySet()) {
            List<DataBalanceTable.RSMapping> dynamicList = dynamicentry.getValue();
            require = dynamicList.get(0).getRequire();
            int dynamicperiod = (Integer)MRPUtil.convert((Object)require.getValue(DefaultField.RequireField.DYNAMICCYCLE.getName()), (Object)0);
            this.dealPurQuotaDynamicCycles(this.ctx, dynamicList, dynamicperiod, purQuotaRich);
        }
        for (Map.Entry<Long, List<DataBalanceTable.RSMapping>> fixedEntry : fixedMappings.entrySet()) {
            List<DataBalanceTable.RSMapping> fixedList = fixedEntry.getValue();
            require = fixedList.get(0).getRequire();
            int fixedperiod = (Integer)MRPUtil.convert((Object)require.getValue(DefaultField.RequireField.FIXEDPERIOD.getName()), (Object)0);
            this.dealPurQuotaFixedCycles(this.ctx, fixedList, fixedperiod, purQuotaRich);
        }
    }

    protected void dealPurQuotaSpecialCycles(IMRPEnvProvider ctx, List<DataBalanceTable.RSMapping> mappings, long specialperiod, List<DataBalanceTable.RSMapping> purQuotaRich) {
        MRPUtil.sortRsMappingsByRequireDate(mappings);
        HashMap<Integer, Boolean> cache = new HashMap<Integer, Boolean>(mappings.size());
        List cycleList = MRPUtil.getMergeCycleVos((IMRPEnvProvider)ctx, (long)specialperiod);
        Iterator cycleIts = cycleList.iterator();
        TreeMap rsMappingMap = new TreeMap();
        MergeCycleVo cycleVo = null;
        if (!cycleList.isEmpty()) {
            cycleVo = (MergeCycleVo)cycleIts.next();
        }
        for (DataBalanceTable.RSMapping nxmapping : mappings) {
            if (nxmapping.getBeforeMergedQty() == null) {
                nxmapping.setBeforeMergedQty(nxmapping.getrQty());
            }
            Date nxDate = new Date((Long)nxmapping.getRequire().getValue(DefaultField.RequireField.__ORIGIN_DEMAND_DATE__.getName()));
            boolean isMerge = true;
            while (cycleVo != null && nxDate.compareTo(cycleVo.getEndDate()) > 0) {
                if (cycleIts.hasNext()) {
                    cycleVo = (MergeCycleVo)cycleIts.next();
                    continue;
                }
                QuotaAllocationUtil.mergeCycleRsMapping((IMRPEnvProvider)ctx, (Date)nxDate, rsMappingMap, (DataBalanceTable.RSMapping)nxmapping, cache);
                isMerge = false;
                break;
            }
            if (!isMerge) continue;
            if (cycleVo != null && nxDate.compareTo(cycleVo.getStartDate()) >= 0 && nxDate.compareTo(cycleVo.getEndDate()) <= 0) {
                QuotaAllocationUtil.mergeCycleRsMapping((IMRPEnvProvider)ctx, (Date)cycleVo.getMergeDate(), rsMappingMap, (DataBalanceTable.RSMapping)nxmapping, cache);
                continue;
            }
            QuotaAllocationUtil.mergeCycleRsMapping((IMRPEnvProvider)ctx, (Date)nxDate, rsMappingMap, (DataBalanceTable.RSMapping)nxmapping, cache);
        }
        PlanModel planModel = (PlanModel)ctx.getService(PlanModel.class);
        boolean isbatchpolicy = (Boolean)planModel.getPlanDataByParam("isbatchpolicy", (Object)true);
        for (Map.Entry rsMappingListEntry : rsMappingMap.entrySet()) {
            for (DataBalanceTable.RSMapping rsMapping : (List)rsMappingListEntry.getValue()) {
                Map<Long, BigDecimal> supplierRatio = null;
                if (isbatchpolicy) {
                    BigDecimal rQty = QuotaAllocationUtil.richMappingSupply((IMRPEnvProvider)ctx, (DataBalanceTable.RSMapping)rsMapping, purQuotaRich, cache);
                    supplierRatio = this.getSupplierRatio(rsMapping.getRequire(), rQty);
                    rsMapping.setrQty(rQty);
                }
                this.executePurQuotaAllocation(ctx, rsMapping, purQuotaRich, cache, supplierRatio);
            }
        }
    }

    protected void dealPurQuotaDynamicCycles(IMRPEnvProvider ctx, List<DataBalanceTable.RSMapping> mappings, int dynamicperiod, List<DataBalanceTable.RSMapping> purQuotaRich) {
        MRPUtil.sortRsMappingsByRequireDate(mappings);
        HashMap<Integer, Boolean> cache = new HashMap<Integer, Boolean>(mappings.size());
        TreeMap rsMappingMap = new TreeMap();
        ArrayList dynamicCycleVos = new ArrayList(dynamicperiod);
        for (DataBalanceTable.RSMapping nxMapping : mappings) {
            if (nxMapping.getBeforeMergedQty() == null) {
                nxMapping.setBeforeMergedQty(nxMapping.getrQty());
            }
            Date nxDate = new Date((Long)nxMapping.getRequire().getValue(DefaultField.RequireField.__ORIGIN_DEMAND_DATE__.getName()));
            if (dynamicCycleVos.isEmpty()) {
                QuotaAllocationUtil.addNewDynamicVo((Date)nxDate, rsMappingMap, dynamicCycleVos, (DataBalanceTable.RSMapping)nxMapping);
                continue;
            }
            boolean isMatch = false;
            for (DynamicCycleVo dynamicCycleVo : dynamicCycleVos) {
                DataBalanceTable.RSMapping dsMapping = dynamicCycleVo.getRsMapping();
                Date mergeDate = new Date((Long)dsMapping.getRequire().getValue(DefaultField.RequireField.__ORIGIN_DEMAND_DATE__.getName()));
                if (dynamicCycleVo.getCount() >= dynamicperiod && mergeDate.compareTo(nxDate) != 0 || !QuotaAllocationUtil.requireMatch((IMRPEnvProvider)ctx, (DataBalanceTable.RSMapping)dsMapping, (DataBalanceTable.RSMapping)nxMapping, cache)) continue;
                if (mergeDate.compareTo(nxDate) != 0) {
                    dynamicCycleVo.setCount(dynamicCycleVo.getCount() + 1);
                }
                nxMapping.getRequire().update(DefaultField.RequireField.DATE.getName(), (Object)mergeDate.getTime());
                isMatch = true;
                break;
            }
            if (isMatch) continue;
            QuotaAllocationUtil.addNewDynamicVo((Date)nxDate, rsMappingMap, dynamicCycleVos, (DataBalanceTable.RSMapping)nxMapping);
        }
        PlanModel planModel = (PlanModel)ctx.getService(PlanModel.class);
        boolean isbatchpolicy = (Boolean)planModel.getPlanDataByParam("isbatchpolicy", (Object)true);
        for (Map.Entry rsMappingListEntry : rsMappingMap.entrySet()) {
            for (DataBalanceTable.RSMapping rsMapping : (List)rsMappingListEntry.getValue()) {
                Map<Long, BigDecimal> supplierRatio = null;
                if (isbatchpolicy) {
                    BigDecimal rQty = QuotaAllocationUtil.richMappingSupply((IMRPEnvProvider)ctx, (DataBalanceTable.RSMapping)rsMapping, purQuotaRich, cache);
                    supplierRatio = this.getSupplierRatio(rsMapping.getRequire(), rQty);
                    rsMapping.setrQty(rQty);
                }
                this.executePurQuotaAllocation(ctx, rsMapping, purQuotaRich, cache, supplierRatio);
            }
        }
    }

    protected void dealPurQuotaFixedCycles(IMRPEnvProvider ctx, List<DataBalanceTable.RSMapping> mappings, int fixedperiod, List<DataBalanceTable.RSMapping> purQuotaRich) {
        MRPUtil.sortRsMappingsByRequireDate(mappings);
        HashMap<Integer, Boolean> cache = new HashMap<Integer, Boolean>(mappings.size());
        TreeMap rsMappingMap = new TreeMap();
        Date startdate = null;
        Date nxdate = null;
        Date endDate = null;
        for (DataBalanceTable.RSMapping nxmapping : mappings) {
            if (nxmapping.getBeforeMergedQty() == null) {
                nxmapping.setBeforeMergedQty(nxmapping.getrQty());
            }
            if (startdate == null) {
                startdate = new Date((Long)nxmapping.getRequire().getValue(DefaultField.RequireField.__ORIGIN_DEMAND_DATE__.getName()));
            }
            nxdate = new Date((Long)nxmapping.getRequire().getValue(DefaultField.RequireField.__ORIGIN_DEMAND_DATE__.getName()));
            endDate = MRPUtil.addDays((Date)startdate, (int)fixedperiod);
            while (nxdate.compareTo(endDate) >= 0) {
                startdate = MRPUtil.addDays((Date)startdate, (int)fixedperiod);
                endDate = MRPUtil.addDays((Date)startdate, (int)fixedperiod);
            }
            if (nxdate.compareTo(startdate) >= 0 && nxdate.compareTo(endDate) <= 0) {
                QuotaAllocationUtil.mergeCycleRsMapping((IMRPEnvProvider)ctx, (Date)startdate, rsMappingMap, (DataBalanceTable.RSMapping)nxmapping, cache);
                continue;
            }
            QuotaAllocationUtil.mergeCycleRsMapping((IMRPEnvProvider)ctx, (Date)nxdate, rsMappingMap, (DataBalanceTable.RSMapping)nxmapping, cache);
        }
        PlanModel planModel = (PlanModel)ctx.getService(PlanModel.class);
        boolean isbatchpolicy = (Boolean)planModel.getPlanDataByParam("isbatchpolicy", (Object)true);
        for (Map.Entry rsMappingListEntry : rsMappingMap.entrySet()) {
            for (DataBalanceTable.RSMapping rsMapping : (List)rsMappingListEntry.getValue()) {
                Map<Long, BigDecimal> supplierRatio = null;
                if (isbatchpolicy) {
                    BigDecimal rQty = QuotaAllocationUtil.richMappingSupply((IMRPEnvProvider)ctx, (DataBalanceTable.RSMapping)rsMapping, purQuotaRich, cache);
                    supplierRatio = this.getSupplierRatio(rsMapping.getRequire(), rQty);
                    rsMapping.setrQty(rQty);
                }
                this.executePurQuotaAllocation(ctx, rsMapping, purQuotaRich, cache, supplierRatio);
            }
        }
    }

    private void initCycleMappings(Map<Long, List<DataBalanceTable.RSMapping>> specialMappings, Map<Long, List<DataBalanceTable.RSMapping>> dynamicMappings, Map<Long, List<DataBalanceTable.RSMapping>> fixedMappings, DataBalanceTable.RSMapping mapping) {
        RequireRowData require = mapping.getRequire();
        Integer fixedperiod = (Integer)MRPUtil.convert((Object)require.getValue(DefaultField.RequireField.FIXEDPERIOD.getName()), (Object)0);
        Integer dynamicperiod = (Integer)MRPUtil.convert((Object)require.getValue(DefaultField.RequireField.DYNAMICCYCLE.getName()), (Object)0);
        Long specialperiod = (Long)MRPUtil.convert((Object)require.getValue(DefaultField.RequireField.SPECIFIEDPERIOD.getName()), (Object)0L);
        Long materialPlanId = (Long)MRPUtil.convert((Object)require.getValue(DefaultField.RequireField.__MATERIALPLAN__.getName()), (Object)0L);
        if (materialPlanId != null && materialPlanId > 0L) {
            if (fixedperiod > 0) {
                this.addRSMapping(fixedMappings, materialPlanId, mapping);
            } else if (dynamicperiod > 0) {
                this.addRSMapping(dynamicMappings, materialPlanId, mapping);
            } else if (specialperiod > 0L) {
                this.addRSMapping(specialMappings, materialPlanId, mapping);
            }
        }
    }

    private void executeCycleBatch(Map<Long, List<DataBalanceTable.RSMapping>> specialMappings, Map<Long, List<DataBalanceTable.RSMapping>> dynamicMappings, Map<Long, List<DataBalanceTable.RSMapping>> fixedMappings) {
        RequireRowData require;
        for (Map.Entry<Long, List<DataBalanceTable.RSMapping>> specialentry : specialMappings.entrySet()) {
            List<DataBalanceTable.RSMapping> specialList = specialentry.getValue();
            require = specialList.get(0).getRequire();
            long specialperiod = require.getLong(DefaultField.RequireField.SPECIFIEDPERIOD.getName()) == null ? 0L : require.getLong(DefaultField.RequireField.SPECIFIEDPERIOD.getName());
            MRPUtil.dealSpecialCycles((IMRPEnvProvider)this.ctx, specialList, (long)specialperiod);
        }
        for (Map.Entry<Long, List<DataBalanceTable.RSMapping>> dynamicentry : dynamicMappings.entrySet()) {
            List<DataBalanceTable.RSMapping> dynamicList = dynamicentry.getValue();
            require = dynamicList.get(0).getRequire();
            Integer dynamicperiod = require.getInteger(DefaultField.RequireField.DYNAMICCYCLE.getName()) == null ? Integer.valueOf(0) : require.getInteger(DefaultField.RequireField.DYNAMICCYCLE.getName());
            MRPUtil.dealDynamicCycles((IMRPEnvProvider)this.ctx, dynamicList, (Integer)dynamicperiod);
        }
        for (Map.Entry<Long, List<DataBalanceTable.RSMapping>> fixedEntry : fixedMappings.entrySet()) {
            List<DataBalanceTable.RSMapping> fixedList = fixedEntry.getValue();
            require = fixedList.get(0).getRequire();
            Integer fixedperiod = require.getInteger(DefaultField.RequireField.FIXEDPERIOD.getName()) == null ? Integer.valueOf(0) : require.getInteger(DefaultField.RequireField.FIXEDPERIOD.getName());
            TraceSpan ts = Tracer.create((String)"MRPDataBalanceResolver.executeCycleBatch-dealFixedCycles", (String)"executeCycleBatch-dealFixedCycles");
            Throwable throwable = null;
            try {
                MRPUtil.dealFixedCycles((IMRPEnvProvider)this.ctx, fixedList, (Integer)fixedperiod);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ts == null) continue;
                if (throwable != null) {
                    try {
                        ts.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ts.close();
            }
        }
    }

    private void addRSMapping(Map<Long, List<DataBalanceTable.RSMapping>> map, long materialPlanId, DataBalanceTable.RSMapping mapping) {
        if (map.get(materialPlanId) == null) {
            LinkedList<DataBalanceTable.RSMapping> mappingList = new LinkedList<DataBalanceTable.RSMapping>();
            mappingList.add(mapping);
            map.put(materialPlanId, mappingList);
        } else {
            List<DataBalanceTable.RSMapping> mappingList = map.get(materialPlanId);
            mappingList.add(mapping);
        }
    }

    protected void saveDatas() {
        long start = System.currentTimeMillis();
        MultiThreadCacheManager.setCacheData((MultiThreadCacheKey)MultiThreadCacheKey.KEY_MAPPING_START_IDX, (Object)0);
        this.requireTbl.clear();
        start = System.currentTimeMillis();
        try (TraceSpan ts = Tracer.create((String)"MRPDataBalanceResolver.executeBatchpolicy", (String)"executeBatchpolicy");){
            this.executeBatchpolicy();
        }
        if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG)) || System.currentTimeMillis() - start > 10000L) {
            logger.warn(String.format("ctxid: %s, mrprunner-executeBatchpolicy llc: %s, mid: %s, timecost: %s(ms), rCnt: %s, sCnt: %s, RSMappingSize: %s", this.ctx.getMRPContextId(), this.llc, this.materialId, System.currentTimeMillis() - start, this.requireCount, this.supplyCount, this.ctx.calcBalanceDetails().getUnVisitedSize()));
        }
        start = System.currentTimeMillis();
        ts = Tracer.create((String)"MRPDataBalanceResolver.executeInventoryPlan", (String)"executeInventoryPlan");
        var4_3 = null;
        try {
            this.executeInventoryPlan();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (ts != null) {
                if (var4_3 != null) {
                    try {
                        ts.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    ts.close();
                }
            }
        }
        MultiThreadCacheManager.setCacheData((MultiThreadCacheKey)MultiThreadCacheKey.KEY_MAPPING_END_IDX, (Object)this.ctx.calcBalanceDetails().getUnVisitedMappings().size());
        ts = Tracer.create((String)"MRPDataBalanceResolver.executeDependentCalcStep", (String)"executeDependentCalcStep");
        var4_3 = null;
        try {
            this.executeDependentCalcStep();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (ts != null) {
                if (var4_3 != null) {
                    try {
                        ts.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    ts.close();
                }
            }
        }
        this.dependentCount = this.requireTbl.size();
        if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("ctxid: %s, mrprunner-executeDependentCalcStep llc: %s, mid: %s, timecost: %s(ms)", this.ctx.getMRPContextId(), this.llc, this.materialId, System.currentTimeMillis() - start));
        }
        start = System.currentTimeMillis();
        if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("ctxid: %s, mrprunner-MRPReplaceStep llc: %s, mid: %s, timecost: %s(ms)", this.ctx.getMRPContextId(), this.llc, this.materialId, System.currentTimeMillis() - start));
        }
        start = System.currentTimeMillis();
        ts = Tracer.create((String)"MRPDataBalanceResolver.executePlanOrderStep", (String)"executePlanOrderStep");
        var4_3 = null;
        try {
            this.executePlanOrderStep();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (ts != null) {
                if (var4_3 != null) {
                    try {
                        ts.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    ts.close();
                }
            }
        }
        if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("ctxid: %s, mrprunner-executePlanOrderStep llc: %s, mid: %s, timecost: %s(ms)", this.ctx.getMRPContextId(), this.llc, this.materialId, System.currentTimeMillis() - start));
        }
        start = System.currentTimeMillis();
        if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("ctxid: %s, mrprunner-pocount llc: %s, mid: %s, count: %s", this.ctx.getMRPContextId(), this.llc, this.materialId, this.result.getDataAmount()));
        }
        if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("ctxid: %s, mrprunner-cachePO llc: %s, mid: %s, timecost: %s(ms)", this.ctx.getMRPContextId(), this.llc, this.materialId, System.currentTimeMillis() - start));
        }
        start = System.currentTimeMillis();
        LinkedList<Map<String, Object>> details = new LinkedList<Map<String, Object>>();
        try (TraceSpan ts = Tracer.create((String)"MRPDataBalanceResolver.saveRSMappings", (String)"saveRSMappings");){
            this.saveRSMappings(details);
        }
        if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("ctxid: %s, mrprunner-saveRSMappings llc: %s, mid: %s, timecost: %s(ms)", this.ctx.getMRPContextId(), this.llc, this.materialId, System.currentTimeMillis() - start));
        }
        start = System.currentTimeMillis();
        List<RowData> cops = this.cancelSupplys(details);
        if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("ctxid: %s, mrprunner-cancelSupplys llc: %s, mid: %s, timecost: %s(ms)", this.ctx.getMRPContextId(), this.llc, this.materialId, System.currentTimeMillis() - start));
        }
        start = System.currentTimeMillis();
        try (TraceSpan ts = Tracer.create((String)"MRPDataBalanceResolver.putMaterialDetails", (String)"putMaterialDetails");){
            this.putMaterialDetails(details);
        }
        this.saveReserveCache();
        this.event.setParam(MultiThreadCacheKey.KEY_DETAILS, (Serializable)((Object)JSON.toJSONString((Object)new int[]{this.requireCount, this.supplyCount, this.detailCnt, this.dependentCount}, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect})));
        if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("ctxid: %s, mrprunner-cacheDetails llc: %s, mid: %s, timecost: %s(ms)", this.ctx.getMRPContextId(), this.llc, this.materialId, System.currentTimeMillis() - start));
        }
        start = System.currentTimeMillis();
        this.ctx.calcBalanceDetails().clear();
        ts = Tracer.create((String)"MRPDataBalanceResolver.refreshDependentRequires", (String)"refreshDependentRequires");
        var6_16 = null;
        try {
            this.refreshDependentRequires();
        }
        catch (Throwable throwable) {
            var6_16 = throwable;
            throw throwable;
        }
        finally {
            if (ts != null) {
                if (var6_16 != null) {
                    try {
                        ts.close();
                    }
                    catch (Throwable throwable) {
                        var6_16.addSuppressed(throwable);
                    }
                } else {
                    ts.close();
                }
            }
        }
        ts = Tracer.create((String)"MRPDataBalanceResolver.refreshCopSupplys", (String)"refreshCopSupplys");
        var6_16 = null;
        try {
            this.refreshCopSupplys(cops);
        }
        catch (Throwable throwable) {
            var6_16 = throwable;
            throw throwable;
        }
        finally {
            if (ts != null) {
                if (var6_16 != null) {
                    try {
                        ts.close();
                    }
                    catch (Throwable throwable) {
                        var6_16.addSuppressed(throwable);
                    }
                } else {
                    ts.close();
                }
            }
        }
        if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("ctxid: %s, mrprunner-refreshDependentRequires llc: %s, mid: %s, timecost: %s(ms)", this.ctx.getMRPContextId(), this.llc, this.materialId, System.currentTimeMillis() - start));
        }
        CacheDatas cacheDatas = (CacheDatas)this.ctx.getService(CacheDatas.class);
        RequireDataModel requireDataModel = (RequireDataModel)this.ctx.getService(RequireDataModel.class);
        if (cacheDatas.isSelectBillPlan()) {
            if (!requireDataModel.getSelectPlanDeleteOrderIds().isEmpty()) {
                MRPCacheManager.getInst().putData((CalEnv)this.ctx, MRPRuntimeConsts.getSelectPlanDeleteOrderIdsKey((String)this.ctx.getMRPContextId(), (String)this.materialId), JSON.toJSONString((Object)requireDataModel.getSelectPlanDeleteOrderIds(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
            }
            if (!requireDataModel.getSelectPlanDeleteCollIds().isEmpty()) {
                MRPCacheManager.getInst().putData((CalEnv)this.ctx, MRPRuntimeConsts.getSelectPlanDeleteCollIdsKey((String)this.ctx.getMRPContextId(), (String)this.materialId), JSON.toJSONString((Object)requireDataModel.getSelectPlanDeleteCollIds(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
            }
            requireDataModel.getSelectPlanDeleteCollIds().clear();
            requireDataModel.getSelectPlanDeleteOrderIds().clear();
        }
        if (this.isDynamicBOM) {
            this.bomTbl.clear();
        }
    }

    protected void saveReserveCache() {
        for (Map.Entry entry : this.ctx.getReserveCacheData().entrySet()) {
            MRPCacheManager.getInst().setReserveCache((CalEnv)this.ctx, (String)entry.getKey(), (List)entry.getValue());
            MRPCacheManager.getInst().putData((CalEnv)this.ctx, MRPRuntimeConsts.getReserveSplitKey((String)this.ctx.getMRPContextId(), (String)((String)entry.getKey())), String.valueOf(((List)entry.getValue()).size()));
        }
        for (Map.Entry entry : this.ctx.getRemovePlanOrders().entrySet()) {
            MRPCacheManager.getInst().putSubData((CalEnv)this.ctx, "reserve_record_po_removee", MRPRuntimeConsts.getMaterialKey4ReserveRemovePo((String)this.ctx.getMRPContextId(), (String)((String)entry.getKey())), JSON.toJSONString(entry.getValue()));
        }
        PlanModel planModel = (PlanModel)this.ctx.getService(PlanModel.class);
        boolean isReserve = planModel.isReserve();
        String ocpWeakReserve = planModel.getOcpWeakReserve();
        isReserve = isReserve && StringUtils.equalsIgnoreCase((CharSequence)ocpWeakReserve, (CharSequence)"1");
        Map reserveDatas = this.supplyTbl.getReserveDatas();
        Map r2Row = this.supplyTbl.getR2Row();
        Map s2Col = this.supplyTbl.getS2Col();
        if (isReserve && reserveDatas != null) {
            for (Map.Entry row : r2Row.entrySet()) {
                for (Map.Entry col : s2Col.entrySet()) {
                    ReserveData reserveData = (ReserveData)reserveDatas.get(String.valueOf(row.getValue()) + '-' + String.valueOf(col.getValue()));
                    BigDecimal useWeakQty = reserveData == null ? BigDecimal.ZERO : reserveData.getOrigWeakReserveQty().subtract(reserveData.getWeakReserveQty());
                    if (useWeakQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                    String cacheKey = MRPRuntimeConsts.getMetaDynamicInfoKey((String)this.ctx.getMRPContextId(), (String)String.format("%s\u0001%s", row.getKey(), col.getKey()));
                    MRPCacheManager.getInst().putSubData((CalEnv)this.ctx, "reserve_record", cacheKey, useWeakQty.toPlainString());
                }
            }
        }
    }

    protected void executeInventoryPlan() {
        Boolean cfgValue = (Boolean)this.ctx.getCfgValue(EnvCfgItem.INV_LEVEL_CALC);
        if (cfgValue.booleanValue()) {
            new MRPInventoryPlanStep(this.ctx).execute();
        }
    }

    protected void putMaterialDetails(List<Map<String, Object>> details) {
        String detailSaveMode = (String)this.ctx.getCfgValue(EnvCfgItem.DETAIL_SAVING_MODE);
        if ("BY_SPLIT".equals(detailSaveMode)) {
            int batch = this.getDetailSaveBatch();
            if (!details.isEmpty()) {
                MRPCacheManager.getInst().setMaterialDetails2((CalEnv)this.ctx, this.materialId, details, batch, this.savedBatchCnt++);
            }
            MRPCacheManager.getInst().putData((CalEnv)this.ctx, MRPRuntimeConsts.getBalanceSplitKey((String)this.ctx.getMRPContextId(), (String)this.materialId), String.valueOf(this.detailCnt));
        } else {
            HashMap<String, List> detailMap = new HashMap<String, List>(1);
            for (Map<String, Object> map : details) {
                String material = String.valueOf(map.get("material"));
                List ds = detailMap.computeIfAbsent(material, k -> new ArrayList(16));
                ds.add(map);
            }
            for (Map.Entry entry : detailMap.entrySet()) {
                MRPCacheManager.getInst().setMaterialDetails((CalEnv)this.ctx, (String)entry.getKey(), (List)entry.getValue());
                MRPCacheManager.getInst().putData((CalEnv)this.ctx, MRPRuntimeConsts.getBalanceSplitKey((String)this.ctx.getMRPContextId(), (String)((String)entry.getKey())), String.valueOf(((List)entry.getValue()).size()));
            }
        }
    }

    protected void executeSafeInvRequireAdvanceStep() {
        new MRPMSafeInvResolveStep(this.ctx).execute();
    }

    protected void executeDependentCalcStep() {
        new MRPMDependentReqStep(this.ctx).execute();
    }

    protected MRPDataBalanceResult executeBalanceStep() {
        boolean isReplaceBalance = this.groupMIds != null && !this.groupMIds.isEmpty() && !this.bomTbl.isDependReplaceGroup(this.materialId) || !this.invPlanKey2Require.isEmpty();
        return (MRPDataBalanceResult)new MRPMDataBalanceStep(this.ctx, isReplaceBalance).execute();
    }

    protected PlanOrderCreateResult executePlanOrderStep() {
        this.result = (PlanOrderCreateResult)new MRPMCreatePlanOrder(this.ctx).execute();
        return this.result;
    }

    protected Long getSupplyKey(RowData supply) {
        Long bill_id = (Long)MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.BILLID.getName()), (Object)0L);
        Long billentry_id = (Long)MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.BILLENTRYID.getName()), (Object)0L);
        return billentry_id > 0L ? billentry_id : bill_id;
    }

    protected void saveRSMappings(List<Map<String, Object>> details) {
        CacheDatas cacheDatas = (CacheDatas)this.ctx.getService(CacheDatas.class);
        RequireDataModel requireDataModel = (RequireDataModel)this.ctx.getService(RequireDataModel.class);
        boolean isSelectBillPlan = cacheDatas.isSelectBillPlan();
        for (DataBalanceTable.RSMapping mapping : this.ctx.calcBalanceDetails().getMappings()) {
            HashMap<String, Object> entry;
            if (!mapping.isCalDetail()) continue;
            RequireRowData require = mapping.getRequire();
            List supplys = mapping.getSupplys();
            boolean isInvLevel = MRPUtil.convert((Object)require.getValue(DefaultField.RequireField.__INVLEVEL_REQUIRE__.getName()), (Boolean)Boolean.FALSE);
            boolean is_inv_water_level = MRPUtil.convert((Object)require.getValue(DefaultField.RequireField.IS_INV_WATER_LEVEL.getName()), (Boolean)Boolean.FALSE);
            if (isInvLevel) {
                InvPlanUtil.updateInvRequireFields((IMRPEnvProvider)this.ctx, (RequireRowData)require, (Object)require.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()), (Object)require.getValue(DefaultField.RequireField.MATERIAL.getName()));
            }
            int mAttr = (Integer)MRPUtil.convert((Object)require.getValue(DefaultField.RequireField.MATERIALATTR.getName()), (Object)MaterialAttribute.OTHER.getValue());
            if (BillSupplyStrategy.INVENTORY.getValue().equals(require.getString(DefaultField.RequireField.DEMAND_SUPPLY_STRATEGY.getName()))) {
                mAttr = MaterialAttribute.STORAGEPART.getValue();
            }
            if (mapping.getPoList() != null) {
                BigDecimal virtualQty = mapping.getVirtualQty();
                for (SimplePlanOrder spo : mapping.getPoList()) {
                    Long date;
                    entry = new HashMap<String, Object>();
                    BigDecimal rQty = spo.getQty() == null ? mapping.getrQty() : spo.getQty();
                    String exceptionMsg = spo.getExceptionMsg();
                    String exceptionNumber = spo.getExceptionNumber();
                    entry.put("materialattr", mAttr);
                    entry.put("material", require.getValue(DefaultField.RequireField.MATERIAL.getName()));
                    entry.put("configuredcode", require.getValue(DefaultField.RequireField.CONFIGUREDCODE.getName()));
                    entry.put("tracknumber", require.getValue(DefaultField.RequireField.TRACKNUMBER.getName()));
                    Object supplyAuxpty = require.getLong(DefaultField.RequireField.SUPPLY_MATERIALFLEXPROPS.getName());
                    Object object = supplyAuxpty = supplyAuxpty == null ? spo.getAuxProperty() : supplyAuxpty;
                    if (supplyAuxpty != null) {
                        entry.put("supplyauxpty", supplyAuxpty);
                    }
                    if (isInvLevel || is_inv_water_level) {
                        exceptionMsg = MRPUtil.appendExceptionMsg((Object)exceptionMsg, (String)ResManager.loadKDString((String)"\u5e93\u5b58\u6c34\u4f4d\u5360\u7528\u3002", (String)"MRPDataBalanceResolver_2", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0]));
                        exceptionNumber = MRPUtil.appendExceptionNumber((Object)exceptionNumber, (String)"98");
                    }
                    String poNum = this.getPoNum(spo, mAttr);
                    String key = String.format("%s\u0001%s", requireDataModel.getOutputType(), poNum);
                    if (this.ctx.getPoNum2InvRequireQty().get(key) != null && isInvLevel) {
                        require.update(DefaultField.RequireField.__INV_PO_QTY__.getName(), this.ctx.getPoNum2InvRequireQty().get(key));
                    }
                    if (BigDecimal.ZERO.compareTo(rQty = DataBalanceUtil.getDetailQty((BigDecimal)rQty, (BigDecimal)virtualQty, (RequireRowData)require)) >= 0) continue;
                    Long supplyDate = spo.getSupplyDate();
                    if (supplyDate == null && require.getValue(DefaultField.RequireField.BATCHPOLICYRICHDATE.getName()) != null) {
                        supplyDate = (Long)MRPUtil.convert((Object)require.getValue(DefaultField.RequireField.BATCHPOLICYRICHDATE.getName()), (Object)0L);
                    }
                    Long l = date = supplyDate == null ? (Long)require.getValue(DefaultField.RequireField.DATE.getName()) : supplyDate;
                    if (!mapping.isClearRequire()) {
                        this.putRequireDetail(this.ctx, entry, require, mapping.isExceptionData(), this.llc);
                        entry.put("demandqty", rQty);
                        if (MRPUtil.isNeedReserve((CalEnv)this.ctx, (RequireRowData)require)) {
                            if (this.isRemovePO(this.ctx, String.valueOf(require.getValue(DefaultField.RequireField.__PLAN_TAG__.getName())))) {
                                String billKey = String.format("%s-%s", this.outputType, spo.getId());
                                Set removePo = this.ctx.getRemovePlanOrders().computeIfAbsent(String.valueOf(require.getValue(DefaultField.RequireField.MATERIAL.getName())), k -> new HashSet(16));
                                removePo.add(billKey);
                            } else {
                                spo.setNumber(poNum);
                                spo.setSupplyDate(date);
                                spo.setQty(rQty);
                                this.addReserveCacheData(this.ctx, spo, require, this.outputType);
                            }
                        }
                    } else {
                        entry.put("top_require_date", require.getValue(DefaultField.RequireField.TOP_REQUIRE_DATE.getName()));
                    }
                    this.updateDetailBomId(poNum, entry);
                    String bt = this.ctx.getRelatedSupplyBillType(mAttr);
                    entry.put("supplybilltype", bt == null ? ResManager.loadKDString((String)"\u65b0\u5efa\u8ba1\u5212\u8ba2\u5355", (String)"MRPDataBalanceResolver_3", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0]) : bt);
                    entry.put("supmaterial", require.getValue(DefaultField.RequireField.MATERIAL.getName()));
                    entry.put("supplybillf7", this.outputType);
                    entry.put("supplyqty", rQty);
                    entry.put("originsupplyqty", rQty);
                    entry.put("supplydate", date);
                    entry.put("adjustsuggest", BillAdjustStrategy.NONE.getAlias());
                    entry.put("supplybillentryseq", 0);
                    entry.put("supplyorg", spo.getProductOrgUnit());
                    entry.put("supplybillid", spo.getId());
                    entry.put("supplybillno", poNum);
                    entry.put("sexpmsg", exceptionMsg);
                    entry.put("sexpnumber", exceptionNumber);
                    entry.put("supplyoperator", require.getValue(DefaultField.RequireField.REQUIREOPERAOTR.getName()));
                    entry.put("supplantag", MRPDataBalanceResolver.setPlanTag(this.ctx, require.getValue(DefaultField.RequireField.__PLAN_TAG__.getName())));
                    if (spo.getAdjustFlag() != null) {
                        entry.put("adjustqty", spo.getQty());
                        entry.put("adjustdate", spo.getAdjustDate());
                        entry.put("adjustsuggest", BillAdjustStrategy.parseInt((int)spo.getAdjustFlag()).getAlias());
                        entry.put("supplydate", spo.getAdjustDate());
                    }
                    entry.put("eventid", this.event.getEventId());
                    entry.put("resolverip", AbstractMRPRunner.getIP());
                    Long supply_tracknumber = require.getLong(DefaultField.RequireField.SUPPLY_TRACKNUMBER.getName());
                    Object isTrackMatch = require.getValue(DefaultField.RequireField.IS_TRACK_MATCH.getName());
                    if (MRPUtil.convert((Object)isTrackMatch, (Boolean)Boolean.FALSE).booleanValue()) {
                        entry.put("suptracknumber", supply_tracknumber != null ? supply_tracknumber : spo.getTrackNumber());
                    }
                    entry.put("supplyproject", spo.getProject());
                    entry.put("supplysupplier", spo.getSupplier());
                    entry.put("supplyplanscope", spo.getPlanScope());
                    if (!entry.containsKey("ismerge")) {
                        entry.put("ismerge", 0);
                    }
                    this.addDetails(details, entry);
                }
            }
            if (supplys != null) {
                BigDecimal rQty = (BigDecimal)MRPUtil.convert((Object)require.getValue(DefaultField.RequireField.__SUPPLY_QTY__.getName()), (Object)BigDecimal.ZERO);
                for (RowData supply : supplys) {
                    entry = new HashMap();
                    entry.put("materialattr", mAttr);
                    String key = String.valueOf(supply.getValue(DefaultField.SupplyField.MATERIAL.getName())) + '\u0001' + String.valueOf(supply.getValue(DefaultField.SupplyField.SUPPLYORGUNIT.getName()));
                    this.midAndOrg2mAttr.putIfAbsent(key, mAttr);
                    if (this.ctx.getCustomParams("simulationbillid") != null) {
                        this.calcOrderDate(require, supply);
                    }
                    if (isInvLevel || is_inv_water_level) {
                        this.markInvLevelRequireOccupySupply(supply);
                    }
                    boolean isNewCreateBill = InvPlanUtil.isNewCreateSupplyBill((IMRPEnvProvider)this.ctx, (RowData)supply);
                    BigDecimal sQty = (BigDecimal)MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.QTY.getName()), (Object)BigDecimal.ZERO);
                    if (rQty.compareTo(sQty) >= 0) {
                        rQty = rQty.subtract(sQty);
                    } else {
                        sQty = rQty;
                    }
                    String invBillKey = String.format("%s\u0001%s", supply.getString(DefaultField.SupplyField.BILL_ENTITY.getName()), supply.getString(DefaultField.SupplyField.BILLNUMBER.getName()));
                    if (isInvLevel && this.ctx.getPoNum2InvRequireQty().get(invBillKey) != null) {
                        sQty = (BigDecimal)this.ctx.getPoNum2InvRequireQty().get(invBillKey);
                        supply.update(DefaultField.SupplyField.QTY.getName(), (Object)sQty);
                        if (sQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                    }
                    if (!isInvLevel && !is_inv_water_level || isNewCreateBill) {
                        this.putRequireDetail(this.ctx, entry, require, mapping.isExceptionData(), this.llc);
                        entry.put("demandqty", sQty);
                    } else {
                        entry.put("demandqty", BigDecimal.ZERO);
                    }
                    if (sQty.compareTo(BigDecimal.ZERO) == 0 && "1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                        logger.warn(String.format("mrprunner-save-detail-require: %s", require));
                        logger.warn(String.format("mrprunner-save-detail-supply: %s", supply));
                    }
                    if (isNewCreateBill) {
                        this.updateDetailBomId(supply.getString(DefaultField.SupplyField.BILLNUMBER.getName()), entry);
                    }
                    entry.put("material", require.getValue(DefaultField.RequireField.MATERIAL.getName()));
                    this.putSupplyDetail(this.ctx, entry, supply, this.llc);
                    entry.put("eventid", this.event.getEventId());
                    entry.put("resolverip", AbstractMRPRunner.getIP());
                    if (!entry.containsKey("ismerge")) {
                        entry.put("ismerge", 0);
                    }
                    this.addDetails(details, entry);
                    if (!isSelectBillPlan) continue;
                    Map billIdQtys = this.mid2billIdQtys.computeIfAbsent(String.valueOf(supply.getValue(DefaultField.SupplyField.MATERIAL.getName())), k -> new HashMap(16));
                    Long supplyKey = this.getSupplyKey(supply);
                    BigDecimal qty = billIdQtys.getOrDefault(supplyKey, BigDecimal.ZERO);
                    qty = qty.add((BigDecimal)MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.QTY.getName()), (Object)BigDecimal.ZERO));
                    billIdQtys.put(supplyKey, qty);
                }
            }
            if (mapping.getPoList() != null && !mapping.getPoList().isEmpty() || supplys != null && !supplys.isEmpty()) continue;
            HashMap<String, Object> entry2 = new HashMap<String, Object>();
            entry2.put("materialattr", mAttr);
            this.putRequireDetail(this.ctx, entry2, require, mapping.isExceptionData(), this.llc);
            Object isMergeReq = require.getValue(DefaultField.RequireField.__IS_MERGE_.getName());
            if (isMergeReq == Boolean.TRUE) {
                entry2.put("ismerge", isMergeReq);
                entry2.put("mergebillno", require.getValue(DefaultField.RequireField.__MERGE_REQBILL_NUM_.getName()));
                entry2.put("mergebillentryseq", require.getValue(DefaultField.RequireField.__MERGE_REQBILL_ENTRYSEQ_.getName()));
                entry2.put("mergebillid", require.getValue(DefaultField.RequireField.__MERGE_REQBILL_ID_.getName()));
                entry2.put("mergebillentryid", require.getValue(DefaultField.RequireField.__MERGE_REQBILL_ENTRYID_.getName()));
            } else if (require.getValue(DefaultField.RequireField.EXCEPTIONMESSAGE.getName()) == null && "1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                logger.warn(String.format("mrprunner-oom-require-data, mid: %s, rowdatas: %s", this.materialId, require));
            }
            entry2.put("eventid", this.event.getEventId());
            entry2.put("resolverip", AbstractMRPRunner.getIP());
            if (!entry2.containsKey("ismerge")) {
                entry2.put("ismerge", 0);
            }
            this.addDetails(details, entry2);
        }
    }

    private void updateDetailBomId(String poNum, Map<String, Object> entry) {
        Integer bomIdx = (Integer)this.ctx.getPo2BomIdx().get(poNum);
        if (bomIdx != null) {
            RowData bomData = this.ctx.bomDatas().fetchRow(bomIdx.intValue());
            String superBomId = String.valueOf(bomData.getValue(DefaultField.BOMField.__SUPER_BOMID__.getName()));
            if (DynamicObjDataUtil.isNullStringOr0Long((String)superBomId)) {
                superBomId = String.valueOf(bomData.getValue(DefaultField.BOMField.BOMID.getName()));
            }
            entry.put("parentbomid", superBomId);
            entry.put("bomversion", bomData.getValue(DefaultField.BOMField.BOMVERSION.getName()));
        }
    }

    private void markInvLevelRequireOccupySupply(RowData supply) {
        if (!((String)MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.__EXCEPTIONNUMBER__.getName()), (Object)"")).contains("98")) {
            String exceptionMsg = ResManager.loadKDString((String)"\u5e93\u5b58\u6c34\u4f4d\u5360\u7528\u3002", (String)"MRPDataBalanceResolver_2", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0]);
            String exceptionNumber = "98";
            supply.update(DefaultField.SupplyField._IS_INV_LEVEL_OCCUPIED_.getName(), (Object)Boolean.TRUE);
            exceptionNumber = MRPUtil.appendExceptionNumber((Object)supply.getValue(DefaultField.SupplyField.__EXCEPTIONNUMBER__.getName()), (String)exceptionNumber);
            exceptionMsg = MRPUtil.appendExceptionMsg((Object)supply.getValue(DefaultField.SupplyField.__EXCEPTIONMESSAGE__.getName()), (String)exceptionMsg);
            supply.update(DefaultField.SupplyField.__EXCEPTIONNUMBER__.getName(), (Object)exceptionNumber);
            supply.update(DefaultField.SupplyField.__EXCEPTIONMESSAGE__.getName(), (Object)exceptionMsg);
        }
    }

    private boolean isRemovePO(IMRPEnvProvider ctx, String tag) {
        ArrayList<Long> check = new ArrayList<Long>(ctx.getAllPlanTags());
        if (check.isEmpty()) {
            check.add(0L);
        }
        if ("null".equals(tag) || StringUtils.isBlank((CharSequence)tag)) {
            tag = "0";
        }
        return !check.contains(Long.valueOf(tag));
    }

    private void addReserveCacheData(IMRPEnvProvider provider, SimplePlanOrder po, RequireRowData require, String outPutType) {
        Long material = require.getLong(DefaultField.RequireField.MATERIAL.getName());
        String reservedType = require.getString(DefaultField.RequireField.RESERVEDTYPE.getName());
        boolean isWeak = StringUtils.equals((CharSequence)reservedType, (CharSequence)"B");
        Object reserve_billno = require.getValue(DefaultField.RequireField.RESERVE_BILLNO.getName());
        Object reserve_billid = require.getValue(DefaultField.RequireField.RESERVE_BILLID.getName());
        Object reserve_billentryid = require.getValue(DefaultField.RequireField.RESERVE_BILLENTRYID.getName());
        Object reserve_billentryseq = require.getValue(DefaultField.RequireField.RESERVE_BILLENTRYSEQ.getName());
        String bill_obj = outPutType;
        Object billNo = require.getValue(DefaultField.RequireField.BILLNUMBER.getName());
        Object billId = require.getValue(DefaultField.RequireField.BILLID.getName());
        Object billEntryId = require.getValue(DefaultField.RequireField.BILLENTRYID.getName());
        Object billEntrySeq = require.getValue(DefaultField.RequireField.BILLENTRYSEQ.getName());
        String billEntity = require.getString(DefaultField.RequireField.BILL_ENTITY.getName());
        if (reserve_billid == null) {
            reserve_billno = billNo;
            reserve_billid = billId;
            reserve_billentryid = billEntryId;
            reserve_billentryseq = billEntrySeq;
            bill_obj = billEntity;
        }
        HashMap<String, Object> resMap = new HashMap<String, Object>(32);
        resMap.put("ori_bill_obj", billEntity);
        resMap.put("ori_bill_no", billNo);
        resMap.put("ori_bill_id", billId);
        resMap.put("ori_billentry_id", billEntryId);
        resMap.put("ori_billentry_seq", billEntrySeq);
        resMap.put("bill_obj", bill_obj);
        resMap.put("r_sale_org", require.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()));
        resMap.put("r_biz_date", require.getLong(DefaultField.RequireField.__ORIGIN_DEMAND_DATE__.getName()) == null ? require.getLong(DefaultField.RequireField.DATE.getName()) : require.getLong(DefaultField.RequireField.__ORIGIN_DEMAND_DATE__.getName()));
        resMap.put("s_biz_date", po.getSupplyDate());
        resMap.put("bill_no", reserve_billno);
        resMap.put("bill_id", reserve_billid);
        resMap.put("billentry_id", reserve_billentryid);
        resMap.put("billentry_seq", reserve_billentryseq);
        resMap.put("s_org", po.getProductOrgUnit());
        resMap.put("bal_obj", outPutType);
        resMap.put("bal_id", Long.valueOf(po.getId()));
        resMap.put("s_billnum", po.getNumber());
        resMap.put("bal_entryid", Long.valueOf(po.getId()));
        resMap.put("s_materiel", material);
        resMap.put("s_unit", require.getValue(DefaultField.RequireField.BASEUNIT.getName()));
        resMap.put("s_baseunit", require.getValue(DefaultField.RequireField.BASEUNIT.getName()));
        resMap.put("qty", po.getQty());
        resMap.put("base_qty", po.getQty());
        resMap.put("ori_qty", po.getQty());
        resMap.put("isweak", isWeak);
        resMap.put("isNew", "1");
        resMap.put("change_type", "1");
        resMap.put("create_date", new Date());
        resMap.put("creater", RequestContext.get().getCurrUserId());
        resMap.put("reservesource", "MRP");
        resMap.put("priority", require.getInteger(DefaultField.RequireField.__PRIORITY_LEVEL__.getName()));
        resMap.put("isgenreserve", MRPUtil.convert((Object)require.getValue(DefaultField.RequireField.IS_GEN_RESERVE.getName()), (Boolean)Boolean.FALSE));
        List list = provider.getReserveCacheData().computeIfAbsent(material.toString(), k -> new ArrayList(16));
        list.add(resMap);
    }

    private void calcOrderDate(RequireRowData require, RowData supply) {
        Long date = (Long)require.getValue(DefaultField.RequireField.DATE.getName());
        Long supplyDate = (Long)supply.getValue(DefaultField.SupplyField.DATE.getName());
        require.update(DefaultField.RequireField.DATE.getName(), (Object)supplyDate);
        require.update(DefaultField.RequireField.__END_DATE__.getName(), null);
        require.update(DefaultField.RequireField.__START_DATE__.getName(), null);
        String supplyOrgId = String.valueOf(require.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()));
        require.update(DefaultField.RequireField.SUPPLYORGUNIT.getName(), supply.getValue(DefaultField.SupplyField.SUPPLYORGUNIT.getName()));
        MRPUtil.calcDate((RequireRowData)require, (BigDecimal)((BigDecimal)MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.QTY.getName()), (Object)BigDecimal.ZERO)), (IMRPEnvProvider)this.ctx);
        require.update(DefaultField.RequireField.DATE.getName(), (Object)date);
        require.update(DefaultField.RequireField.SUPPLYORGUNIT.getName(), (Object)supplyOrgId);
    }

    private void addDetails(List<Map<String, Object>> details, HashMap<String, Object> entry) {
        int batch;
        String mid = (String)MRPUtil.convert((Object)entry.get("material"), (Object)"");
        BigDecimal requireQty = (BigDecimal)MRPUtil.convert((Object)entry.get("demandqty"), (Object)BigDecimal.ZERO);
        BigDecimal supplyQty = (BigDecimal)MRPUtil.convert((Object)entry.get("supplyqty"), (Object)BigDecimal.ZERO);
        if (MRPUtil.isExceededQty((BigDecimal)requireQty) || MRPUtil.isExceededQty((BigDecimal)supplyQty)) {
            String[] strings = this.ctx.getMaterialDataById(mid);
            throw new MRPBizException(Errors.getDetailExceededQtyError(), new Object[]{strings[0], entry.get("billno"), entry.get("billentryseq"), requireQty.compareTo(supplyQty) >= 0 ? requireQty.toPlainString() : supplyQty.toPlainString()});
        }
        ++this.detailCnt;
        details.add(entry);
        String detailSaveMode = (String)this.ctx.getCfgValue(EnvCfgItem.DETAIL_SAVING_MODE);
        if ("BY_SPLIT".equals(detailSaveMode) && this.detailCnt % (batch = this.getDetailSaveBatch()) == 0) {
            MRPCacheManager.getInst().setMaterialDetails2((CalEnv)this.ctx, this.materialId, details, batch, this.savedBatchCnt++);
            details.clear();
        }
    }

    private int getDetailSaveBatch() {
        int batch = (Integer)this.ctx.getCfgValue(EnvCfgItem.DETAIL_SAVING_BATCH);
        if (batch <= 0) {
            batch = 5000;
        }
        return batch;
    }

    protected String getPoNum(SimplePlanOrder spo, int mAttr) {
        if (mAttr != MaterialAttribute.PURCHASEDPART.getValue()) {
            return spo.getNumber();
        }
        if (this.result.getNumMap().isEmpty()) {
            return spo.getNumber();
        }
        String num = String.valueOf(this.result.getNumMap().get(spo.getNumber()));
        if (num == null || "null".equalsIgnoreCase(num)) {
            return spo.getNumber();
        }
        return num;
    }

    protected List<RowData> cancelSupplys(List<Map<String, Object>> details) {
        SupplymentDataTable supplys = this.ctx.supplyDatas();
        RequireDataModel requireDataModel = (RequireDataModel)this.ctx.getService(RequireDataModel.class);
        ArrayList<RowData> cops = new ArrayList<RowData>(16);
        CacheDatas cacheDatas = (CacheDatas)this.ctx.getService(CacheDatas.class);
        boolean isSelectBillPlan = cacheDatas.isSelectBillPlan();
        HashMap<String, Map> mid2billQtyRatio = new HashMap<String, Map>(this.mid2billIdQtys.size());
        HashMap<String, Map> mid2billCancelQty = new HashMap<String, Map>(this.mid2billIdQtys.size());
        for (int i = 0; i < supplys.size(); ++i) {
            boolean isCancel;
            Object tmp;
            boolean isRecordOOR;
            RowData rowData = supplys.fetchRow(i);
            Object isLocked = rowData.getValue(DefaultField.SupplyField.__IS_OCCUPIED__.name());
            Object isReplace = rowData.getValue(DefaultField.SupplyField.__IS_REPLACE__.getName());
            String modelID = (String)rowData.getValue(DefaultField.SupplyField.BILL_ENTITY.getName());
            BillSplitStrategy ajustType = this.ctx.strategys().getOrDefault(modelID, BillSplitStrategy.PART);
            Object isManualCop = rowData.getValue(DefaultField.SupplyField.__MANUAL_CREATE_COP__.getName());
            Boolean invLevelOccupied = MRPUtil.convert((Object)rowData.getValue(DefaultField.SupplyField._IS_INV_LEVEL_OCCUPIED_.getName()), (Boolean)Boolean.FALSE);
            boolean isPoSup = InvPlanUtil.isNewCreateSupplyBill((IMRPEnvProvider)this.ctx, (RowData)rowData);
            if (isPoSup) continue;
            if (isManualCop != null && ((Boolean)isManualCop).booleanValue()) {
                cops.add(rowData);
                rowData.update(DefaultField.SupplyField.__MANUAL_CREATE_COP__.getName(), null);
                supplys.updateValue(DefaultField.SupplyField.__MANUAL_CREATE_COP__.getName(), Integer.valueOf(i), null);
                continue;
            }
            Long billId = (Long)MRPUtil.convert((Object)rowData.getValue(DefaultField.SupplyField.BILLID.getName()), (Object)0L);
            Long billEntryId = (Long)MRPUtil.convert((Object)rowData.getValue(DefaultField.SupplyField.BILLENTRYID.getName()), (Object)0L);
            if (billEntryId <= 0L) {
                billEntryId = billId;
            }
            String key = String.format("%s-%s", billId, billEntryId);
            ReserveData reserveData = (ReserveData)this.supplyTbl.getS2Reserve().get(key);
            if (reserveData != null) {
                reserveData.calculateSupplySurplusQty();
            }
            if (isLocked != null && ((Boolean)isLocked).booleanValue() || isReplace != null && ((Boolean)isReplace).booleanValue()) continue;
            if (reserveData != null && reserveData.getAllQty().compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal qty = rowData.getBigDecimal(DefaultField.SupplyField.QTY.getName());
                BigDecimal surplusQty = reserveData.subReserveQty(qty);
                if (surplusQty.compareTo(BigDecimal.ZERO) >= 0) {
                    rowData.update(DefaultField.SupplyField.QTY.getName(), (Object)BigDecimal.ZERO);
                    continue;
                }
                qty = surplusQty.negate();
                rowData.update(DefaultField.SupplyField.QTY.getName(), (Object)qty);
            }
            HashMap<String, Object> entry = new HashMap<String, Object>();
            entry.put("material", rowData.getValue(DefaultField.SupplyField.MATERIAL.getName()));
            entry.put("configuredcode", rowData.getValue(DefaultField.SupplyField.CONFIGUREDCODE.getName()));
            BillAdjustStrategy adjustStrategy = BillAdjustStrategy.CANCEL;
            if (Boolean.TRUE.equals(invLevelOccupied)) {
                String invRequireKey = (String)MRPUtil.convert((Object)rowData.getValue(DefaultField.SupplyField.__INV_REQUIRE_KEY_.getName()), (Object)"");
                RequireRowData requireRowData = (RequireRowData)this.ctx.getInvPlanKey2Require().get(invRequireKey);
                Map supplyQtyMap = (Map)this.ctx.getSupplyOccupyQty().get(invRequireKey);
                if (requireRowData != null && supplyQtyMap != null) {
                    String sk = String.format("%s-%s", rowData.getValue(DefaultField.SupplyField.BILLID.getName()), rowData.getValue(DefaultField.SupplyField.BILLENTRYID.getName()));
                    BigDecimal qty = supplyQtyMap.getOrDefault(sk, BigDecimal.ZERO);
                    if (qty.compareTo(BigDecimal.ZERO) > 0) {
                        BigDecimal sQty = (BigDecimal)MRPUtil.convert((Object)rowData.getValue(DefaultField.SupplyField.QTY.getName()), (Object)BigDecimal.ZERO);
                        if (qty.compareTo(sQty) < 0) {
                            RowData split = supplys.split(rowData, sQty.subtract(qty), this.ctx);
                            split.update(DefaultField.SupplyField._IS_INV_LEVEL_OCCUPIED_.getName(), null);
                            supplys.fill(split);
                        }
                        supplyQtyMap.put(sk, qty.subtract(sQty));
                    }
                    this.putRequireDetail(this.ctx, entry, requireRowData, false, this.llc);
                    entry.put("demandqty", rowData.getValue(DefaultField.SupplyField.QTY.getName()));
                }
                adjustStrategy = BillAdjustStrategy.NONE;
                this.markInvLevelRequireOccupySupply(rowData);
            }
            this.putSupplyDetail(this.ctx, entry, rowData, this.llc);
            entry.put("adjustsuggest", adjustStrategy.getAlias());
            entry.put("eventid", this.event.getEventId());
            entry.put("resolverip", AbstractMRPRunner.getIP());
            boolean bl = isRecordOOR = this.ctx.getOORDataResolveStrategy() == OORBillResolveStrategy.RECORDEXCEPTIONTAG;
            if (this.isRemoveStorageSupply(rowData)) {
                String exceptionMsg = ResManager.loadKDString((String)"\u5e93\u5b58\u6570\u636e\u8d85\u51fa\u8ba1\u7b97\u8303\u56f4", (String)"MRPDataBalanceResolver_6", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0]);
                String exceptionNumber = "103";
                exceptionNumber = MRPUtil.appendExceptionNumber((Object)rowData.getValue(DefaultField.SupplyField.__EXCEPTIONNUMBER__.getName()), (String)exceptionNumber);
                exceptionMsg = MRPUtil.appendExceptionMsg((Object)rowData.getValue(DefaultField.SupplyField.__EXCEPTIONMESSAGE__.getName()), (String)exceptionMsg);
                rowData.update(DefaultField.SupplyField.__EXCEPTIONNUMBER__.getName(), (Object)exceptionNumber);
                rowData.update(DefaultField.SupplyField.__EXCEPTIONMESSAGE__.getName(), (Object)exceptionMsg);
            }
            if (MRPUtil.hasExceptionSupply((String)String.valueOf(rowData.getValue(DefaultField.SupplyField.__EXCEPTIONNUMBER__.getName()))) && !isRecordOOR) continue;
            String supplyKey = String.valueOf(rowData.getValue(DefaultField.SupplyField.MATERIAL.getName())) + '\u0001' + String.valueOf(rowData.getValue(DefaultField.SupplyField.SUPPLYORGUNIT.getName()));
            Integer mAttr = (Integer)MRPUtil.convert((Object)rowData.getValue(DefaultField.SupplyField.MATERIALATTR.getName()), (Object)MaterialAttribute.OTHER.getValue());
            if (mAttr == null || MaterialAttribute.OTHER.getValue() == mAttr.intValue()) {
                mAttr = this.midAndOrg2mAttr.getOrDefault(supplyKey, MaterialAttribute.OTHER.getValue());
            }
            entry.put("materialattr", mAttr);
            entry.put("sexpnumber", rowData.getValue(DefaultField.SupplyField.__EXCEPTIONNUMBER__.getName()));
            entry.put("sexpmsg", rowData.getValue(DefaultField.SupplyField.__EXCEPTIONMESSAGE__.getName()));
            if (!entry.containsKey("ismerge")) {
                entry.put("ismerge", 0);
            }
            if ((tmp = rowData.get(DefaultField.SupplyField.__HAS_WHOLE_ADJUST__.name())) != null && (BillSplitStrategy.WHOLE == ajustType || BillSplitStrategy.NONE == ajustType) && (isCancel = MRPUtil.convert((Object)tmp, (Boolean)Boolean.FALSE).booleanValue())) {
                String exceptionMsg = BillSplitStrategy.WHOLE == ajustType ? ResManager.loadKDString((String)"\u6574\u5355\u8c03\u6574\u7b56\u7565\uff0c\u4e0d\u8c03\u6574\u7684\u4f9b\u5e94\u5bcc\u4f59\u91cf", (String)"MRPDataBalanceResolver_8", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8c03\u6574\u7b56\u7565\u4e3a\u4e0d\u8c03\u6574\uff0c\u5bcc\u4f59\u4f9b\u5e94\u4e0d\u4ea7\u751f\u8c03\u6574\u5efa\u8bae", (String)"MRPDataBalanceResolver_9", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0]);
                String exceptionNumber = "99";
                exceptionNumber = MRPUtil.appendExceptionNumber((Object)rowData.getValue(DefaultField.SupplyField.__EXCEPTIONNUMBER__.getName()), (String)exceptionNumber);
                exceptionMsg = MRPUtil.appendExceptionMsg((Object)rowData.getValue(DefaultField.SupplyField.__EXCEPTIONMESSAGE__.getName()), (String)exceptionMsg);
                entry.put("sexpnumber", exceptionNumber);
                entry.put("sexpmsg", exceptionMsg);
                entry.put("adjustsuggest", BillAdjustStrategy.NONE.getAlias());
            }
            if (BillAdjustStrategy.CANCEL.getAlias().equals(entry.get("adjustsuggest"))) {
                entry.put("adjustqty", entry.get("originsupplyqty"));
                Long supplyScope = (Long)MRPUtil.convert((Object)entry.get("supplyplanscope"), (Object)0L);
                if (supplyScope <= 0L) {
                    PlanModel planModel = (PlanModel)this.ctx.getService(PlanModel.class);
                    String material = String.valueOf(rowData.getValue(DefaultField.SupplyField.MATERIAL.getName()));
                    Long supplyOrg = (Long)MRPUtil.convert((Object)rowData.getValue(DefaultField.SupplyField.SUPPLYORGUNIT.getName()), (Object)0L);
                    String cacheKey = PlanScopeRelationConst.getRedisPlanScopeRelationKey((String)supplyOrg.toString(), (String)material);
                    SupplyStruct ss = planModel.getPriorityRelations().getOrDefault(supplyOrg.toString(), new SupplyStruct());
                    supplyScope = DataBalanceUtil.getSupplyPlanScope((IMRPEnvProvider)this.ctx, (SupplyStruct)ss, (Long)supplyOrg, (String)material, (boolean)true, (String)cacheKey, (RowData)rowData);
                    entry.put("supplyplanscope", supplyScope);
                    rowData.update(DefaultField.SupplyField.DYNAMIC_PLANSCOPE.getName(), (Object)supplyScope);
                }
            }
            this.addDetails(details, entry);
            if (!isSelectBillPlan) continue;
            Map<Long, BigDecimal> billQtyMap = this.mid2billIdQtys.get(String.valueOf(rowData.getValue(DefaultField.SupplyField.MATERIAL.getName())));
            Long supplyIDKey = this.getSupplyKey(rowData);
            if (billQtyMap == null || billQtyMap.get(supplyIDKey) == null) continue;
            Map billCancelQtyMap = mid2billCancelQty.computeIfAbsent(String.valueOf(rowData.getValue(DefaultField.SupplyField.MATERIAL.getName())), k -> new HashMap(16));
            BigDecimal cancelQty = billCancelQtyMap.getOrDefault(supplyIDKey, BigDecimal.ZERO);
            cancelQty = cancelQty.add((BigDecimal)MRPUtil.convert((Object)rowData.getValue(DefaultField.SupplyField.QTY.getName()), (Object)BigDecimal.ZERO));
            billCancelQtyMap.put(supplyIDKey, cancelQty);
        }
        for (Map.Entry<String, Map<Long, BigDecimal>> entry : this.mid2billIdQtys.entrySet()) {
            Map<Long, BigDecimal> billQtyMap = entry.getValue();
            Map billCancelQtyMap = mid2billCancelQty.getOrDefault(entry.getKey(), new HashMap(0));
            Map billQtyRatioMap = mid2billQtyRatio.computeIfAbsent(entry.getKey(), k -> new HashMap(billQtyMap.size()));
            for (Map.Entry<Long, BigDecimal> e : billQtyMap.entrySet()) {
                BigDecimal sumQty = e.getValue().add(billCancelQtyMap.getOrDefault(e.getKey(), BigDecimal.ZERO));
                if (sumQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal ratio = e.getValue().divide(sumQty, 10, 5);
                billQtyRatioMap.put(e.getKey(), ratio);
            }
        }
        for (Map.Entry<String, Map<Long, BigDecimal>> entry : mid2billQtyRatio.entrySet()) {
            MRPCacheManager.getInst().putData((CalEnv)this.ctx, MRPRuntimeConsts.getDependSupplyKey((String)this.ctx.getMRPContextId(), (String)entry.getKey()), JSON.toJSONString(entry.getValue()));
        }
        return cops;
    }

    protected boolean isRemoveStorageSupply(RowData supply) {
        PlanModel planModel = (PlanModel)this.ctx.getService(PlanModel.class);
        HashSet requireOrgs = planModel.getRequirorgs();
        Boolean isStorageSupply = MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.ISSTORAGEDATA.getName()), (Boolean)Boolean.FALSE);
        if (isStorageSupply.booleanValue()) {
            boolean isRemove = true;
            for (String requireOrg : requireOrgs) {
                if (!DataBalanceUtil.isEnableStorageSupply((IMRPEnvProvider)this.ctx, (RowData)supply, (String)requireOrg, (boolean)false)) continue;
                isRemove = false;
                break;
            }
            return isRemove;
        }
        return false;
    }

    protected void refreshCopSupplys(List<RowData> cops) {
        HashMap<String, List> mToData = new HashMap<String, List>(1);
        for (RowData rowData : cops) {
            String materialId = String.valueOf(rowData.getValue(DefaultField.SupplyField.MATERIAL.getName()));
            List datas = mToData.computeIfAbsent(materialId, k -> new ArrayList());
            datas.add(rowData.getValues());
        }
        for (Map.Entry entry : mToData.entrySet()) {
            String cacheKey = MRPRuntimeConsts.getDataKey((String)this.event.getEventId(), null, (String)((String)entry.getKey()));
            MRPCacheManager.getInst().putSubData((CalEnv)this.ctx, "supply-" + (String)entry.getKey(), cacheKey, JSON.toJSONString(entry.getValue(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
        }
    }

    protected void refreshDependentRequires() {
        ColumnDatas col = this.ctx.requireDatas().getCol(DefaultField.RequireField.MATERIAL.getName());
        Iterator iter = col.iterator();
        CacheDatas cacheDatas = (CacheDatas)this.ctx.getService(CacheDatas.class);
        boolean isSelectMaterialPlan = cacheDatas.isSelectMaterialPlan();
        boolean isSelectMaterialPlan4PlanScope = cacheDatas.isSelectMaterialPlan4PlanScope();
        HashSet<String> dependMids = new HashSet<String>(16);
        HashMap<String, Set> orgAndMid2AllScope = new HashMap<String, Set>(16);
        while (iter.hasNext()) {
            this.ctx.testEnvStatus();
            HashSet group = null;
            TraceSpan ts = Tracer.create((String)"MRPDataResolver.refreshDependentRequires", (String)"refreshDependentRequires");
            Throwable throwable = null;
            try {
                Object id = iter.next();
                String materialId = String.valueOf(id);
                String cacheKey = MRPRuntimeConsts.getDataKey((String)this.event.getEventId(), null, (String)materialId);
                List rows = col.get(id);
                ArrayList<Object[]> datas = new ArrayList<Object[]>(rows.size());
                for (Integer i : rows) {
                    Set res;
                    Long dataOrg;
                    Object[] value = this.ctx.requireDatas().getSrcDatas().getDatas().get(i.intValue());
                    boolean isBomPass = MRPUtil.convert((Object)value[(Integer)this.ctx.requireDatas().getColIdx().get(DefaultField.RequireField.__IS_EXPANDABLE__.getName())], (Boolean)Boolean.TRUE);
                    Long planScope = (Long)MRPUtil.convert((Object)value[(Integer)this.ctx.requireDatas().getColIdx().get(DefaultField.RequireField.PLANSCOPE.getName())], (Object)0L);
                    Long supplyOrg = (Long)MRPUtil.convert((Object)value[(Integer)this.ctx.requireDatas().getColIdx().get(DefaultField.RequireField.SUPPLYORGUNIT.getName())], (Object)0L);
                    Long l = dataOrg = supplyOrg > 0L ? supplyOrg : (Long)MRPUtil.convert((Object)value[(Integer)this.ctx.requireDatas().getColIdx().get(DefaultField.RequireField.PRODUCTIONORGUNIT.getName())], (Object)0L);
                    if (isSelectMaterialPlan4PlanScope && planScope > 0L) {
                        String key = dataOrg.toString() + '\u0001' + materialId;
                        Set allScope = orgAndMid2AllScope.computeIfAbsent(key, k -> new HashSet());
                        allScope.add(planScope.toString());
                    }
                    if (isSelectMaterialPlan && this.ctx.isReplace() && !(res = ReplaceUtil.getReplaceMaterialCol((RowData)this.ctx.requireDatas().fetchRow(i.intValue()))).isEmpty()) {
                        if (group == null) {
                            group = new HashSet(res.size());
                        }
                        group.addAll(res);
                    }
                    if (!isBomPass) continue;
                    datas.add(value);
                }
                if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                    logger.warn(String.format("mrprunner-refreshDependentRequires mid:%s, cnt: %s", materialId, datas.size()));
                }
                if (datas.isEmpty()) continue;
                MRPCacheManager.getInst().putSubData((CalEnv)this.ctx, "require-" + materialId, cacheKey, JSON.toJSONString(datas, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
                if (!isSelectMaterialPlan) continue;
                dependMids.add(materialId);
                if (group == null) continue;
                dependMids.addAll(group);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ts == null) continue;
                if (throwable != null) {
                    try {
                        ts.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ts.close();
            }
        }
        if (!dependMids.isEmpty()) {
            MRPCacheManager.getInst().putData((CalEnv)this.ctx, MRPRuntimeConsts.getDependRequireMaterialKey((String)this.ctx.getMRPContextId(), (String)this.materialId), JSON.toJSONString(dependMids, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
        }
        if (!orgAndMid2AllScope.isEmpty()) {
            MRPCacheManager.getInst().putData((CalEnv)this.ctx, MRPRuntimeConsts.getDependRequireMaterialPlanScopeKey((String)this.ctx.getMRPContextId(), (String)this.materialId), JSON.toJSONString(orgAndMid2AllScope, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
        }
    }

    protected void putRequireDetail(IMRPEnvProvider ctx, HashMap<String, Object> entry, RequireRowData require, boolean isExceptionData, int llc) {
        MRPDataBalanceResolver.putRequire(ctx, entry, require, isExceptionData, llc);
        IMRPCalcNetDemandPlugin imrpCalcNetDemandPlugin = ctx.getMRPCalcNetDemandPlugin();
        if (imrpCalcNetDemandPlugin != null) {
            imrpCalcNetDemandPlugin.putRequireDetail(ctx.getMrpSdkEnv(), entry, (IRowData)require, isExceptionData, llc);
        }
    }

    public static void putRequire(IMRPEnvProvider ctx, HashMap<String, Object> entry, RequireRowData require, boolean isExceptionData, int llc) {
        entry.put("material", require.getValue(DefaultField.RequireField.MATERIAL.getName()));
        entry.put("demandbilltype", require.getValue(DefaultField.CommonField.__MODEL_NUMBER__.name()));
        entry.put("demandbillf7", require.getValue(DefaultField.RequireField.BILL_ENTITY.getName()));
        entry.put("bomversion", require.getValue(DefaultField.RequireField.__BOM_VERSION__.getName()));
        BigDecimal qty = (BigDecimal)require.getValue(DefaultField.RequireField.QTY.getName());
        entry.put("demandqty", qty);
        entry.put("billid", require.getValue(DefaultField.RequireField.BILLID.getName()));
        entry.put("billno", require.getValue(DefaultField.RequireField.BILLNUMBER.getName()));
        entry.put("ishandle", Boolean.FALSE);
        Object date = require.getValue(DefaultField.RequireField.__SRC_DATE__.getName());
        if (date == null) {
            date = require.getValue(DefaultField.RequireField.DATE.getName());
        }
        if ("SYSDATE".equalsIgnoreCase((String)ctx.getCfgValue(EnvCfgItem.REQUIRE_BILL_DATE_ADJUST_TYPE)) && (Long)date < ctx.getPlanDate().getTime()) {
            date = ctx.getPlanDate().getTime();
        }
        entry.put("demanddate", date);
        entry.put("billentryid", require.getValue(DefaultField.RequireField.BILLENTRYID.getName()));
        entry.put("billentryseq", require.getValue(DefaultField.RequireField.BILLENTRYSEQ.getName()));
        entry.put("srcdemandqty", require.getValue(DefaultField.RequireField.__MERGE_REQQTY_.getName()));
        entry.put("requireorg", require.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
        entry.put("reqpriority", require.getValue(DefaultField.RequireField.__PRIORITY_LEVEL__.getName()));
        entry.put("materialattr", require.getValue(DefaultField.RequireField.MATERIALATTR.getName()));
        if (BillSupplyStrategy.INVENTORY.getValue().equals(require.getString(DefaultField.RequireField.DEMAND_SUPPLY_STRATEGY.getName()))) {
            entry.put("materialattr", MaterialAttribute.STORAGEPART.getValue());
        }
        entry.put("orderdate", require.getValue(DefaultField.RequireField.__ORDER_DATE__.getName()));
        entry.put("leadtime", require.getValue(DefaultField.RequireField.__LEADTIME__.getName()));
        entry.put("entryqtytype", require.getValue(DefaultField.RequireField.__CHILDAMTTYPE__.getName()));
        entry.put("entryqtynumerator", require.getValue(DefaultField.RequireField.__CHILDNUMERATOR__.getName()));
        entry.put("entryqtydenominator", require.getValue(DefaultField.RequireField.__CHILDDENOMINATOR__.getName()));
        entry.put("wastagerateformula", require.getValue(DefaultField.RequireField.__DYNAMICSCRAPFORMULA__.getName()));
        if (isExceptionData || require.getValue(DefaultField.RequireField.EXCEPTIONMESSAGE.getName()) != null) {
            entry.put("exception", MRPUtil.subExceptionMsg((String)String.valueOf(require.getValue(DefaultField.RequireField.EXCEPTIONMESSAGE.getName()))));
        }
        entry.put("exceptionnumber", require.getValue(DefaultField.RequireField.EXCEPTIONNUMBER.getName()));
        entry.put("reqsourcebillno", require.getValue(DefaultField.RequireField.__REQUIRE_SOURCE__.getName()));
        entry.put("llc", String.valueOf(llc));
        entry.put("parentbomid", require.getValue(DefaultField.RequireField.__BOMID__.getName()));
        entry.put("bomid", require.getValue(DefaultField.RequireField.__PARENT_BOMID__.getName()));
        entry.put("yieldratio", require.getValue(DefaultField.RequireField.YIELD.getName()));
        entry.put("scrapratio", require.getValue(DefaultField.RequireField.__SCRAPRATIO__.getName()));
        entry.put("dynamicscrapratio", require.getValue(DefaultField.RequireField.__DYNAMICSCRAPRATIO__.getName()));
        entry.put("fixscrap", require.getValue(DefaultField.RequireField.__FIXSCRAP__.getName()));
        entry.put("dynamicscrapformula", require.getValue(DefaultField.RequireField.__DYNAMICSCRAPFORMULA__.getName()));
        entry.put("origindemanddate", require.getValue(DefaultField.RequireField.__ORIGIN_DEMAND_DATE__.getName()));
        entry.put("requireoperator", require.getValue(DefaultField.RequireField.REQUIREOPERAOTR.getName()));
        entry.put("plantag", MRPDataBalanceResolver.setPlanTag(ctx, require.getValue(DefaultField.RequireField.__PLAN_TAG__.getName())));
        entry.put("demandsourcetype", require.getValue(DefaultField.RequireField.REQUIRETYPE.getName()));
        entry.put("configuredcode", require.getValue(DefaultField.RequireField.CONFIGUREDCODE.getName()));
        Object isTrackMatch = require.getValue(DefaultField.RequireField.IS_TRACK_MATCH.getName());
        if (MRPUtil.convert((Object)isTrackMatch, (Boolean)Boolean.FALSE).booleanValue()) {
            entry.put("tracknumber", require.getValue(DefaultField.RequireField.TRACKNUMBER.getName()));
        } else {
            entry.put("tracknumber", null);
        }
        entry.put("demandstorage", require.getValue(DefaultField.RequireField.OWNER.getName()));
        entry.put("demandauxpty", require.getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName()));
        entry.put("reqflexmetricid", require.getValue(DefaultField.RequireField.FLEXMETRICID.getName()));
        entry.put("reqflexmetricval", require.getValue(DefaultField.RequireField.FLEXMETRICVALUE.getName()));
        entry.put("demandproject", require.getValue(DefaultField.RequireField.PROJECTNUMBER.getName()));
        entry.put("demandsupplier", require.getValue(DefaultField.RequireField.SUPPLIER.getName()));
        entry.put("demandplanscope", require.getValue(DefaultField.RequireField.PLANSCOPE.getName()));
        entry.put("demandwarehouse", require.getValue(DefaultField.RequireField.WAREHOUSE.getName()));
        entry.put("workcenter", require.getValue(DefaultField.RequireField.WORKCENTER.getName()));
        entry.put("copytype", require.getLong(DefaultField.RequireField.SUPPLY_NETWORK.getName()));
        entry.put("top_require_date", require.getValue(DefaultField.RequireField.TOP_REQUIRE_DATE.getName()));
        Object strategy = require.get(DefaultField.RequireField.PLAN_STRATEGY.getName());
        if (strategy == null) {
            strategy = require.get(DefaultField.RequireField.DEFAULT_PLAN_STRATEGY.getName());
        }
        entry.put("manustrategy", strategy);
        entry.put("onworkqty4req", require.getBigDecimal(DefaultField.RequireField.ONWORKQTY.getName()));
        entry.put("receiveqty4req", require.getBigDecimal(DefaultField.RequireField.PICKEDQTY.getName()));
    }

    protected void putSupplyDetail(IMRPEnvProvider ctx, HashMap<String, Object> entry, RowData supply, int llc) {
        MRPDataBalanceResolver.putSupply(ctx, entry, supply, llc);
        IMRPCalcNetDemandPlugin imrpCalcNetDemandPlugin = ctx.getMRPCalcNetDemandPlugin();
        if (imrpCalcNetDemandPlugin != null) {
            imrpCalcNetDemandPlugin.putSupplyDetail(ctx.getMrpSdkEnv(), entry, (IRowData)supply, llc);
        }
    }

    public static void putSupply(IMRPEnvProvider ctx, HashMap<String, Object> entry, RowData supply, int llc) {
        RequireDataModel requireDataModel = (RequireDataModel)ctx.getService(RequireDataModel.class);
        String outputType = requireDataModel.getOutputType();
        String supplyType = "";
        if (supply.getValue(DefaultField.CommonField.__MODEL_NUMBER__.name()) != null) {
            supplyType = (String)supply.getValue(DefaultField.CommonField.__MODEL_NUMBER__.name());
        }
        entry.put("supplybilltype", supply.getValue(DefaultField.CommonField.__MODEL_NUMBER__.name()));
        if (supply.getValue(DefaultField.SupplyField.BILL_ENTITY.getName()) != null) {
            entry.put("supplybillf7", supply.getValue(DefaultField.SupplyField.BILL_ENTITY.getName()));
        } else {
            entry.put("supplybillf7", outputType);
        }
        entry.put("ishandle", Boolean.FALSE);
        entry.put("supmaterial", supply.getValue(DefaultField.SupplyField.MATERIAL.getName()));
        entry.put("suppriority", supply.getValue(DefaultField.SupplyField.__PRIORITY_LEVEL__.getName()));
        entry.put("supplyqty", supply.getValue(DefaultField.SupplyField.QTY.getName()));
        entry.put("originsupplyqty", supply.getValue(DefaultField.SupplyField.ORIGINQTY.getName()));
        entry.put("supplybillid", supply.getValue(DefaultField.SupplyField.BILLID.getName()));
        entry.put("supplybillno", supply.getValue(DefaultField.SupplyField.BILLNUMBER.getName()));
        entry.put("supplydate", supply.getValue(DefaultField.SupplyField.DATE.getName()));
        entry.put("supplybillentryid", supply.getValue(DefaultField.SupplyField.BILLENTRYID.getName()));
        Boolean isInvOccupy = MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField._IS_INV_LEVEL_OCCUPIED_.getName()), (Boolean)Boolean.FALSE);
        entry.put("adjustdate", isInvOccupy != false ? null : supply.getValue(DefaultField.SupplyField.__ADJUST_PLAN_DATE__.name()));
        int flag = (Integer)MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.__ADJUST_FLAG__.name()), (Object)BillAdjustStrategy.NONE.getValue());
        entry.put("adjustsuggest", isInvOccupy != false ? BillAdjustStrategy.NONE.getAlias() : BillAdjustStrategy.parseInt((int)flag).getAlias());
        if (flag == BillAdjustStrategy.NONE.getValue() || isInvOccupy.booleanValue()) {
            entry.put("adjustqty", BigDecimal.ZERO);
        } else {
            entry.put("adjustqty", supply.getValue(DefaultField.SupplyField.__ADJUST_QTY__.name()));
        }
        entry.put("supplybillentryseq", supply.getValue(DefaultField.SupplyField.BILLENTRYSEQ.getName()));
        entry.put("sexpmsg", supply.getValue(DefaultField.SupplyField.__EXCEPTIONMESSAGE__.getName()));
        entry.put("sexpnumber", supply.getValue(DefaultField.SupplyField.__EXCEPTIONNUMBER__.getName()));
        entry.put("supplydetail", MRPDataBalanceResolver.buildSupplyDetail(supply));
        entry.put("warehouse", supply.getValue(DefaultField.SupplyField.WAREHOUSE.getName()));
        entry.put("location", supply.getValue(DefaultField.SupplyField.STOCKLOT.getName()));
        entry.put("invpriority", supply.getValue(DefaultField.SupplyField.__SUPPLY_PRIORITY__.getName()));
        entry.put("supplyorg", supply.getValue(DefaultField.SupplyField.SUPPLYORGUNIT.getName()));
        entry.put("llc", String.valueOf(llc));
        entry.put("supplyoperator", supply.getValue(DefaultField.SupplyField.SUPPLYOPERATOR.getName()));
        entry.put("supplantag", MRPDataBalanceResolver.setPlanTag(ctx, supply.getValue(DefaultField.SupplyField.SUPPLANTAG.getName())));
        long planTag = 0L;
        if (supply.getValue(DefaultField.SupplyField.SUPPLANTAG.getName()) != null) {
            planTag = (Long)MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.SUPPLANTAG.getName()), (Object)0L);
        }
        entry.put("cache_supplantag", planTag);
        entry.put("suptracknumber", supply.getValue(DefaultField.SupplyField.TRACKNUMBER.getName()));
        entry.put("supplystorage", supply.getValue(DefaultField.SupplyField.OWNER.getName()));
        entry.put("supplyauxpty", supply.getValue(DefaultField.SupplyField.MATERIALFLEXPROPS.getName()));
        entry.put("copsupply", String.valueOf(supply.getValue(DefaultField.SupplyField.COPSUPPLY.getName())));
        if (ResManager.loadKDString((String)"\u65b0\u5efa\u8ba1\u5212\u8ba2\u5355\uff08\u8054\u526f\u4ea7\u54c1\uff09", (String)"MRPDataBalanceResolver_5", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0]).equals(supplyType)) {
            entry.put("copsupply", Character.valueOf('1'));
        }
        entry.put("supflexmetricid", supply.getValue(DefaultField.SupplyField.FLEXMETRICID.getName()));
        entry.put("supflexmetricval", supply.getValue(DefaultField.SupplyField.FLEXMETRICVALUE.getName()));
        entry.put("supplyproject", supply.getValue(DefaultField.SupplyField.PROJECTNUMBER.getName()));
        entry.put("supplysupplier", supply.getValue(DefaultField.SupplyField.SUPPLIER.getName()));
        Long planScope = (Long)MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.PLANSCOPE.getName()), (Object)0L);
        entry.put("supplyplanscope", planScope <= 0L ? supply.getValue(DefaultField.SupplyField.DYNAMIC_PLANSCOPE.getName()) : planScope);
        entry.put("onworkqty4sup", supply.getBigDecimal(DefaultField.SupplyField.ONWORKQTY.getName()));
        entry.put("receiveqty4sup", supply.getBigDecimal(DefaultField.SupplyField.PICKEDQTY.getName()));
    }

    private static Object setPlanTag(IMRPEnvProvider ctx, Object obj) {
        String[] strs = ctx.getPlanTagInfo(String.valueOf(obj));
        return strs[1];
    }

    private static String buildSupplyDetail(RowData supply) {
        String bt = String.valueOf(supply.getValue(DefaultField.SupplyField.BILL_ENTITY.getName()));
        StringBuilder sb = new StringBuilder();
        if ("pm_purapplybill".equals(bt)) {
            sb.append("PR");
            MRPDataBalanceResolver.appendValue(supply, DefaultField.SupplyField.BILLNUMBER, sb);
            MRPDataBalanceResolver.appendValue(supply, DefaultField.SupplyField.BILLENTRYSEQ, sb);
        } else if ("pm_purorderbill".equals(bt)) {
            sb.append("PO");
            MRPDataBalanceResolver.appendValue(supply, DefaultField.SupplyField.BILLNUMBER, sb);
            MRPDataBalanceResolver.appendValue(supply, DefaultField.SupplyField.BILLENTRYSEQ, sb);
        } else if ("im_inv_realbalance".equals(bt)) {
            sb.append("OH");
            MRPDataBalanceResolver.appendValue(supply, DefaultField.SupplyField.WAREHOUSENAME, sb);
            MRPDataBalanceResolver.appendValue(supply, DefaultField.SupplyField.LOCATIONNAME, sb);
        } else if ("pom_mftorder".equals(bt)) {
            sb.append("WIP");
            MRPDataBalanceResolver.appendValue(supply, DefaultField.SupplyField.BILLNUMBER, sb);
            MRPDataBalanceResolver.appendValue(supply, DefaultField.SupplyField.BILLENTRYSEQ, sb);
        } else if ("pom_mftstock".equals(bt)) {
            sb.append("WIP_R");
            MRPDataBalanceResolver.appendValue(supply, DefaultField.SupplyField.BILLNUMBER, sb);
            MRPDataBalanceResolver.appendValue(supply, DefaultField.SupplyField.BILLENTRYSEQ, sb);
        } else {
            sb.append(supply.getValue(DefaultField.SupplyField.BILLNUMBER.getName()));
            MRPDataBalanceResolver.appendValue(supply, DefaultField.SupplyField.BILLENTRYSEQ, sb);
        }
        return sb.toString();
    }

    private static void appendValue(RowData supply, DefaultField.SupplyField field, StringBuilder sb) {
        sb.append('_');
        if (supply.getValue(field.getName()) != null) {
            sb.append(supply.getValue(field.getName()));
        } else {
            sb.append(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e", (String)"MRPDataBalanceResolver_4", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0]));
        }
    }
}

