/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.calcnode.framework.mq.resolver.cps;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.framework.mq.event.MRPEvent;
import kd.mmc.mrp.framework.mq.resolver.IEventResolver;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.MultiThreadCacheKey;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.table.res.RequirementDataTable;
import kd.mmc.mrp.model.table.res.SupplymentDataTable;
import kd.mmc.mrp.utils.MRPUtil;

public class CPSWIPSupply2RequireResolver
implements IEventResolver {
    private static final Log logger = LogFactory.getLog(CPSWIPSupply2RequireResolver.class);

    public void execute(MRPEvent event, IMRPEnvProvider ctx) {
        this.restoreImpl(ctx, event);
        ctx.supplyDatas().clear();
        ctx.requireDatas().clear();
    }

    private void restoreImpl(IMRPEnvProvider ctx, MRPEvent event) {
        String mId = String.valueOf(event.getParam(MultiThreadCacheKey.KEY_MATERIAL_ID));
        Map map = MRPCacheManager.getInst().getSubDataMap((CalEnv)ctx, "supply-" + mId);
        if (map != null) {
            List<String> supplyBills = Arrays.asList("pom_mftorder", "om_mftorder", "mrp_planorder", "pm_om_purorderbill");
            HashSet<Object> orderEntrys = new HashSet<Object>(map.size());
            boolean isSelectBillPlan = Boolean.parseBoolean(String.valueOf(event.getParam(MultiThreadCacheKey.KEY_IS_SELECT_MATERIAL_PLAN)));
            String entity = event.getParam(MultiThreadCacheKey.KEY_ENTITY_NUMBER).toString();
            ArrayList li = new ArrayList(16);
            for (Map.Entry entry : map.entrySet()) {
                String jsonStr;
                String[] splits = MRPRuntimeConsts.splitDataKey((String)((String)entry.getKey()));
                ctx.restoreTableDatas(splits[0], splits[1], mId, JSON.parseArray((String)((String)entry.getValue()), Object[].class), false);
                if (!isSelectBillPlan || (jsonStr = MRPCacheManager.getInst().getSubData((CalEnv)ctx, "selectbills", MRPRuntimeConsts.getSelectBillDataKey((String)ctx.getMRPContextId(), (Object)splits[1]))) == null) continue;
                List list = JSON.parseArray((String)jsonStr, Object[].class);
                li.addAll(list);
            }
            SupplymentDataTable supplys = ctx.supplyDatas();
            ArrayList<RowData> needCalcList = new ArrayList<RowData>(16);
            ArrayList<RowData> notCalcList = new ArrayList<RowData>(16);
            logger.warn(String.format("CPSWIPSupply2RequireResolver-mrprunner-ctxid:%s,size:%s", ctx.getMRPContextId(), supplys.size()));
            for (int i = 0; i < supplys.size(); ++i) {
                RowData row = supplys.fetchRow(i);
                Iterator object = row.get(DefaultField.SupplyField.BILL_ENTITY.getName());
                Object billId = row.get(DefaultField.SupplyField.BILLID.getName());
                Object billEntryId = row.get(DefaultField.SupplyField.BILLENTRYID.getName());
                Boolean isOnWork = MRPUtil.convert((Object)row.get(DefaultField.SupplyField.ISONWORK.getName()), (Boolean)Boolean.FALSE);
                if (!supplyBills.contains(object) || !entity.equals(object) || !isOnWork.booleanValue()) continue;
                boolean flag = false;
                if (isSelectBillPlan) {
                    for (int j = 0; j < li.size(); ++j) {
                        if (!billId.equals(((Object[])li.get(j))[0]) || !billEntryId.equals(((Object[])li.get(j))[1])) continue;
                        logger.warn(String.format("CPSWIPSupply2RequireResolver-mrprunner-ctxid:%s,row:%s", ctx.getMRPContextId(), row.toString()));
                        needCalcList.add(row);
                        flag = true;
                        break;
                    }
                    if (!flag) {
                        notCalcList.add(row);
                    }
                } else {
                    needCalcList.add(row);
                }
                if ("mrp_planorder".equals(object)) {
                    orderEntrys.add(billId);
                    continue;
                }
                orderEntrys.add(billEntryId);
            }
            if (!needCalcList.isEmpty() || !notCalcList.isEmpty()) {
                PlanModel service = (PlanModel)ctx.getService(PlanModel.class);
                RequirementDataTable requireDatas = new RequirementDataTable((CalEnv)ctx, new HashSet());
                requireDatas.getColIdx().putAll(ctx.requireDatas().getColIdx());
                map = MRPCacheManager.getInst().getSubDataMap((CalEnv)ctx, "require-" + mId);
                if (map != null) {
                    for (Map.Entry entry : map.entrySet()) {
                        String[] splits = MRPRuntimeConsts.splitDataKey((String)((String)entry.getKey()));
                        ctx.restoreTableDatas(splits[0], splits[1], mId, JSON.parseArray((String)((String)entry.getValue()), Object[].class), true);
                    }
                }
                Map wipSupply2Require = service.getWipSupply2Require();
                int i = 0;
                for (RowData row : needCalcList) {
                    RequireRowData require = new RequireRowData(requireDatas.getSrcDatas(), Integer.valueOf(requireDatas.size() + ++i), requireDatas.getColIdx(), new Object[requireDatas.getColIdx().size()]);
                    wipSupply2Require.forEach((k, v) -> require.update(k, row.get(v)));
                    require.update(DefaultField.CommonField.__MODEL_NUMBER__.name(), row.get(DefaultField.CommonField.__MODEL_NUMBER__.name()));
                    require.update(DefaultField.CommonField.__MODEL_ID__.name(), row.get(DefaultField.CommonField.__MODEL_ID__.name()));
                    require.update(DefaultField.RequireField.__ISONWORK__.getName(), (Object)true);
                    require.update(DefaultField.RequireField.BILL_ENTITY.getName(), row.get(DefaultField.SupplyField.BILL_ENTITY.getName()));
                    require.update(DefaultField.RequireField.__IS_CALC_REQUIRE__.getName(), (Object)true);
                    requireDatas.fill((RowData)require);
                    logger.warn(String.format("CPSWIPSupply2RequireResolver-mrprunner-ctxid:%s,require:%s", ctx.getMRPContextId(), require.toString()));
                }
                for (RowData row : notCalcList) {
                    RequireRowData require = new RequireRowData(requireDatas.getSrcDatas(), Integer.valueOf(requireDatas.size() + ++i), requireDatas.getColIdx(), new Object[requireDatas.getColIdx().size()]);
                    wipSupply2Require.forEach((k, v) -> require.update(k, row.get(v)));
                    require.update(DefaultField.CommonField.__MODEL_NUMBER__.name(), row.get(DefaultField.CommonField.__MODEL_NUMBER__.name()));
                    require.update(DefaultField.CommonField.__MODEL_ID__.name(), row.get(DefaultField.CommonField.__MODEL_ID__.name()));
                    require.update(DefaultField.RequireField.__ISONWORK__.getName(), (Object)true);
                    require.update(DefaultField.RequireField.BILL_ENTITY.getName(), row.get(DefaultField.SupplyField.BILL_ENTITY.getName()));
                    require.update(DefaultField.RequireField.__IS_CALC_REQUIRE__.getName(), (Object)false);
                    requireDatas.fill((RowData)require);
                    logger.warn(String.format("CPSWIPSupply2RequireResolver-mrprunner-ctxid:%s,require:%s", ctx.getMRPContextId(), require.toString()));
                }
                int size = requireDatas.getSrcDatas().getDatas().size();
                ArrayList<Object[]> datas = new ArrayList<Object[]>(size);
                for (int j = 0; j < size; ++j) {
                    datas.add(requireDatas.getSrcDatas().getDatas().get(j));
                }
                logger.warn(String.format("CPSWIPSupply2RequireResolver-mrprunner-ctxid:%s,datas.size:%s", ctx.getMRPContextId(), datas.size()));
                String cacheKey = MRPRuntimeConsts.getDataKey((String)event.getEventId(), null, (String)mId);
                MRPCacheManager.getInst().putSubData((CalEnv)ctx, "require-" + mId, cacheKey, JSON.toJSONString(datas, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
            }
            if (!orderEntrys.isEmpty()) {
                MRPCacheManager.getInst().putData((CalEnv)ctx, MRPRuntimeConsts.getCPSOrderEntryIds((String)event.getEventId()), JSON.toJSONString(orderEntrys, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
            }
        }
    }
}

