/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.calcnode.framework.mq.resolver.query;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.xdb.QueryTimeout;
import kd.mmc.mrp.calcnode.framework.ext.IUpdateMRPResDataQueryDataSet;
import kd.mmc.mrp.calcnode.framework.ext.UpdateMRPResDataQueryDataSetImpl;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPDataSourceResolver;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.framework.mq.event.MRPEvent;
import kd.mmc.mrp.framework.mq.resolver.IEventResolver;
import kd.mmc.mrp.model.enums.MultiThreadCacheKey;
import kd.mmc.mrp.model.wrapper.DynamicRowSet;
import kd.mmc.mrp.utils.MRPUtil;

abstract class AbstractMRPResDataQueryResolver
implements IEventResolver {
    protected static final Log logger = LogFactory.getLog(AbstractMRPResDataQueryResolver.class);
    protected String modelId;
    protected IMRPEnvProvider ctx;
    protected MRPEvent event;
    protected String prefix;
    protected long startTs = System.currentTimeMillis();

    AbstractMRPResDataQueryResolver() {
    }

    public void execute(MRPEvent event, IMRPEnvProvider ctx) {
        this.ctx = ctx;
        this.event = event;
        this.modelId = event.getParam(MultiThreadCacheKey.KEY_MODEL_ID).toString();
        Serializable filterStr = event.getParam(MultiThreadCacheKey.KEY_RES_CUSTOM_FILTER);
        String filter = filterStr == null ? null : filterStr.toString();
        boolean isSelectMaterialPlan = MRPUtil.convert((Object)event.getParam(MultiThreadCacheKey.KEY_IS_SELECT_MATERIAL_PLAN), (Boolean)Boolean.FALSE);
        Set<String> metaCols = this.getMetaKeyCols(ctx);
        logger.warn(String.format("ctxid: %s, evtid: %s, mrprunner evtid: %s, modelid: %s, resolver: %s", ctx.getMRPContextId(), event.getEventId(), event.getEventId(), this.modelId, this.getClass().getName()));
        long start = System.currentTimeMillis();
        DynamicRowSet rs = ctx.createDataFetcher().fetchDatas(this.modelId, metaCols, filter, "supply-".equals(this.prefix) || isSelectMaterialPlan);
        logger.warn(String.format("ctxid: %s, evtid: %s, mrprunner-fetchdatas evtid: %s, timecost: %s, resolver: %s", ctx.getMRPContextId(), event.getEventId(), event.getEventId(), System.currentTimeMillis() - start, this.getClass().getName()));
        start = System.currentTimeMillis();
        try (QueryTimeout timeout = DB.timeout((int)1200);){
            this.saveDatas(rs.getMetas(), rs.getData(), metaCols, ctx.getDataSourceResolver(), rs.getModelId(), rs.getModelNumber());
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("mrprunner-dataset-execute-failed: %s.%s", rs.getModelId(), rs.getModelNumber()), e);
        }
        finally {
            rs.getData().close();
        }
        logger.warn(String.format("ctxid: %s, evtid: %s, mrprunner-savedatas evtid: %s, timecost: %s, resolver: %s", ctx.getMRPContextId(), event.getEventId(), event.getEventId(), System.currentTimeMillis() - start, this.getClass().getName()));
    }

    protected abstract Set<String> getMetaKeyCols(IMRPEnvProvider var1);

    protected void prepare(String[] metas) {
    }

    protected void visitRow(Object[] row) {
    }

    protected void finish() {
    }

    private DataSet updateDataSet(DataSet ds, String resId, String resNumber) {
        UpdateMRPResDataQueryDataSetImpl defPlugin = new UpdateMRPResDataQueryDataSetImpl();
        PluginProxy pluginProxy = PluginProxy.create((Object)defPlugin, IUpdateMRPResDataQueryDataSet.class, (String)"MRP_DATA_QUERY_UPDATE", null);
        List dataSets = pluginProxy.callReplaceIfPresent(p -> p.updateDataSet(this.ctx, ds, resId, resNumber));
        return (DataSet)dataSets.get(0);
    }

    private void saveDatas(String[] metas, DataSet ds, Set<String> metaCols, IMRPDataSourceResolver dataResolver, String resId, String resNumber) {
        ds = this.updateDataSet(ds, resId, resNumber);
        this.prepare(metas);
        MRPCacheManager.getInst().putData((CalEnv)this.ctx, this.modelId, this.event.getEventId());
        MRPCacheManager.getInst().putData((CalEnv)this.ctx, MRPRuntimeConsts.getMetaKey((String)this.event.getEventId(), (String)this.modelId), JSON.toJSONString((Object)metas, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
        HashSet<String> groups = new HashSet<String>();
        int rowCount = 0;
        StringBuilder metaKey = new StringBuilder();
        ArrayList<Object[]> datas = null;
        String lastRowKey = null;
        HashMap<String, Integer> rcBuffer = new HashMap<String, Integer>(7);
        HashMap<String, Integer> colIdx = new HashMap<String, Integer>(0);
        if (dataResolver != null) {
            for (int i = 0; i < metas.length; ++i) {
                colIdx.put(metas[i], i);
            }
        }
        while (ds.hasNext()) {
            Row data = ds.next();
            if (dataResolver != null && !dataResolver.isValidRowData(resId, resNumber, data)) continue;
            ++rowCount;
            metaKey.setLength(0);
            for (String label : metaCols) {
                if (metaKey.length() != 0) {
                    metaKey.append('\u0001');
                }
                metaKey.append(data.get(label));
            }
            String rowKey = metaKey.toString();
            if (datas == null || !rowKey.equals(lastRowKey)) {
                if (datas != null && !datas.isEmpty()) {
                    MRPCacheManager.getInst().putSubData((CalEnv)this.ctx, this.prefix + lastRowKey, MRPRuntimeConsts.getDataKey((String)this.event.getEventId(), (String)this.modelId, (String)""), JSON.toJSONString(datas, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
                    rcBuffer.put(lastRowKey, datas.size());
                }
                datas = new ArrayList<Object[]>();
                lastRowKey = rowKey;
                groups.add(rowKey);
            }
            Object[] row = new Object[metas.length];
            for (int i = 0; i < row.length; ++i) {
                Object val;
                String label = metas[i];
                row[i] = val = data.get(label);
            }
            this.visitRow(row);
            if (dataResolver != null) {
                datas.addAll(dataResolver.splitRowData(this.ctx, resId, colIdx, row));
                continue;
            }
            datas.add(row);
        }
        if (datas != null && !datas.isEmpty()) {
            MRPCacheManager.getInst().putSubData((CalEnv)this.ctx, this.prefix + lastRowKey, MRPRuntimeConsts.getDataKey((String)this.event.getEventId(), (String)this.modelId, (String)""), JSON.toJSONString(datas, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
            rcBuffer.put(lastRowKey, datas.size());
        }
        MRPCacheManager.getDStore((String)this.ctx.getMRPContextId()).mapMSet(MRPRuntimeConsts.getSummarizeKey((String)this.ctx.getMRPContextId()), rcBuffer);
        MRPCacheManager.getInst().putData((CalEnv)this.ctx, MRPRuntimeConsts.getSeparateKey((String)this.event.getEventId(), (String)this.modelId), JSON.toJSONString(groups, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
        MRPCacheManager.getInst().putData((CalEnv)this.ctx, MRPRuntimeConsts.getQueryModelRowCountKey((String)this.modelId), JSON.toJSONString((Object)rowCount));
        MRPCacheManager.getInst().putData((CalEnv)this.ctx, MRPRuntimeConsts.getQueryModelTimeCostKey((String)this.modelId), JSON.toJSONString((Object)((double)(System.currentTimeMillis() - this.startTs) / 1000.0 / 60.0)));
        MRPCacheManager.getInst().putData((CalEnv)this.ctx, MRPRuntimeConsts.getMetaColsKey((String)this.event.getEventId(), (String)this.modelId), JSON.toJSONString(new ArrayList<String>(metaCols), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
        this.finish();
    }
}

