/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.calcnode.framework.mq.resolver.save;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.framework.mq.event.MRPEvent;
import kd.mmc.mrp.framework.mq.resolver.IEventResolver;
import kd.mmc.mrp.integrate.entity.RequireDataModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.enums.MultiThreadCacheKey;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.utils.MRPUtil;
import kd.mmc.mrp.utils.ReserveUtil;

public class MRPDataSaveResolver
implements IEventResolver {
    private static Log logger = LogFactory.getLog(MRPDataSaveResolver.class);

    public void execute(MRPEvent event, IMRPEnvProvider ctx) {
        try (TXHandle h = TX.notSupported((String)"MRPDataSaveResolver.execute");){
            String method = String.valueOf(event.getParam(MultiThreadCacheKey.KEY_MODEL_ID));
            RequireDataModel require = (RequireDataModel)ctx.getService(RequireDataModel.class);
            String outputType = require.getOutputType();
            String outputCollaborativeorder = require.getOutputCollaborativeorder();
            if ("1".equals(ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                logger.warn("mrprunner-MRPDataSaveResolver: " + method);
            }
            if ("po".equals(method)) {
                this.savePO(event, ctx);
            } else if ("detail".equals(method)) {
                this.saveDetail(event, ctx);
            } else if ("simulate".equals(method)) {
                this.saveDetail(event, ctx, "mrp_simulationdetail");
            } else if ("po-clear".equals(method)) {
                this.clearBills(ctx, event, outputType);
            } else if ("colPlanBill-clear".equals(method)) {
                this.clearBills(ctx, event, outputCollaborativeorder);
            } else if ("invdetail".equals(method)) {
                this.saveDetail(event, ctx, "msplan_invlevel_detail");
            } else if ("reserve".equals(method)) {
                this.saveReserve(event, ctx);
            } else if ("mrp_cps_detail".equals(method) || "mrp_cps_shortage".equals(method)) {
                this.saveDetail(event, ctx, method);
            }
        }
    }

    private void saveReserve(MRPEvent event, IMRPEnvProvider ctx) {
        String materialId = String.valueOf(event.getParam(MultiThreadCacheKey.KEY_MATERIAL_ID));
        List allList = MRPCacheManager.getInst().getReserveCache((CalEnv)ctx, materialId);
        if (allList.isEmpty()) {
            return;
        }
        HashSet removePlanOrders = new HashSet(16);
        Map jsonMap = MRPCacheManager.getInst().getSubDataMap((CalEnv)ctx, "reserve_record_po_removee");
        if (jsonMap != null) {
            for (Map.Entry entry : jsonMap.entrySet()) {
                removePlanOrders.addAll(JSON.parseArray((String)((String)entry.getValue()), String.class));
            }
        }
        HashMap<String, List> removeListMap = new HashMap<String, List>(16);
        ListIterator its = allList.listIterator();
        while (its.hasNext()) {
            Map record = (Map)its.next();
            String isDependReqReserve = String.valueOf(record.get("isDependReqReserve"));
            if (!"1".equalsIgnoreCase(isDependReqReserve)) continue;
            String key = String.format("%s\u0001%s\u0001%s\u0001%s", record.get("ori_bill_obj"), record.get("ori_bill_id"), record.get("ori_billentry_id"), record.get("r_sale_org"));
            List removeList = removeListMap.computeIfAbsent(key, k -> new ArrayList(16));
            removeList.add(record);
            its.remove();
        }
        int actSize = ReserveUtil.createReserveRecord((IMRPEnvProvider)ctx, (List)allList, removePlanOrders);
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"msplan_net_change_record");
        MainEntityType reserveEntityType = MetadataServiceHelper.getDataEntityType((String)"msmod_reserve_record");
        MainEntityType mrpEntityType = MetadataServiceHelper.getDataEntityType((String)"mrp_net_change_detail");
        String updateSql = String.format("update %s set f_bill_obj_id = ?,f_bill_no = ?,f_bill_id = ?,f_billentry_id = ?,f_billentry_seq = ?,f_base_qty = ?,f_qty = ?,fisdepend = '0' where fid = ?", entityType.getAlias());
        String updateReserveSql = String.format("update %s set f_bill_obj_id = ?,f_bill_no = ?,f_bill_id = ?,f_billentry_id = ?,f_billentry_seq = ?,f_base_qty = ?,f_qty = ? where fid = ?", reserveEntityType.getAlias());
        String updateMRPSql = String.format("update %s set f_ori_qty = ?,f_base_qty = 0,ftype = '0' where fid = ?", mrpEntityType.getAlias());
        QFilter qFilterMaterial = new QFilter("s_materiel", "=", (Object)Long.parseLong(materialId));
        ArrayList<Object[]> params = new ArrayList<Object[]>(removeListMap.size());
        ArrayList<Object[]> mrpParams = new ArrayList<Object[]>(removeListMap.size());
        ArrayList<DynamicObject> mrpSaves = new ArrayList<DynamicObject>(removeListMap.size());
        HashSet<Long> handledRecord = new HashSet<Long>(4);
        QFilter qFilterRemove = new QFilter("id", "not in", handledRecord);
        for (Map.Entry entry : removeListMap.entrySet()) {
            List removeList = (List)entry.getValue();
            String[] req = ((String)entry.getKey()).split("\u0001");
            if (req.length != 4) continue;
            QFilter qFilterBill_obj = new QFilter("bill_obj", "=", (Object)req[0]);
            QFilter qFilterBill_id = new QFilter("bill_id", "=", MRPUtil.convert((Object)req[1], (Object)0L));
            QFilter qFilterBillentry_id = new QFilter("billentry_id", "=", MRPUtil.convert((Object)req[2], (Object)0L));
            QFilter qFilterOrg = new QFilter("r_sale_org", "=", MRPUtil.convert((Object)req[3], (Object)0L));
            QFilter qFilterDepend = new QFilter("isdepend", "=", (Object)Boolean.TRUE);
            QFilter qFilterQty = new QFilter("base_qty", ">", (Object)BigDecimal.ZERO);
            for (Map param : removeList) {
                DynamicObject[] mrpCacheDatas;
                BigDecimal base_qty = (BigDecimal)MRPUtil.convert(param.get("base_qty"), (Object)BigDecimal.ZERO);
                QFilter qFilterBal_obj = new QFilter("bal_obj", "=", MRPUtil.convert(param.get("bal_obj"), (Object)""));
                QFilter qFilterBal_id = new QFilter("bal_id", "=", MRPUtil.convert(param.get("bal_id"), (Object)0L));
                QFilter qFilterBal_entryid = new QFilter("bal_entryid", "=", MRPUtil.convert(param.get("bal_entryid"), (Object)0L));
                ArrayList<Long> redIds = new ArrayList<Long>(2);
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getSimpleName(), (String)"msplan_net_change_record", (String)"id,base_qty", (QFilter[])new QFilter[]{qFilterMaterial, qFilterBill_obj, qFilterBill_id, qFilterBillentry_id, qFilterOrg, qFilterDepend, qFilterRemove, qFilterQty, qFilterBal_obj, qFilterBal_id, qFilterBal_entryid}, null);){
                    ArrayList<DynamicObject> saves = new ArrayList<DynamicObject>(4);
                    ArrayList<DynamicObject> saveReserves = new ArrayList<DynamicObject>(4);
                    for (Row row : dataSet) {
                        if (base_qty.compareTo(BigDecimal.ZERO) <= 0) break;
                        Long record_id = row.getLong("id");
                        BigDecimal qty = row.getBigDecimal("base_qty");
                        if ((base_qty = base_qty.subtract(qty)).compareTo(BigDecimal.ZERO) < 0) {
                            BigDecimal surplus = base_qty.abs();
                            qty = qty.subtract(surplus);
                            DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)record_id, (DynamicObjectType)entityType);
                            data = (DynamicObject)OrmUtils.clone((Object)data, (IDataEntityType)entityType, (boolean)true, (boolean)true);
                            long newId = ReserveUtil.getGlobeLongId();
                            data.set("id", (Object)newId);
                            data.set("base_qty", (Object)surplus);
                            data.set("qty", (Object)surplus);
                            data.set("ori_qty", (Object)surplus);
                            saves.add(data);
                            if (QueryServiceHelper.exists((String)"msmod_reserve_record", (Object)record_id)) {
                                DynamicObject reserveData = BusinessDataServiceHelper.loadSingle((Object)record_id, (DynamicObjectType)reserveEntityType);
                                reserveData = (DynamicObject)OrmUtils.clone((Object)reserveData, (IDataEntityType)reserveEntityType, (boolean)true, (boolean)true);
                                reserveData.set("id", (Object)newId);
                                reserveData.set("base_qty", (Object)surplus);
                                reserveData.set("qty", (Object)surplus);
                                saveReserves.add(reserveData);
                            }
                        }
                        Object[] p = new Object[]{param.get("bill_obj"), param.get("bill_no"), param.get("bill_id"), param.get("billentry_id"), param.get("billentry_seq"), qty, qty, record_id};
                        params.add(p);
                        handledRecord.add(record_id);
                        redIds.add(record_id);
                    }
                    if (!saves.isEmpty()) {
                        SaveServiceHelper.save((DynamicObject[])saves.toArray(new DynamicObject[0]));
                    }
                    if (!saveReserves.isEmpty()) {
                        SaveServiceHelper.save((DynamicObject[])saveReserves.toArray(new DynamicObject[0]));
                    }
                }
                QFilter qFilterType = new QFilter("type", "=", (Object)"1");
                qFilterType.and(new QFilter("record_id", "in", redIds));
                ArrayList<Long> pkIds = new ArrayList<Long>(redIds.size());
                DynamicObject[] dynamicObjectArray = null;
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getSimpleName(), (String)"mrp_net_change_detail", (String)"id,base_qty", (QFilter[])new QFilter[]{qFilterType}, null);){
                    while (dataSet.hasNext()) {
                        Row row = dataSet.next();
                        Object[] p = new Object[2];
                        p[0] = row.getBigDecimal("base_qty");
                        Long pkId = row.getLong("id");
                        p[1] = pkId;
                        mrpParams.add(p);
                        pkIds.add(pkId);
                    }
                }
                catch (Throwable object) {
                    dynamicObjectArray = object;
                    throw object;
                }
                if (pkIds.isEmpty()) continue;
                for (DynamicObject mrpCacheData : mrpCacheDatas = BusinessDataServiceHelper.load((Object[])pkIds.toArray(), (DynamicObjectType)mrpEntityType)) {
                    mrpCacheData = (DynamicObject)OrmUtils.clone((Object)mrpCacheData, (IDataEntityType)mrpEntityType, (boolean)true, (boolean)true);
                    DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"bos_billmainentity");
                    obj.set("id", param.get("bill_obj"));
                    mrpCacheData.set("bill_obj", (Object)obj);
                    mrpCacheData.set("bill_no", param.get("bill_no"));
                    mrpCacheData.set("bill_id", param.get("bill_id"));
                    mrpCacheData.set("billentry_id", param.get("billentry_id"));
                    mrpCacheData.set("billentry_seq", param.get("billentry_seq"));
                    mrpSaves.add(mrpCacheData);
                }
            }
        }
        if (!params.isEmpty()) {
            DB.executeBatch((DBRoute)new DBRoute(entityType.getDBRouteKey()), (String)updateSql, params);
            DB.executeBatch((DBRoute)new DBRoute(entityType.getDBRouteKey()), (String)updateReserveSql, params);
        }
        if (!mrpParams.isEmpty()) {
            DB.executeBatch((DBRoute)new DBRoute(mrpEntityType.getDBRouteKey()), (String)updateMRPSql, mrpParams);
            SaveServiceHelper.save((DynamicObject[])mrpSaves.toArray(new DynamicObject[0]));
        }
        event.setParam(MultiThreadCacheKey.KEY_REPLY_SAVE_COUNT, (Serializable)Integer.valueOf(actSize));
    }

    private void savePO(MRPEvent event, IMRPEnvProvider ctx) {
        ORM orm = ORM.create();
        String materialId = String.valueOf(event.getParam(MultiThreadCacheKey.KEY_MATERIAL_ID));
        ArrayList<Long> check = new ArrayList<Long>(ctx.getAllPlanTags());
        if (check.isEmpty()) {
            check.add(0L);
        }
        int actSize = 0;
        int batchSize = (Integer)ctx.getCfgValue(EnvCfgItem.PLAN_ORDER_SAVE_BATCH);
        Iterator allListIter = MRPCacheManager.getInst().getPlanOrders((CalEnv)ctx, materialId);
        if (!allListIter.hasNext()) {
            if ("1".equals(ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                logger.warn(String.format("mrprunner-saveplanorders-find-empty, mid: %s", materialId));
            }
            return;
        }
        RequireDataModel require = (RequireDataModel)ctx.getService(RequireDataModel.class);
        String outputType = require.getOutputType();
        String outputCollaborativeorder = require.getOutputCollaborativeorder();
        ArrayList batchPOList = new ArrayList(batchSize);
        ArrayList<DynamicObject> batchInsertObjectList = new ArrayList<DynamicObject>(batchSize);
        Map map = MRPCacheManager.getInst().getSubDataMap((CalEnv)ctx, MRPRuntimeConsts.getReplacePlanOrderKey((String)materialId));
        while (allListIter.hasNext()) {
            batchPOList.clear();
            batchInsertObjectList.clear();
            for (int j = 0; j < batchSize && allListIter.hasNext(); ++j) {
                batchPOList.add(allListIter.next());
            }
            for (Map po : batchPOList) {
                String tag = String.valueOf(po.get("plantags"));
                if ("null".equals(tag) || StringUtils.isBlank((String)tag)) {
                    tag = "0";
                }
                if (!check.contains(Long.valueOf(tag))) continue;
                DynamicObject poHeader = orm.newDynamicObject(outputType);
                batchInsertObjectList.add(poHeader);
                Object replaceKey = po.remove(DefaultField.RequireField.__REPLACE_KEY__.getName());
                boolean isReplaceOrder = map != null && !map.isEmpty() && replaceKey != null;
                Iterator its = po.entrySet().iterator();
                boolean isPlanOrder = require.isPlanOrderExtendEntity();
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)outputType);
                while (its.hasNext()) {
                    Map.Entry entry = its.next();
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (value instanceof BigDecimal) {
                        value = ((BigDecimal)value).setScale(10, RoundingMode.DOWN);
                    }
                    if ("entryentity".equals(key) || "copentry".equals(key) || value instanceof String && StringUtils.isEmpty((String)value.toString()) || dataEntityType.findProperty(key) == null) continue;
                    poHeader.set(key, value);
                }
                if (dataEntityType.findProperty("auxproperty") != null) {
                    poHeader.set("auxproperty", po.get("auxproperty"));
                }
                if (!isPlanOrder) continue;
                List entrys = (List)po.get("entryentity");
                if (entrys != null) {
                    if (isReplaceOrder) {
                        ArrayList result = new ArrayList(16);
                        Iterator it = entrys.iterator();
                        while (it.hasNext()) {
                            Map poEntry = (Map)it.next();
                            String poEntryKey = MRPRuntimeConsts.getReplacePlanOrderSubKey((String)ctx.getMRPContextId(), (String)replaceKey.toString(), (String)String.valueOf(po.get("bom")), (String)String.valueOf(poEntry.get("entryreplaceplan")));
                            String cacheValue = (String)map.get(poEntryKey);
                            if (cacheValue == null) continue;
                            List values = JSON.parseArray((String)cacheValue, Object[].class);
                            ArrayList<RequireRowData> requireValues = new ArrayList<RequireRowData>(values.size());
                            for (Object[] v : values) {
                                requireValues.add(new RequireRowData(ctx.requireDatas().getSrcDatas(), Integer.valueOf(-1), ctx.requireDatas().getColIdx(), v));
                            }
                            result.addAll(requireValues);
                            it.remove();
                        }
                        ctx.createMappingSaver().createFabPOEntry(ctx, po, entrys, result);
                    }
                    this.createPoEntry(entrys, orm, "entryentity", poHeader, outputType, dataEntityType);
                }
                if ((entrys = (List)po.get("copentry")) == null) continue;
                this.createPoEntry(entrys, orm, "copentry", poHeader, outputType, dataEntityType);
            }
            if (batchInsertObjectList.isEmpty()) continue;
            actSize += batchInsertObjectList.size();
            orm.insert(batchInsertObjectList);
        }
        if ("1".equals(ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("ctxid: %s, mrprunner-savePO, mid: %s, resolves: %s", ctx.getMRPContextId(), materialId, actSize));
        }
        event.setParam(MultiThreadCacheKey.KEY_REPLY_SAVE_COUNT, (Serializable)Integer.valueOf(actSize));
    }

    private void createPoEntry(List<?> entrys, ORM orm, String entryKey, DynamicObject poHeader, String outputType, MainEntityType dataEntityType) {
        for (int j = 0; j < entrys.size(); ++j) {
            DynamicObject poEntry = this.newDynamicObject(orm, outputType + '.' + entryKey);
            Map entry = (Map)entrys.get(j);
            for (Map.Entry it : entry.entrySet()) {
                Object key = it.getKey();
                Object value = it.getValue();
                if (value instanceof BigDecimal) {
                    value = ((BigDecimal)value).setScale(10, RoundingMode.DOWN);
                }
                if (value instanceof String && StringUtils.isEmpty((String)value.toString()) || dataEntityType.findProperty(String.valueOf(key)) == null) continue;
                poEntry.set(String.valueOf(key), value);
            }
            if (entry.get("entryauxproperty") != null && dataEntityType.findProperty("entryauxproperty") != null) {
                poEntry.set("entryauxproperty", entry.get("entryauxproperty"));
            }
            if (entry.get("copentryauxproperty") != null && dataEntityType.findProperty("copentryauxproperty") != null) {
                poEntry.set("copentryauxproperty", entry.get("copentryauxproperty"));
            }
            poHeader.getDynamicObjectCollection(entryKey).add((Object)poEntry);
        }
    }

    private DynamicObject newDynamicObject(ORM orm, String entityKey) {
        return orm.newDynamicObject(entityKey);
    }

    private void saveDetail(MRPEvent event, IMRPEnvProvider ctx) {
        this.saveDetail(event, ctx, "mrp_calcdetail");
    }

    /*
     * WARNING - void declaration
     */
    private void saveDetail(MRPEvent event, IMRPEnvProvider ctx, String detailEntityKey) {
        int detailSize = 0;
        String materialId = String.valueOf(event.getParam(MultiThreadCacheKey.KEY_MATERIAL_ID));
        Long headId = Long.valueOf(String.valueOf(event.getParam(MultiThreadCacheKey.KEY_PO_HEAD_ID)));
        Iterator datas = MRPCacheManager.getInst().getMaterialDetails2((CalEnv)ctx, materialId);
        if (!datas.hasNext()) {
            if ("1".equals(ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                logger.warn(String.format("mrprunner-savedetails-find-empty, mid: %s", materialId));
            }
            return;
        }
        AppParam appParam = new AppParam("0MBBBZ1L5IAW", Long.valueOf(ctx.getPlanOrgId()));
        Map mrpParam = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        boolean isGenRequireRunRecord = "mrp_calcdetail".equals(detailEntityKey) && MRPUtil.convert(mrpParam.get("isgenreqcalcrecord"), (Boolean)Boolean.FALSE) != false;
        HashMap reqcalc_records = new HashMap(16);
        HashSet<Object> billEntryIds = new HashSet<Object>(16);
        HashSet<Object> billIds = new HashSet<Object>(16);
        String updateSql = "update t_mrp_reqcalc_record set flast_runlogno = ? , flast_runtime = ? where fid = ?";
        Date nowDate = new Date();
        DBRoute scmRoute = DBRoute.of((String)"scm");
        ORM orm = ORM.create();
        IDataEntityType dt = orm.newDynamicObject(detailEntityKey + '.' + "entryentity").getDataEntityType();
        DataEntityPropertyCollection c = dt.getProperties();
        HashMap<String, StringBuilder> sqls = new HashMap<String, StringBuilder>();
        HashMap args = new HashMap();
        HashMap<String, List> oneRow = new HashMap<String, List>();
        int size = 0;
        String count = MRPCacheManager.getInst().getData((CalEnv)ctx, MRPRuntimeConsts.getBalanceSplitKey((String)ctx.getMRPContextId(), (String)materialId));
        long[] genLongIds = orm.genLongIds(dt, Integer.parseInt(count));
        int x = 0;
        while (datas.hasNext()) {
            Map m = (Map)datas.next();
            if (isGenRequireRunRecord) {
                Object v = m.get("billid");
                Object billEntryId = m.get("billentryid");
                Object billNo = m.get("billno");
                Object v2 = m.get("demandbillf7");
                Object v3 = m.get("billentryseq");
                String key = String.format("%s-%s", v, billEntryId == null ? Long.valueOf(0L) : billEntryId);
                Object parentbomid = m.get("bomid");
                if ((parentbomid == null || "".equals(parentbomid.toString())) && v != null && !reqcalc_records.containsKey(key)) {
                    HashMap value = new HashMap(4);
                    value.put("bill_obj", v2);
                    value.put("bill_no", billNo);
                    value.put("billentry_seq", v3);
                    reqcalc_records.put(key, value);
                    billEntryIds.add(MRPUtil.convert(billEntryId, (Object)0L));
                    billIds.add(MRPUtil.convert(v, (Object)0L));
                }
            }
            sqls.clear();
            oneRow.clear();
            Iterator iterator = m.entrySet().iterator();
            Long entryId = genLongIds[x++];
            while (iterator.hasNext()) {
                void var32_57;
                void var32_54;
                void var32_51;
                IDataEntityProperty prop;
                Map.Entry it = iterator.next();
                Object k2 = it.getKey();
                Object v = it.getValue();
                if (v instanceof BigDecimal) {
                    BigDecimal bigDecimal = MRPUtil.toBigDecimal(v);
                }
                if ((prop = (IDataEntityProperty)c.get((Object)String.valueOf(k2))) == null) {
                    if (!"1".equals(ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) continue;
                    logger.warn("mrprunner-savecalcdetail-unknown-column: " + k2);
                    continue;
                }
                String tblName = StringUtils.isEmpty((String)prop.getTableGroup()) ? dt.getAlias() : dt.getAlias() + "_" + prop.getTableGroup();
                StringBuilder sql2 = (StringBuilder)sqls.get(tblName);
                if (sql2 == null) {
                    sql2 = new StringBuilder(256);
                    sql2.append("insert into ").append(tblName).append(" (").append(prop.getAlias());
                    sqls.put(tblName, sql2);
                } else {
                    sql2.append(", ").append(prop.getAlias());
                }
                List row = oneRow.computeIfAbsent(tblName, k -> new ArrayList());
                if (var32_51 instanceof Date) {
                    Timestamp timestamp = new Timestamp(((Date)var32_51).getTime());
                } else {
                    Object object = MRPUtil.convert((Object)var32_51, (IDataEntityProperty)prop);
                }
                if (var32_54 instanceof Date) {
                    Timestamp timestamp = new Timestamp(((Date)var32_54).getTime());
                } else if (var32_54 instanceof String && "null".equals(var32_54)) {
                    String string = "";
                }
                row.add(var32_57);
            }
            for (Map.Entry entry : sqls.entrySet()) {
                StringBuilder stringBuilder = (StringBuilder)entry.getValue();
                stringBuilder.append(", fid, fentryid) values (");
                List params = (List)oneRow.get(entry.getKey());
                for (int i = 0; i < params.size(); ++i) {
                    stringBuilder.append("?, ");
                }
                stringBuilder.append("?, ?)");
            }
            for (Map.Entry entry : oneRow.entrySet()) {
                String k2 = ((StringBuilder)sqls.get(entry.getKey())).toString();
                ArrayList<Object[]> rows = (ArrayList<Object[]>)args.get(k2);
                if (rows == null) {
                    rows = new ArrayList<Object[]>();
                    args.put(k2, rows);
                }
                List list = (List)entry.getValue();
                list.add(headId);
                list.add(entryId);
                rows.add(list.toArray());
                list.clear();
            }
            if (++size != 5000) continue;
            detailSize += 5000;
            for (Map.Entry entry : args.entrySet()) {
                DB.executeBatch((DBRoute)scmRoute, (String)((String)entry.getKey()), (List)((List)entry.getValue()));
            }
            args.clear();
            size = 0;
        }
        detailSize += size;
        for (Map.Entry entry : args.entrySet()) {
            DB.executeBatch((DBRoute)scmRoute, (String)((String)entry.getKey()), (List)((List)entry.getValue()));
        }
        args.clear();
        size = 0;
        if (!billEntryIds.isEmpty()) {
            ArrayList<DynamicObject> saves = new ArrayList<DynamicObject>(16);
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"mrp_reqcalc_record");
            ArrayList<Object[]> updateParams = new ArrayList<Object[]>(16);
            QFilter qFilter = new QFilter("billentry_id", "in", billEntryIds);
            Throwable throwable = null;
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getSimpleName(), (String)"mrp_reqcalc_record", (String)"id,bill_id,billentry_id,last_runlogno", (QFilter[])new QFilter[]{qFilter}, null);){
                for (Row row : dataSet) {
                    Long id = row.getLong("id");
                    Long bill_id = row.getLong("bill_id");
                    Long billentry_id = row.getLong("billentry_id");
                    String last_runlogno = row.getString("last_runlogno");
                    if (!billIds.contains(bill_id)) continue;
                    if (!ctx.getRunLogNumber().equals(last_runlogno)) {
                        Object[] p = new Object[]{ctx.getRunLogNumber(), nowDate, id};
                        updateParams.add(p);
                    }
                    reqcalc_records.remove(String.format("%s-%s", bill_id, billentry_id));
                }
            }
            catch (Throwable entry) {
                Throwable throwable2 = entry;
                throw entry;
            }
            if (!updateParams.isEmpty()) {
                int[] nArray = DB.executeBatch((DBRoute)scmRoute, (String)updateSql, updateParams);
            }
            for (Map.Entry entry : reqcalc_records.entrySet()) {
                Map param = (Map)entry.getValue();
                String[] str = ((String)entry.getKey()).split("-");
                if (param == null) continue;
                DynamicObject bill = (DynamicObject)mainEntityType.createInstance();
                for (Map.Entry entry2 : param.entrySet()) {
                    ReserveUtil.setDynamicObjValue((DynamicObject)bill, (EntityType)mainEntityType, (String)((String)entry2.getKey()), entry2.getValue());
                }
                bill.set("bill_id", (Object)Long.parseLong(str[0]));
                bill.set("billentry_id", (Object)Long.parseLong(str[1]));
                bill.set("last_runlogno", (Object)ctx.getRunLogNumber());
                bill.set("last_runtime", (Object)nowDate);
                saves.add(bill);
            }
            if (!saves.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])saves.toArray(new DynamicObject[0]));
            }
        }
        if ("1".equals(ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("ctxid: %s, mrprunner-saveDetail, mid: %s, resolves: %s", ctx.getMRPContextId(), materialId, detailSize));
        }
        event.setParam(MultiThreadCacheKey.KEY_REPLY_SAVE_COUNT, (Serializable)Integer.valueOf(detailSize));
    }

    private void clearBills(IMRPEnvProvider ctx, MRPEvent event, String bill) {
        int globalReTryCnt;
        String ids = event.getParam(MultiThreadCacheKey.KEY_MATERIAL_ROWS).toString();
        String tableName = EntityMetadataCache.getDataEntityType((String)bill).getAlias();
        List all = JSON.parseArray((String)ids, Long.class);
        int reTryCnt = globalReTryCnt = ((Integer)ctx.getCfgValue(EnvCfgItem.RETRY_CNT_BY_CLEAR_FAILURE)).intValue();
        while (--reTryCnt > 0) {
            try (ShardingHintContext dbCtx = ShardingHintContext.createAndSet((String)tableName.toString(), (HintCondition[])new HintCondition[]{new HintCondition("id", FilterType.in_range, (Object)all)});){
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)bill);
                DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])all.toArray());
                break;
            }
            catch (Throwable e) {
                logger.warn(String.format("mrprunner-delete-bills: %s, %s, %s", bill, reTryCnt, ids), e);
                try {
                    Thread.sleep((globalReTryCnt - reTryCnt) * 100);
                }
                catch (InterruptedException e2) {
                    logger.warn(String.format("mrprunner-delete-bills-yield: %s, %s, %s", bill, reTryCnt, ids), (Throwable)e2);
                }
            }
        }
    }
}

