/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.calcnode.framework.step;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mmc.mrp.calcnode.framework.step.AbstractMRPSubStep;
import kd.mmc.mrp.calcnode.framework.step.result.PlanOrderCreateResult;
import kd.mmc.mrp.exception.MRPBizException;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPDataSaveResolver;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.consts.Errors;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.framework.consts.Tips;
import kd.mmc.mrp.model.enums.EnvCfgItem;

public class MRPMCreatePlanOrder
extends AbstractMRPSubStep {
    private static Log logger = LogFactory.getLog(MRPMCreatePlanOrder.class);

    public MRPMCreatePlanOrder(IMRPEnvProvider ctx) {
        super(ctx);
    }

    @Override
    protected PlanOrderCreateResult executeImpl() {
        PlanOrderCreateResult ret = new PlanOrderCreateResult();
        this.ctx.calcBalanceDetails().finish();
        ArrayList dealMappings = new ArrayList(this.ctx.calcBalanceDetails().getMappings());
        try {
            IMRPDataSaveResolver resolver = this.createMappingSaver();
            boolean is_create_po_write_redis = (Boolean)this.ctx.getCfgValue(EnvCfgItem.IS_CREATE_PO_WRITE_REDIS);
            if (is_create_po_write_redis) {
                resolver.saveMappingAndWriteRedis(this.ctx, dealMappings);
                ret.setDataAmount(resolver.getCreatePoCount());
            } else {
                List result = this.ctx.createMappingSaver().saveMapping(this.ctx, dealMappings);
                this.putPlanOrders(result);
                ret.setDataAmount(result.size());
            }
        }
        catch (Throwable e) {
            logger.error("mrprunner-createpo-error: ", e);
            throw new MRPBizException(Errors.getPOCreateError(), e.getMessage(), e.getStackTrace());
        }
        return ret;
    }

    private void putPlanOrders(List<Map<String, Object>> orders) {
        int batchSize = (Integer)this.ctx.getCfgValue(EnvCfgItem.PO_REDIS_DATA_BATCH);
        HashMap<String, List> orderMap = new HashMap<String, List>(1);
        for (Map<String, Object> map : orders) {
            String material = String.valueOf(map.get("material"));
            List order = orderMap.computeIfAbsent(material, k -> new ArrayList(16));
            order.add(map);
        }
        for (Map.Entry entry : orderMap.entrySet()) {
            MRPCacheManager.getInst().setPlanOrders((CalEnv)this.ctx, (String)entry.getKey(), (List)entry.getValue(), batchSize);
            MRPCacheManager.getInst().putData((CalEnv)this.ctx, MRPRuntimeConsts.getPlanOrderSplitKey((String)this.ctx.getMRPContextId(), (String)((String)entry.getKey())), String.valueOf(((List)entry.getValue()).size()));
        }
    }

    protected IMRPDataSaveResolver createMappingSaver() {
        return this.ctx.createMappingSaver();
    }

    public String getDesc() {
        return Tips.getCreatePlanorder();
    }
}

