/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.calcnode.framework.step;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.mmc.mrp.calcnode.framework.step.MRPMDataBalanceStep;
import kd.mmc.mrp.calcnode.framework.step.comparator.RequirePriorityComparator;
import kd.mmc.mrp.calcnode.framework.step.comparator.SupplySortComparator;
import kd.mmc.mrp.calcnode.framework.step.result.MRPDataBalanceNewResult;
import kd.mmc.mrp.calcnode.framework.step.result.SafeInvStatistics;
import kd.mmc.mrp.common.util.SerializableUtils;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.MRPWorkCalendarManager;
import kd.mmc.mrp.framework.step.IMRPResult;
import kd.mmc.mrp.integrate.entity.CacheDatas;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.integrate.entity.RequireDataModel;
import kd.mmc.mrp.integrate.entity.ResDataModelCollection;
import kd.mmc.mrp.model.date.OrgBasedCalendarModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.enums.strategy.BillAdjustStrategy;
import kd.mmc.mrp.model.enums.strategy.MaterialAttribute;
import kd.mmc.mrp.model.enums.strategy.OORBillResolveStrategy;
import kd.mmc.mrp.model.struct.InvRealBalanceStruct;
import kd.mmc.mrp.model.struct.ReplaceStruct;
import kd.mmc.mrp.model.struct.SupplyStruct;
import kd.mmc.mrp.model.table.AdjustParameter;
import kd.mmc.mrp.model.table.AdjustSuggestTable;
import kd.mmc.mrp.model.table.ColumnDatas;
import kd.mmc.mrp.model.table.DataBalanceTable;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.table.res.RequirementDataTable;
import kd.mmc.mrp.model.table.res.SupplymentDataTable;
import kd.mmc.mrp.model.table.utils.DataBalanceUtil;
import kd.mmc.mrp.model.table.utils.DataMatchUtils;
import kd.mmc.mrp.model.table.utils.InvPlanUtil;
import kd.mmc.mrp.model.table.utils.ReplaceUtil;
import kd.mmc.mrp.mservice.batchpolicy.BatchCalcService;
import kd.mmc.mrp.utils.MRPUtil;
import kd.sdk.mmc.mrp.extpoint.IMRPCalcNetDemandPlugin;
import kd.sdk.mmc.mrp.framework.res.IResModelDataTable;
import kd.sdk.mmc.mrp.framework.res.IRowData;

public class MRPMDataBalanceNewStep
extends MRPMDataBalanceStep {
    private static Log logger = LogFactory.getLog(MRPMDataBalanceNewStep.class);
    protected List<RequireRowData> unFullRequires = new ArrayList<RequireRowData>();
    protected boolean isCenterWarehouseCycle = false;
    protected HashMap<String, SafeInvStatistics> safeInvs = new HashMap();
    protected int currentPriotiry = -1;

    @Override
    protected List<RowData[]> createCollaborateSupply(ArrayList<RequireRowData> current) {
        if (current == null || current.isEmpty()) {
            return new ArrayList<RowData[]>();
        }
        Iterator<RequireRowData> it = current.iterator();
        while (it.hasNext()) {
            RequireRowData requireRowData = it.next();
            if (this.isCreateCollaborateBill(requireRowData)) continue;
            this.orderAddMapping(this.ctx.calcBalanceDetails(), requireRowData, new ArrayList<RowData>(), DataBalanceTable.MatchType.LESS);
            it.remove();
        }
        return this.ctx.createCollaborateSupply(current);
    }

    private boolean isCreateCollaborateBill(RequireRowData requireRowData) {
        CacheDatas cacheDatas = (CacheDatas)this.ctx.getService(CacheDatas.class);
        int value = (Integer)MRPUtil.convert((Object)requireRowData.getValue(DefaultField.RequireField.MATERIALATTR.getName()), (Object)MaterialAttribute.OTHER.getValue());
        return MaterialAttribute.STORAGEPART.getValue() == value;
    }

    @Override
    protected boolean isTransfer(RequireRowData requireData, DataBalanceTable.MatchType matchType) {
        String supplyOrgId;
        boolean isTransfer;
        String requireOrgId = String.valueOf(requireData.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
        boolean bl = isTransfer = !requireOrgId.equals(supplyOrgId = String.valueOf(requireData.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()))) && this.isFabricatedpart(requireData);
        if (isTransfer && matchType == DataBalanceTable.MatchType.EQUAL) {
            this.collaborates.removeIf(require -> Objects.equals(require.getRowIdx(), requireData.getRowIdx()));
        }
        return matchType == DataBalanceTable.MatchType.LESS && isTransfer;
    }

    @Override
    protected boolean isFabricatedpart(RequireRowData row) {
        CacheDatas cacheDatas = (CacheDatas)this.ctx.getService(CacheDatas.class);
        int value = (Integer)MRPUtil.convert((Object)row.getValue(DefaultField.RequireField.MATERIALATTR.getName()), (Object)MaterialAttribute.OTHER.getValue());
        return MaterialAttribute.STORAGEPART.getValue() == value;
    }

    public MRPMDataBalanceNewStep(IMRPEnvProvider ctx) {
        super(ctx);
    }

    public MRPMDataBalanceNewStep(IMRPEnvProvider ctx, boolean isReplaceBalance) {
        super(ctx, isReplaceBalance);
    }

    @Override
    protected IMRPResult executeImpl() {
        super.executeImpl();
        return new MRPDataBalanceNewResult(this.collaborates, this.safeInvs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void cycleOccupy(Iterator<Comparable<?>> priorityIter, ColumnDatas rCol) {
        if ("SURPLUS_ADJUST".equals(this.ctx.getCfgValue(EnvCfgItem.MRP_BALANCE_TYPE))) {
            super.cycleOccupy(priorityIter, rCol);
            this.isCenterWarehouseCycle = true;
            this.unFullRequires.sort(new RequirePriorityComparator());
            this.modifyOccupy(this.unFullRequires);
            this.unFullRequires.clear();
            this.isCenterWarehouseCycle = false;
            return;
        } else {
            int[] prioritys = this.ctx.getSupplyPrioritys();
            ArrayList requires = new ArrayList();
            while (priorityIter.hasNext()) {
                requires.add(priorityIter.next());
            }
            RequireDataModel requireDataModel = (RequireDataModel)this.ctx.getService(RequireDataModel.class);
            boolean isByFlex = requireDataModel.isByFlex();
            boolean havNullValueMatch = requireDataModel.r2sHavSNullValueMatch();
            if (this.isReplaceBalance) {
                this.isNullValueMatch = true;
                this.isCenterWarehouseCycle = true;
                this.cycle(0, requires, rCol);
                return;
            } else if (isByFlex) {
                boolean isRollOver = (Boolean)this.ctx.getCfgValue(EnvCfgItem.SUPPLY_ROLL_OVER_ENABLED);
                if (isRollOver) {
                    for (int priority : prioritys = this.getPrioritys(prioritys)) {
                        this.isNullValueMatch = false;
                        this.cycle(priority, requires, rCol);
                        if (havNullValueMatch) {
                            this.isNullValueMatch = true;
                            this.cycle(priority, requires, rCol);
                        }
                        try {
                            this.isNullValueMatch = false;
                            this.ctx.putLocalParam("__MRP_PRODUCT_SUBSTITUTE__", (Object)true);
                            this.cycle(priority, requires, rCol);
                            if (!havNullValueMatch) continue;
                            this.isNullValueMatch = true;
                            this.cycle(priority, requires, rCol);
                        }
                        finally {
                            this.ctx.putLocalParam("__MRP_PRODUCT_SUBSTITUTE__", (Object)false);
                        }
                    }
                    return;
                } else {
                    this.isNullValueMatch = false;
                    this.flexMatch(requires, rCol, prioritys);
                    if (havNullValueMatch) {
                        this.isNullValueMatch = true;
                        this.flexMatch(requires, rCol, prioritys);
                    }
                    try {
                        this.isNullValueMatch = false;
                        this.ctx.putLocalParam("__MRP_PRODUCT_SUBSTITUTE__", (Object)true);
                        this.productSubstitute(requires, rCol, prioritys);
                        if (!havNullValueMatch) return;
                        this.isNullValueMatch = true;
                        this.productSubstitute(requires, rCol, prioritys);
                        return;
                    }
                    finally {
                        this.ctx.putLocalParam("__MRP_PRODUCT_SUBSTITUTE__", (Object)false);
                    }
                }
            } else if (prioritys.length <= 0) {
                this.isNullValueMatch = true;
                this.cycle(0, requires, rCol);
                return;
            } else {
                this.isNullValueMatch = false;
                this.cycleMatch(requires, rCol, prioritys);
                if (!havNullValueMatch) return;
                this.isNullValueMatch = true;
                this.cycleMatch(requires, rCol, prioritys);
            }
        }
    }

    protected void cycleMatch(List<Comparable<?>> requires, ColumnDatas rCol, int[] prioritys) {
        for (int priority : prioritys = this.getPrioritys(prioritys)) {
            this.cycle(priority, requires, rCol);
        }
    }

    protected void flexMatch(List<Comparable<?>> requires, ColumnDatas rCol, int[] prioritys) {
        this.cycleMatch(requires, rCol, prioritys);
    }

    protected void productSubstitute(List<Comparable<?>> requires, ColumnDatas rCol, int[] prioritys) {
        this.cycleMatch(requires, rCol, prioritys);
    }

    private int[] getPrioritys(int[] prioritys) {
        boolean hasZero = false;
        for (int p : prioritys) {
            if (p != 0) continue;
            hasZero = true;
            break;
        }
        return hasZero ? prioritys : Arrays.copyOf(prioritys, prioritys.length + 1);
    }

    private void cycle(int priority, List<Comparable<?>> requires, ColumnDatas rCol) {
        this.currentPriotiry = priority;
        super.cycleOccupy(requires.iterator(), rCol);
        this.isCenterWarehouseCycle = true;
        this.unFullRequires.sort(new RequirePriorityComparator());
        this.modifyOccupy(new ArrayList<RequireRowData>(this.unFullRequires));
        this.unFullRequires.clear();
        this.isCenterWarehouseCycle = false;
    }

    @Override
    protected List<RequireRowData> samePeriodOccupy(List<Integer> requireRowIdxs) {
        if ("SURPLUS_ADJUST".equals(this.ctx.getCfgValue(EnvCfgItem.MRP_BALANCE_TYPE))) {
            return super.samePeriodOccupy(requireRowIdxs);
        }
        RequirementDataTable requireTbl = this.ctx.requireDatas();
        List requireRows = requireTbl.fetchRow(requireRowIdxs);
        Iterator iter = requireRows.iterator();
        while (iter.hasNext()) {
            RequireRowData require = (RequireRowData)iter.next();
            boolean bool = this.safeInvResolve(require, this.ctx.supplyDatas());
            if (!bool) {
                iter.remove();
                continue;
            }
            BigDecimal qty = (BigDecimal)MRPUtil.convert((Object)require.getValue(DefaultField.RequireField.QTY.getName()), (Object)BigDecimal.ZERO);
            Object isMergeReq = require.getValue(DefaultField.RequireField.__IS_MERGE_.getName());
            if (isMergeReq == Boolean.TRUE) continue;
            String num = String.valueOf(require.getValue(DefaultField.RequireField.EXCEPTIONNUMBER.getName()));
            if (qty.compareTo(BigDecimal.ZERO) <= 0) {
                if (num.contains("100")) continue;
                iter.remove();
                continue;
            }
            String exp = require.getValue(DefaultField.RequireField.EXCEPTIONNUMBER.getName()) == null ? "" : String.valueOf(require.getValue(DefaultField.RequireField.EXCEPTIONNUMBER.getName()));
            if (StringUtils.isEmpty((String)exp) || !MRPUtil.hasException((String)exp)) continue;
            this.ctx.calcBalanceDetails().addMapping(require, new ArrayList(), DataBalanceTable.MatchType.EQUAL);
            iter.remove();
        }
        return requireRows;
    }

    @Override
    protected boolean samePeriodOccupyRecord(RequireRowData requireData, SupplymentDataTable supplyTbl, DataBalanceTable detailTbl) {
        boolean bool = this.safeInvResolve(requireData, supplyTbl);
        if (!bool) {
            return true;
        }
        List<Integer> occupys = this.singleSamePeriodOccupy(requireData, this.ctx);
        if ("SURPLUS_ADJUST".equals(this.ctx.getCfgValue(EnvCfgItem.MRP_BALANCE_TYPE))) {
            detailTbl.addMapping(requireData, supplyTbl.fetchRow(occupys), DataBalanceTable.MatchType.LESS);
        } else if (requireData.isBalanced()) {
            detailTbl.addMapping(requireData, supplyTbl.fetchRow(occupys), DataBalanceTable.MatchType.EQUAL);
        }
        supplyTbl.lock(occupys, requireData.getRowIdx());
        return requireData.isBalanced();
    }

    private boolean safeInvResolve(RequireRowData requireData, SupplymentDataTable supplyTbl) {
        String type;
        boolean ret = MRPUtil.convert((Object)requireData.getValue(DefaultField.RequireField.ISSTOCK.getName()), (Boolean)Boolean.FALSE);
        if (!ret) {
            return true;
        }
        logger.warn(String.format("mrprunner-safeInvs-collect row: %s", requireData));
        if (requireData.getValue(DefaultField.RequireField.EXCEPTIONNUMBER.getName()) != null) {
            return this.ctx.getOORDataResolveStrategy() == OORBillResolveStrategy.RECORDEXCEPTIONTAG;
        }
        Object obj = requireData.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName());
        if (obj == null) {
            obj = requireData.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName());
        }
        if ("A".equals(type = String.valueOf(requireData.getValue(DefaultField.RequireField.SAFEINVTYPE.getName())))) {
            return true;
        }
        String key = String.valueOf(obj);
        SafeInvStatistics safe = new SafeInvStatistics();
        safe.setRequireData(requireData);
        safe.setStart(new Date((Long)requireData.getValue(DefaultField.RequireField.DATE.getName())));
        Object end = requireData.getValue(DefaultField.RequireField.INVALIDDATE.getName());
        if (end == null) {
            safe.setEnd(this.ctx.getPlanDate());
        } else {
            safe.setEnd(new Date((Long)end));
        }
        this.safeInvs.put(key, safe);
        return false;
    }

    @Override
    protected void modifyOccupyRecord(RequireRowData requireData, DataBalanceTable detailTbl) {
        ArrayList<RowData> occupyData = new ArrayList<RowData>();
        String[] exps = new String[2];
        if (this.isExceptionRequire(requireData, exps)) {
            String exp = MRPUtil.appendExceptionMsg((Object)requireData.getValue(DefaultField.RequireField.EXCEPTIONMESSAGE.getName()), (String)exps[1]);
            requireData.update(DefaultField.RequireField.EXCEPTIONMESSAGE.getName(), (Object)exp);
            String num = MRPUtil.appendExceptionNumber((Object)requireData.getValue(DefaultField.RequireField.EXCEPTIONNUMBER.getName()), (String)exps[0]);
            requireData.update(DefaultField.RequireField.EXCEPTIONNUMBER.getName(), (Object)num);
            detailTbl.addMapping(requireData, occupyData, DataBalanceTable.MatchType.EQUAL);
            return;
        }
        DataBalanceTable.MatchType matchType = this.singleModifyOccupy(this.isCenterWarehouseCycle, requireData, this.ctx, occupyData);
        String requireProductOrgUnitID = String.valueOf(requireData.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()));
        if (matchType != null) {
            if (this.isCenterTrans(this.ctx, requireProductOrgUnitID)) {
                if (matchType == DataBalanceTable.MatchType.LESS) {
                    if (!this.isCenterWarehouseCycle) {
                        this.unFullRequires.add(requireData);
                    } else {
                        this.addMapping(detailTbl, requireData, occupyData, matchType);
                    }
                } else {
                    this.addMapping(detailTbl, requireData, occupyData, matchType);
                }
            } else {
                this.addMapping(detailTbl, requireData, occupyData, matchType);
            }
        }
    }

    protected boolean isExceptionRequire(RequireRowData requireData, String[] exps) {
        IMRPCalcNetDemandPlugin imrpCalcNetDemandPlugin = this.ctx.getMRPCalcNetDemandPlugin();
        if (imrpCalcNetDemandPlugin != null) {
            return imrpCalcNetDemandPlugin.isExceptionRequire(this.ctx.getMrpSdkEnv(), (IRowData)requireData, exps);
        }
        return false;
    }

    public List<Integer> singleSamePeriodOccupy(RequireRowData requireData, IMRPEnvProvider ctx) {
        return DataBalanceUtil.singleSamePeriodOccupy((RequireRowData)requireData, (IMRPEnvProvider)ctx);
    }

    public DataBalanceTable.MatchType singleModifyOccupy(boolean isCenterWarehouseCycle, RequireRowData requireData, IMRPEnvProvider ctx, List<RowData> occupyData) {
        Boolean isFastEnable;
        boolean isCycleBatch;
        ReplaceStruct replaceStruct;
        int planOutLook = ctx.getPlanOutLook();
        MRPWorkCalendarManager wcm = ctx.dateManager();
        SupplymentDataTable supplyTbl = ctx.supplyDatas();
        AdjustParameter adjustParameter = DataBalanceUtil.getAdjustParameter((IMRPEnvProvider)ctx, (RequireRowData)requireData);
        int advanceAdjust = adjustParameter.getAdvanceAdjust();
        int delayAdjust = adjustParameter.getDelayAdjust();
        int tolerOfDelay = adjustParameter.getTolerOfDelay();
        int tolerOfForward = adjustParameter.getTolerOfForward();
        this.beforeSingleModifyOccupy(requireData, ctx);
        BigDecimal rQty = requireData.getNewQrequireQty();
        if (rQty == null) {
            rQty = MRPUtil.toBigDecimal((Object)requireData.getValue(DefaultField.RequireField.QTY.getName()));
        }
        if (rQty.compareTo(BigDecimal.ZERO) <= 0 || requireData.isBalanced()) {
            return null;
        }
        Date requireDate = new Date((Long)requireData.getValue(DefaultField.RequireField.DATE.getName()));
        String requireProductOrgUnitID = String.valueOf(requireData.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()));
        String requireOrgUnitID = String.valueOf(requireData.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
        OrgBasedCalendarModel rOcm = wcm.get(requireProductOrgUnitID, requireOrgUnitID);
        int periodAdjust = wcm.getPlanDatePeriod(requireProductOrgUnitID, requireOrgUnitID) + planOutLook;
        int requirePeriod = rOcm.getWorkDaySeq(requireDate);
        if (requirePeriod > periodAdjust) {
            occupyData.addAll(supplyTbl.fetchRow((Collection)requireData.getOccupys(), true));
            return DataBalanceTable.MatchType.LESS;
        }
        String json = (String)requireData.getValue(DefaultField.RequireField.__REPLACE_STRUCT__.getName());
        ReplaceStruct replaceStruct2 = replaceStruct = json == null ? null : (ReplaceStruct)SerializableUtils.fromSerializedString((String)json, ReplaceStruct.class);
        if (this.isReplaceBalance) {
            isCenterWarehouseCycle = this.isCenterTrans(ctx, requireProductOrgUnitID);
        }
        List supplys = this.findSupplys(isCenterWarehouseCycle, (RowData)requireData, ctx);
        Boolean isProSubstitute = ctx.getLocalParams("__MRP_PRODUCT_SUBSTITUTE__") == null ? Boolean.valueOf(false) : (Boolean)ctx.getLocalParams("__MRP_PRODUCT_SUBSTITUTE__");
        boolean isReplaceRequire = ctx.isReplace() && replaceStruct != null;
        PlanModel planModel = (PlanModel)ctx.getService(PlanModel.class);
        boolean isReserve = planModel.isReserve();
        Long reqBillId = (Long)MRPUtil.convert((Object)requireData.getValue(DefaultField.RequireField.BILLID.getName()), (Object)0L);
        Long reqBillEntryId = (Long)MRPUtil.convert((Object)requireData.getValue(DefaultField.RequireField.BILLENTRYID.getName()), (Object)0L);
        if (reqBillEntryId == 0L) {
            reqBillEntryId = reqBillId;
        }
        Integer row = (Integer)ctx.supplyDatas().getR2Row().get(reqBillId.toString() + '-' + reqBillEntryId);
        isReserve = isReserve && row != null;
        boolean is_inv_water_level = MRPUtil.convert((Object)requireData.getValue(DefaultField.RequireField.IS_INV_WATER_LEVEL.getName()), (Boolean)Boolean.FALSE);
        boolean isNewInvRequire = InvPlanUtil.isNewInvRequire((IMRPEnvProvider)ctx, (RequireRowData)requireData);
        String batchpolicy = requireData.getString(DefaultField.RequireField.BATCHPOLICY.getName());
        boolean bl = isCycleBatch = "C".equals(batchpolicy) && !is_inv_water_level && isNewInvRequire;
        if (supplys.isEmpty() && !isReplaceRequire && !isReserve && !isNewInvRequire) {
            occupyData.addAll(supplyTbl.fetchRow((Collection)requireData.getOccupys(), true));
            return DataBalanceTable.MatchType.LESS;
        }
        Object strategy = requireData.getValue(DefaultField.RequireField.PLAN_STRATEGY.getName());
        if (strategy == null) {
            strategy = requireData.getValue(DefaultField.RequireField.DEFAULT_PLAN_STRATEGY.getName());
        }
        if (!(isFastEnable = (Boolean)ctx.getCfgValue(EnvCfgItem.ENABLE_FAST_SUPLLY_SEARCH_MODE)).booleanValue()) {
            if (!isProSubstitute.booleanValue()) {
                supplys = ctx.sortByPriority(supplyTbl, requireProductOrgUnitID, supplys, strategy == null ? null : String.valueOf(strategy), isCenterWarehouseCycle);
            } else {
                ResDataModelCollection resDataModelCollection = (ResDataModelCollection)ctx.getService(ResDataModelCollection.class);
                ListIterator<Integer> ites = supplys.listIterator();
                while (ites.hasNext()) {
                    InvRealBalanceStruct invacc;
                    int next = (Integer)ites.next();
                    RowData supplyData = supplyTbl.fetchRow(next);
                    SupplyStruct struct = (SupplyStruct)planModel.getPriorityRelations().get(requireProductOrgUnitID);
                    Boolean isStorageSupply = MRPUtil.convert((Object)supplyData.getValue(DefaultField.SupplyField.ISSTORAGEDATA.getName()), (Boolean)Boolean.FALSE);
                    if (!isStorageSupply.booleanValue() || resDataModelCollection.isStorageSupplyMatch(supplyTbl, struct, invacc = new InvRealBalanceStruct((CalEnv)ctx, supplyTbl.getColIdx(), supplyData.getValues()), supplyData.getValues(), isCenterWarehouseCycle, planModel, next, new ArrayList())) continue;
                    ites.remove();
                }
            }
        }
        if ("RECEIVE_ADJUST".equals(ctx.getCfgValue(EnvCfgItem.MRP_BALANCE_TYPE))) {
            if (!isFastEnable.booleanValue() && !isProSubstitute.booleanValue()) {
                supplys.sort(new SupplySortComparator(ctx));
            }
            supplys = supplyTbl.sortSupplyByReserve(ctx, supplys, requireData);
            if (!this.isReplaceBalance) {
                Iterator iter = supplys.iterator();
                while (iter.hasNext()) {
                    Boolean isReserveSup;
                    Integer rowIdx = (Integer)iter.next();
                    Integer priority = (Integer)supplyTbl.getValue(DefaultField.SupplyField.__PRIORITY_LEVEL__.getName(), rowIdx.intValue());
                    if (priority == null) {
                        logger.warn(String.format("mrprunner-emtpy-priority-supply-data: %s", supplyTbl.fetchRow(rowIdx.intValue())));
                    }
                    if ((isReserveSup = MRPUtil.convert((Object)supplyTbl.getValue(DefaultField.SupplyField._IS_RESERVE_SUPPLY_.getName(), rowIdx.intValue()), (Boolean)Boolean.FALSE)) != null && isReserveSup.booleanValue() || priority == null || priority == this.currentPriotiry) continue;
                    iter.remove();
                }
            }
        }
        if ("1".equals(ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG)) && ctx.isReplace()) {
            logger.warn(String.format("ctxid: %s, mrprunner-replaceUtil-replaceOp, replaceStruct: %s", ctx.getMRPContextId(), replaceStruct));
        }
        if (isReplaceRequire && !isProSubstitute.booleanValue()) {
            supplys = ReplaceUtil.sortByReplace((SupplymentDataTable)supplyTbl, supplys, (ReplaceStruct)replaceStruct);
        }
        supplys = this.sortSupplyByRequire(ctx, supplys, requireData);
        List supplyDatas = supplyTbl.fetchRow((Collection)supplys);
        BigDecimal sumSQty = BigDecimal.ZERO;
        boolean isSurplus = rQty.compareTo(BigDecimal.ZERO) <= 0;
        LinkedHashMap<Integer, BigDecimal> supplyIdx2remainQty = new LinkedHashMap<Integer, BigDecimal>(2);
        for (int idx = 0; idx < supplyDatas.size(); ++idx) {
            AdjustSuggestTable suggestTable;
            int supplyPeriod;
            RowData supply = (RowData)supplyDatas.get(idx);
            int supplyIdx = supply.getRowIdx();
            if ("tmp_safe_inv".equals(supply.getValue(DefaultField.SupplyField.BILL_ENTITY.getName())) || supply.getValue(DefaultField.SupplyField.__EXCEPTIONNUMBER__.getName()) != null || MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.__IS_OCCUPIED__.getName()), (Boolean)Boolean.FALSE).booleanValue()) continue;
            Object supplyProductOrgUnitID = String.valueOf(supply.getValue(DefaultField.SupplyField.SUPPLYORGUNIT.getName()));
            String requireOrgID = String.valueOf(requireData.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
            HashSet reqOrgs = ctx.getRequirorgs();
            if (!reqOrgs.contains(supplyProductOrgUnitID) && !reqOrgs.contains(requireOrgID)) {
                supplyProductOrgUnitID = String.valueOf(requireData.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()));
            }
            OrgBasedCalendarModel sOcm = wcm.get((String)supplyProductOrgUnitID, requireOrgID);
            int period = sOcm.getWorkDaySeq(requireDate);
            int advancePeriodAdjust = period + advanceAdjust;
            int delayPeriodAdjust = period - delayAdjust;
            requirePeriod = sOcm.getWorkDaySeq(requireDate);
            Date supplyDate = new Date((Long)supply.getValue(DefaultField.SupplyField.DATE.getName()));
            if ((Integer)MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.ISSTORAGEDATA.getName()), (Object)0) != 0) {
                supplyPeriod = requirePeriod;
                BigDecimal dt = MRPUtil.toBigDecimal((Object)supply.getValue(DefaultField.SupplyField.__WASTE_STORAGE_DEAL_TIME__.getName()));
                if (dt != null) {
                    int n = dt.setScale(0, RoundingMode.CEILING).intValue();
                    supplyPeriod = sOcm.getWorkDaySeq(sOcm.getDate(new Date(), false, n).getTime());
                    supply.update(DefaultField.SupplyField.DATE.getName(), (Object)(MRPUtil.normalize((Date)new Date()).getTime() + (long)n * 86400000L));
                    if (requirePeriod < supplyPeriod) {
                        String mid = String.valueOf(supply.getValue(DefaultField.SupplyField.MATERIAL.getName()));
                        logger.warn(String.format("ctxid: %s, mrprunner-adjust-requirePeriod<supplyPeriod-continue mid: %s, requirePeriod: %s, supplyPeriod: %s, dt: %s", ctx.getMRPContextId(), mid, requirePeriod, supplyPeriod, dt));
                        continue;
                    }
                    supplyPeriod = requirePeriod;
                }
            } else {
                supplyPeriod = sOcm.getWorkDaySeq(supplyDate);
            }
            if (supplyPeriod > advancePeriodAdjust || supplyPeriod < delayPeriodAdjust || (suggestTable = DataBalanceUtil.getAdjustSuggestTable((IMRPEnvProvider)ctx, (RequireRowData)requireData, (RowData)supply, (int)requirePeriod, (int)supplyPeriod, (Integer)tolerOfDelay, (Integer)tolerOfForward, (OrgBasedCalendarModel)rOcm)) == null || !this.isMatchSupply(ctx, requireData, supply)) continue;
            BigDecimal sQty = MRPUtil.toBigDecimal((Object)supply.getValue(DefaultField.SupplyField.QTY.getName()));
            sumSQty = sumSQty.add(sQty);
            int balance = rQty.compareTo(sumSQty);
            boolean isPoSup = InvPlanUtil.isNewCreateSupplyBill((IMRPEnvProvider)ctx, (RowData)supply);
            if (isPoSup) {
                this.deductRemainPoQty(balance < 0 ? rQty.subtract(sumSQty).add(sQty) : sQty, supply);
                suggestTable.setAdjust(false);
                suggestTable.setAdjustFlag(BillAdjustStrategy.NONE.getValue());
                suggestTable.setAdjustPlanDate(null);
            }
            if (balance > 0 || isReplaceRequire) {
                if (!is_inv_water_level) {
                    DataBalanceUtil.lessOrEqualsDataBalance((IMRPEnvProvider)ctx, (RowData)supply, (AdjustSuggestTable)suggestTable);
                }
                requireData.getOccupys().add(supplyIdx);
                continue;
            }
            if (balance == 0) {
                if (!is_inv_water_level) {
                    DataBalanceUtil.lessOrEqualsDataBalance((IMRPEnvProvider)ctx, (RowData)supply, (AdjustSuggestTable)suggestTable);
                }
                requireData.getOccupys().add(supplyIdx);
            } else {
                if (isSurplus) {
                    supplyIdx2remainQty.put(supplyIdx, sQty);
                    if (!is_inv_water_level) continue;
                    requireData.getOccupys().add(supplyIdx);
                    continue;
                }
                BigDecimal unUsedQty = sumSQty.subtract(rQty);
                int idx2 = -1;
                if (!is_inv_water_level) {
                    idx2 = DataBalanceUtil.surplusDataBalance((IMRPEnvProvider)ctx, (RowData)supply, (AdjustSuggestTable)suggestTable, (SupplymentDataTable)supplyTbl, (BigDecimal)unUsedQty);
                }
                if (idx2 >= 0) {
                    requireData.getOccupys().add(idx2);
                } else {
                    requireData.getOccupys().add(supplyIdx);
                }
                supplyIdx2remainQty.put(supplyIdx, unUsedQty);
            }
            isSurplus = true;
            if (!isNewInvRequire) break;
        }
        if (isNewInvRequire && !isCycleBatch) {
            isSurplus = this.invLevelRequireBalance(ctx, requireData, supplyIdx2remainQty, rQty, sumSQty);
        }
        DataBalanceTable.MatchType matchType = null;
        if (isReplaceRequire) {
            List result = ReplaceUtil.replaceOp(this.unFullRequires, (SupplymentDataTable)supplyTbl, (RequireRowData)requireData, (IMRPEnvProvider)ctx);
            for (RequireRowData newData : result) {
                this.addMapping(ctx.calcBalanceDetails(), newData, supplyTbl.fetchRow((Collection)newData.getOccupys(), true), newData.isBalanced() ? DataBalanceTable.MatchType.EQUAL : DataBalanceTable.MatchType.LESS);
            }
        } else {
            occupyData.addAll(supplyTbl.fetchRow((Collection)requireData.getOccupys(), true));
            if (!isSurplus) {
                requireData.setNewQrequireQty(rQty.subtract(sumSQty));
                matchType = DataBalanceTable.MatchType.LESS;
            } else {
                matchType = DataBalanceTable.MatchType.EQUAL;
            }
            if (!is_inv_water_level) {
                supplyTbl.lock((Collection)requireData.getOccupys(), requireData.getRowIdx());
            } else {
                MRPMDataBalanceStep.PlanTypeCalc planTypeCalc = this.getPlanTypeCalc(requireData, ctx);
                if (planTypeCalc != null) {
                    BigDecimal vQty;
                    Integer i;
                    RowData supply;
                    boolean isPoSup;
                    BatchCalcService batchCalcService = this.getBatchCalcService(requireData);
                    BigDecimal remainQty = planTypeCalc.getRemainSupplyOccupyQty(batchCalcService, requireData);
                    String key = InvPlanUtil.getEmptyRequireKey((RequireRowData)requireData, (boolean)planModel.isEnablePlanScope());
                    HashMap<String, BigDecimal> supply2Qty = new HashMap<String, BigDecimal>(supplyIdx2remainQty.size());
                    Iterator iterator = requireData.getOccupys().iterator();
                    while (iterator.hasNext() && ((isPoSup = InvPlanUtil.isNewCreateSupplyBill((IMRPEnvProvider)ctx, (RowData)(supply = supplyTbl.fetchRow((i = (Integer)iterator.next()).intValue())))) || (remainQty = this.invPlanOccupySupply(remainQty, vQty = (BigDecimal)MRPUtil.convert((Object)supplyTbl.getValue(DefaultField.SupplyField.QTY.getName(), i.intValue()), (Object)BigDecimal.ZERO), i, supply2Qty, key)).compareTo(BigDecimal.ZERO) > 0)) {
                    }
                    this.supplyOccupyQty.put(key, supply2Qty);
                }
                return null;
            }
        }
        if (isCycleBatch) {
            requireData.setBalanced(DataBalanceTable.MatchType.EQUAL == matchType);
            this.batchCycleMergeStruct.addRequireByMpId(ctx, (Long)MRPUtil.convert((Object)requireData.getValue(DefaultField.RequireField.__MATERIALPLAN__.getName()), (Object)0L), requireData, supplyIdx2remainQty);
            return null;
        }
        return matchType;
    }

    private boolean invLevelRequireBalance(IMRPEnvProvider ctx, RequireRowData requireData, Map<Integer, BigDecimal> supplyIdx2remainQty, BigDecimal rQty, BigDecimal sumSQty) {
        boolean isSurplus;
        MRPMDataBalanceStep.PlanTypeCalc planTypeCalc = this.getPlanTypeCalc(requireData, ctx);
        boolean bl = isSurplus = rQty.compareTo(sumSQty) <= 0;
        if (planTypeCalc != null) {
            boolean is_inv_water_level = MRPUtil.convert((Object)requireData.getValue(DefaultField.RequireField.IS_INV_WATER_LEVEL.getName()), (Boolean)Boolean.FALSE);
            BatchCalcService batchCalcService = this.getBatchCalcService(requireData);
            if (!is_inv_water_level) {
                this.invPlanRequireOccupySupply(planTypeCalc, batchCalcService, requireData, supplyIdx2remainQty);
            }
            BigDecimal remainQty = is_inv_water_level ? sumSQty : sumSQty.subtract(rQty);
            BigDecimal invQty = planTypeCalc.getPlanOrderQty(is_inv_water_level ? BigDecimal.ZERO : rQty, sumSQty);
            if (invQty != null && (invQty.compareTo(BigDecimal.ZERO) > 0 || invQty.compareTo(BigDecimal.ZERO) == 0 && !planTypeCalc.isEnough(remainQty))) {
                MRPMDataBalanceStep.InvPlanBalanceParam invPlanBalanceParam = new MRPMDataBalanceStep.InvPlanBalanceParam(batchCalcService, planTypeCalc, new ArrayList<RowData>(1));
                invPlanBalanceParam.setSurplus(isSurplus);
                invPlanBalanceParam.setSumSQty(sumSQty);
                invPlanBalanceParam.setRemainQty(remainQty);
                invPlanBalanceParam.setOrigRequireNotOccupy(is_inv_water_level);
                invPlanBalanceParam.setDateTime(MRPUtil.getNetRequireDateTimeByCalendar((IMRPEnvProvider)ctx, (Long)((Long)MRPUtil.convert((Object)requireData.getValue(DefaultField.RequireField.DATE.getName()), (Object)System.currentTimeMillis())), (RequireRowData)requireData));
                this.invLevelRequireQuotaAndBatchCalc(requireData, invQty, rQty, invPlanBalanceParam);
                isSurplus = true;
            }
        }
        return isSurplus;
    }

    protected void beforeSingleModifyOccupy(RequireRowData requireData, IMRPEnvProvider ctx) {
        IMRPCalcNetDemandPlugin imrpCalcNetDemandPlugin = ctx.getMRPCalcNetDemandPlugin();
        if (imrpCalcNetDemandPlugin != null) {
            imrpCalcNetDemandPlugin.beforeSingleModifyOccupy(ctx.getMrpSdkEnv(), (IRowData)requireData);
        }
    }

    protected boolean isMatchSupply(IMRPEnvProvider ctx, RequireRowData requireData, RowData supply) {
        IMRPCalcNetDemandPlugin imrpCalcNetDemandPlugin = ctx.getMRPCalcNetDemandPlugin();
        if (imrpCalcNetDemandPlugin != null) {
            return imrpCalcNetDemandPlugin.isMatchSupply(ctx.getMrpSdkEnv(), (IRowData)requireData, (IRowData)supply);
        }
        return true;
    }

    protected List<Integer> sortSupplyByRequire(IMRPEnvProvider ctx, List<Integer> supplys, RequireRowData requireData) {
        IMRPCalcNetDemandPlugin imrpCalcNetDemandPlugin = ctx.getMRPCalcNetDemandPlugin();
        if (imrpCalcNetDemandPlugin != null) {
            return imrpCalcNetDemandPlugin.sortSupplyByRequire(ctx.getMrpSdkEnv(), (IResModelDataTable)ctx.supplyDatas(), supplys, (IRowData)requireData);
        }
        return supplys;
    }

    protected List<Integer> findSupplys(boolean isCenterWarehouseCycle, RowData requireData, IMRPEnvProvider ctx) {
        RequireDataModel requireDataModel = (RequireDataModel)ctx.getService(RequireDataModel.class);
        boolean havNullValueMatch = requireDataModel.r2sHavSNullValueMatch();
        return DataMatchUtils.findSupplysUtil((boolean)isCenterWarehouseCycle, (RowData)requireData, (IMRPEnvProvider)ctx, (havNullValueMatch && this.isNullValueMatch ? 1 : 0) != 0);
    }

    private boolean isCenterTrans(IMRPEnvProvider ctx, String requireOrgId) {
        PlanModel planModel = (PlanModel)ctx.getService(PlanModel.class);
        return planModel.isOnWayTransfer(requireOrgId);
    }
}

