/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.calcnode.framework.step;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mmc.mrp.calcnode.framework.step.AbstractMRPSubStep;
import kd.mmc.mrp.calcnode.framework.step.result.DependentReqResult;
import kd.mmc.mrp.common.consts.PlanScopeRelationConst;
import kd.mmc.mrp.common.enums.CopTypeEnum;
import kd.mmc.mrp.common.util.DynamicObjDataUtil;
import kd.mmc.mrp.common.util.SerializableUtils;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.MRPWorkCalendarManager;
import kd.mmc.mrp.framework.MultiThreadCacheManager;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.framework.consts.Tips;
import kd.mmc.mrp.integrate.entity.CacheDatas;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.integrate.entity.PlanScopeModel;
import kd.mmc.mrp.model.date.OrgBasedCalendarModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.enums.MultiThreadCacheKey;
import kd.mmc.mrp.model.enums.select.LeadType;
import kd.mmc.mrp.model.enums.strategy.BillSupplyStrategy;
import kd.mmc.mrp.model.enums.strategy.MaterialAttribute;
import kd.mmc.mrp.model.struct.OrgSupplyStruct;
import kd.mmc.mrp.model.struct.ReplaceMaterialStruct;
import kd.mmc.mrp.model.struct.ReplaceStruct;
import kd.mmc.mrp.model.struct.SupplyOrgTypeStruct;
import kd.mmc.mrp.model.struct.SupplyStruct;
import kd.mmc.mrp.model.table.DataBalanceTable;
import kd.mmc.mrp.model.table.GridData;
import kd.mmc.mrp.model.table.MemoryGrid;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.table.res.BOMStructDataTable;
import kd.mmc.mrp.model.table.utils.DataBalanceUtil;
import kd.mmc.mrp.model.table.utils.DataMatchUtils;
import kd.mmc.mrp.model.table.utils.InvPlanUtil;
import kd.mmc.mrp.model.table.utils.ReplaceUtil;
import kd.mmc.mrp.model.wrapper.SimplePlanOrder;
import kd.mmc.mrp.mservice.GenOrderBomService;
import kd.mmc.mrp.utils.MRPUtil;
import kd.sdk.mmc.mrp.extpoint.IMRPCalcNetDemandPlugin;
import kd.sdk.mmc.mrp.framework.res.IRowData;

public class MRPMDependentReqStep
extends AbstractMRPSubStep {
    protected static final Log logger = LogFactory.getLog(MRPMDependentReqStep.class);
    private HashMap<String, Integer> bomCache = new HashMap();
    private HashMap<String, List<Integer>> bomChildrenCache = new HashMap();
    private StringBuilder keyBuffer = new StringBuilder();
    private long start;
    private long findBomChildrenTime = 0L;
    private final boolean isDynamicBOM;
    private Set<Integer> configBomCache = new HashSet<Integer>(16);
    private Map<Integer, Long> configToNewBomId = new HashMap<Integer, Long>(16);

    public MRPMDependentReqStep(IMRPEnvProvider ctx) {
        super(ctx);
        this.isDynamicBOM = (Boolean)ctx.getCfgValue(EnvCfgItem.DYNAMIC_BOM_RESTORE);
    }

    @Override
    protected DependentReqResult executeImpl() {
        RequireRowData rData;
        DataBalanceTable.RSMapping mapping;
        DependentReqResult ret = new DependentReqResult();
        int startIdx = (Integer)MultiThreadCacheManager.getCacheData((MultiThreadCacheKey)MultiThreadCacheKey.KEY_MAPPING_START_IDX);
        int endIdx = (Integer)MultiThreadCacheManager.getCacheData((MultiThreadCacheKey)MultiThreadCacheKey.KEY_MAPPING_END_IDX);
        Iterator iter = this.ctx.calcBalanceDetails().getUnVisitedMappings(startIdx, endIdx);
        long redisAccTime = 0L;
        long findBomTime = 0L;
        long calcDateTime = 0L;
        HashMap<String, String> po2Exception = new HashMap<String, String>(16);
        HashMap<String, Integer> po2BomIdx = new HashMap<String, Integer>(16);
        while (iter.hasNext()) {
            BigDecimal rQty;
            this.start = System.currentTimeMillis();
            this.ctx.testEnvStatus();
            redisAccTime += System.currentTimeMillis() - this.start;
            mapping = (DataBalanceTable.RSMapping)iter.next();
            rData = mapping.getRequire();
            String order = rData.getString(DefaultField.RequireField.__INVLEVEL_BILLNUMBER__.getName());
            if (StringUtils.isBlank((CharSequence)order)) {
                order = rData.getString(DefaultField.RequireField.__BATCHPOLICY_BILLNUMBER__.getName());
            }
            if (!mapping.isCreateDepentRequire()) {
                rQty = mapping.getrQty();
                this.calcDate(rData, rQty);
            }
            if (!mapping.isGenPlanOrder()) continue;
            if (mapping.getMt() == DataBalanceTable.MatchType.LESS) {
                this.start = System.currentTimeMillis();
                rQty = mapping.getrQty();
                this.calcDate(rData, rQty);
                calcDateTime += System.currentTimeMillis() - this.start;
                if (BigDecimal.ZERO.compareTo(rQty) >= 0) continue;
                Integer mAttr = (Integer)MRPUtil.convert((Object)mapping.getRequire().getValue(DefaultField.RequireField.MATERIALATTR.getName()), (Object)MaterialAttribute.PURCHASEDPART.getValue());
                int bomRowIdx = -1;
                if (MaterialAttribute.PURCHASEDPART.getValue() != mAttr.intValue()) {
                    this.start = System.currentTimeMillis();
                    bomRowIdx = this.findBOM((RowData)rData, rQty);
                    findBomTime += System.currentTimeMillis() - this.start;
                }
                if (bomRowIdx != -1) {
                    mapping.setBom(this.ctx.bomDatas().fetchRow(bomRowIdx));
                    String bomFID = String.valueOf(mapping.getBom().getValue(DefaultField.BOMField.BOMID.getName()));
                    this.ctx.bomDatas().setFilter(null);
                    this.start = System.currentTimeMillis();
                    List<Integer> children = this.findBOMChildren(bomFID, true);
                    this.findBomChildrenTime += System.currentTimeMillis() - this.start;
                    if (children.isEmpty()) {
                        mapping.setBom(null);
                    } else {
                        if (StringUtils.isNotBlank((CharSequence)order)) {
                            po2BomIdx.put(order, bomRowIdx);
                        }
                        this.updateRDataBomField(rData, mapping.getBom(), bomFID);
                    }
                    HashMap<Integer, BigDecimal> parentQuota = new HashMap<Integer, BigDecimal>(16);
                    HashMap<Integer, BigDecimal> rQtyMap = new HashMap<Integer, BigDecimal>(16);
                    HashMap<Integer, Integer> parentBalancePeriod = new HashMap<Integer, Integer>(16);
                    mapping.setChildren(new ArrayList());
                    HashMap<String, ReplaceStruct> repStructs = new HashMap<String, ReplaceStruct>(16);
                    for (int i = 0; i < children.size(); ++i) {
                        this.start = System.currentTimeMillis();
                        this.ctx.testEnvStatus();
                        redisAccTime += System.currentTimeMillis() - this.start;
                        int childIdx = children.get(i);
                        ++this.dataAmount;
                        this.createDependentRequire(mapping, rData, rQty, rQtyMap, parentQuota, parentBalancePeriod, repStructs, children, childIdx, bomFID, i);
                    }
                    this.SerializableReplaceStruct(mapping);
                    continue;
                }
                if (MaterialAttribute.PURCHASEDPART.getValue() == mAttr.intValue()) continue;
                String msg = MRPUtil.appendExceptionMsg((Object)rData.getValue(DefaultField.RequireField.EXCEPTIONMESSAGE.getName()), (String)ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5236\u9020BOM", (String)"MRPMDependentReqStep_4", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0]));
                rData.update(DefaultField.RequireField.EXCEPTIONMESSAGE.getName(), (Object)msg);
                String num = MRPUtil.appendExceptionNumber((Object)rData.getValue(DefaultField.RequireField.EXCEPTIONNUMBER.getName()), (String)"30");
                rData.update(DefaultField.RequireField.EXCEPTIONNUMBER.getName(), (Object)num);
                Boolean isInvLevel = MRPUtil.convert((Object)rData.getValue(DefaultField.RequireField.__INVLEVEL_REQUIRE__.getName()), (Boolean)Boolean.FALSE);
                String poNum = rData.getString(DefaultField.RequireField.__INVLEVEL_BILLNUMBER__.getName());
                if (isInvLevel == null || !isInvLevel.booleanValue() || poNum == null) continue;
                po2Exception.put(poNum, String.format("%s\u0001%s", num, msg));
                continue;
            }
            if ((mapping.getSupplys() == null || mapping.getSupplys().isEmpty()) && mapping.getMt() == DataBalanceTable.MatchType.EQUAL) {
                String materialId = String.valueOf(mapping.getRequire().getValue(DefaultField.RequireField.MATERIAL.getName()));
                if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                    logger.warn(String.format("mrprunner-empty-mapping-datas, mid: %s", materialId), (Throwable)new RuntimeException());
                }
            }
            mapping.setrQty(BigDecimal.ZERO);
        }
        if (!po2Exception.isEmpty()) {
            iter = this.ctx.calcBalanceDetails().getUnVisitedMappings(startIdx, endIdx);
            while (iter.hasNext()) {
                mapping = (DataBalanceTable.RSMapping)iter.next();
                rData = mapping.getRequire();
                List poList = mapping.getPoList();
                if (poList == null || poList.isEmpty()) continue;
                for (SimplePlanOrder po : poList) {
                    String exception = (String)po2Exception.get(po.getNumber());
                    if (exception == null) continue;
                    String[] str1 = exception.split("\u0001");
                    String msg = str1[1];
                    rData.update(DefaultField.RequireField.EXCEPTIONMESSAGE.getName(), (Object)msg);
                    String num = str1[0];
                    rData.update(DefaultField.RequireField.EXCEPTIONNUMBER.getName(), (Object)num);
                }
            }
        }
        if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("ctxid: %s, mrprunner-mrpmdependentreq-cacheacctime timecost: %s(ms)", this.ctx.getMRPContextId(), redisAccTime));
            logger.warn(String.format("ctxid: %s, mrprunner-mrpmdependentreq-findBomTime timecost: %s(ms)", this.ctx.getMRPContextId(), findBomTime));
            logger.warn(String.format("ctxid: %s, mrprunner-mrpmdependentreq-findBomChildrenTime timecost: %s(ms)", this.ctx.getMRPContextId(), this.findBomChildrenTime));
            logger.warn(String.format("ctxid: %s, mrprunner-mrpmdependentreq-calcDateTime timecost: %s(ms)", this.ctx.getMRPContextId(), calcDateTime));
        }
        this.ctx.getPo2BomIdx().putAll(po2BomIdx);
        return ret;
    }

    protected void updateRDataBomField(RequireRowData rData, RowData bom, String bomFID) {
        rData.update(DefaultField.RequireField.ECN.getName(), bom.getValue(DefaultField.BOMField.ECN.getName()));
        String superBomId = String.valueOf(bom.getValue(DefaultField.BOMField.__SUPER_BOMID__.getName()));
        if (DynamicObjDataUtil.isNullStringOr0Long((String)superBomId)) {
            superBomId = bomFID;
        }
        rData.update(DefaultField.RequireField.__BOMID__.getName(), (Object)superBomId);
        rData.update(DefaultField.RequireField.__BOM_VERSION__.getName(), bom.getValue(DefaultField.BOMField.BOMVERSION.getName()));
        rData.update(DefaultField.RequireField.BOMNUMBER.getName(), bom.getValue(DefaultField.BOMField.BOMNUMBER.getName()));
    }

    protected void createDependentRequire(DataBalanceTable.RSMapping mapping, RequireRowData rData, BigDecimal rQty, HashMap<Integer, BigDecimal> rQtyMap, HashMap<Integer, BigDecimal> parentQuota, HashMap<Integer, Integer> parentBalancePeriod, Map<String, ReplaceStruct> repStructs, List<Integer> children, int childIdx, String bomFID, int childrenListIdx) {
        RequireRowData row;
        boolean isVirtualRequire;
        Integer delayDays;
        Object[] data;
        Long snt;
        boolean isFilter;
        RowData bomEntryRow = this.ctx.bomDatas().fetchRow(childIdx);
        RequireRowData dependent = rData.clone();
        dependent.update(DefaultField.RequireField.__ISDEPENDENT__.getName(), (Object)1);
        String copType = String.valueOf(bomEntryRow.getValue(DefaultField.BOMField.COPTYPE.getName()));
        boolean isCop = CopTypeEnum.fromValue((String)copType) != null;
        BigDecimal quota = MRPUtil.toBigDecimal((Object)bomEntryRow.getValue(DefaultField.BOMField.CHILDQTY.getName()));
        String qtyType = bomEntryRow.getValue(DefaultField.BOMField.CHILDAMTTYPE.getName()) == null ? "A" : (String)bomEntryRow.getValue(DefaultField.BOMField.CHILDAMTTYPE.getName());
        BigDecimal qty = quota;
        if (qtyType.equalsIgnoreCase("A") || qtyType.equalsIgnoreCase("C")) {
            qty = rQtyMap.containsKey(childIdx) ? MRPUtil.multiply((BigDecimal)rQtyMap.get(childIdx), (BigDecimal)qty) : MRPUtil.multiply((BigDecimal)rQty, (BigDecimal)qty);
        }
        String childMid = String.valueOf(bomEntryRow.getValue(DefaultField.BOMField.CHILDMATERIAL.getName()));
        String org = String.valueOf(rData.getString(DefaultField.RequireField.SUPPLYORGUNIT.getName()));
        MRPUtil.findWastageFormula((IMRPEnvProvider)this.ctx, (RowData)bomEntryRow, (String)childMid, (String)org);
        qty = MRPUtil.calcYield(null, (Object)bomEntryRow.getValue(DefaultField.BOMField.CHILDUNIT.getName()), (BigDecimal)qty, (IMRPEnvProvider)this.ctx, (boolean)true);
        BigDecimal reqQty = MRPUtil.calScrapRation((IMRPEnvProvider)this.ctx, (BigDecimal)qty, (RowData)bomEntryRow);
        dependent.update(DefaultField.RequireField.MATERIALFLEXPROPS.getName(), bomEntryRow.getValue(DefaultField.BOMField.ENTRYMATERIALFLEXPROP.getName()));
        dependent.update(DefaultField.RequireField.PRODUCTIONORGUNIT.getName(), rData.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()));
        dependent.update(DefaultField.RequireField.MATERIAL.getName(), bomEntryRow.getValue(DefaultField.BOMField.CHILDMATERIAL.getName()));
        if ((Long)MRPUtil.convert((Object)dependent.getValue(DefaultField.RequireField.MATERIAL.getName()), (Object)0L) <= 0L) {
            logger.warn(String.format("ctxid: %s, mrprunner-mrpmdependentreq-isempty bomentry : %s", this.ctx.getMRPContextId(), bomEntryRow));
            return;
        }
        dependent.update(DefaultField.RequireField.QTY.getName(), (Object)reqQty);
        dependent.update(DefaultField.RequireField.STAND_QTY.getName(), (Object)qty);
        dependent.update(DefaultField.RequireField.__REAL_QUATA__.name(), (Object)quota);
        dependent.update(DefaultField.RequireField.ECN.getName(), bomEntryRow.getValue(DefaultField.BOMField.CHILDECN.getName()));
        dependent.update(DefaultField.RequireField.BASEUNIT.getName(), bomEntryRow.getValue(DefaultField.BOMField.CHILDUNIT.getName()));
        dependent.update(DefaultField.RequireField.__BOM_VERSION__.getName(), bomEntryRow.getValue(DefaultField.BOMField.CHILDBOMVERSION.getName()));
        dependent.update(DefaultField.RequireField.__CHILDTYPE__.getName(), bomEntryRow.getValue(DefaultField.BOMField.CHILDTYPE.getName()));
        dependent.update(DefaultField.RequireField.__CHILDAMTTYPE__.getName(), bomEntryRow.getValue(DefaultField.BOMField.CHILDAMTTYPE.getName()));
        dependent.update(DefaultField.RequireField.__CHILDNUMERATOR__.getName(), bomEntryRow.getValue(DefaultField.BOMField.CHILDNUMERATOR.getName()));
        dependent.update(DefaultField.RequireField.__CHILDDENOMINATOR__.getName(), bomEntryRow.getValue(DefaultField.BOMField.CHILDDENOMINATOR.getName()));
        dependent.update(DefaultField.RequireField.__CHILDQTY__.getName(), bomEntryRow.getValue(DefaultField.BOMField.CHILDQTY.getName()));
        dependent.update(DefaultField.RequireField.__CHILDFIXSCRAP__.getName(), bomEntryRow.getValue(DefaultField.BOMField.CHILDFIXEDSCRAP.getName()));
        dependent.update(DefaultField.RequireField.__IS_KEYPART__.getName(), bomEntryRow.getValue(DefaultField.BOMField.__IS_KEY_MATERIAL__.getName()));
        dependent.update(DefaultField.RequireField.__EXIST_KEYPART__.getName(), bomEntryRow.getValue(DefaultField.BOMField.__EXIST_KEYPART__.getName()));
        dependent.update(DefaultField.RequireField.__BOM_IDX__.getName(), (Object)childIdx);
        dependent.update(DefaultField.RequireField.__CHILDSUPPLYTYPE__.getName(), bomEntryRow.getValue(DefaultField.BOMField.CHILDSUPPLYTYPE.getName()));
        dependent.update(DefaultField.RequireField.__PARENT_BOMID__.getName(), rData.getValue(DefaultField.RequireField.__BOMID__.getName()));
        dependent.update(DefaultField.RequireField.__BOMID__.getName(), null);
        dependent.update(DefaultField.RequireField.BOMNUMBER.getName(), null);
        dependent.update(DefaultField.RequireField.PARENT_BOMNUMBER.getName(), bomEntryRow.getValue(DefaultField.BOMField.BOMNUMBER.getName()));
        dependent.update(DefaultField.RequireField.__PARENT_MATERIAL__.getName(), rData.getValue(DefaultField.RequireField.MATERIAL.getName()));
        dependent.update(DefaultField.RequireField.__REAL_PARENT_MATERIAL__.getName(), bomEntryRow.getValue(DefaultField.BOMField.MATERIAL.getName()));
        dependent.update(DefaultField.RequireField.REPLACEPLAN.getName(), bomEntryRow.getValue(DefaultField.BOMField.REPLACEPLAN.getName()));
        dependent.update(DefaultField.RequireField.ISREPLACEPLANMM.getName(), bomEntryRow.getValue(DefaultField.BOMField.ISREPLACEPLANMM.getName()));
        dependent.update(DefaultField.RequireField.ISREPLACE.getName(), bomEntryRow.getValue(DefaultField.BOMField.ISREPLACE.getName()));
        dependent.update(DefaultField.RequireField.REPLACEPRIORITY.getName(), bomEntryRow.getValue(DefaultField.BOMField.REPLACEPRIORITY.getName()));
        dependent.update(DefaultField.RequireField.REPLACESTRA.getName(), bomEntryRow.getValue(DefaultField.BOMField.REPLACESTRA.getName()));
        dependent.update(DefaultField.RequireField.REPLACEMETHOD.getName(), bomEntryRow.getValue(DefaultField.BOMField.REPLACEMETHOD.getName()));
        dependent.update(DefaultField.RequireField.__SCRAPRATIO__.getName(), bomEntryRow.getValue(DefaultField.BOMField.WASTAGERATE.getName()));
        dependent.update(DefaultField.RequireField.__DYNAMICSCRAPRATIO__.getName(), bomEntryRow.getValue(DefaultField.BOMField.CHILDSCRAPRATE.getName()));
        dependent.update(DefaultField.RequireField.__FIXSCRAP__.getName(), bomEntryRow.getValue(DefaultField.BOMField.CHILDFIXEDSCRAP.getName()));
        dependent.update(DefaultField.RequireField.__DYNAMICSCRAPFORMULA__.getName(), bomEntryRow.getValue(DefaultField.BOMField.WASTAGERATEFORMULA.getName()));
        dependent.update(DefaultField.RequireField.__LEADTIME__.getName(), bomEntryRow.getValue(DefaultField.BOMField.CHILDPRODUCEDELAYTIME.getName()));
        if (MRPUtil.convert((Object)dependent.getValue(DefaultField.RequireField.__IS_EXPANDABLE__.getName()), (Boolean)Boolean.TRUE).booleanValue()) {
            dependent.update(DefaultField.RequireField.__IS_EXPANDABLE__.getName(), bomEntryRow.getValue(DefaultField.BOMField.ISPASSREQ.getName()));
        }
        dependent.update(DefaultField.RequireField.__COPTYPE__.getName(), bomEntryRow.getValue(DefaultField.BOMField.COPTYPE.getName()));
        dependent.update(DefaultField.RequireField.__COPOPERATION__.getName(), bomEntryRow.getValue(DefaultField.BOMField.COPOPERATION.getName()));
        dependent.update(DefaultField.RequireField.__CHILDVALIDDATE__.getName(), bomEntryRow.getValue(DefaultField.BOMField.CHILDVALIDDATE.getName()));
        dependent.update(DefaultField.RequireField.__CHILDINVALIDDATE__.getName(), bomEntryRow.getValue(DefaultField.BOMField.CHILDINVALIDDATE.getName()));
        dependent.update(DefaultField.RequireField.__ENTRYAUXPROPERTY__.getName(), bomEntryRow.getValue(DefaultField.BOMField.ENTRYMATERIALFLEXPROP.getName()));
        dependent.update(DefaultField.RequireField.__REMARK__.getName(), bomEntryRow.getValue(DefaultField.BOMField.REMARK.getName()));
        dependent.update(DefaultField.RequireField.CONFIGUREDCODE.getName(), bomEntryRow.getValue(DefaultField.BOMField.ENTRYCONFIGUREDCODE.getName()));
        dependent.update(DefaultField.RequireField.ISDEPENTREQ.getName(), (Object)false);
        dependent.update(DefaultField.RequireField.__BOM_ENTRYID__.getName(), bomEntryRow.getValue(DefaultField.BOMField.ENTRYID.getName()));
        dependent.update(DefaultField.RequireField.MATERIALATTR.getName(), null);
        this.clearDependRequireField(dependent);
        dependent.update(DefaultField.RequireField.PARENT_STRATEGY.getName(), rData.getValue(DefaultField.RequireField.PLAN_STRATEGY.getName()));
        Map info = this.ctx.getMaterialPlanInfo((String)MRPUtil.convert((Object)dependent.getValue(DefaultField.RequireField.MATERIAL.getName()), (Object)""), (String)MRPUtil.convert((Object)dependent.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()), (Object)""), new HashMap(InvPlanUtil.getExtendValMap((CalEnv)this.ctx, (RowData)dependent, (int)0)));
        boolean notHavInfo = false;
        if (info == null) {
            notHavInfo = !isCop;
            info = new HashMap(0);
        }
        dependent.update(DefaultField.RequireField.__CHILDMATERIALPLAN__.getName(), MRPUtil.convert(info.get("id"), (Object)0L));
        if (bomEntryRow.getValue(DefaultField.BOMField.CHILDMATERIALATTR.getName()) != null) {
            dependent.update(DefaultField.RequireField.MATERIALATTR.getName(), bomEntryRow.getValue(DefaultField.BOMField.CHILDMATERIALATTR.getName()));
        } else {
            dependent.update(DefaultField.RequireField.MATERIALATTR.getName(), MRPUtil.convert(info.get("materialattr"), (Object)""));
        }
        boolean isJump = MRPUtil.convert((Object)bomEntryRow.getValue(DefaultField.BOMField.ISJUMP.getName()), (Boolean)Boolean.FALSE);
        if (this.isFabricatedpart(dependent) && !isJump) {
            dependent.update(DefaultField.RequireField.SUPPLYORGUNIT.getName(), null);
        } else {
            dependent.update(DefaultField.RequireField.SUPPLYORGUNIT.getName(), dependent.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
        }
        boolean flag = this.syncDateCalcSettings(rData, dependent, bomEntryRow, parentBalancePeriod.getOrDefault(childIdx, 0));
        if (!flag) {
            this.updateException(dependent, bomEntryRow, mapping, "87", ResManager.loadKDString((String)"BOM\u5df2\u7ecf\u5931\u6548", (String)"MRPMDependentReqStep_6", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0]), true);
            return;
        }
        String replaceKey = this.getReplaceKey(bomEntryRow);
        boolean bl = isFilter = this.ctx.isReplace() && !this.ctx.bomDatas().getMainMaterialGroup().containsKey(replaceKey) && MRPUtil.convert((Object)bomEntryRow.getValue(DefaultField.BOMField.ISREPLACE.getName()), (Boolean)Boolean.FALSE) != false;
        if (isFilter) {
            dependent.update(DefaultField.RequireField.QTY.getName(), (Object)BigDecimal.ZERO);
            dependent.update(DefaultField.RequireField.STAND_QTY.getName(), (Object)BigDecimal.ZERO);
            dependent = DataBalanceUtil.fillDependentRequire((RowData)bomEntryRow, (RequireRowData)dependent, (IMRPEnvProvider)this.ctx);
            mapping.addChild(dependent);
            return;
        }
        if (notHavInfo) {
            this.updateException(dependent, bomEntryRow, mapping, "90", ResManager.loadKDString((String)"\u672a\u627e\u5230\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u6216\u8ba1\u5212\u65b9\u5f0f\u4e0d\u4e00\u81f4\u3002", (String)"MRPMDependentReqStep_3", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0]));
            return;
        }
        this.doUpdateDate(rData, dependent);
        this.updateDependRequire(rData, dependent, bomEntryRow);
        PlanModel planModel = (PlanModel)this.ctx.getService(PlanModel.class);
        CacheDatas cacheDatas = (CacheDatas)this.ctx.getService(CacheDatas.class);
        Long parent_planscope = (Long)MRPUtil.convert((Object)rData.getValue(DefaultField.RequireField.PLANSCOPE.getName()), (Object)0L);
        Long orgId = Long.parseLong(org);
        Long[] values = new Long[]{orgId, 0L, 0L};
        String cacheKey = PlanScopeRelationConst.getRedisPlanScopeRelationKey((String)org, (String)childMid);
        Long supply_network = MRPUtil.getLong(info, (String)"supplynetwork");
        String cacheValue = cacheDatas.getPlanScopeCache(cacheKey, parent_planscope.toString(), true);
        if (cacheValue != null && (snt = (Long)MRPUtil.convert((Object)(data = (Object[])JSON.parseObject((String)cacheValue, Object[].class))[2], (Object)0L)) > 0L) {
            supply_network = snt;
        }
        boolean isCross = false;
        SupplyOrgTypeStruct defSupplyOrgTypeStruct = null;
        if (supply_network != null && supply_network > 0L) {
            defSupplyOrgTypeStruct = planModel.getSupplyOrgTypeStruct(supply_network, (String)MRPUtil.convert((Object)dependent.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()), (Object)""), (String)MRPUtil.convert((Object)dependent.getValue(DefaultField.RequireField.MATERIAL.getName()), (Object)""));
        }
        if (defSupplyOrgTypeStruct != null) {
            BillSupplyStrategy supplyStrategy = null;
            Long supply_org = null;
            for (Map.Entry entry : defSupplyOrgTypeStruct.getMap().entrySet()) {
                supplyStrategy = ((OrgSupplyStruct)entry.getValue()).getStrategy();
                supply_org = Long.parseLong((String)entry.getKey());
                if (supplyStrategy == null) continue;
                break;
            }
            if (supplyStrategy != null && supplyStrategy == BillSupplyStrategy.RECEIVE) {
                isCross = true;
                dependent.update(DefaultField.RequireField.DEMAND_SUPPLY_STRATEGY.getName(), (Object)supplyStrategy.getValue());
                info = this.ctx.getMaterialPlanInfo((String)MRPUtil.convert((Object)dependent.getValue(DefaultField.RequireField.MATERIAL.getName()), (Object)""), supply_org.toString(), new HashMap(InvPlanUtil.getExtendValMap((CalEnv)this.ctx, (RowData)dependent, (int)0)));
                if (info != null) {
                    dependent.update(DefaultField.RequireField.__CHILDMATERIALPLAN__.getName(), MRPUtil.convert(info.get("id"), (Object)0L));
                    dependent.update(DefaultField.RequireField.MATERIALATTR.getName(), MRPUtil.convert(info.get("materialattr"), (Object)""));
                }
                dependent.update(DefaultField.RequireField.SUPPLYORGUNIT.getName(), (Object)supply_org);
                if (planModel.isEnablePlanScope()) {
                    Object[] newMftDatas = cacheDatas.getMftData4OrgAndMaterial(supply_org, Long.valueOf(Long.parseLong(childMid)));
                    Long warehouse = (Long)MRPUtil.convert((Object)newMftDatas[1], (Object)0L);
                    Long location = (Long)MRPUtil.convert((Object)newMftDatas[2], (Object)0L);
                    Long scopeId = cacheDatas.getPlanScope4orgAndWarehouse(supply_org, warehouse);
                    cacheValue = cacheDatas.getPlanScopeCache(PlanScopeRelationConst.getRedisPlanScopeRelationKey((String)supply_org.toString(), (String)childMid), scopeId.toString(), true);
                    if (cacheValue != null) {
                        Object[] data2 = (Object[])JSON.parseObject((String)cacheValue, Object[].class);
                        warehouse = (Long)MRPUtil.convert((Object)data2[8], (Object)0L);
                        location = (Long)MRPUtil.convert((Object)data2[9], (Object)0L);
                    }
                    values = new Long[]{supply_org, warehouse, location};
                } else {
                    values = new Long[]{supply_org, 0L, 0L};
                }
            }
        }
        if ((delayDays = (Integer)bomEntryRow.getValue(DefaultField.BOMField.CHILDPRODUCEDELAYTIME.getName())) == null) {
            delayDays = 0;
        }
        int childAttr = (Integer)MRPUtil.convert((Object)dependent.getValue(DefaultField.RequireField.MATERIALATTR.getName()), (Object)MaterialAttribute.OTHER.getValue());
        boolean isPhanto = MaterialAttribute.PHANTOMPART.getValue() == childAttr;
        String mid = String.valueOf(dependent.getValue(DefaultField.RequireField.MATERIAL.getName()));
        if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("mrprunner-dependent-req-resolve, mid: %s, mattr: %s, isJump: %s, bom-detail: %s", mid, childAttr, isJump, bomEntryRow));
        }
        boolean bl2 = isVirtualRequire = childAttr != MaterialAttribute.PURCHASEDPART.getValue() && (isPhanto || isJump) && !isCop;
        if (isVirtualRequire) {
            this.ctx.bomDatas().setFilter(null);
            qty = MRPUtil.toBigDecimal((Object)bomEntryRow.getValue(DefaultField.BOMField.CHILDQTY.getName()));
            String configProperties = cacheDatas.getConfigProperties(childMid);
            dependent.update(DefaultField.RequireField.CONFIGPROPERTIES.getName(), (Object)configProperties);
            dependent.update(DefaultField.RequireField.IS_VIRTUAL_REQUIRE.getName(), (Object)true);
            int bomRowIdx = this.findBOM((RowData)dependent);
            if (bomRowIdx == -1) {
                this.updateException(dependent, bomEntryRow, mapping, "30", ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5236\u9020BOM", (String)"MRPMDependentReqStep_4", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0]));
                this.onlyUpdateException(dependent, "112", ResManager.loadKDString((String)"\u865a\u62df\u4ef6\u9700\u6c42\u4e0d\u53c2\u4e0eMRP\u8ba1\u7b97", (String)"MRPMDependentReqStep_7", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0]));
            } else {
                bomFID = String.valueOf(this.ctx.bomDatas().getValue(DefaultField.BOMField.BOMID.getName(), bomRowIdx));
                this.start = System.currentTimeMillis();
                List<Integer> children2 = this.findBOMChildren(bomFID, false);
                this.findBomChildrenTime += System.currentTimeMillis() - this.start;
                for (Integer idx : children2) {
                    rQtyMap.put(idx, reqQty);
                    if (parentBalancePeriod.containsKey(childIdx)) {
                        parentBalancePeriod.put(idx, parentBalancePeriod.get(childIdx) + delayDays);
                        continue;
                    }
                    parentBalancePeriod.put(idx, delayDays);
                }
                children.addAll(childrenListIdx + 1, children2);
                bomFID = String.valueOf(mapping.getBom().getValue(DefaultField.BOMField.BOMID.getName()));
                this.updateException(dependent, bomEntryRow, mapping, "112", ResManager.loadKDString((String)"\u865a\u62df\u4ef6\u9700\u6c42\u4e0d\u53c2\u4e0eMRP\u8ba1\u7b97", (String)"MRPMDependentReqStep_7", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0]));
            }
        }
        if (isCop) {
            ArrayList<RequireRowData> cops = mapping.getCops();
            if (cops == null) {
                cops = new ArrayList<RequireRowData>(16);
                mapping.setCops(cops);
            }
            cops.add(dependent);
            return;
        }
        SupplyStruct ss = (SupplyStruct)planModel.getPriorityRelations().get(org);
        if (ss != null) {
            PlanScopeModel planScopeModel = (PlanScopeModel)this.ctx.getService(PlanScopeModel.class);
            Long supplier_org = (Long)MRPUtil.convert((Object)bomEntryRow.getValue(DefaultField.BOMField.CHILDSUPPLYORGUNIT.getName()), (Object)0L);
            Long supplier_warehouse = (Long)MRPUtil.convert((Object)bomEntryRow.getValue(DefaultField.BOMField.CHILDWAREHOUSE.getName()), (Object)0L);
            Long supplier_shipping = (Long)MRPUtil.convert((Object)bomEntryRow.getValue(DefaultField.BOMField.CHILDLOCATION.getName()), (Object)0L);
            if (!isCross && planModel.isEnablePlanScope()) {
                Long parent_mftversion = (Long)MRPUtil.convert((Object)rData.getValue(DefaultField.RequireField.MFTVERSION.getName()), (Object)0L);
                Object[] parentMftVersionData = cacheDatas.getMftVersion4Id(parent_mftversion);
                Object[] mftDatas = cacheDatas.getMftData4OrgAndMaterial(orgId, Long.valueOf(Long.parseLong(childMid)));
                String invinfosrc = String.valueOf(mftDatas[6]);
                boolean isstockallot = MRPUtil.convert((Object)mftDatas[9], (Boolean)Boolean.FALSE);
                dependent.update(DefaultField.RequireField.ISSTOCKALLOT.getName(), (Object)isstockallot);
                if ("B".equalsIgnoreCase(invinfosrc)) {
                    values = planScopeModel.getSupplyOrgAndWareHouse4MaterialMftInfo(mftDatas, orgId, cacheKey);
                } else if ("C".equalsIgnoreCase(invinfosrc)) {
                    values = planScopeModel.getSupplyOrgAndWareHouse4MftVersion(parentMftVersionData, orgId, cacheKey);
                } else if ("D".equalsIgnoreCase(invinfosrc)) {
                    values = planScopeModel.getSupplyOrgAndWareHouse4MftVersionOrMftInfo(parentMftVersionData, mftDatas, orgId, cacheKey);
                } else if ("A".equalsIgnoreCase(invinfosrc)) {
                    values = planScopeModel.getSupplyOrgAndWareHouse4Bom(new Long[]{supplier_org, supplier_warehouse, supplier_shipping}, orgId, cacheKey);
                }
                if (values[0].equals(orgId)) {
                    Long mftId = (Long)MRPUtil.convert((Object)mftDatas[7], (Object)0L);
                    dependent.update(DefaultField.RequireField.MATERIALMFTINFO.getName(), (Object)mftId);
                }
            }
            dependent.update(DefaultField.RequireField.SUPPLIER_ORG.getName(), (Object)values[0]);
            dependent.update(DefaultField.RequireField.SUPPLIER_WAREHOUSE.getName(), (Object)values[1]);
            dependent.update(DefaultField.RequireField.SUPPLIER_SHIPPING.getName(), (Object)values[2]);
            dependent.update(DefaultField.RequireField.SUPPLYORGUNIT.getName(), values[0] == 0L || orgId.equals(values[0]) ? null : values[0]);
            dependent.update(DefaultField.RequireField.WAREHOUSE.getName(), (Object)values[1]);
        }
        if (isVirtualRequire) {
            return;
        }
        if (cacheDatas.isSelectMaterialPlan4PlanScope()) {
            Long productStorageOrgUnitID = DataBalanceUtil.getPlanScopeRequireOrg((RowData)dependent);
            Long warehouse = (Long)MRPUtil.convert((Object)dependent.getValue(DefaultField.RequireField.WAREHOUSE.getName()), (Object)0L);
            cacheKey = PlanScopeRelationConst.getRedisPlanScopeRelationKey((String)String.valueOf(productStorageOrgUnitID), (String)childMid);
            ss = (SupplyStruct)planModel.getPriorityRelations().get(String.valueOf(productStorageOrgUnitID));
            if (ss != null) {
                Long planScope = DataBalanceUtil.getPlanScopeByWareHouse((IMRPEnvProvider)this.ctx, (SupplyStruct)ss, (Long)productStorageOrgUnitID, (String)childMid, (boolean)false, (String)cacheKey, (Long)0L, (Long)warehouse, (boolean)true);
                dependent.update(DefaultField.RequireField.PLANSCOPE.getName(), (Object)planScope);
            }
        }
        if (!this.ctx.isReplace() && !MRPUtil.convert((Object)bomEntryRow.getValue(DefaultField.BOMField.ISREPLACE.getName()), (Boolean)Boolean.FALSE).booleanValue()) {
            row = DataBalanceUtil.fillDependentRequire((RowData)bomEntryRow, (RequireRowData)dependent, (IMRPEnvProvider)this.ctx);
            mapping.addChild(row);
        } else if (this.ctx.isReplace()) {
            row = dependent;
            HashMap mainMaterialGroup = this.ctx.bomDatas().getMainMaterialGroup();
            if (mainMaterialGroup.isEmpty() && "1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                logger.warn(String.format("ctxid: %s, mrprunner-replaceStruct-isNull", this.ctx.getMRPContextId()));
            }
            ReplaceStruct replaceStruct = repStructs.get(replaceKey);
            boolean isClone = false;
            if (replaceStruct == null) {
                isClone = true;
                replaceStruct = (ReplaceStruct)mainMaterialGroup.get(replaceKey);
            }
            if (replaceStruct == null) {
                row = DataBalanceUtil.fillDependentRequire((RowData)bomEntryRow, (RequireRowData)dependent, (IMRPEnvProvider)this.ctx);
                mapping.addChild(row);
            } else {
                if (isClone) {
                    replaceStruct = replaceStruct.clone();
                    repStructs.put(replaceKey, replaceStruct);
                }
                if (!MRPUtil.convert((Object)bomEntryRow.getValue(DefaultField.BOMField.ISREPLACE.getName()), (Boolean)Boolean.FALSE).booleanValue() && MRPUtil.convert((Object)bomEntryRow.getValue(DefaultField.BOMField.ISREPLACEPLANMM.getName()), (Boolean)Boolean.FALSE).booleanValue()) {
                    row = DataBalanceUtil.fillDependentRequire((RowData)bomEntryRow, (RequireRowData)dependent, (IMRPEnvProvider)this.ctx);
                    mapping.addChild(row);
                    row.update(DefaultField.RequireField.__REPLACE_STRUCT__.getName(), (Object)replaceStruct);
                    String uuid = (String)rData.getValue(DefaultField.RequireField.__REPLACE_KEY__.getName());
                    if (uuid == null) {
                        uuid = UUID.randomUUID().toString();
                    }
                    row.update(DefaultField.RequireField.__REPLACE_KEY__.getName(), (Object)uuid);
                    rData.update(DefaultField.RequireField.__REPLACE_KEY__.getName(), (Object)uuid);
                } else {
                    row.setBomRow(bomEntryRow);
                    if (row.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()) == null) {
                        row.update(DefaultField.RequireField.SUPPLYORGUNIT.getName(), row.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
                    }
                    this.ctx.loadRequireMaterialExtProps(row);
                    boolean isFlexPropMatch = (Boolean)this.ctx.getCfgValue(EnvCfgItem.ENABLE_MATERIAL_EXT_PROPS);
                    if (!isFlexPropMatch) {
                        ReplaceUtil.initRequireData4Replace((ReplaceStruct)replaceStruct, (RequireRowData)row);
                    } else {
                        ReplaceUtil.initRequireData4ReplaceByAuxProperty((IMRPEnvProvider)this.ctx, (ReplaceStruct)replaceStruct, (RequireRowData)row);
                    }
                }
            }
        }
    }

    private String getReplaceKey(RowData bomEntryRow) {
        String repId = String.valueOf(bomEntryRow.getValue(DefaultField.BOMField.REPLACEPLAN.getName()));
        String bomId = String.valueOf(bomEntryRow.getValue(DefaultField.BOMField.__SUPER_BOMID__.getName()));
        if (DynamicObjDataUtil.isNullStringOr0Long((String)bomId)) {
            bomId = String.valueOf(bomEntryRow.getValue(DefaultField.BOMField.BOMID.getName()));
        }
        return MRPRuntimeConsts.getReplaceKey((String)bomId, (String)repId);
    }

    protected void clearDependRequireField(RequireRowData dependent) {
        dependent.update(DefaultField.RequireField.SUPPLIER.getName(), null);
        dependent.update(DefaultField.RequireField.ONWORKQTY.getName(), null);
        dependent.update(DefaultField.RequireField.PICKEDQTY.getName(), null);
        dependent.update(DefaultField.RequireField.FLEXMETRICVALUE.getName(), null);
        dependent.update(DefaultField.RequireField.FLEXMETRICID.getName(), null);
        DataBalanceUtil.clearRequireData((RequireRowData)dependent);
    }

    private void SerializableReplaceStruct(DataBalanceTable.RSMapping mapping) {
        Iterator iter = mapping.getChildrenIterator();
        while (iter.hasNext()) {
            RequireRowData row = (RequireRowData)iter.next();
            ReplaceStruct replaceStruct = (ReplaceStruct)row.getValue(DefaultField.RequireField.__REPLACE_STRUCT__.getName());
            if (replaceStruct == null) continue;
            if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                List reps = replaceStruct.getReplaceMs();
                for (ReplaceMaterialStruct struct : reps) {
                    logger.warn(String.format("ctxid: %s, mrprunner-SerializableReplaceStruct, mid: %s, rowData: %s", this.ctx.getMRPContextId(), struct.getMaterial(), struct.getRequireRowData()));
                }
            }
            String json = SerializableUtils.toSerializedString((Object)replaceStruct);
            row.update(DefaultField.RequireField.__REPLACE_STRUCT__.getName(), (Object)json);
        }
    }

    protected void doUpdateDate(RequireRowData rData, RequireRowData dependent) {
    }

    protected void updateDependRequire(RequireRowData rData, RequireRowData dependent, RowData bomEntryRow) {
        IMRPCalcNetDemandPlugin imrpCalcNetDemandPlugin = this.ctx.getMRPCalcNetDemandPlugin();
        if (imrpCalcNetDemandPlugin != null) {
            imrpCalcNetDemandPlugin.updateDependRequire(this.ctx.getMrpSdkEnv(), (IRowData)rData, (IRowData)dependent, (IRowData)bomEntryRow);
        }
    }

    protected void calcDate(RequireRowData require, BigDecimal qty) {
        if (qty == null || qty.compareTo(BigDecimal.ZERO) <= 0) {
            qty = require.getNewQrequireQty() == null ? BigDecimal.ZERO : require.getNewQrequireQty();
        }
        Integer inspectLeadDays = (Integer)MRPUtil.convert((Object)require.getValue(DefaultField.RequireField.INSPECTLEADDAYS.getName()), (Object)0);
        Long date = (Long)require.getValue(DefaultField.RequireField.DATE.getName());
        MRPWorkCalendarManager wcm = this.ctx.dateManager();
        String supplyOrgId = String.valueOf(require.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()));
        String requireProductOrgUnitID = String.valueOf(require.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
        OrgBasedCalendarModel sOcm = wcm.get(supplyOrgId, requireProductOrgUnitID);
        date = sOcm.getDate(new Date(date), true).getTimeInMillis();
        Long end = (Long)require.getValue(DefaultField.RequireField.__END_DATE__.getName());
        if (end == null) {
            end = sOcm.getDate(new Date(date), true, inspectLeadDays.intValue()).getTimeInMillis();
            require.update(DefaultField.RequireField.__END_DATE__.getName(), (Object)end);
            Long start = (Long)require.getValue(DefaultField.RequireField.__START_DATE__.getName());
            if (start == null) {
                String leadType;
                Integer postProcessDays;
                Integer preProcessDays = (Integer)require.getValue(DefaultField.RequireField.PREPROCESSDAYS.getName());
                if (preProcessDays == null) {
                    preProcessDays = 0;
                }
                if ((postProcessDays = (Integer)require.getValue(DefaultField.RequireField.POSTPROCESSDAYS.getName())) == null) {
                    postProcessDays = 0;
                }
                if ((leadType = (String)require.getValue(DefaultField.RequireField.LEADTYPE.getName())) == null) {
                    leadType = LeadType.FIXED.getValue();
                }
                start = end - (long)preProcessDays.intValue() * 86400000L - (long)postProcessDays.intValue() * 86400000L;
                Integer leadTime = 0;
                if (LeadType.FIXED.getValue().equals(leadType)) {
                    Object fixedLeadDays = require.getValue(DefaultField.RequireField.FIXEDLEADDAYS.getName());
                    leadTime = fixedLeadDays == null ? Integer.valueOf(0) : (Integer)fixedLeadDays;
                    start = start - (long)leadTime.intValue() * 86400000L;
                } else if (LeadType.DYNAMIC.getValue().equals(leadType)) {
                    Object dynamicLeadDays = require.getValue(DefaultField.RequireField.DYNAMICLEADDAYS.getName());
                    leadTime = dynamicLeadDays == null ? Integer.valueOf(0) : (Integer)dynamicLeadDays;
                    BigDecimal dynamicBatch = MRPUtil.toBigDecimal((Object)require.getValue(DefaultField.RequireField.DYNAMICBATCH.getName()));
                    if (dynamicBatch != null) {
                        leadTime = qty.divide(dynamicBatch, 0, RoundingMode.CEILING).intValue() * leadTime;
                        start = start - (long)leadTime.intValue() * 86400000L;
                    }
                }
                start = sOcm.getDate(new Date(end), true, preProcessDays + postProcessDays + leadTime).getTimeInMillis();
                require.update(DefaultField.RequireField.__START_DATE__.getName(), (Object)start);
                require.update(DefaultField.RequireField.__ORDER_DATE__.getName(), (Object)start);
            }
        }
    }

    protected boolean syncDateCalcSettings(RequireRowData parent, RequireRowData dependent, RowData bomEntryRow, Integer parentBalancePeriod) {
        Long parentStart = (Long)parent.getValue(DefaultField.RequireField.__START_DATE__.getName());
        return this.syncDateCalcSettings(parentStart, parent, dependent, bomEntryRow, parentBalancePeriod);
    }

    protected boolean syncDateCalcSettings(Long parentStart, RequireRowData parent, RequireRowData dependent, RowData bomEntryRow, Integer parentBalancePeriod) {
        boolean ret = true;
        Long bomTime = MRPUtil.getExpendBomTime((IMRPEnvProvider)this.ctx, (RowData)parent);
        Object validdateObj = bomEntryRow.getValue(DefaultField.BOMField.CHILDVALIDDATE.getName());
        Long validdate = validdateObj != null ? Long.parseLong(validdateObj.toString()) : 0L;
        Object invaliddateObj = bomEntryRow.getValue(DefaultField.BOMField.CHILDINVALIDDATE.getName());
        Long invaliddate = invaliddateObj != null ? Long.parseLong(invaliddateObj.toString()) : 0L;
        if (validdateObj != null && invaliddateObj != null && (bomTime.compareTo(validdate) < 0 || bomTime.compareTo(invaliddate) > 0)) {
            ret = false;
        }
        OrgBasedCalendarModel cal = this.ctx.dateManager().get(String.valueOf(dependent.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName())), String.valueOf(dependent.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName())), String.valueOf(dependent.getValue(DefaultField.RequireField.MATERIAL.getName())));
        Integer delayDays = (Integer)bomEntryRow.getValue(DefaultField.BOMField.CHILDPRODUCEDELAYTIME.getName());
        if (delayDays == null) {
            delayDays = 0;
        }
        delayDays = delayDays + parentBalancePeriod;
        long start = parentStart + (long)delayDays.intValue() * 86400000L;
        if (cal != null) {
            start = cal.getDate(new Date(parentStart), false, delayDays.intValue()).getTimeInMillis();
        }
        dependent.update(DefaultField.RequireField.DATE.getName(), (Object)start);
        IMRPCalcNetDemandPlugin imrpCalcNetDemandPlugin = this.ctx.getMRPCalcNetDemandPlugin();
        if (ret && imrpCalcNetDemandPlugin != null) {
            imrpCalcNetDemandPlugin.afterDependRequireDateCalc(this.ctx.getMrpSdkEnv(), parentStart, (IRowData)parent, (IRowData)dependent, (IRowData)bomEntryRow, parentBalancePeriod);
        }
        return ret;
    }

    protected boolean isFabricatedpart(RequireRowData row) {
        int value = (Integer)MRPUtil.convert((Object)row.getValue(DefaultField.RequireField.MATERIALATTR.getName()), (Object)10070);
        return MaterialAttribute.STORAGEPART.getValue() == value;
    }

    private int findBOM(RowData requireData) {
        return this.findBOM(requireData, null);
    }

    public int findBOM(RowData requireData, BigDecimal rQty) {
        String mid = String.valueOf(requireData.getValue(DefaultField.RequireField.MATERIAL.getName()));
        if (this.isDynamicBOM && this.ctx.bomDatas().getAlreadyDynamicRestoreBOMMaterial().add(mid)) {
            try (TraceSpan ts = Tracer.create((String)"MRPMDependentReqStep.loadDynamicBOM", (String)"loadDynamicBOM");){
                List datas = MRPCacheManager.getInst().getBOMTableSrcDataByGroup((CalEnv)this.ctx, mid);
                this.ctx.bomDatas().restoreDatas(datas);
            }
        }
        boolean mrp_consider_pro_version_to_bom = MRPUtil.convert((Object)this.ctx.getCfgValue(EnvCfgItem.MRP_CONSIDER_PRO_VERSION_TO_BOM), (Boolean)Boolean.FALSE);
        Long bomId = 0L;
        Long org = (Long)MRPUtil.convert((Object)requireData.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()), (Object)0L);
        if (org <= 0L) {
            org = (Long)MRPUtil.convert((Object)requireData.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()), (Object)0L);
        }
        Long matid = (Long)MRPUtil.convert((Object)requireData.getValue(DefaultField.RequireField.MATERIAL.getName()), (Object)0L);
        Long configId = (Long)MRPUtil.convert((Object)requireData.getValue(DefaultField.RequireField.CONFIGUREDCODE.getName()), (Object)0L);
        String configProperty = (String)MRPUtil.convert((Object)requireData.getValue(DefaultField.RequireField.CONFIGPROPERTIES.getName()), (Object)"");
        if (mrp_consider_pro_version_to_bom && rQty != null) {
            boolean isFlexPropMatch;
            CacheDatas cacheDatas = (CacheDatas)this.ctx.getService(CacheDatas.class);
            Long materialMftInfo = (Long)MRPUtil.convert((Object)requireData.getValue(DefaultField.RequireField.MATERIALMFTINFO.getName()), (Object)0L);
            Long material = (Long)MRPUtil.convert((Object)requireData.getValue(DefaultField.RequireField.MATERIAL.getName()), (Object)0L);
            CacheDatas.MftVersionQueryParam mftVersionQueryParam = new CacheDatas.MftVersionQueryParam(org, material);
            mftVersionQueryParam.setMaterialMftInfo(materialMftInfo);
            if ("2".equals(configProperty)) {
                mftVersionQueryParam.setConfigure(configId);
            }
            if (isFlexPropMatch = ((Boolean)this.ctx.getCfgValue(EnvCfgItem.ENABLE_MATERIAL_EXT_PROPS)).booleanValue()) {
                Long materialflexprops = (Long)MRPUtil.convert((Object)requireData.getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName()), (Object)0L);
                mftVersionQueryParam.setAuxproperty(materialflexprops);
            }
            Long[] mftVersionData = cacheDatas.getMftVersion4orgAndMftInfo(mftVersionQueryParam, MRPUtil.getExpendBomTime((IMRPEnvProvider)this.ctx, (RowData)requireData), rQty);
            requireData.update(DefaultField.RequireField.MFTVERSION.getName(), (Object)mftVersionData[3]);
            requireData.update(DefaultField.RequireField.WORKCENTER.getName(), (Object)mftVersionData[4]);
            bomId = (Long)MRPUtil.convert((Object)mftVersionData[5], (Object)0L);
        }
        if (bomId > 0L) {
            int idx = this.ctx.bomDatas().getCol(DefaultField.BOMField.BOMID.getName()).getFirstNoCheck((Object)bomId);
            if (idx < 0) {
                String msg = MRPUtil.appendExceptionMsg((Object)requireData.getValue(DefaultField.RequireField.EXCEPTIONMESSAGE.getName()), (String)ResManager.loadKDString((String)"\u751f\u4ea7\u7248\u672c\u6307\u5b9aBOM\u4e0d\u5728BOM\u6570\u636e\u8303\u56f4\u5185", (String)"MRPMDependentReqStep_9", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0]));
                requireData.update(DefaultField.RequireField.EXCEPTIONMESSAGE.getName(), (Object)msg);
                return idx;
            }
            RowData bomData = this.ctx.bomDatas().fetchRow(idx);
            Boolean isSuperBom = MRPUtil.convert((Object)bomData.getValue(DefaultField.BOMField.ISSUPERBOM.getName()), (Boolean)Boolean.FALSE);
            if (!isSuperBom.booleanValue() || !"2".equals(configProperty) || configId <= 0L) {
                return idx;
            }
            String key = matid.toString() + '.' + org + '.' + configId + '.' + bomId;
            Integer hashKey = key.hashCode();
            if (this.configToNewBomId.containsKey(hashKey)) {
                bomId = this.configToNewBomId.get(hashKey) == null ? bomId : this.configToNewBomId.get(hashKey);
            } else {
                Map config2bomIds = GenOrderBomService.genOrderBomBySingleConfigCode((IMRPEnvProvider)this.ctx, (String)"model_pom", (Long)org, (Long)matid, (Long)bomId, Collections.singletonList(configId), (GridData.Grid)new MemoryGrid(6000), new HashMap(0), (BOMStructDataTable)this.ctx.bomDatas(), (Map)this.ctx.bomDatas().getColIdx(), null);
                Long newBomId = config2bomIds.get(configId) != null && !((List)config2bomIds.get(configId)).isEmpty() ? (Long)((List)config2bomIds.get(configId)).get(0) : null;
                this.configToNewBomId.put(hashKey, newBomId);
                bomId = newBomId == null ? bomId : newBomId;
            }
            idx = this.ctx.bomDatas().getCol(DefaultField.BOMField.BOMID.getName()).getFirstNoCheck((Object)bomId);
            return idx;
        }
        int bomRowIdx = DataMatchUtils.findBOM((IMRPEnvProvider)this.ctx, (StringBuilder)this.keyBuffer, this.bomCache, (RowData)requireData);
        String key = matid.toString() + '.' + org + '.' + configId;
        if (bomRowIdx == -1 && configId > 0L && "2".equals(configProperty) && this.configBomCache.add(key.hashCode())) {
            GenOrderBomService.genOrderBomBySingleConfigCode((IMRPEnvProvider)this.ctx, (String)"model_pom", (Long)org, (Long)matid, null, Collections.singletonList(configId), (GridData.Grid)new MemoryGrid(6000), new HashMap(0), (BOMStructDataTable)this.ctx.bomDatas(), (Map)this.ctx.bomDatas().getColIdx(), null);
            bomRowIdx = DataMatchUtils.findBOM((IMRPEnvProvider)this.ctx, (StringBuilder)this.keyBuffer, this.bomCache, (RowData)requireData);
        }
        return bomRowIdx;
    }

    private void updateException(RequireRowData dependent, RowData bomEntryRow, DataBalanceTable.RSMapping mapping, String code, String msg) {
        this.updateException(dependent, bomEntryRow, mapping, code, msg, false);
    }

    private void updateException(RequireRowData dependent, RowData bomEntryRow, DataBalanceTable.RSMapping mapping, String code, String msg, boolean isRemove) {
        this.onlyUpdateException(dependent, code, msg);
        RequireRowData row = new RequireRowData(this.ctx.requireDatas().getSrcDatas(), Integer.valueOf(this.ctx.requireDatas().fill((RowData)dependent)), (RowData)dependent);
        row.setBomRow(bomEntryRow);
        boolean bl = isRemove = isRemove || MRPUtil.convert((Object)bomEntryRow.getValue(DefaultField.BOMField.ISREPLACE.getName()), (Boolean)Boolean.FALSE) != false;
        if (!isRemove) {
            mapping.addChild(row);
        }
    }

    private void onlyUpdateException(RequireRowData dependent, String code, String msg) {
        msg = MRPUtil.appendExceptionMsg((Object)dependent.getValue(DefaultField.RequireField.EXCEPTIONMESSAGE.getName()), (String)msg);
        dependent.update(DefaultField.RequireField.EXCEPTIONMESSAGE.getName(), (Object)msg);
        code = MRPUtil.appendExceptionNumber((Object)dependent.getValue(DefaultField.RequireField.EXCEPTIONNUMBER.getName()), (String)code);
        dependent.update(DefaultField.RequireField.EXCEPTIONNUMBER.getName(), (Object)code);
    }

    private List<Integer> findBOMChildren(String bomFID, boolean isHaveCops) {
        List boms = DataMatchUtils.findBOMChildren((IMRPEnvProvider)this.ctx, this.bomChildrenCache, (String)bomFID);
        if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("mrprunner-findBOMChildren: bomFID: %s, subCount: %s", bomFID, boms.size()));
        }
        if (!isHaveCops) {
            int idx = (Integer)this.ctx.bomDatas().getColIdx().get(DefaultField.BOMField.COPTYPE.getName());
            Iterator it = boms.iterator();
            while (it.hasNext()) {
                Integer i = (Integer)it.next();
                Object v = this.ctx.bomDatas().fetchRow(i.intValue()).get(idx);
                CopTypeEnum copTypeEnum = CopTypeEnum.fromValue((String)String.valueOf(v));
                if (copTypeEnum == null) continue;
                it.remove();
            }
        }
        return boms;
    }

    public String getDesc() {
        return Tips.getCreateDependentReq();
    }
}

