/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.calcnode.framework.step;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.mmc.mrp.calcnode.framework.step.AbstractMRPSubStep;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.consts.Tips;
import kd.mmc.mrp.framework.step.IMRPResult;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.model.PrioritySettingDatas;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.struct.SupplyStruct;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.res.RequirementDataTable;
import kd.mmc.mrp.utils.MRPUtil;
import kd.mpscmm.msplan.business.helper.PriorityCalculationHelper;
import kd.sdk.mmc.mrp.extpoint.IMRPCalcNetDemandPlugin;
import kd.sdk.mmc.mrp.framework.res.IResModelDataTable;

public class MRPMReuqirePriorityLevelCalcStep
extends AbstractMRPSubStep {
    private String stepDesc = Tips.getInitRequirePriorityLevel();
    private boolean isOnlyIndependent;

    public MRPMReuqirePriorityLevelCalcStep(IMRPEnvProvider ctx) {
        this(ctx, false);
    }

    public MRPMReuqirePriorityLevelCalcStep(IMRPEnvProvider ctx, boolean isOnlyIndependent) {
        super(ctx);
        this.isOnlyIndependent = isOnlyIndependent;
    }

    public void setStepDesc(String newDesc) {
        this.stepDesc = newDesc;
    }

    @Override
    protected IMRPResult executeImpl() {
        int i;
        PlanModel planModel = (PlanModel)this.ctx.getService(PlanModel.class);
        RequirementDataTable table = this.ctx.requireDatas();
        table.clearIndex(DefaultField.RequireField.__PRIORITY_LEVEL__.name());
        int size = table.size();
        Object priority_model = planModel.getPlanDataByParam("prioritymodel");
        Long prioritymodelId = priority_model instanceof DynamicObject ? ((DynamicObject)priority_model).getLong("id") : 0L;
        List priorityLevels = null;
        if (prioritymodelId > 0L) {
            ArrayList<Map> parameterList = new ArrayList<Map>(size);
            for (i = 0; i < size; ++i) {
                RequireRowData rowData = table.fetchRow(i);
                parameterList.add(rowData.toMap());
            }
            priorityLevels = PriorityCalculationHelper.calPlanPriorityWeight((Long)prioritymodelId, parameterList);
        }
        IMRPCalcNetDemandPlugin imrpCalcNetDemandPlugin = this.ctx.getMRPCalcNetDemandPlugin();
        for (i = 0; i < size; ++i) {
            Integer newVal;
            Integer old = (Integer)MRPUtil.convert((Object)table.getValue(DefaultField.RequireField.__PRIORITY_LEVEL__.name(), i), (Object)-1);
            if (table.isLock(Integer.valueOf(i)) || this.isOnlyIndependent && (Integer)MRPUtil.convert((Object)table.getValue(DefaultField.RequireField.__ISDEPENDENT__.getName(), i), (Object)0) == 1) {
                newVal = (Integer)MRPUtil.convert((Object)old, (Object)0);
            } else {
                Integer n = newVal = priorityLevels != null ? (Integer)priorityLevels.get(i) : Integer.valueOf(this.getPriority(i));
            }
            if (imrpCalcNetDemandPlugin != null) {
                newVal = imrpCalcNetDemandPlugin.getRequirePriorityLevel(this.ctx.getMrpSdkEnv(), (IResModelDataTable)table, i, newVal);
            }
            table.updateValue(DefaultField.RequireField.__PRIORITY_LEVEL__.name(), Integer.valueOf(i), (Object)newVal);
            if (old == null || !old.equals(newVal)) continue;
            table.updateIndexValue(DefaultField.RequireField.__PRIORITY_LEVEL__.name(), Integer.valueOf(i), (Object)old);
        }
        this.dataAmount = table.size();
        return null;
    }

    protected int getPriority(int rowIdx) {
        RequirementDataTable table = this.ctx.requireDatas();
        table.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName(), rowIdx);
        SupplyStruct infos = (SupplyStruct)this.ctx.getPriorityRelations().get(this.ctx.getPlanOrgId() + "pentryentity");
        if (infos == null) {
            return 0;
        }
        int priotiry = 0;
        for (PrioritySettingDatas setting : infos.getRequirePrioritys()) {
            if ((Integer)MRPUtil.convert((Object)table.getValue(DefaultField.RequireField.ISSTOCK.getName(), rowIdx), (Object)0) == 1) continue;
            priotiry += setting.apply(table, rowIdx);
        }
        return priotiry;
    }

    public String getDesc() {
        return this.stepDesc;
    }
}

