/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.calcnode.framework.step;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mmc.mrp.calcnode.framework.step.AbstractMRPSubStep;
import kd.mmc.mrp.common.util.DynamicObjDataUtil;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.MRPWorkCalendarManager;
import kd.mmc.mrp.framework.step.IMRPResult;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.table.ColumnDatas;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.table.res.RequirementDataTable;
import kd.mmc.mrp.utils.MRPUtil;

public class MRPMSafeInvResolveStep
extends AbstractMRPSubStep {
    private RequirementDataTable requireTbl;
    private static final Log logger = LogFactory.getLog(MRPMSafeInvResolveStep.class);

    public MRPMSafeInvResolveStep(IMRPEnvProvider ctx) {
        super(ctx);
    }

    public String getDesc() {
        return ResManager.loadKDString((String)"\u5b89\u5168\u5e93\u5b58\u9700\u6c42\u63d0\u62c9", (String)"MRPMSafeInvResolveStep_0", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0]);
    }

    @Override
    protected IMRPResult executeImpl() {
        this.requireTbl = this.ctx.requireDatas();
        int size = this.ctx.requireDatas().size();
        if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("mrprunner-safeInv-resolve :ctxid: %s, runLog: %s", this.ctx.getMRPContextId(), this.ctx.getRunLogNumber()));
        }
        HashMap<Long, TreeMap> materialMap = new HashMap<Long, TreeMap>(2);
        Long earliestRequireDate = Long.MAX_VALUE;
        for (int i = 0; i < size; ++i) {
            boolean ret = MRPUtil.convert((Object)this.requireTbl.getValue(DefaultField.RequireField.ISSTOCK.getName(), i), (Boolean)Boolean.FALSE);
            RequireRowData row = this.requireTbl.fetchRow(i);
            Long date = (Long)MRPUtil.convert((Object)row.getValue(DefaultField.RequireField.DATE.getName()), (Object)System.currentTimeMillis());
            if (ret) {
                Long mid = (Long)MRPUtil.convert((Object)row.getValue(DefaultField.RequireField.MATERIAL.getName()), (Object)0L);
                TreeMap safeInvs = materialMap.computeIfAbsent(mid, k -> new TreeMap());
                if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                    logger.warn(String.format("mrprunner-safeInv-data :ctxid: %s, runLog: %s, mid: %s, requireDate: %s", this.ctx.getMRPContextId(), this.ctx.getRunLogNumber(), row.getValue(DefaultField.RequireField.MATERIAL.getName()), new Date(date)));
                }
                safeInvs.put(date, row);
                continue;
            }
            earliestRequireDate = Math.min(earliestRequireDate, date);
        }
        for (Map.Entry entry : materialMap.entrySet()) {
            TreeMap safeInvs = (TreeMap)entry.getValue();
            Iterator safeDateIter = safeInvs.descendingKeySet().descendingIterator();
            HashMap<Long, BigDecimal> requireAdjust = new HashMap<Long, BigDecimal>();
            BigDecimal lastSafeQty = BigDecimal.ZERO;
            Long lastEnd = null;
            String safe_inv_advance_start_date = (String)this.ctx.getCfgValue(EnvCfgItem.SAFE_INV_ADVANCE_START_DATE);
            boolean isEarliestRequiredate = "EARLIEST_REQUIREDATE".equals(safe_inv_advance_start_date);
            while (safeDateIter.hasNext()) {
                Long date = (Long)safeDateIter.next();
                RequireRowData requireData = (RequireRowData)safeInvs.get(date);
                BigDecimal safeRequire = MRPUtil.toBigDecimal((Object)requireData.getValue(DefaultField.RequireField.QTY.getName()));
                String type = String.valueOf(requireData.getValue(DefaultField.RequireField.SAFEINVTYPE.getName()));
                if ("B".equals(type)) {
                    Long start = Math.max(date, this.ctx.getPlanDate().getTime());
                    ColumnDatas rCol = this.requireTbl.getCol(DefaultField.RequireField.DATE.getName());
                    Long end = (Long)requireData.getValue(DefaultField.RequireField.INVALIDDATE.getName());
                    Long outlook = this.ctx.getPlanDate().getTime() + (long)this.ctx.getPlanOutLook() * 86400000L;
                    end = Math.min(end, outlook);
                    Long requireDate = start + 86400000L;
                    String mId = String.valueOf(requireData.getValue(DefaultField.RequireField.MATERIAL.getName()));
                    if (this.ctx.getPlanDate().getTime() > end) continue;
                    if (lastEnd != null) {
                        BigDecimal consume;
                        while (lastEnd <= start) {
                            consume = (BigDecimal)requireAdjust.remove(lastEnd);
                            if (consume != null) {
                                lastSafeQty = lastSafeQty.subtract(consume);
                            }
                            lastEnd = lastEnd + 86400000L;
                        }
                        safeRequire = safeRequire.subtract(lastSafeQty);
                        while (safeRequire.compareTo(BigDecimal.ZERO) <= 0 && !requireAdjust.isEmpty() && lastEnd <= outlook) {
                            consume = (BigDecimal)requireAdjust.remove(lastEnd);
                            if (consume != null) {
                                safeRequire = safeRequire.add(consume);
                            }
                            lastEnd = lastEnd + 86400000L;
                        }
                        if (safeRequire.compareTo(BigDecimal.ZERO) <= 0) continue;
                        start = lastEnd - 86400000L;
                        requireDate = lastEnd;
                        if (start > end) continue;
                    }
                    block5: while (requireDate <= outlook) {
                        List rows = rCol.get((Object)requireDate);
                        if (rows.isEmpty()) {
                            requireDate = requireDate + 86400000L;
                            continue;
                        }
                        BigDecimal adv = BigDecimal.ZERO;
                        for (Integer idx : rows) {
                            String m = String.valueOf(this.requireTbl.getValue(DefaultField.RequireField.MATERIAL.getName(), idx.intValue()));
                            if (!mId.equals(m) || MRPUtil.convert((Object)this.requireTbl.getValue(DefaultField.RequireField.ISSTOCK.getName(), idx.intValue()), (Boolean)Boolean.FALSE).booleanValue()) continue;
                            BigDecimal rQty = (BigDecimal)MRPUtil.convert((Object)this.requireTbl.getValue(DefaultField.RequireField.QTY.getName(), idx.intValue()), (Object)BigDecimal.ZERO);
                            if (safeRequire.compareTo(rQty) >= 0) {
                                adv = adv.add(rQty);
                                safeRequire = safeRequire.subtract(rQty);
                            } else {
                                RequireRowData rData = this.requireTbl.fetchRow(idx.intValue());
                                RequireRowData split = rData.clone();
                                rData.update(DefaultField.RequireField.QTY.getName(), (Object)safeRequire);
                                split.update(DefaultField.RequireField.QTY.getName(), (Object)rQty.subtract(safeRequire));
                                this.requireTbl.fill((RowData)split);
                                adv = adv.add(safeRequire);
                                safeRequire = BigDecimal.ZERO;
                            }
                            this.adjustRequire(idx, start);
                        }
                        BigDecimal preAdv = (BigDecimal)requireAdjust.get(requireDate);
                        if (preAdv != null) {
                            adv = adv.add(preAdv);
                        }
                        requireAdjust.put(requireDate, adv);
                        if (safeRequire.compareTo(BigDecimal.ZERO) <= 0) {
                            do {
                                if ((start = Long.valueOf(start + 86400000L)) > end) {
                                    safeRequire = BigDecimal.ZERO;
                                    break block5;
                                }
                                safeRequire = (BigDecimal)requireAdjust.remove(start);
                                if (safeRequire == null || start.longValue() != requireDate.longValue()) continue;
                                requireDate = requireDate + 86400000L;
                            } while (safeRequire == null && !requireAdjust.isEmpty());
                            continue;
                        }
                        requireDate = requireDate + 86400000L;
                    }
                    lastSafeQty = MRPUtil.toBigDecimal((Object)requireData.getValue(DefaultField.RequireField.QTY.getName()));
                    lastEnd = end + 86400000L;
                    continue;
                }
                if (!"C".equals(type)) continue;
                MRPWorkCalendarManager manager = this.ctx.dateManager();
                String org = String.valueOf(requireData.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
                String supplyOrg = String.valueOf(requireData.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()));
                if (DynamicObjDataUtil.isNullStringOr0Long((String)supplyOrg)) {
                    supplyOrg = org;
                }
                Long start = manager.getBeginDateRequire(supplyOrg, org).getTime();
                start = Math.max(start, isEarliestRequiredate ? earliestRequireDate : date);
                ColumnDatas rCol = this.requireTbl.getCol(DefaultField.RequireField.DATE.getName());
                Long end = (Long)MRPUtil.convert((Object)requireData.getValue(DefaultField.RequireField.INVALIDDATE.getName()), (Object)System.currentTimeMillis());
                end = Math.min(end, manager.getEndDateOutLook(supplyOrg, org).getTime());
                Long requireDate = start;
                int safeDay = safeRequire.intValue();
                if (safeDay <= 0 || end <= start) continue;
                String mId = String.valueOf(requireData.getValue(DefaultField.RequireField.MATERIAL.getName()));
                while (requireDate < end) {
                    requireDate = requireDate + 86400000L;
                    List rows = rCol.get((Object)requireDate);
                    for (Integer idx : rows) {
                        String m = String.valueOf(this.requireTbl.getValue(DefaultField.RequireField.MATERIAL.getName(), idx.intValue()));
                        if (!mId.equals(m) || MRPUtil.convert((Object)this.requireTbl.getValue(DefaultField.RequireField.ISSTOCK.getName(), idx.intValue()), (Boolean)Boolean.FALSE).booleanValue()) continue;
                        this.adjustRequire(idx, start);
                    }
                    if (start + (long)safeDay * 86400000L != requireDate) continue;
                    start = start + 86400000L;
                }
            }
        }
        return null;
    }

    private void adjustRequire(int idx, long start) {
        RequireRowData rowData = this.requireTbl.fetchRow(idx);
        Long oldDate = (Long)MRPUtil.convert((Object)rowData.getValue(DefaultField.RequireField.DATE.getName()), (Object)System.currentTimeMillis());
        Object mid = rowData.getValue(DefaultField.RequireField.MATERIAL.getName());
        if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("mrprunner-safeInv-data :ctxid: %s, runLog: %s, mid: %s, oldDate: %s, newDate: %s", this.ctx.getMRPContextId(), this.ctx.getRunLogNumber(), mid, new Date(oldDate), new Date(start)));
        }
        this.requireTbl.updateValue(DefaultField.RequireField.DATE.getName(), Integer.valueOf(idx), (Object)start);
        String msg = MRPUtil.appendExceptionMsg((Object)this.requireTbl.getValue(DefaultField.RequireField.EXCEPTIONMESSAGE.getName(), idx), (String)ResManager.loadKDString((String)"\u9700\u6c42\u65e5\u671f\u56e0\u4e3a\u5b89\u5168\u5e93\u5b58\u63d0\u524d\u3002", (String)"MRPMSafeInvResolveStep_1", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0]));
        this.requireTbl.updateValue(DefaultField.RequireField.EXCEPTIONMESSAGE.getName(), Integer.valueOf(idx), (Object)msg);
        String num = MRPUtil.appendExceptionNumber((Object)this.requireTbl.getValue(DefaultField.RequireField.EXCEPTIONNUMBER.getName(), idx), (String)"94");
        this.requireTbl.updateValue(DefaultField.RequireField.EXCEPTIONNUMBER.getName(), Integer.valueOf(idx), (Object)num);
    }
}

