/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.calcnode.framework.step;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.mmc.mrp.calcnode.framework.step.AbstractMRPSubStep;
import kd.mmc.mrp.exception.MRPBizException;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.MRPWorkCalendarManager;
import kd.mmc.mrp.framework.consts.Errors;
import kd.mmc.mrp.framework.consts.Tips;
import kd.mmc.mrp.framework.step.IMRPResult;
import kd.mmc.mrp.model.date.OrgBasedCalendarModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.enums.ResType;
import kd.mmc.mrp.model.table.ChooseCycleData;
import kd.mmc.mrp.model.table.MergeDataTable;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.table.res.RequirementDataTable;
import kd.mmc.mrp.mservice.algorithm.IMRPRequireMergeExt;
import kd.mmc.mrp.mservice.algorithm.MRPRequireMergeExtImpl;
import kd.mmc.mrp.utils.MRPUtil;

public class MRPMergeRule
extends AbstractMRPSubStep {
    private static Log logger = LogFactory.getLog(MRPMergeRule.class);

    public MRPMergeRule(IMRPEnvProvider ctx) {
        super(ctx);
    }

    @Override
    protected IMRPResult executeImpl() {
        this.requireDataMerge();
        this.dataAmount = this.ctx.requireDatas().getSrcDatas().getDatas().size();
        return null;
    }

    public String getDesc() {
        return Tips.getApplyMergeRule();
    }

    protected void requireDataMerge() {
        MergeDataTable mergeDataTable;
        RequirementDataTable requireTbl = this.ctx.requireDatas();
        Map colIdx = requireTbl.getColIdx();
        int size = requireTbl.getSrcDatas().getDatas().size();
        if (size <= 0) {
            return;
        }
        HashMap<String, List> allMap = new HashMap<String, List>(16);
        HashMap<String, MergeDataTable> mergeDataTableMap = new HashMap<String, MergeDataTable>(2);
        ArrayList<Object[]> allDatas = new ArrayList<Object[]>(16);
        StringBuilder groupKeys = new StringBuilder();
        HashMap<Integer, Object[]> lockDatas = new HashMap<Integer, Object[]>(16);
        MRPRequireMergeExtImpl imrpRequireMergeExt = new MRPRequireMergeExtImpl();
        PluginProxy pluginProxy = PluginProxy.create((Object)imrpRequireMergeExt, IMRPRequireMergeExt.class, (String)"MRP_REQUIRE_MERGE_EXT", null);
        for (int i = 0; i < size; ++i) {
            String exp;
            Object[] o = requireTbl.getSrcDatas().getDatas().get(i);
            BigDecimal qty = MRPUtil.toBigDecimal((Object)o[(Integer)this.ctx.requireDatas().getColIdx().get(DefaultField.RequireField.QTY.getName())]);
            RequireRowData requireData = requireTbl.fetchRow(i);
            Object mId = o[(Integer)colIdx.get(DefaultField.RequireField.MATERIAL.getName())];
            Object org = o[(Integer)colIdx.get(DefaultField.RequireField.SUPPLYORGUNIT.getName())];
            Object flexedProp = o[(Integer)colIdx.get(DefaultField.RequireField.MATERIALFLEXPROPS.getName())];
            String mIdStr = String.valueOf(mId);
            if (requireTbl.isLock(Integer.valueOf(i))) {
                lockDatas.put(i, o);
                continue;
            }
            if ("null".equals(mIdStr) || "0".equals(mIdStr) || qty == null || qty.compareTo(BigDecimal.ZERO) <= 0) {
                allDatas.add(o);
                continue;
            }
            Integer idx = (Integer)colIdx.get(DefaultField.RequireField.EXCEPTIONNUMBER.getName());
            String string = exp = o[idx] == null ? "" : String.valueOf(o[idx]);
            if (!StringUtils.isEmpty((String)exp) && MRPUtil.hasException((String)exp)) {
                allDatas.add(o);
                continue;
            }
            idx = (Integer)colIdx.get(DefaultField.RequireField.ISSTOCK.getName());
            if (MRPUtil.convert((Object)o[idx], (Boolean)Boolean.FALSE).booleanValue()) {
                allDatas.add(o);
                continue;
            }
            idx = (Integer)colIdx.get(DefaultField.RequireField.__REPLACE_STRUCT__.getName());
            if (o[idx] != null) {
                allDatas.add(o);
                continue;
            }
            if (!this.isRequireMerge((PluginProxy<IMRPRequireMergeExt>)pluginProxy, this.ctx, requireData)) {
                allDatas.add(o);
                continue;
            }
            String key = String.format("%s\u0001%s", mIdStr, org);
            mergeDataTable = (MergeDataTable)mergeDataTableMap.get(key);
            if (mergeDataTable == null) {
                Long ruleId = (Long)MRPUtil.convert((Object)o[(Integer)colIdx.get(DefaultField.RequireField.DEMANDMERGERULE.getName())], (Object)0L);
                if (ruleId <= 0L) {
                    allDatas.add(o);
                    continue;
                }
                if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                    logger.warn(String.format("ctxid: %s, mrprunner mid: %s, ruleid: %s", this.ctx.getMRPContextId(), key, ruleId));
                }
                mergeDataTable = this.ctx.createMergeTable(String.valueOf(ruleId));
                mergeDataTableMap.put(key, mergeDataTable);
            }
            ArrayList fields = new ArrayList(mergeDataTable.getMergeFields());
            groupKeys.setLength(0);
            Object reqSource = o[(Integer)colIdx.get(DefaultField.RequireField.__REQUIRE_SOURCE__.getName())];
            if (!mergeDataTable.isRequireSource()) {
                reqSource = Character.valueOf(' ');
            }
            groupKeys.append(reqSource);
            groupKeys.append('\u0001').append(key);
            for (String field : fields) {
                Integer fieldIdx = (Integer)this.ctx.requireDatas().getColIdx().get(field);
                if (fieldIdx == null || DefaultField.RequireField.MATERIAL.getName().equalsIgnoreCase(field) || DefaultField.RequireField.SUPPLYORGUNIT.getName().equalsIgnoreCase(field) || DefaultField.RequireField.DATE.getName().equalsIgnoreCase(field)) continue;
                groupKeys.append('\u0001');
                groupKeys.append(o[fieldIdx]);
            }
            List list = allMap.computeIfAbsent(groupKeys.toString(), k -> new ArrayList(16));
            list.add(o);
        }
        for (Map.Entry entry : allMap.entrySet()) {
            List list = (List)entry.getValue();
            ArrayList<Object[]> resultDatas = new ArrayList<Object[]>();
            HashMap<String, Object[]> newDataMap = new HashMap<String, Object[]>();
            Long[] reqDateSortArray = new Long[list.size() + 1];
            int i = this.getReqDateSortArray(list, reqDateSortArray);
            Object ruleId = ((Object[])list.get(0))[(Integer)this.ctx.requireDatas().getColIdx().get(DefaultField.RequireField.DEMANDMERGERULE.getName())];
            String mIdStr = String.valueOf(((Object[])list.get(0))[(Integer)this.ctx.requireDatas().getColIdx().get(DefaultField.RequireField.MATERIAL.getName())]);
            String org = String.valueOf(((Object[])list.get(0))[(Integer)this.ctx.requireDatas().getColIdx().get(DefaultField.RequireField.SUPPLYORGUNIT.getName())]);
            mergeDataTable = mergeDataTableMap.getOrDefault(String.format("%s\u0001%s", mIdStr, org), this.ctx.createMergeTable(String.valueOf(ruleId)));
            BigDecimal splitBatch = mergeDataTable.getSplitBatch();
            this.requireDataMergeByGroupAttr(list, mergeDataTable, newDataMap, reqDateSortArray, i, resultDatas);
            this.requireDataMergeBySplitBatch(newDataMap, splitBatch, resultDatas);
            allDatas.addAll(resultDatas);
        }
        this.fillAllData(allDatas, lockDatas);
    }

    protected boolean isRequireMerge(PluginProxy<IMRPRequireMergeExt> pluginProxy, IMRPEnvProvider ctx, RequireRowData requireData) {
        List list = pluginProxy.callReplaceIfPresent(p -> p.isRequireMerge(ctx, requireData));
        return list != null && !list.isEmpty() ? (Boolean)list.get(0) : true;
    }

    protected void fillAllData(List<Object[]> allDatas, Map<Integer, Object[]> lockDatas) {
        if (!allDatas.isEmpty() || !lockDatas.isEmpty()) {
            this.ctx.requireDatas().clear();
            int size = allDatas.size() + lockDatas.size();
            int seq = 0;
            for (int i = 0; i < size; ++i) {
                RowData data;
                Object[] value = lockDatas.get(i);
                if (value == null) {
                    value = allDatas.get(seq++);
                    data = new RowData(this.ctx.requireDatas().getSrcDatas(), this.ctx.requireDatas().getColIdx(), value, Integer.valueOf(-1), ResType.REQUIRE);
                    this.ctx.requireDatas().fill(data);
                    continue;
                }
                data = new RowData(this.ctx.requireDatas().getSrcDatas(), this.ctx.requireDatas().getColIdx(), value, Integer.valueOf(-1), ResType.REQUIRE);
                this.ctx.requireDatas().lock(Integer.valueOf(this.ctx.requireDatas().fill(data)));
            }
        }
    }

    protected int getReqDateSortArray(List<Object[]> list, Long[] reqDateSortArray) {
        int i = 1;
        reqDateSortArray[0] = 0L;
        for (Object[] o : list) {
            Long date = (Long)o[(Integer)this.ctx.requireDatas().getColIdx().get(DefaultField.RequireField.DATE.getName())];
            if (date > reqDateSortArray[i - 1]) {
                reqDateSortArray[i] = date;
                ++i;
                continue;
            }
            if (date >= reqDateSortArray[i - 1] || this.checkIsRepeat(i - 1, reqDateSortArray, date)) continue;
            reqDateSortArray[j] = date;
            for (int j = i; j >= 1 && reqDateSortArray[j - 1] > reqDateSortArray[j]; --j) {
                Long x = reqDateSortArray[j];
                reqDateSortArray[j] = reqDateSortArray[j - 1];
                reqDateSortArray[j - 1] = x;
            }
            ++i;
        }
        return i;
    }

    protected boolean checkIsRepeat(int i, Long[] reqDateSortArray, Long date) {
        for (int j = i - 1; j >= 0; --j) {
            if (date.longValue() != reqDateSortArray[j].longValue()) continue;
            return true;
        }
        return false;
    }

    protected void requireDataMergeBySplitBatch(Map<String, Object[]> newDataMap, BigDecimal splitBatch, List<Object[]> resultDatas) {
        if (splitBatch == null) {
            splitBatch = BigDecimal.ZERO;
        }
        for (Map.Entry<String, Object[]> DataEntry : newDataMap.entrySet()) {
            Object[] data = DataEntry.getValue();
            BigDecimal qty = MRPUtil.toBigDecimal((Object)data[(Integer)this.ctx.requireDatas().getColIdx().get(DefaultField.RequireField.QTY.getName())]);
            while (splitBatch.compareTo(BigDecimal.ZERO) > 0 && qty.compareTo(splitBatch) > 0) {
                Object[] cloneData = new Object[]{};
                try {
                    cloneData = this.clone(data);
                }
                catch (IOException | ClassNotFoundException e) {
                    throw new MRPBizException(Errors.getRequireMergeError(), e.getMessage(), e.getStackTrace());
                }
                cloneData[((Integer)this.ctx.requireDatas().getColIdx().get((Object)DefaultField.RequireField.QTY.getName())).intValue()] = new BigDecimal(splitBatch.toString());
                resultDatas.add(cloneData);
                qty = qty.subtract(splitBatch);
            }
            if (qty.compareTo(BigDecimal.ZERO) <= 0) continue;
            data[((Integer)this.ctx.requireDatas().getColIdx().get((Object)DefaultField.RequireField.QTY.getName())).intValue()] = qty;
            resultDatas.add(data);
        }
    }

    protected void requireDataMergeByGroupAttr(List<Object[]> list, MergeDataTable mergeDataTable, Map<String, Object[]> newDataMap, Long[] reqDateSortArray, int size, List<Object[]> resultDatas) {
        StringBuilder groupKeys = new StringBuilder();
        ArrayList fields = new ArrayList(mergeDataTable.getMergeFields());
        for (int i = 0; i < list.size(); ++i) {
            Object[] data = list.get(i);
            groupKeys.setLength(0);
            BigDecimal qty = MRPUtil.toBigDecimal((Object)data[(Integer)this.ctx.requireDatas().getColIdx().get(DefaultField.RequireField.QTY.getName())]);
            Object reqSource = data[(Integer)this.ctx.requireDatas().getColIdx().get(DefaultField.RequireField.__REQUIRE_SOURCE__.getName())];
            if (!mergeDataTable.isRequireSource()) {
                reqSource = Character.valueOf(' ');
            }
            groupKeys.append(reqSource);
            Object obj = data[(Integer)this.ctx.requireDatas().getColIdx().get(DefaultField.RequireField.PRODUCTIONORGUNIT.getName())];
            String requireProductOrgUnitID = obj == null ? null : String.valueOf(obj);
            obj = data[(Integer)this.ctx.requireDatas().getColIdx().get(DefaultField.RequireField.SUPPLYORGUNIT.getName())];
            String supplyOrgUnitID = obj == null ? null : String.valueOf(obj);
            obj = data[(Integer)this.ctx.requireDatas().getColIdx().get(DefaultField.RequireField.MATERIAL.getName())];
            String materialId = obj == null ? null : String.valueOf(obj);
            MRPWorkCalendarManager wcm = this.ctx.dateManager();
            OrgBasedCalendarModel requireCal = wcm.get(supplyOrgUnitID, requireProductOrgUnitID, materialId);
            boolean isDataMerge = false;
            Date requireDate = null;
            for (String identif : fields) {
                Integer idx = (Integer)this.ctx.requireDatas().getColIdx().get(identif);
                if (idx == null) continue;
                Object colData = data[idx];
                if (DefaultField.RequireField.DATE.getName().equalsIgnoreCase(identif)) {
                    requireDate = new Date((Long)colData);
                    requireDate = this.getMergeData(requireDate, mergeDataTable, reqDateSortArray, size, requireCal);
                    groupKeys.append('\u0001');
                    groupKeys.append(requireDate.getTime());
                    isDataMerge = true;
                    continue;
                }
                if (colData == null) continue;
                groupKeys.append('\u0001');
                groupKeys.append(colData);
            }
            String mergeKey = groupKeys.toString();
            Object[] existData = newDataMap.get(mergeKey);
            if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                logger.warn(String.format("MRPMergeRule-%s\uff0c\u5408\u5e76key\uff1a%s - \u662f\u5426\u5b58\u5728[%s]\u3002", this.ctx.getRunLogNumber(), mergeKey, existData != null));
            }
            if (existData != null) {
                BigDecimal sumQty = MRPUtil.toBigDecimal((Object)existData[(Integer)this.ctx.requireDatas().getColIdx().get(DefaultField.RequireField.QTY.getName())]);
                sumQty = sumQty.add(qty);
                existData[((Integer)this.ctx.requireDatas().getColIdx().get((Object)DefaultField.RequireField.QTY.getName())).intValue()] = sumQty;
                data[((Integer)this.ctx.requireDatas().getColIdx().get((Object)DefaultField.RequireField.QTY.getName())).intValue()] = BigDecimal.ZERO;
                data[((Integer)this.ctx.requireDatas().getColIdx().get((Object)DefaultField.RequireField.__IS_MERGE_.getName())).intValue()] = Boolean.TRUE;
                data[((Integer)this.ctx.requireDatas().getColIdx().get((Object)DefaultField.RequireField.__MERGE_REQBILL_NUM_.getName())).intValue()] = existData[(Integer)this.ctx.requireDatas().getColIdx().get(DefaultField.RequireField.BILLNUMBER.getName())];
                data[((Integer)this.ctx.requireDatas().getColIdx().get((Object)DefaultField.RequireField.__MERGE_REQBILL_ID_.getName())).intValue()] = existData[(Integer)this.ctx.requireDatas().getColIdx().get(DefaultField.RequireField.BILLID.getName())];
                data[((Integer)this.ctx.requireDatas().getColIdx().get((Object)DefaultField.RequireField.__MERGE_REQBILL_ENTRYID_.getName())).intValue()] = existData[(Integer)this.ctx.requireDatas().getColIdx().get(DefaultField.RequireField.BILLENTRYID.getName())];
                data[((Integer)this.ctx.requireDatas().getColIdx().get((Object)DefaultField.RequireField.__MERGE_REQBILL_ENTRYSEQ_.getName())).intValue()] = existData[(Integer)this.ctx.requireDatas().getColIdx().get(DefaultField.RequireField.BILLENTRYSEQ.getName())];
                resultDatas.add(data);
                this.saveMergeBillNum(existData, data);
            } else {
                newDataMap.put(mergeKey, data);
                this.saveMergeBillNum(data, data);
            }
            data[((Integer)this.ctx.requireDatas().getColIdx().get((Object)DefaultField.RequireField.__MERGE_REQQTY_.getName())).intValue()] = qty;
            if (!isDataMerge) continue;
            data[((Integer)this.ctx.requireDatas().getColIdx().get((Object)DefaultField.RequireField.DATE.getName())).intValue()] = requireDate.getTime();
        }
    }

    protected void saveMergeBillNum(Object[] existData, Object[] data) {
    }

    protected Object[] clone(Object[] objects) throws IOException, ClassNotFoundException {
        Object[] outer = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(objects);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        outer = (Object[])ois.readObject();
        return outer;
    }

    protected Date getMergeData(Date requireDate, MergeDataTable mergeDataTable, Long[] reqDateSortArray, int size, OrgBasedCalendarModel requireCal) {
        String cycleType = mergeDataTable.getCycleType();
        Integer dynamicCycle = mergeDataTable.getDynamicCycle();
        Integer fixedCycle = mergeDataTable.getFixedCycle();
        List chooseCycles = mergeDataTable.getChooseCycleDatas();
        String mergeType = mergeDataTable.getMergeType() == null ? "A" : mergeDataTable.getMergeType();
        int dateOffsetDay = mergeDataTable.getDateOffsetDay() == null ? 0 : mergeDataTable.getDateOffsetDay();
        Date newRequireDate = requireDate;
        if ("A".equalsIgnoreCase(cycleType)) {
            Date date = new Date(reqDateSortArray[1]);
            if (date.after(requireDate)) {
                return requireDate;
            }
            if (dateOffsetDay >= dynamicCycle) {
                dateOffsetDay = dynamicCycle - 1;
            }
            int cycleNum = 0;
            int startIdx = 1;
            for (int i = 1; i < size; ++i) {
                Date newReqDate = new Date(reqDateSortArray[i]);
                if (date.after(newReqDate)) continue;
                if (++cycleNum == 1) {
                    startIdx = i;
                }
                cycleNum %= dynamicCycle.intValue();
                if (requireDate.compareTo(newReqDate) != 0) continue;
                int dateIdx = "B".equalsIgnoreCase(mergeType) ? (startIdx + dynamicCycle - 1 >= size ? size - 1 : startIdx + dynamicCycle - 1) : (dateOffsetDay + startIdx >= size ? size - 1 : dateOffsetDay + startIdx);
                newRequireDate = new Date(reqDateSortArray[dateIdx]);
                break;
            }
        } else if ("B".equalsIgnoreCase(cycleType)) {
            LocalDate resultLcoalDate;
            Date date = new Date(reqDateSortArray[1]);
            if (date.after(requireDate)) {
                return requireDate;
            }
            LocalDate localDate = MRPUtil.date2LocalDate((Date)date);
            LocalDate localReqDate = MRPUtil.date2LocalDate((Date)requireDate);
            long day1 = localDate.toEpochDay();
            long day2 = localReqDate.toEpochDay();
            long day = day2 - day1 + 1L;
            long n = (long)Math.ceil((double)day / ((double)fixedCycle.intValue() * 1.0));
            if (dateOffsetDay >= fixedCycle) {
                dateOffsetDay = fixedCycle - 1;
            }
            if ("B".equalsIgnoreCase(mergeType)) {
                resultLcoalDate = localDate.plusDays(n * (long)fixedCycle.intValue() - 1L);
                dateOffsetDay = 0;
            } else {
                resultLcoalDate = localDate.plusDays((n - 1L) * (long)fixedCycle.intValue());
            }
            resultLcoalDate = resultLcoalDate.plusDays(dateOffsetDay);
            newRequireDate = MRPUtil.localDate2Date((LocalDate)resultLcoalDate);
        } else if ("C".equalsIgnoreCase(cycleType)) {
            if (chooseCycles.isEmpty()) {
                logger.warn(String.format("MRPMergeRule-%s\uff0c\u6307\u5b9a\u5468\u671f\u5206\u5f55\u4e3a\u7a7a ", this.ctx.getRunLogNumber()));
            }
            for (ChooseCycleData cycleData : chooseCycles) {
                Date startDate = cycleData.getStartDate();
                Date endDate = cycleData.getEndDate();
                Date mergeDate = cycleData.getMergeDate();
                if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                    logger.warn(String.format("MRPMergeRule-%s\uff0c\u5f00\u59cb\u65e5\u671f\uff1a%s\uff0c\u7ed3\u675f\u65e5\u671f[%s]\uff0c\u5408\u5e76\u65e5\u671f[%s]\uff0c\u9700\u6c42\u65e5\u671f[%s] ", this.ctx.getRunLogNumber(), startDate, endDate, mergeDate, requireDate));
                }
                if (startDate.compareTo(requireDate) > 0 || endDate.compareTo(requireDate) < 0) continue;
                newRequireDate = mergeDate;
                break;
            }
        }
        if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("MRPMergeRule-%s\uff0c\u5408\u5e76\u5468\u671f\u7c7b\u578b\uff1a%s\uff0c\u9700\u6c42\u65f6\u95f4[%s]\uff0c\u5408\u5e76\u540e\u9700\u6c42\u65f6\u95f4[%s]", this.ctx.getRunLogNumber(), cycleType, requireDate, newRequireDate));
        }
        if (requireCal == null) {
            return newRequireDate;
        }
        return requireCal.getDate(newRequireDate, true).getTime();
    }
}

