/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.calcnode.framework.step;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.mrp.calcnode.framework.step.MRPMergeRule;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.consts.Tips;
import kd.mmc.mrp.framework.step.IMRPResult;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.table.GridData;
import kd.mmc.mrp.model.table.MergeDataTable;
import kd.mmc.mrp.model.table.res.RequirementDataTable;
import kd.mmc.mrp.utils.MRPUtil;

public class MRPReqOrgMergeRule
extends MRPMergeRule {
    private static final Log logger = LogFactory.getLog(MRPReqOrgMergeRule.class);

    public MRPReqOrgMergeRule(IMRPEnvProvider ctx) {
        super(ctx);
    }

    @Override
    protected IMRPResult executeImpl() {
        this.requireDataMerge();
        this.dataAmount = this.ctx.requireDatas().getSrcDatas().getDatas().size();
        return null;
    }

    @Override
    public String getDesc() {
        return Tips.getApplyMergeRule();
    }

    @Override
    protected void requireDataMerge() {
        RequirementDataTable requireTbl = this.ctx.requireDatas();
        Map colIdx = requireTbl.getColIdx();
        GridData.Grid all = requireTbl.getSrcDatas().getDatas();
        if (all == null || all.isEmpty()) {
            return;
        }
        HashMap<String, List> allMap = new HashMap<String, List>(all.size());
        for (Object[] o : all) {
            String exp;
            Object mId = o[(Integer)colIdx.get(DefaultField.RequireField.MATERIAL.getName())];
            String mIdStr = String.valueOf(mId);
            if (mIdStr.equals("null") || mIdStr.equals("0")) continue;
            Object org = o[(Integer)colIdx.get(DefaultField.RequireField.PRODUCTIONORGUNIT.getName())];
            String orgStr = String.valueOf(org);
            if (org == null || StringUtils.isBlank((String)orgStr)) continue;
            Integer idx = (Integer)colIdx.get(DefaultField.RequireField.EXCEPTIONNUMBER.getName());
            String string = exp = o[idx] == null ? "" : String.valueOf(o[idx]);
            if (!StringUtils.isEmpty((String)exp) && MRPUtil.hasException((String)exp) || MRPUtil.convert((Object)o[idx = (Integer)colIdx.get(DefaultField.RequireField.ISSTOCK.getName())], (Boolean)Boolean.FALSE).booleanValue()) continue;
            List list = allMap.getOrDefault(orgStr, new ArrayList());
            list.add(o);
            allMap.put(orgStr, list);
        }
        ArrayList<Object[]> allDatas = new ArrayList<Object[]>();
        for (Map.Entry entry : allMap.entrySet()) {
            List list = (List)entry.getValue();
            ArrayList<Object[]> resultDatas = new ArrayList<Object[]>();
            HashMap<String, Object[]> newDataMap = new HashMap<String, Object[]>();
            Long[] reqDateSortArray = new Long[list.size() + 1];
            int i = this.getReqDateSortArray(list, reqDateSortArray);
            Object ruleId = this.loadReqOrgMergeRule((String)entry.getKey());
            logger.warn(String.format("ctxid: %s, mrprunner mid: %s, ruleid: %s", this.ctx.getMRPContextId(), entry.getKey(), ruleId));
            if (ruleId == null || "0".equals(ruleId.toString())) {
                resultDatas.addAll(list);
            } else {
                MergeDataTable mergeDataTable = this.ctx.createMergeTable(String.valueOf(ruleId));
                BigDecimal splitBatch = mergeDataTable.getSplitBatch();
                this.requireDataMergeByGroupAttr(list, mergeDataTable, newDataMap, reqDateSortArray, i, resultDatas);
                this.requireDataMergeBySplitBatch(newDataMap, splitBatch, resultDatas);
            }
            allDatas.addAll(resultDatas);
        }
        this.fillAllData(allDatas, new HashMap<Integer, Object[]>(0));
    }

    @Override
    protected void saveMergeBillNum(Object[] k, Object[] v) {
        int i = (Integer)this.ctx.requireDatas().getColIdx().get(DefaultField.RequireField.BILLID.getName());
        int ii = (Integer)this.ctx.requireDatas().getColIdx().get(DefaultField.RequireField.BILLENTRYID.getName());
        String key = k[i] + "_" + k[ii];
        String vKey = v[i] + "_" + v[ii];
        String mstr = MRPCacheManager.getInst().getData((CalEnv)this.ctx, "allocationMergeBills");
        Map ms = mstr == null ? new HashMap() : (Map)JSON.parseObject((String)mstr, Map.class);
        List list = ms.computeIfAbsent(key, l -> new ArrayList());
        list.add(vKey);
        MRPCacheManager.getInst().putData((CalEnv)this.ctx, "allocationMergeBills", JSON.toJSONString(ms));
    }

    private Object loadReqOrgMergeRule(String rorg) {
        DynamicObject[] doc;
        if (rorg != null && (doc = BusinessDataServiceHelper.load((String)"mrp_orgmerge", (String)"createorg,mergerule", (QFilter[])new QFilter[]{new QFilter("createorg", "=", (Object)Long.valueOf(rorg)), new QFilter("enable", "=", (Object)"1"), new QFilter("status", "=", (Object)"C")})) != null && doc.length > 0) {
            return doc[0].getDynamicObject("mergerule").getPkValue();
        }
        return null;
    }
}

