/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.calcnode.framework.thread;

import com.alibaba.fastjson.JSON;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.ThreadLocals;
import kd.mmc.mrp.calcnode.framework.mq.resolver.MRPCalcEventResolverFactory;
import kd.mmc.mrp.calcnode.framework.thread.MRPMutilCallable;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.MultiThreadCacheManager;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.framework.mq.IMRPEventManager;
import kd.mmc.mrp.framework.mq.event.MRPEvent;
import kd.mmc.mrp.framework.runner.MRPCalcManager;
import kd.mmc.mrp.integrate.MRPIntegrateFactory;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.enums.MultiThreadCacheKey;
import kd.mmc.mrp.utils.MRPCalcStateManager;

public class MRPCalcWorker
implements Runnable {
    private static Map<String, MRPCalcWorker> WORKERS = new ConcurrentHashMap<String, MRPCalcWorker>();
    private final String mrpContextId;
    private final String nodeId;
    private final Set<String> eventSet = Collections.synchronizedSet(new HashSet());
    private LinkedBlockingQueue<MRPEvent> eventQueue = new LinkedBlockingQueue();
    private AtomicBoolean threadStarted = new AtomicBoolean();
    private Object terminalLock = new Object();
    private volatile boolean terminated = false;
    private static final Log logger = LogFactory.getLog(MRPCalcWorker.class);
    private MRPCalcStateManager stateManager;
    private MRPCalcStateManager.CallBack callback;
    private IMRPEnvProvider ctx;
    private boolean onMaster = false;
    private RequestContext requestContext;
    private boolean isContinue = true;
    static ThreadLocal<IMRPEnvProvider> LOCALS = ThreadLocals.create();
    private ThreadPool tp;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resolveAlone(MRPEvent event) {
        MRPCalcWorker worker = new MRPCalcWorker(event.getMrpContextId(), event.getNodeId());
        Object object = worker.terminalLock;
        synchronized (object) {
            if (!worker.terminated && worker.eventSet.add(event.getEventId())) {
                worker.eventQueue.add(event);
            }
        }
        ThreadPools.executeOnceIncludeRequestContext((String)"MRPCalcWorker", (Runnable)worker);
        while (worker.isContinue) {
            object = worker;
            synchronized (object) {
                try {
                    worker.wait(2000L);
                }
                catch (InterruptedException e) {
                    logger.error("mrprunner-wait-failed", (Throwable)e);
                    Thread.currentThread().interrupt();
                    IMRPEnvProvider ctx = worker.ctx;
                    IMRPEventManager mqManager = ctx.getMQManager();
                    boolean failed = mqManager.isFailed();
                    if (failed) {
                        StackTraceElement[] errStack = mqManager.getErrStack();
                        KDBizException error = new KDBizException(mqManager.getErrMsg());
                        if (errStack != null) {
                            error.setStackTrace(errStack);
                        }
                        throw error;
                    }
                    throw new KDBizException((Throwable)e, new ErrorCode("FAILED_TO_WAIT_IN_SINGLE_MODE", "FAILED_TO_WAIT_IN_SINGLE_MODE"), new Object[0]);
                }
            }
        }
    }

    public MRPCalcWorker(String mrpContextId, String nodeId) {
        this.mrpContextId = mrpContextId;
        this.nodeId = nodeId;
        this.callback = this.createCallback();
        this.stateManager = new MRPCalcStateManager(mrpContextId, this.callback);
        this.requestContext = RequestContext.get();
        this.ctx = MRPCalcManager.getContext((String)mrpContextId);
        if (this.ctx != null) {
            this.onMaster = true;
        }
    }

    private MRPCalcStateManager.CallBack createCallback() {
        return new MRPCalcStateManager.CallBack(){

            public void masterLost() {
                MRPCalcWorker.this.doMasterLost();
            }

            public void masterTerminated() {
                MRPCalcWorker.this.doMasterTerminated();
            }

            public void workerTerminated() {
                if (MRPCalcWorker.this.ctx != null) {
                    MRPCalcWorker.this.ctx.setShutdown();
                }
            }

            public void manuTerminated() {
                if (MRPCalcWorker.this.ctx != null) {
                    MRPCalcWorker.this.ctx.setShutdown();
                }
            }
        };
    }

    protected void doMasterLost() {
        if (!this.terminated) {
            this.terminated = true;
        }
        this.releaseMaster();
        logger.info("MRP mrp calc task (ctxId=" + this.mrpContextId + ") will terminate for masterLost, shutdown the worker(nodeId=" + this.nodeId + ")");
    }

    protected void doMasterTerminated() {
        if (!this.terminated) {
            this.terminated = true;
        }
        if (this.tp != null) {
            this.tp = null;
        }
        if (this.ctx != null) {
            this.ctx.setShutdown();
        }
        logger.info("MRP mrp calc task (ctxId=" + this.mrpContextId + ") will terminate for masterTerminated, shutdown the worker(nodeId=" + this.nodeId + ")");
    }

    private void releaseMaster() {
        if (this.ctx == null) {
            return;
        }
        RequestContext.set((RequestContext)this.requestContext);
        ThreadPools.executeOnce((String)"MRPMaster-lost-recorder", (Runnable)new Runnable(){

            @Override
            public void run() {
                MRPCalcWorker.this.ctx.onMasterLost();
                MRPCalcWorker.this.ctx.setShutdown();
            }
        });
    }

    public static synchronized MRPCalcWorker getOrCreateWorkder(MRPEvent event) {
        String mrpContextId = event.getMrpContextId();
        return WORKERS.computeIfAbsent(mrpContextId, k -> new MRPCalcWorker((String)k, event.getNodeId()));
    }

    public void startThreads() {
        if (this.threadStarted.compareAndSet(false, true)) {
            ThreadPools.executeOnceIncludeRequestContext((String)"MRPCalcWorker", (Runnable)this);
            this.stateManager.startWorkerCheckThread();
            boolean isDynamicGC = (Boolean)this.ctx.getCfgValue(EnvCfgItem.DYNAMIC_GC_ENABLED);
            if (isDynamicGC) {
                int minutes = (Integer)this.ctx.getCfgValue(EnvCfgItem.DYNAMIC_GC_INTERVAL);
                this.stateManager.startMemoryCheckThread((long)(minutes * 60) * 1000L);
            }
        }
    }

    public boolean resolveByMQ(MRPEvent event, MessageAcker paramMessageAcker, String paramString) {
        return this.resolveByMQ(event, paramMessageAcker, paramString, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resolveByMQ(MRPEvent event, MessageAcker paramMessageAcker, String paramString, boolean paramBoolean) {
        this.initialize();
        if (this.ctx.isShutdown() || !"D".equals(this.ctx.getRunLog().getString("calculatestatus"))) {
            logger.warn(String.format("mrprunner-worker-receive-unfinished-event: ctxId: %s, nodeId: %s, runlog: %s", event.getMrpContextId(), event.getNodeId(), this.ctx.getRunLog().getString("number")));
            paramMessageAcker.ack(paramString);
            return false;
        }
        boolean isMainInstCalcEnabled = (Boolean)this.ctx.getCfgValue(EnvCfgItem.MAIN_INST_CALC_ENABLED);
        if (this.onMaster && !isMainInstCalcEnabled) {
            paramMessageAcker.ack(paramString);
            this.ctx.getMQManager().publishCalcEvent(event, false);
            return false;
        }
        boolean isMulti = (Boolean)this.ctx.getCfgValue(EnvCfgItem.MULTI_THREAD_ENABLED);
        if (isMulti) {
            if (this.threadStarted.compareAndSet(false, true)) {
                int nThreads = (Integer)this.ctx.getCfgValue(EnvCfgItem.MRP_THREAD_COUNT);
                this.tp = ThreadPools.getOrCreateFixedThreadPool((String)("mrprunner-pool-" + this.ctx.getMRPContextId()), (int)nThreads);
                this.eventQueue = new LinkedBlockingQueue(nThreads);
                this.stateManager.startWorkerCheckThread();
            }
            while (!this.eventQueue.offer(event)) {
                Thread.yield();
            }
            this.tp.submit((Callable)new MRPMutilCallable(event, this.mrpContextId, a -> {
                paramMessageAcker.ack(paramString);
                this.eventQueue.poll();
            }), this.requestContext);
        } else {
            Object object = this.terminalLock;
            synchronized (object) {
                if (!this.terminated) {
                    if (this.eventSet.add(event.getEventId())) {
                        this.eventQueue.add(event);
                    }
                    this.startThreads();
                    boolean isEnabled = (Boolean)this.ctx.getCfgValue(EnvCfgItem.MQ_EVENT_BLOCK_ENABLED);
                    if (isEnabled) {
                        while (!this.eventSet.isEmpty() && !this.terminated) {
                            Thread.yield();
                        }
                        paramMessageAcker.ack(paramString);
                    } else {
                        paramMessageAcker.ack(paramString);
                    }
                }
            }
        }
        return true;
    }

    private void onTerminated() {
        WORKERS.remove(this.mrpContextId);
        this.stateManager.stopWorkerThread();
        logger.info("MRP mrp calc worker terminate, (ctxId=" + this.mrpContextId + ", nodeId=" + this.nodeId + ")");
        this.ctx.setShutdown();
        if (!this.onMaster) {
            MRPCacheManager.clearCache((CalEnv)this.ctx);
            IMRPEnvProvider ctx = MRPCalcManager.getContext((String)this.mrpContextId);
            if (ctx != null) {
                ctx.setShutdown();
                MRPCalcManager.removeContext((String)this.mrpContextId);
            }
        }
    }

    private synchronized void initialize() {
        if (this.ctx == null) {
            ORM orm = ORM.create();
            DynamicObject runLog = orm.queryOne("mrp_caculate_log", new QFilter[]{new QFilter("mrpid", "=", (Object)this.mrpContextId)});
            this.ctx = MRPIntegrateFactory.initEnv((DynamicObject)runLog);
            this.ctx.restore(this.mrpContextId);
        } else {
            this.ctx.restoreBOM();
        }
    }

    @Override
    public void run() {
        while (this.isContinue) {
            if (this.terminated) {
                this.onTerminated();
                break;
            }
            this.resolveEvent(this.ctx, () -> {
                try {
                    return this.eventQueue.poll(3L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        MultiThreadCacheManager.releaseDataSet();
        boolean isDistribute = (Boolean)this.ctx.getCfgValue(EnvCfgItem.USE_DISTRIBUTION_MODE);
        if (isDistribute && !this.onMaster) {
            this.ctx.tearDown();
        }
        WORKERS.remove(this.mrpContextId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resolveEvent(IMRPEnvProvider ctx, Supplier<MRPEvent> evtCreator) {
        block36: {
            MRPEvent event = null;
            try {
                event = evtCreator.get();
                String oldName = Thread.currentThread().getName();
                if (event == null) break block36;
                try (TraceSpan ts = Tracer.create((String)"MRPCalc.worker", (String)"worker");
                     TXHandle h = TX.notSupported((String)"MPRCalc-worker");){
                    ts.addTag("event", event.getEventId());
                    long start = System.currentTimeMillis();
                    Thread.currentThread().setName(String.format("MRPCalcWorker-%s-ismaster-%s", ctx.getRunLogNumber(), this.onMaster) + oldName);
                    ctx.setCurrentResolveMaterial((String)((Object)event.getParam(MultiThreadCacheKey.KEY_MATERIAL_ID)));
                    if ("1".equals(ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                        logger.warn(String.format("ctxid: %s, mrprunner-restore-ctx timecost: %s", event.getMrpContextId(), (System.currentTimeMillis() - start) / 1000L));
                    }
                    start = System.currentTimeMillis();
                    MRPCalcEventResolverFactory.initResolver(event).execute(event, ctx);
                    if ("1".equals(ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                        logger.warn(String.format("ctxid: %s, mrprunner-event-resolve(%s), evtid: %s, timecost: %s", event.getMrpContextId(), event.getClass().getName(), event.getEventId(), (System.currentTimeMillis() - start) / 1000L));
                    }
                    this.notifyWorkCompleted(event, true, ctx);
                }
                finally {
                    Thread.currentThread().setName(oldName);
                    this.eventSet.remove(event.getEventId());
                    ThreadLocals.release();
                }
            }
            catch (Throwable ex) {
                logger.error("MRPCalcWorker got exception, ctxid:" + (event != null ? event.getMrpContextId() : "null"), ex);
                this.eventSet.clear();
                this.eventQueue.clear();
                if (this.onMaster && ctx.isShutdown() || this.stateManager.isMasterTerminated() || this.stateManager.isMasterLost() || this.stateManager.isWorkerTerminated()) {
                    logger.error("MRPCalcWorker shutdown because master has terminated before.", ex);
                } else {
                    try {
                        String details;
                        String string = details = ex.getStackTrace() == null ? null : JSON.toJSONString((Object)ex.getStackTrace());
                        if (details != null) {
                            event.setParam(MultiThreadCacheKey.KEY_SERVICE_EXCEPTION, (Serializable)((Object)details));
                        }
                        String exception = this.getExceptionString(ex);
                        event.setParam(MultiThreadCacheKey.KEY_SERVICE_EXCEPTION_DETAIL, (Serializable)((Object)exception));
                        logger.error("MRPCalcWorker-Exception:" + exception, ex);
                        this.stateManager.setTerminated(exception);
                    }
                    catch (Throwable e) {
                        logger.error("MRPCalcWorker-Exception-Exception:", e);
                        this.stateManager.setTerminated(this.getExceptionString(ex));
                    }
                    this.notifyWorkCompleted(event, false, ctx);
                }
                this.isContinue = false;
                this.terminated = true;
            }
        }
    }

    private String getExceptionString(Throwable ex) {
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWorkCompleted(MRPEvent event, boolean isServiceOk, IMRPEnvProvider ctx) {
        block6: {
            try {
                event.setReplyNodeId(MRPRuntimeConsts.NODE_ID);
                event.setParam(MultiThreadCacheKey.KEY_SERVICE_OK, (Serializable)((Object)String.valueOf(isServiceOk)));
                event.setParam(MultiThreadCacheKey.KEY_REPLY_TS, (Serializable)Long.valueOf(System.currentTimeMillis()));
                event.setParam(MultiThreadCacheKey.KEY_REPLY_RANDOM, (Serializable)((Object)UUID.randomUUID().toString()));
                boolean isDistribute = (Boolean)ctx.getCfgValue(EnvCfgItem.USE_DISTRIBUTION_MODE);
                if (isDistribute) {
                    ctx.getMQManager().publishControlEvent(event);
                    break block6;
                }
                MRPCalcManager.getEventManager((String)event.getEventManagerId()).onMessage(event);
                MRPCalcWorker mRPCalcWorker = this;
                synchronized (mRPCalcWorker) {
                    this.isContinue = false;
                    this.notifyAll();
                }
            }
            catch (Throwable t) {
                this.isContinue = false;
                String str = this.getExceptionString(t);
                logger.error("MRPCalcWork:" + str, t);
                this.stateManager.setTerminated(str);
                this.terminated = true;
            }
        }
    }
}

