/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.common.entity.gross;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RequireTypeSummaryEntity
implements Serializable {
    private static final long serialVersionUID = -4963297128045468171L;
    private Date firstDay;
    private boolean isWeek;
    private List<String> dateList;
    private Map<String, BigDecimal> qtyMap;
    private Long materialId;
    private Long configuredcode;
    private String requireResource;
    private int count;

    public RequireTypeSummaryEntity(boolean isWeek, int count, Date firstDay, Long materialId, Long configuredcode, String requireResource) {
        this.isWeek = isWeek;
        this.count = count;
        this.firstDay = firstDay;
        this.materialId = materialId;
        this.configuredcode = configuredcode;
        this.requireResource = requireResource;
        this.dateList = new ArrayList<String>(count);
        this.qtyMap = new HashMap<String, BigDecimal>(count);
        this.dateList.add("total");
        this.qtyMap.put("total", BigDecimal.ZERO);
        Calendar cal = Calendar.getInstance();
        if (isWeek) {
            cal.setFirstDayOfWeek(2);
            cal.setTime(firstDay);
            int day = cal.get(7);
            if (day == 1) {
                day = 8;
            }
            cal.add(5, cal.getFirstDayOfWeek() - day);
            int n = count;
            for (int i = 0; i < n; ++i) {
                String dateString = cal.get(1) + "/" + (cal.get(2) + 1) + "/" + cal.get(5);
                this.dateList.add(dateString);
                this.qtyMap.put(dateString, BigDecimal.ZERO);
                cal.add(5, 7);
            }
        } else {
            cal.setTime(firstDay);
            int n = count;
            for (int i = 0; i < n; ++i) {
                String dateString = cal.get(1) + "/" + (cal.get(2) + 1);
                if (this.dateList.contains(dateString)) {
                    cal.add(5, 7);
                    continue;
                }
                this.dateList.add(dateString);
                this.qtyMap.put(dateString, BigDecimal.ZERO);
                cal.add(5, 7);
            }
        }
    }

    public Long getMaterialId() {
        return this.materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public Long getConfiguredcode() {
        return this.configuredcode;
    }

    public void setConfiguredcode(Long configuredcode) {
        this.configuredcode = configuredcode;
    }

    public String getRequireResource() {
        return this.requireResource;
    }

    public void setRequireResource(String requireResource) {
        this.requireResource = requireResource;
    }

    public Date getFirstDay() {
        return this.firstDay;
    }

    public void setFirstDay(Date firstDay) {
        this.firstDay = firstDay;
    }

    public boolean isWeek() {
        return this.isWeek;
    }

    public void setWeek(boolean isWeek) {
        this.isWeek = isWeek;
    }

    public List<String> getDateList() {
        return this.dateList;
    }

    public void setDateList(List<String> dateList) {
        this.dateList = dateList;
    }

    public Map<String, BigDecimal> getQtyMap() {
        return this.qtyMap;
    }

    public void setQtyMap(Map<String, BigDecimal> qtyMap) {
        this.qtyMap = qtyMap;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }
}

