/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.common.operate;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.mmc.mrp.common.result.PurForecastOperationPram;
import kd.mmc.mrp.common.result.PurForecastOperationResult;

public class PurForecastOperate {
    public static PurForecastOperationResult execute(String opKey, Map<Object, String> billnoMap, List<Object> currPkIds, PurForecastOperationPram pram) {
        OperationResult operationResult = new OperationResult();
        boolean isRelease = "release".equals(opKey);
        String selectFields = "id, entryentity.id, entryentity.issplited, entryentity.ispublished, entryentity.publisher, entryentity.publish_time, entryentity.lastmodifier, entryentity.lastdatetime";
        DynamicObject data = ORM.create().queryOne("mrp_pur_fctdata", selectFields, new QFilter("entryentity.id", "in", currPkIds).toArray());
        DynamicObjectCollection collection = data.getDynamicObjectCollection("entryentity");
        int errorCount = 0;
        ArrayList<Object> successPkIds = new ArrayList<Object>();
        for (DynamicObject dynamicObject : collection) {
            Object pkValue = dynamicObject.getPkValue();
            boolean published = "1".equals(dynamicObject.getString("ispublished"));
            String isSpilted = dynamicObject.getString("issplited");
            if (isRelease == !published && "N".equals(isSpilted)) {
                successPkIds.add(pkValue);
                dynamicObject.set("publisher", (Object)pram.getPublisher());
                dynamicObject.set("publish_time", (Object)pram.getPublishDateTime());
                dynamicObject.set("ispublished", (Object)(isRelease ? "1" : "0"));
                dynamicObject.set("lastmodifier", (Object)pram.getModifier());
                dynamicObject.set("lastdatetime", (Object)pram.getModifyDateTime());
                continue;
            }
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo("error_code", ErrorLevel.Warning, (Object)errorCount++);
            operateErrorInfo.setMessage(PurForecastOperate.getTipMessage(billnoMap.get(pkValue), pram.getEnableStatusName(), pram.getOperateName(), isSpilted));
            operationResult.addErrorInfo(operateErrorInfo);
        }
        operationResult.setBillCount(currPkIds.size());
        operationResult.setSuccessPkIds(successPkIds);
        return new PurForecastOperationResult(operationResult, (List<DynamicObject>)collection);
    }

    public static String getTipMessage(String material, String enableStatusName, String operateName, String isSpilted) {
        if (!"N".equals(isSpilted)) {
            return String.format(ResManager.loadKDString((String)"%1$s: \u62c6\u5206\u72b6\u6001\u4e0d\u4e3a\u672a\u62c6\u5206\uff0c\u4e0d\u5141\u8bb8%2$s\u3002", (String)"PurForecastOperate_0", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), material, operateName);
        }
        return String.format(ResManager.loadKDString((String)"%1$s: \u53d1\u5e03\u72b6\u6001\u5fc5\u987b\u4e3a%2$s\u624d\u80fd%3$s\u3002", (String)"PurForecastOperate_1", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), material, enableStatusName, operateName);
    }
}

