/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.SqlRequest;
import kd.bos.orm.query.SqlTreeNode;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.user.UserService;

public class DataConversionUtil {
    private static final Log logger = LogFactory.getLog(DataConversionUtil.class);
    private static final String algoKey = "DataConversionUtil";
    private static final String RESOURCE_DATACONFIG = "mrp_resource_dataconfig";
    private static final String RESOURCE_DATACONFIG_NAME = "name";
    private static final String BILLFIELDTRANSFER_NAME = "name";
    private static final String RESOURCE_DATACONFIG_NUMBER = "number";
    private static final String RESOURCE_DATACONFIG_FILTER = "filter_tag";
    private static final String TABLE_ID = "id";
    private static final String RESOURCE_DATACONFIG_DESTBILL = "billfieldtransfer";
    private static final String BILLFIELDTRANSFER = "mrp_billfieldtransfer";
    private static final String BILLFIELDTRANSFER_SECBILL = "srcbill";
    private static final String BILLFIELDTRANSFER_DESTBILL = "destbill";
    private static final String ENTRYENTITY = "entryentity";
    private static final String SRCFIELDFLAG = "sourcefieldflag";
    private static final String DESTFIELDFLAG = "destfieldflag";
    private static final String CALCULATEEXC_TAG = "calculateexc_tag";
    private static final String CALCULATE_EXPRESSION = "expression";

    public static DataSet getPlsOrderDataSet(Set<Long> resourceIds, Set<String> mustInputFields, boolean onlyQueryMustInputFields, Set<Long> productionOrgIds, QFilter qFilter) {
        Set<String> fields = onlyQueryMustInputFields ? Collections.emptySet() : EntityMetadataCache.getDataEntityType((String)"mrp_pls_order").getFields().keySet();
        DataSet resultSet = null;
        int count = 0;
        DataSet[] dataSetArray = new DataSet[resourceIds.size() - 1];
        for (Long resourceId : resourceIds) {
            DataSet dataSet = DataConversionUtil.selectConversionPLSOrders(resourceId, fields, mustInputFields, onlyQueryMustInputFields, productionOrgIds, qFilter);
            if (resultSet == null) {
                resultSet = dataSet;
                continue;
            }
            dataSetArray[count++] = dataSet;
        }
        if (resultSet == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u8d44\u6e90\u6570\u636e\u4e3a\u7a7a, \u8bf7\u68c0\u67e5\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"DataConversionUtil_6", (String)"mmc-mrp-common", (Object[])new Object[0]));
        }
        return dataSetArray.length == 0 ? resultSet : resultSet.union(dataSetArray);
    }

    public static DataSet selectConversionPLSOrders(Long resourceConfId, Set<String> fields, Set<String> mustCoversionFields, boolean onlyQueryMustInputFields, Set<Long> productionOrgIds, QFilter orgQFilter) {
        if (mustCoversionFields == null) {
            mustCoversionFields = Collections.emptySet();
        }
        ORM orm = ORM.create();
        DynamicObject resourceConf = orm.queryOne(RESOURCE_DATACONFIG, new QFilter[]{new QFilter(TABLE_ID, "=", (Object)resourceConfId)});
        DynamicObject fieldMapping = resourceConf.getDynamicObject(RESOURCE_DATACONFIG_DESTBILL);
        DynamicObject fromBillEntity = (fieldMapping = orm.queryOne(BILLFIELDTRANSFER, new QFilter[]{new QFilter(TABLE_ID, "=", (Object)fieldMapping.getLong(TABLE_ID))})).getDynamicObject(BILLFIELDTRANSFER_SECBILL);
        if (fromBillEntity == null) {
            logger.error(ResManager.loadKDString((String)"\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u6e90\u5b9e\u4f53\u4e3a\u7a7a\u3002", (String)"DataConversionUtil_3", (String)"mmc-mrp-common", (Object[])new Object[0]));
            throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u6e90\u5b9e\u4f53\u4e3a\u7a7a\u3002", (String)"DataConversionUtil_3", (String)"mmc-mrp-common", (Object[])new Object[0]));
        }
        DynamicObject toEntity = fieldMapping.getDynamicObject(BILLFIELDTRANSFER_DESTBILL);
        if (toEntity == null) {
            logger.error(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u76ee\u6807\u5b9e\u4f53\u201d\u3002", (String)"DataConversionUtil_4", (String)"mmc-mrp-common", (Object[])new Object[0]));
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u76ee\u6807\u5b9e\u4f53\u201d\u3002", (String)"DataConversionUtil_4", (String)"mmc-mrp-common", (Object[])new Object[0]));
        }
        MainEntityType fromBillMainType = (MainEntityType)orm.getDataEntityType(fromBillEntity.getString(TABLE_ID));
        MainEntityType toBillMainType = (MainEntityType)orm.getDataEntityType(toEntity.getString(TABLE_ID));
        QFilter filter = DataConversionUtil.getFilter(resourceConf, fromBillMainType);
        DynamicObjectCollection fielMappingEntry = fieldMapping.getDynamicObjectCollection(ENTRYENTITY);
        if (fielMappingEntry == null || fielMappingEntry.isEmpty()) {
            logger.error(ResManager.loadKDString((String)"\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u7f3a\u5c11\u5b57\u6bb5\u6620\u5c04\u4fe1\u606f\u3002", (String)"DataConversionUtil_5", (String)"mmc-mrp-common", (Object[])new Object[0]));
            throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u7f3a\u5c11\u5b57\u6bb5\u6620\u5c04\u4fe1\u606f\u3002", (String)"DataConversionUtil_5", (String)"mmc-mrp-common", (Object[])new Object[0]));
        }
        HashSet<String> mustFields = new HashSet<String>(mustCoversionFields.size());
        mustFields.addAll(mustCoversionFields);
        for (DynamicObject mapping : fielMappingEntry) {
            String toField = mapping.getString(DESTFIELDFLAG);
            mustFields.remove(toField);
        }
        if (!CollectionUtils.isEmpty(mustFields)) {
            String join = String.join((CharSequence)",", mustFields);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u201c%1$s\u201d\u4e2d\u76ee\u6807\u5b9e\u4f53\u7f3a\u5c11\u5fc5\u5f55\u5b57\u6bb5\u201c%2$s\u201d\u3002", (String)"DataConversionUtil_9", (String)"mmc-mrp-common", (Object[])new Object[0]), fieldMapping.getString(RESOURCE_DATACONFIG_NUMBER), join));
        }
        HashSet<String> mappingToFields = new HashSet<String>();
        String oqlFields = DataConversionUtil.getOqlFields(fielMappingEntry, resourceConf, mappingToFields, onlyQueryMustInputFields, mustCoversionFields);
        if (!mustCoversionFields.isEmpty()) {
            StringBuilder errorMsg = new StringBuilder();
            DynamicObject finalFieldMapping = fieldMapping;
            mustCoversionFields.forEach(val -> {
                if (!mappingToFields.contains(val)) {
                    if (StringUtils.isBlank((CharSequence)errorMsg)) {
                        errorMsg.append(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u76ee\u6807\u5b9e\u4f53\u201c%s\u201d\u3002", (String)"DataConversionUtil_0", (String)"mmc-mrp-common", (Object[])new Object[0]), finalFieldMapping.getString("name")));
                    }
                    errorMsg.append(String.format(ResManager.loadKDString((String)"\u7f3a\u5c11\u5fc5\u5f55\u5b57\u6bb5\u201c%1$s:%2$s\u201d\u3002", (String)"DataConversionUtil_1", (String)"mmc-mrp-common", (Object[])new Object[0]), toBillMainType.findProperty(val).getDisplayName(), val));
                }
            });
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                throw new KDBizException(errorMsg.toString());
            }
        }
        if (!CollectionUtils.isEmpty(productionOrgIds)) {
            for (DynamicObject mapping : fielMappingEntry) {
                String fromField = mapping.getString(SRCFIELDFLAG);
                String toField = mapping.getString(DESTFIELDFLAG);
                if (!"production_org".equals(toField)) continue;
                filter = Objects.isNull(filter) ? new QFilter(fromField, "in", productionOrgIds) : filter.and(new QFilter(fromField, "in", productionOrgIds));
                break;
            }
        }
        if (Objects.nonNull(orgQFilter)) {
            QFilter newQFilter = DataConversionUtil.getNewQFilter(orgQFilter, fielMappingEntry);
            filter = Objects.isNull(filter) ? newQFilter : filter.and(newQFilter);
        }
        DataConversionUtil.parseSQL(orm, fromBillMainType.getName(), oqlFields, filter, resourceConf);
        DataSet dataSet = orm.queryDataSet(algoKey, fromBillMainType.getName(), oqlFields, new QFilter[]{filter}, null);
        if (onlyQueryMustInputFields) {
            return dataSet;
        }
        RowMeta rowMeta = dataSet.getRowMeta();
        if (rowMeta.getFieldIndex("sourceentity", false) < 0) {
            String sourceEntity = "'" + fromBillEntity.getPkValue() + "'";
            dataSet = dataSet.addField(sourceEntity, "sourceentity");
            rowMeta = dataSet.getRowMeta();
        }
        ArrayList<String> nullFields = new ArrayList<String>();
        for (String field : fields) {
            if (rowMeta.getFieldIndex(field, false) >= 0) continue;
            nullFields.add(field);
        }
        dataSet = dataSet.addNullField(nullFields.toArray(new String[0]));
        dataSet = dataSet.select(fields.toArray(new String[0]));
        return dataSet;
    }

    private static void parseSQL(ORM orm, String entityName, String oqlFields, QFilter filter, DynamicObject resourceConf) {
        try {
            SqlTreeNode root = orm.getQuerySql(entityName, oqlFields, new QFilter[]{filter}, null, 0, -1);
            DataConversionUtil.logSql(root, resourceConf, algoKey, entityName);
        }
        catch (Throwable e) {
            logger.error(String.format("%s-\u89e3\u6790sql\u5f02\u5e38", algoKey), e);
        }
    }

    private static String getOqlFields(DynamicObjectCollection fielMappingEntry, DynamicObject resourceConf, Set<String> mappingToFields, boolean onlyQueryMustInputFields, Set<String> mustCoversionFields) {
        StringBuilder oqlFields = new StringBuilder();
        for (DynamicObject mapping : fielMappingEntry) {
            String fromField = mapping.getString(SRCFIELDFLAG);
            String toField = mapping.getString(DESTFIELDFLAG);
            mappingToFields.add(toField);
            if (onlyQueryMustInputFields && !mustCoversionFields.contains(toField)) continue;
            if (!StringUtils.isEmpty((CharSequence)fromField)) {
                oqlFields.append(fromField).append(" as ").append(toField).append(", ");
                continue;
            }
            if (!StringUtils.isEmpty((CharSequence)fromField)) continue;
            String formula = mapping.getString(CALCULATEEXC_TAG);
            boolean isUnSet = StringUtils.isEmpty((CharSequence)formula);
            Map jo = isUnSet ? null : (Map)SerializationUtils.fromJsonString((String)formula, Map.class);
            String string = fromField = jo == null ? null : jo.get(CALCULATE_EXPRESSION).toString();
            if (fromField == null) {
                throw new KDBizException(new ErrorCode("EMPTY_FIELD_CONTENT", String.format(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u201c%1$s, id: %2$s\u201d\u7684\u53d6\u6570\u8bbe\u7f6e\u201c%3$s, id: %4$s\u201d\u5b57\u6bb5\u201c%5$s\u201d\u672a\u8bbe\u7f6e\u3002", (String)"DataConversionUtil_10", (String)"mmc-mrp-common", (Object[])new Object[0]), resourceConf.getString("name"), resourceConf.getString(TABLE_ID), resourceConf.getString("name"), resourceConf.getString(TABLE_ID), toField)), new Object[0]);
            }
            if ("true".equalsIgnoreCase(fromField.trim())) {
                fromField = "1";
            } else if ("false".equalsIgnoreCase(fromField.trim())) {
                fromField = "0";
            }
            if (StringUtils.isEmpty((CharSequence)fromField)) continue;
            oqlFields.append('(').append(fromField).append(") as ").append(toField).append(", ");
        }
        return oqlFields.deleteCharAt(oqlFields.length() - 2).toString();
    }

    private static QFilter getFilter(DynamicObject resourceConf, MainEntityType fromBillMainType) {
        QFilter filter = null;
        String filterContent = resourceConf.getString(RESOURCE_DATACONFIG_FILTER);
        if (!StringUtils.isEmpty((CharSequence)filterContent)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterContent, FilterCondition.class);
            FilterBuilder fb = new FilterBuilder(fromBillMainType, filterCondition);
            TimeService timeService = new TimeService();
            fb.setTimeService((ITimeService)timeService);
            UserService userService = new UserService();
            fb.setUserService((IUserService)userService);
            fb.buildFilter(false);
            filter = fb.getQFilter();
        }
        return filter;
    }

    private static void logSql(SqlTreeNode node, DynamicObject mrpDs, String className, String mt) {
        List children;
        SqlRequest req = node.getValue();
        if (req != null) {
            logger.warn(String.format("mrprunner-fetch-datas-%s, rl: %s, dsname: %s(%s), mt: %s, route: %s, sql: %s, ppk: %s", className, "====", mrpDs.getString("name"), mrpDs.getString(RESOURCE_DATACONFIG_NUMBER), mt, req.getDbRoute(), req.getSql(), req.getParentFK()));
        }
        if ((children = node.getChildren()) == null) {
            return;
        }
        for (SqlTreeNode c : children) {
            DataConversionUtil.logSql(c, mrpDs, className, mt);
        }
    }

    private static QFilter getNewQFilter(QFilter qFilter, DynamicObjectCollection fielMappingEntry) {
        String property = qFilter.getProperty();
        String cp = qFilter.getCP();
        Object value = qFilter.getValue();
        List collect = fielMappingEntry.stream().filter(x -> x.getString(DESTFIELDFLAG).equals(property)).map(x -> x.getString(SRCFIELDFLAG)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect) || collect.size() != 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\u76ee\u6807\u5b9e\u4f53\u5b57\u6bb5\u4e2d\u672a\u5305\u542b\u8fc7\u6ee4\u6761\u4ef6\u5b57\u6bb5\u201c%s\u201d\u3002", (String)"DataConversionUtil_8", (String)"mmc-mrp-common", (Object[])new Object[0]), property));
        }
        QFilter newQFilter = new QFilter((String)collect.get(0), cp, value);
        List nests = qFilter.getNests(true);
        for (QFilter.QFilterNest nest : nests) {
            QFilter nextFilter = nest.getFilter();
            if (Objects.isNull(nextFilter)) continue;
            if (nest.isAnd()) {
                newQFilter.and(DataConversionUtil.getNewQFilter(nextFilter, fielMappingEntry));
                continue;
            }
            newQFilter.or(DataConversionUtil.getNewQFilter(nextFilter, fielMappingEntry));
        }
        return newQFilter;
    }
}

