/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kd.bos.exception.KDBizException;

public class DateUtils {
    private static final ThreadLocal<SimpleDateFormat> DATETIME = ThreadLocal.withInitial(() -> new SimpleDateFormat(PATTERN_DATETIME));
    private static final ThreadLocal<SimpleDateFormat> DATE = ThreadLocal.withInitial(() -> new SimpleDateFormat(PATTERN_DATE));
    private static final String PATTERN_DATE = "yyyy/MM/dd";
    private static final String PATTERN_DATETIME = "yyyy/MM/dd HH:mm:ss";
    private static final String EXPORT_DATETIME = "yyyyMMddHHmmssSSS";
    private static final ThreadLocal<SimpleDateFormat> EXPORT_DATE = ThreadLocal.withInitial(() -> new SimpleDateFormat(EXPORT_DATETIME));
    private static final SimpleDateFormat formatMonth = new SimpleDateFormat("yyyy/MM");

    private DateUtils() {
        throw new KDBizException("not supported");
    }

    public static String getSundayOfWeek(Date date) {
        return DATE.get().format(DateUtils.getSundayDateOfWeek(date));
    }

    public static Date getSundayDateOfWeek(Date date) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        Date monday = null;
        monday = instance.get(7) == 2 ? date : DateUtils.getMondayDateOfWeek(date);
        instance.setTime(monday);
        instance.add(5, 6);
        return instance.getTime();
    }

    public static String getMondayOfWeek(Date date) {
        return DATE.get().format(DateUtils.getMondayDateOfWeek(date));
    }

    public static Date getMondayDateOfWeek(Date date) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        return DateUtils.getMondayDateOfWeek(instance);
    }

    public static Date getMondayDateOfWeek(Calendar calendar) {
        Calendar instance = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        int index = calendar.get(7);
        if (index == 1) {
            index = 8;
        }
        calendar.add(5, calendar.getFirstDayOfWeek() - index);
        instance.set(11, 0);
        instance.set(12, 0);
        instance.set(13, 0);
        instance.set(14, 0);
        return calendar.getTime();
    }

    public static Date getFirstDayOfMonth(Date date) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        instance.set(5, 1);
        instance.set(11, 0);
        instance.set(12, 0);
        instance.set(13, 0);
        instance.set(14, 0);
        return instance.getTime();
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar instance = Calendar.getInstance();
        date = DateUtils.getFirstDayOfMonth(date);
        instance.setTime(date);
        instance.add(2, 1);
        instance.add(5, -1);
        return instance.getTime();
    }

    public static String formatDate(Date date) {
        return DATE.get().format(date);
    }

    public static String formatDateTime(Date date) {
        return DATETIME.get().format(date);
    }

    public static String formatExportDate(Date date) {
        return EXPORT_DATE.get().format(date);
    }

    public static Date parseDate(String format) {
        try {
            return DATE.get().parse(format);
        }
        catch (ParseException e) {
            throw new KDBizException("convert faield " + e.getMessage());
        }
    }

    public static Date parseDateTime(String format) {
        try {
            return DATETIME.get().parse(format);
        }
        catch (ParseException e) {
            throw new KDBizException("convert faield " + e.getMessage());
        }
    }

    public static Date convertDate(Date date) {
        String format = DATE.get().format(date);
        try {
            return DATE.get().parse(format);
        }
        catch (ParseException e) {
            throw new KDBizException("convert faield " + e.getMessage());
        }
    }

    public static String formatMonthDate(Date date) {
        return formatMonth.format(date);
    }
}

