/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.id.ID;
import kd.bos.inte.api.EnabledLang;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.mulilang.GLDataServiceHelper;

public class MulLangTableDataInitUtil {
    public static String getDefaultLocaleValue(LocaleString localeString) {
        String defaultLocaleId = GLDataServiceHelper.getDefaultLocaleId();
        return (String)localeString.getItem(defaultLocaleId);
    }

    public static List<Object[]> getInsertMulLangTableParams(Object id, LocaleString ... localeStrings) {
        List langs = InteServiceHelper.getEnabledLang();
        ArrayList<Object[]> params = new ArrayList<Object[]>(langs.size());
        String[] pkIds = ID.genStringIds((int)langs.size());
        for (int i = 0; i < langs.size(); ++i) {
            EnabledLang enabledLang = (EnabledLang)langs.get(i);
            Object[] p = new Object[3 + localeStrings.length];
            p[0] = id;
            p[1] = pkIds[i];
            p[2] = enabledLang.getNumber();
            for (int j = 0; j < localeStrings.length; ++j) {
                String localeValue = (String)localeStrings[j].getItem(enabledLang.getNumber());
                p[3 + j] = localeValue == null ? "" : localeValue;
            }
            params.add(p);
        }
        return params;
    }

    public static LocaleString string2LocaleString(String defValue) {
        List langs = InteServiceHelper.getEnabledLang();
        HashMap<String, String> values = new HashMap<String, String>(langs.size());
        for (EnabledLang enabledLang : langs) {
            values.put(enabledLang.getNumber(), defValue);
        }
        return LocaleString.fromMap(values);
    }

    public static String formatFormulaJson(String calculateexc, String calculatetext) {
        calculateexc = MulLangTableDataInitUtil.appendBackSlash(calculateexc);
        calculatetext = MulLangTableDataInitUtil.appendBackSlash(calculatetext);
        return String.format("{\"expression\":\"%s\",\"exprTran\":\"%s\",\"description\":{\"zh_CN\":\"\"},\"exprDesc\":\"%s\",\"localeExprTran\":{\"zh_CN\":\"%s\"}}", calculateexc, calculatetext, calculatetext, calculatetext);
    }

    private static String appendBackSlash(String calculateexc) {
        if (calculateexc.startsWith("\"") && calculateexc.endsWith("\"")) {
            calculateexc = "\\\"" + calculateexc.substring(1, calculateexc.length() - 1) + "\\\"";
        }
        return calculateexc;
    }
}

