/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.pls.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Row;
import kd.mmc.mrp.pls.model.Category;
import kd.mmc.mrp.pls.model.WorkCenter;
import kd.mmc.mrp.pls.model.WorkCenterManager;

public class OrderMaterialMananger {
    private final Map<Long, List<WorkCenter>> midOrGroupId2WorkCenters = new HashMap<Long, List<WorkCenter>>(16);

    public void init(Row row, WorkCenterManager workCenterManager) {
        String category = row.getString("category");
        long orderModelKey = Category.MATERIAL.getValue().equals(category) ? row.getLong("material_id") : row.getLong("materialgroup_id");
        WorkCenter workCenter = workCenterManager.getWorkCenter(row.getLong("workcenter_id"));
        if (workCenter != null) {
            List workCenters = this.midOrGroupId2WorkCenters.computeIfAbsent(orderModelKey, k -> new ArrayList());
            workCenters.add(workCenter);
        }
    }

    public Long getOrderModelKey(WorkCenterManager workCenterManager, String midAndProdOrgId, long materialId) {
        Long materialProdInfoId = workCenterManager.getMaterialId(midAndProdOrgId);
        Long key = null;
        if (materialProdInfoId == null) {
            List<Long> materialGroupIds = workCenterManager.getMaterialGroupIds(String.valueOf(materialId));
            if (materialGroupIds == null) {
                return null;
            }
            for (Long materialGroupId : materialGroupIds) {
                if (!this.midOrGroupId2WorkCenters.containsKey(materialGroupId)) continue;
                key = materialGroupId;
                break;
            }
        } else {
            key = materialProdInfoId;
        }
        return key;
    }

    public List<WorkCenter> get(Long key) {
        return this.midOrGroupId2WorkCenters.getOrDefault(key, Collections.emptyList());
    }

    public Map<Long, List<WorkCenter>> getMidOrGroupId2WorkCenters() {
        return this.midOrGroupId2WorkCenters;
    }

    public int size() {
        return this.midOrGroupId2WorkCenters.size();
    }
}

