/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.pls.model;

import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mmc.mrp.pls.model.WorkShift;
import kd.mmc.mrp.pls.util.LogUtils;

public class WorkShiftManager {
    private static final Log log = LogFactory.getLog(WorkShiftManager.class);
    private final Map<Integer, WorkShift> seq2WorkShifts = new LinkedHashMap<Integer, WorkShift>();
    private final Set<Integer> firstDayWorkShiftSeqs = new HashSet<Integer>();

    public void put(Integer seq, WorkShift workShift) {
        this.seq2WorkShifts.put(seq, workShift);
    }

    public boolean isCalcFirstDay(boolean acrossDayShift, Long calcStartTime, Date planDate) {
        boolean isCalcFirstDay = false;
        if (calcStartTime > 0L) {
            for (Map.Entry<Integer, WorkShift> entry : this.seq2WorkShifts.entrySet()) {
                WorkShift workShift = entry.getValue();
                Long startTime = workShift.getStartTime();
                if (acrossDayShift && workShift.isAcrossDay()) {
                    if (startTime.compareTo(calcStartTime) < 0) continue;
                    this.firstDayWorkShiftSeqs.add(entry.getKey());
                    continue;
                }
                if (startTime.compareTo(calcStartTime) < 0) continue;
                isCalcFirstDay = true;
                this.firstDayWorkShiftSeqs.add(entry.getKey());
            }
        } else {
            isCalcFirstDay = true;
            this.firstDayWorkShiftSeqs.addAll(this.seq2WorkShifts.keySet());
        }
        LogUtils.info(log, ResManager.loadKDString((String)"\u7b2c\u4e00\u5929\u662f\u5426\u53c2\u4e0e\u8ba1\u7b97: {}, calcStartTime: {}, planDate: {}, firstDayWorkShiftSeqs: {}", (String)"WorkShiftManager_0", (String)"mmc-mrp-common", (Object[])new Object[0]), isCalcFirstDay, calcStartTime, planDate, this.firstDayWorkShiftSeqs);
        return isCalcFirstDay;
    }

    public Map<Integer, WorkShift> getAll() {
        return this.seq2WorkShifts;
    }

    public WorkShift get(Integer key) {
        return this.seq2WorkShifts.get(key);
    }

    public boolean currentWorkShiftCanWork(int seq) {
        return this.firstDayWorkShiftSeqs.contains(seq);
    }

    public String toString() {
        return "WorkShiftManager{seq2WorkShifts=" + this.seq2WorkShifts + ", firstDayWorkShiftSeqs=" + this.firstDayWorkShiftSeqs + '}';
    }

    public boolean shiftCanWork(Date startDate, Date workDate, WorkShift workShift) {
        Long startTime;
        Long calcStartTime = (startDate.getTime() - workDate.getTime()) / 1000L;
        return calcStartTime.compareTo(startTime = workShift.getStartTime()) <= 0;
    }
}

