/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.pls.util;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.pls.model.Category;
import kd.mmc.mrp.pls.model.WorkUnit;
import org.apache.commons.lang3.time.DateFormatUtils;

public class CurrentDayTimeUtils {
    public Map<Long, Map<String, BigDecimal>> getWorkCenterDateTimes(List<Long> workcenterId, List<Date> time) {
        Map<Long, Map<Long, Map<String, BigDecimal>>> workcenterMatToDateNumMap = this.getInstransitOrder(workcenterId, time);
        Map<Long, Map<String, BigDecimal>> workCenterMatCalcResult = this.getWorkCenterMatCalcResult(workcenterMatToDateNumMap);
        return workCenterMatCalcResult;
    }

    private Map<Long, Map<String, BigDecimal>> getWorkCenterMatCalcResult(Map<Long, Map<Long, Map<String, BigDecimal>>> workcenterMatToDateNumMap) {
        HashMap<Long, Map<String, BigDecimal>> workDateToTimes = new HashMap<Long, Map<String, BigDecimal>>();
        if (workcenterMatToDateNumMap == null) {
            return workDateToTimes;
        }
        HashMap workcenterMatToTimeMap = new HashMap();
        if (!workcenterMatToDateNumMap.isEmpty()) {
            String selectFields = "id,entryproduct.producttype producttype,entryproduct.materielf7,entryproduct.materialgroup,entryproduct.subentryentitycal.workunits,entryproduct.subentryentitycal.completeresult,entryproduct.subentryentitycal.precision";
            Set<Long> longs = workcenterMatToDateNumMap.keySet();
            DynamicObjectCollection query = QueryServiceHelper.query((String)"mpdm_workcentre", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", longs)});
            for (DynamicObject dynamicObject : query) {
                long workCenterId = dynamicObject.getLong("id");
                HashMap<Long, BigDecimal> matToTimeMap = (HashMap<Long, BigDecimal>)workcenterMatToTimeMap.get(workCenterId);
                if (matToTimeMap == null) {
                    matToTimeMap = new HashMap<Long, BigDecimal>(8);
                }
                BigDecimal result = new BigDecimal(dynamicObject.getString("entryproduct.subentryentitycal.completeresult") == null ? "0" : dynamicObject.getString("entryproduct.subentryentitycal.completeresult"));
                String workUnit = dynamicObject.getString("entryproduct.subentryentitycal.workunits");
                result = WorkUnit.MINUTE.getValue().equals(workUnit) ? result.multiply(WorkUnit.Constants.MINUTE) : (WorkUnit.HOUR.getValue().equals(workUnit) ? (result = result.multiply(WorkUnit.Constants.HOUR)) : (WorkUnit.DAY.getValue().equals(workUnit) ? (result = result.multiply(WorkUnit.Constants.DAY)) : result));
                Long materialId = 0L;
                materialId = Category.MATERIAL.getValue().equals(dynamicObject.getString("producttype")) ? Long.valueOf(dynamicObject.getLong("entryproduct.materielf7")) : Long.valueOf(dynamicObject.getLong("entryproduct.materialgroup"));
                matToTimeMap.put(materialId, result);
                workcenterMatToTimeMap.put(workCenterId, matToTimeMap);
            }
        }
        for (Map.Entry<Long, Map<Long, Map<String, BigDecimal>>> mapEntry : workcenterMatToDateNumMap.entrySet()) {
            Map matToTimeMap;
            Long workCenterId = mapEntry.getKey();
            Map<Long, Map<String, BigDecimal>> value = mapEntry.getValue();
            if (!workcenterMatToTimeMap.containsKey(workCenterId) || (matToTimeMap = (Map)workcenterMatToTimeMap.get(workCenterId)) == null || matToTimeMap.size() == 0) continue;
            for (Map.Entry map : matToTimeMap.entrySet()) {
                Long mat = (Long)map.getKey();
                BigDecimal time = (BigDecimal)map.getValue();
                if (!value.containsKey(mat)) continue;
                Map<String, BigDecimal> dateToNumMap = value.get(mat);
                for (Map.Entry<String, BigDecimal> dateToNumEntry : dateToNumMap.entrySet()) {
                    String date = dateToNumEntry.getKey();
                    BigDecimal num = dateToNumEntry.getValue();
                    HashMap<String, BigDecimal> decimalMap = (HashMap<String, BigDecimal>)workDateToTimes.get(workCenterId);
                    if (decimalMap == null) {
                        decimalMap = new HashMap<String, BigDecimal>(8);
                    }
                    BigDecimal multiply = num.multiply(time);
                    if (decimalMap.containsKey(date)) {
                        BigDecimal bigDecimal = ((BigDecimal)decimalMap.get(date)).add(multiply);
                        decimalMap.put(date, bigDecimal);
                    } else {
                        decimalMap.put(date, multiply);
                    }
                    workDateToTimes.put(workCenterId, decimalMap);
                }
            }
        }
        return workDateToTimes;
    }

    public Map<Long, Map<Long, Map<String, BigDecimal>>> getInstransitOrder(List<Long> workcenterIds, List<Date> time) {
        Calendar instance = Calendar.getInstance();
        List<String> stringDate = this.getStringDate(time, instance);
        HashMap<Long, Map<Long, Map<String, BigDecimal>>> workcenterMatToDateNumMap = new HashMap<Long, Map<Long, Map<String, BigDecimal>>>(8);
        List<QFilter> mftorderQfilter = this.getMftorderQfilter(workcenterIds, time);
        Map<Long, Map<Long, Long>> workCenterMatOrGroup = this.getWorkCenterMatOrGroup(workcenterIds);
        DynamicObjectCollection pom_mftorder = QueryServiceHelper.query((String)"pom_mftorder", (String)"org,treeentryentity.material,treeentryentity.material.masterid,treeentryentity.baseqty,treeentryentity.workcenter,treeentryentity.planbegintime", (QFilter[])mftorderQfilter.toArray(new QFilter[mftorderQfilter.size()]));
        for (DynamicObject dynamicObject : pom_mftorder) {
            Map<String, BigDecimal> dateNumMap;
            HashMap<Long, Map<String, BigDecimal>> matToDateNumMap;
            Date date_w = dynamicObject.getDate("treeentryentity.planbegintime");
            instance.setTime(date_w);
            instance.set(11, 0);
            instance.set(12, 0);
            instance.set(13, 0);
            instance.set(14, 0);
            String date = DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.format(instance.getTime());
            if (!stringDate.contains(date)) continue;
            Long workcenterId = dynamicObject.getLong("treeentryentity.workcenter");
            Map<Long, Long> longLongMap = workCenterMatOrGroup.get(workcenterId);
            Long orderModelKey = this.getOrderModelKeyByQuery(dynamicObject, longLongMap);
            BigDecimal baseqty = dynamicObject.getBigDecimal("treeentryentity.baseqty");
            if (workcenterId == 0L || orderModelKey == null) continue;
            if (workcenterMatToDateNumMap.containsKey(workcenterId)) {
                matToDateNumMap = (HashMap<Long, Map<String, BigDecimal>>)workcenterMatToDateNumMap.get(workcenterId);
                if (matToDateNumMap.containsKey(orderModelKey)) {
                    dateNumMap = (Map)matToDateNumMap.get(orderModelKey);
                    if (dateNumMap.containsKey(date)) {
                        BigDecimal num = (BigDecimal)dateNumMap.get(date);
                        num = num.add(baseqty);
                        dateNumMap.put(date, num);
                        continue;
                    }
                    dateNumMap.put(date, baseqty);
                    continue;
                }
                dateNumMap = new HashMap(8);
                dateNumMap.put(date, baseqty);
                matToDateNumMap.put(orderModelKey, dateNumMap);
                continue;
            }
            matToDateNumMap = new HashMap<Long, Map<String, BigDecimal>>(8);
            dateNumMap = new HashMap<String, BigDecimal>(8);
            dateNumMap.put(date, baseqty);
            matToDateNumMap.put(orderModelKey, dateNumMap);
            workcenterMatToDateNumMap.put(workcenterId, matToDateNumMap);
        }
        return workcenterMatToDateNumMap;
    }

    private Map<Long, Map<Long, Long>> getWorkCenterMatOrGroup(List<Long> workcenterIds) {
        HashMap<Long, Map<Long, Long>> workCenterMat = new HashMap<Long, Map<Long, Long>>(8);
        String selectFields = "id,entryproduct.producttype producttype,entryproduct.materielf7,entryproduct.materialgroup,entryproduct.subentryentitycal.workunits,entryproduct.subentryentitycal.completeresult,entryproduct.subentryentitycal.precision";
        DynamicObjectCollection query = QueryServiceHelper.query((String)"mpdm_workcentre", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", workcenterIds)}, (String)"entryproduct.materielf7 desc");
        for (DynamicObject dynamicObject : query) {
            long workCenterId = dynamicObject.getLong("id");
            HashMap<Long, Long> mat = (HashMap<Long, Long>)workCenterMat.get(workCenterId);
            if (mat == null) {
                mat = new HashMap<Long, Long>(8);
            }
            Long materialId = 0L;
            if (Category.MATERIAL.getValue().equals(dynamicObject.getString("producttype"))) {
                materialId = dynamicObject.getLong("entryproduct.materielf7");
                mat.put(materialId, materialId);
            } else {
                DynamicObject[] materialmftinfo;
                materialId = dynamicObject.getLong("entryproduct.materialgroup");
                QFilter filter = new QFilter("mftcontrolentry.materialcontrol.id", "=", (Object)materialId);
                QFilter status = new QFilter("status", "=", (Object)"C");
                QFilter enable = new QFilter("enable", "=", (Object)"1");
                for (DynamicObject materialInfo : materialmftinfo = BusinessDataServiceHelper.load((String)"bd_materialmftinfo", (String)"id,masterid,materialattr", (QFilter[])new QFilter[]{filter, status, enable})) {
                    DynamicObject material = (DynamicObject)materialInfo.get("masterid");
                    if (mat.containsKey(material.getLong("id"))) continue;
                    mat.put(material.getLong("id"), materialId);
                }
            }
            workCenterMat.put(workCenterId, mat);
        }
        return workCenterMat;
    }

    private Long getOrderModelKeyByQuery(DynamicObject dynamicObject, Map<Long, Long> matOrGroup) {
        Long materielId = dynamicObject.getLong("treeentryentity.material");
        if (matOrGroup == null) {
            return null;
        }
        Long aLong = matOrGroup.get(materielId);
        return aLong;
    }

    private List<String> getStringDate(List<Date> time, Calendar instance) {
        ArrayList<String> list = new ArrayList<String>(time.size());
        for (Date dates : time) {
            instance.setTime(dates);
            instance.set(11, 0);
            instance.set(12, 0);
            instance.set(13, 0);
            instance.set(14, 0);
            String date = DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.format(instance.getTime());
            list.add(date);
        }
        return list;
    }

    public List<QFilter> getMftorderQfilter(List<Long> workcenterId, List<Date> time) {
        ArrayList<QFilter> list_qf = new ArrayList<QFilter>(8);
        QFilter billstatus_qf = new QFilter("billstatus", "=", (Object)"C");
        QFilter taskstatus_qf = new QFilter("treeentryentity.taskstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"A", "B", "D"}));
        QFilter bizstatus_qf = new QFilter("treeentryentity.bizstatus", "=", (Object)"A");
        QFilter billstatus_workcenter = new QFilter("treeentryentity.workcenter", "in", workcenterId);
        list_qf.add(billstatus_qf);
        list_qf.add(taskstatus_qf);
        list_qf.add(bizstatus_qf);
        list_qf.add(billstatus_workcenter);
        return list_qf;
    }
}

