/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.basedata;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.pdm.common.constants.ProconfigScheImConst;

public class ProconfigSchemeImportPlugIn
extends AbstractBillPlugIn {
    private static final String KEY_NUMBER = "number";
    private static final String KEY_CREATEORG = "createorg";
    private static final String KEY_NAME = "name";
    private static final String MPDM_BOMEXPANDCONFIG = "mpdm_bomexpandconfig";
    private static final String BD_MATERIAL = "bd_material";
    private static final String PDM_FEATURE_DEF = "pdm_featuredefinition";
    private static final String MPDM_FEATURE_TYPE = "mpdm_featuretype";

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        List datalist = e.getSourceDataList();
        this.searchData(datalist);
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        Map sourceData = e.getSourceData();
        this.patchFeatureInfo(sourceData);
        String msgInfo = this.patchConfigType(sourceData);
        if (StringUtils.isNotEmpty((CharSequence)msgInfo)) {
            ArrayList<String> msgs = new ArrayList<String>(1);
            msgs.add(msgInfo);
            e.setCancel(true);
            e.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), msgs);
            e.setFireAfterImportData(false);
        }
    }

    private void patchFeatureInfo(Map<String, Object> sourceData) {
        JSONArray featureInfoEntrys = (JSONArray)JSON.toJSON((Object)sourceData.get("featureinfo"));
        if (featureInfoEntrys != null && !featureInfoEntrys.isEmpty()) {
            for (int i = 0; i < featureInfoEntrys.size(); ++i) {
                JSONObject featureInfo = (JSONObject)JSON.toJSON((Object)featureInfoEntrys.get(i));
                if (featureInfo == null) continue;
                Object featuretypeObj = featureInfo.get((Object)"featuretype");
                JSONObject featuretype = featuretypeObj != null ? (JSONObject)featuretypeObj : null;
                String importProp = featuretype != null ? featuretype.getString("importprop") : KEY_NUMBER;
                String featurePropV = featuretype != null ? featuretype.getString(importProp) : "";
                JSONArray features = (JSONArray)JSON.toJSON((Object)featureInfo.get((Object)"subentryentity"));
                if (features.isEmpty()) continue;
                String preFeatureNumberId = "";
                for (int j = 0; j < features.size(); ++j) {
                    JSONObject feature = (JSONObject)JSON.toJSON((Object)features.get(j));
                    if (feature == null) continue;
                    JSONObject featureDef = (JSONObject)JSON.toJSON((Object)feature.get((Object)"featureid"));
                    if (featureDef != null) {
                        String importprop = featureDef.getString("importprop");
                        String featureKey = featureDef.getString(importprop);
                        Map featureDefMap = (Map)ProconfigScheImConst.featureMap.get(featureKey);
                        if (featureDefMap != null) {
                            feature.put("featurenumberid", featureDefMap.get("id"));
                            String featureValue = feature.getString("featurevalue");
                            Object featureValueInfo = featureDefMap.get(featureValue);
                            if (featureValueInfo instanceof DynamicObject) {
                                feature.put("featurevalueid", ((DynamicObject)featureValueInfo).get("treeentryentity.id"));
                            }
                        }
                    } else {
                        feature.put("featurenumberid", (Object)preFeatureNumberId);
                    }
                    preFeatureNumberId = feature.getString("featurenumberid");
                }
            }
        }
    }

    private String patchConfigType(Map<String, Object> sourceData) {
        String configType;
        String configTypeTrans;
        String configProp;
        JSONObject materialID = (JSONObject)JSON.toJSON((Object)sourceData.get("masterid"));
        if (materialID == null) {
            return ResManager.loadKDString((String)"\u7269\u6599\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5bfc\u5165\u7269\u6599\u3002", (String)"ProconfigSchemeImportPlugIn_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
        }
        String matPropKey = StringUtils.isNotEmpty((CharSequence)materialID.getString("importprop")) ? materialID.getString("importprop") : KEY_NUMBER;
        String matKey = materialID.getString(matPropKey);
        DynamicObject material = (DynamicObject)ProconfigScheImConst.materialMap.get(matKey);
        String string = configProp = material == null ? "" : material.getString("configproperties");
        if ("3".equals(configProp)) {
            return String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u4e3a\u7279\u5f81\u4ef6\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"ProconfigSchemeImportPlugIn_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), matKey);
        }
        JSONObject bomExpand = (JSONObject)JSON.toJSON((Object)sourceData.get("bomexpandconfig"));
        String headConfigType = sourceData.get("configtype") == null ? "" : sourceData.get("configtype").toString();
        JSONArray featureInfo = (JSONArray)JSON.toJSON((Object)sourceData.get("featureinfo"));
        if (bomExpand == null) {
            if (StringUtils.isNotEmpty((CharSequence)configProp) && "2".equals(configProp)) {
                return String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u4e3a\u914d\u7f6e\u4ef6\uff0cBOM\u5c55\u5f00\u8bbe\u7f6e\u5fc5\u5f55\uff0c\u8bf7\u5bfc\u5165BOM\u5c55\u5f00\u8bbe\u7f6e\u3002", (String)"ProconfigSchemeImportPlugIn_2", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), matKey);
            }
            return this.checkFeatureType(configProp, headConfigType, featureInfo, matKey, "");
        }
        if (!"2".equals(configProp)) {
            return String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u4e3a\u975e\u914d\u7f6e\u4ef6\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165BOM\u5c55\u5f00\u8bbe\u7f6e\u3002", (String)"ProconfigSchemeImportPlugIn_3", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), matKey);
        }
        String propKey = StringUtils.isNotEmpty((CharSequence)bomExpand.getString("importprop")) ? bomExpand.getString("importprop") : KEY_NUMBER;
        String bomExpandKey = bomExpand.getString(propKey);
        DynamicObject bomExpandDO = (DynamicObject)ProconfigScheImConst.bomExpandMap.get(bomExpandKey);
        String string2 = configTypeTrans = bomExpandDO == null ? "" : bomExpandDO.getString("superbomtype.configtype");
        String string3 = "A".equals(configTypeTrans) ? "1" : (configType = "B".equals(configTypeTrans) ? "2" : "");
        if (StringUtils.isBlank((CharSequence)headConfigType)) {
            if ("2".equals(configProp)) {
                sourceData.put("configtype", configType);
            } else {
                sourceData.put("configtype", "");
            }
        } else if (!configType.equals(headConfigType)) {
            return String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u7684\u914d\u7f6e\u65b9\u5f0f\u4e0eBOM\u5c55\u5f00\u8bbe\u7f6e\u7684\u8d85\u7ea7BOM\u7c7b\u578b\u7684\u914d\u7f6e\u65b9\u5f0f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProconfigSchemeImportPlugIn_4", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), matKey);
        }
        Object isdealresult = sourceData.get("isdealresult");
        if ("1".equals(configProp)) {
            if (isdealresult == null) {
                sourceData.put("isdealresult", true);
            } else if (isdealresult instanceof Boolean && !((Boolean)isdealresult).booleanValue()) {
                return String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u7684\u201c\u914d\u7f6e\u65b9\u5f0f\u201d\u4e3a\u201c\u7ec4\u4ef6\u9009\u914d\u201d\uff0c\u201c\u751f\u6210\u7ec4\u4ef6\u660e\u7ec6\u201d\u5fc5\u987b\u4e3a\u201c\u662f\u201d\u3002", (String)"ProconfigSchemeImportPlugIn_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), matKey);
            }
        }
        return this.checkFeatureType(configProp, configType, featureInfo, matKey, bomExpandKey);
    }

    private String checkFeatureType(String configProp, String configType, JSONArray featureInfo, String matInfo, String bomExpandInfo) {
        boolean featureIsEmpty;
        StringBuilder msgInfo = new StringBuilder();
        boolean bl = featureIsEmpty = featureInfo != null && !featureInfo.isEmpty();
        if (!"2".equals(configProp)) {
            if (featureIsEmpty) {
                msgInfo.append(this.checkFeatureTypeConf(configProp, matInfo, featureInfo));
            }
        } else if ("1".equals(configType)) {
            if (featureIsEmpty) {
                msgInfo.append(String.format(ResManager.loadKDString((String)"BOM\u5c55\u5f00\u8bbe\u7f6e\u201c%1$s\u201d\u7684\u8d85\u7ea7BOM\u7c7b\u578b\u7684\u914d\u7f6e\u65b9\u5f0f\u4e3a\u7ec4\u4ef6\u9009\u914d\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u7279\u5f81\u7c7b\u3002", (String)"ProconfigSchemeImportPlugIn_6", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), bomExpandInfo));
            }
        } else if ("2".equals(configType)) {
            if (!featureIsEmpty) {
                msgInfo.append(String.format(ResManager.loadKDString((String)"BOM\u5c55\u5f00\u8bbe\u7f6e\u201c%1$s\u201d\u7684\u8d85\u7ea7BOM\u7c7b\u578b\u7684\u914d\u7f6e\u65b9\u5f0f\u4e3a\u7279\u5f81\u9009\u914d\uff0c\u5fc5\u987b\u5bfc\u5165\u7279\u5f81\u7c7b\u3002", (String)"ProconfigSchemeImportPlugIn_7", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), bomExpandInfo));
            }
            msgInfo.append(this.checkFeatureTypeConf(configProp, matInfo, featureInfo));
        }
        return msgInfo.toString();
    }

    private String checkFeatureTypeConf(String configProp, String matInfo, JSONArray featureInfo) {
        StringBuilder msgInfo = new StringBuilder();
        for (int i = 0; i < featureInfo.size(); ++i) {
            String propKey;
            String featuretypeKey;
            DynamicObject featuretypeDO;
            JSONObject featuretype;
            JSONObject featureInfoRow = (JSONObject)JSON.toJSON((Object)featureInfo.get(i));
            if (featureInfoRow == null || (featuretype = (JSONObject)JSON.toJSON((Object)featureInfoRow.get((Object)"featuretype"))) == null || (featuretypeDO = (DynamicObject)ProconfigScheImConst.featureTypeMap.get(featuretypeKey = featuretype.getString(propKey = StringUtils.isNotEmpty((CharSequence)featuretype.getString("importprop")) ? featuretype.getString("importprop") : KEY_NUMBER))) == null) continue;
            String type = featuretypeDO.getString("type");
            if ("2".equals(configProp) && !"B".equals(type)) {
                msgInfo.append(String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u4e3a\u914d\u7f6e\u4ef6\uff0c\u7279\u5f81\u7c7b\u201c%2$s\u201d\u5fc5\u987b\u4e3a\u914d\u7f6e\u7c7b\u3002", (String)"ProconfigSchemeImportPlugIn_8", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), matInfo, featuretypeKey));
                continue;
            }
            if (!"2".equals(configProp) && !"A".equals(type)) {
                msgInfo.append(String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u4e3a\u975e\u914d\u7f6e\u4ef6\uff0c\u7279\u5f81\u7c7b\u201c%2$s\u201d\u5fc5\u987b\u4e3a\u9009\u9879\u7c7b\u3002", (String)"ProconfigSchemeImportPlugIn_9", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), matInfo, featuretypeKey));
                continue;
            }
            JSONArray features = (JSONArray)JSON.toJSON((Object)featureInfoRow.get((Object)"subentryentity"));
            if (features == null) continue;
            Set defs = (Set)ProconfigScheImConst.featureTypeDefs.get(featuretypeKey);
            String preFeatureDefKey = "";
            for (int j = 0; j < features.size(); ++j) {
                String featureVName;
                DynamicObject featureDefInfo;
                String featureDefType;
                JSONObject feature = (JSONObject)JSON.toJSON((Object)features.get(j));
                if (feature == null) continue;
                JSONObject featureDef = (JSONObject)JSON.toJSON((Object)feature.get((Object)"featureid"));
                String featureValue = feature.getString("featurevalue");
                String featureValueName = feature.getString("featurevaluename");
                if (featureDef != null) {
                    String propFeatureDefKey = StringUtils.isNotEmpty((CharSequence)featureDef.getString("importprop")) ? featuretype.getString("importprop") : KEY_NUMBER;
                    String featureDefKey = featureDef.getString(propFeatureDefKey);
                    if (!defs.contains(featureDefKey)) {
                        msgInfo.append(String.format(ResManager.loadKDString((String)"\u7279\u5f81\u7c7b\u201c%1$s\u201d\u4e2d\u4e0d\u5b58\u5728\u7279\u5f81\u5b9a\u4e49\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProconfigSchemeImportPlugIn_10", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), featuretypeKey, featureDefKey));
                    }
                    preFeatureDefKey = featureDefKey;
                }
                String featureDefID = feature.getString("featurenumberid");
                Set featureVals = (Set)ProconfigScheImConst.featureDefVals.get(featureDefID);
                if (StringUtils.isNotEmpty((CharSequence)featureValue) && featureVals != null && !featureVals.isEmpty() && !featureVals.contains(featureValue)) {
                    msgInfo.append(String.format(ResManager.loadKDString((String)"\u7279\u5f81\u5b9a\u4e49\u201c%1$s\u201d\u4e2d\u4e0d\u5b58\u5728\u7279\u5f81\u503c\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProconfigSchemeImportPlugIn_11", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), preFeatureDefKey, featureValue));
                }
                String string = featureDefType = (featureDefInfo = (DynamicObject)ProconfigScheImConst.featureInfoMap.get(feature.getLong("featurenumberid"))) == null ? "" : featureDefInfo.getString("featuretype");
                if ("B".equals(featureDefType) || featureVals == null || !featureVals.contains(featureValue)) continue;
                Map featureValueMap = (Map)ProconfigScheImConst.featureDefValNames.get(featureDefID);
                String string2 = featureVName = featureValueMap != null ? featureValueMap.getOrDefault(featureValue, "") : "";
                if (StringUtils.equals((CharSequence)featureValueName, (CharSequence)featureVName)) continue;
                feature.put("featurevaluename", (Object)featureVName);
            }
        }
        return msgInfo.toString();
    }

    private void searchData(List<Map<String, Object>> datalist) {
        if (datalist == null) {
            return;
        }
        HashSet<String> bomExpandSet = new HashSet<String>(128);
        HashSet<String> materialSet = new HashSet<String>(128);
        HashSet<String> featureEntrySet = new HashSet<String>(128);
        HashSet<String> featureTypeSet = new HashSet<String>(128);
        AtomicReference<String> filterField = new AtomicReference<String>(KEY_NUMBER);
        AtomicReference<String> matfilterField = new AtomicReference<String>(KEY_NUMBER);
        AtomicReference<String> featureEntryField = new AtomicReference<String>(KEY_NUMBER);
        AtomicReference<String> featureTypeField = new AtomicReference<String>(KEY_NUMBER);
        datalist.stream().forEach(rowData -> {
            JSONObject bomExpand = (JSONObject)JSON.toJSON(rowData.get("bomexpandconfig"));
            this.recordFilterData(bomExpand, bomExpandSet, filterField);
            JSONObject material = (JSONObject)JSON.toJSON(rowData.get("masterid"));
            this.recordFilterData(material, materialSet, matfilterField);
            JSONArray featureInfoEntry = (JSONArray)JSON.toJSON(rowData.get("featureinfo"));
            if (featureInfoEntry != null && !featureInfoEntry.isEmpty()) {
                for (int i = 0; i < featureInfoEntry.size(); ++i) {
                    JSONObject featureInfo = (JSONObject)JSON.toJSON((Object)featureInfoEntry.get(i));
                    if (featureInfo == null) continue;
                    JSONObject featureType = (JSONObject)JSON.toJSON((Object)featureInfo.get((Object)"featuretype"));
                    this.recordFilterData(featureType, featureTypeSet, featureTypeField);
                    JSONArray features = (JSONArray)JSON.toJSON((Object)featureInfo.get((Object)"subentryentity"));
                    if (features == null || features.isEmpty()) continue;
                    for (int j = 0; j < features.size(); ++j) {
                        JSONObject feature = (JSONObject)JSON.toJSON((Object)features.get(j));
                        if (feature == null) continue;
                        JSONObject featureDef = (JSONObject)JSON.toJSON((Object)feature.get((Object)"featureid"));
                        this.recordFilterData(featureDef, featureEntrySet, featureEntryField);
                    }
                }
            }
        });
        this.searchDataAndRecord("bomexpandconfig", filterField.get(), this.getBOMExpandField(), bomExpandSet);
        this.searchDataAndRecord("masterid", matfilterField.get(), this.getMaterialField(), materialSet);
        this.searchDataAndRecord("featuretype", featureTypeField.get(), this.getFeatureTypeField(), featureTypeSet);
        this.searchFeatureData(featureEntryField.get(), this.getFeatureField(), featureEntrySet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchFeatureData(String filterField, String queryField, Set<String> dataSet) {
        QFilter qFilter;
        if (dataSet == null || dataSet.isEmpty()) {
            return;
        }
        String filterFieldKey = filterField;
        if (StringUtils.isNotEmpty((CharSequence)filterField)) {
            qFilter = new QFilter(filterField, "in", dataSet);
        } else {
            qFilter = new QFilter(KEY_NUMBER, "in", dataSet);
            filterFieldKey = KEY_NUMBER;
        }
        DynamicObjectCollection features = QueryServiceHelper.query((String)PDM_FEATURE_DEF, (String)queryField, (QFilter[])new QFilter[]{qFilter});
        for (int i = 0; i < features.size(); ++i) {
            Object featureVals;
            DynamicObject feature = (DynamicObject)features.get(i);
            String featureDefKey = feature.getString(filterFieldKey);
            String featureValue = feature.getString("treeentryentity.entryvalue");
            String featureValueName = feature.getString("treeentryentity.entryvaluename");
            Map map = ProconfigScheImConst.featureMap;
            synchronized (map) {
                Map featureDefMap = ProconfigScheImConst.featureMap.getOrDefault(featureDefKey, new HashMap(4));
                featureDefMap.put(featureValue, feature);
                featureDefMap.put("id", feature.getLong("id"));
                ProconfigScheImConst.featureMap.put(featureDefKey, featureDefMap);
                ProconfigScheImConst.featureInfoMap.put(feature.getLong("id"), feature);
            }
            map = ProconfigScheImConst.featureDefVals;
            synchronized (map) {
                featureVals = ProconfigScheImConst.featureDefVals.getOrDefault(feature.getLong("id") + "", new HashSet(4));
                if (StringUtils.isNotEmpty((CharSequence)featureValue)) {
                    featureVals.add(featureValue);
                }
                ProconfigScheImConst.featureDefVals.put(feature.getLong("id") + "", featureVals);
            }
            map = ProconfigScheImConst.featureDefValNames;
            synchronized (map) {
                featureVals = ProconfigScheImConst.featureDefValNames.getOrDefault(feature.getLong("id") + "", new HashMap(2));
                if (StringUtils.isNotEmpty((CharSequence)featureValue)) {
                    featureVals.put(featureValue, featureValueName);
                }
                ProconfigScheImConst.featureDefValNames.put(feature.getLong("id") + "", featureVals);
                continue;
            }
        }
    }

    private void recordFilterData(JSONObject josnData, Set<String> dataSet, AtomicReference<String> dataField) {
        if (josnData != null) {
            String importProp = josnData.getString("importprop");
            if (StringUtils.isNotEmpty((CharSequence)importProp)) {
                String dataProp = josnData.getString(importProp);
                dataSet.add(dataProp);
                dataField.set(importProp);
            } else {
                String dataProp = josnData.getString(KEY_NUMBER);
                dataSet.add(dataProp);
                dataField.set(KEY_NUMBER);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchDataAndRecord(String searchField, String filterField, String queryField, Set<String> dataSet) {
        QFilter qFilter;
        if (dataSet == null || dataSet.isEmpty()) {
            return;
        }
        String filterFieldKey = filterField;
        if (StringUtils.isNotEmpty((CharSequence)filterField)) {
            qFilter = new QFilter(filterField, "in", dataSet);
        } else {
            qFilter = new QFilter(KEY_NUMBER, "in", dataSet);
            filterFieldKey = KEY_NUMBER;
        }
        String QUERY_BILL = MPDM_BOMEXPANDCONFIG;
        Map cacheMap = ProconfigScheImConst.bomExpandMap;
        if ("masterid".equals(searchField)) {
            QUERY_BILL = BD_MATERIAL;
            cacheMap = ProconfigScheImConst.materialMap;
        } else if ("featuretype".equals(searchField)) {
            QUERY_BILL = MPDM_FEATURE_TYPE;
            cacheMap = ProconfigScheImConst.featureTypeMap;
        }
        DynamicObjectCollection bomExpands = QueryServiceHelper.query((String)QUERY_BILL, (String)queryField, (QFilter[])new QFilter[]{qFilter});
        for (int i = 0; i < bomExpands.size(); ++i) {
            DynamicObject bomExpand = (DynamicObject)bomExpands.get(i);
            String bomExpandKey = bomExpand.getString(filterFieldKey);
            Map map = cacheMap;
            synchronized (map) {
                cacheMap.put(bomExpandKey, bomExpand);
            }
            if (!"featuretype".equals(searchField)) continue;
            map = ProconfigScheImConst.featureTypeDefs;
            synchronized (map) {
                Set featureDefSet = ProconfigScheImConst.featureTypeDefs.getOrDefault(bomExpandKey, new HashSet());
                featureDefSet.add(bomExpand.getString("entryentity.featurenum.number"));
                featureDefSet.add(bomExpand.getString("entryentity.featurenum.name"));
                ProconfigScheImConst.featureTypeDefs.put(bomExpandKey, featureDefSet);
            }
            map = ProconfigScheImConst.featureTypeDefMap;
            synchronized (map) {
                List defInfos = ProconfigScheImConst.featureTypeDefMap.getOrDefault(bomExpandKey, new ArrayList(2));
                HashMap<String, String> defInfoMap = new HashMap<String, String>(2);
                defInfoMap.put(KEY_NUMBER, bomExpand.getString("entryentity.featurenum.number"));
                defInfoMap.put(KEY_NAME, bomExpand.getString("entryentity.featurenum.name"));
                defInfos.add(defInfoMap);
                ProconfigScheImConst.featureTypeDefMap.put(bomExpandKey, defInfos);
                continue;
            }
        }
    }

    public String getBOMExpandField() {
        StringBuilder bomExpandField = new StringBuilder();
        bomExpandField.append("id,");
        bomExpandField.append("number,");
        bomExpandField.append("name,");
        bomExpandField.append("superbomtype.configtype");
        return bomExpandField.toString();
    }

    public String getFeatureTypeField() {
        StringBuilder bomExpandField = new StringBuilder();
        bomExpandField.append("id,");
        bomExpandField.append("number,");
        bomExpandField.append("name,");
        bomExpandField.append("type,");
        bomExpandField.append("entryentity.id,");
        bomExpandField.append("entryentity.featurenum.number,");
        bomExpandField.append("entryentity.featurenum.name");
        return bomExpandField.toString();
    }

    private String getMaterialField() {
        StringBuilder materialField = new StringBuilder();
        materialField.append("id,");
        materialField.append("number,");
        materialField.append("name,");
        materialField.append("configproperties");
        return materialField.toString();
    }

    private String getFeatureField() {
        StringBuilder featureField = new StringBuilder();
        featureField.append("id,");
        featureField.append("number,");
        featureField.append("name,");
        featureField.append("featuretype,");
        featureField.append("treeentryentity.id,");
        featureField.append("treeentryentity.featurevalueid,");
        featureField.append("treeentryentity.entryvalue,");
        featureField.append("treeentryentity.entryvaluename");
        return featureField.toString();
    }
}

