/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.batchmftbom;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.mmc.pdm.business.ecoplatform.EcoUtils;
import kd.mmc.pdm.common.util.CheckBOMUtils;
import kd.mmc.pdm.common.util.MMCUtils;
import kd.mmc.pdm.common.util.batchbom.BatchBOMUtils;
import kd.mmc.pdm.formplugin.batchmftbom.BatchBomPageOPUtils;

public class BatchBomToECNBusiness {
    private static volatile BatchBomToECNBusiness batchBomToECNBusiness;
    private Map<Long, DynamicObject> proBomMap = new HashMap<Long, DynamicObject>(100);
    private Map<Long, String> failedMap = new HashMap<Long, String>(100);
    private Set<Long> repeatS = new HashSet<Long>(100);
    SimpleDateFormat formatData = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private boolean replacePlanFlag = false;
    private Map<Long, Boolean> repeatBomEntryReplaceMap = new HashMap<Long, Boolean>(16);
    private Map<String, List<DynamicObject>> bomEcoEntryRepalceMap = new HashMap<String, List<DynamicObject>>(32);
    private Map<Long, List<DynamicObject>> replacePlanBomEntryMap = new HashMap<Long, List<DynamicObject>>(32);
    private static String ENTITY_REPLACEPLAN;
    private Map<Long, DynamicObject> updateRowToEcnRow = new HashMap<Long, DynamicObject>(16);
    private static final String LONG_FORMAT = "^\\d+$";

    private BatchBomToECNBusiness() {
    }

    public static BatchBomToECNBusiness getInstance() {
        if (batchBomToECNBusiness == null) {
            batchBomToECNBusiness = new BatchBomToECNBusiness();
        }
        return batchBomToECNBusiness;
    }

    public int doEcnmodify(IDataModel dm, Long[] bomIds, DynamicObjectCollection changeEntrys, Map<String, Object> param, StringBuffer errorMsg) {
        if (!this.hasNewECNPermission()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d8\u66f4\u5931\u8d25\uff1a\u5f53\u524d\u7528\u6237\u6ca1\u6709\u3010\u5de5\u7a0b\u53d8\u66f4\u5355\u7684\u3011\u7684\u65b0\u589e\u6743\u9650\u3002", (String)"BatchBomToECNBusiness_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        }
        this.proBomMap.clear();
        this.failedMap.clear();
        this.repeatS.clear();
        this.bomEcoEntryRepalceMap.clear();
        this.repeatBomEntryReplaceMap.clear();
        if (bomIds == null || changeEntrys == null) {
            return 0;
        }
        Map<Object, DynamicObject> bomMap = this.businessDataLoadBomData(bomIds);
        if (bomMap == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u67e5\u5230BOM\u4fe1\u606f\u3002", (String)"BatchBomToECNBusiness_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        }
        int success = this.filterBomType(bomMap, changeEntrys, param, errorMsg);
        if (bomMap.isEmpty()) {
            return success;
        }
        Set<Map.Entry<Object, DynamicObject>> bomSet = bomMap.entrySet();
        List<DynamicObject> retEcoBom = new ArrayList<DynamicObject>(100);
        String changeType = String.valueOf(param.get("changetype"));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date validateDate = null;
        try {
            validateDate = format.parse(param.get("effectiveDate").toString());
        }
        catch (ParseException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
        List<String> modifyFiledList = this.clearModifyFieldSuffix(param);
        this.replacePlanFlag = param.containsKey("replacePlanFlag") ? (Boolean)JSONArray.parseObject((String)param.get("replacePlanFlag").toString(), Boolean.class) : false;
        switch (changeType) {
            case "A": {
                retEcoBom = this.addNewEntry(bomSet, changeEntrys, modifyFiledList);
                break;
            }
            case "B": {
                retEcoBom = this.modifyEntry(bomSet, changeEntrys, modifyFiledList, validateDate);
                if (!retEcoBom.isEmpty()) break;
                throw new KDBizException(ResManager.loadKDString((String)"\u4fee\u6539\u5931\u8d25\uff1a\u9009\u62e9\u7684BOM\u4e2d\uff0c\u7ec4\u4ef6\u4e0d\u5b58\u5728\u6216\u5df2\u5931\u6548\u3002", (String)"BatchBomToECNBusiness_2", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            }
            case "C": {
                retEcoBom = this.replaceEntry(bomSet, changeEntrys, modifyFiledList, validateDate);
                break;
            }
            case "D": {
                retEcoBom = this.invalidateMat(bomSet, changeEntrys, modifyFiledList, validateDate);
                if (!retEcoBom.isEmpty() || !this.repeatBomEntryReplaceMap.isEmpty()) break;
                throw new KDBizException(ResManager.loadKDString((String)"\u4fee\u6539\u5931\u8d25\uff1a\u9009\u62e9\u7684BOM\u4e2d\uff0c\u7ec4\u4ef6\u4e0d\u5b58\u5728\u6216\u5df2\u5931\u6548\u3002", (String)"BatchBomToECNBusiness_2", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            }
            case "E": {
                break;
            }
            case "F": {
                retEcoBom = this.addFeatureEntry(bomSet, changeEntrys, modifyFiledList, validateDate, changeType);
                if (!retEcoBom.isEmpty()) break;
                throw new KDBizException(ResManager.loadKDString((String)"\u65b0\u589e\u5931\u8d25\uff1a\u9009\u62e9\u7684BOM\u4e2d\uff0c\u7ec4\u4ef6\u4e0d\u5b58\u5728\u3002", (String)"BatchBomToECNBusiness_3", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            }
            case "G": {
                break;
            }
            case "H": {
                retEcoBom = this.deleteEntry(bomSet, changeEntrys, modifyFiledList, validateDate, "H");
                if (!retEcoBom.isEmpty()) break;
                throw new KDBizException(ResManager.loadKDString((String)"\u4fee\u6539\u9009\u9879\u7c7b\u5931\u8d25\uff1a\u9009\u62e9\u7684BOM\u4e2d\uff0c\u7ec4\u4ef6\u4e0d\u5b58\u5728\u3002", (String)"BatchBomToECNBusiness_4", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            }
        }
        this.repeatValidECNBOMEntrys(retEcoBom, bomMap, changeType);
        DynamicObject retEcoObj = this.createEcoHeadInfo(param, validateDate);
        DynamicObjectCollection pentry = retEcoObj.getDynamicObjectCollection("pentry");
        int pEntrySize = pentry.size();
        DynamicObject logObj = this.createLogInfo(changeEntrys, param, bomSet);
        this.resetECOBomEntryData(retEcoBom);
        List ecoErrorInfo = new ArrayList(100);
        if (!retEcoBom.isEmpty()) {
            OperationResult ecoSaveRet = OperationServiceHelper.executeOperate((String)"save", (String)"pdm_bom_eco", (DynamicObject[])new DynamicObject[]{retEcoObj}, (OperateOption)OperateOption.create());
            ecoErrorInfo = ecoSaveRet.getAllErrorOrValidateInfo();
        }
        try (TXHandle h = TX.required();){
            if (!retEcoBom.isEmpty()) {
                for (DynamicObject ecoBom : retEcoBom) {
                    DynamicObjectCollection coll = ecoBom.getDynamicObjectCollection("entry");
                    if (coll == null || coll.isEmpty()) continue;
                    for (int i = 0; i < coll.size(); ++i) {
                        DynamicObject ecoBomEntry = (DynamicObject)coll.get(i);
                        ecoBomEntry.set("estimatestatus", (Object)"A");
                        ecoBomEntry.set("continuouspoint", (Object)"A");
                        ecoBomEntry.set("iscanestimate", (Object)true);
                        ecoBomEntry.set("groupkey", (Object)false);
                        ecoBomEntry.set("refkey", (Object)false);
                        ecoBomEntry.set("acttime", (Object)validateDate);
                        ecoBomEntry.set("transtartdate", (Object)validateDate);
                        ecoBomEntry.set("tranqty", (Object)BigDecimal.ZERO);
                    }
                }
                OperationResult ecoBomSaveRet = OperationServiceHelper.executeOperate((String)"save", (String)"pdm_ecobom", (DynamicObject[])retEcoBom.toArray(new DynamicObject[retEcoBom.size()]), (OperateOption)OperateOption.create());
                List ecoBomErrorInfo = ecoBomSaveRet.getAllErrorOrValidateInfo();
                ecoErrorInfo.addAll(ecoBomErrorInfo);
            }
            OperationResult logSaveRet = OperationServiceHelper.executeOperate((String)"save", (String)"pdm_batchmftbomlog", (DynamicObject[])new DynamicObject[]{logObj}, (OperateOption)OperateOption.create());
            List logErrorInfo = logSaveRet.getAllErrorOrValidateInfo();
            ecoErrorInfo.addAll(logErrorInfo);
            if (!ecoErrorInfo.isEmpty()) {
                h.setRollback(true);
            }
        }
        if (!ecoErrorInfo.isEmpty()) {
            DeleteServiceHelper.delete((IDataEntityType)retEcoObj.getDataEntityType(), (Object[])new Object[]{retEcoObj.getPkValue()});
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u53d8\u66f4\u5355\u5931\u8d25:%s\u3002", (String)"BatchBomToECNBusiness_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), ecoErrorInfo.toString()));
        }
        this.setMessageInfo(bomSet, errorMsg);
        return pEntrySize;
    }

    private void repeatValidECNBOMEntrys(List<DynamicObject> retEcoBom, Map<Object, DynamicObject> bomMap, String changeType) {
        ArrayList<DynamicObject> removeEcoBom = new ArrayList<DynamicObject>(16);
        for (DynamicObject ecoBom : retEcoBom) {
            String bomPkValue = ecoBom.getString("bomid");
            long bomPk = StringUtils.isNotEmpty((CharSequence)bomPkValue) && Pattern.matches(LONG_FORMAT, bomPkValue) ? Long.parseLong(bomPkValue) : 0L;
            DynamicObject bom = bomMap.get(bomPk);
            if (bom == null) continue;
            DynamicObjectCollection bomEntryDOC = bom.getDynamicObjectCollection("entry");
            DynamicObjectCollection ecoBomEntryDoc = ecoBom.getDynamicObjectCollection("entry");
            DynamicObject bomType = bom.getDynamicObject("type");
            String checkRepeat = bomType.getString("checkrepeat");
            String verifyDimension = bomType.getString("verifydimension");
            if ("A".equals(checkRepeat)) continue;
            String errorMsg = BatchBOMUtils.repeatAddEcoEntrys((DynamicObjectCollection)ecoBomEntryDoc, (DynamicObjectCollection)bomEntryDOC, (String)checkRepeat, (String)verifyDimension, (String)changeType);
            if (StringUtils.isNotEmpty((CharSequence)errorMsg) && "C".equals(checkRepeat)) {
                this.failedMap.put(bomPk, errorMsg);
                removeEcoBom.add(ecoBom);
                continue;
            }
            if (!StringUtils.isNotEmpty((CharSequence)errorMsg) || !"B".equals(checkRepeat)) continue;
            this.failedMap.put(bomPk, errorMsg);
            this.repeatS.add(bomPk);
        }
        if (!removeEcoBom.isEmpty()) {
            retEcoBom.removeAll(removeEcoBom);
            for (DynamicObject ecoBom : removeEcoBom) {
                long ecoBomPk = ecoBom.getLong("id");
                this.proBomMap.remove(ecoBomPk);
            }
        }
    }

    private void resetECOBomEntryData(List<DynamicObject> retEcoBom) {
        for (int i = 0; i < retEcoBom.size(); ++i) {
            DynamicObject ecoBOM = retEcoBom.get(i);
            DynamicObjectCollection entryDOC = ecoBOM.getDynamicObjectCollection("entry");
            DataEntityPropertyCollection properties = entryDOC.getDynamicObjectType().getProperties();
            if (entryDOC == null) continue;
            this.resetEntryData(entryDOC, properties);
        }
    }

    private void resetEntryData(DynamicObjectCollection entryDOC, DataEntityPropertyCollection properties) {
        for (int j = 0; j < entryDOC.size(); ++j) {
            DynamicObject entry = (DynamicObject)entryDOC.get(j);
            for (int k = 0; k < properties.size(); ++k) {
                String field = ((IDataEntityProperty)properties.get(k)).getName();
                if (!StringUtils.isNotEmpty((CharSequence)field) || !properties.containsKey((Object)field)) continue;
                Object entryowner = entry.get(field);
                entry.set(field, entryowner);
            }
        }
    }

    private List<String> clearModifyFieldSuffix(Map<String, Object> param) {
        List<String> modifyFiledList = JSONArray.parseArray((String)param.get("modifyFileds").toString(), String.class);
        modifyFiledList = modifyFiledList.stream().map(field -> {
            if (field.contains("_ctrl")) {
                return field.substring(0, field.indexOf("_ctrl"));
            }
            if (field.contains("_qty")) {
                return field.substring(0, field.indexOf("_qty"));
            }
            if (field.contains("_set")) {
                return field.substring(0, field.indexOf("_set"));
            }
            return field;
        }).collect(Collectors.toList());
        return modifyFiledList;
    }

    private Map<Object, DynamicObject> businessDataLoadBomData(Long[] bomIds) {
        DynamicObject mftBom = ORM.create().newDynamicObject("pdm_mftbom");
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])bomIds, (DynamicObjectType)mftBom.getDynamicObjectType());
        HashMap<Object, DynamicObject> bomMap = new HashMap<Object, DynamicObject>(32);
        if (load == null || load.length == 0) {
            return bomMap;
        }
        for (int i = 0; i < load.length; ++i) {
            DynamicObject bom = load[i];
            if (bom == null) continue;
            bomMap.put(bom.getLong("id"), bom);
        }
        return bomMap;
    }

    private void setMessageInfo(Set<Map.Entry<Object, DynamicObject>> bomSet, StringBuffer errorMsg) {
        for (Map.Entry<Object, DynamicObject> entry : bomSet) {
            String msg;
            long bomid = Long.parseLong(entry.getKey().toString());
            DynamicObject bomObj = entry.getValue();
            String bomNumber = bomObj == null ? "" : bomObj.getString("number");
            String bomTypeCheckRepeat = this.getBomTypeCheckRepeat(bomObj);
            if (!this.failedMap.containsKey(bomid) || !StringUtils.isNotEmpty((CharSequence)(msg = this.failedMap.get(bomid))) || this.repeatS.contains(bomid)) continue;
            errorMsg.append(bomNumber).append("\uff1a").append(msg).append("\n");
        }
    }

    private int filterBomType(Map<Object, DynamicObject> bomMap, DynamicObjectCollection changeEntrys, Map<String, Object> param, StringBuffer errorMsg) {
        String changeTypeParam = String.valueOf(param.get("changetype"));
        int sucess = 0;
        Iterator<Map.Entry<Object, DynamicObject>> iterator = bomMap.entrySet().iterator();
        HashSet<Map.Entry<Object, DynamicObject>> bomSet = new HashSet<Map.Entry<Object, DynamicObject>>(bomMap.size());
        DynamicObject bomType = null;
        while (iterator.hasNext()) {
            Map.Entry<Object, DynamicObject> next = iterator.next();
            DynamicObject bomInfo = next.getValue();
            if (bomInfo == null) continue;
            Object bomPk = next.getKey();
            boolean isAddEntry = true;
            boolean isBomTypeEntryType = this.checkBomTypeEntryType(bomInfo, changeTypeParam);
            bomType = bomInfo.getDynamicObject("type");
            if (isBomTypeEntryType) {
                String sourceMsg = ResManager.loadKDString((String)"\u975e\u7279\u5f81\u9009\u914d\u7684\u914d\u7f6eBOM\u4e0d\u5141\u8bb8\u7ef4\u62a4\u9009\u9879\u7c7b\u3002", (String)"BatchBomToECNBusiness_6", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                errorMsg.append(bomInfo.getString("number")).append("\uff1a").append(sourceMsg).append("\n");
                this.failedMap.put(Long.valueOf(bomPk.toString()), sourceMsg);
                bomSet.add(next);
                isAddEntry = false;
            } else if (bomType != null && ("A".equals(bomType.getString("purpose")) || "C".equals(bomType.getString("purpose")))) {
                for (int i = 0; i < changeEntrys.size(); ++i) {
                    StringBuilder logEntryErrorMsg;
                    DynamicObject changeEntry = (DynamicObject)changeEntrys.get(i);
                    boolean isCheckMatMftInfo = BatchBomToECNBusiness.checkBomMatMftInfo(bomType, changeEntry, changeTypeParam, logEntryErrorMsg = new StringBuilder());
                    if (!isCheckMatMftInfo) continue;
                    String errorInfo = logEntryErrorMsg.toString();
                    errorMsg.append(bomInfo.getString("number")).append("\uff1a").append(errorInfo).append("\n");
                    String msgInfo = this.failedMap.getOrDefault(Long.valueOf(bomPk.toString()), "");
                    this.failedMap.put(Long.valueOf(bomPk.toString()), msgInfo + errorInfo);
                    bomSet.add(next);
                    isAddEntry = false;
                }
            }
            if (isAddEntry) continue;
            iterator.remove();
        }
        DynamicObject logObj = this.createLogInfo(changeEntrys, param, bomSet);
        OperationResult logSaveRet = OperationServiceHelper.executeOperate((String)"save", (String)"pdm_batchmftbomlog", (DynamicObject[])new DynamicObject[]{logObj}, (OperateOption)OperateOption.create());
        return sucess;
    }

    public static boolean checkBomMatMftInfo(DynamicObject bomTypeDO, DynamicObject changeEntry, String opKey, StringBuilder logEntryErrorMsg) {
        boolean isCheckMatMftInfo = false;
        String purpose = MMCUtils.getDynamicObjectStringData((DynamicObject)bomTypeDO, (String)"purpose");
        DynamicObject entryMaterialDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)changeEntry, (String)"entrymaterial");
        DynamicObject materialDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)changeEntry, (String)"entrymaterialid");
        if (("A".equals(purpose) || "C".equals(purpose)) && entryMaterialDO == null) {
            String materBumber = MMCUtils.getDynamicObjectStringData((DynamicObject)materialDO, (String)"number");
            int row = MMCUtils.getDynamicObjectIntegerData((DynamicObject)changeEntry, (String)"seq");
            isCheckMatMftInfo = true;
            logEntryErrorMsg.append(String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25\uff0c\u7b2c%2$s\u884c\u7ec4\u4ef6\u7f16\u7801[%3$s]\u7684\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"BatchBomToECNBusiness_7", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), new CheckBOMUtils().getOpTypeMsg(opKey), row, materBumber));
        }
        return isCheckMatMftInfo;
    }

    private boolean checkBomTypeEntryType(DynamicObject bomDO, String changeTypeParam) {
        boolean isSuccess = false;
        if (bomDO != null) {
            DynamicObject typeDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)bomDO, (String)"type");
            String purpose = MMCUtils.getDynamicObjectStringData((DynamicObject)typeDO, (String)"purpose");
            String configType = MMCUtils.getDynamicObjectStringData((DynamicObject)typeDO, (String)"configtype");
            if (!(!StringUtils.equals((CharSequence)"F", (CharSequence)changeTypeParam) && !StringUtils.equals((CharSequence)"G", (CharSequence)changeTypeParam) && !StringUtils.equals((CharSequence)"H", (CharSequence)changeTypeParam) || StringUtils.equals((CharSequence)"B", (CharSequence)purpose) && StringUtils.equals((CharSequence)"B", (CharSequence)configType))) {
                isSuccess = true;
            }
        }
        return isSuccess;
    }

    private List<DynamicObject> addFeatureEntry(Set<Map.Entry<Object, DynamicObject>> bomSet, DynamicObjectCollection changeEntrys, List<String> modifyFiledList, Date validateDate, String opKey) {
        ArrayList<DynamicObject> retBom = new ArrayList<DynamicObject>(100);
        for (Map.Entry<Object, DynamicObject> entry : bomSet) {
            DynamicObject bomObj = entry.getValue();
            if (changeEntrys.isEmpty()) continue;
            DynamicObject retEcoBom = this.createEcoBom(bomObj, changeEntrys, opKey, modifyFiledList);
            retBom.add(retEcoBom);
        }
        return retBom;
    }

    private DynamicObjectCollection bomHeadFeatureValidate(DynamicObjectCollection changeEntrys, DynamicObject bomObj, String opKey) {
        DynamicObjectCollection existBomEntry = new DynamicObjectCollection();
        DynamicObject matInfo = bomObj.getDynamicObject("material");
        long matInfoId = matInfo == null ? 0L : (Long)matInfo.getPkValue();
        for (DynamicObject changEntry : changeEntrys) {
            long changeEntryMatId;
            DynamicObject changeEntryMat = changEntry.getDynamicObject("entrymaterial");
            long l = changeEntryMatId = changeEntryMat == null ? 0L : (Long)changeEntryMat.getPkValue();
            if (changeEntryMatId == matInfoId) {
                DynamicObject mat = bomObj.getDynamicObject("material");
                String materialNumber = "";
                DynamicObject material = null;
                if (mat != null) {
                    material = mat.getDynamicObject("masterid");
                }
                if (material == null) continue;
                materialNumber = material.getString("number");
                continue;
            }
            existBomEntry.add((Object)changEntry);
        }
        return existBomEntry;
    }

    private List<DynamicObject> deleteEntry(Set<Map.Entry<Object, DynamicObject>> bomSet, DynamicObjectCollection changeEntrys, List<String> modifyFiledList, Date validateDate, String opKey) {
        ArrayList<DynamicObject> retBom = new ArrayList<DynamicObject>(100);
        for (Map.Entry<Object, DynamicObject> entry : bomSet) {
            DynamicObject bomObj = entry.getValue();
            DynamicObjectCollection bomEntryCol = bomObj.getDynamicObjectCollection("entry");
            if (bomEntryCol.isEmpty() || !this.isEntryExist(changeEntrys, bomObj, validateDate, opKey)) continue;
            DynamicObjectCollection existChangeEntrys = this.getBOMExistChangeEntrys(changeEntrys, bomEntryCol, opKey, validateDate);
            if (!existChangeEntrys.isEmpty()) {
                DynamicObject retEcoBom = this.createEcoBom(bomObj, existChangeEntrys, opKey, modifyFiledList);
                retBom.add(retEcoBom);
                continue;
            }
            String validateDateStr = this.formatData.format(validateDate);
            String msg = String.format(ResManager.loadKDString((String)"BOM\u201c%1$s\u201d\u5728\u751f\u6548\u65f6\u95f4\u201c%2$s\u201d\u70b9\uff0c\u4e0d\u5b58\u5728\u9700\u8981\u5931\u6548\u7684\u7ec4\u4ef6\u4fe1\u606f\u3002", (String)"BatchBomToECNBusiness_9", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), bomObj.getString("number"), validateDateStr);
            this.failedMap.put(Long.valueOf(bomObj.getPkValue().toString()), msg);
        }
        return retBom;
    }

    private boolean hasNewECNPermission() {
        RequestContext curUserID = RequestContext.getOrCreate();
        Long userId = curUserID.getCurrUserId();
        boolean hasPer = PermissionServiceHelper.hasNewPermission((long)userId, (String)"pdm", (String)"pdm_bom_eco");
        return hasPer;
    }

    private List<DynamicObject> addNewEntry(Set<Map.Entry<Object, DynamicObject>> bomSet, DynamicObjectCollection changeEntrys, List<String> modifyFiledList) {
        ArrayList<DynamicObject> retBom = new ArrayList<DynamicObject>(100);
        for (Map.Entry<Object, DynamicObject> entry : bomSet) {
            DynamicObject bomObj = entry.getValue();
            DynamicObjectCollection headValidateCol = this.bomHeadMatValidate(changeEntrys, bomObj, "A");
            DynamicObjectCollection existChangeEntrys = this.copEntryValidate(headValidateCol, bomObj, "A");
            if (existChangeEntrys.isEmpty()) continue;
            DynamicObject retEcoBom = this.createEcoBom(bomObj, existChangeEntrys, "A", modifyFiledList);
            retBom.add(retEcoBom);
        }
        return retBom;
    }

    private List<DynamicObject> modifyEntry(Set<Map.Entry<Object, DynamicObject>> bomSet, DynamicObjectCollection changeEntrys, List<String> modifyFiledList, Date validateDate) {
        ArrayList<DynamicObject> retBom = new ArrayList<DynamicObject>(100);
        for (Map.Entry<Object, DynamicObject> entry : bomSet) {
            DynamicObject bomObj = entry.getValue();
            DynamicObjectCollection bomEntryCol = bomObj.getDynamicObjectCollection("entry");
            if (bomEntryCol.isEmpty() || !this.isAllExist(changeEntrys, bomObj, validateDate, "B")) continue;
            DynamicObject bomType = bomObj.getDynamicObject("type");
            String purpose = bomType == null ? "" : bomType.getString("purpose");
            DynamicObjectCollection existChangeEntrys = this.getExistChangeEntrys(changeEntrys, bomEntryCol, "B", purpose, validateDate);
            if (!existChangeEntrys.isEmpty()) {
                DynamicObject retEcoBom = this.createEcoBom(bomObj, existChangeEntrys, "B", modifyFiledList);
                retBom.add(retEcoBom);
                continue;
            }
            String validateDateStr = this.formatData.format(validateDate);
            String msg = String.format(ResManager.loadKDString((String)"BOM\u201c%1$s\u201d\u5728\u751f\u6548\u65f6\u95f4\u201c%2$s\u201d\u70b9\uff0c\u4e0d\u5b58\u5728\u9700\u8981\u4fee\u6539\u7684\u7ec4\u4ef6\u4fe1\u606f\u3002", (String)"BatchBomToECNBusiness_10", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), bomObj.getString("number"), validateDateStr);
            this.failedMap.put(Long.valueOf(bomObj.getPkValue().toString()), msg);
        }
        return retBom;
    }

    private List<DynamicObject> replaceEntry(Set<Map.Entry<Object, DynamicObject>> bomSet, DynamicObjectCollection changeEntrys, List<String> modifyFiledList, Date validateDate) {
        ArrayList<DynamicObject> retBom = new ArrayList<DynamicObject>(100);
        for (Map.Entry<Object, DynamicObject> entry : bomSet) {
            DynamicObject bomObj = entry.getValue();
            DynamicObjectCollection bomEntryCol = bomObj.getDynamicObjectCollection("entry");
            if (bomEntryCol.isEmpty() || !this.isAllExist(changeEntrys, bomObj, validateDate, "C")) continue;
            DynamicObjectCollection validateChangeEntrys = this.bomHeadMatValidate(changeEntrys, bomObj, "C");
            DynamicObjectCollection validateCopEntryCol = this.copEntryValidate(validateChangeEntrys, bomObj, "C");
            DynamicObject bomType = bomObj.getDynamicObject("type");
            String purpose = bomType == null ? "" : bomType.getString("purpose");
            DynamicObjectCollection existChangeEntrys = this.getExistChangeEntrys(validateCopEntryCol, bomEntryCol, "C", purpose, validateDate);
            this.updateRowToEcnRow.clear();
            if (!existChangeEntrys.isEmpty()) {
                List mPropList = BatchBOMUtils.getModifyFieldList(modifyFiledList, (DynamicObject)bomObj);
                DynamicObject retEcoBom = this.createEcoBom(bomObj, existChangeEntrys, "C", mPropList);
                long bomPk = bomObj.getLong("id");
                if (this.replacePlanFlag && this.repeatBomEntryReplaceMap.containsKey(bomPk) && this.repeatBomEntryReplaceMap.get(bomPk).booleanValue()) continue;
                retBom.add(retEcoBom);
                continue;
            }
            String validateDateStr = this.formatData.format(validateDate);
            String msg = String.format(ResManager.loadKDString((String)"BOM\u201c%1$s\u201d\u5728\u751f\u6548\u65f6\u95f4\u201c%2$s\u201d\u70b9\uff0c\u4e0d\u5b58\u5728\u9700\u8981\u66ff\u4ee3\u7684\u7ec4\u4ef6\u4fe1\u606f\u3002", (String)"BatchBomToECNBusiness_11", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), bomObj.getString("number"), validateDateStr);
            String erroMsg = this.failedMap.get(Long.valueOf(bomObj.getPkValue().toString()));
            erroMsg = erroMsg != null ? erroMsg + "\n" + msg : msg;
            this.failedMap.put(Long.valueOf(bomObj.getPkValue().toString()), erroMsg);
        }
        return retBom;
    }

    private List<DynamicObject> invalidateMat(Set<Map.Entry<Object, DynamicObject>> bomSet, DynamicObjectCollection changeEntrys, List<String> modifyFiledList, Date validateDate) {
        ArrayList<DynamicObject> retBom = new ArrayList<DynamicObject>(100);
        for (Map.Entry<Object, DynamicObject> entry : bomSet) {
            DynamicObject bomObj = entry.getValue();
            DynamicObjectCollection bomEntryCol = bomObj.getDynamicObjectCollection("entry");
            if (bomEntryCol.isEmpty() || !this.isAllExist(changeEntrys, bomObj, validateDate, "D")) continue;
            DynamicObject bomType = bomObj.getDynamicObject("type");
            String purpose = bomType == null ? "" : bomType.getString("purpose");
            DynamicObjectCollection existChangeEntrys = this.getExistChangeEntrys(changeEntrys, bomEntryCol, "D", purpose, validateDate);
            if (!existChangeEntrys.isEmpty()) {
                DynamicObject retEcoBom = this.createEcoBom(bomObj, existChangeEntrys, "D", modifyFiledList);
                long bomPk = bomObj.getLong("id");
                if (this.repeatBomEntryReplaceMap.containsKey(bomPk) && this.repeatBomEntryReplaceMap.get(bomPk).booleanValue()) continue;
                retBom.add(retEcoBom);
                continue;
            }
            String validateDateStr = this.formatData.format(validateDate);
            String msg = String.format(ResManager.loadKDString((String)"BOM\u201c%1$s\u201d\u5728\u751f\u6548\u65f6\u95f4\u201c%2$s\u201d\u70b9\uff0c\u4e0d\u5b58\u5728\u9700\u8981\u5931\u6548\u7684\u7ec4\u4ef6\u4fe1\u606f\u3002", (String)"BatchBomToECNBusiness_9", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), bomObj.getString("number"), validateDateStr);
            this.failedMap.put(Long.valueOf(bomObj.getPkValue().toString()), msg);
        }
        return retBom;
    }

    private DynamicObjectCollection bomHeadMatValidate(DynamicObjectCollection changeEntrys, DynamicObject bomObj, String changeType) {
        DynamicObjectCollection existBomEntry = new DynamicObjectCollection();
        DynamicObject matInfo = bomObj.getDynamicObject("material");
        long matInfoId = matInfo == null ? 0L : (Long)matInfo.getPkValue();
        for (DynamicObject changEntry : changeEntrys) {
            long changeEntryMatId;
            DynamicObject changeEntryMat = changEntry.getDynamicObject("entrymaterial");
            if ("C".equals(changeType)) {
                changeEntryMat = changEntry.getDynamicObject("new_entrymaterial");
            }
            long l = changeEntryMatId = changeEntryMat == null ? 0L : (Long)changeEntryMat.getPkValue();
            if (changeEntryMatId == matInfoId) {
                DynamicObject mat = bomObj.getDynamicObject("material");
                String materialNumber = "";
                DynamicObject material = null;
                if (mat != null) {
                    material = mat.getDynamicObject("masterid");
                }
                if (material != null) {
                    materialNumber = material.getString("number");
                }
                String errorMsg = this.getMsgInfo(changeType);
                String msg = String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u4ef6\u7f16\u7801\u201c%2$s\u201d\u548cBOM\u201c%3$s\u201d\u7684\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u76f8\u540c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BatchBomToECNBusiness_8", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), errorMsg, materialNumber, bomObj.getString("number"));
                this.failedMap.put(Long.valueOf(bomObj.getPkValue().toString()), msg);
                continue;
            }
            existBomEntry.add((Object)changEntry);
        }
        return existBomEntry;
    }

    private String getMsgInfo(String changeType) {
        String msg = "";
        if ("C".equals(changeType)) {
            msg = ResManager.loadKDString((String)"\u65b0", (String)"BatchBomToECNBusiness_26", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
        }
        return msg;
    }

    private DynamicObjectCollection copEntryValidate(DynamicObjectCollection changeEntrys, DynamicObject bomObj, String changeType) {
        DynamicObjectCollection copBomEntry = new DynamicObjectCollection();
        DynamicObjectCollection copentryCol = bomObj.getDynamicObjectCollection("copentry");
        HashSet<String> existIdSet = new HashSet<String>(100);
        for (DynamicObject changEntry : changeEntrys) {
            boolean flag = false;
            DynamicObject changeEntryMat = changEntry.getDynamicObject("entrymaterial");
            DynamicObject changeEntryVer = changEntry.getDynamicObject("entryversion");
            DynamicObject changeEntryAux = changEntry.getDynamicObject("entryauxproperty");
            if ("C".equals(changeType)) {
                changeEntryMat = changEntry.getDynamicObject("new_entrymaterial");
                changeEntryVer = changEntry.getDynamicObject("new_entryversion");
                changeEntryAux = changEntry.getDynamicObject("new_entryauxproperty");
            }
            long changeEntryMatId = changeEntryMat == null ? 0L : (Long)changeEntryMat.getPkValue();
            long changeEntryVerId = changeEntryVer == null ? 0L : (Long)changeEntryVer.getPkValue();
            long changeEntryAuxId = changeEntryAux == null ? 0L : (Long)changeEntryAux.getPkValue();
            for (int i = 0; i < copentryCol.size(); ++i) {
                long entryAuxpty;
                DynamicObject copEntryBomEntry = (DynamicObject)copentryCol.get(i);
                DynamicObject entryMat = copEntryBomEntry.getDynamicObject("copentrymaterial");
                long entryMatId = entryMat == null ? 0L : (Long)entryMat.getPkValue();
                DynamicObject entryVer = copEntryBomEntry.getDynamicObject("copentryversion");
                long entryVerId = entryVer == null ? 0L : (Long)entryVer.getPkValue();
                DynamicObject entryAux = copEntryBomEntry.getDynamicObject("copentryauxproperty");
                long l = entryAuxpty = entryAux == null ? 0L : (Long)entryAux.getPkValue();
                if (entryMatId != changeEntryMatId || entryVerId != changeEntryVerId || entryAuxpty != changeEntryAuxId) continue;
                flag = true;
                DynamicObject mat = copEntryBomEntry.getDynamicObject("copentrymaterial");
                if (existIdSet.contains(mat.getPkValue().toString())) continue;
                existIdSet.add(mat.getPkValue().toString());
                String msg = String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u7f16\u7801\u6216\u65b0\u7ec4\u4ef6\u7f16\u7801\u201c%1$s\u201d\uff0c\u5df2\u5728BOM\u201c%2$s\u201d\u7684\u8054\u526f\u4ea7\u54c1\u4e2d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BatchBomToECNBusiness_12", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), this.getMaterialMFTInfoNumber(mat), entryMat == null ? "" : this.getMaterialMFTInfoNumber(entryMat));
                String errorMsg = this.failedMap.get(Long.valueOf(bomObj.getPkValue().toString()));
                errorMsg = errorMsg == null ? msg : errorMsg + "\n" + msg;
                this.failedMap.put(Long.valueOf(bomObj.getPkValue().toString()), errorMsg);
            }
            if (flag) continue;
            copBomEntry.add((Object)changEntry);
        }
        return copBomEntry;
    }

    private String getMaterialMFTInfoNumber(DynamicObject mat) {
        DynamicObject masterDO;
        String matNumber = "";
        if (mat != null && (masterDO = mat.getDynamicObject("masterid")) != null) {
            matNumber = masterDO.getString("number");
        }
        return matNumber;
    }

    private boolean isAllExist(DynamicObjectCollection changeEntrys, DynamicObject bomObj, Date validateDate, String changeType) {
        boolean retFlag = true;
        DynamicObjectCollection bomEntryCol = bomObj.getDynamicObjectCollection("entry");
        for (DynamicObject changEntry : changeEntrys) {
            String matNum;
            long changeEntryMatId;
            boolean flag = false;
            DynamicObject changeEntryMat = changEntry.getDynamicObject("entrymaterial");
            if (changeEntryMat == null) {
                DynamicObject changeMaterialid = changEntry.getDynamicObject("entrymaterialid");
                changeEntryMatId = changeMaterialid == null ? 0L : (Long)changeMaterialid.getPkValue();
                matNum = changeMaterialid == null ? "" : changeMaterialid.getString("number");
            } else {
                changeEntryMatId = changeEntryMat == null ? 0L : (Long)changeEntryMat.getPkValue();
                matNum = changeEntryMat == null ? "" : changeEntryMat.getDynamicObject("masterid").getString("number");
            }
            DynamicObject changeEntryVer = changEntry.getDynamicObject("entryversion");
            long changeEntryVerId = changeEntryVer == null ? 0L : (Long)changeEntryVer.getPkValue();
            DynamicObject changeEntryAux = changEntry.getDynamicObject("entryauxproperty");
            long changeEntryAuxId = changeEntryAux == null ? 0L : (Long)changeEntryAux.getPkValue();
            DynamicObject changeEntryConigCode = changEntry.getDynamicObject("entryconfiguredcode");
            long changeEntryConigCodetId = changeEntryConigCode == null ? 0L : (Long)changeEntryConigCode.getPkValue();
            for (int i = 0; i < bomEntryCol.size(); ++i) {
                DynamicObject changeMaterialid;
                DynamicObject selectedBomEntry = (DynamicObject)bomEntryCol.get(i);
                DynamicObject entryMat = selectedBomEntry.getDynamicObject("entrymaterial");
                long entryMatId = changeEntryMat == null ? ((changeMaterialid = changEntry.getDynamicObject("entrymaterialid")) == null ? 0L : (Long)changeMaterialid.getPkValue()) : (entryMat == null ? 0L : (Long)entryMat.getPkValue());
                DynamicObject entryVer = selectedBomEntry.getDynamicObject("entryversion");
                long entryVerId = entryVer == null ? 0L : (Long)entryVer.getPkValue();
                DynamicObject entryAux = selectedBomEntry.getDynamicObject("entryauxproperty");
                long entryAuxpty = entryAux == null ? 0L : (Long)entryAux.getPkValue();
                DynamicObject entryConfigCode = selectedBomEntry.getDynamicObject("entryconfiguredcode");
                long entryconfigcodeId = entryConfigCode == null ? 0L : (Long)entryConfigCode.getPkValue();
                Date startDate = selectedBomEntry.getDate("entryvaliddate");
                Date endDate = selectedBomEntry.getDate("entryinvaliddate");
                if (validateDate != null && (startDate.after(validateDate) || endDate.before(validateDate)) || entryMatId != changeEntryMatId || entryVerId != changeEntryVerId || entryAuxpty != changeEntryAuxId || entryconfigcodeId != changeEntryConigCodetId) continue;
                flag = true;
                boolean entryIsReplace = selectedBomEntry.getBoolean("entryisreplace");
                if (!"C".equals(changeType) && !"D".equals(changeType) || !entryIsReplace) continue;
                int seq = changEntry.getInt("seq");
                String changeTypeStr = this.getMsgEntryAbsent(changeType);
                String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s[%3$s]\u5728BOM\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"BatchBomToECNBusiness_25", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), seq, changeTypeStr, matNum);
                this.failedMap.put(Long.valueOf(bomObj.getPkValue().toString()), msg);
                retFlag = false;
                break;
            }
            if (flag) continue;
            String validateDateStr = this.formatData.format(validateDate);
            String msg = String.format(ResManager.loadKDString((String)"BOM\u201c%1$s\u201d\u5728\u751f\u6548\u65f6\u95f4\u201c%2$s\u201d\u70b9\uff0c\u4e0d\u5b58\u5728\u9700\u8981\u66ff\u4ee3\u7684\u7ec4\u4ef6\u201c%3$s\u201d\uff0c\u8bf7\u68c0\u67e5\u8f85\u52a9\u5c5e\u6027\u3001\u7248\u672c\u3001\u914d\u7f6e\u53f7\u662f\u5426\u4e00\u81f4\u3002", (String)"BatchBomToECNBusiness_13", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), bomObj.getString("number"), validateDateStr, matNum);
            String erroMsg = this.failedMap.get(Long.valueOf(bomObj.getPkValue().toString()));
            erroMsg = erroMsg != null ? erroMsg + "\n" + msg : msg;
            this.failedMap.put(Long.valueOf(bomObj.getPkValue().toString()), erroMsg);
            retFlag = false;
        }
        return retFlag;
    }

    private String getMsgEntryAbsent(String changeType) {
        String opTypeMsg = new CheckBOMUtils().getOpTypeMsg(changeType);
        if ("C".equals(changeType)) {
            opTypeMsg = String.format(ResManager.loadKDString((String)"\u88ab%1$s", (String)"BatchBomToECNBusiness_24", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), opTypeMsg);
        }
        return opTypeMsg;
    }

    private boolean isEntryExist(DynamicObjectCollection changeEntrys, DynamicObject bomObj, Date validateDate, String opKey) {
        boolean retFlag = true;
        String matOrFeature = this.getUniqueField(opKey);
        DynamicObjectCollection bomEntryCol = bomObj.getDynamicObjectCollection("entry");
        for (DynamicObject changEntry : changeEntrys) {
            boolean flag = false;
            DynamicObject matOrFeatureDO = changEntry.getDynamicObject(matOrFeature);
            String matNum = matOrFeatureDO == null ? "" : matOrFeatureDO.getString("number");
            Long changeEntryMatId = matOrFeatureDO != null ? matOrFeatureDO.getLong("id") : 0L;
            DynamicObject changeEntryVer = changEntry.getDynamicObject("entryversion");
            long changeEntryVerId = changeEntryVer == null ? 0L : (Long)changeEntryVer.getPkValue();
            DynamicObject changeEntryAux = changEntry.getDynamicObject("entryauxproperty");
            long changeEntryAuxId = changeEntryAux == null ? 0L : (Long)changeEntryAux.getPkValue();
            DynamicObject changeEntryConigCode = changEntry.getDynamicObject("entryconfiguredcode");
            long changeEntryConigCodetId = changeEntryConigCode == null ? 0L : (Long)changeEntryConigCode.getPkValue();
            for (int i = 0; i < bomEntryCol.size(); ++i) {
                long entryconfigcodeId;
                long entryMatId;
                DynamicObject selectedBomEntry = (DynamicObject)bomEntryCol.get(i);
                DynamicObject entryMat = selectedBomEntry.getDynamicObject(matOrFeature);
                long l = entryMatId = entryMat == null ? 0L : (Long)entryMat.getPkValue();
                if ("F".equals(opKey) || "G".equals(opKey) || "H".equals(opKey)) {
                    if (!"G".equals(opKey)) {
                        Date startDate = selectedBomEntry.getDate("entryvaliddate");
                        Date endDate = selectedBomEntry.getDate("entryinvaliddate");
                        if (validateDate != null && (startDate.after(validateDate) || endDate.before(validateDate))) continue;
                    }
                    if (!changeEntryMatId.equals(entryMatId)) continue;
                    flag = true;
                    continue;
                }
                DynamicObject entryVer = selectedBomEntry.getDynamicObject("entryversion");
                long entryVerId = entryVer == null ? 0L : (Long)entryVer.getPkValue();
                DynamicObject entryAux = selectedBomEntry.getDynamicObject("entryauxproperty");
                long entryAuxpty = entryAux == null ? 0L : (Long)entryAux.getPkValue();
                DynamicObject entryConfigCode = selectedBomEntry.getDynamicObject("entryconfiguredcode");
                long l2 = entryconfigcodeId = entryConfigCode == null ? 0L : (Long)entryConfigCode.getPkValue();
                if (!"E".equals(opKey)) {
                    Date startDate = selectedBomEntry.getDate("entryvaliddate");
                    Date endDate = selectedBomEntry.getDate("entryinvaliddate");
                    if (validateDate != null && (startDate.after(validateDate) || endDate.before(validateDate))) continue;
                }
                if (entryMatId != changeEntryMatId || entryVerId != changeEntryVerId || entryAuxpty != changeEntryAuxId || entryconfigcodeId != changeEntryConigCodetId) continue;
                flag = true;
            }
            if (flag) continue;
            String validateDateStr = this.formatData.format(validateDate);
            String msg = String.format(ResManager.loadKDString((String)"BOM\u201c%1$s\u201d\u5728\u751f\u6548\u65f6\u95f4\u201c%2$s\u201d\u70b9\uff0c\u4e0d\u5b58\u5728\u9700\u8981\u66ff\u4ee3\u7684\u7ec4\u4ef6\u201c%3$s\u201d\uff0c\u8bf7\u68c0\u67e5\u8f85\u52a9\u5c5e\u6027\u3001\u7248\u672c\u3001\u914d\u7f6e\u53f7\u662f\u5426\u4e00\u81f4\u3002", (String)"BatchBomToECNBusiness_13", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), bomObj.getString("number"), validateDateStr, matNum);
            String erroMsg = this.failedMap.get(Long.valueOf(bomObj.getPkValue().toString()));
            erroMsg = erroMsg != null ? erroMsg + "\n" + msg : msg;
            this.failedMap.put(Long.valueOf(bomObj.getPkValue().toString()), erroMsg);
            retFlag = false;
        }
        return retFlag;
    }

    private String getUniqueField(String opKey) {
        String uniqueField = "";
        uniqueField = "F".equals(opKey) || "G".equals(opKey) || "H".equals(opKey) ? "featuretype" : "entrymaterialid";
        return uniqueField;
    }

    private DynamicObjectCollection getExistChangeEntrys(DynamicObjectCollection changeEntrys, DynamicObjectCollection bomEntryCol, String changeType, String purpose, Date validateDate) {
        DynamicObjectCollection existBomEntry = new DynamicObjectCollection();
        for (int i = 0; i < bomEntryCol.size(); ++i) {
            long entryMatId;
            DynamicObject selectedBomEntry = (DynamicObject)bomEntryCol.get(i);
            DynamicObject featureType = selectedBomEntry.getDynamicObject("featuretype");
            if (featureType != null) continue;
            if ("B".equals(purpose)) {
                DynamicObject entryMaterialID = selectedBomEntry.getDynamicObject("entrymaterialid");
                entryMatId = entryMaterialID == null ? 0L : entryMaterialID.getLong("id");
            } else {
                DynamicObject entryMat = selectedBomEntry.getDynamicObject("entrymaterial");
                DynamicObject masterID = entryMat == null ? null : entryMat.getDynamicObject("masterid");
                entryMatId = masterID == null ? 0L : masterID.getLong("id");
            }
            DynamicObject entryVer = selectedBomEntry.getDynamicObject("entryversion");
            long entryVerId = entryVer == null ? 0L : (Long)entryVer.getPkValue();
            DynamicObject entryAux = selectedBomEntry.getDynamicObject("entryauxproperty");
            long entryAuxpty = entryAux == null ? 0L : (Long)entryAux.getPkValue();
            DynamicObject entryConfigCode = selectedBomEntry.getDynamicObject("entryconfiguredcode");
            long entryconfigcodeId = entryConfigCode == null ? 0L : (Long)entryConfigCode.getPkValue();
            Date startDate = selectedBomEntry.getDate("entryvaliddate");
            Date endDate = selectedBomEntry.getDate("entryinvaliddate");
            if (validateDate != null && (startDate.after(validateDate) || endDate.before(validateDate))) continue;
            for (DynamicObject changEntry : changeEntrys) {
                long changeEntryConigCodetId;
                long changeEntryMatId;
                if ("B".equals(purpose)) {
                    DynamicObject changeMaterialID = changEntry.getDynamicObject("entrymaterialid");
                    changeEntryMatId = changeMaterialID == null ? 0L : changeMaterialID.getLong("id");
                } else {
                    DynamicObject changeEntryMat = changEntry.getDynamicObject("entrymaterial");
                    DynamicObject masterID = changeEntryMat == null ? null : changeEntryMat.getDynamicObject("masterid");
                    changeEntryMatId = masterID == null ? 0L : masterID.getLong("id");
                }
                DynamicObject changeEntryVer = changEntry.getDynamicObject("entryversion");
                long changeEntryVerId = changeEntryVer == null ? 0L : (Long)changeEntryVer.getPkValue();
                DynamicObject changeEntryAux = changEntry.getDynamicObject("entryauxproperty");
                long changeEntryAuxId = changeEntryAux == null ? 0L : (Long)changeEntryAux.getPkValue();
                DynamicObject changeEntryConigCode = changEntry.getDynamicObject("entryconfiguredcode");
                long l = changeEntryConigCodetId = changeEntryConigCode == null ? 0L : (Long)changeEntryConigCode.getPkValue();
                if (entryMatId != changeEntryMatId || entryVerId != changeEntryVerId || entryAuxpty != changeEntryAuxId || entryconfigcodeId != changeEntryConigCodetId) continue;
                DynamicObject newChangEntry = this.DynamicObjectCopy(changEntry);
                newChangEntry.set("id", (Object)Long.parseLong(selectedBomEntry.getPkValue().toString()));
                existBomEntry.add((Object)newChangEntry);
            }
        }
        return existBomEntry;
    }

    private DynamicObjectCollection getBOMExistChangeEntrys(DynamicObjectCollection changeEntrys, DynamicObjectCollection bomEntryCol, String opKey, Date validateDate) {
        String matOrFeature = this.getUniqueField(opKey);
        DynamicObjectCollection existBomEntry = new DynamicObjectCollection();
        for (int i = 0; i < bomEntryCol.size(); ++i) {
            long entryconfigcodeId;
            DynamicObject selectedBomEntry = (DynamicObject)bomEntryCol.get(i);
            DynamicObject entryMat = selectedBomEntry.getDynamicObject(matOrFeature);
            long entryMatId = entryMat == null ? 0L : (Long)entryMat.getPkValue();
            DynamicObject entryVer = selectedBomEntry.getDynamicObject("entryversion");
            long entryVerId = entryVer == null ? 0L : (Long)entryVer.getPkValue();
            DynamicObject entryAux = selectedBomEntry.getDynamicObject("entryauxproperty");
            long entryAuxpty = entryAux == null ? 0L : (Long)entryAux.getPkValue();
            DynamicObject entryConfigCode = selectedBomEntry.getDynamicObject("entryconfiguredcode");
            long l = entryconfigcodeId = entryConfigCode == null ? 0L : (Long)entryConfigCode.getPkValue();
            if (!"E".equals(opKey) && !"G".equals(opKey)) {
                Date startDate = selectedBomEntry.getDate("entryvaliddate");
                Date endDate = selectedBomEntry.getDate("entryinvaliddate");
                if (validateDate != null && (startDate.after(validateDate) || endDate.before(validateDate))) continue;
            }
            for (DynamicObject changEntry : changeEntrys) {
                long changeEntryConigCodetId;
                long changeEntryMatId;
                DynamicObject changeEntryMat = changEntry.getDynamicObject(matOrFeature);
                long l2 = changeEntryMatId = changeEntryMat == null ? 0L : (Long)changeEntryMat.getPkValue();
                if ("F".equals(opKey) || "G".equals(opKey) || "H".equals(opKey)) {
                    if (changeEntryMatId != entryMatId) continue;
                    DynamicObject newChangEntry = this.DynamicObjectCopy(changEntry);
                    newChangEntry.set("id", (Object)Long.parseLong(selectedBomEntry.getPkValue().toString()));
                    existBomEntry.add((Object)newChangEntry);
                    continue;
                }
                DynamicObject changeEntryVer = changEntry.getDynamicObject("entryversion");
                long changeEntryVerId = changeEntryVer == null ? 0L : (Long)changeEntryVer.getPkValue();
                DynamicObject changeEntryAux = changEntry.getDynamicObject("entryauxproperty");
                long changeEntryAuxId = changeEntryAux == null ? 0L : (Long)changeEntryAux.getPkValue();
                DynamicObject changeEntryConigCode = changEntry.getDynamicObject("entryconfiguredcode");
                long l3 = changeEntryConigCodetId = changeEntryConigCode == null ? 0L : (Long)changeEntryConigCode.getPkValue();
                if (entryMatId != changeEntryMatId || entryVerId != changeEntryVerId || entryAuxpty != changeEntryAuxId || entryconfigcodeId != changeEntryConigCodetId) continue;
                DynamicObject newChangEntry = this.DynamicObjectCopy(changEntry);
                newChangEntry.set("id", (Object)Long.parseLong(selectedBomEntry.getPkValue().toString()));
                existBomEntry.add((Object)newChangEntry);
            }
        }
        return existBomEntry;
    }

    private DynamicObject DynamicObjectCopy(DynamicObject changEntry) {
        DynamicObject newChangEntry = new DynamicObject(changEntry.getDynamicObjectType());
        DataEntityPropertyCollection oldProperties = newChangEntry.getDataEntityType().getProperties();
        for (IDataEntityProperty property : oldProperties) {
            newChangEntry.set(property.getName(), changEntry.get(property.getName()));
        }
        return newChangEntry;
    }

    private DynamicObject createEcoHeadInfo(Map<String, Object> param, Date validateDate) {
        String changeOrgId = String.valueOf(param.get("changeOrg"));
        DynamicObject ecoObj = BusinessDataServiceHelper.newDynamicObject((String)"pdm_bom_eco");
        Long orgId = Long.valueOf(changeOrgId);
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org", (String)"id,number");
        ecoObj.set("org", (Object)org);
        ecoObj.set("org_id", (Object)orgId);
        ecoObj.set("changetype", (Object)"A");
        ecoObj.set("type", param.get("typeObj"));
        ecoObj.set("type_id", (Object)Long.valueOf(param.get("typePK").toString()));
        ecoObj.set("billstatus", (Object)"A");
        ecoObj.set("enable", (Object)"0");
        ecoObj.set("ctrlstrategy", (Object)"5");
        RequestContext curUserID = RequestContext.getOrCreate();
        Long userId = curUserID.getCurrUserId();
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)userId, (String)"bos_user");
        ecoObj.set("creator", (Object)user);
        this.createProductInfo(param, ecoObj, validateDate, orgId);
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)ecoObj.getDataEntityType().getName(), (DynamicObject)ecoObj, (String)changeOrgId);
        ecoObj.set("name", (Object)"");
        return ecoObj;
    }

    private void createProductInfo(Map<String, Object> param, DynamicObject ecoObj, Date validateDate, Long orgId) {
        String verionCtrl = String.valueOf(param.get("version"));
        DynamicObjectCollection proEntryCol = ecoObj.getDynamicObjectCollection("pentry");
        DataEntityPropertyCollection proEntryProps = proEntryCol.getDynamicObjectType().getProperties();
        Set<Map.Entry<Long, DynamicObject>> bomSet = this.proBomMap.entrySet();
        DynamicObject defEcoType = EcoUtils.getDefaultEcoType((Long)orgId);
        for (Map.Entry<Long, DynamicObject> entry : bomSet) {
            DynamicObject proEntryObj = proEntryCol.addNew();
            long ecobomid = entry.getKey();
            DynamicObject bomObj = entry.getValue();
            proEntryObj.set("pentrybom", (Object)bomObj);
            proEntryObj.set("proentrymaterial", bomObj.get("material"));
            proEntryObj.set("proentrymaterialid", bomObj.get("materialid"));
            proEntryObj.set("bomauxproperty", bomObj.get("auxproperty"));
            proEntryObj.set("entryversioncontrol", (Object)verionCtrl);
            proEntryObj.set("pentryoldversion", bomObj.get("version"));
            proEntryObj.set("pentryexecmode", (Object)"A");
            proEntryObj.set("pentryvaliddate", (Object)validateDate);
            proEntryObj.set("ecobomid", (Object)ecobomid);
            proEntryObj.set("ecobomid2", (Object)ecobomid);
            proEntryObj.set("ecotype", (Object)defEcoType);
            proEntryObj.set("bomtype", ecoObj.get("type"));
        }
    }

    private String getEcoTypeField() {
        StringBuilder ecoTypeField = new StringBuilder();
        ecoTypeField.append("id");
        ecoTypeField.append(",number");
        ecoTypeField.append(",name");
        ecoTypeField.append(",adjustacttime");
        ecoTypeField.append(",useorg");
        return ecoTypeField.toString();
    }

    private DynamicObject createEcoBom(DynamicObject bomObj, DynamicObjectCollection changeEntrys, String changeType, List<String> modifyFiledList) {
        DynamicObject ecoBomObj = BusinessDataServiceHelper.newDynamicObject((String)"pdm_ecobom");
        long pkId = ID.genLongId();
        DataEntityPropertyCollection targetHeadProperties = ecoBomObj.getDataEntityType().getProperties();
        DataEntityPropertyCollection bomProperties = bomObj.getDataEntityType().getProperties();
        for (IDataEntityProperty targetHeadProperty : targetHeadProperties) {
            if (!bomProperties.containsKey((Object)targetHeadProperty.getName()) || "entry".equals(targetHeadProperty.getName()) || "copentry".equals(targetHeadProperty.getName())) continue;
            if ("multilanguagetext".equals(targetHeadProperty.getName())) {
                DynamicObjectCollection newLocCol = this.setLocaleString(bomObj, targetHeadProperty.getName());
                ecoBomObj.set(targetHeadProperty.getName(), (Object)newLocCol);
                continue;
            }
            ecoBomObj.set(targetHeadProperty.getName(), bomObj.get(targetHeadProperty.getName()));
        }
        ecoBomObj.set("id", (Object)pkId);
        ecoBomObj.set("status", (Object)"A");
        ecoBomObj.set("bomid", bomObj.getPkValue());
        DynamicObjectCollection ecoBomEntryCol = this.createEcoBomEntry(bomObj, changeEntrys, ecoBomObj, changeType, modifyFiledList);
        ecoBomObj.set("entry", (Object)ecoBomEntryCol);
        long bomPk = bomObj.getLong("id");
        if ((!"D".equals(changeType) || !this.repeatBomEntryReplaceMap.containsKey(bomPk) || !this.repeatBomEntryReplaceMap.get(bomPk).booleanValue() || "C".equals(changeType) && this.replacePlanFlag && this.repeatBomEntryReplaceMap.containsKey(bomPk) && this.repeatBomEntryReplaceMap.get(bomPk).booleanValue()) && !this.proBomMap.values().contains(bomObj)) {
            this.proBomMap.put(pkId, bomObj);
        }
        return ecoBomObj;
    }

    private DynamicObjectCollection createEcoBomEntry(DynamicObject bomObj, DynamicObjectCollection changeEntrys, DynamicObject ecoBomObj, String changeType, List<String> mPropList) {
        DynamicObjectCollection bomEntryCol = bomObj.getDynamicObjectCollection("entry");
        DynamicObjectCollection ecoBomEntryCol = ecoBomObj.getDynamicObjectCollection("entry");
        ecoBomEntryCol.clear();
        int seq = 1;
        boolean isRepeat = false;
        DynamicObjectCollection copyChangEntry = null;
        if ("C".equals(changeType) || "D".equals(changeType)) {
            copyChangEntry = (DynamicObjectCollection)changeEntrys.clone();
        }
        for (DynamicObject changeEntryObj : changeEntrys) {
            DynamicObject afterObj;
            if ("B".equals(changeType)) {
                DynamicObject beforeObj = this.createBeforeEcoBomEntry(changeEntryObj, bomEntryCol, ecoBomEntryCol, changeType);
                if (beforeObj != null) {
                    beforeObj.set("seq", (Object)seq);
                }
                ++seq;
                afterObj = this.createAfterEcoBomEntry(changeEntryObj, bomEntryCol, ecoBomEntryCol, changeType, mPropList);
                if (afterObj != null) {
                    afterObj.set("seq", (Object)seq);
                }
                ++seq;
                continue;
            }
            if ("C".equals(changeType)) {
                long bomEntryPk = changeEntryObj.getLong("id");
                if (this.updateRowToEcnRow.containsKey(bomEntryPk)) {
                    DynamicObject lastChangeEcnRow = this.updateRowToEcnRow.get(bomEntryPk);
                    this.updateEcnNewEntryFromChangeEntry(changeEntryObj, lastChangeEcnRow, changeType, mPropList);
                    continue;
                }
                DynamicObject beforeObj = this.createBeforeEcoBomEntry(changeEntryObj, bomEntryCol, ecoBomEntryCol, "D");
                String beforeReplaceGroup = "";
                if (beforeObj != null) {
                    beforeObj.set("seq", (Object)seq);
                    beforeReplaceGroup = beforeObj.getString("entryreplacegroup");
                }
                ++seq;
                DynamicObject newObj = this.createNewEcoBomEntry(ecoBomEntryCol, changeEntryObj, "A", true, bomEntryCol, mPropList);
                if (newObj != null) {
                    newObj.set("seq", (Object)seq);
                    if (this.replacePlanFlag && StringUtils.isNotEmpty((CharSequence)beforeReplaceGroup)) {
                        newObj.set("entryreplacegroup", (Object)beforeReplaceGroup);
                        isRepeat = new CheckBOMUtils().checkBomReplaceEntryNewEntry(bomObj, bomEntryCol, newObj, beforeReplaceGroup, this.failedMap);
                        this.createExpirBeforeEcoBomEntry(bomObj.getString("number"), beforeReplaceGroup, bomEntryCol, ecoBomEntryCol, changeEntryObj, seq, copyChangEntry, changeType, newObj, mPropList);
                        seq = ecoBomEntryCol.size();
                    } else if (!this.replacePlanFlag && StringUtils.isNotEmpty((CharSequence)beforeReplaceGroup)) {
                        this.clearReplaceGroupInfo(newObj);
                        if (copyChangEntry != null) {
                            copyChangEntry.remove((Object)changeEntryObj);
                        }
                        this.createExpirBeforeEcoBomEntry(bomObj.getString("number"), beforeReplaceGroup, bomEntryCol, ecoBomEntryCol, changeEntryObj, seq, copyChangEntry, changeType, newObj, mPropList);
                        seq = ecoBomEntryCol.size();
                    }
                }
                if (isRepeat) {
                    this.repeatBomEntryReplaceMap.put(bomObj.getLong("id"), isRepeat);
                }
                ++seq;
                continue;
            }
            if ("D".equals(changeType)) {
                DynamicObject beforeObj = this.createBeforeEcoBomEntry(changeEntryObj, bomEntryCol, ecoBomEntryCol, "D");
                if (beforeObj != null) {
                    beforeObj.set("seq", (Object)seq);
                    String beforeReplaceGroup = beforeObj.getString("entryreplacegroup");
                    if (StringUtils.isNotBlank((CharSequence)beforeReplaceGroup)) {
                        ++seq;
                        if (copyChangEntry != null) {
                            copyChangEntry.remove((Object)changeEntryObj);
                        }
                        isRepeat = this.createExpirBeforeEcoBomEntry(bomObj.getString("number"), beforeReplaceGroup, bomEntryCol, ecoBomEntryCol, changeEntryObj, seq, copyChangEntry, changeType);
                    }
                }
                if (isRepeat) {
                    this.addInvalideErrorMessage(bomObj.getLong("id"), changeEntryObj);
                    this.repeatBomEntryReplaceMap.put(bomObj.getLong("id"), isRepeat);
                }
                ++seq;
                continue;
            }
            if ("E".equals(changeType) || "G".equals(changeType)) continue;
            if ("H".equals(changeType)) {
                DynamicObject beforeObj = this.createBeforeEcoBomEntry(changeEntryObj, bomEntryCol, ecoBomEntryCol, changeType);
                if (beforeObj != null) {
                    beforeObj.set("seq", (Object)seq);
                }
                ++seq;
                afterObj = this.createAfterEcoBomEntry(changeEntryObj, bomEntryCol, ecoBomEntryCol, changeType, mPropList);
                if (afterObj == null) continue;
                afterObj.set("seq", (Object)seq);
                continue;
            }
            DynamicObject newObj = this.createNewEcoBomEntry(ecoBomEntryCol, changeEntryObj, changeType, false, bomEntryCol, mPropList);
            newObj.set("seq", (Object)seq);
            ++seq;
        }
        return ecoBomEntryCol;
    }

    private void clearReplaceGroupInfo(DynamicObject newObj) {
        newObj.set("entryreplacegroup", (Object)"");
        newObj.set("entryreplaceplan", null);
        newObj.set("entryisreplaceplanmm", (Object)false);
    }

    private void addInvalideErrorMessage(long bomPk, DynamicObject invalidEntryObj) {
        Date invalidityDate = BatchBOMUtils.getInvalidityDateFromChangeEntry((DynamicObject)invalidEntryObj);
        String invalidMatNumber = invalidEntryObj.getDynamicObject("entrymaterialid").getString("number");
        String invalidDateStr = this.formatData.format(invalidityDate);
        String errorMsg = String.format(ResManager.loadKDString((String)"\u5931\u6548\u5931\u8d25\uff0c\u5931\u6548\u7ec4\u4ef6[%1$s]\u8fdb\u884c\u4e86\u66ff\u4ee3\uff0c\u5931\u6548\u65f6\u95f4[%2$s]\u4e0d\u5728\u4e3b\u6599\u6216\u8005\u66ff\u4ee3\u6599\u7684\u751f\u5931\u6548\u65f6\u95f4\u8303\u56f4\u4e4b\u5185\uff0c\u8bf7\u68c0\u67e5\u4e3b\u6599\u548c\u66ff\u4ee3\u6599\u7684\u751f\u5931\u6548\u65f6\u95f4\u3002", (String)"BatchBomToECNBusiness_23", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), invalidMatNumber, invalidDateStr);
        this.failedMap.put(bomPk, errorMsg);
    }

    private boolean createExpirBeforeEcoBomEntry(String bomNumber, String beforeReplaceGroup, DynamicObjectCollection bomEntryCol, DynamicObjectCollection ecoBomEntryCol, DynamicObject changeEntryObj, int preSeq, DynamicObjectCollection copyChangEntry, String changeType) {
        return this.createExpirBeforeEcoBomEntry(bomNumber, beforeReplaceGroup, bomEntryCol, ecoBomEntryCol, changeEntryObj, preSeq, copyChangEntry, changeType, null, new ArrayList<String>());
    }

    private boolean createExpirBeforeEcoBomEntry(String bomNumber, String beforeReplaceGroup, DynamicObjectCollection bomEntryCol, DynamicObjectCollection ecoBomEntryCol, DynamicObject changeEntryObj, int preSeq, DynamicObjectCollection copyChangEntry, String changeType, DynamicObject newObject, List<String> mPropList) {
        boolean expireFail = false;
        int seq = preSeq;
        ArrayList<DynamicObject> ecoBomEntrys = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> rmBomEntrys = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> ecoBomNewEntrys = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> ecoMasterReplaceEntrys = new ArrayList<DynamicObject>(8);
        Date entryvaliddate = changeEntryObj.getDate("entryvaliddate");
        for (DynamicObject bomEntry : bomEntryCol) {
            String bomEntryReplaceGroup = bomEntry.getString("entryreplacegroup");
            if (StringUtils.isBlank((CharSequence)bomEntryReplaceGroup) || !StringUtils.equals((CharSequence)bomEntryReplaceGroup, (CharSequence)beforeReplaceGroup)) continue;
            boolean entryIsReplace = bomEntry.getBoolean("entryisreplace");
            if (entryIsReplace) {
                if ("D".equals(changeType) && !this.checkReplaceInvalideDate(bomEntry, changeEntryObj)) {
                    expireFail = true;
                    break;
                }
                ecoBomEntrys.add(this.createEcoBomExpirEntry(bomEntry, ecoBomEntryCol, entryvaliddate, seq, "E"));
                if (this.replacePlanFlag && "C".equals(changeType)) {
                    ecoBomNewEntrys.add(bomEntry);
                }
                rmBomEntrys.add(bomEntry);
            } else {
                boolean updateEntry = this.checkBomEntryExistChangeEntry(copyChangEntry, bomEntry, changeEntryObj);
                if ("C".equals(changeType) && !updateEntry) {
                    ecoBomEntrys.add(this.createEcoBomExpirEntry(bomEntry, ecoBomEntryCol, entryvaliddate, seq, "E"));
                    if (this.replacePlanFlag && "C".equals(changeType)) {
                        ecoBomNewEntrys.add(bomEntry);
                    } else {
                        DynamicObject ecoBomAfterEntryObj = this.createEcoBomExpirEntry(bomEntry, ecoBomEntryCol, entryvaliddate, seq, "A");
                        boolean entryisreplace = bomEntry.getBoolean("entryisreplace");
                        if (!entryisreplace) {
                            this.updateRowToEcnRow.put(bomEntry.getLong("id"), ecoBomAfterEntryObj);
                        }
                        if (ecoBomAfterEntryObj.getDynamicObjectType().getProperties().containsKey((Object)"acttime")) {
                            ecoBomAfterEntryObj.set("entryvaliddate", ecoBomAfterEntryObj.get("acttime"));
                        }
                        this.clearReplaceGroupInfo(ecoBomAfterEntryObj);
                        ecoMasterReplaceEntrys.add(ecoBomAfterEntryObj);
                    }
                    rmBomEntrys.add(bomEntry);
                } else if ("D".equals(changeType) && !updateEntry) {
                    if ("D".equals(changeType) && !this.checkReplaceInvalideDate(bomEntry, changeEntryObj)) {
                        expireFail = true;
                        break;
                    }
                    ecoBomEntrys.add(this.createEcoBomExpirEntry(bomEntry, ecoBomEntryCol, entryvaliddate, seq, "E"));
                    rmBomEntrys.add(bomEntry);
                }
            }
            ++seq;
        }
        if (!rmBomEntrys.isEmpty()) {
            bomEntryCol.removeAll(rmBomEntrys);
        }
        if (newObject != null) {
            seq = ecoBomEntryCol.size();
            newObject.set("seq", (Object)seq);
        }
        AtomicInteger rowIndex = new AtomicInteger(seq + 1);
        if (!ecoMasterReplaceEntrys.isEmpty()) {
            ecoMasterReplaceEntrys.stream().forEach(entry -> entry.set("seq", (Object)rowIndex.incrementAndGet()));
        }
        if (!ecoBomNewEntrys.isEmpty()) {
            String replaceGroupNo = BatchBomToECNBusiness.genReplaceGroupNo(seq);
            if (newObject != null) {
                newObject.set("entryreplacegroup", (Object)replaceGroupNo);
            }
            for (int i = 0; i < ecoBomNewEntrys.size(); ++i) {
                DynamicObject ecnBomEntry = (DynamicObject)ecoBomNewEntrys.get(i);
                boolean entryisreplace = ecnBomEntry.getBoolean("entryisreplace");
                DynamicObject ecoBomEntryObj = this.createEcoBomExpirEntry(ecnBomEntry, ecoBomEntryCol, entryvaliddate, rowIndex.get() + (i + 1), "A");
                ecoBomEntryObj.set("entryreplacegroup", (Object)replaceGroupNo);
                if (entryisreplace) continue;
                this.updateRowToEcnRow.put(ecnBomEntry.getLong("id"), ecoBomEntryObj);
            }
        }
        if (!ecoBomEntrys.isEmpty()) {
            List bomEcoEntrys = this.bomEcoEntryRepalceMap.getOrDefault(bomNumber, new ArrayList(8));
            bomEcoEntrys.addAll(ecoBomEntrys);
            this.bomEcoEntryRepalceMap.put(bomNumber, bomEcoEntrys);
        }
        return expireFail;
    }

    private void updateEcnNewEntryFromChangeEntry(DynamicObject changeEntryObj, DynamicObject lastChangeEcnRow, String changeType, List<String> modifyFiledList) {
        if ("C".equals(changeType)) {
            DataEntityPropertyCollection dataProperties = lastChangeEcnRow.getDynamicObjectType().getProperties();
            DataEntityPropertyCollection changePropertys = changeEntryObj.getDynamicObjectType().getProperties();
            for (IDataEntityProperty dataProperty : dataProperties) {
                String fieldName = dataProperty.getName();
                String newFieldName = "new_" + fieldName;
                boolean isNew = false;
                if (changePropertys.containsKey((Object)newFieldName)) {
                    lastChangeEcnRow.set(fieldName, changeEntryObj.get(newFieldName));
                }
                if (!modifyFiledList.contains(fieldName) && !modifyFiledList.contains(fieldName + "_ctrl") || !dataProperties.containsKey((Object)fieldName) || !changePropertys.containsKey((Object)fieldName) || "qtyentry".equals(dataProperty.getName()) || "setupentry".equals(dataProperty.getName()) || "subentryentity".equals(dataProperty.getName()) || "workstationentry".equals(dataProperty.getName())) continue;
                if ("multilanguagetext".equals(dataProperty.getName())) {
                    DynamicObjectCollection newLocCol = this.setLocaleString(changeEntryObj, dataProperty.getName());
                    lastChangeEcnRow.set(dataProperty.getName(), (Object)newLocCol);
                    continue;
                }
                lastChangeEcnRow.set(dataProperty.getName(), changeEntryObj.get(dataProperty.getName()));
            }
        }
    }

    private static String genReplaceGroupNo(int seq) {
        return ORM.create().genLongId(ENTITY_REPLACEPLAN) + "_" + seq;
    }

    private boolean checkReplaceInvalideDate(DynamicObject bomEntry, DynamicObject changeEntryObj) {
        Date invalidityDate = BatchBOMUtils.getInvalidityDateFromChangeEntry((DynamicObject)changeEntryObj);
        return BatchBOMUtils.checkInvalidDate((DynamicObject)bomEntry, (Date)invalidityDate);
    }

    private List<DynamicObject> createEcoBomUpdateEntry(DynamicObject bomEntry, DynamicObjectCollection ecoBomEntryCol, DynamicObject changeEntryObj, int seq) {
        ArrayList<DynamicObject> ecoBomEntrys = new ArrayList<DynamicObject>(2);
        Date entryvaliddate = changeEntryObj.getDate("entryvaliddate");
        DynamicObject ecoBomEntryObj = this.createEcoBomEntry(ecoBomEntryCol, bomEntry, entryvaliddate, "E");
        ecoBomEntryObj.set("seq", (Object)seq);
        DynamicObject ecoBomAfterEntryObj = this.createEcoBomEntry(ecoBomEntryCol, bomEntry, entryvaliddate, "A");
        if (ecoBomAfterEntryObj.getDynamicObjectType().getProperties().containsKey((Object)"acttime")) {
            ecoBomAfterEntryObj.set("entryvaliddate", ecoBomAfterEntryObj.get("acttime"));
        }
        DynamicObjectCollection qtyEntry = this.createChildEntry(ecoBomAfterEntryObj, bomEntry, "qtyentry");
        ecoBomAfterEntryObj.set("qtyentry", (Object)qtyEntry);
        DynamicObjectCollection setupEntry = this.createChildEntry(ecoBomAfterEntryObj, bomEntry, "setupentry");
        ecoBomAfterEntryObj.set("setupentry", (Object)setupEntry);
        DynamicObjectCollection subEntryEntity = this.createChildEntry(ecoBomAfterEntryObj, bomEntry, "subentryentity");
        ecoBomAfterEntryObj.set("subentryentity", (Object)subEntryEntity);
        DynamicObjectCollection workStationEntry = this.createChildEntry(ecoBomAfterEntryObj, bomEntry, "workstationentry");
        ecoBomAfterEntryObj.set("workstationentry", (Object)workStationEntry);
        if (ecoBomAfterEntryObj != null) {
            ecoBomAfterEntryObj.set("entrymode", (Object)"C");
        }
        ecoBomAfterEntryObj.set("entryreplacegroup", (Object)"");
        ecoBomAfterEntryObj.set("entryreplaceplan", null);
        ecoBomAfterEntryObj.set("entryisreplaceplanmm", (Object)false);
        ecoBomAfterEntryObj.set("seq", (Object)seq);
        ecoBomEntrys.add(ecoBomEntryObj);
        ecoBomEntrys.add(ecoBomAfterEntryObj);
        return ecoBomEntrys;
    }

    private boolean checkBomEntryExistChangeEntry(DynamicObjectCollection copyChangEntry, DynamicObject bomEntry, DynamicObject changeEntryObj) {
        CheckBOMUtils checkBOMUtils = new CheckBOMUtils();
        boolean consistent = checkBOMUtils.checkTwoEntryConsistent("B", changeEntryObj, bomEntry);
        if (consistent) {
            return consistent;
        }
        return checkBOMUtils.checkExistEntry("B", bomEntry, copyChangEntry, "");
    }

    private DynamicObject createEcoBomExpirEntry(DynamicObject bomEntry, DynamicObjectCollection ecoBomEntryCol, Date entryvaliddate, int seq, String entryMode) {
        DynamicObject ecoBomEntryObj = this.createEcoBomEntry(ecoBomEntryCol, bomEntry, entryvaliddate, entryMode);
        ecoBomEntryObj.set("seq", (Object)seq);
        return ecoBomEntryObj;
    }

    private DynamicObject createEcoBomEntry(DynamicObjectCollection ecoBomEntryCol, DynamicObject bomEntry, Date validdate, String entryMode) {
        DynamicObject ecoBomEntryObj = ecoBomEntryCol.addNew();
        long ecnEntryId = ID.genLongId();
        DataEntityPropertyCollection bomEntryObjPro = bomEntry.getDynamicObjectType().getProperties();
        DataEntityPropertyCollection eocBomEntryObjPro = ecoBomEntryObj.getDynamicObjectType().getProperties();
        for (IDataEntityProperty dataProperty : eocBomEntryObjPro) {
            if (!bomEntryObjPro.containsKey((Object)dataProperty.getName()) || "qtyentry".equals(dataProperty.getName()) || "setupentry".equals(dataProperty.getName()) || "subentryentity".equals(dataProperty.getName()) || "workstationentry".equals(dataProperty.getName())) continue;
            if ("multilanguagetext".equals(dataProperty.getName())) {
                DynamicObjectCollection newLocCol = this.setLocaleString(bomEntry, dataProperty.getName());
                ecoBomEntryObj.set(dataProperty.getName(), (Object)newLocCol);
                continue;
            }
            ecoBomEntryObj.set(dataProperty.getName(), bomEntry.get(dataProperty.getName()));
        }
        DynamicObjectCollection qtyEntry = this.createChildEntry(ecoBomEntryObj, bomEntry, "qtyentry");
        ecoBomEntryObj.set("qtyentry", (Object)qtyEntry);
        DynamicObjectCollection setupEntry = this.createChildEntry(ecoBomEntryObj, bomEntry, "setupentry");
        ecoBomEntryObj.set("setupentry", (Object)setupEntry);
        DynamicObjectCollection subEntryEntity = this.createChildEntry(ecoBomEntryObj, bomEntry, "subentryentity");
        ecoBomEntryObj.set("subentryentity", (Object)subEntryEntity);
        DynamicObjectCollection workStationEntry = this.createChildEntry(ecoBomEntryObj, bomEntry, "workstationentry");
        ecoBomEntryObj.set("workstationentry", (Object)workStationEntry);
        long bomEntryId = bomEntry.getLong("id");
        ecoBomEntryObj.set("acttime", (Object)validdate);
        ecoBomEntryObj.set("entrymode", (Object)entryMode);
        this.setEcnBomEntryHistoryAndNewID(entryMode, ecoBomEntryObj, bomEntryId, ecnEntryId);
        ecoBomEntryObj.set("id", (Object)ecnEntryId);
        return ecoBomEntryObj;
    }

    private void setEcnBomEntryHistoryAndNewID(String entryMode, DynamicObject ecoBomEntryObj, long bomEntryId, long ecnEntryId) {
        if ("A".equals(entryMode)) {
            ecoBomEntryObj.set("bomentry", (Object)ecnEntryId);
            ecoBomEntryObj.set("entrybomentryid", null);
        } else if ("E".equals(entryMode) || "B".equals(entryMode)) {
            ecoBomEntryObj.set("bomentry", (Object)bomEntryId);
            ecoBomEntryObj.set("entrybomentryid", (Object)bomEntryId);
        } else if ("C".equals(entryMode)) {
            ecoBomEntryObj.set("bomentry", (Object)ecnEntryId);
            ecoBomEntryObj.set("entrybomentryid", (Object)bomEntryId);
        }
    }

    private DynamicObject createNewEcoBomEntry(DynamicObjectCollection ecoBomEntryCol, DynamicObject changeEntryObj, String changeType, boolean isRepalce, DynamicObjectCollection bomEntryCol, List<String> modifyFiledList) {
        DataEntityPropertyCollection dataProperties = ecoBomEntryCol.getDynamicObjectType().getProperties();
        DataEntityPropertyCollection changePropertys = changeEntryObj.getDynamicObjectType().getProperties();
        DynamicObject newObj = ecoBomEntryCol.addNew();
        long entryId = ID.genLongId();
        DynamicObject updataEntryObj = changeEntryObj;
        DynamicObject bomEntryObj = null;
        if (isRepalce) {
            bomEntryObj = this.findEntryFromBomEntryCol(changeEntryObj, bomEntryCol);
            Iterator bomEntryProperties = bomEntryObj.getDynamicObjectType().getProperties();
            for (IDataEntityProperty dataProperty : dataProperties) {
                String fieldName = dataProperty.getName();
                String newFieldName = "new_" + fieldName;
                boolean isNew = false;
                if (changePropertys.containsKey((Object)newFieldName)) {
                    isNew = true;
                }
                if (!changePropertys.containsKey((Object)fieldName) || "qtyentry".equals(dataProperty.getName()) || "setupentry".equals(dataProperty.getName()) || "subentryentity".equals(dataProperty.getName()) || "workstationentry".equals(dataProperty.getName())) continue;
                if ("multilanguagetext".equals(dataProperty.getName())) {
                    DynamicObjectCollection newLocCol = this.setLocaleString(changeEntryObj, dataProperty.getName());
                    newObj.set(dataProperty.getName(), (Object)newLocCol);
                    continue;
                }
                if (isNew) {
                    newObj.set(fieldName, changeEntryObj.get(newFieldName));
                    continue;
                }
                if ((modifyFiledList.contains(fieldName) || modifyFiledList.contains(fieldName + "_ctrl")) && bomEntryProperties.containsKey(fieldName)) {
                    newObj.set(dataProperty.getName(), changeEntryObj.get(dataProperty.getName()));
                    continue;
                }
                newObj.set(dataProperty.getName(), bomEntryObj.get(dataProperty.getName()));
            }
        } else {
            for (IDataEntityProperty dataProperty : dataProperties) {
                if (!changePropertys.containsKey((Object)dataProperty.getName()) || "qtyentry".equals(dataProperty.getName()) || "setupentry".equals(dataProperty.getName()) || "subentryentity".equals(dataProperty.getName()) || "workstationentry".equals(dataProperty.getName())) continue;
                if ("multilanguagetext".equals(dataProperty.getName())) {
                    DynamicObjectCollection newLocCol = this.setLocaleString(changeEntryObj, dataProperty.getName());
                    newObj.set(dataProperty.getName(), (Object)newLocCol);
                    continue;
                }
                newObj.set(dataProperty.getName(), changeEntryObj.get(dataProperty.getName()));
            }
        }
        newObj.set("acttime", changeEntryObj.get("entryvaliddate"));
        newObj.set("transtartdate", changeEntryObj.get("entryvaliddate"));
        newObj.set("estimatestatus", (Object)"A");
        if (isRepalce && bomEntryObj != null && (modifyFiledList.contains("qtyentry") || modifyFiledList.contains("setupentry") || modifyFiledList.contains("subentryentity") || modifyFiledList.contains("workstationentry"))) {
            updataEntryObj = bomEntryObj;
        }
        DynamicObjectCollection qtyEntry = this.createChildEntry(newObj, updataEntryObj, "qtyentry");
        newObj.set("qtyentry", (Object)qtyEntry);
        DynamicObjectCollection setupEntry = this.createChildEntry(newObj, updataEntryObj, "setupentry");
        newObj.set("setupentry", (Object)setupEntry);
        DynamicObjectCollection subEntryEntity = this.createChildEntry(newObj, updataEntryObj, "subentryentity");
        newObj.set("subentryentity", (Object)subEntryEntity);
        DynamicObjectCollection workStationEntry = this.createChildEntry(newObj, updataEntryObj, "workstationentry");
        newObj.set("workstationentry", (Object)workStationEntry);
        newObj.set("id", (Object)entryId);
        newObj.set("bomentry", (Object)entryId);
        newObj.set("entrymode", (Object)"A");
        return newObj;
    }

    private DynamicObject findEntryFromBomEntryCol(DynamicObject changeEntryObj, DynamicObjectCollection bomEntryCol) {
        long changeBomEntryId = changeEntryObj.getLong("id");
        DynamicObject updateBomEntryObj = changeEntryObj;
        for (int i = 0; i < bomEntryCol.size(); ++i) {
            DynamicObject bomEntryObj = (DynamicObject)bomEntryCol.get(i);
            long bomEntryId = bomEntryObj.getLong("id");
            if (changeBomEntryId != bomEntryId) continue;
            updateBomEntryObj = bomEntryObj;
            break;
        }
        return updateBomEntryObj;
    }

    private DynamicObject createBeforeEcoBomEntry(DynamicObject changeEntryObj, DynamicObjectCollection bomEntryCol, DynamicObjectCollection ecoBomEntryCol, String changeType) {
        String entryMode = "D".equals(changeType) ? "E" : "B";
        DynamicObject beforeUpdateObj = this.createEcoBomEntryInfo(changeEntryObj, bomEntryCol, ecoBomEntryCol, entryMode);
        DynamicObject updateBomEntryObj = null;
        long changeBomEntryId = changeEntryObj.getLong("id");
        for (int i = 0; i < bomEntryCol.size(); ++i) {
            DynamicObject bomEntryObj = (DynamicObject)bomEntryCol.get(i);
            long bomEntryId = bomEntryObj.getLong("id");
            if (changeBomEntryId != bomEntryId) continue;
            updateBomEntryObj = bomEntryObj;
            break;
        }
        if (updateBomEntryObj != null) {
            if ("E".equals(changeType) || "G".equals(changeType)) {
                bomEntryCol.remove(updateBomEntryObj);
            } else if (beforeUpdateObj != null) {
                DynamicObjectCollection qtyEntry = this.createChildEntry(beforeUpdateObj, updateBomEntryObj, "qtyentry");
                beforeUpdateObj.set("qtyentry", (Object)qtyEntry);
                DynamicObjectCollection setupEntry = this.createChildEntry(beforeUpdateObj, updateBomEntryObj, "setupentry");
                beforeUpdateObj.set("setupentry", (Object)setupEntry);
                DynamicObjectCollection subEntryEntity = this.createChildEntry(beforeUpdateObj, updateBomEntryObj, "subentryentity");
                beforeUpdateObj.set("subentryentity", (Object)subEntryEntity);
                DynamicObjectCollection workStationEntry = this.createChildEntry(beforeUpdateObj, updateBomEntryObj, "workstationentry");
                beforeUpdateObj.set("workstationentry", (Object)workStationEntry);
                beforeUpdateObj.set("acttime", changeEntryObj.get("entryvaliddate"));
            }
        }
        return beforeUpdateObj;
    }

    private DynamicObject createAfterEcoBomEntry(DynamicObject changeEntryObj, DynamicObjectCollection bomEntryCol, DynamicObjectCollection ecoBomEntryCol, String changeType, List<String> modifyFiledList) {
        DynamicObject afterUpdateObj = this.createEcoBomEntryInfo(changeEntryObj, bomEntryCol, ecoBomEntryCol, "C");
        if (afterUpdateObj == null) {
            return null;
        }
        DataEntityPropertyCollection changePropertys = changeEntryObj.getDynamicObjectType().getProperties();
        for (int i = 0; i < modifyFiledList.size(); ++i) {
            String fieldName = modifyFiledList.get(i);
            if ("setupentry".equals(fieldName) || "qtyentry".equals(fieldName) || "subentryentity".equals(fieldName) || "workstationentry".equals(fieldName)) continue;
            if (fieldName.endsWith("_ctrl")) {
                fieldName = fieldName.replace("_ctrl", "");
            }
            if (!changePropertys.containsKey((Object)fieldName)) continue;
            afterUpdateObj.set(fieldName, changeEntryObj.get(fieldName));
            afterUpdateObj.getDataEntityState().setBizChanged(((IDataEntityProperty)changePropertys.get((Object)fieldName)).getOrdinal(), true);
        }
        if (afterUpdateObj.getDynamicObjectType().getProperties().containsKey((Object)"acttime")) {
            afterUpdateObj.set("acttime", changeEntryObj.get("entryvaliddate"));
        }
        DynamicObjectCollection qtyEntry = this.createChildEntry(afterUpdateObj, changeEntryObj, "qtyentry");
        afterUpdateObj.set("qtyentry", (Object)qtyEntry);
        DynamicObjectCollection setupEntry = this.createChildEntry(afterUpdateObj, changeEntryObj, "setupentry");
        afterUpdateObj.set("setupentry", (Object)setupEntry);
        DynamicObjectCollection subEntryEntity = this.createChildEntry(afterUpdateObj, changeEntryObj, "subentryentity");
        afterUpdateObj.set("subentryentity", (Object)subEntryEntity);
        DynamicObjectCollection workStationEntry = this.createChildEntry(afterUpdateObj, changeEntryObj, "workstationentry");
        afterUpdateObj.set("workstationentry", (Object)workStationEntry);
        return afterUpdateObj;
    }

    private DynamicObject createEcoBomEntryInfo(DynamicObject changeEntryObj, DynamicObjectCollection bomEntryCol, DynamicObjectCollection ecoBomEntryCol, String entryMode) {
        long changeBomEntryId = changeEntryObj.getLong("id");
        DynamicObject updateBomEntryObj = null;
        for (int i = 0; i < bomEntryCol.size(); ++i) {
            DynamicObject bomEntryObj = (DynamicObject)bomEntryCol.get(i);
            long bomEntryId = bomEntryObj.getLong("id");
            if (changeBomEntryId != bomEntryId) continue;
            updateBomEntryObj = bomEntryObj;
            break;
        }
        if (updateBomEntryObj == null) {
            return null;
        }
        DynamicObject ecoBomEntryObj = ecoBomEntryCol.addNew();
        long entryId = ID.genLongId();
        DataEntityPropertyCollection bomEntryObjPro = updateBomEntryObj.getDynamicObjectType().getProperties();
        DataEntityPropertyCollection eocBomEntryObjPro = ecoBomEntryObj.getDynamicObjectType().getProperties();
        for (IDataEntityProperty dataProperty : eocBomEntryObjPro) {
            if (!bomEntryObjPro.containsKey((Object)dataProperty.getName()) || "qtyentry".equals(dataProperty.getName()) || "setupentry".equals(dataProperty.getName()) || "subentryentity".equals(dataProperty.getName()) || "workstationentry".equals(dataProperty.getName())) continue;
            if ("multilanguagetext".equals(dataProperty.getName())) {
                DynamicObjectCollection newLocCol = this.setLocaleString(updateBomEntryObj, dataProperty.getName());
                ecoBomEntryObj.set(dataProperty.getName(), (Object)newLocCol);
                continue;
            }
            ecoBomEntryObj.set(dataProperty.getName(), updateBomEntryObj.get(dataProperty.getName()));
        }
        ecoBomEntryObj.set("acttime", changeEntryObj.get("entryvaliddate"));
        ecoBomEntryObj.set("entrymode", (Object)entryMode);
        this.setEcnBomEntryHistoryAndNewID(entryMode, ecoBomEntryObj, changeBomEntryId, entryId);
        ecoBomEntryObj.set("id", (Object)entryId);
        return ecoBomEntryObj;
    }

    private DynamicObjectCollection createChildEntry(DynamicObject targetEntryObj, DynamicObject sourceObj, String entryNum) {
        DynamicObjectCollection sourceEntryCol = sourceObj.getDynamicObjectCollection(entryNum);
        DynamicObjectCollection tagetEntryCol = targetEntryObj.getDynamicObjectCollection(entryNum);
        int sourceSize = sourceEntryCol.size();
        for (int i = 0; i < sourceSize; ++i) {
            DynamicObject newEntryObj = tagetEntryCol.addNew();
            long entryId = ID.genLongId();
            DynamicObject sourceEntryObj = (DynamicObject)sourceEntryCol.get(i);
            DataEntityPropertyCollection targetPropertys = newEntryObj.getDynamicObjectType().getProperties();
            DataEntityPropertyCollection sourcePropertys = sourceEntryObj.getDynamicObjectType().getProperties();
            boolean hasData = false;
            for (IDataEntityProperty dataProperty : targetPropertys) {
                String fieldName = dataProperty.getName();
                if (!sourcePropertys.containsKey((Object)fieldName)) continue;
                if ("multilanguagetext".equals(dataProperty.getName())) {
                    DynamicObjectCollection newLocCol = this.setLocaleString(sourceEntryObj, fieldName);
                    newEntryObj.set(fieldName, (Object)newLocCol);
                    hasData = true;
                    continue;
                }
                newEntryObj.set(fieldName, sourceEntryObj.get(fieldName));
                hasData = true;
            }
            if (!hasData) continue;
            newEntryObj.set("id", (Object)entryId);
        }
        return tagetEntryCol;
    }

    private DynamicObjectCollection setLocaleString(DynamicObject sourceEntryObj, String fieldName) {
        LocaleDynamicObjectCollection locCol = (LocaleDynamicObjectCollection)sourceEntryObj.get(fieldName);
        LocaleDynamicObjectCollection newLocCol = new LocaleDynamicObjectCollection();
        for (DynamicObject locObj : locCol) {
            DynamicObject newLocObj = new DynamicObject(locObj.getDynamicObjectType());
            DataEntityPropertyCollection locPros = locObj.getDataEntityType().getProperties();
            for (IDataEntityProperty locProperty : locPros) {
                newLocObj.set(locProperty.getName(), locObj.get(locProperty.getName()));
            }
            newLocObj.set("pkid", (Object)Uuid16.create().toString());
            newLocCol.add((Object)newLocObj);
        }
        return newLocCol;
    }

    private DynamicObject createLogInfo(DynamicObjectCollection changeEntrys, Map<String, Object> param, Set<Map.Entry<Object, DynamicObject>> bomSet) {
        String changeOrgId = String.valueOf(param.get("changeOrg"));
        DynamicObject batchMFTBomLogDO = BusinessDataServiceHelper.newDynamicObject((String)"pdm_batchmftbomlog");
        RequestContext curUserID = RequestContext.getOrCreate();
        Long userId = curUserID.getCurrUserId();
        batchMFTBomLogDO.set("orgchange", (Object)Long.valueOf(changeOrgId));
        batchMFTBomLogDO.set("createorg", (Object)Long.valueOf(changeOrgId));
        batchMFTBomLogDO.set("createorg_id", (Object)Long.valueOf(changeOrgId));
        batchMFTBomLogDO.set("creator", (Object)userId);
        batchMFTBomLogDO.set("modifier", (Object)userId);
        batchMFTBomLogDO.set("modifytime", (Object)new Date());
        batchMFTBomLogDO.set("createtime", (Object)new Date());
        batchMFTBomLogDO.set("showcontent", (Object)ResManager.loadKDString((String)"\u8be6\u60c5", (String)"BatchBomToECNBusiness_28", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        batchMFTBomLogDO.set("updatetype", (Object)"B");
        if (changeEntrys.size() > 0) {
            DynamicObject typeDO = (DynamicObject)changeEntrys.get(0);
            String typeStr = MMCUtils.getDynamicObjectStringData((DynamicObject)typeDO, (String)"changetype");
            batchMFTBomLogDO.set("type", (Object)typeStr);
        }
        List modifyFiledList = JSONArray.parseArray((String)param.get("modifyFileds").toString(), String.class);
        ArrayList<String> changeFiedList = new ArrayList<String>(100);
        for (int i = 0; i < modifyFiledList.size(); ++i) {
            String fieldName = (String)modifyFiledList.get(i);
            if (StringUtils.contains((CharSequence)fieldName, (CharSequence)"_ctrl") || StringUtils.contains((CharSequence)fieldName, (CharSequence)"_qty") || StringUtils.contains((CharSequence)fieldName, (CharSequence)"_set")) {
                changeFiedList.add(fieldName.substring(0, fieldName.indexOf("_")));
                continue;
            }
            changeFiedList.add(fieldName);
        }
        return this.createLogEntry(batchMFTBomLogDO, bomSet, changeFiedList, changeEntrys);
    }

    private DynamicObject createLogEntry(DynamicObject batchMFTBomLogDO, Set<Map.Entry<Object, DynamicObject>> bomSet, List<String> changeFiedList, DynamicObjectCollection changeEntrys) {
        DynamicObjectCollection logDetailEntryDOC = batchMFTBomLogDO.getDynamicObjectCollection("logdetailentry");
        String newline = System.lineSeparator();
        for (Map.Entry<Object, DynamicObject> entry : bomSet) {
            long bomid = Long.parseLong(entry.getKey().toString());
            DynamicObject bomObj = entry.getValue();
            DynamicObject matObj = bomObj.getDynamicObject("materialid");
            DynamicObject auxpObj = bomObj.getDynamicObject("auxproperty");
            DynamicObject logDetailEntry = logDetailEntryDOC.addNew();
            String msg = this.failedMap.get(bomid);
            if (msg != null) {
                if (this.repeatS.contains(bomid)) {
                    logDetailEntry.set("changestatus", (Object)"A");
                    msg = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u6210\u529f%1$s%2$s", (String)"BatchBomToECNBusiness_27", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), newline, msg);
                } else {
                    logDetailEntry.set("changestatus", (Object)"B");
                }
            } else {
                logDetailEntry.set("changestatus", (Object)"A");
            }
            logDetailEntry.set("bomid", (Object)bomid);
            logDetailEntry.set("bomnum", (Object)bomObj.getString("number"));
            logDetailEntry.set("bommaterialnumber", (Object)matObj.getString("number"));
            Object multiTextObj = logDetailEntry.get("multilanguagetext");
            if (multiTextObj instanceof LocaleDynamicObjectCollection) {
                LocaleDynamicObjectCollection multiTextObjDOC = (LocaleDynamicObjectCollection)multiTextObj;
                OrmLocaleValue materialNameL = (OrmLocaleValue)matObj.get("name");
                materialNameL.keySet().stream().forEach(keyMap -> {
                    DynamicObject multiDO = multiTextObjDOC.addNew();
                    String value = materialNameL.get(keyMap);
                    multiDO.set("localeid", keyMap);
                    multiDO.set("bommatername", (Object)value);
                });
            }
            logDetailEntry.set("multilanguagetext", multiTextObj);
            logDetailEntry.set("bomauxpropertyid", auxpObj == null ? Long.valueOf(0L) : auxpObj.getPkValue());
            logDetailEntry.set("exeresult", (Object)msg);
            BatchBomPageOPUtils batchBomPageOPUtils = new BatchBomPageOPUtils(this.replacePlanBomEntryMap, this.bomEcoEntryRepalceMap);
            batchBomPageOPUtils.writeModifyContent(changeFiedList, changeEntrys, batchMFTBomLogDO, "content", "savecontent");
        }
        return batchMFTBomLogDO;
    }

    private String getBomTypeCheckRepeat(DynamicObject bomObj) {
        DynamicObject type = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)bomObj, (String)"type");
        String checkRepeat = type.getString("checkrepeat");
        return checkRepeat;
    }

    static {
        ENTITY_REPLACEPLAN = "mpdm_replaceplan";
    }
}

