/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.batchmftbom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxLink;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.ControlAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.mmc.pdm.business.ext.EditSetModifyFieldAfterArgs;
import kd.mmc.pdm.business.ext.IBatchBOMSetModifyFieldExt;
import kd.mmc.pdm.common.util.FormMetaDataUtil;
import kd.mmc.pdm.common.util.MMCUtils;
import kd.mmc.pdm.common.util.ORGAndPermissionUtils;
import kd.mmc.pdm.formplugin.batchmftbom.BatchMFTBomRangeEditPlugin;

public class BatchMFTBomEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(BatchMFTBomRangeEditPlugin.class);
    private static final String PDM_BATCHMFTBOMRANGE = "pdm_batchmftbomrange";
    private static final String MPDM_BOMTYPE = "mpdm_bomtype";
    private static final String MATERRIAL_PAGE = "tabpage_entry";
    private static final String MATERRIAL_CONTROL_PAGE = "tabpage_entrycontrol";
    private static final String QTYENTRY_PAGE = "tabpage_qtyentry";
    private static final String SETUPENTRY_PAGE = "tabpage_setupentry";
    private static final String ENTRY_NAME = "filedlist";
    private static final String MULTYPE = "multype";
    private static List<String> noShowField = new ArrayList<String>(128);
    public static final HashMap<String, Map<String, Integer>> RELATIONMAP = new HashMap();
    private static Map<String, Integer> materialAttrRelation = new HashMap<String, Integer>(2);
    private static Map<String, Integer> qtyTypeRelation = new HashMap<String, Integer>(2);
    private static Map<String, Integer> qtyEntryRelation = new HashMap<String, Integer>(2);
    private static Map<String, Integer> qtyAndQtyTypeRelation = new HashMap<String, Integer>(2);
    private static Map<String, Integer> setupEntryRelation = new HashMap<String, Integer>(4);
    private static Map<String, Integer> configCodeRelation = new HashMap<String, Integer>(8);
    private static Map<String, Integer> workstationRelation = new HashMap<String, Integer>(4);
    private static Map<String, Integer> locationRelation = new HashMap<String, Integer>(2);
    private static Map<String, Integer> qtyRelation = new HashMap<String, Integer>(2);
    private static Map<String, Integer> operationRelation = new HashMap<String, Integer>(2);
    private static Map<String, Integer> ownerRelation = new HashMap<String, Integer>(2);
    private static Map<String, Integer> isbulkmaterialRelation = new HashMap<String, Integer>(1);
    private static Map<String, Integer> outWarehouseRelation = new HashMap<String, Integer>(2);
    private static Map<String, Integer> outWareOrgRelation = new HashMap<String, Integer>(1);
    private static Map<String, Integer> defultSupplyOrgRelation = new HashMap<String, Integer>(3);
    private static boolean staticVariableInvalid = true;
    private static List<Long> orgList = new ArrayList<Long>();
    private static final String ORGCHANGE = "orgchange";

    public static List<String> getNoShowField() {
        return noShowField;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.bindFiledList(this.getView(), this.getModel());
        this.initChangeOrg();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"replaceplan"});
        this.excuteBOMSetModifyFieldExt();
    }

    private void excuteBOMSetModifyFieldExt() {
        EditSetModifyFieldAfterArgs args = new EditSetModifyFieldAfterArgs(RELATIONMAP);
        PluginProxy pluginProxy = PluginProxy.create(null, IBatchBOMSetModifyFieldExt.class, (String)"BATCHBOM_SET_MODIFY_FIELD", null);
        List list = pluginProxy.callAfter(p -> {
            if (p != null) {
                p.afterEditSetModifyField(args);
            }
            return null;
        });
    }

    private static void initRelationField(Map<String, Integer> relationMap, String[] relationStr) {
        if (relationMap == null || relationStr == null) {
            return;
        }
        for (int i = 0; i < relationStr.length; ++i) {
            relationMap.put(relationStr[i], -1);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        boolean permFlag;
        super.preOpenForm(e);
        RequestContext curUserID = RequestContext.getOrCreate();
        long currUserId = curUserID.getCurrUserId();
        String permIDStr = this.getPermissionID("BATCHMFTBOMMODIFY");
        if (StringUtils.isEmpty((CharSequence)permIDStr)) {
            permFlag = false;
        } else {
            permFlag = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"fmm", (String)"pdm_mftbom", (String)permIDStr);
            logger.info(String.format("\u662f\u5426\u6709fmm\u4e0bpdm_mftbom\u7684\u6279\u91cf\u4fee\u6539\u6743\u9650\uff08BATCHMFTBOMMODIFY\uff09\uff1a%s;", permFlag));
        }
        if (!permFlag) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u65e0BOM\u7ef4\u62a4->\u6279\u91cf\u4fee\u6539\u6743\u9650\u3002", (String)"BatchMFTBomEditPlugin_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    private String getPermissionID(String permName) {
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"perm_permitem", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)permName)});
        Optional entry = loadFromCache.entrySet().stream().findFirst();
        Map.Entry mapEntry = (Map.Entry)entry.get();
        if (mapEntry == null) {
            return "";
        }
        DynamicObject value = (DynamicObject)mapEntry.getValue();
        if (value == null) {
            return "";
        }
        String permIDStr = value.getString("id");
        return permIDStr;
    }

    private void bindFiledList(IFormView fv, IDataModel model) {
        List materialPages = FormMetaDataUtil.getContainerAps((String)PDM_BATCHMFTBOMRANGE, (String)MATERRIAL_PAGE);
        List materialControlPages = FormMetaDataUtil.getContainerAps((String)PDM_BATCHMFTBOMRANGE, (String)MATERRIAL_CONTROL_PAGE);
        List qtyEntryPages = FormMetaDataUtil.getContainerAps((String)PDM_BATCHMFTBOMRANGE, (String)QTYENTRY_PAGE);
        List setupEntryPages = FormMetaDataUtil.getContainerAps((String)PDM_BATCHMFTBOMRANGE, (String)SETUPENTRY_PAGE);
        List configCodeEntryPages = FormMetaDataUtil.getContainerAps((String)PDM_BATCHMFTBOMRANGE, (String)"tabpage_chararule");
        DynamicObjectCollection entryEntity = model.getEntryEntity(ENTRY_NAME);
        int row = 0;
        this.addEntryRow(materialPages, model, fv, ENTRY_NAME, true);
        this.addEntryRow(materialControlPages, model, fv, ENTRY_NAME, true);
        if (entryEntity != null) {
            row = entryEntity.size();
            model.createNewEntryRow(ENTRY_NAME);
            this.setFieldListValue(model, ResManager.loadKDString((String)"\u9636\u68af\u7528\u91cf", (String)"BatchMFTBomEditPlugin_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), "qtyentry", row, false);
            qtyTypeRelation.put("qtyentry", row);
        }
        this.addEntryRow(qtyEntryPages, model, fv, ENTRY_NAME, false);
        if (entryEntity != null) {
            row = entryEntity.size();
            model.createNewEntryRow(ENTRY_NAME);
            this.setFieldListValue(model, ResManager.loadKDString((String)"\u5b89\u88c5\u4f4d\u7f6e", (String)"BatchMFTBomEditPlugin_2", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), "setupentry", row, false);
        }
        this.addEntryRow(setupEntryPages, model, fv, ENTRY_NAME, false);
        if (entryEntity != null) {
            row = entryEntity.size();
            int configRuleEntryRow = model.createNewEntryRow(ENTRY_NAME);
            this.setFieldListValue(model, ResManager.loadKDString((String)"\u914d\u7f6e\u89c4\u5219", (String)"BatchMFTBomEditPlugin_3", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), "subentryentity", row, true);
        }
        this.addEntryRow(configCodeEntryPages, model, fv, ENTRY_NAME, false);
        this.getRowIndexRelationFiled(this.getView(), this.getModel(), true, "workstationentry");
        this.getRowIndexRelationFiled(this.getView(), this.getModel(), true, "subentryentity");
        staticVariableInvalid = false;
    }

    private void addEntryRow(List<ControlAp<?>> controls, IDataModel model, IFormView fv, String entryName, boolean flag) {
        DynamicObjectCollection entryEntity = model.getEntryEntity(entryName);
        if (controls == null || entryEntity == null) {
            return;
        }
        int row = entryEntity.size();
        for (ControlAp<?> controlAp : controls) {
            if (controlAp.isHidden() || noShowField.contains(controlAp.getKey())) continue;
            model.createNewEntryRow(entryName);
            this.setFieldListValue(model, controlAp.getName().getLocaleValue(), controlAp.getKey(), row, false);
            if (!flag) {
                fv.setEnable(Boolean.valueOf(false), row, new String[]{"isupdate"});
            }
            if (StringUtils.equals((CharSequence)controlAp.getKey(), (CharSequence)"entryisjumplevel_ctrl")) {
                model.setValue("isupdate", (Object)true, row);
                fv.setEnable(Boolean.valueOf(false), row, new String[]{"isupdate"});
            }
            if (StringUtils.equals((CharSequence)controlAp.getKey(), (CharSequence)"entryconfiguredcode")) {
                model.setValue("isupdate", (Object)true, row);
                fv.setEnable(Boolean.valueOf(false), row, new String[]{"isupdate"});
            }
            if (StringUtils.equals((CharSequence)controlAp.getKey(), (CharSequence)"entryqtynumerator") || "entryqtydenominator".equals(controlAp.getKey())) {
                model.setValue("isupdate", (Object)true, row);
            }
            this.initRelationRowIndex(controlAp.getKey(), row);
            ++row;
        }
    }

    private void initRelationRowIndex(String key, int row) {
        this.setStaticMapValue(materialAttrRelation, key, row);
        this.setStaticMapValue(qtyTypeRelation, key, row);
        this.setStaticMapValue(qtyEntryRelation, key, row);
        this.setStaticMapValue(qtyAndQtyTypeRelation, key, row);
        this.setStaticMapValue(setupEntryRelation, key, row);
        this.setStaticMapValue(configCodeRelation, key, row);
        this.setStaticMapValue(workstationRelation, key, row);
        this.setStaticMapValue(locationRelation, key, row);
        this.setStaticMapValue(qtyRelation, key, row);
        this.setStaticMapValue(operationRelation, key, row);
        this.setStaticMapValue(ownerRelation, key, row);
        this.setStaticMapValue(isbulkmaterialRelation, key, row);
        this.setStaticMapValue(outWarehouseRelation, key, row);
        this.setStaticMapValue(outWareOrgRelation, key, row);
        this.setStaticMapValue(defultSupplyOrgRelation, key, row);
    }

    private void setStaticMapValue(Map<String, Integer> relationMap, String key, int row) {
        if (relationMap == null || row < 0) {
            return;
        }
        if (relationMap.containsKey(key)) {
            relationMap.put(key, row);
        }
    }

    private void setFieldListValue(IDataModel model, String filedname, String filednumber, int row, boolean isModify) {
        model.setValue("filedname", (Object)filedname, row);
        model.setValue("filednumber", (Object)filednumber, row);
        model.setValue("isupdate", (Object)isModify, row);
    }

    private void initChangeOrg() {
        RequestContext curUserID = RequestContext.getOrCreate();
        long orgId = curUserID.getOrgId();
        Long userId = Long.parseLong(curUserID.getUserId());
        String permIDStr = this.getPermissionID("BATCHMFTBOMMODIFY");
        logger.info(String.format("\u83b7\u53d6fmm\u4e0bpdm_mftbom\u7684\u6279\u91cf\u4fee\u6539\u6743\u9650\u9879\uff08BATCHMFTBOMMODIFY\uff09ID\uff1a%s;", permIDStr));
        Long orgByUserOrg = ORGAndPermissionUtils.getOrgByUserOrg((Long)userId, (Long)orgId, (String)"pdm_mftbom", (String)"fmm", (String)permIDStr, (String)"04");
        this.getModel().setValue(ORGCHANGE, (Object)orgByUserOrg);
        orgList = ORGAndPermissionUtils.getAllOrgByPermission((Long)userId, (String)"fmm", (String)"pdm_mftbom", (String)permIDStr, (String)"04");
        logger.info(String.format("\u83b7\u53d6\u6240\u6709\u6709fmm\u4e0bpdm_mftbom\u7684\u6279\u91cf\u4fee\u6539\u6743\u9650\uff08BATCHMFTBOMMODIFY\uff09\u7684\u7ec4\u7ec7\uff1a%s\uff1b", orgList == null ? "[]" : orgList.toString()));
    }

    public void registerListener(EventObject e) {
        BasedataEdit featureTypeTo;
        BasedataEdit featureTypeFrom;
        BasedataEdit entryMaterialTo;
        BasedataEdit entryMaterialFrom;
        BasedataEdit proMaterialTo;
        BasedataEdit proMaterialFrom;
        super.registerListener(e);
        BasedataEdit orgChangeEdit = (BasedataEdit)this.getView().getControl(ORGCHANGE);
        orgChangeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bomFromEdit = (BasedataEdit)this.getView().getControl("bomfrom");
        bomFromEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bomToEdit = (BasedataEdit)this.getView().getControl("bomto");
        bomToEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit mulTypeEdit = (BasedataEdit)this.getView().getControl(MULTYPE);
        if (mulTypeEdit != null) {
            mulTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((proMaterialFrom = (BasedataEdit)this.getView().getControl("promaterialfrom")) != null) {
            proMaterialFrom.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((proMaterialTo = (BasedataEdit)this.getView().getControl("promaterialto")) != null) {
            proMaterialTo.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entryMaterialFrom = (BasedataEdit)this.getView().getControl("entrymaterialfrom")) != null) {
            entryMaterialFrom.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entryMaterialTo = (BasedataEdit)this.getView().getControl("entrymaterialto")) != null) {
            entryMaterialTo.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((featureTypeFrom = (BasedataEdit)this.getView().getControl("featuretypefrom")) != null) {
            featureTypeFrom.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((featureTypeTo = (BasedataEdit)this.getView().getControl("featuretypeto")) != null) {
            featureTypeTo.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners(new String[]{"bom_query"});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String eventName;
        switch (eventName = e.getProperty().getName()) {
            case "orgchange": {
                ListShowParameter orgShowParam = (ListShowParameter)e.getFormShowParameter();
                if (orgList.isEmpty()) {
                    RequestContext curUserID = RequestContext.getOrCreate();
                    Long userId = Long.parseLong(curUserID.getUserId());
                    String permIDStr = this.getPermissionID("BATCHMFTBOMMODIFY");
                    orgList = ORGAndPermissionUtils.getAllOrgByPermission((Long)userId, (String)"fmm", (String)"pdm_mftbom", (String)permIDStr, (String)"04");
                    logger.info(String.format("F7\u4e8b\u4ef6\u4e2d\u83b7\u53d6\u6240\u6709\u6709fmm\u4e0bpdm_mftbom\u7684\u6279\u91cf\u4fee\u6539\u6743\u9650\uff08BATCHMFTBOMMODIFY\uff09\u7684\u7ec4\u7ec7\uff1a%s\uff1b", orgList == null ? "[]" : orgList.toString()));
                }
                orgShowParam.getListFilterParameter().setFilter(new QFilter("id", "in", orgList));
                List qFilters2 = orgShowParam.getListFilterParameter().getQFilters();
                logger.info(String.format("\u8fc7\u6ee4\u6761\u4ef6\u4e3a\uff1a%s\uff1b", qFilters2 == null ? "[]" : qFilters2.toString()));
                break;
            }
            case "multype": {
                ListShowParameter typeShowParam = (ListShowParameter)e.getFormShowParameter();
                List qFilters1 = typeShowParam.getListFilterParameter().getQFilters();
                String updateType = (String)this.getModel().getValue("updatetype");
                if (!"B".equals(updateType)) break;
                qFilters1.add(new QFilter("isecnupdate", "!=", (Object)"0"));
                break;
            }
            case "bomfrom": 
            case "bomto": {
                boolean f7ShowFlag = this.emptyCheckTypeOrOrg(e);
                if (!f7ShowFlag) {
                    return;
                }
                List<QFilter> ecnqFilters = this.getBomQFilter();
                this.listShowParamF7(e, "pdm_mftbom", "createorg", ecnqFilters);
                ListShowParameter bomFShowPara = (ListShowParameter)e.getFormShowParameter();
                break;
            }
        }
    }

    private List<QFilter> getBomQFilter() {
        ArrayList<QFilter> ecnqFilters = new ArrayList<QFilter>(1);
        Object orgObj = this.getModel().getValue(ORGCHANGE);
        if (orgObj instanceof DynamicObject) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORGCHANGE);
            QFilter bomFOrgQFilter = new QFilter("createorg", "=", org.getPkValue());
            ecnqFilters.add(bomFOrgQFilter);
        }
        List<Long> typePkList = this.getMulTypeData(this.getModel());
        ecnqFilters.add(new QFilter("type", "in", typePkList));
        return ecnqFilters;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("bom_query".equals(key)) {
            this.clickBomQuery();
        }
    }

    private void clickBomQuery() {
        IDataModel model = this.getModel();
        Object changeOrgObj = model.getValue(ORGCHANGE);
        List<Long> mulTypeData = this.getMulTypeData(model);
        Long changeOrg = 0L;
        if (changeOrgObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u3010\u53d8\u66f4\u7ec4\u7ec7\u3011\u3002", (String)"BatchMFTBomEditPlugin_4", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return;
        }
        changeOrg = (Long)((DynamicObject)changeOrgObj).getPkValue();
        if (mulTypeData == null || mulTypeData.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u3010\u53d8\u66f4\u5bf9\u8c61\u7c7b\u578b\u3011\u3002", (String)"BatchMFTBomEditPlugin_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return;
        }
        Object isecnObj = model.getValue("isecn");
        boolean isecn = false;
        if (isecnObj != null) {
            isecn = (Boolean)isecnObj;
        }
        Object effectObj = model.getValue("effectivedate");
        Date effectiveDate = new Date();
        if (effectObj instanceof Date) {
            effectiveDate = (Date)effectObj;
        }
        List<Long> bomList = this.queryModifyBomList(changeOrg, mulTypeData, isecn);
        Set<String> modifyFileds = this.queryModifyFields(model);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
        ArrayList<String> modifyFiledList = new ArrayList<String>(modifyFileds);
        String changetype = MMCUtils.getDataModelStringData((IDataModel)model, (String)"changetypegroup");
        boolean replacePlanFlag = MMCUtils.getDataModelBooleanData((IDataModel)model, (String)"replaceplan");
        this.setFiledRelation(model, changetype);
        modifyFiledList.add("entryvaliddate");
        modifyFiledList.add("entrymaterialattr_ctrl");
        paramMap.put("mulTypePK", mulTypeData);
        paramMap.put("changetype", changetype);
        paramMap.put("replacePlanFlag", replacePlanFlag);
        paramMap.put("modifyFileds", modifyFiledList);
        paramMap.put("effectiveDate", effectiveDate);
        paramMap.put("changeOrg", changeOrg);
        paramMap.put("changeOrgObj", changeOrgObj);
        paramMap.put("bomList", bomList);
        String updatetype = MMCUtils.getDataModelStringData((IDataModel)model, (String)"updatetype");
        String version = MMCUtils.getDataModelStringData((IDataModel)model, (String)"version");
        paramMap.put("updatetype", updatetype);
        paramMap.put("version", version);
        this.showBatchBOMRange(paramMap);
    }

    private void setFiledRelation(IDataModel model, String changetype) {
        if (StringUtils.equals((CharSequence)changetype, (CharSequence)"C")) {
            this.setQtyTypeRelationIsUpdate(model);
        }
    }

    private void setQtyTypeRelationIsUpdate(IDataModel model) {
        if (model == null) {
            return;
        }
        if (qtyTypeRelation.get("qtyentry") > 0) {
            this.setEntryIsUpdate(this.getView(), model, qtyTypeRelation, true);
        } else {
            Object filedObj = model.getValue(ENTRY_NAME);
            if (filedObj instanceof DynamicObjectCollection) {
                DynamicObjectCollection filedDOC = (DynamicObjectCollection)filedObj;
                for (DynamicObject filedDO : filedDOC) {
                    String qtyTypeStr = MMCUtils.getDynamicObjectStringData((DynamicObject)filedDO, (String)"filednumber");
                    if (!StringUtils.equals((CharSequence)qtyTypeStr, (CharSequence)"entryqtytype")) continue;
                    filedDO.set("isupdate", (Object)true);
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u754c\u9762\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u52a0\u8f7d\u9875\u9762\u3002", (String)"BatchMFTBomEditPlugin_6", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    private Set<String> queryModifyFields(IDataModel model) {
        HashSet<String> modifyFields = new HashSet<String>(32);
        DynamicObjectCollection fieldEntrys = model.getEntryEntity(ENTRY_NAME);
        if (fieldEntrys == null || fieldEntrys.isEmpty()) {
            return null;
        }
        for (DynamicObject field : fieldEntrys) {
            boolean isModify = field.getBoolean("isupdate");
            String fieldName = field.getString("filednumber");
            if (!isModify || StringUtils.isEmpty((CharSequence)fieldName)) continue;
            modifyFields.add(fieldName);
        }
        return modifyFields;
    }

    private DynamicObject getDataModeDOValue(IDataModel model, String propertyName) {
        if (model == null || propertyName == null || "".equals(propertyName)) {
            return null;
        }
        Object obj = model.getValue(propertyName);
        return obj instanceof DynamicObject ? (DynamicObject)obj : null;
    }

    private boolean emptyCheckTypeOrOrg(BeforeF7SelectEvent e) {
        List<Long> mulTypePkList = this.getMulTypeData(this.getModel());
        if (mulTypePkList == null || mulTypePkList.isEmpty()) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u3010\u53d8\u66f4\u5bf9\u8c61\u7c7b\u578b\u3011\u3002", (String)"BatchMFTBomEditPlugin_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject changeORGDOValue = this.getDataModeDOValue(this.getModel(), ORGCHANGE);
        if (changeORGDOValue == null) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u3010\u53d8\u66f4\u7ec4\u7ec7\u3011\u3002", (String)"BatchMFTBomEditPlugin_4", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private List<Long> getMulTypeData(IDataModel model) {
        ArrayList<Long> pkList = new ArrayList<Long>(4);
        MulBasedataDynamicObjectCollection mulTypeDOC = null;
        if (model == null) {
            return pkList;
        }
        Object valueObj = model.getValue(MULTYPE);
        if (valueObj instanceof MulBasedataDynamicObjectCollection) {
            mulTypeDOC = (MulBasedataDynamicObjectCollection)valueObj;
        }
        if (mulTypeDOC != null && !mulTypeDOC.isEmpty()) {
            for (int i = 0; i < mulTypeDOC.size(); ++i) {
                DynamicObject mulTpeyDO = (DynamicObject)mulTypeDOC.get(i);
                DynamicObject mulType = mulTpeyDO.getDynamicObject("fbasedataid");
                if (mulType == null) continue;
                pkList.add(mulType.getLong("id"));
            }
        }
        return pkList;
    }

    private void listShowParamF7(BeforeF7SelectEvent e, String entityNum, String orgProName, List<QFilter> qFilters) {
        ListShowParameter bomFShowPara = (ListShowParameter)e.getFormShowParameter();
        ListFilterParameter lfp = bomFShowPara.getListFilterParameter();
        if (qFilters != null) {
            for (QFilter qFilter : qFilters) {
                lfp.setFilter(qFilter);
            }
        }
    }

    private void showCustomComfirm() {
        String msg = ResManager.loadKDString((String)"\u4fee\u6539\u7ec4\u4ef6\u6216\u66ff\u6362\u7ec4\u4ef6\u65f6\uff0c\u9700\u7ef4\u62a4\u5b57\u6bb5\u4fee\u6539\u8bbe\u7f6e\u624d\u4f1a\u66f4\u65b0\u5bf9\u5e94\u5b57\u6bb5\u503c\uff0c\u8bf7\u786e\u5b9a\u662f\u5426\u5df2\u6b63\u786e\u7ef4\u62a4\u3002", (String)"BatchMFTBomEditPlugin_7", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
        String info = ResManager.loadKDString((String)"\u4e0d\u518d\u63d0\u793a", (String)"BatchMFTBomEditPlugin_8", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(ResManager.loadKDString((String)"\u63d0\u793a", (String)"BatchMFTBomEditPlugin_9", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), (IFormPlugin)this);
        MessageBoxLink ls = new MessageBoxLink();
        this.getView().showConfirm("A", MessageBoxOptions.YesNo, confirmCallBacks);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    private List<Long> queryModifyBomList(Long changeOrg, List<Long> mulTypeData, boolean isecn) {
        QFilter materialQFilter;
        if (changeOrg == 0L || mulTypeData == null || mulTypeData.isEmpty()) {
            return null;
        }
        IDataModel model = this.getModel();
        List<String> bomFroms = this.getStringDataList(model, "bomfrom", "number");
        String bomTo = this.getStringData(model, "bomto", "number");
        List<String> proMaterialFroms = this.getStringDataList(model, "promaterialfrom", "number");
        String proMaterialTo = this.getStringData(model, "promaterialto", "number");
        List<String> materialFroms = this.getStringDataList(model, "entrymaterialfrom", "number");
        String materialTo = this.getStringData(model, "entrymaterialto", "number");
        List<String> featureTypeFroms = this.getStringDataList(model, "featuretypefrom", "number");
        String featureTypeTo = this.getStringData(model, "featuretypeto", "number");
        ArrayList<QFilter> qfs = new ArrayList<QFilter>(8);
        QFilter orgQFilter = new QFilter("createorg", "=", (Object)changeOrg);
        qfs.add(orgQFilter);
        QFilter typeQFilter = new QFilter("type", "in", mulTypeData);
        qfs.add(typeQFilter);
        QFilter enableQFilter = new QFilter("enable", "=", (Object)"1");
        qfs.add(enableQFilter);
        if (isecn) {
            QFilter isecnQFilter = new QFilter("status", "=", (Object)"C");
            qfs.add(isecnQFilter);
        }
        qfs.add(enableQFilter);
        if (bomFroms == null) {
            if (bomTo != null) {
                qfs.add(new QFilter("number", "in", (Object)bomTo));
            }
        } else if (bomFroms != null && bomFroms.size() > 1) {
            qfs.add(new QFilter("number", "in", bomFroms));
        } else if (bomFroms != null && bomFroms.size() == 1) {
            String largeBom = null;
            String lessBom = null;
            if (bomTo != null) {
                if (bomTo != null && bomFroms.get(0).compareTo(bomTo) < 0) {
                    largeBom = bomFroms.get(0);
                    lessBom = bomTo;
                } else {
                    largeBom = bomTo;
                    lessBom = bomFroms.get(0);
                }
                qfs.add(new QFilter("number", ">=", (Object)largeBom));
                qfs.add(new QFilter("number", "<=", (Object)lessBom));
            } else {
                qfs.add(new QFilter("number", "=", (Object)bomFroms.get(0)));
            }
        }
        if ((materialQFilter = this.getQFilter("materialid", proMaterialFroms, proMaterialTo, changeOrg, "bd_material", "number")) != null) {
            qfs.add(materialQFilter);
        }
        QFilter entrymaterialQFilter = this.getQFilter("entry.entrymaterialid", materialFroms, materialTo, changeOrg, "bd_material", "number");
        QFilter featureTypeQFilter = this.getQFilter("entry.featuretype", featureTypeFroms, featureTypeTo, changeOrg, "mpdm_featuretype", "number");
        if (entrymaterialQFilter != null) {
            if (featureTypeQFilter != null) {
                entrymaterialQFilter.or(featureTypeQFilter);
            }
            qfs.add(entrymaterialQFilter);
        }
        ArrayList<Long> boms = new ArrayList<Long>(8);
        QFilter[] qFilters = new QFilter[8];
        qFilters = qfs.toArray(qFilters);
        DynamicObjectCollection resultBoms = QueryServiceHelper.query((String)"pdm_mftbom", (String)"id", (QFilter[])qFilters);
        for (DynamicObject resultBom : resultBoms) {
            boms.add(resultBom.getLong("id"));
        }
        return boms;
    }

    private QFilter getQFilter(String filterFiled, List<String> froms, String to, Long changeOrg, String entityName, String numberField) {
        ArrayList<QFilter> qFList = new ArrayList<QFilter>(2);
        if (froms == null || froms.isEmpty()) {
            if (StringUtils.isBlank((CharSequence)to)) {
                return null;
            }
            qFList.add(new QFilter(numberField, "=", (Object)to));
        } else if (froms.size() > 1) {
            qFList.add(new QFilter(numberField, "in", froms));
        } else if (froms.size() == 1) {
            String largeBom = null;
            String lessBom = null;
            if (to != null) {
                if (to != null && froms.get(0).compareTo(to) < 0) {
                    largeBom = froms.get(0);
                    lessBom = to;
                } else {
                    largeBom = to;
                    lessBom = froms.get(0);
                }
                qFList.add(new QFilter(numberField, ">=", (Object)largeBom));
                qFList.add(new QFilter(numberField, "<=", (Object)lessBom));
            } else {
                qFList.add(new QFilter(numberField, "=", (Object)froms.get(0)));
            }
        }
        QFilter qFilterOrg = BaseDataServiceHelper.getBaseDataFilter((String)entityName, (Long)changeOrg);
        qFList.add(qFilterOrg);
        QFilter[] qFilters = qFList.toArray(new QFilter[1]);
        DynamicObjectCollection resultBoms = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])qFilters);
        ArrayList<Long> idList = new ArrayList<Long>();
        for (DynamicObject resultBom : resultBoms) {
            idList.add(resultBom.getLong("id"));
        }
        if (idList.isEmpty()) {
            return null;
        }
        return new QFilter(filterFiled, "in", idList);
    }

    private Long getLongData(IDataModel dm, String proName, String filedName) {
        DynamicObject data = this.getDataModeDOValue(dm, proName);
        if (data == null) {
            return null;
        }
        Object value = data.get(filedName);
        if (value instanceof Long) {
            return (Long)value;
        }
        return null;
    }

    private String getStringData(IDataModel dm, String proName, String filedName) {
        DynamicObject data = this.getDataModeDOValue(dm, proName);
        if (data == null) {
            return null;
        }
        Object value = data.get(filedName);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    private List<String> getStringDataList(IDataModel dm, String proName, String filedName) {
        if (this.checkParamEmpty(dm) || this.checkParamEmpty(proName) || this.checkParamEmpty(filedName)) {
            return null;
        }
        List<String> dataList = this.getDataList(dm, proName, filedName);
        if (this.checkParamEmpty(dataList)) {
            return null;
        }
        return dataList;
    }

    private List<String> getDataList(IDataModel dm, String proName, String filedName) {
        if (this.checkParamEmpty(dm) || this.checkParamEmpty(proName) || this.checkParamEmpty(filedName)) {
            return null;
        }
        Object proObj = dm.getValue(proName);
        ArrayList<String> resultList = new ArrayList<String>();
        if (proObj instanceof DynamicObjectCollection) {
            DynamicObjectCollection proObjs = (DynamicObjectCollection)proObj;
            if (proObjs == null || proObjs.isEmpty()) {
                return null;
            }
            for (DynamicObject row : proObjs) {
                DynamicObject basedataObj = row.getDynamicObject("fbasedataid");
                if (basedataObj == null) continue;
                Object filedV = basedataObj.get(filedName);
                if (filedV instanceof Long) {
                    resultList.add(filedV.toString());
                    continue;
                }
                resultList.add(String.valueOf(filedV));
            }
            return resultList;
        }
        return null;
    }

    private boolean checkParamEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        return obj instanceof String && "".equals(obj);
    }

    private void showBatchBOMRange(Map<String, Object> param) {
        BaseShowParameter rangeFormShow = new BaseShowParameter();
        rangeFormShow.setFormId(PDM_BATCHMFTBOMRANGE);
        rangeFormShow.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        rangeFormShow.setCustomParams(param);
        this.getView().showForm((FormShowParameter)rangeFormShow);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    public void propertyChanged(PropertyChangedArgs event) {
        String propertyName = event.getProperty().getName();
        ChangeData[] changeSet = event.getChangeSet();
        switch (propertyName) {
            case "bomfrom": {
                for (int i = 0; i < changeSet.length; ++i) {
                    this.handleBomFilter(this.getModel(), changeSet[i], "bomfrom", "bomto");
                }
                break;
            }
            case "promaterialfrom": {
                for (int i = 0; i < changeSet.length; ++i) {
                    this.handleBomFilter(this.getModel(), changeSet[i], "promaterialfrom", "promaterialto");
                }
                break;
            }
            case "entrymaterialfrom": {
                for (int i = 0; i < changeSet.length; ++i) {
                    this.handleBomFilter(this.getModel(), changeSet[i], "entrymaterialfrom", "entrymaterialto");
                }
                break;
            }
            case "featuretypefrom": {
                for (int i = 0; i < changeSet.length; ++i) {
                    this.handleBomFilter(this.getModel(), changeSet[i], "featuretypefrom", "featuretypeto");
                }
                break;
            }
            case "isupdate": {
                this.properChangedIsUpdate(changeSet);
                break;
            }
            case "changetypegroup": {
                this.propertyChangedTypeGroup(changeSet);
                break;
            }
            case "updatetype": {
                this.propertyChangeUpdateType(changeSet);
                break;
            }
        }
    }

    private void propertyChangeUpdateType(ChangeData[] changeSet) {
        for (int i = 0; i < changeSet.length; ++i) {
            Object newValue = changeSet[i].getNewValue();
            if (!(newValue instanceof String)) continue;
            String comboStr = newValue.toString();
            if (StringUtils.equals((CharSequence)comboStr, (CharSequence)"B")) {
                Object changeTypeGroup = this.getModel().getValue("changetypegroup");
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"deltype"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"delclasstype"});
                if (!(changeTypeGroup instanceof String) || !StringUtils.equals((CharSequence)"E", (CharSequence)changeTypeGroup.toString()) && !StringUtils.equals((CharSequence)"G", (CharSequence)changeTypeGroup.toString())) continue;
                this.getModel().setValue("changetypegroup", (Object)"A");
                continue;
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"deltype"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"delclasstype"});
        }
    }

    private void propertyChangedTypeGroup(ChangeData[] changeSet) {
        for (int i = 0; i < changeSet.length; ++i) {
            Object newValue = changeSet[i].getNewValue();
            if (!(newValue instanceof String)) continue;
            String comboStr = newValue.toString();
            if (StringUtils.equals((CharSequence)comboStr, (CharSequence)"C")) {
                this.setQtyTypeRelationIsUpdate(this.getModel());
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"replaceplan"});
                continue;
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"replaceplan"});
            this.getView().updateView("replaceplan");
        }
    }

    private void properChangedIsUpdate(ChangeData[] changeSet) {
        for (int i = 0; i < changeSet.length; ++i) {
            DynamicObject dataEntity = changeSet[i].getDataEntity();
            Object newValue = changeSet[i].getNewValue();
            boolean isUpdate = false;
            if (newValue instanceof Boolean) {
                isUpdate = (Boolean)newValue;
            }
            String filedNumber = MMCUtils.getDynamicObjectStringData((DynamicObject)dataEntity, (String)"filednumber");
            IDataModel dm = this.getModel();
            if (staticVariableInvalid) {
                DynamicObjectCollection entryDOC = dm.getEntryEntity(ENTRY_NAME);
                if (!entryDOC.isEmpty()) {
                    for (DynamicObject entryDO : entryDOC) {
                        int row = MMCUtils.getDynamicObjectIntegerData((DynamicObject)entryDO, (String)"seq");
                        String filedName = MMCUtils.getDynamicObjectStringData((DynamicObject)entryDO, (String)"filednumber");
                        this.initRelationRowIndex(filedName, row - 1);
                    }
                }
                staticVariableInvalid = false;
            }
            this.getRowIndexRelationFiled(this.getView(), this.getModel(), isUpdate, filedNumber);
        }
    }

    private void getRowIndexRelationFiled(IFormView fv, IDataModel dm, boolean isUpdate, String filedNumber) {
        if (fv == null || dm == null) {
            return;
        }
        Object filedEntry = dm.getValue(ENTRY_NAME);
        if (filedEntry instanceof DynamicObjectCollection) {
            switch (filedNumber) {
                case "entrymaterialattr_ctrl": {
                    this.setEntryIsUpdate(fv, dm, materialAttrRelation, isUpdate);
                    break;
                }
                case "entryqtytype": {
                    this.setEntryIsUpdate(fv, dm, qtyTypeRelation, isUpdate);
                    break;
                }
                case "qtyentry": {
                    this.setEntryIsUpdate(fv, dm, qtyEntryRelation, isUpdate);
                    this.setEntryIsUpdate(fv, dm, qtyAndQtyTypeRelation, isUpdate);
                    break;
                }
                case "setupentry": {
                    this.setEntryIsUpdate(fv, dm, setupEntryRelation, isUpdate);
                    break;
                }
                case "subentryentity": {
                    this.setEntryIsUpdate(fv, dm, configCodeRelation, isUpdate);
                    break;
                }
                case "workstationentry": {
                    this.setEntryIsUpdate(fv, dm, workstationRelation, isUpdate);
                    break;
                }
                case "entryqtynumerator": 
                case "entryqtydenominator": {
                    this.setEntryIsUpdate(fv, dm, qtyRelation, isUpdate);
                    break;
                }
                case "entryprocessseq_ctrl": 
                case "entryoperationnumber_ctrl": {
                    this.setEntryIsUpdate(fv, dm, operationRelation, isUpdate);
                    break;
                }
                case "entryownertype_ctrl": 
                case "entryowner_ctrl": {
                    this.setEntryIsUpdate(fv, dm, ownerRelation, isUpdate);
                    break;
                }
                case "entryisbulkmaterial_ctrl": {
                    this.setEntryIsUpdate(fv, dm, isbulkmaterialRelation, isUpdate);
                    break;
                }
                case "entryoutorg_ctrl": {
                    this.setEntryIsUpdate(fv, dm, outWareOrgRelation, isUpdate);
                }
                case "entryoutwarehouse_ctrl": 
                case "entryoutlocation_ctrl": {
                    this.setEntryIsUpdate(fv, dm, outWarehouseRelation, isUpdate);
                    break;
                }
                case "entrysupplyorg_ctrl": 
                case "entrywarehouse_ctrl": 
                case "entrylocation_ctrl": {
                    this.setEntryIsUpdate(fv, dm, defultSupplyOrgRelation, isUpdate);
                    break;
                }
            }
        }
    }

    private void setEntryIsUpdate(IFormView fv, IDataModel dm, Map<String, Integer> ralationMap, boolean isUpdate) {
        if (fv == null || dm == null || ralationMap == null) {
            return;
        }
        for (Map.Entry<String, Integer> entry : ralationMap.entrySet()) {
            int row = entry.getValue();
            if (row <= -1) continue;
            dm.setValue("isupdate", (Object)isUpdate, row);
        }
    }

    private void handleBomFilter(IDataModel dm, ChangeData changeData, String propFrom, String propTo) {
        if (changeData == null || StringUtils.isEmpty((CharSequence)propFrom) || StringUtils.isEmpty((CharSequence)propTo)) {
            return;
        }
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        DynamicObjectCollection newValueColl = new DynamicObjectCollection();
        if (newValue != null) {
            newValueColl = (DynamicObjectCollection)newValue;
        }
        if (newValueColl.size() != 1) {
            dm.setValue(propTo, null);
            if (newValueColl.isEmpty()) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{propTo});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{propTo});
            }
            return;
        }
        this.getView().setEnable(Boolean.valueOf(true), new String[]{propTo});
        DynamicObjectCollection oldValueColl = new DynamicObjectCollection();
        if (oldValue instanceof DynamicObjectCollection) {
            oldValueColl = (DynamicObjectCollection)oldValue;
        }
        DynamicObject newValueOne = new DynamicObject();
        for (DynamicObject dynamicObject : newValueColl) {
            Object baseObj = dynamicObject.get("fbasedataid");
            if (!(baseObj instanceof DynamicObject)) continue;
            newValueOne = (DynamicObject)dynamicObject.get("fbasedataid");
        }
        Object toObj = dm.getValue(propTo);
        if (newValueOne != null && toObj == null) {
            Object pkValue = newValueOne.getPkValue();
            Long pk = 0L;
            if (pkValue instanceof Long) {
                pk = (Long)pkValue;
            }
            dm.setValue(propTo, (Object)pk);
            this.getView().updateView(propTo);
        }
    }

    private static void initRelationsMap() {
        RELATIONMAP.put("materialAttrRelation", materialAttrRelation);
        RELATIONMAP.put("qtyTypeRelation", qtyTypeRelation);
        RELATIONMAP.put("qtyEntryRelation", qtyEntryRelation);
        RELATIONMAP.put("qtyAndQtyTypeRelation", qtyAndQtyTypeRelation);
        RELATIONMAP.put("setupEntryRelation", setupEntryRelation);
        RELATIONMAP.put("configCodeRelation", configCodeRelation);
        RELATIONMAP.put("workstationRelation", workstationRelation);
        RELATIONMAP.put("locationRelation", locationRelation);
        RELATIONMAP.put("qtyRelation", qtyRelation);
        RELATIONMAP.put("operationRelation", operationRelation);
        RELATIONMAP.put("ownerRelation", ownerRelation);
        RELATIONMAP.put("isbulkmaterialRelation", isbulkmaterialRelation);
        RELATIONMAP.put("outWarehouseRelation", outWarehouseRelation);
        RELATIONMAP.put("outWareOrgRelation", outWareOrgRelation);
        RELATIONMAP.put("defultSupplyOrgRelation", defultSupplyOrgRelation);
    }

    static {
        String[] noShow = new String[]{"entryconfiguredcode", "qtyopt", "opt", "preferopt", "mutuexcopt", "minqtyopt", "maxqtyopt", "entryseq", "configproperties", "new_entrymaterialidmod_r", "entrymaterialidmodel_r", "new_entryconfiguredcode", "new_entrymaterialmodel_r", "new_entrymaterialid", "new_entrymaterialid_r", "entrymaterialattr_ctrl", "changetype_qty", "changetype_ctrl", "changetype_set", "changetype", "entrytype", "entrymaterial", "entrymaterialname_r", "new_entrymaterial", "new_entrymaterialname_r", "featuretype", "entrymaterialid", "entrymaterialmodel_r", "entrymaterialidname_r", "entryqty", "entryunit", "entryversion", "new_entryversion", "entryvaliddate", "entryecnno", "entryecnid", "entryecn", "entryecnverionm", "entryecnvaliddatem", "entryecnverion", "entryecnvaliddate", "entryauxproperty", "new_entryauxproperty", "entryprocessseq", "entryoperationnumber", "entrymaterialattr", "entryisjumplevel", "entryownertype", "entryowner", "entryissuemode", "entryiskey", "entryisstockalloc", "entryoutorg", "entryoutwarehouse", "entryoutlocation", "entryreplaceplan", "repacetype", "reppriority", "entryisreplaceplanmm", "entryreplacegroup", "entryisbulkmaterial", "entryisbackflush", "entryleadtime", "entrytimeunit", "entrysupplytype", "entrysupplyorg", "entrysupplymode", "entrywarehouse", "entrylocation", "entrynumber", "material_rowflag", "entryseq_ctrl", "entrymaterial_ctrl", "entrymaterialname_ctrl", "entrymaterialmodel_ctrl", "entryunit_ctrl", "entryqtytype_ctrl", "entrytimeunit_ctrl", "entrysupplytype_ctrl", "entryreplaceplan_ctrl", "entryreplaceplanname", "entryreplaceplanstrategy", "entryisreplaceplanmm_ctrl", "reppriority_ctrl", "repacetype_ctrl", "qtyentry_rowflag", "entryseq_qty", "entrymaterial_qty", "entrymaterialname_qty", "entrymaterialmodel_qty", "entryunit_qty", "entrymaterialattr_qty", "entryprocessseq_qty", "entryoperationnumber_qty", "qtyentrykey", "setupentry_rowflag", "entryseq_set", "entrymaterial_set", "entrymaterialname_set", "entrymaterialmodel_set", "entryunit_set", "entrymaterialattr_set", "entryprocessseq_set", "entryoperationnumber_set", "entryqty_set", "setupentrykey", "changetype_rulctl", "entryseq_rulctl", "entrymaterial_rulctl", "entrymaterialname_rulctl", "entrymaterialmodel_rulctl", "entryunit_rulctl", "changetype_ws", "entrymaterial_ws", "entrymaterialname_ws", "entrymaterialmodel_ws", "entryunit_ws"};
        noShowField = Arrays.asList(noShow);
        materialAttrRelation.put("entryqtytype", -1);
        materialAttrRelation.put("entryisjumplevel_ctrl", -1);
        qtyTypeRelation.put("qtyentry", -1);
        String[] qtyEntryRelationS = new String[]{"qtyentrybatchstartqty", "qtyentrybatchendqty", "qtyentryisstepfix", "qtyentryqtynumerator", "qtyentryqtydenominator", "qtyentryfixscrap", "qtyentryscraprate"};
        BatchMFTBomEditPlugin.initRelationField(qtyEntryRelation, qtyEntryRelationS);
        qtyAndQtyTypeRelation.put("entryqtytype", -1);
        String[] setupEntryRelationS = new String[]{"setupentrysetuplocation", "setupentryqty", "setupentryremark"};
        BatchMFTBomEditPlugin.initRelationField(setupEntryRelation, setupEntryRelationS);
        String[] configCodeRelationS = new String[]{"chararuleno", "chararulename", "chararulegroup", "chararuleclassify", "chararuletype", "chararuleformulaalias"};
        BatchMFTBomEditPlugin.initRelationField(configCodeRelation, configCodeRelationS);
        String[] workstationRelationS = new String[]{"workcenter", "workstation", "workentryqty"};
        BatchMFTBomEditPlugin.initRelationField(workstationRelation, workstationRelationS);
        locationRelation.put("entrywarehouse_ctrl", -1);
        qtyRelation.put("entryqtynumerator", -1);
        qtyRelation.put("entryqtydenominator", -1);
        operationRelation.put("entryprocessseq_ctrl", -1);
        operationRelation.put("entryoperationnumber_ctrl", -1);
        ownerRelation.put("entryownertype_ctrl", -1);
        ownerRelation.put("entryowner_ctrl", -1);
        isbulkmaterialRelation.put("entryissuemode_ctrl", -1);
        String[] outWarehouseRelationS = new String[]{"entryoutorg_ctrl", "entryoutwarehouse_ctrl", "entryoutlocation_ctrl"};
        BatchMFTBomEditPlugin.initRelationField(outWarehouseRelation, outWarehouseRelationS);
        outWareOrgRelation.put("entryisstockalloc_ctrl", -1);
        String[] defultSupplyOrgRelations = new String[]{"entrysupplyorg_ctrl", "entrywarehouse_ctrl", "entrylocation_ctrl"};
        BatchMFTBomEditPlugin.initRelationField(defultSupplyOrgRelation, defultSupplyOrgRelations);
        BatchMFTBomEditPlugin.initRelationsMap();
    }
}

