/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.eco;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.query.helper.MaterialMftQueryHelper;
import kd.bd.mpdm.common.utils.DynamicObjDataUtil;
import kd.bd.mpdm.common.utils.ECNLocalCacheUtils;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.business.ecoplatform.EcoUtils;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.common.bom.ecoroute.EcoCommonHelper;
import kd.mmc.pdm.common.enums.StatusEnum;
import kd.mmc.pdm.common.util.BOMVersionUtil;
import kd.mmc.pdm.common.util.MMCUtils;
import kd.mmc.pdm.common.util.PdmParamSetHelper;

public class ECOBaseEditPlugin
extends AbstractBillPlugIn {
    private static final Log logger = LogFactory.getLog(ECOBaseEditPlugin.class);
    public static final String OPERATION_SAVE = "save";
    public static final String OPERATION_AUDIT = "audit";
    public static final String OPERATION_COPY = "copy";
    public static final String OPERATION_NEW = "new";
    public static final String OPERATION_NEXTPENTRY = "nextpentry";
    public static final String OPERATION_PREVPENTRY = "prevpentry";
    public static final String OPERATION_SUBMIT = "submit";
    public static final String OPERATION_UNAUDIT = "unaudit";
    public static final String OPERATION_UNSUBMIT = "unsubmit";
    public static final String PAGECACHE_TYPE = "pc_type";
    public static final String PAGECACHE_CHANGETYPE = "pc_changetype";
    public static final String PROP_BILLSTATUS = "billstatus";
    public static final String PROP_ORG = "org";
    public static final String PROP_CHANGETYPE = "changetype";
    public static final String PROP_PENTRYROUTE = "pentryroute";
    public static final String PROP_PENTRYROUTENAME = "pentryroutename";
    public static final String PROP_ECOROUTEID = "ecorouteid";
    public static final String PROP_ECOROUTEDATA = "ecoroutedata";
    public static final String PROP_PENTRYOLDRTVERSION = "pentryoldrtversion";
    public static final String PROP_PENTRYNEWRTVERSION = "pentrynewrtversion";
    public static final String PROP_ENTRYBOMENTRYID = "entrybomentryid";
    public static final String PROP_ENTRYBOM = "entrybom";
    public static final String PROP_ENTRYINVALIDDATE = "entryinvaliddate";
    public static final String PROP_ENTRYMODE = "entrymode";
    public static final String PROP_ENTRYVALIDDATE = "entryvaliddate";
    public static final String PROP_PENTRY = "pentry";
    public static final String PROP_PENTRYBOM = "pentrybom";
    public static final String PROP_PENTRYECNVERSION = "pentryecnversion";
    public static final String PROP_PENTRYECREASON = "pentryecreason";
    public static final String PROP_PENTRYEXECDATE = "pentryexecdate";
    public static final String PROP_PENTRYEXECMODE = "pentryexecmode";
    public static final String PROP_PENTRYEXECSTATUS = "pentryexecstatus";
    public static final String PROP_PENTRYMATERIALMODEL = "pentrymaterialmodel";
    public static final String PROP_PENTRYNEWVERSION = "pentrynewversion";
    public static final String PROP_PENTRYECN = "pentryecn";
    public static final String PROP_PENTRYOLDVERSION = "pentryoldversion";
    public static final String PROP_PENTRYREPLACENO = "pentryreplaceno";
    public static final String PROP_PENTRYSEQ = "pentryseq";
    public static final String PROP_PENTRYVALIDDATE = "pentryvaliddate";
    public static final String PROP_PENTRYVERSIONCONTROL = "entryversioncontrol";
    public static final String PROP_QTYENTRYSRCID = "qtyentrysrcid";
    public static final String PROP_SETUPENTRYSRCID = "setupentrysrcid";
    public static final String PROP_ECOTYPE = "ecotype";
    public static final String PROP_TYPE = "type";
    public static final String TAB_CHANGE = "tab_change";
    public static final String TABPAGE_PENTRY = "tabpage_pentry";
    public static final String TB_PENTRY = "acptb_pentry";
    public static final String TBI_PENTRYDELETE = "acptbi_pentry_delete";
    public static final String TBI_PENTRYINSERT = "acptbi_pentry_insert";
    public static final String TBI_PENTRYNEW = "acptbi_pentry_new";
    public static final String PRDENTRYVALIDDATE = "prdentryvaliddate";
    public static final String TABPAGESETUPENTRY = "tabpage_setupentry";
    public static final String PROP_PROENTRYMATERIAL = "proentrymaterial";
    public static final String PROP_PROENTRYMATERIALID = "proentrymaterialid";
    public static final String PROP_ECOBOMID = "ecobomid";
    public static final String PROP_ECOBOMDATA = "ecobomdata";
    public static final String PROP_BOMTYPE = "bomtype";
    public static final String PROP_ENTRY = "entry";
    public static final String PROP_COPENTRY = "copentry";
    public static final String PDM_ECOBOM = "pdm_ecobom";
    public static final String PDM_ECOROUTE = "pdm_ecoroute";
    public static final String BD_BOMVERSION_NEW = "bd_bomversion_new";
    public static final String ENTRYINFO = "entryinfo";
    public static final String PDM_MFTBOM = "pdm_mftbom";
    public static final String PDM_ROUTE = "pdm_route";
    public static final String PDM_MMC_ECO_ENTRYINFO = "mmc_eco_entryinfo";
    public static final String MMC_PDM_SELECTBOMID = "mmc_pdm_selectbomid";
    public static final String PROP_AUXPROPERTY = "auxproperty";
    public static final String PROP_BOMAUXPROPERTY = "bomauxproperty";
    public static final String PROP_NUMBER = "number";
    public static final String CHILDCHANGE = "childChange";
    public static final String CLOSECONFIRM = "closeConfirm";
    public static final String SKIPCHECK = "skipCheck";
    public static final String PROP_PURPOSE = "purpose";
    public static final String PC_LASTINDEX = "lastindex";
    public static final String PC_LASTINDEX_CHANGETYPE = "lastindexchangetype";
    public static final String PC_LAST_OPENKEYSTRING = "lastopenkeystring";
    public static final String PROP_SERIALIZCACHETYPE = "SerializeCacheType";
    public static final String PROP_CREATEORG = "createorg";

    public String getControlVersion(int seq) {
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        return String.valueOf(dm.getValue(PROP_PENTRYVERSIONCONTROL, seq - 1));
    }

    public String getSerialiationCacheType() {
        IPageCache pc = this.getPageCache();
        String cacheType = pc.get(PROP_SERIALIZCACHETYPE);
        if (StringUtils.isEmpty((String)cacheType)) {
            cacheType = PdmParamSetHelper.getStringParamValue((String)PROP_SERIALIZCACHETYPE);
            if (StringUtils.isEmpty((String)cacheType)) {
                cacheType = "pgcache";
            }
            pc.put(PROP_SERIALIZCACHETYPE, cacheType);
        }
        return cacheType;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getSerialiationCacheType();
        this.getIsDisableGroupno();
        this.setChangeTypeEnable();
    }

    public boolean isLcCacheType() {
        String cacheType = this.getSerialiationCacheType();
        return "lccache".equalsIgnoreCase(cacheType);
    }

    public String getIsDisableGroupno() {
        IPageCache pc = this.getPageCache();
        String isDisableGroupno = pc.get("isDisableGroupno");
        if (StringUtils.isEmpty((String)isDisableGroupno)) {
            isDisableGroupno = PdmParamSetHelper.getStringParamValue((String)"ECN_DisableGroupNo");
            if (StringUtils.isEmpty((String)isDisableGroupno)) {
                isDisableGroupno = "true";
            }
            pc.put("isDisableGroupno", isDisableGroupno);
        }
        return isDisableGroupno;
    }

    public void setChangeTypeEnable() {
        Long billId;
        boolean isEnable = true;
        Object id = this.getModel().getDataEntity().getPkValue();
        if (id != null && !PlatformUtils.isNullLong((Long)(billId = (Long)id))) {
            isEnable = !QueryServiceHelper.exists((String)"pdm_bom_eco", (Object)billId);
        }
        this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{PROP_CHANGETYPE});
    }

    public void clearEhCacheData(Set<Long> keyLongSet, String serialiationCacheType) {
        if (this.isLcCacheType()) {
            if (keyLongSet == null) {
                keyLongSet = this.getEcoBomIdSet();
            }
            if (!keyLongSet.isEmpty()) {
                HashSet<String> keyStringSet = new HashSet<String>(keyLongSet.size());
                for (Long id : keyLongSet) {
                    keyStringSet.add(String.valueOf(id));
                }
                ECNLocalCacheUtils.clearLocalCtrlCache(keyStringSet);
            }
        }
    }

    public Set<Long> getEcoBomIdSet() {
        IFormView view = this.getView();
        IDataModel dm = view.getModel();
        DynamicObjectCollection pentry = dm.getEntryEntity(PROP_PENTRY);
        HashSet<Long> ecoBomIdSet = new HashSet<Long>(16);
        if (pentry != null && !pentry.isEmpty()) {
            for (int i = 0; i < pentry.size(); ++i) {
                DynamicObject entry = (DynamicObject)pentry.get(i);
                Long ecoBomId = entry.getLong(PROP_ECOBOMID);
                if (ecoBomId != null && !ecoBomId.equals(0L)) {
                    ecoBomIdSet.add(ecoBomId);
                }
                if ((ecoBomId = Long.valueOf(entry.getLong(PROP_ECOROUTEID))) == null || ecoBomId.equals(0L)) continue;
                ecoBomIdSet.add(ecoBomId);
            }
        }
        return ecoBomIdSet;
    }

    public boolean isNeedMaterialMft(DynamicObject bomType) {
        if (bomType == null) {
            return false;
        }
        String purpose = bomType.getString(PROP_PURPOSE);
        return "A".equals(purpose) || "C".equals(purpose);
    }

    public DynamicObject getDefaultEcoType() {
        DynamicObject org = (DynamicObject)this.getView().getModel().getValue(PROP_ORG);
        if (org == null) {
            return null;
        }
        if (this.isRouteChange()) {
            return EcoUtils.getDefaultEcoTypeByRt((Long)org.getLong("id"));
        }
        return EcoUtils.getDefaultEcoType((Long)org.getLong("id"));
    }

    public String getChangeType() {
        Object changeType = this.getView().getModel().getValue(PROP_CHANGETYPE);
        return changeType == null ? "A" : (String)changeType;
    }

    public boolean isBomChange() {
        return "A".equals(this.getChangeType());
    }

    public boolean isRouteChange() {
        return "B".equals(this.getChangeType());
    }

    public String getSubEntryNumber() {
        if (this.isRouteChange()) {
            return "processentry";
        }
        if (this.isBomChange()) {
            return PROP_ENTRY;
        }
        return "dtbmaterentry";
    }

    public String getShowSubEntryNumber() {
        if (this.isRouteChange()) {
            return "processentry1";
        }
        if (this.isBomChange()) {
            return PROP_ENTRY;
        }
        return "dtbmaterentry";
    }

    public String getEntryModeField(String subEntryNumber) {
        if (this.isRouteChange()) {
            return this.isShowProcessEntry(subEntryNumber) ? "entrymode3" : PROP_ENTRYMODE;
        }
        return this.isCopEntry(subEntryNumber) ? "copentrymode" : PROP_ENTRYMODE;
    }

    public String getActtimeField(String subEntryNumber) {
        if (this.isRouteChange()) {
            return this.isShowProcessEntry(subEntryNumber) ? "acttime3" : "acttime";
        }
        return this.isCopEntry(subEntryNumber) ? "copacttime" : "acttime";
    }

    public boolean isShowProcessEntry(String subEntryNumber) {
        return "processentry1".equals(subEntryNumber);
    }

    public boolean isCopEntry(String subEntryNumber) {
        return PROP_COPENTRY.equals(subEntryNumber);
    }

    public String getEntryValidDateField(String subEntryNumber) {
        if (this.isRouteChange()) {
            return this.isShowProcessEntry(subEntryNumber) ? "entryvaliddate3" : PROP_ENTRYVALIDDATE;
        }
        return this.isCopEntry(subEntryNumber) ? "copentryvaliddate" : PROP_ENTRYVALIDDATE;
    }

    public String getEcoBomIdField() {
        if (this.isRouteChange()) {
            return PROP_ECOROUTEID;
        }
        return PROP_ECOBOMID;
    }

    public String getEntityByChangeType() {
        if (this.isRouteChange()) {
            return PDM_ROUTE;
        }
        return PDM_MFTBOM;
    }

    public String getEcoEntityByChangeType() {
        if (this.isRouteChange()) {
            return PDM_ECOROUTE;
        }
        return PDM_ECOBOM;
    }

    public Set<String> getUnInCludeFieldSet() {
        HashSet<String> field = new HashSet<String>(16);
        field.add("id");
        field.add(PROP_CREATEORG);
        return field;
    }

    public List<Long> getIdFromReturnValue(ListSelectedRowCollection returnLSRC) {
        ArrayList<Long> returnBOMPKList = new ArrayList<Long>(16);
        for (ListSelectedRow returnLSR : returnLSRC) {
            Object returnPKObj = returnLSR.getPrimaryKeyValue();
            if (returnPKObj == null || returnBOMPKList.contains((Long)returnPKObj)) continue;
            returnBOMPKList.add((Long)returnPKObj);
        }
        return returnBOMPKList;
    }

    public Set<String> getPurseSet() {
        DynamicObjectCollection pentrys = this.getModel().getEntryEntity(PROP_PENTRY);
        HashSet<String> bomTypePurseSet = new HashSet<String>(16);
        int size = pentrys.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject bomType = ((DynamicObject)pentrys.get(i)).getDynamicObject(PROP_BOMTYPE);
            if (bomType == null) continue;
            bomTypePurseSet.add(bomType.getString(PROP_PURPOSE));
        }
        return bomTypePurseSet;
    }

    public Long getEcoBomId(DynamicObject entryDO) {
        if (entryDO == null) {
            return 0L;
        }
        if (this.isBomChange()) {
            return entryDO.getLong(PROP_ECOBOMID);
        }
        return entryDO.getLong(PROP_ECOROUTEID);
    }

    public Long getDynamicObjectId(DynamicObject data) {
        if (data != null) {
            return (Long)data.getPkValue();
        }
        return 0L;
    }

    public boolean checkIsExistsDB(String ecoBomId) {
        return QueryServiceHelper.exists((String)this.getEcoEntityByChangeType(), (Object)Long.valueOf(ecoBomId));
    }

    public BasedataProp getBomOrRouteBaseProp(String fieldNumber) {
        DynamicProperty pEntryBOMDP;
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        MainEntityType met = dm.getDataEntityType();
        DynamicProperty pEntryDP = met.getProperty(PROP_PENTRY);
        EntryProp pEntryEP = pEntryDP == null ? null : (pEntryDP instanceof EntryProp ? (EntryProp)pEntryDP : null);
        DynamicObjectType pEntryDOT = pEntryEP == null ? null : pEntryEP.getDynamicCollectionItemPropertyType();
        DynamicProperty dynamicProperty = pEntryBOMDP = pEntryDOT == null ? null : pEntryDOT.getProperty(fieldNumber);
        return pEntryBOMDP == null ? null : (pEntryBOMDP instanceof BasedataProp ? (BasedataProp)pEntryBOMDP : null);
    }

    public Set<Long> getBomOrRouteIdSet(String fieldNumber, IDataModel dm) {
        HashSet<Long> bomPKSet = new HashSet<Long>(16);
        DynamicObjectCollection pEntryDOC = dm.getEntryEntity(PROP_PENTRY);
        int pEntryDOCSize = MMCUtils.isEmptyList((List)pEntryDOC) ? 0 : pEntryDOC.size();
        for (int index = 0; index < pEntryDOCSize; ++index) {
            Object pEntryBOMDOPKObj;
            DynamicObject pEntryDO = (DynamicObject)pEntryDOC.get(index);
            DynamicObject pEntryBOMDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)pEntryDO, (String)fieldNumber);
            Object object = pEntryBOMDOPKObj = pEntryBOMDO == null ? null : pEntryBOMDO.getPkValue();
            if (pEntryBOMDOPKObj == null) continue;
            bomPKSet.add((Long)pEntryBOMDOPKObj);
        }
        return bomPKSet;
    }

    public DynamicObject getMaterialMasterByRow(IDataModel dm, int rowIndex) {
        DynamicObject pEntryBOMMaterialDO = MMCUtils.getDataModelDynamicObjectData((IDataModel)dm, (String)PROP_PROENTRYMATERIALID, (int)rowIndex);
        if (pEntryBOMMaterialDO != null) {
            return pEntryBOMMaterialDO;
        }
        DynamicObject pEntryBOMMFTInfoDO = MMCUtils.getDataModelDynamicObjectData((IDataModel)dm, (String)PROP_PROENTRYMATERIAL, (int)rowIndex);
        if (pEntryBOMMFTInfoDO != null) {
            return pEntryBOMMFTInfoDO.getDynamicObject("masterid");
        }
        return null;
    }

    public boolean isAdjustActtime(DynamicObject ecoType) {
        return ecoType == null ? Boolean.FALSE.booleanValue() : ecoType.getBoolean("adjustacttime");
    }

    public DynamicObject getMaterialMasterByObject(Object materialMft) {
        if (materialMft != null) {
            DynamicObject mft;
            if (materialMft instanceof DynamicObject) {
                return ((DynamicObject)materialMft).getDynamicObject("masterid");
            }
            if (materialMft instanceof Long && (mft = MaterialMftQueryHelper.getDataCacheByID((Object)materialMft)) != null) {
                return mft.getDynamicObject("masterid");
            }
        }
        return null;
    }

    public QFilter getMaterialIdFilter(int rowIndex) {
        IFormView view = this.getView();
        IDataModel dm = view.getModel();
        QFilter filter = null;
        if (this.isBomChange()) {
            DynamicObject typeObj = (DynamicObject)dm.getValue(PROP_BOMTYPE, rowIndex);
            if (typeObj == null) {
                return filter;
            }
            String purpose = typeObj.getString(PROP_PURPOSE);
            String configType = typeObj.getString("configtype");
            if ("B".equals(purpose)) {
                ArrayList<String> list = new ArrayList<String>(10);
                list.add("2");
                if (!"B".equals(configType)) {
                    list.add("3");
                }
                filter = new QFilter("configproperties", "in", list);
            } else if ("C".equals(purpose)) {
                filter = new QFilter("configproperties", "=", (Object)"2");
            } else if ("A".equals(purpose)) {
                ArrayList<String> list = new ArrayList<String>(10);
                list.add("");
                list.add("1");
                filter = new QFilter("configproperties", "in", list);
            }
        }
        return filter;
    }

    public String getChangeDescByChangeTypeA(String number) {
        if (this.isRouteChange()) {
            return String.format(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u5de5\u5e8f\u4fe1\u606f\u3002", (String)"ECOBaseEditPlugin_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), number);
        }
        return String.format(ResManager.loadKDString((String)"BOM\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u7ec4\u4ef6\u4fe1\u606f\u3002", (String)"ECOBaseEditPlugin_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), number);
    }

    public String getChangeDescByChangeTypeB(String number) {
        if (this.isRouteChange()) {
            return String.format(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684", (String)"ECOBaseEditPlugin_2", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), number);
        }
        return String.format(ResManager.loadKDString((String)"BOM\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684", (String)"ECOBaseEditPlugin_3", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), number);
    }

    public List<DynamicObject> setSubMaterial(List<DynamicObject> saveDataList, DynamicObject org) {
        for (DynamicObject obj : saveDataList) {
            DynamicObjectCollection entry = obj.getDynamicObjectCollection(PROP_ENTRY);
            block1: for (DynamicObject subobj : entry) {
                String entryMode;
                DynamicObject entrymaterial = subobj.getDynamicObject("entrymaterial");
                subobj.set("entryseq", subobj.get("seq"));
                if (null != entrymaterial) {
                    subobj.set("entrymaterialid", entrymaterial.get("masterid"));
                } else {
                    DynamicObject materialmft;
                    DynamicObject entrymaterialid = subobj.getDynamicObject("entrymaterialid");
                    if (entrymaterialid != null && (materialmft = MaterialMftQueryHelper.getDataCacheByMaterialID((Long)entrymaterialid.getLong("id"), (Long)obj.getDynamicObject(PROP_CREATEORG).getLong("id"), null)) != null) {
                        subobj.set("entrymaterial", (Object)materialmft);
                    }
                }
                if (!"B".equals(entryMode = subobj.getString(PROP_ENTRYMODE))) continue;
                Long bomentryId = subobj.getLong(PROP_ENTRYBOMENTRYID);
                for (DynamicObject subobj2 : entry) {
                    String entryMode2 = subobj2.getString(PROP_ENTRYMODE);
                    Long bomentryId2 = subobj2.getLong(PROP_ENTRYBOMENTRYID);
                    if (!"C".equals(entryMode2) || !bomentryId2.equals(bomentryId)) continue;
                    subobj.set("entryrefno", (Object)subobj2.getString("entryrefno"));
                    subobj.set("entrygroupno", (Object)subobj2.getString("entrygroupno"));
                    continue block1;
                }
            }
            obj.set(PROP_ENTRY, (Object)entry);
            DynamicObjectCollection copentry = obj.getDynamicObjectCollection(PROP_COPENTRY);
            for (DynamicObject subobj : copentry) {
                subobj.set("copentryseq", subobj.get("seq"));
            }
        }
        return saveDataList;
    }

    public void doSecondSaveDeal() {
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        DynamicObjectCollection pentry = dm.getEntryEntity(PROP_PENTRY);
        Object billIdObj = dm.getDataEntity().getPkValue();
        if (billIdObj == null) {
            return;
        }
        Long billId = (Long)billIdObj;
        if (billId.equals(0L)) {
            return;
        }
        QFilter filter = new QFilter("id", "=", (Object)billId);
        DynamicObject bomeco = BusinessDataServiceHelper.loadSingle((String)"pdm_bom_eco", (String)"id,billno,pentry.ecobomid,pentry.pentrybom,pentry.pentryroute,pentry.entryversioncontrol,pentry.pentrynewversion,pentry.pentrynewrtversion,pentry.ecorouteid", (QFilter[])new QFilter[]{filter});
        if (null == bomeco) {
            return;
        }
        String oldBillno = bomeco.getString("billno");
        String newBillno = dm.getValue("billno").toString();
        DynamicObjectCollection ecoPentry = bomeco.getDynamicObjectCollection(PROP_PENTRY);
        if (ecoPentry.isEmpty()) {
            return;
        }
        HashSet<String> billnoSet = new HashSet<String>(16);
        billnoSet.add(oldBillno);
        billnoSet.add(newBillno);
        boolean isBomChange = this.isBomChange();
        boolean isRouteChange = this.isRouteChange();
        ArrayList<String> oldIdList = new ArrayList<String>(16);
        HashMap<String, DynamicObject> enOldMap = new HashMap<String, DynamicObject>(16);
        HashMap<String, DynamicObject> enOldBomMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject obj : ecoPentry) {
            if (isBomChange) {
                String versionCtrl = obj.getString(PROP_PENTRYVERSIONCONTROL);
                String ecobomid = obj.getString(PROP_ECOBOMID);
                if ("B".equals(versionCtrl)) {
                    enOldMap.put(ecobomid, obj.getDynamicObject(PROP_PENTRYNEWVERSION));
                    enOldBomMap.put(ecobomid, obj.getDynamicObject(PROP_PENTRYBOM));
                }
                oldIdList.add(ecobomid);
                continue;
            }
            if (!isRouteChange) continue;
            String ecorouteid = obj.getString(PROP_ECOROUTEID);
            oldIdList.add(ecorouteid);
            String versionCtrl = obj.getString(PROP_PENTRYVERSIONCONTROL);
            if (!"B".equals(versionCtrl)) continue;
            enOldMap.put(ecorouteid, obj.getDynamicObject(PROP_PENTRYNEWRTVERSION));
            enOldBomMap.put(ecorouteid, obj.getDynamicObject(PROP_PENTRYROUTE));
        }
        ArrayList<String> newIdList = new ArrayList<String>(16);
        ArrayList<Object> removeKey = new ArrayList<Object>(16);
        for (DynamicObject obj : pentry) {
            DynamicObject newVersion;
            DynamicObject newVersion2;
            String versionCtrl = obj.getString(PROP_PENTRYVERSIONCONTROL);
            if (isBomChange) {
                String ecobomid = obj.getString(PROP_ECOBOMID);
                newIdList.add(ecobomid);
                if (!oldIdList.contains(ecobomid)) continue;
                if (!"B".equals(versionCtrl)) {
                    newVersion2 = (DynamicObject)enOldMap.get(ecobomid);
                    if (newVersion2 == null) continue;
                    removeKey.add(newVersion2.getPkValue());
                    continue;
                }
                DynamicObject bom = obj.getDynamicObject(PROP_PENTRYBOM);
                DynamicObject oldBom = (DynamicObject)enOldBomMap.get(ecobomid);
                if (oldBom == null || bom.getPkValue().equals(oldBom.getPkValue()) || (newVersion = (DynamicObject)enOldMap.get(ecobomid)) == null) continue;
                removeKey.add(newVersion.getPkValue());
                continue;
            }
            if (!isRouteChange) continue;
            String ecorouteid = obj.getString(PROP_ECOROUTEID);
            newIdList.add(ecorouteid);
            if (!oldIdList.contains(ecorouteid)) continue;
            if (!"B".equals(versionCtrl)) {
                newVersion2 = (DynamicObject)enOldMap.get(ecorouteid);
                if (newVersion2 == null) continue;
                removeKey.add(newVersion2.getPkValue());
                continue;
            }
            DynamicObject route = obj.getDynamicObject(PROP_PENTRYROUTE);
            DynamicObject oldRoute = (DynamicObject)enOldBomMap.get(ecorouteid);
            if (oldRoute == null || route.getPkValue().equals(oldRoute.getPkValue()) || (newVersion = (DynamicObject)enOldMap.get(ecorouteid)) == null) continue;
            removeKey.add(newVersion.getPkValue());
        }
        if (!oldIdList.isEmpty()) {
            for (String newId : newIdList) {
                oldIdList.remove(newId);
            }
        }
        if (!oldIdList.isEmpty()) {
            for (String ecobomid : oldIdList) {
                DynamicObject newVersion = (DynamicObject)enOldMap.get(ecobomid);
                if (newVersion == null) continue;
                removeKey.add(newVersion.getPkValue());
            }
            this.deletVersionData(removeKey, billnoSet);
            this.deletEcoData(oldIdList, isBomChange);
        }
    }

    public void deletVersionData(List<Object> versionIdList, Set<String> billnoSet) {
        if (!versionIdList.isEmpty()) {
            QFilter qfilter = new QFilter("id", "in", versionIdList);
            qfilter.and(new QFilter("ecnbillno", "in", billnoSet));
            DeleteServiceHelper.delete((String)BD_BOMVERSION_NEW, (QFilter[])new QFilter[]{qfilter});
        }
    }

    public void deletEcoData(List<String> oldIdList, boolean isBomChange) {
        if (!oldIdList.isEmpty()) {
            List longList = oldIdList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            if (isBomChange) {
                DeleteServiceHelper.delete((String)PDM_ECOBOM, (QFilter[])new QFilter[]{new QFilter("id", "in", longList)});
            } else {
                DeleteServiceHelper.delete((String)PDM_ECOROUTE, (QFilter[])new QFilter[]{new QFilter("id", "in", longList)});
            }
            this.clearEhCacheData(new HashSet<Long>(longList), this.getSerialiationCacheType());
        }
    }

    public boolean checkReturnIdIsExists(Set<Long> returnIdSet, String fieldNumber) {
        DynamicObjectCollection pentrys = this.getModel().getEntryEntity(PROP_PENTRY);
        int size = pentrys.size();
        for (int i = 0; i < size; ++i) {
            Long id;
            DynamicObject pentDy = (DynamicObject)((DynamicObject)pentrys.get(i)).get(fieldNumber);
            if (pentDy == null || !returnIdSet.contains(id = (Long)pentDy.getPkValue())) continue;
            String msg = String.format(ResManager.loadKDString((String)"%1$s\u5df2\u5b58\u5728,\u8bf7\u52ff\u91cd\u590d\u9009\u62e9\u3002", (String)"ECOBaseEditPlugin_4", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), pentDy.getString(PROP_NUMBER));
            this.getView().showTipNotification(msg);
            return false;
        }
        return true;
    }

    public void setValueWithIgnoreChange(IDataModel dm, String fieldNumber, Object value, int rowIndex) {
        this.getPageCache().put("isIgnoreChangeListener", "true");
        dm.beginInit();
        if (rowIndex >= 0) {
            dm.setValue(fieldNumber, value, rowIndex);
        } else {
            dm.setValue(fieldNumber, value);
        }
        dm.endInit();
        if (rowIndex >= 0) {
            this.getView().updateView(fieldNumber, rowIndex);
        } else {
            this.getView().updateView(fieldNumber);
        }
        this.getPageCache().put("isIgnoreChangeListener", "true");
    }

    public DynamicObject genEcoBOMByPEntry(DynamicObject entryDO, int seq, Long ecoBomId) {
        String versionCtrl;
        String ebomstr;
        DynamicObject pentrybom = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)entryDO, (String)PROP_PENTRYBOM);
        String bomnumber = pentrybom == null ? null : MMCUtils.getDynamicObjectStringData((DynamicObject)pentrybom, (String)PROP_NUMBER);
        Long bomid = this.getDynamicObjectId(pentrybom);
        DynamicObject wbs = pentrybom == null ? null : MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)pentrybom, (String)"wbs");
        DynamicObject material = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)entryDO, (String)PROP_PROENTRYMATERIAL);
        DynamicObject masterialDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)entryDO, (String)PROP_PROENTRYMATERIALID);
        DynamicObject baseunitDO = masterialDO == null ? null : MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)masterialDO, (String)"baseunit");
        DynamicObject version = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)pentrybom, (String)"version");
        DynamicObject configuredcode = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)pentrybom, (String)"configuredcode");
        DynamicObject type = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)pentrybom, (String)PROP_TYPE);
        DynamicObject org = (DynamicObject)this.getModel().getValue(PROP_ORG);
        DynamicObject createorg = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)pentrybom, (String)PROP_CREATEORG);
        if (createorg == null) {
            createorg = org;
        }
        boolean iscoproduct = pentrybom == null ? Boolean.FALSE.booleanValue() : pentrybom.getBoolean("iscoproduct");
        Date validdate = MMCUtils.getDynamicObjectDateData((DynamicObject)entryDO, (String)PROP_PENTRYVALIDDATE);
        String serialiationCacheType = this.getSerialiationCacheType();
        DynamicObject ecobom = null;
        if (!PlatformUtils.isNullLong((Long)ecoBomId) && null != (ebomstr = this.getView().getPageCache().get(String.valueOf(ecoBomId)))) {
            ecobom = ECNLocalCacheUtils.deSerializeFromBase64((String)ebomstr, (String)serialiationCacheType);
        }
        if (ecobom == null) {
            ecobom = BusinessDataServiceHelper.newDynamicObject((String)PDM_ECOBOM);
            long fmmbomid = ORM.create().genLongId(PDM_ECOBOM);
            ecobom.set("id", (Object)fmmbomid);
        }
        ecobom.set(PROP_NUMBER, (Object)bomnumber);
        ecobom.set("material", (Object)material);
        ecobom.set("materialid", (Object)masterialDO);
        ecobom.set(PROP_CREATEORG, (Object)createorg);
        ecobom.set(PROP_TYPE, (Object)type);
        ecobom.set("version", (Object)version);
        ecobom.set("status", (Object)"A");
        ecobom.set("bomid", (Object)String.valueOf(bomid));
        ecobom.set(PROP_PENTRYVALIDDATE, (Object)validdate);
        ecobom.set("qtybaseunit", (Object)baseunitDO);
        ecobom.set("productno", (Object)(seq + 1));
        ecobom.set("configuredcode", (Object)configuredcode);
        ecobom.set("iscoproduct", (Object)iscoproduct);
        ecobom.set("wbs", (Object)wbs);
        if (pentrybom != null) {
            ecobom.set("bomid", pentrybom.getPkValue());
        }
        ecobom.set("optioncontrol", (Object)MMCUtils.getDynamicObjectStringData((DynamicObject)pentrybom, (String)"optioncontrol"));
        String string = versionCtrl = entryDO == null ? "A" : entryDO.getString(PROP_PENTRYVERSIONCONTROL);
        if (!"A".equals(versionCtrl)) {
            ecobom.set("ctrlstrategy", (Object)this.getDefaultCt());
        }
        if (StringUtils.isEmpty((String)ecobom.getString("ctrlstrategy"))) {
            ecobom.set("ctrlstrategy", (Object)(pentrybom == null ? this.getDefaultCt() : pentrybom.getString("ctrlstrategy")));
        }
        ecobom.set(PROP_ENTRY, null);
        ecobom.set(PROP_COPENTRY, null);
        return ecobom;
    }

    public DynamicObject genEcoRouteByPEntry(DynamicObject entryDO, int seq, Long ecoRouteId) {
        String versionCtrl;
        String ebomstr;
        DynamicObject pentryRoute = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)entryDO, (String)PROP_PENTRYROUTE);
        String routeNumber = pentryRoute == null ? null : MMCUtils.getDynamicObjectStringData((DynamicObject)pentryRoute, (String)PROP_NUMBER);
        String routeName = pentryRoute == null ? MMCUtils.getDynamicObjectStringData((DynamicObject)entryDO, (String)PROP_PENTRYROUTENAME) : MMCUtils.getDynamicObjectStringData((DynamicObject)pentryRoute, (String)"name");
        DynamicObject masterialDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)entryDO, (String)PROP_PROENTRYMATERIALID);
        DynamicObject baseunitDO = masterialDO == null ? null : MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)masterialDO, (String)"baseunit");
        DynamicObject org = (DynamicObject)this.getModel().getValue(PROP_ORG);
        DynamicObject createorg = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)pentryRoute, (String)PROP_CREATEORG);
        if (createorg == null) {
            createorg = org;
        }
        Date validdate = MMCUtils.getDynamicObjectDateData((DynamicObject)entryDO, (String)PROP_PENTRYVALIDDATE);
        String serialiationCacheType = this.getSerialiationCacheType();
        DynamicObject ecoRoute = null;
        if (!PlatformUtils.isNullLong((Long)ecoRouteId) && null != (ebomstr = this.getView().getPageCache().get(String.valueOf(ecoRouteId)))) {
            ecoRoute = ECNLocalCacheUtils.deSerializeFromBase64((String)ebomstr, (String)serialiationCacheType);
        }
        if (ecoRoute == null) {
            ecoRoute = BusinessDataServiceHelper.newDynamicObject((String)PDM_ECOROUTE);
            long fmmbomid = ORM.create().genLongId(PDM_ECOROUTE);
            ecoRoute.set("id", (Object)fmmbomid);
        }
        if (pentryRoute != null && !pentryRoute.containsProperty("routeversion")) {
            pentryRoute = BusinessDataServiceHelper.loadSingleFromCache((Object)pentryRoute.getPkValue(), (String)pentryRoute.getDynamicObjectType().getName());
        }
        ecoRoute.set(PROP_NUMBER, (Object)routeNumber);
        ecoRoute.set("name", (Object)routeName);
        ecoRoute.set(PROP_CREATEORG, (Object)createorg);
        ecoRoute.set("version", pentryRoute == null ? null : pentryRoute.getDynamicObject("version"));
        ecoRoute.set("routeversion", (Object)(pentryRoute == null ? entryDO.getDynamicObject(PROP_PENTRYNEWRTVERSION) : pentryRoute.getDynamicObject("routeversion")));
        ecoRoute.set("processtype", pentryRoute == null ? "A" : pentryRoute.get("processtype"));
        ecoRoute.set("material", (Object)masterialDO);
        ecoRoute.set("ismainprocess", (Object)(pentryRoute == null ? Boolean.TRUE.booleanValue() : pentryRoute.getBoolean("ismainprocess")));
        ecoRoute.set("routereplace", pentryRoute == null ? null : pentryRoute.getDynamicObject("routereplace"));
        ecoRoute.set("materialgroup", pentryRoute == null ? null : pentryRoute.getDynamicObject("materialgroup"));
        ecoRoute.set("unit", (Object)baseunitDO);
        ecoRoute.set(PROP_AUXPROPERTY, (Object)(pentryRoute == null ? Boolean.TRUE.booleanValue() : pentryRoute.getBoolean(PROP_AUXPROPERTY)));
        ecoRoute.set("configcode", (Object)(pentryRoute == null ? Boolean.TRUE.booleanValue() : pentryRoute.getBoolean("configcode")));
        ecoRoute.set("group", (Object)(pentryRoute == null ? Boolean.TRUE.booleanValue() : pentryRoute.getBoolean("group")));
        ecoRoute.set("status", (Object)"A");
        ecoRoute.set("enable", (Object)"1");
        ecoRoute.set(PROP_PENTRYVALIDDATE, (Object)validdate);
        ecoRoute.set("productno", (Object)(seq + 1));
        ecoRoute.set("routeid", (Object)(pentryRoute == null ? 0L : pentryRoute.getLong("id")));
        ecoRoute.set("wbs", (Object)(pentryRoute == null ? Long.valueOf(0L) : pentryRoute.getDynamicObject("wbs")));
        String string = versionCtrl = entryDO == null ? "A" : entryDO.getString(PROP_PENTRYVERSIONCONTROL);
        if (!"A".equals(versionCtrl)) {
            ecoRoute.set("ctrlstrategy", (Object)this.getDefaultCt());
        }
        if (StringUtils.isEmpty((String)ecoRoute.getString("ctrlstrategy"))) {
            ecoRoute.set("ctrlstrategy", (Object)(pentryRoute == null ? this.getDefaultCt() : pentryRoute.getString("ctrlstrategy")));
        }
        this.clearRouteEntry(ecoRoute);
        DynamicObjectCollection coll = ecoRoute.getDynamicObjectCollection("entryentity");
        if (PlatformUtils.isNullCollection((DynamicObjectCollection)coll)) {
            DynamicObject entryEntity = coll.addNew();
            entryEntity.set("processseq", (Object)1);
            entryEntity.set("processseqtype", (Object)"A");
            entryEntity.set("processseqname", (Object)ResManager.loadKDString((String)"\u4e3b\u5e8f\u5217", (String)"ECOBaseEditPlugin_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        }
        return ecoRoute;
    }

    public boolean isViewStatus() {
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        FormShowParameter fsp = fv.getFormShowParameter();
        OperationStatus os = fsp == null ? OperationStatus.VIEW : (fsp.getStatus() == null ? OperationStatus.VIEW : fsp.getStatus());
        String billStatus = MMCUtils.getDataModelStringData((IDataModel)dm, (String)PROP_BILLSTATUS, (String)StatusEnum.AUDITED.getValue());
        return os.getValue() == OperationStatus.VIEW.getValue() || billStatus.equals(StatusEnum.SUBMITED.getValue()) || billStatus.equals(StatusEnum.AUDITED.getValue());
    }

    public void clearRouteEntry(DynamicObject ecoRoute) {
        ecoRoute.set("processentry", null);
    }

    public DynamicObject setEcoDataByPentry(DynamicObject pentry, DynamicObject fmmEcobom, Map<Long, DynamicObject> existEcoBomMap) {
        DynamicObject material = pentry.getDynamicObject(PROP_PROENTRYMATERIAL);
        DynamicObject materialid = pentry.getDynamicObject(PROP_PROENTRYMATERIALID);
        boolean isBomChange = this.isBomChange();
        boolean isRouteChange = this.isRouteChange();
        if (isBomChange) {
            fmmEcobom.set("materialid", materialid == null ? Long.valueOf(0L) : materialid.getPkValue());
            fmmEcobom.set("material", material == null ? Long.valueOf(0L) : material.getPkValue());
        } else if (isRouteChange) {
            fmmEcobom.set("material", materialid == null ? Long.valueOf(0L) : materialid.getPkValue());
        }
        fmmEcobom.set(PROP_PENTRYVALIDDATE, pentry.get(PROP_PENTRYVALIDDATE));
        fmmEcobom.set("productno", pentry.get("seq"));
        String versionCtrl = pentry.getString(PROP_PENTRYVERSIONCONTROL);
        if (!"A".equals(versionCtrl)) {
            fmmEcobom.set("ctrlstrategy", (Object)this.getDefaultCt());
        }
        if (StringUtils.isEmpty((String)fmmEcobom.getString("ctrlstrategy"))) {
            fmmEcobom.set("ctrlstrategy", (Object)this.getDefaultCt());
        }
        Long ecoBomId = this.getEcoBomId(pentry);
        DynamicObject org = (DynamicObject)this.getModel().getValue(PROP_ORG);
        DynamicObject ecobomDO = existEcoBomMap.get(ecoBomId);
        if (ecobomDO != null) {
            EcoCommonHelper.putHeadProperties((DynamicObject)fmmEcobom, (DynamicObject)ecobomDO, this.getUnInCludeFieldSet());
            String subEntryNumber = this.getSubEntryNumber();
            ecobomDO.set(subEntryNumber, (Object)fmmEcobom.getDynamicObjectCollection(subEntryNumber));
            if (isBomChange) {
                ecobomDO.set(PROP_COPENTRY, (Object)fmmEcobom.getDynamicObjectCollection(PROP_COPENTRY));
            }
            ecobomDO.set("productno", fmmEcobom.get("productno"));
            ecobomDO.set(PROP_CREATEORG, (Object)org);
            if (isBomChange) {
                ecobomDO.set(PROP_TYPE, (Object)pentry.getDynamicObject(PROP_BOMTYPE));
            }
            return ecobomDO;
        }
        fmmEcobom.set(PROP_CREATEORG, (Object)org);
        if (isBomChange) {
            fmmEcobom.set(PROP_TYPE, (Object)pentry.getDynamicObject(PROP_BOMTYPE));
        }
        return fmmEcobom;
    }

    public void dealPenrtryDate(int i) {
        Date validdate = new Date();
        IDataModel model = this.getView().getModel();
        model.setValue(PROP_PENTRYVALIDDATE, (Object)validdate, i);
        model.setValue(PROP_ECOTYPE, (Object)this.getDefaultEcoType(), i);
    }

    public void setProductNewVersion(Object newValue, String propertyName, int newIndex) {
        String newVersionField;
        if (newValue == null) {
            return;
        }
        IDataModel dm = this.getModel();
        String conVersion = dm.getValue(PROP_PENTRYVERSIONCONTROL, newIndex).toString();
        if (!"D".equals(conVersion)) {
            return;
        }
        DynamicObject pmarterial = (DynamicObject)newValue;
        DynamicObject org = (DynamicObject)dm.getValue(PROP_ORG);
        DynamicObject bomType = (DynamicObject)dm.getValue(PROP_BOMTYPE, newIndex);
        DynamicObject ppmarterial = null;
        if (PROP_PROENTRYMATERIAL.equals(propertyName)) {
            ppmarterial = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)pmarterial, (String)"masterid");
        } else if (PROP_PROENTRYMATERIALID.equals(propertyName)) {
            ppmarterial = pmarterial;
        }
        String string = newVersionField = this.isRouteChange() ? PROP_PENTRYNEWRTVERSION : PROP_PENTRYNEWVERSION;
        if (this.isNeedVersion(bomType, ppmarterial, org)) {
            DynamicObject bomTypeRule = BOMVersionUtil.getBomTypeDefVersionRule((DynamicObject)bomType);
            DynamicObject version = BOMVersionUtil.getInitVersion((DynamicObject)org, (DynamicObject)ppmarterial, (String)(this.isRouteChange() ? "B" : "A"), (DynamicObject)bomTypeRule);
            if (version != null) {
                dm.setValue(newVersionField, version.getPkValue(), newIndex);
            } else {
                dm.setValue(newVersionField, null, newIndex);
            }
            this.getView().setEnable(Boolean.TRUE, newIndex, new String[]{newVersionField});
        } else {
            this.getView().setEnable(Boolean.FALSE, newIndex, new String[]{newVersionField});
        }
    }

    public String getDynamicObjectNumber(DynamicObject dy) {
        return dy == null ? null : dy.getString(PROP_NUMBER);
    }

    public Set<String> getBizChangedField() {
        HashSet<String> field = new HashSet<String>(16);
        field.add("entryisjumplevel_ctrl");
        field.add("entryisstockalloc_ctrl");
        field.add("entryisbulkmaterial_ctrl");
        field.add("entryiskey_ctrl");
        field.add("entrymode_ec");
        field.add("entrymaterial_ctrl");
        field.add("entryunit_ctrl");
        field.add("iscoproduct");
        return field;
    }

    public void setBizChangedFieldFalse(IDataModel model) {
        Set<String> fields = this.getBizChangedField();
        for (String field : fields) {
            this.setBizChangedFieldFalse(model, field);
        }
    }

    public void setBizChangedFieldFalse(IDataModel model, String field) {
        DynamicObject dy = model.getDataEntity();
        DynamicObjectType type = dy.getDynamicObjectType();
        int posInt = type.getProperty(field).getOrdinal();
        dy.getDataEntityState().setBizChanged(posInt, Boolean.FALSE.booleanValue());
    }

    public void comCtrl(IFormView view) {
        if (!this.isBomChange()) {
            return;
        }
        IDataModel model = view.getModel();
        String seq = String.valueOf(model.getValue("entryseq_ctrl"));
        Long ecoBomId = model.getDataEntity().getLong("id");
        if (ecoBomId == null || ecoBomId.equals(0L)) {
            return;
        }
        DynamicObject org = (DynamicObject)model.getValue("entrysupplyorg_ctrl");
        String orgNumber = this.getDynamicObjectNumber(org);
        String attr = String.valueOf(model.getValue("entryownertype_ctrl"));
        String opnum = String.valueOf(model.getValue("entryoperationnumber_ctrl"));
        String mode = String.valueOf(model.getValue("entryissuemode_ctrl"));
        String entryprocessseq = String.valueOf(model.getValue("entryprocessseq_ctrl"));
        String entryisbackflush = String.valueOf(model.getValue("entryisbackflush_ctrl"));
        String entryleadtime = String.valueOf(model.getValue("entryleadtime_ctrl"));
        DynamicObject entrywarehouse = (DynamicObject)view.getModel().getValue("entrywarehouse_ctrl");
        String entrywarehousenum = this.getDynamicObjectNumber(entrywarehouse);
        this.setBizChangedFieldFalse(model);
        String paramstr = "number,entry.seq,entry.entryownertype,entry.entryoperationnumber,entry.entryissuemode,entry.entrysupplyorg,entry.entryprocessseq,entry.entryisbackflush,entry.entryleadtime,entry.entrywarehouse";
        DynamicObject dynaobj = BusinessDataServiceHelper.loadSingle((String)PDM_ECOBOM, (String)paramstr, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)ecoBomId)});
        if (null == dynaobj) {
            return;
        }
        DynamicObjectCollection col = dynaobj.getDynamicObjectCollection(PROP_ENTRY);
        if (null == col || col.isEmpty()) {
            return;
        }
        for (DynamicObject dyn : col) {
            DynamicObject dynhouse;
            String housenum;
            DynamicObject dynorg;
            String orgnum;
            if (!seq.equals(dyn.getString("seq"))) continue;
            this.setBizChangedFieldFalse(model, "entryseq_ctrl");
            this.setBizChangedFieldFalse(model, "entrymaterialattr_ctrl");
            if (dyn.getString("entryownertype").equals(attr)) {
                this.setBizChangedFieldFalse(model, "entryownertype_ctrl");
            }
            if (dyn.getString("entryoperationnumber").equals(opnum)) {
                this.setBizChangedFieldFalse(model, "entryoperationnumber_ctrl");
            }
            if (dyn.getString("entryissuemode").equals(mode)) {
                this.setBizChangedFieldFalse(model, "entryissuemode_ctrl");
            }
            if (!PlatformUtils.isDiffString((String)(orgnum = this.getDynamicObjectNumber(dynorg = (DynamicObject)dyn.get("entrysupplyorg"))), (String)orgNumber)) {
                this.setBizChangedFieldFalse(model, "entrysupplyorg_ctrl");
            }
            if (dyn.getString("entryprocessseq").equals(entryprocessseq)) {
                this.setBizChangedFieldFalse(model, "entryprocessseq_ctrl");
            }
            if (dyn.getString("entryisbackflush").equals(entryisbackflush)) {
                this.setBizChangedFieldFalse(model, "entryisbackflush_ctrl");
            }
            if (dyn.getString("entryleadtime").equals(entryleadtime)) {
                this.setBizChangedFieldFalse(model, "entryleadtime_ctrl");
            }
            if (PlatformUtils.isDiffString((String)(housenum = this.getDynamicObjectNumber(dynhouse = (DynamicObject)dyn.get("entrywarehouse"))), (String)entrywarehousenum)) break;
            this.setBizChangedFieldFalse(model, "entrywarehouse_ctrl");
            break;
        }
        int[] a = new int[]{81, 82, 101, 102, 104, 105, 107};
        for (int i = 0; i < a.length; ++i) {
            view.getModel().getDataEntity().getDataEntityState().setBizChanged(a[i], false);
        }
    }

    public String getDefaultCt() {
        DynamicObject org;
        String ctrl;
        String entityNumber = PDM_MFTBOM;
        if (this.isRouteChange()) {
            entityNumber = PDM_ROUTE;
        }
        if (StringUtils.isEmpty((String)(ctrl = BaseDataServiceHelper.getBdCtrlStrgy((String)entityNumber, (String)(org = (DynamicObject)this.getModel().getValue(PROP_ORG)).getString("id"))))) {
            DynamicObject defCtrlStrDO = BaseDataServiceHelper.getDefaultCtrlStrtgy((String)entityNumber);
            ctrl = defCtrlStrDO == null ? "5" : DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)defCtrlStrDO, (String)"defaultctrlstrategy");
        }
        return ctrl;
    }

    public String getECNBill() {
        return (String)this.getModel().getValue("billno");
    }

    public boolean isNeedVersion(DynamicObject bomType, DynamicObject ppmarterial, DynamicObject org) {
        Long pmarterialPkId = 0L;
        if (ppmarterial != null) {
            pmarterialPkId = (Long)ppmarterial.getPkValue();
        }
        Long orgpk = (Long)org.getPkValue();
        if (this.isBomChange()) {
            boolean isVersion = MMCUtils.getDynamicObjectBooleanData((DynamicObject)bomType, (String)"isversion");
            boolean isenablematerialversion = MMCUtils.getDynamicObjectBooleanData((DynamicObject)ppmarterial, (String)"isenablematerialversion");
            return pmarterialPkId > 0L && orgpk > 0L && (isenablematerialversion || isVersion);
        }
        if (this.isRouteChange()) {
            return BOMVersionUtil.isRouteVsersion((Long)orgpk);
        }
        return false;
    }
}

