/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.eco;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bd.mpdm.common.query.helper.MaterialMftQueryHelper;
import kd.bd.mpdm.common.utils.ECNLocalCacheUtils;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterUtil;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.BizBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.pdm.business.ecoplatform.EcoUtils;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.common.util.BOMVersionUtil;
import kd.mmc.pdm.common.util.ECNUtil;
import kd.mmc.pdm.common.util.MMCUtils;
import kd.mmc.pdm.formplugin.eco.ECNAfterAuditUtils;
import kd.mmc.pdm.formplugin.eco.ECOBaseEditPlugin;

public class ECOEditPlugin
extends ECOBaseEditPlugin
implements RowClickEventListener,
BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(ECOEditPlugin.class);

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        String selectbomid;
        super.afterDoOperation(event);
        IFormView fv = this.getView();
        IPageCache pc = this.getPageCache();
        String opKey = event.getOperateKey();
        if (MMCUtils.isEmptyString((String)opKey)) {
            return;
        }
        if (event.getOperationResult() == null || !event.getOperationResult().isSuccess()) {
            return;
        }
        if (opKey.equalsIgnoreCase("nextpentry") || opKey.equalsIgnoreCase("prevpentry") || opKey.equalsIgnoreCase("new") || opKey.equalsIgnoreCase("copy") || opKey.equalsIgnoreCase("submit") || opKey.equalsIgnoreCase("unsubmit") || opKey.equalsIgnoreCase("audit") || opKey.equalsIgnoreCase("unaudit")) {
            fv.setVisible(Boolean.valueOf(!this.isViewStatus()), new String[]{"acptbi_pentry_new", "acptbi_pentry_delete"});
            if (opKey.equalsIgnoreCase("submit") || opKey.equalsIgnoreCase("unsubmit")) {
                String selectbomid2;
                String lastindex = pc.get("lastindex");
                if (StringUtils.isNotEmpty((CharSequence)lastindex)) {
                    pc.remove("lastindex");
                    pc.remove("lastindexchangetype");
                }
                if (StringUtils.isNotEmpty((CharSequence)(selectbomid2 = pc.get("mmc_pdm_selectbomid")))) {
                    pc.remove("mmc_pdm_selectbomid");
                }
                fv.updateView();
            }
        }
        if (opKey.equalsIgnoreCase("save")) {
            fv.updateView();
        }
        if (opKey.equalsIgnoreCase("save") && StringUtils.isEmpty((CharSequence)this.getPageCache().get("skipCheck"))) {
            this.getPageCache().remove("childChange");
            selectbomid = pc.get("mmc_pdm_selectbomid");
            this.showEcobomPage(selectbomid, OperationStatus.ADDNEW, false);
        }
        if (opKey.equalsIgnoreCase("audit") || opKey.equalsIgnoreCase("submit")) {
            selectbomid = pc.get("mmc_pdm_selectbomid");
            this.showEcobomPage(selectbomid, OperationStatus.VIEW, false);
            if (opKey.equalsIgnoreCase("audit")) {
                ECNAfterAuditUtils.throwMsg(event, this.getView());
            }
        }
    }

    public void afterLoadData(EventObject event) {
        super.afterLoadData(event);
        this.getView().setVisible(Boolean.valueOf(!this.isViewStatus()), new String[]{"acptbi_pentry_new", "acptbi_pentry_delete"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        String opKey;
        super.beforeDoOperation(event);
        Object srcObj = event.getSource();
        AbstractOperate srcAO = srcObj == null ? null : (srcObj instanceof AbstractOperate ? (AbstractOperate)srcObj : null);
        String string = opKey = srcAO == null ? null : srcAO.getOperateKey();
        if (MMCUtils.isEmptyString((String)opKey)) {
            return;
        }
        if ("save".equals(opKey) || "submit".equals(opKey)) {
            IFormView fv = this.getView();
            IDataModel dm = fv.getModel();
            IPageCache pc = this.getPageCache();
            DynamicObject org = (DynamicObject)fv.getModel().getValue("org");
            String serialiationCacheType = this.getSerialiationCacheType();
            DynamicObjectCollection pentry = dm.getEntryEntity("pentry");
            Set<Long> ecoBomIdSet = this.getEcoBomIdSet();
            DynamicObject currentEcoBom = this.putModelToCache();
            List<DynamicObject> saveDataList = new ArrayList<DynamicObject>(pentry.size());
            HashMap<Long, DynamicObject> existEcoBomMap = new HashMap<Long, DynamicObject>(16);
            if (!ecoBomIdSet.isEmpty()) {
                DynamicObject ecoBomDy = ORM.create().newDynamicObject(this.getEcoEntityByChangeType());
                DynamicObject[] dyColl = BusinessDataServiceHelper.load((Object[])ecoBomIdSet.toArray(), (DynamicObjectType)ecoBomDy.getDynamicObjectType());
                if (dyColl != null && dyColl.length > 0) {
                    for (int i = 0; i < dyColl.length; ++i) {
                        existEcoBomMap.put(dyColl[i].getLong("id"), dyColl[i]);
                    }
                }
            }
            for (DynamicObject dynamicObj : pentry) {
                Long ecobomid = this.getEcoBomId(dynamicObj);
                DynamicObject fmmEcobom = null;
                if (currentEcoBom != null && ecobomid.equals(currentEcoBom.getLong("id"))) {
                    fmmEcobom = currentEcoBom;
                } else {
                    String ecobomStr = pc.get(String.valueOf(ecobomid));
                    if (StringUtils.isNotEmpty((CharSequence)ecobomStr)) {
                        fmmEcobom = ECNLocalCacheUtils.deSerializeFromBase64((String)ecobomStr, (String)serialiationCacheType);
                    }
                }
                if (fmmEcobom == null) continue;
                saveDataList.add(this.setEcoDataByPentry(dynamicObj, fmmEcobom, existEcoBomMap));
            }
            this.doSecondSaveDeal();
            if (!saveDataList.isEmpty()) {
                if (this.isBomChange()) {
                    saveDataList = this.setSubMaterial(saveDataList, org);
                }
                SaveServiceHelper.save((DynamicObject[])saveDataList.toArray(new DynamicObject[saveDataList.size()]));
            }
        }
    }

    public DynamicObject putModelToCache() {
        IFormView fv = this.getView();
        IPageCache pc = this.getPageCache();
        String entrypageid = pc.get("mmc_eco_entryinfo");
        if (StringUtils.isEmpty((CharSequence)entrypageid)) {
            return null;
        }
        DynamicObject currentEcoBom = null;
        DynamicObjectCollection dycol = null;
        IDataModel ebomDM = fv.getView(entrypageid).getModel();
        if (ebomDM == null || !ebomDM.isDataLoaded()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9875\u9762\u7f13\u5b58\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"ECOEditPlugin_26", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return null;
        }
        String subEntryNumber = this.getSubEntryNumber();
        dycol = ebomDM.getEntryEntity(subEntryNumber);
        String seq = ebomDM.getValue("productno").toString();
        String ecobomid = pc.get("mmc_pdm_selectbomid");
        String serialiationCacheType = this.getSerialiationCacheType();
        boolean isBomChange = this.isBomChange();
        boolean isRouteChange = this.isRouteChange();
        DynamicObject fmmEcobom = null;
        if (StringUtils.isNotEmpty((CharSequence)ecobomid)) {
            String fmmEcobomStr = pc.get(ecobomid);
            if (StringUtils.isNotEmpty((CharSequence)fmmEcobomStr) && (fmmEcobom = ECNLocalCacheUtils.deSerializeFromBase64((String)fmmEcobomStr, (String)serialiationCacheType)) != null) {
                String contVersion;
                fmmEcobom.set(subEntryNumber, (Object)dycol);
                if (isRouteChange) {
                    fmmEcobom.set(this.getShowSubEntryNumber(), (Object)ebomDM.getEntryEntity(this.getShowSubEntryNumber()));
                    fmmEcobom.set("entryentity", (Object)ebomDM.getEntryEntity("entryentity"));
                    fmmEcobom.set("relentryentity", (Object)ebomDM.getEntryEntity("relentryentity"));
                } else if (isBomChange) {
                    fmmEcobom.set("copentry", (Object)ebomDM.getEntryEntity("copentry"));
                }
                String string = contVersion = "".equals(seq) ? "" : this.getControlVersion(Integer.parseInt(seq));
                if (isBomChange && "D".equals(contVersion)) {
                    fmmEcobom.set("group", ebomDM.getValue("group"));
                    fmmEcobom.set("yieldrate", ebomDM.getValue("yieldrate"));
                    fmmEcobom.set("configuredcode", ebomDM.getValue("configuredcode"));
                    fmmEcobom.set("iscoproduct", ebomDM.getValue("iscoproduct"));
                    fmmEcobom.set("wbs", ebomDM.getValue("wbs"));
                }
                if (isRouteChange) {
                    fmmEcobom.set("ismainprocess", ebomDM.getValue("ismainprocess"));
                    fmmEcobom.set("fremark", ebomDM.getValue("fremark"));
                    fmmEcobom.set("routereplace", ebomDM.getValue("routereplace"));
                    fmmEcobom.set("wbs", ebomDM.getValue("wbs"));
                    fmmEcobom.set("fremark", ebomDM.getValue("fremark"));
                }
                pc.put(ecobomid, ECNLocalCacheUtils.serializeToBase64((DynamicObject)fmmEcobom, (String)serialiationCacheType));
                currentEcoBom = fmmEcobom;
            }
            if (fmmEcobom == null) {
                DynamicObject ebomObj = ebomDM.getDataEntity(true);
                pc.put(ecobomid, ECNLocalCacheUtils.serializeToBase64((DynamicObject)ebomObj, (String)serialiationCacheType));
                currentEcoBom = ebomObj;
            }
        }
        return currentEcoBom;
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String srcDEPName;
        int rowIndex = event.getRow();
        IDataEntityProperty srcDEP = event.getProperty();
        String string = srcDEPName = srcDEP == null ? null : srcDEP.getName();
        if (MMCUtils.isEmptyString((String)srcDEPName)) {
            return;
        }
        if ("pentrynewversion".equalsIgnoreCase(srcDEPName) && rowIndex >= 0) {
            this.createBomVersionf7(event);
        }
        if ("pentrybom".equalsIgnoreCase(srcDEPName) && rowIndex >= 0) {
            this.createBomf7(event);
        }
        if ("bomtype".equalsIgnoreCase(srcDEPName) && rowIndex >= 0) {
            this.createBomTypef7(event);
        }
        if ("proentrymaterialid".equalsIgnoreCase(srcDEPName) && rowIndex >= 0) {
            this.createProEntryMaterialIdf7(event);
        }
        if ("pentryroute".equalsIgnoreCase(srcDEPName) && rowIndex >= 0) {
            this.createRoutef7(event);
        }
        if ("pentrynewrtversion".equalsIgnoreCase(srcDEPName) && rowIndex >= 0) {
            this.createRouteVersionf7(event);
        }
        if ("ecotype".equalsIgnoreCase(srcDEPName) && rowIndex >= 0) {
            this.createEcoTypef7(event);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        int[] a;
        EntryGrid grid;
        Long tempPk;
        String selectProperties;
        super.closedCallBack(event);
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        AbstractFormDataModel afdm = dm instanceof AbstractFormDataModel ? (AbstractFormDataModel)dm : null;
        String actID = event.getActionId();
        Object returnDataObj = event.getReturnData();
        ListSelectedRowCollection returnLSRC = returnDataObj instanceof ListSelectedRowCollection ? (ListSelectedRowCollection)returnDataObj : null;
        int returnLSRCSize = returnLSRC == null || returnLSRC.isEmpty() ? 0 : returnLSRC.size();
        if (MMCUtils.isEmptyString((String)actID) || returnDataObj == null) {
            return;
        }
        if ("pdm_bom".equalsIgnoreCase(actID) && returnLSRCSize > 0) {
            List<Long> returnBOMPKList = this.getIdFromReturnValue(returnLSRC);
            if (!this.checkReturnIdIsExists(new HashSet<Long>(returnBOMPKList), "pentrybom")) {
                return;
            }
            if (MMCUtils.isEmptyList(returnBOMPKList)) {
                return;
            }
            selectProperties = "id,createorg,number,type,type.purpose,version,material,materialid,ecn,auxproperty,ecn.number,optioncontrol";
            Object[] bomDOs = BusinessDataServiceHelper.load((String)"pdm_mftbom", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("id", "in", returnBOMPKList)});
            if (MMCUtils.isEmptyArray((Object[])bomDOs)) {
                return;
            }
            dm.beginInit();
            tempPk = null;
            grid = (EntryGrid)fv.getControl("pentry");
            a = grid.getSelectRows();
            DynamicObject bomType = null;
            Date validdate = new Date();
            DynamicObject defEcoType = this.getDefaultEcoType();
            for (Long id : returnBOMPKList) {
                Object[] objectArray = bomDOs;
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    Object bomDO = objectArray[i];
                    Object bomPKObj = bomDO.getPkValue();
                    Long bomPK = Long.parseLong(bomPKObj.toString());
                    if (!bomPK.equals(id)) continue;
                    bomType = bomDO.getDynamicObject("type");
                    Long bomTypeId = bomType.getLong("id");
                    DynamicObject bomMaterialDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)bomDO, (String)"material");
                    Long bomMaterialPK = ECNUtil.getDynamicObjectId((DynamicObject)bomMaterialDO);
                    DynamicObject bomVersionDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)bomDO, (String)"version");
                    Long bomVersionPK = ECNUtil.getDynamicObjectId((DynamicObject)bomVersionDO);
                    DynamicObject ecn = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)bomDO, (String)"ecn");
                    String ECNVersion = MMCUtils.getDynamicObjectStringData((DynamicObject)ecn, (String)"number");
                    DynamicObject auxproperty = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)bomDO, (String)"auxproperty");
                    Long auxpropertyPK = ECNUtil.getDynamicObjectId((DynamicObject)auxproperty);
                    DynamicObject bomMaterialMasterDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)bomDO, (String)"materialid");
                    Object bomMaterialMasterPKObj = bomMaterialMasterDO == null ? null : bomMaterialMasterDO.getPkValue();
                    Long bomMaterialMasterPK = bomMaterialMasterPKObj == null ? Long.valueOf(-1L) : Long.valueOf(Long.parseLong(bomMaterialMasterPKObj.toString()));
                    if ((bomMaterialPK == null || bomMaterialPK.equals(0L) || bomMaterialPK.equals(-1L)) && (bomMaterialDO = MaterialMftQueryHelper.getDataCacheByMaterialID((Long)bomMaterialMasterPK, (Long)bomDO.getDynamicObject("createorg").getLong("id"), null)) != null) {
                        bomMaterialPK = bomMaterialDO.getLong("id");
                    }
                    if (returnBOMPKList.size() == 1 || tempPk == null) {
                        dm.setValue("pentrybom", (Object)bomPK, a[0]);
                        dm.setValue("bomtype", (Object)bomTypeId, a[0]);
                        dm.setValue("proentrymaterial", (Object)bomMaterialPK, a[0]);
                        dm.setValue("proentrymaterialid", (Object)bomMaterialMasterPK, a[0]);
                        dm.setValue("bomauxproperty", (Object)auxpropertyPK, a[0]);
                        dm.setValue("pentryecn", (Object)ECNVersion, a[0]);
                        dm.setValue("pentryoldversion", (Object)bomVersionPK, a[0]);
                        dm.setValue("pentrynewversion", (Object)0L, a[0]);
                        fv.setEnable(Boolean.FALSE, a[0], new String[]{"proentrymaterialid"});
                        tempPk = bomPK;
                        continue;
                    }
                    DynamicObject obj = dm.getDataEntity(true);
                    DynamicObjectCollection coll = obj.getDynamicObjectCollection("pentry");
                    DynamicObjectType entryType = coll.getDynamicObjectType();
                    DynamicObject dynobj = new DynamicObject(entryType);
                    dynobj.set("pentrybom", bomDO);
                    dynobj.set("bomtype", (Object)bomDO.getDynamicObject("type"));
                    dynobj.set("proentrymaterial", (Object)bomMaterialDO);
                    dynobj.set("proentrymaterialid", (Object)bomMaterialMasterDO);
                    dynobj.set("bomauxproperty", (Object)auxproperty);
                    dynobj.set("pentryoldversion", (Object)bomVersionDO);
                    dynobj.set("pentrynewversion", null);
                    dynobj.set("pentryvaliddate", (Object)validdate);
                    dynobj.set("ecotype", (Object)defEcoType);
                    int seqi = dm.createNewEntryRow("pentry", a[0] + 1, dynobj);
                    fv.setEnable(Boolean.FALSE, seqi, new String[]{"proentrymaterialid"});
                }
            }
            dm.endInit();
            fv.updateView("pentry");
            this.productEntryShow(a[0]);
            this.updateCacheBom(a[0]);
            this.setVersionIsLock(-1);
        }
        if ("bd_materialinfo".equalsIgnoreCase(actID) && returnLSRCSize > 0) {
            ListSelectedRow returnLSR = returnLSRC.get(0);
            Object returnPKObj = returnLSR.getPrimaryKeyValue();
            Long returnPK = returnPKObj == null ? Long.valueOf(-1L) : Long.valueOf(Long.parseLong(returnPKObj.toString()));
            EntryGrid grid2 = (EntryGrid)this.getView().getControl("pentry");
            int[] a2 = grid2.getSelectRows();
            this.getModel().setValue("proentrymaterialid", (Object)returnPK, a2[0]);
        }
        if ("pdm_route".equalsIgnoreCase(actID) && returnLSRCSize > 0) {
            List<Long> returnRoutePKList = this.getIdFromReturnValue(returnLSRC);
            if (!this.checkReturnIdIsExists(new HashSet<Long>(returnRoutePKList), "pentryroute")) {
                return;
            }
            if (MMCUtils.isEmptyList(returnRoutePKList)) {
                return;
            }
            selectProperties = "id,createorg,number,name,routeversion,ismainprocess,processtype,material,auxproperty,wbs";
            Object[] routeDOs = BusinessDataServiceHelper.load((String)"pdm_route", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("id", "in", returnRoutePKList)});
            if (MMCUtils.isEmptyArray((Object[])routeDOs)) {
                return;
            }
            dm.beginInit();
            tempPk = null;
            grid = (EntryGrid)fv.getControl("pentry");
            a = grid.getSelectRows();
            Date validdate = new Date();
            DynamicObject defEcoType = this.getDefaultEcoType();
            for (Long id : returnRoutePKList) {
                for (Object routeDO : routeDOs) {
                    if (!((Long)routeDO.getPkValue()).equals(id)) continue;
                    if (returnRoutePKList.size() == 1 || tempPk == null) {
                        this.setEntryValue((DynamicObject)routeDO, a[0], validdate, defEcoType, (IDataModel)afdm, fv);
                        tempPk = (Long)routeDO.getPkValue();
                        continue;
                    }
                    int[] appendRows = dm.appendEntryRow("pentry", a[0] + 1, 1);
                    int rowIndex = appendRows[0];
                    this.setEntryValue((DynamicObject)routeDO, rowIndex, validdate, defEcoType, (IDataModel)afdm, fv);
                }
            }
            dm.endInit();
            fv.updateView("pentry");
            this.productEntryShow(a[0]);
            this.updateCacheBom(a[0]);
            this.setVersionIsLock(-1);
        }
    }

    private void setEntryValue(DynamicObject routeDO, int rowIndex, Date validdate, DynamicObject defEcoType, IDataModel dm, IFormView fv) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject materialDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)routeDO, (String)"material");
        Long routeMaterialMasterPK = ECNUtil.getDynamicObjectId((DynamicObject)materialDO);
        DynamicObject materialMftDo = MaterialMftQueryHelper.getDataCacheByMaterialID((Long)routeMaterialMasterPK, (Long)org.getLong("id"), null);
        DynamicObject routeVersionDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)routeDO, (String)"routeversion");
        Long routeVersionPK = ECNUtil.getDynamicObjectId((DynamicObject)routeVersionDO);
        DynamicObject auxproperty = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)routeDO, (String)"auxproperty");
        Long auxpropertyPK = ECNUtil.getDynamicObjectId((DynamicObject)auxproperty);
        dm.setValue("pentryroute", routeDO.getPkValue(), rowIndex);
        dm.setValue("pentryroutename", (Object)routeDO.getString("name"), rowIndex);
        dm.setValue("proentrymaterial", materialMftDo == null ? Long.valueOf(0L) : materialMftDo.getPkValue(), rowIndex);
        dm.setValue("proentrymaterialid", (Object)routeMaterialMasterPK, rowIndex);
        dm.setValue("bomauxproperty", (Object)auxpropertyPK, rowIndex);
        dm.setValue("pentryoldrtversion", (Object)routeVersionPK, rowIndex);
        dm.setValue("pentrynewrtversion", (Object)0L, rowIndex);
        dm.setValue("pentryvaliddate", (Object)validdate, rowIndex);
        if (defEcoType != null) {
            dm.setValue("ecotype", defEcoType.getPkValue(), rowIndex);
        }
        fv.setEnable(Boolean.FALSE, rowIndex, new String[]{"proentrymaterialid"});
    }

    private void updateCacheBom(int seq) {
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        IPageCache pc = fv.getPageCache();
        String indexSeq = this.getView().getPageCache().get("lastindex");
        DynamicObject entryDO = fv.getModel().getEntryRowEntity("pentry", Integer.parseInt(indexSeq == null ? "0" : indexSeq));
        String serialiationCacheType = this.getSerialiationCacheType();
        Long ecoBomId = this.getEcoBomId(entryDO);
        DynamicObject ecobom = null;
        if (this.isBomChange()) {
            ecobom = this.genEcoBOMByPEntry(entryDO, seq, ecoBomId);
        } else if (this.isRouteChange()) {
            ecobom = this.genEcoRouteByPEntry(entryDO, seq, ecoBomId);
        } else {
            return;
        }
        String ecobomJson = ECNLocalCacheUtils.serializeToBase64((DynamicObject)ecobom, (String)serialiationCacheType);
        ecoBomId = ecobom.getLong("id");
        pc.put("mmc_pdm_selectbomid", String.valueOf(ecoBomId));
        pc.put(String.valueOf(ecoBomId), ecobomJson);
        dm.beginInit();
        if (this.isBomChange()) {
            dm.setValue("ecobomid", (Object)ecoBomId, seq);
            dm.setValue("ecobomdata", (Object)ecoBomId, seq);
        } else if (this.isRouteChange()) {
            dm.setValue("ecorouteid", (Object)ecoBomId, seq);
            dm.setValue("ecoroutedata", (Object)ecoBomId, seq);
        }
        dm.endInit();
        this.showEcobomPage("", OperationStatus.ADDNEW, true);
    }

    private void productEntryShow(int seqIndex) {
        Object materialObject;
        IFormView fv = this.getView();
        EntryGrid grid = (EntryGrid)fv.getControl("pentry");
        grid.selectRows(seqIndex);
        DynamicObject entryDO = fv.getModel().getEntryRowEntity("pentry", seqIndex);
        String seq = entryDO.getString("seq");
        DynamicObject material = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)entryDO, (String)"proentrymaterial");
        Object object = materialObject = material == null ? null : material.getPkValue();
        Long materailid = materialObject == null ? 0L : (materialObject instanceof Long ? (Long)materialObject : 0L);
        DynamicObject masterialDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)entryDO, (String)"proentrymaterialid");
        Long materailmasterid = (Long)masterialDO.getPkValue();
        DynamicObject baseunitDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)masterialDO, (String)"baseunit");
        String pageid = fv.getPageCache().get("mmc_eco_entryinfo");
        IFormView efv = fv.getView(pageid);
        if (this.isBomChange()) {
            DynamicObject pentrybom = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)entryDO, (String)"pentrybom");
            String bomnumber = pentrybom == null ? null : MMCUtils.getDynamicObjectStringData((DynamicObject)pentrybom, (String)"number");
            DynamicObject version = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)pentrybom, (String)"version");
            Long versionid = this.getDynamicObjectId(version);
            efv.getModel().setValue("type", (Object)entryDO.getDynamicObject("bomtype"));
            efv.getModel().setValue("productno", (Object)seq);
            efv.getModel().setValue("number", (Object)bomnumber);
            efv.getModel().setValue("material", (Object)materailid);
            efv.getModel().setValue("materialid", (Object)materailmasterid);
            efv.getModel().setValue("version", (Object)versionid);
            efv.getModel().setValue("optioncontrol", (Object)MMCUtils.getDynamicObjectStringData((DynamicObject)pentrybom, (String)"optioncontrol"));
            efv.getModel().setValue("iscoproduct", (Object)MMCUtils.getDynamicObjectBooleanData((DynamicObject)pentrybom, (String)"iscoproduct"));
            DynamicObject wbs = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)pentrybom, (String)"wbs");
            efv.getModel().setValue("wbs", (Object)wbs);
        } else if (this.isRouteChange()) {
            DynamicObject pentryRoute = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)entryDO, (String)"pentryroute");
            DynamicObject version = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)entryDO, (String)"pentryoldrtversion");
            Long versionid = this.getDynamicObjectId(version);
            DynamicObject auxproperty = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)pentryRoute, (String)"auxproperty");
            Long auxpropertyPK = this.getDynamicObjectId(auxproperty);
            efv.getModel().setValue("processtype", (Object)pentryRoute.getString("processtype"));
            efv.getModel().setValue("productno", (Object)seq);
            efv.getModel().setValue("number", (Object)pentryRoute.getString("number"));
            efv.getModel().setValue("name", (Object)pentryRoute.getString("name"));
            efv.getModel().setValue("routeversion", (Object)versionid);
            efv.getModel().setValue("ismainprocess", pentryRoute.get("ismainprocess"));
            efv.getModel().setValue("routereplace", pentryRoute.get("routereplace"));
            efv.getModel().setValue("fremark", pentryRoute.get("fremark"));
            efv.getModel().setValue("material", (Object)materailmasterid);
            efv.getModel().setValue("unit", baseunitDO.getPkValue());
            efv.getModel().setValue("auxproperty", (Object)auxpropertyPK);
            if (pentryRoute.containsProperty("wbs")) {
                efv.getModel().setValue("wbs", pentryRoute.get("wbs"));
            }
            this.setWbsEnable(this.getModel(), seqIndex, efv);
        }
        String subEntrys = this.getSubEntryNumber();
        IDataModel subdm = efv.getModel();
        this.deleteSubEntrys(efv, subdm, subEntrys);
        if (this.isBomChange()) {
            this.deleteSubEntrys(efv, subdm, "copentry");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        IPageCache pc = this.getPageCache();
        String callBackID = event.getCallBackId();
        if (MMCUtils.isEmptyString((String)callBackID)) {
            return;
        }
        MessageBoxResult mbr = event.getResult();
        if (mbr == null) {
            return;
        }
        if ("pentryvaliddate".equals(callBackID)) {
            int row;
            String validDataStr = pc.get("pentryvaliddate");
            Date validData = MMCUtils.isEmptyString((String)validDataStr) ? null : new Date(Long.parseLong(validDataStr));
            String rowStr = pc.get("pentryvaliddate-row");
            int n = row = rowStr == null ? -1 : Integer.parseInt(rowStr);
            if (validData == null || row < 0) {
                return;
            }
            if (mbr.compareTo((Enum)MessageBoxResult.No) == 0 || mbr.compareTo((Enum)MessageBoxResult.Cancel) == 0) {
                this.setValueWithIgnoreChange(dm, "pentryvaliddate", validData, row);
                fv.updateView("pentryvaliddate", row);
            } else if (mbr.compareTo((Enum)MessageBoxResult.Yes) == 0 || mbr.compareTo((Enum)MessageBoxResult.OK) == 0) {
                Date newValidDate = MMCUtils.getDataModelDateData((IDataModel)dm, (String)"pentryvaliddate", (int)row);
                String pgid = pc.get("mmc_eco_entryinfo");
                if (StringUtils.isNotEmpty((CharSequence)pgid)) {
                    IFormView efv = this.getView().getView(pgid);
                    if (efv == null) {
                        return;
                    }
                    String subEntryNumber = this.getShowSubEntryNumber();
                    String entryModeField = this.getEntryModeField(subEntryNumber);
                    String acttimeField = this.getActtimeField(subEntryNumber);
                    String entryValidDate = this.getEntryValidDateField(subEntryNumber);
                    this.deleteEntryByPentryValidate(efv, subEntryNumber, entryModeField, acttimeField, entryValidDate, newValidDate);
                    if (this.isBomChange()) {
                        this.deleteEntryByPentryValidate(efv, "copentry", "copentrymode", "copacttime", "copentryvaliddate", newValidDate);
                    }
                    if (this.isRouteChange()) {
                        this.deleteEntryByPentryValidate(efv, "processentry", "entrymode", "acttime", "entryvaliddate", newValidDate);
                    }
                    efv.updateView("pentryvaliddate");
                    fv.sendFormAction(efv);
                }
            }
        } else if ("continue_close".equals(callBackID)) {
            if (mbr.getValue() == 6) {
                this.getPageCache().remove("childChange");
                this.getPageCache().put("closeConfirm", "true");
                this.getView().invokeOperation("close");
            } else {
                this.getPageCache().remove("childChange");
            }
        } else if ("ecotype".equalsIgnoreCase(callBackID)) {
            long ecoTye;
            String rowStr = pc.get("ecotype-row");
            String ecotypeStr = pc.get("ecotype");
            int rowIndex = StringUtils.isEmpty((CharSequence)rowStr) ? -1 : Integer.parseInt(rowStr);
            long l = ecoTye = StringUtils.isEmpty((CharSequence)ecotypeStr) ? -1L : Long.parseLong(ecotypeStr);
            if (rowIndex < 0 || ecoTye <= 0L) {
                return;
            }
            if (mbr.compareTo((Enum)MessageBoxResult.No) == 0 || mbr.compareTo((Enum)MessageBoxResult.Cancel) == 0) {
                this.setValueWithIgnoreChange(dm, "ecotype", ecoTye, rowIndex);
                this.getView().updateView("ecotype", rowIndex);
            } else {
                String pgid = this.getPageCache().get("mmc_eco_entryinfo");
                if (StringUtils.isEmpty((CharSequence)pgid)) {
                    return;
                }
                IFormView efv = this.getView().getView(pgid);
                if (efv == null) {
                    return;
                }
                String subEntryNumber = this.getShowSubEntryNumber();
                Date pentryvaliddate = (Date)dm.getValue("pentryvaliddate", rowIndex);
                DynamicObject newEcoType = (DynamicObject)dm.getValue("ecotype", rowIndex);
                boolean isAdjustTime = this.isAdjustActtime(newEcoType);
                this.setActtimeByPentryValidDate(efv, subEntryNumber, pentryvaliddate, isAdjustTime);
                if (this.isBomChange()) {
                    this.setActtimeByPentryValidDate(efv, "copentry", pentryvaliddate, isAdjustTime);
                }
                fv.sendFormAction(efv);
            }
        } else if ("changetype".equals(callBackID)) {
            if (mbr.compareTo((Enum)MessageBoxResult.No) == 0 || mbr.compareTo((Enum)MessageBoxResult.Cancel) == 0) {
                String oldChangeType = pc.get("pc_changetype");
                this.getPageCache().put("isIgnoreChangeListener", "true");
                dm.setValue("changetype", (Object)oldChangeType);
                this.getPageCache().put("isIgnoreChangeListener", "false");
            } else if (mbr.compareTo((Enum)MessageBoxResult.Yes) == 0 || mbr.compareTo((Enum)MessageBoxResult.OK) == 0) {
                dm.beginInit();
                this.removeAllPEntry();
                dm.endInit();
                fv.updateView("pentry");
            }
        }
    }

    private void deleteEntryByPentryValidate(IFormView efv, String subEntryNumber, String entryModeField, String acttimeField, String entryValidDate, Date newValidDate) {
        ArrayList<Integer> del = new ArrayList<Integer>(16);
        IDataModel ebomDM = efv.getModel();
        if (ebomDM == null) {
            return;
        }
        DynamicObjectCollection entrys = ebomDM.getEntryEntity(subEntryNumber);
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            String mode = MMCUtils.getDynamicObjectStringData((DynamicObject)entry, (String)entryModeField);
            if (StringUtils.equals((CharSequence)mode, (CharSequence)"A")) {
                ebomDM.setValue(entryValidDate, (Object)newValidDate, i);
                ebomDM.setValue(acttimeField, (Object)newValidDate, i);
                continue;
            }
            if (!StringUtils.equals((CharSequence)mode, (CharSequence)"B") && !StringUtils.equals((CharSequence)mode, (CharSequence)"C") && !StringUtils.equals((CharSequence)mode, (CharSequence)"E")) continue;
            del.add(i);
        }
        if (!del.isEmpty()) {
            int[] d = del.stream().mapToInt(Integer::intValue).toArray();
            ebomDM.deleteEntryRows(subEntryNumber, d);
            efv.updateView(subEntryNumber);
        }
    }

    private void setActtimeByPentryValidDate(IFormView efv, String subEntryNumber, Date pentryvaliddate, boolean isLock) {
        IDataModel edm = efv.getModel();
        if (edm == null) {
            return;
        }
        String acttimeField = this.getActtimeField(subEntryNumber);
        DynamicObjectCollection entrys = edm.getEntryEntity(subEntryNumber);
        for (int rowIndx = 0; rowIndx < entrys.size(); ++rowIndx) {
            edm.setValue(acttimeField, (Object)pentryvaliddate, rowIndx);
            efv.setEnable(Boolean.valueOf(isLock), rowIndx, new String[]{acttimeField});
        }
    }

    public void itemClick(ItemClickEvent event) {
        super.itemClick(event);
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        String itemKey = event.getItemKey();
        IPageCache pc = this.getPageCache();
        if (itemKey.equalsIgnoreCase("acptbi_pentry_new")) {
            int seqIndex = dm.createNewEntryRow("pentry");
            fv.setEnable(Boolean.valueOf(false), seqIndex, new String[]{"proentrymaterialid"});
            this.dealPenrtryDate(seqIndex);
            this.setVersionIsLock(-1);
        } else if (itemKey.equalsIgnoreCase("acptbi_pentry_delete")) {
            String entryinfo;
            String selectbomid;
            String lastindex;
            int[] pEntryRowIndexes;
            EntryGrid pEntryEG = (EntryGrid)this.getControl("pentry");
            AbstractGrid.GridState pEntryGS = pEntryEG == null ? null : pEntryEG.getEntryState();
            int[] nArray = pEntryRowIndexes = pEntryGS == null ? new int[]{} : pEntryGS.getSelectedRows();
            if (pEntryRowIndexes.length <= 0) {
                fv.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u4ea7\u54c1\u3002", (String)"ECOEditPlugin_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
                return;
            }
            int count = 0;
            String serialiationCacheType = this.getSerialiationCacheType();
            HashSet<Long> keyStringSet = new HashSet<Long>(16);
            for (int pEntryRowIndex : pEntryRowIndexes) {
                DynamicObject pEntryBOMDO = MMCUtils.getDataModelDynamicObjectData((IDataModel)dm, (String)"pentrybom", (int)(pEntryRowIndex -= ++count));
                DynamicObject pEntryRouteDO = MMCUtils.getDataModelDynamicObjectData((IDataModel)dm, (String)"pentryroute", (int)pEntryRowIndex);
                if (null != pEntryBOMDO || null != pEntryRouteDO) {
                    DynamicObject entryRow = dm.getEntryRowEntity("pentry", pEntryRowIndex);
                    String ecobomid = entryRow.getString("ecobomid");
                    String ecoRouteid = entryRow.getString("ecorouteid");
                    if (StringUtils.isNotEmpty((CharSequence)ecobomid)) {
                        pc.remove(ecobomid);
                        keyStringSet.add(Long.parseLong(ecobomid));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)ecoRouteid)) {
                        pc.remove(ecoRouteid);
                        keyStringSet.add(Long.parseLong(ecoRouteid));
                    }
                }
                dm.deleteEntryRow("pentry", pEntryRowIndex);
            }
            if (pEntryEG != null) {
                pEntryEG.clearEntryState();
            }
            if (StringUtils.isNotEmpty((CharSequence)(lastindex = pc.get("lastindex")))) {
                pc.remove("lastindex");
                pc.remove("lastindexchangetype");
            }
            if (StringUtils.isNotEmpty((CharSequence)(selectbomid = pc.get("mmc_pdm_selectbomid")))) {
                pc.remove("mmc_pdm_selectbomid");
                pc.remove(selectbomid);
            }
            if (StringUtils.isNotEmpty((CharSequence)(entryinfo = pc.get("mmc_eco_entryinfo")))) {
                pc.remove("mmc_eco_entryinfo");
            }
            this.clearEhCacheData(keyStringSet, serialiationCacheType);
            this.showEcobomPage("", OperationStatus.ADDNEW, true);
            this.setVersionIsLock(-1);
        } else if (itemKey.equalsIgnoreCase("acptbi_pentry_insert")) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("pentry");
            int[] selectedId = entryGrid.getSelectRows();
            if (null == selectedId || selectedId.length == 0) {
                fv.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u4ea7\u54c1\u3002", (String)"ECOEditPlugin_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
                return;
            }
            int seqIndex = dm.insertEntryRow("pentry", entryGrid.getSelectRows()[0]);
            fv.setEnable(Boolean.valueOf(false), seqIndex, new String[]{"proentrymaterialid"});
            this.dealPenrtryDate(seqIndex);
            entryGrid.selectRows(seqIndex);
            this.dealInsertEvent(pc, fv);
            this.setVersionIsLock(-1);
        }
    }

    private void dealInsertEvent(IPageCache pc, IFormView fv) {
        String selectbomid = pc.get("mmc_pdm_selectbomid");
        String bomstr = pc.get(selectbomid);
        DynamicObject fmmEcobom = null;
        String serialiationCacheType = this.getSerialiationCacheType();
        if (StringUtils.isNotBlank((CharSequence)bomstr)) {
            fmmEcobom = ECNLocalCacheUtils.deSerializeFromBase64((String)bomstr, (String)serialiationCacheType);
            String pgid = pc.get("mmc_eco_entryinfo");
            IFormView efv = this.getView().getView(pgid);
            if (efv != null && efv.getModel() != null) {
                IDataModel edm = efv.getModel();
                String subEntryNumber = this.getSubEntryNumber();
                DynamicObjectCollection entrycol = edm.getEntryEntity(subEntryNumber);
                fmmEcobom.set(subEntryNumber, (Object)entrycol);
                if (this.isRouteChange()) {
                    fmmEcobom.set(this.getShowSubEntryNumber(), (Object)edm.getEntryEntity(this.getShowSubEntryNumber()));
                    fmmEcobom.set("entryentity", (Object)edm.getEntryEntity("entryentity"));
                    fmmEcobom.set("relentryentity", (Object)edm.getEntryEntity("relentryentity"));
                } else if (this.isBomChange()) {
                    fmmEcobom.set("copentry", (Object)edm.getEntryEntity("copentry"));
                }
                String fbomstr = ECNLocalCacheUtils.serializeToBase64((DynamicObject)fmmEcobom, (String)serialiationCacheType);
                pc.put(selectbomid, fbomstr);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)selectbomid)) {
            pc.remove("mmc_pdm_selectbomid");
        }
        this.showEcobomPage("", OperationStatus.ADDNEW, true);
    }

    public void propertyChanged(PropertyChangedArgs event) {
        ChangeData[] changeDatas;
        super.propertyChanged(event);
        String propertyName = event.getProperty().getName();
        if (propertyName == null || "".equals(propertyName)) {
            return;
        }
        for (ChangeData changeData : changeDatas = event.getChangeSet()) {
            this.propertyChanged(propertyName, changeData);
        }
    }

    protected void propertyChanged(String propertyName, ChangeData propertyValue) {
        DynamicObject propertyValueDO;
        if ("true".equals(this.getPageCache().get("isIgnoreChangeListener"))) {
            return;
        }
        IFormView fv = this.getView();
        IPageCache pc = this.getPageCache();
        IDataModel dm = fv.getModel();
        ChangeData propertyValueCD = propertyValue;
        String serialiationCacheType = this.getSerialiationCacheType();
        boolean isBomChange = this.isBomChange();
        boolean isRouteChange = this.isRouteChange();
        int rowIndex = propertyValue.getRowIndex();
        Object propertyOldValueObj = propertyValueCD.getOldValue();
        DynamicObject propertyOldValueDO = propertyOldValueObj == null ? null : (propertyOldValueObj instanceof DynamicObject ? (DynamicObject)propertyOldValueObj : null);
        Object propertyValueObj = propertyValueCD == null ? propertyValue : propertyValueCD.getNewValue();
        DynamicObject dynamicObject = propertyValueDO = propertyValueObj instanceof DynamicObject ? (DynamicObject)propertyValueObj : null;
        if (propertyName.equalsIgnoreCase("bomtype")) {
            if (!isBomChange) {
                return;
            }
            Object newValue = propertyValue == null ? null : propertyValue.getNewValue();
            this.changeSubPageType(newValue);
            this.setVersionIsLock(rowIndex);
        } else if (propertyName.equalsIgnoreCase("pentrybom")) {
            if (!isBomChange) {
                return;
            }
            Object tempvalue = propertyValue.getNewValue();
            if (tempvalue == null) {
                this.clearPageContent(fv, dm, rowIndex);
                this.updateCacheBom(rowIndex);
            } else {
                this.updateBomProductEntryShow(rowIndex, tempvalue);
                this.updateCacheBom(rowIndex);
            }
            this.setVersionIsLock(rowIndex);
        } else if (propertyName.equalsIgnoreCase("pentryvaliddate")) {
            Date propertyOldData = propertyOldValueObj instanceof Date ? (Date)propertyOldValueObj : null;
            Date propertyValueDate = propertyValueObj instanceof Date ? (Date)propertyValueObj : null;
            DynamicObject obj = dm.getEntryRowEntity("pentry", rowIndex);
            if (isBomChange && (obj.get("pentrybom") == null || obj.get("proentrymaterialid") == null)) {
                return;
            }
            if (isRouteChange && (obj.get("pentryroute") == null || obj.get("proentrymaterialid") == null)) {
                return;
            }
            if (propertyValueDate == null && propertyOldData != null) {
                propertyValueDate = propertyOldData;
                dm.setValue("pentryvaliddate", (Object)propertyValueDate, rowIndex);
                return;
            }
            if (propertyValueDate != null && propertyOldData == null) {
                return;
            }
            String pgid = this.getPageCache().get("mmc_eco_entryinfo");
            if (StringUtils.isEmpty((CharSequence)pgid)) {
                return;
            }
            IFormView efv = this.getView().getView(pgid);
            if (efv == null) {
                return;
            }
            IDataModel edm = efv.getModel();
            if (edm == null) {
                return;
            }
            edm.setValue("pentryvaliddate", (Object)propertyValueDate);
            DynamicObject ecoType = MMCUtils.getDataModelDynamicObjectData((IDataModel)dm, (String)"ecoType", (int)rowIndex);
            boolean adjustActTime = this.isAdjustActtime(ecoType);
            ArrayList<Integer> idxs = new ArrayList<Integer>(16);
            String subEntryNumber = this.getShowSubEntryNumber();
            boolean isUpdate = this.getSubAddEntryModeRow(edm, idxs, subEntryNumber);
            ArrayList<Integer> idxs2 = new ArrayList<Integer>(16);
            boolean isUpdate2 = false;
            if (isBomChange) {
                isUpdate2 = this.getSubAddEntryModeRow(edm, idxs2, "copentry");
            }
            if (isUpdate || isUpdate2) {
                pc.put("pentryvaliddate", propertyOldData == null ? "0" : String.valueOf(propertyOldData.getTime()));
                pc.put("pentryvaliddate-row", String.valueOf(rowIndex));
                fv.showConfirm(String.format(ResManager.loadKDString((String)"\u4fee\u6539\u4ea7\u54c1\u5206\u5f55\u7b2c%s\u884c\u7684\u201c\u751f\u6548\u65e5\u671f\u201d\uff0c\u5c06\u81ea\u52a8\u5220\u9664\u8be5\u4ea7\u54c1\u5206\u5f55\u5bf9\u5e94\u7684\u975e\u65b0\u589e\u7ec4\u4ef6\u5206\u5f55\uff0c\u786e\u5b9a\u4fee\u6539\uff1f", (String)"ECOEditPlugin_6", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), rowIndex + 1), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("pentryvaliddate"));
            } else if (adjustActTime) {
                this.setSubAddEntryModeActtimeValue(efv, edm, idxs, subEntryNumber, propertyValueDate);
                this.setSubAddEntryModeActtimeValue(efv, edm, idxs2, "copentry", propertyValueDate);
                fv.sendFormAction(efv);
            }
        } else if (propertyName.equalsIgnoreCase("entryversioncontrol")) {
            if (null != propertyValue) {
                this.initVersionControll(fv, propertyValue, dm);
            }
        } else if (propertyName.equalsIgnoreCase("proentrymaterialid")) {
            Object newValue = propertyValue.getNewValue();
            int newIndex = -1;
            if (null != propertyValue) {
                newIndex = propertyValue.getRowIndex();
            }
            if (newValue == null) {
                this.clearPageContent(fv, dm, newIndex);
                this.claerPageCacheByEcobomid(newIndex);
            } else {
                IFormView efv;
                String pgid;
                dm.beginInit();
                dm.setValue("pentryoldversion", null, newIndex);
                dm.setValue("bomauxproperty", null, newIndex);
                dm.setValue("pentrynewversion", null, newIndex);
                dm.setValue("pentryoldrtversion", null, newIndex);
                dm.setValue("pentrynewrtversion", null, newIndex);
                dm.endInit();
                this.getView().updateView("pentryoldversion", newIndex);
                this.getView().updateView("bomauxproperty", newIndex);
                this.getView().updateView("pentrynewversion", newIndex);
                this.getView().updateView("pentryoldrtversion", newIndex);
                this.getView().updateView("pentrynewrtversion", newIndex);
                boolean fg = this.bomCodeNumberStart(fv, newIndex);
                if (!fg) {
                    return;
                }
                this.clearSubPageEntry(newIndex);
                DynamicObject entryDO = this.getModel().getEntryRowEntity("pentry", newIndex);
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (isBomChange) {
                    DynamicObject bomType = entryDO.getDynamicObject("bomtype");
                    if (bomType == null) {
                        this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165BOM\u7c7b\u578b\uff0c\u518d\u586b\u5199\u7b2c%s\u884c\u4ea7\u54c1\u5206\u5f55\u4fe1\u606f\u3002", (String)"ECOEditPlugin_7", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), newIndex + 1));
                        dm.setValue("proentrymaterialid", propertyOldValueObj, newIndex);
                        return;
                    }
                    if (this.isNeedMaterialMft(bomType)) {
                        DynamicObject materialMasterId = (DynamicObject)newValue;
                        DynamicObject mft = MaterialMftQueryHelper.getDataCacheByMaterial((DynamicObject)materialMasterId, (DynamicObject)org);
                        if (mft == null || !mft.getBoolean("ismainproduct")) {
                            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4ea7\u54c1\u5206\u5f55\u7684\u7269\u6599%2$s\u6ca1\u6709\u7269\u6599\u751f\u4ea7\u4fe1\u606f,\u6216\u4e0d\u662f\u53ef\u4e3b\u4ea7\u54c1\u3002", (String)"ECOEditPlugin_8", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), newIndex + 1, materialMasterId.getString("number")));
                            dm.setValue("proentrymaterialid", propertyOldValueObj, newIndex);
                            return;
                        }
                        dm.setValue("proentrymaterial", (Object)mft.getLong("id"), newIndex);
                        this.showInitVersionInfo(mft, "proentrymaterial", newIndex);
                    } else {
                        this.showInitVersionInfo(newValue, "proentrymaterialid", newIndex);
                    }
                } else {
                    DynamicObject materialMasterId = (DynamicObject)newValue;
                    DynamicObject mft = MaterialMftQueryHelper.getDataCacheByMaterial((DynamicObject)materialMasterId, (DynamicObject)org);
                    if (mft != null) {
                        dm.setValue("proentrymaterial", (Object)mft.getLong("id"), newIndex);
                    }
                    this.showInitVersionInfo(newValue, "proentrymaterialid", newIndex);
                }
                if (isBomChange) {
                    String ecoBomId = entryDO.getString("ecobomid");
                    if (ecoBomId == null || "".equals(ecoBomId) || "0".equals(ecoBomId)) {
                        this.genEcoBomidAndEcoBom(entryDO, newIndex);
                        pgid = this.getPageCache().get("mmc_eco_entryinfo");
                        if (StringUtils.isEmpty((CharSequence)pgid)) {
                            return;
                        }
                        efv = this.getView().getView(pgid);
                        IDataModel subdm = efv.getModel();
                        String selectId = pc.get("mmc_pdm_selectbomid");
                        String bomString = pc.get(selectId);
                        DynamicObject bom = ECNLocalCacheUtils.deSerializeFromBase64((String)bomString, (String)serialiationCacheType);
                        subdm.setValue("number", bom.get("number"));
                        this.getView().sendFormAction(efv);
                    } else {
                        String bomstr = pc.get(ecoBomId);
                        DynamicObject fmmEcobom = null;
                        if (StringUtils.isNotBlank((CharSequence)bomstr)) {
                            fmmEcobom = ECNLocalCacheUtils.deSerializeFromBase64((String)bomstr, (String)serialiationCacheType);
                        } else if (QueryServiceHelper.exists((String)"pdm_ecobom", (Object)ecoBomId)) {
                            fmmEcobom = BusinessDataServiceHelper.loadSingle((Object)ecoBomId, (String)"pdm_ecobom");
                        } else {
                            fmmEcobom = BusinessDataServiceHelper.newDynamicObject((String)"pdm_ecobom");
                            fmmEcobom.set("id", (Object)ecoBomId);
                        }
                        fmmEcobom.set("material", (Object)entryDO.getDynamicObject("proentrymaterial"));
                        fmmEcobom.set("materialid", (Object)entryDO.getDynamicObject("proentrymaterialid"));
                        String fbomstr = ECNLocalCacheUtils.serializeToBase64((DynamicObject)fmmEcobom, (String)serialiationCacheType);
                        pc.put(ecoBomId, fbomstr);
                        pc.put("mmc_pdm_selectbomid", String.valueOf(ecoBomId));
                    }
                } else if (isRouteChange) {
                    String ecoRouteId = entryDO.getString("ecorouteid");
                    if (ecoRouteId == null || "".equals(ecoRouteId) || "0".equals(ecoRouteId)) {
                        this.genEcoRouteidAndEcoRoute(entryDO, newIndex);
                        pgid = this.getPageCache().get("mmc_eco_entryinfo");
                        if (StringUtils.isEmpty((CharSequence)pgid)) {
                            return;
                        }
                        efv = this.getView().getView(pgid);
                        IDataModel subdm = efv.getModel();
                        String selectId = pc.get("mmc_pdm_selectbomid");
                        String bomString = pc.get(selectId);
                        DynamicObject route = ECNLocalCacheUtils.deSerializeFromBase64((String)bomString, (String)serialiationCacheType);
                        subdm.setValue("number", route.get("number"));
                        subdm.setValue("name", route.get("name"));
                        this.getView().sendFormAction(efv);
                    } else {
                        String routestr = pc.get(ecoRouteId);
                        DynamicObject fmmEcoRoute = null;
                        if (StringUtils.isNotBlank((CharSequence)routestr)) {
                            fmmEcoRoute = ECNLocalCacheUtils.deSerializeFromBase64((String)routestr, (String)serialiationCacheType);
                        } else if (QueryServiceHelper.exists((String)"pdm_ecoroute", (Object)ecoRouteId)) {
                            fmmEcoRoute = BusinessDataServiceHelper.loadSingle((Object)ecoRouteId, (String)"pdm_ecoroute");
                        } else {
                            fmmEcoRoute = BusinessDataServiceHelper.newDynamicObject((String)"pdm_ecoroute");
                            fmmEcoRoute.set("id", (Object)ecoRouteId);
                        }
                        fmmEcoRoute.set("material", (Object)entryDO.getDynamicObject("proentrymaterialid"));
                        fmmEcoRoute.set("unit", entryDO.getDynamicObject("proentrymaterialid").get("baseunit"));
                        String froutestr = ECNLocalCacheUtils.serializeToBase64((DynamicObject)fmmEcoRoute, (String)serialiationCacheType);
                        pc.put(ecoRouteId, froutestr);
                        pc.put("mmc_pdm_selectbomid", String.valueOf(ecoRouteId));
                    }
                }
                if (isBomChange || isRouteChange) {
                    this.setProductNewVersion(newValue, "proentrymaterialid", newIndex);
                    this.showEcobomPage("", OperationStatus.ADDNEW, true);
                }
            }
        } else if (propertyName.equalsIgnoreCase("pentrynewversion") || propertyName.equalsIgnoreCase("pentrynewrtversion")) {
            String bomstr;
            Object newValue = propertyValue == null ? null : propertyValue.getNewValue();
            int newIndex = propertyValue == null ? -1 : propertyValue.getRowIndex();
            this.showInitVersionInfo(newValue, propertyName, newIndex);
            DynamicObject entryDO = this.getModel().getEntryRowEntity("pentry", newIndex);
            Long ecobomid = this.getEcoBomId(entryDO);
            if (!PlatformUtils.isNullLong((Long)ecobomid) && !StringUtils.isEmpty((CharSequence)(bomstr = pc.get(String.valueOf(ecobomid))))) {
                DynamicObject fmmEcobom = ECNLocalCacheUtils.deSerializeFromBase64((String)bomstr, (String)serialiationCacheType);
                fmmEcobom.set(isBomChange ? "version" : "routeversion", newValue);
                String fbomstr = ECNLocalCacheUtils.serializeToBase64((DynamicObject)fmmEcobom, (String)serialiationCacheType);
                pc.put(String.valueOf(ecobomid), fbomstr);
                pc.put("mmc_pdm_selectbomid", String.valueOf(ecobomid));
            }
        } else if (propertyName.equalsIgnoreCase("bomauxproperty")) {
            String bomstr;
            DynamicObject entryDO;
            Long ecobomid;
            Object newValue = propertyValue == null ? null : propertyValue.getNewValue();
            int newIndex = -1;
            if (propertyValue != null) {
                newIndex = propertyValue.getRowIndex();
            }
            if (!PlatformUtils.isNullLong((Long)(ecobomid = this.getEcoBomId(entryDO = this.getModel().getEntryRowEntity("pentry", newIndex)))) && (bomstr = pc.get(String.valueOf(ecobomid))) != null && !"".equals(bomstr)) {
                DynamicObject fmmEcobom = ECNLocalCacheUtils.deSerializeFromBase64((String)bomstr, (String)serialiationCacheType);
                fmmEcobom.set("auxproperty", (Object)((DynamicObject)newValue));
                String fbomstr = ECNLocalCacheUtils.serializeToBase64((DynamicObject)fmmEcobom, (String)serialiationCacheType);
                pc.put(String.valueOf(ecobomid), fbomstr);
                pc.put("mmc_pdm_selectbomid", String.valueOf(ecobomid));
            }
        } else if ("ecotype".equalsIgnoreCase(propertyName)) {
            String pgid;
            DynamicObject obj = dm.getEntryRowEntity("pentry", rowIndex);
            if (isBomChange ? obj.get("pentrybom") == null && obj.get("proentrymaterialid") == null : isRouteChange && obj.get("pentryroute") == null && obj.get("proentrymaterialid") == null) {
                return;
            }
            if (propertyOldValueDO != null && propertyValueDO != null) {
                boolean adjustActTimeOld = propertyOldValueDO.getBoolean("adjustacttime");
                boolean adjustActTimeNew = propertyValueDO.getBoolean("adjustacttime");
                if (!adjustActTimeNew && adjustActTimeOld) {
                    pc.put("ecotype", String.valueOf(propertyOldValueDO.getPkValue()));
                    pc.put("ecotype-row", String.valueOf(rowIndex));
                    String number = propertyValueDO.getString("number");
                    fv.showConfirm(String.format(ResManager.loadKDString((String)"%s\u53d8\u66f4\u7c7b\u578b\u5bf9\u5e94\u201c\u5141\u8bb8\u5b9e\u65bd\u8c03\u6574\u65f6\u95f4\u201d\u5b57\u6bb5\u5df2\u53d8\u66f4\uff0c\u662f\u5426\u66f4\u65b0\u7ec4\u4ef6\u5b9e\u65bd\u65f6\u95f4\u4e3a\u4ea7\u54c1\u4fe1\u606f\u884c\u751f\u6548\u65f6\u95f4\uff1f", (String)"ECOEditPlugin_9", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), number), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("ecotype"));
                    return;
                }
            }
            if (StringUtils.isEmpty((CharSequence)(pgid = this.getPageCache().get("mmc_eco_entryinfo")))) {
                return;
            }
            IFormView efv = this.getView().getView(pgid);
            if (efv == null) {
                return;
            }
            DynamicObject newEcoType = (DynamicObject)propertyValue.getNewValue();
            boolean isAdjustTime = this.isAdjustActtime(newEcoType);
            Date pentryvaliddate = (Date)dm.getValue("pentryvaliddate", rowIndex);
            this.setActtimeByPentryValidDate(efv, this.getShowSubEntryNumber(), pentryvaliddate, isAdjustTime);
            if (isBomChange) {
                this.setActtimeByPentryValidDate(efv, "copentry", pentryvaliddate, isAdjustTime);
            }
            fv.sendFormAction(efv);
        } else if ("pentryroute".equalsIgnoreCase(propertyName)) {
            if (!this.isRouteChange()) {
                return;
            }
            Object tempvalue = propertyValue.getNewValue();
            int newIndex = propertyValue.getRowIndex();
            if (tempvalue == null) {
                this.clearPageContent(fv, dm, newIndex);
                this.updateCacheBom(newIndex);
            } else {
                this.updateRouteProductEntryShow(newIndex, tempvalue);
                this.updateCacheBom(newIndex);
            }
            this.setVersionIsLock(rowIndex);
        } else if ("changetype".equalsIgnoreCase(propertyName)) {
            pc.put("pc_changetype", propertyOldValueObj == null ? "A" : propertyOldValueObj.toString());
            if (this.getView().getModel().getEntryRowCount("pentry") > 0) {
                String msg = ResManager.loadKDString((String)"\u4fee\u6539\u201c\u53d8\u66f4\u5bf9\u8c61\u201d\uff0c\u4f1a\u81ea\u52a8\u5220\u9664\u6b64\u884c\u7684\u7ec4\u4ef6\u4fe1\u606f\u6570\u636e\uff0c\u786e\u5b9a\u4fee\u6539\uff1f", (String)"ECOEditPlugin_28", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                if (isRouteChange) {
                    msg = ResManager.loadKDString((String)"\u4fee\u6539\u201c\u53d8\u66f4\u5bf9\u8c61\u201d\u5c06\u81ea\u52a8\u5220\u9664\u53d8\u66f4\u4fe1\u606f\u6570\u636e\uff0c\u662f\u5426\u786e\u5b9a\u4fee\u6539\uff1f", (String)"ECOEditPlugin_30", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                }
                fv.showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("changetype"));
            } else {
                this.showEcobomPage("", OperationStatus.ADDNEW, true);
            }
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setVersionIsLock(-1);
    }

    protected void setVersionIsLock(int rowIndex) {
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        DynamicObjectCollection coll = dm.getEntryEntity("pentry");
        int size = coll.size();
        if (size <= 0) {
            return;
        }
        boolean isBomChange = this.isBomChange();
        String newVersionField = isBomChange ? "pentrynewversion" : "pentrynewrtversion";
        DynamicObject org = (DynamicObject)dm.getValue("org");
        for (int i = 0; i < size; ++i) {
            if (rowIndex >= 0 && rowIndex != i) continue;
            boolean isLock = false;
            String entryversioncontrol = (String)dm.getValue("entryversioncontrol", i);
            if ("D".equals(entryversioncontrol)) {
                DynamicObject material = (DynamicObject)dm.getValue("proentrymaterialid", i);
                DynamicObject bomType = (DynamicObject)dm.getValue("bomtype", i);
                isLock = this.isNeedVersion(bomType, material, org);
            }
            fv.setEnable(Boolean.valueOf(isLock), i, new String[]{newVersionField});
        }
    }

    protected boolean getSubAddEntryModeRow(IDataModel edm, List<Integer> idxs, String subEntryNumber) {
        DynamicObjectCollection entrys = edm.getEntryEntity(subEntryNumber);
        String entryModeField = this.getEntryModeField(subEntryNumber);
        boolean isUpdate = Boolean.FALSE;
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            String mode = MMCUtils.getDynamicObjectStringData((DynamicObject)entry, (String)entryModeField);
            if (StringUtils.equals((CharSequence)mode, (CharSequence)"A")) {
                idxs.add(i);
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)mode)) continue;
            isUpdate = Boolean.TRUE;
        }
        return isUpdate;
    }

    protected void setSubAddEntryModeActtimeValue(IFormView efv, IDataModel edm, List<Integer> idxs, String subEntryNumber, Date propertyValueDate) {
        if (idxs.isEmpty()) {
            return;
        }
        String acttimeField = this.getActtimeField(subEntryNumber);
        String entryValidDateField = this.getEntryValidDateField(subEntryNumber);
        for (Integer i : idxs) {
            edm.setValue(entryValidDateField, (Object)propertyValueDate, i.intValue());
            edm.setValue(acttimeField, (Object)propertyValueDate, i.intValue());
        }
        efv.updateView(subEntryNumber);
        efv.updateView("pentryvaliddate");
    }

    protected boolean isInitVersonAndSendEcoType(int rowIndex) {
        String versionControl;
        DynamicObject entryDO = this.getModel().getEntryRowEntity("pentry", rowIndex);
        return entryDO.getDynamicObject("proentrymaterialid") != null && (versionControl = entryDO.getString("entryversioncontrol")) != null && "D".equals(versionControl);
    }

    private boolean bomCodeNumberStart(IFormView fv, int index) {
        DynamicObject entryDO = this.getModel().getEntryRowEntity("pentry", index);
        String versionControl = entryDO.getString("entryversioncontrol");
        if ("D".equals(versionControl)) {
            QFilter filter1 = new QFilter("bizobjectid", "=", (Object)this.getEntityByChangeType());
            QFilter filter2 = new QFilter("enable", "=", (Object)"1");
            Boolean flag = QueryServiceHelper.exists((String)"bos_coderule", (QFilter[])new QFilter[]{filter1, filter2});
            if (flag.booleanValue()) {
                return true;
            }
            if (this.isBomChange()) {
                fv.showTipNotification(ResManager.loadKDString((String)"BOM\u7f16\u7801\u89c4\u5219\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528\uff0c\u8bf7\u6838\u9a8c\u3002", (String)"ECOEditPlugin_10", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            } else {
                fv.showTipNotification(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u7f16\u7801\u89c4\u5219\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528\uff0c\u8bf7\u6838\u9a8c\u3002", (String)"ECOEditPlugin_20", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            }
            fv.getModel().setValue("proentrymaterial", null, index);
            fv.getModel().setValue("proentrymaterialid", null, index);
            return false;
        }
        return true;
    }

    private void updateBomProductEntryShow(int newIndex, Object tempvalue) {
        DynamicObject tempbom;
        Object materialObject;
        IFormView fv = this.getView();
        IDataModel dm = this.getModel();
        DynamicObject entryDO = fv.getModel().getEntryRowEntity("pentry", newIndex);
        int seq = newIndex + 1;
        DynamicObject newBom = (DynamicObject)tempvalue;
        DynamicObject material = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)newBom, (String)"material");
        DynamicObject masterialDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)newBom, (String)"materialid");
        DynamicObject org = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)newBom, (String)"createorg");
        Object object = materialObject = material == null ? null : material.getPkValue();
        Long materailid = materialObject == null ? 0L : (materialObject instanceof Long ? (Long)materialObject : 0L);
        if (masterialDO == null) {
            masterialDO = material == null ? null : MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)material, (String)"masterid");
        }
        Long materialMasterid = masterialDO == null ? 0L : masterialDO.getLong("id");
        if ((material == null || materailid.equals(0L)) && (material = MaterialMftQueryHelper.getDataCacheByMaterialID((Long)materialMasterid, (Long)org.getLong("id"), null)) != null) {
            materailid = material.getLong("id");
        }
        String bomnumber = MMCUtils.getDynamicObjectStringData((DynamicObject)newBom, (String)"number");
        DynamicObject version = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)newBom, (String)"version");
        DynamicObject configuredcode = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)newBom, (String)"configuredcode");
        Long versionid = this.getDynamicObjectId(version);
        DynamicObject auxproperty = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)newBom, (String)"auxproperty");
        Long auxpropertyPK = this.getDynamicObjectId(auxproperty);
        String ecobomid = entryDO.getString("ecobomid");
        IPageCache pc = fv.getPageCache();
        String bomString = pc.get(ecobomid);
        String serialiationCacheType = this.getSerialiationCacheType();
        if (!StringUtils.isEmpty((CharSequence)bomString) && (tempbom = ECNLocalCacheUtils.deSerializeFromBase64((String)bomString, (String)serialiationCacheType)) != null) {
            tempbom.set("entry", null);
            tempbom.set("copentry", null);
            String fbomstr = ECNLocalCacheUtils.serializeToBase64((DynamicObject)tempbom, (String)serialiationCacheType);
            pc.put(ecobomid, fbomstr);
        }
        this.getPageCache().put("isIgnoreChangeListener", "true");
        dm.beginInit();
        dm.setValue("bomtype", (Object)newBom.getDynamicObject("type"), newIndex);
        dm.setValue("pentrybom", (Object)newBom, newIndex);
        dm.setValue("proentrymaterial", (Object)materailid, newIndex);
        dm.setValue("proentrymaterialid", (Object)materialMasterid, newIndex);
        dm.setValue("bomauxproperty", (Object)auxpropertyPK, newIndex);
        dm.setValue("pentryoldversion", (Object)versionid, newIndex);
        dm.setValue("pentrynewversion", null, newIndex);
        dm.endInit();
        this.getPageCache().put("isIgnoreChangeListener", "false");
        String pageid = fv.getPageCache().get("mmc_eco_entryinfo");
        IFormView efv = fv.getView(pageid);
        efv.getModel().setValue("productno", (Object)seq);
        efv.getModel().setValue("number", (Object)bomnumber);
        efv.getModel().setValue("material", (Object)materailid);
        efv.getModel().setValue("materialid", (Object)materialMasterid);
        efv.getModel().setValue("version", (Object)versionid);
        efv.getModel().setValue("type", (Object)newBom.getDynamicObject("type"));
        if (newBom.containsProperty("wbs")) {
            efv.getModel().setValue("wbs", newBom.get("wbs"));
        }
        if (null != configuredcode) {
            efv.getModel().setValue("configuredcode", configuredcode.getPkValue());
        }
        fv.updateView("pentry");
        fv.sendFormAction(efv);
    }

    private void updateRouteProductEntryShow(int newIndex, Object tempvalue) {
        DynamicObject tempRoute;
        IFormView fv = this.getView();
        IDataModel dm = this.getModel();
        DynamicObject entryDO = fv.getModel().getEntryRowEntity("pentry", newIndex);
        int seq = newIndex + 1;
        DynamicObject newRoute = (DynamicObject)tempvalue;
        DynamicObject masterialDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)newRoute, (String)"material");
        DynamicObject org = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)newRoute, (String)"createorg");
        DynamicObject material = MaterialMftQueryHelper.getDataCacheByMaterialID((Long)this.getDynamicObjectId(masterialDO), (Long)org.getLong("id"), null);
        String routnumber = MMCUtils.getDynamicObjectStringData((DynamicObject)newRoute, (String)"number");
        String routname = MMCUtils.getDynamicObjectStringData((DynamicObject)newRoute, (String)"name");
        DynamicObject version = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)newRoute, (String)"routeversion");
        DynamicObject configuredcode = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)newRoute, (String)"configcode");
        Long versionid = this.getDynamicObjectId(version);
        DynamicObject auxproperty = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)newRoute, (String)"auxproperty");
        Long auxpropertyPK = this.getDynamicObjectId(auxproperty);
        String ecoRouteid = entryDO.getString("ecorouteid");
        IPageCache pc = fv.getPageCache();
        String routeString = pc.get(ecoRouteid);
        String serialiationCacheType = this.getSerialiationCacheType();
        if (!StringUtils.isEmpty((CharSequence)routeString) && (tempRoute = ECNLocalCacheUtils.deSerializeFromBase64((String)routeString, (String)serialiationCacheType)) != null) {
            this.clearRouteEntry(tempRoute);
            String froutestr = ECNLocalCacheUtils.serializeToBase64((DynamicObject)tempRoute, (String)serialiationCacheType);
            pc.put(ecoRouteid, froutestr);
        }
        this.getPageCache().put("isIgnoreChangeListener", "true");
        dm.beginInit();
        dm.setValue("proentrymaterial", (Object)this.getDynamicObjectId(material), newIndex);
        dm.setValue("proentrymaterialid", (Object)this.getDynamicObjectId(masterialDO), newIndex);
        dm.setValue("bomauxproperty", (Object)auxpropertyPK, newIndex);
        dm.setValue("pentryoldrtversion", (Object)versionid, newIndex);
        dm.setValue("pentrynewrtversion", null, newIndex);
        dm.setValue("pentryroutename", (Object)routname, newIndex);
        dm.endInit();
        this.getPageCache().put("isIgnoreChangeListener", "false");
        String pageid = fv.getPageCache().get("mmc_eco_entryinfo");
        IFormView efv = fv.getView(pageid);
        IDataModel efModel = efv.getModel();
        efModel.beginInit();
        efModel.setValue("createorg", (Object)this.getDynamicObjectId(org));
        efModel.setValue("processtype", (Object)"A");
        efModel.setValue("productno", (Object)seq);
        efModel.setValue("number", (Object)routnumber);
        efModel.setValue("name", (Object)routname);
        efModel.setValue("material", (Object)this.getDynamicObjectId(masterialDO));
        efModel.setValue("routeversion", (Object)versionid);
        efModel.setValue("ismainprocess", (Object)newRoute.getBoolean("ismainprocess"));
        efModel.setValue("fremark", newRoute.get("fremark"));
        efModel.setValue("routereplace", newRoute.get("routereplace"));
        if (newRoute.containsProperty("wbs")) {
            efModel.setValue("wbs", newRoute.get("wbs"));
        }
        if (null != configuredcode) {
            efModel.setValue("configcode", configuredcode.getPkValue());
        }
        efModel.endInit();
        this.setWbsEnable(dm, newIndex, efv);
        fv.updateView("pentry");
        fv.sendFormAction(efv);
    }

    private void setWbsEnable(IDataModel dm, int newIndex, IFormView efv) {
        String entryVersionControl;
        String string = entryVersionControl = dm.getValue("entryversioncontrol", newIndex) != null ? dm.getValue("entryversioncontrol", newIndex).toString() : "";
        if (!"D".equals(entryVersionControl)) {
            efv.setEnable(Boolean.valueOf(false), new String[]{"wbs"});
        } else {
            efv.setEnable(Boolean.valueOf(true), new String[]{"wbs"});
        }
    }

    private void changeSubPageType(Object newValue) {
        IPageCache pc = this.getView().getPageCache();
        String entrypageid = pc.get("mmc_eco_entryinfo");
        IFormView efv = this.getView().getView(entrypageid);
        IDataModel ebomDM = efv.getModel();
        if (!ebomDM.isDataLoaded()) {
            return;
        }
        ebomDM.setValue("type", newValue);
        this.getView().sendFormAction(efv);
    }

    private void clearSubPageEntry(int rowInex) {
        String pgid = this.getPageCache().get("mmc_eco_entryinfo");
        if (StringUtils.isEmpty((CharSequence)pgid)) {
            return;
        }
        IFormView efv = this.getView().getView(pgid);
        this.clearEcoBomAndRouteEntry(efv, rowInex);
    }

    private void deleteSubEntrys(IFormView efv, IDataModel subdm, String subEntryNumber) {
        DynamicObjectCollection subDyncol = subdm.getEntryEntity(subEntryNumber);
        if (PlatformUtils.isNullCollection((DynamicObjectCollection)subDyncol)) {
            return;
        }
        ArrayList<Integer> aint = new ArrayList<Integer>();
        for (int i = 0; i < subDyncol.size(); ++i) {
            aint.add(i);
        }
        int[] d = aint.stream().mapToInt(Integer::intValue).toArray();
        subdm.deleteEntryRows(subEntryNumber, d);
        efv.setStatus(OperationStatus.ADDNEW);
        efv.updateView(subEntryNumber);
        this.getView().sendFormAction(efv);
    }

    private void showInitVersionInfo(Object newValue, String propertyName, int newIndex) {
        String pgid = this.getPageCache().get("mmc_eco_entryinfo");
        if (StringUtils.isEmpty((CharSequence)pgid)) {
            return;
        }
        IFormView efv = this.getView().getView(pgid);
        IDataModel subdm = efv.getModel();
        String versionControl = String.valueOf(this.getModel().getValue("entryversioncontrol", newIndex));
        if (versionControl.equals("D")) {
            if (propertyName.equalsIgnoreCase("proentrymaterial") && this.isBomChange()) {
                subdm.setValue("material", newValue);
                DynamicObject materialMasterId = this.getMaterialMasterByObject(newValue);
                subdm.setValue("materialid", materialMasterId.getPkValue());
            }
            if (propertyName.equalsIgnoreCase("proentrymaterialid")) {
                if (this.isBomChange()) {
                    subdm.setValue("materialid", newValue);
                } else {
                    subdm.setValue("material", newValue);
                }
            }
            if (propertyName.equalsIgnoreCase("pentrynewversion")) {
                subdm.setValue("version", newValue);
            }
            if (propertyName.equalsIgnoreCase("pentrynewrtversion")) {
                subdm.setValue("routeversion", newValue);
            }
        }
        if (this.isRouteChange()) {
            boolean isVisible = !versionControl.equals("D");
            efv.setVisible(Boolean.valueOf(isVisible), new String[]{"editop_entry"});
            efv.setVisible(Boolean.valueOf(isVisible), new String[]{"disableop_entry"});
        }
        efv.setStatus(OperationStatus.ADDNEW);
        this.getView().sendFormAction(efv);
    }

    private void initVersionControll(IFormView fv, ChangeData propertyValue, IDataModel dm) {
        String newValue = String.valueOf(propertyValue.getNewValue());
        String oldValue = String.valueOf(propertyValue.getOldValue());
        int newIndex = propertyValue.getRowIndex();
        if ("D".equals(newValue)) {
            if (newIndex > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7cfb\u7edf\u7684\u521d\u59cb\u7248\u672c\u53ea\u5141\u8bb8\u4f53\u73b0\u5728\u4ea7\u54c1\u5206\u5f55\u7684\u7b2c\u4e00\u884c\u5206\u5f55\u4e2d\u3002", (String)"ECOEditPlugin_11", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
                dm.setValue("entryversioncontrol", (Object)oldValue, newIndex);
                return;
            }
            dm.setValue("pentrybom", null, newIndex);
            dm.setValue("pentryroute", null, newIndex);
            dm.setValue("pentryroutename", null, newIndex);
            fv.setEnable(Boolean.valueOf(true), newIndex, new String[]{"proentrymaterialid"});
            fv.setEnable(Boolean.valueOf(false), newIndex, new String[]{"pentrybom"});
            fv.setEnable(Boolean.valueOf(false), newIndex, new String[]{"pentryroute"});
            this.clearSubPageEntry(newIndex);
        } else if ("D".equals(oldValue)) {
            this.clearPageContent(fv, dm, newIndex);
            fv.setEnable(Boolean.TRUE, newIndex, new String[]{"pentrybom"});
        } else {
            this.clearSubPageEntry(newIndex);
        }
        this.setVersionIsLock(newIndex);
    }

    private void claerPageCacheByEcobomid(int index) {
        IPageCache pc = this.getView().getPageCache();
        String ecoSubField = this.getEcoBomIdField();
        String ecoBomid = String.valueOf(this.getModel().getValue(ecoSubField, index));
        pc.remove(ecoBomid);
        this.getModel().setValue(ecoSubField, (Object)"0", index);
    }

    private void clearPageContent(IFormView fv, IDataModel dm, int seq) {
        dm.beginInit();
        dm.setValue("proentrymaterial", null, seq);
        dm.setValue("proentrymaterialid", null, seq);
        dm.setValue("pentryoldversion", null, seq);
        dm.setValue("bomauxproperty", null, seq);
        dm.setValue("pentrynewversion", null, seq);
        dm.setValue("pentryoldrtversion", null, seq);
        dm.setValue("pentrynewrtversion", null, seq);
        dm.endInit();
        String pgid = this.getPageCache().get("mmc_eco_entryinfo");
        if (StringUtils.isEmpty((CharSequence)pgid)) {
            return;
        }
        IFormView efv = this.getView().getView(pgid);
        IDataModel subdm = efv.getModel();
        if (!subdm.isDataLoaded()) {
            return;
        }
        subdm.setValue("number", null);
        subdm.setValue("material", null);
        subdm.setValue("wbs", null);
        if (this.isRouteChange()) {
            subdm.setValue("name", null);
            subdm.setValue("routeid", null);
            subdm.setValue("routeversion", null);
        } else {
            subdm.setValue("version", null);
        }
        this.clearEcoBomAndRouteEntry(efv, seq);
        fv.updateView("pentry");
        fv.sendFormAction(efv);
    }

    public void registerListener(EventObject event) {
        BasedataEdit bomType;
        BasedataEdit pentryEcoType;
        BasedataEdit pentryNewRtVersion;
        BasedataEdit pentryroute;
        BizBasedataEdit pentryMaterial;
        BasedataEdit pentrybom;
        super.registerListener(event);
        if (event == null) {
            return;
        }
        this.addItemClickListeners(new String[]{"acptb_pentry"});
        BasedataEdit pEntryNewVersionBE = (BasedataEdit)this.getControl("pentrynewversion");
        if (pEntryNewVersionBE != null) {
            pEntryNewVersionBE.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((pentrybom = (BasedataEdit)this.getControl("pentrybom")) != null) {
            pentrybom.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((pentryMaterial = (BizBasedataEdit)this.getControl("proentrymaterial")) != null) {
            pentryMaterial.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((pentryroute = (BasedataEdit)this.getControl("pentryroute")) != null) {
            pentryroute.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((pentryNewRtVersion = (BasedataEdit)this.getControl("pentrynewrtversion")) != null) {
            pentryNewRtVersion.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((pentryEcoType = (BasedataEdit)this.getControl("ecotype")) != null) {
            pentryEcoType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((bomType = (BasedataEdit)this.getControl("bomtype")) != null) {
            bomType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("pentry");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        IFormView fv = this.getView();
        IPageCache pc = this.getPageCache();
        IDataModel dm = fv.getModel();
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (StringUtils.equals((CharSequence)"pentry", (CharSequence)entryGrid.getKey())) {
            int index = evt.getRow();
            String status = MMCUtils.getDataModelStringData((IDataModel)dm, (String)"billstatus");
            int lastindex = -1;
            String lastindxChangeType = "";
            if (StringUtils.isNotEmpty((CharSequence)pc.get("lastindex"))) {
                lastindex = Integer.parseInt(pc.get("lastindex"));
                lastindxChangeType = pc.get("lastindexchangetype");
            }
            if (index >= 0) {
                String changeType = this.getChangeType();
                if (index == lastindex && lastindxChangeType.equals(changeType)) {
                    return;
                }
                this.setCacheBomEntry(lastindex, status, lastindxChangeType);
                pc.put("lastindex", String.valueOf(index));
                pc.put("lastindexchangetype", changeType);
                DynamicObject entryDO = this.getModel().getEntryRowEntity("pentry", index);
                Long ecoBomId = this.getEcoBomId(entryDO);
                if (PlatformUtils.isNullLong((Long)ecoBomId)) {
                    if (this.isBomChange()) {
                        this.genEcoBomidAndEcoBom(entryDO, index);
                    } else {
                        this.genEcoRouteidAndEcoRoute(entryDO, index);
                    }
                    this.showEcobomPage("", OperationStatus.ADDNEW, true);
                } else {
                    String ebomid = String.valueOf(ecoBomId);
                    pc.put("mmc_pdm_selectbomid", ebomid);
                    if (StringUtils.isNotEmpty((CharSequence)ebomid)) {
                        if (!"A".equals(status)) {
                            this.showEcobomPage(ebomid, OperationStatus.VIEW, true);
                        } else {
                            boolean isexist = this.checkIsExistsDB(ebomid);
                            String ebomstr = pc.get(ebomid);
                            if (this.isVersionCtrlD(index)) {
                                String str = this.initVersionSetNewVersion(ebomstr, index);
                                pc.put(ebomid, str);
                            }
                            if (isexist && StringUtils.isEmpty((CharSequence)ebomstr)) {
                                this.showEcobomPage(ebomid, OperationStatus.EDIT, true);
                            } else {
                                this.showEcobomPage("", OperationStatus.ADDNEW, true);
                            }
                        }
                    } else {
                        this.showEcobomPage("", OperationStatus.ADDNEW, true);
                    }
                }
            }
        }
    }

    private void setCacheBomEntry(int lastindex, String status, String lastindxChangeType) {
        boolean isLoad;
        if (lastindex < 0 || !"A".equals(status)) {
            return;
        }
        if (!lastindxChangeType.equals(this.getChangeType())) {
            return;
        }
        IPageCache pc = this.getView().getPageCache();
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        String entrypageid = pc.get("mmc_eco_entryinfo");
        IDataModel ebomDM = fv.getView(entrypageid).getModel();
        String serialiationCacheType = this.getSerialiationCacheType();
        boolean bl = isLoad = ebomDM == null ? Boolean.FALSE.booleanValue() : ebomDM.isDataLoaded();
        if (isLoad && StringUtils.isNotEmpty((CharSequence)entrypageid)) {
            try {
                String ecobomids;
                String fmmEcobomStr;
                DynamicObject entryRowEntity;
                Long ecobomid;
                DynamicObjectCollection dycol = null;
                Object yieldrate = null;
                Object group = null;
                Object configuredcode = null;
                String subEntryNumber = this.getSubEntryNumber();
                boolean isBomChange = this.isBomChange();
                boolean isRouteChange = this.isRouteChange();
                dycol = ebomDM.getEntryEntity(subEntryNumber);
                if (isBomChange) {
                    yieldrate = ebomDM.getValue("yieldrate");
                    group = ebomDM.getValue("group");
                    configuredcode = ebomDM.getValue("configuredcode");
                }
                if ((ecobomid = this.getEcoBomId(entryRowEntity = dm.getEntryRowEntity("pentry", lastindex))) == null || ecobomid.equals(0L)) {
                    dm.beginInit();
                    if (isBomChange) {
                        ecobomid = ORM.create().genLongId("pdm_ecobom");
                        dm.setValue("ecobomid", (Object)ecobomid, lastindex);
                    } else if (isRouteChange) {
                        ecobomid = ORM.create().genLongId("pdm_ecoroute");
                        dm.setValue("ecorouteid", (Object)ecobomid, lastindex);
                    }
                    dm.endInit();
                }
                if (StringUtils.isEmpty((CharSequence)(fmmEcobomStr = pc.get(ecobomids = String.valueOf(ecobomid))))) {
                    DynamicObject ebomObj = ebomDM.getDataEntity(true);
                    ebomObj.set("id", (Object)ecobomid);
                    pc.put(ecobomids, ECNLocalCacheUtils.serializeToBase64((DynamicObject)ebomObj, (String)serialiationCacheType));
                } else {
                    DynamicObject fmmEcobom = ECNLocalCacheUtils.deSerializeFromBase64((String)fmmEcobomStr, (String)serialiationCacheType);
                    if (fmmEcobom != null) {
                        String contrVersion;
                        fmmEcobom.set(subEntryNumber, (Object)dycol);
                        if (isRouteChange) {
                            fmmEcobom.set(this.getShowSubEntryNumber(), (Object)ebomDM.getEntryEntity(this.getShowSubEntryNumber()));
                            fmmEcobom.set("entryentity", (Object)ebomDM.getEntryEntity("entryentity"));
                            fmmEcobom.set("relentryentity", (Object)ebomDM.getEntryEntity("relentryentity"));
                        } else if (isBomChange) {
                            fmmEcobom.set("copentry", (Object)ebomDM.getEntryEntity("copentry"));
                        }
                        if (isBomChange && null != entryRowEntity && "D".equals(contrVersion = entryRowEntity.getString("entryversioncontrol"))) {
                            fmmEcobom.set("group", group);
                            fmmEcobom.set("yieldrate", yieldrate);
                            fmmEcobom.set("configuredcode", configuredcode);
                        }
                        if (isRouteChange) {
                            fmmEcobom.set("ismainprocess", ebomDM.getValue("ismainprocess"));
                            fmmEcobom.set("fremark", ebomDM.getValue("fremark"));
                            fmmEcobom.set("routereplace", ebomDM.getValue("routereplace"));
                        }
                        pc.put(ecobomids, ECNLocalCacheUtils.serializeToBase64((DynamicObject)fmmEcobom, (String)serialiationCacheType));
                    }
                }
            }
            catch (KDException e) {
                logger.error((Throwable)e);
                throw e;
            }
        }
    }

    private boolean isVersionCtrlD(int index) {
        DynamicObjectCollection dyncol = this.getModel().getEntryEntity("pentry");
        DynamicObject dyn = (DynamicObject)dyncol.get(index);
        String versionCtr = dyn.getString("entryversioncontrol");
        return "D".equals(versionCtr);
    }

    private boolean isVersionCtrlB(int index) {
        DynamicObjectCollection dyncol = this.getModel().getEntryEntity("pentry");
        DynamicObject dyn = (DynamicObject)dyncol.get(index);
        String versionCtr = dyn.getString("entryversioncontrol");
        return "D".equals(versionCtr);
    }

    private String initVersionSetNewVersion(String ebomstr, int index) {
        DynamicObject newversion;
        DynamicObjectCollection dyncol = this.getModel().getEntryEntity("pentry");
        DynamicObject dyn = (DynamicObject)dyncol.get(index);
        String versionCtr = dyn.getString("entryversioncontrol");
        boolean isBomChange = this.isBomChange();
        DynamicObject dynamicObject = newversion = isBomChange ? (DynamicObject)dyn.get("pentrynewversion") : (DynamicObject)dyn.get("pentrynewrtversion");
        if (null == ebomstr) {
            return ebomstr;
        }
        String serialiationCacheType = this.getSerialiationCacheType();
        DynamicObject fmmEcobom = ECNLocalCacheUtils.deSerializeFromBase64((String)ebomstr, (String)serialiationCacheType);
        if ("D".equals(versionCtr)) {
            fmmEcobom.set(isBomChange ? "version" : "routeversion", (Object)newversion);
        }
        String bomstr = ECNLocalCacheUtils.serializeToBase64((DynamicObject)fmmEcobom, (String)serialiationCacheType);
        return bomstr;
    }

    private void genEcoBomidAndEcoBom(DynamicObject entryDO, int index) {
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        IPageCache pc = fv.getPageCache();
        DynamicObject org = (DynamicObject)fv.getModel().getValue("org");
        DynamicObject ecoBom = this.genEcoBOMByPEntry(entryDO, index, 0L);
        String versionControl = entryDO.getString("entryversioncontrol");
        if ("D".equals(versionControl)) {
            DynamicObject newversion = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)entryDO, (String)"pentrynewversion");
            ecoBom.set("version", (Object)newversion);
            String newnumber = CodeRuleServiceHelper.getNumber((String)"pdm_mftbom", (DynamicObject)ecoBom, (String)String.valueOf(org.getPkValue()));
            ecoBom.set("number", (Object)newnumber);
        }
        String ecobomJson = ECNLocalCacheUtils.serializeToBase64((DynamicObject)ecoBom, (String)this.getSerialiationCacheType());
        Long fmmBomid = ecoBom.getLong("id");
        pc.put("mmc_pdm_selectbomid", String.valueOf(fmmBomid));
        pc.put(String.valueOf(fmmBomid), ecobomJson);
        dm.beginInit();
        dm.setValue("ecobomid", (Object)fmmBomid, index);
        dm.setValue("ecobomdata", (Object)fmmBomid, index);
        dm.endInit();
    }

    private void genEcoRouteidAndEcoRoute(DynamicObject entryDO, int index) {
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        IPageCache pc = fv.getPageCache();
        DynamicObject org = (DynamicObject)fv.getModel().getValue("org");
        DynamicObject ecoRoute = this.genEcoRouteByPEntry(entryDO, index, 0L);
        String versionControl = entryDO.getString("entryversioncontrol");
        if ("D".equals(versionControl)) {
            DynamicObject newRouteversion = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)entryDO, (String)"pentrynewrtversion");
            ecoRoute.set("routeversion", (Object)newRouteversion);
            String newnumber = CodeRuleServiceHelper.getNumber((String)"pdm_route", (DynamicObject)ecoRoute, (String)String.valueOf(org.getPkValue()));
            ecoRoute.set("number", (Object)newnumber);
        }
        String ecobomJson = ECNLocalCacheUtils.serializeToBase64((DynamicObject)ecoRoute, (String)this.getSerialiationCacheType());
        Long fmmRtid = ecoRoute.getLong("id");
        pc.put("mmc_pdm_selectbomid", String.valueOf(fmmRtid));
        pc.put(String.valueOf(fmmRtid), ecobomJson);
        dm.beginInit();
        dm.setValue("ecorouteid", (Object)fmmRtid, index);
        dm.setValue("ecoroutedata", (Object)fmmRtid, index);
        dm.endInit();
    }

    public boolean checkChildIsChange(String pkid, OperationStatus opstatus) {
        String lastOpenKeyString;
        IPageCache pc = this.getPageCache();
        String ecobomid = pc.get("mmc_pdm_selectbomid");
        if (StringUtils.isEmpty((CharSequence)ecobomid)) {
            return true;
        }
        String bomjson = pc.get(ecobomid);
        String pkStr = (pkid == null ? "0" : pkid) + "_" + this.getChangeType() + "_" + opstatus;
        if (StringUtils.isNotEmpty((CharSequence)bomjson)) {
            if (OperationStatus.VIEW.equals((Object)opstatus) || !this.isLcCacheType()) {
                pkStr = pkStr + bomjson;
            } else {
                pc.put("lastopenkeystring", pkStr);
                return true;
            }
        }
        if (StringUtils.equals((CharSequence)(lastOpenKeyString = pc.get("lastopenkeystring")), (CharSequence)pkStr)) {
            return false;
        }
        pc.put("lastopenkeystring", pkStr);
        return true;
    }

    public void showEcobomPage(String pkid, OperationStatus opstatus, boolean checkChange) {
        if (!this.checkChildIsChange(pkid, opstatus)) {
            return;
        }
        IFormView fv = this.getView();
        IPageCache pc = this.getPageCache();
        BaseShowParameter lsp = new BaseShowParameter();
        String pageId = lsp.getPageId();
        lsp.setFormId(this.getEcoEntityByChangeType());
        lsp.getOpenStyle().setTargetKey("entryinfo");
        lsp.getOpenStyle().setShowType(ShowType.InContainer);
        if (StringUtils.isNotEmpty((CharSequence)pkid)) {
            lsp.setPkId((Object)pkid);
        }
        lsp.setParentFormId(fv.getFormShowParameter().getFormId());
        lsp.setStatus(opstatus);
        String oldpage = pc.get("mmc_eco_entryinfo");
        if (!StringUtils.isEmpty((CharSequence)oldpage)) {
            IFormView efv = fv.getView(oldpage);
            pc.put("mmc_eco_entryinfo", null);
            efv.close();
        }
        fv.showLoading(new LocaleString(ResManager.loadKDString((String)"\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"ECOEditPlugin_12", (String)"mmc-pdm-formplugin", (Object[])new Object[0])));
        fv.showForm((FormShowParameter)lsp);
        pc.put("mmc_eco_entryinfo", pageId);
    }

    public void beforeBindData(EventObject evt) {
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        IPageCache pc = this.getPageCache();
        DynamicObjectCollection pentry = dm.getEntryEntity("pentry");
        String status = MMCUtils.getDataModelStringData((IDataModel)dm, (String)"billstatus");
        if (!PlatformUtils.isNullCollection((DynamicObjectCollection)pentry)) {
            DynamicObject entry = (DynamicObject)pentry.get(0);
            String ecobomid = String.valueOf(this.getEcoBomId(entry));
            if (StringUtils.isNotEmpty((CharSequence)ecobomid) && !"0".equals(ecobomid)) {
                pc.put("mmc_pdm_selectbomid", ecobomid);
                pc.put("lastindex", "0");
                pc.put("lastindexchangetype", this.getChangeType());
                if ("A".equals(status)) {
                    this.showEcobomPage(ecobomid, OperationStatus.EDIT, true);
                } else {
                    this.showEcobomPage(ecobomid, OperationStatus.VIEW, !"C".equals(status));
                }
            } else {
                this.showEcobomPage("", OperationStatus.ADDNEW, true);
            }
        } else {
            this.showEcobomPage("", OperationStatus.ADDNEW, true);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        e.setSkipNoField(true);
        dm.getDataEntity(true);
        String billStatus = MMCUtils.getDataModelStringData((IDataModel)dm, (String)"billstatus");
        if (StringUtils.equals((CharSequence)billStatus, (CharSequence)"A")) {
            e.setCheckDataChange(true);
            DynamicObjectCollection entrys = dm.getEntryEntity("pentry");
            for (DynamicObject entry : entrys) {
                int ordinal = entry.getDynamicObjectType().getProperty("ecobomid").getOrdinal();
                entry.getDataEntityState().setBizChanged(ordinal, false);
                ordinal = entry.getDynamicObjectType().getProperty("ecorouteid").getOrdinal();
                entry.getDataEntityState().setBizChanged(ordinal, false);
            }
        } else {
            e.setCheckDataChange(false);
        }
        if (this.isLcCacheType()) {
            Set<Long> ecoBomIdSet = this.getEcoBomIdSet();
            this.getPageCache().put("clearEcoBomIds", ecoBomIdSet.toString());
        }
        if (!fv.getModel().getDataChanged() && StringUtils.equals((CharSequence)billStatus, (CharSequence)"A")) {
            this.checkChildChange(e);
        }
    }

    private boolean checkChildChange(BeforeClosedEvent e) {
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get("skipCheck"))) {
            return false;
        }
        IFormView view = this.getView().getView(this.getPageCache().get("mmc_eco_entryinfo"));
        int number = view.getModel().getDataEntity().getDynamicObjectType().getProperty("number").getOrdinal();
        view.getModel().getDataEntity().getDataEntityState().setBizChanged(number, false);
        this.comCtrl(view);
        boolean check = view.getModel().getDataChanged();
        HashMap<Integer, String> map = new HashMap<Integer, String>(16);
        map.put(2, ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"ECOEditPlugin_13", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        map.put(6, ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"ECOEditPlugin_14", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        if (check && StringUtils.isEmpty((CharSequence)this.getPageCache().get("closeConfirm"))) {
            String changeDesc = view.getModel().getChangeDesc();
            if (StringUtils.isNotEmpty((CharSequence)changeDesc)) {
                String bomNumber = String.valueOf(view.getModel().getValue("number"));
                String headTag = ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"ECOEditPlugin_15", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                String entryTagA = ResManager.loadKDString((String)"\u7ec4\u4ef6\u4fe1\u606f", (String)"ECOEditPlugin_17", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                String entryTagB = ResManager.loadKDString((String)"\u5de5\u5e8f\u4fe1\u606f", (String)"ECOEditPlugin_22", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                if (changeDesc.indexOf(headTag) == 0) {
                    changeDesc = changeDesc.replace(headTag, this.getChangeDescByChangeTypeA(bomNumber));
                } else if (changeDesc.indexOf(entryTagA) == 0 || changeDesc.indexOf(entryTagB) == 0) {
                    changeDesc = this.getChangeDescByChangeTypeB(bomNumber) + changeDesc;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"ECOEditPlugin_19", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), changeDesc, MessageBoxOptions.OKCancel, ConfirmTypes.Save, new ConfirmCallBackListener("continue_close"), map);
                e.setCancel(true);
                return true;
            }
        } else {
            String changeDesc = this.getPageCache().get("childChange");
            if (StringUtils.isNotEmpty((CharSequence)changeDesc)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"ECOEditPlugin_19", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), changeDesc, MessageBoxOptions.OKCancel, ConfirmTypes.Save, new ConfirmCallBackListener("continue_close"), map);
                e.setCancel(true);
                return true;
            }
        }
        return false;
    }

    private void createProEntryMaterialIdf7(BeforeF7SelectEvent e) {
        ListShowParameter fsp = (ListShowParameter)e.getFormShowParameter();
        if (fsp == null) {
            return;
        }
        int rowIndex = e.getRow();
        QFilter filter = this.getMaterialIdFilter(rowIndex);
        if (filter != null) {
            fsp.getListFilterParameter().setFilter(filter);
        }
        ListShowParameter lsp = fsp;
        CloseCallBack ccb = new CloseCallBack((IFormPlugin)this, "bd_materialinfo");
        if (null != lsp) {
            lsp.setCloseCallBack(ccb);
        }
    }

    private void createBomTypef7(BeforeF7SelectEvent e) {
        QFilter filter;
        ListShowParameter fsp = (ListShowParameter)e.getFormShowParameter();
        if (fsp == null) {
            return;
        }
        int rowIndex = e.getRow();
        if (this.isVersionCtrlD(rowIndex)) {
            filter = new QFilter("purpose", "=", (Object)"A");
            fsp.getListFilterParameter().setFilter(filter);
        }
        if (this.isVersionCtrlB(rowIndex)) {
            filter = new QFilter("purpose", "in", Arrays.asList("A", "C"));
            fsp.getListFilterParameter().setFilter(filter);
        }
    }

    private void createVersionf7(BeforeF7SelectEvent e, String oldVersionField, String type) {
        DynamicObject bomTypeRule;
        DynamicObject bomType;
        DynamicObject pEntryBOMMaterialDO;
        Object pEntryBOMMaterialPKObj;
        Object pEntryOldVersionPKObj;
        ListFilterParameter lfp;
        FormShowParameter fsp = e.getFormShowParameter();
        ListShowParameter lsp = fsp instanceof ListShowParameter ? (ListShowParameter)fsp : null;
        ListFilterParameter listFilterParameter = lfp = lsp == null ? null : lsp.getListFilterParameter();
        if (lfp == null) {
            return;
        }
        int rowIndex = e.getRow();
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
        DynamicObject pEntryOldVersionDO = MMCUtils.getDataModelDynamicObjectData((IDataModel)dm, (String)oldVersionField, (int)rowIndex);
        Object object = pEntryOldVersionPKObj = pEntryOldVersionDO == null ? null : pEntryOldVersionDO.getPkValue();
        if (pEntryOldVersionPKObj != null) {
            qFilterList.add(new QFilter("id", "!=", (Object)Long.parseLong(pEntryOldVersionPKObj.toString())));
        }
        Object object2 = pEntryBOMMaterialPKObj = (pEntryBOMMaterialDO = this.getMaterialMasterByRow(dm, rowIndex)) == null ? null : pEntryBOMMaterialDO.getPkValue();
        if (pEntryBOMMaterialPKObj != null) {
            qFilterList.add(new QFilter("material", "=", (Object)Long.parseLong(pEntryBOMMaterialPKObj.toString())));
        } else {
            qFilterList.add(new QFilter("id", "is null", null));
        }
        qFilterList.add(new QFilter("type", "=", (Object)type));
        if ("A".equals(type) && (bomType = MMCUtils.getDataModelDynamicObjectData((IDataModel)dm, (String)"bomtype", (int)rowIndex)) != null && (bomTypeRule = BOMVersionUtil.getBomTypeDefVersionRule((DynamicObject)bomType)) != null) {
            qFilterList.add(new QFilter("bomversionrule", "=", bomTypeRule.getPkValue()));
        }
        if (!MMCUtils.isEmptyList(qFilterList)) {
            lfp.setQFilters(qFilterList);
            lsp.setListFilterParameter(lfp);
            e.setFormShowParameter((FormShowParameter)lsp);
        }
    }

    private void createBomVersionf7(BeforeF7SelectEvent e) {
        this.createVersionf7(e, "pentryoldversion", "A");
    }

    private void createBomf7(BeforeF7SelectEvent event) {
        Set<Long> bomPKSet;
        ListFilterParameter lfp;
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        BasedataProp pEntryBOMBP = this.getBomOrRouteBaseProp("pentrybom");
        if (pEntryBOMBP == null) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("pentry");
        if (entryGrid.getSelectRows().length == 0) {
            return;
        }
        int rowIndex = entryGrid.getSelectRows()[0];
        DynamicObject bomType = (DynamicObject)this.getModel().getValue("bomtype", rowIndex);
        FormShowParameter fsp = event.getFormShowParameter();
        if (fsp == null) {
            return;
        }
        ListShowParameter lsp = fsp instanceof ListShowParameter ? (ListShowParameter)fsp : null;
        ListFilterParameter listFilterParameter = lfp = lsp == null ? null : lsp.getListFilterParameter();
        if (lfp == null) {
            return;
        }
        CloseCallBack ccb = new CloseCallBack((IFormPlugin)this, "pdm_bom");
        lsp.setCloseCallBack(ccb);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        List defaultFilterList = FilterUtil.buildBaseDataPropertyQFilters((IDataModel)dm, (String)"pdm_mftbom", (IBasedataField)pEntryBOMBP, (String)"pdm", (String)"47150e89000000ac");
        if (!MMCUtils.isEmptyList((List)defaultFilterList)) {
            qFilterList.addAll(defaultFilterList);
        }
        if (!PlatformUtils.isNullSet(bomPKSet = this.getBomOrRouteIdSet("pentrybom", dm))) {
            qFilterList.add(new QFilter("id", "not in", bomPKSet));
        }
        if (bomType != null) {
            qFilterList.add(new QFilter("type", "=", bomType.getPkValue()));
        }
        qFilterList.add(new QFilter("status", "=", (Object)"C"));
        qFilterList.add(new QFilter("enable", "=", (Object)"1"));
        qFilterList.add(new QFilter("type.isecnupdate", "=", (Object)true));
        if (this.isVersionCtrlB(rowIndex)) {
            qFilterList.add(new QFilter("type.purpose", "in", Arrays.asList("A", "C")));
        } else {
            qFilterList.add(new QFilter("type.purpose", "in", Arrays.asList("A", "B", "C")));
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (null != org) {
            qFilterList.add(new QFilter("createorg", "=", (Object)Long.parseLong(org.getPkValue().toString())));
        }
        if (!MMCUtils.isEmptyList(qFilterList)) {
            lfp.setQFilters(qFilterList);
            lsp.setListFilterParameter(lfp);
            event.setFormShowParameter((FormShowParameter)lsp);
        }
    }

    private void createRoutef7(BeforeF7SelectEvent event) {
        Set<Long> routePKSet;
        ListFilterParameter lfp;
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        BasedataProp pEntryRouteBP = this.getBomOrRouteBaseProp("pentryroute");
        if (pEntryRouteBP == null) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("pentry");
        if (entryGrid.getSelectRows().length == 0) {
            return;
        }
        FormShowParameter fsp = event.getFormShowParameter();
        if (fsp == null) {
            return;
        }
        ListShowParameter lsp = fsp instanceof ListShowParameter ? (ListShowParameter)fsp : null;
        ListFilterParameter listFilterParameter = lfp = lsp == null ? null : lsp.getListFilterParameter();
        if (lfp == null) {
            return;
        }
        CloseCallBack ccb = new CloseCallBack((IFormPlugin)this, "pdm_route");
        lsp.setCloseCallBack(ccb);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        List defaultFilterList = FilterUtil.buildBaseDataPropertyQFilters((IDataModel)dm, (String)"pdm_route", (IBasedataField)pEntryRouteBP, (String)"pdm", (String)"47150e89000000ac");
        if (!MMCUtils.isEmptyList((List)defaultFilterList)) {
            qFilterList.addAll(defaultFilterList);
        }
        if (!PlatformUtils.isNullSet(routePKSet = this.getBomOrRouteIdSet("pentryroute", dm))) {
            qFilterList.add(new QFilter("id", "not in", routePKSet));
        }
        qFilterList.add(new QFilter("status", "=", (Object)"C"));
        qFilterList.add(new QFilter("enable", "=", (Object)"1"));
        qFilterList.add(new QFilter("processtype", "=", (Object)"A"));
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (null != org) {
            qFilterList.add(new QFilter("createorg", "=", (Object)Long.parseLong(org.getPkValue().toString())));
        }
        if (!MMCUtils.isEmptyList(qFilterList)) {
            lfp.setQFilters(qFilterList);
            lsp.setListFilterParameter(lfp);
            event.setFormShowParameter((FormShowParameter)lsp);
        }
    }

    private void createRouteVersionf7(BeforeF7SelectEvent e) {
        this.createVersionf7(e, "pentryoldrtversion", "B");
    }

    private void createEcoTypef7(BeforeF7SelectEvent e) {
        if (this.isRouteChange()) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            QFilter filter = new QFilter("statustype", "=", (Object)"A");
            showParameter.getListFilterParameter().getQFilters().add(filter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initDataByBom(e);
    }

    private void initDataByBom(EventObject e) {
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        Object ids = billShowParameter.getCustomParam("ids");
        if (ids == null) {
            return;
        }
        Long bomId = Long.parseLong(ids.toString());
        QFilter qFilter = new QFilter("id", "=", (Object)bomId);
        DynamicObject bom = QueryServiceHelper.queryOne((String)"pdm_mftbom", (String)"createorg,type,material,materialid,version", (QFilter[])qFilter.toArray());
        this.getModel().setValue("org", bom.get("createorg"));
        this.getModel().setValue("type", bom.get("type"));
        this.getModel().setValue("changetype", (Object)"A");
        Date currentDate = new Date();
        DynamicObject ecoType = EcoUtils.getDefaultEcoType((Long)bom.getLong("createorg"));
        IDataModel dataModel = this.getModel();
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("pentrybom", new Object[0]);
        vs.addField("bomtype", new Object[0]);
        vs.addField("proentrymaterial", new Object[0]);
        vs.addField("proentrymaterialid", new Object[0]);
        vs.addField("pentryoldversion", new Object[0]);
        vs.addField("ecotype", new Object[0]);
        vs.addField("pentryvaliddate", new Object[0]);
        vs.addField("pentryexecdate", new Object[0]);
        vs.addField("pentryexecmode", new Object[0]);
        vs.addRow(new Object[]{bomId, bom.getLong("type"), bom.getLong("material"), bom.getLong("materialid"), bom.getLong("version"), ecoType == null ? 0L : ecoType.getLong("id"), currentDate, currentDate, "A"});
        model.batchCreateNewEntryRow("pentry", vs);
        model.endInit();
        this.getView().updateView("pentry");
    }

    public void clearEcoBomAndRouteEntry(IFormView efv, int rowIndex) {
        String ecoBomId;
        IDataModel subdm = efv.getModel();
        if (!subdm.isDataLoaded()) {
            return;
        }
        Object ecoId = subdm.getDataEntity(true).getPkValue();
        String subEntrys = this.getSubEntryNumber();
        this.deleteSubEntrys(efv, subdm, subEntrys);
        boolean isBomChange = this.isBomChange();
        if (isBomChange) {
            this.deleteSubEntrys(efv, subdm, "copentry");
        }
        if (ecoId != null && this.checkIsExistsDB(ecoBomId = String.valueOf(ecoId))) {
            this.getModel().setValue("ecobomid", (Object)0L, rowIndex);
            this.getModel().setValue("ecobomdata", null, rowIndex);
            this.getModel().setValue("ecorouteid", (Object)0L, rowIndex);
            this.getModel().setValue("ecoroutedata", null, rowIndex);
        }
    }

    public void pageRelease(EventObject e) {
        Set ecoBomIdSet;
        super.pageRelease(e);
        String str = this.getPageCache().get("clearEcoBomIds");
        if (!kd.bos.util.StringUtils.isEmpty((String)str) && (ecoBomIdSet = PlatformUtils.ParseStringToLongSet((String)str)) != null && !ecoBomIdSet.isEmpty()) {
            this.clearEhCacheData(ecoBomIdSet, "lccache");
        }
    }

    private void removeAllPEntry() {
        IFormView view = this.getView();
        IDataModel dm = view.getModel();
        DynamicObjectCollection pentry = dm.getEntryEntity("pentry");
        HashSet<Long> ecoBomIdSet = new HashSet<Long>(16);
        HashSet<Long> ecoRouteIdSet = new HashSet<Long>(16);
        HashSet<Long> newVsersionIdSet = new HashSet<Long>(16);
        int size = pentry == null ? 0 : pentry.size();
        String ecoBillNo = dm.getValue("billno").toString();
        for (int i = 0; i < size; ++i) {
            DynamicObject newRtVersion;
            String versionCtrl;
            Long routeId;
            DynamicObject entry = (DynamicObject)pentry.get(i);
            Long ecoBomId = entry.getLong("ecobomid");
            if (ecoBomId != null && !ecoBomId.equals(0L)) {
                ecoBomIdSet.add(ecoBomId);
            }
            if ((routeId = Long.valueOf(entry.getLong("ecorouteid"))) != null && !routeId.equals(0L)) {
                ecoRouteIdSet.add(routeId);
            }
            if (!"B".equals(versionCtrl = entry.getString("entryversioncontrol"))) continue;
            DynamicObject newVersion = entry.getDynamicObject("pentrynewversion");
            if (newVersion != null) {
                newVsersionIdSet.add((Long)newVersion.getPkValue());
            }
            if ((newRtVersion = entry.getDynamicObject("pentrynewrtversion")) == null) continue;
            newVsersionIdSet.add((Long)newRtVersion.getPkValue());
        }
        try {
            String selectBomId;
            String entryinfo;
            String lastindex;
            IPageCache pc = this.getPageCache();
            EntryGrid pEntryEG = (EntryGrid)this.getControl("pentry");
            if (!ecoBomIdSet.isEmpty()) {
                DeleteServiceHelper.delete((String)"pdm_ecobom", (QFilter[])new QFilter[]{new QFilter("id", "in", ecoBomIdSet)});
                this.clearEhCacheData(ecoBomIdSet, this.getSerialiationCacheType());
                for (Long data : ecoBomIdSet) {
                    pc.remove(String.valueOf(data));
                }
            }
            if (!ecoRouteIdSet.isEmpty()) {
                DeleteServiceHelper.delete((String)"pdm_ecoroute", (QFilter[])new QFilter[]{new QFilter("id", "in", ecoRouteIdSet)});
                this.clearEhCacheData(ecoRouteIdSet, this.getSerialiationCacheType());
                for (Long data : ecoRouteIdSet) {
                    pc.remove(String.valueOf(data));
                }
            }
            if (!newVsersionIdSet.isEmpty()) {
                QFilter qfilter = new QFilter("id", "in", newVsersionIdSet);
                qfilter.and(new QFilter("ecnbillno", "=", (Object)ecoBillNo));
                DeleteServiceHelper.delete((String)"bd_bomversion_new", (QFilter[])new QFilter[]{qfilter});
            }
            if (StringUtils.isNotEmpty((CharSequence)(lastindex = pc.get("lastindex")))) {
                pc.remove("lastindex");
                pc.remove("lastindexchangetype");
            }
            if (StringUtils.isNotEmpty((CharSequence)(entryinfo = pc.get("mmc_eco_entryinfo")))) {
                pc.remove("mmc_eco_entryinfo");
            }
            if (StringUtils.isNotEmpty((CharSequence)(selectBomId = pc.get("mmc_pdm_selectbomid")))) {
                pc.remove("mmc_pdm_selectbomid");
            }
            this.getView().getModel().deleteEntryData("pentry");
            if (pEntryEG != null) {
                pEntryEG.clearEntryState();
            }
        }
        catch (Exception e1) {
            logger.error((Throwable)e1);
            throw new KDBizException((Throwable)e1, new ErrorCode("delete-ecobom-fial", String.format(ResManager.loadKDString((String)"\u5220\u9664\u5de5\u7a0b\u53d8\u66f4\u6570\u636e\u5931\u8d25\u3002", (String)"ECOEditPlugin_25", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), new Object[0])), new Object[0]);
        }
        this.showEcobomPage("", OperationStatus.ADDNEW, false);
    }
}

