/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.ecoplatform;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.query.PageRowCacheUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.business.ecoplatform.AddEffectOrderBillBusiness;
import kd.mmc.pdm.business.ecoplatform.GetEcoEffectManuftechBusiness;
import kd.mmc.pdm.business.ecoplatform.GetEcoEffectOrderBusiness;
import kd.mmc.pdm.business.ecoplatform.estimate.step.EstimateUtils;
import kd.mmc.pdm.common.bom.ecoplatform.OrderMutexLockUtils;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.common.util.MMCUtils;
import kd.mmc.pdm.common.util.PdmParamSetHelper;

public class EcoBomEffectOrderPlugin
extends AbstractFormPlugin
implements TabSelectListener,
HyperLinkClickListener,
ProgresssListener {
    private static final Log log = LogFactory.getLog(EcoBomEffectOrderPlugin.class);
    private static final String PGCACHE_CHAR = "pgcache_";
    private static final String TABPAGE_EFFECTRANGE = "tabpage_effectrange";
    private static final String TABPAGE_EFFECTORDER = "tabpage_effectorder";
    private static final String TABPAGE_EFFECTMANFTECH = "tabpage_effectmaftech";
    private static final String BILLLISTAP = "billlistap";
    private static final String PROP_GETDATATYPE = "getdatatype";
    public static final DBRoute scmDBRoute = new DBRoute("scm");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl("tabap");
        if (tab != null) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
        BillList effectRangeBillListAp = (BillList)this.getControl(BILLLISTAP);
        effectRangeBillListAp.addHyperClickListener((HyperLinkClickListener)this);
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        if (progressBar != null) {
            progressBar.addProgressListener((ProgresssListener)this);
        }
    }

    private boolean isFirstLoadTab(String tabPageKey) {
        String cacheValue = this.getView().getPageCache().get(PGCACHE_CHAR + tabPageKey);
        return cacheValue == null || !"true".equalsIgnoreCase(cacheValue);
    }

    private void setFirstLoadTab(String tabPageKey) {
        this.getView().getPageCache().put(PGCACHE_CHAR + tabPageKey, "true");
    }

    private String getCacheEntrys() {
        return this.getPageCache().get("pc_ecoBomEntryIdSet");
    }

    private void setCacheEntrys(String entrys) {
        this.getPageCache().put("pc_ecoBomEntryIdSet", entrys);
    }

    private String getPCacheEntrys() {
        return this.getPageCache().get("pc_ecnPEntryIdSet");
    }

    private void setPCacheEntrys(String pentrys) {
        this.getPageCache().put("pc_ecnPEntryIdSet", pentrys);
    }

    private void setCacheOrgId(String orgIds) {
        this.getPageCache().put("pc_orgid", orgIds);
    }

    private Long getCacheOrgId() {
        String orgIds = this.getPageCache().get("pc_orgid");
        return Long.parseLong(orgIds);
    }

    private void setCacheChangeType(String changeType) {
        this.getPageCache().put("pc_changetype", changeType);
    }

    private String getCacheChangeType() {
        return this.getPageCache().get("pc_changetype");
    }

    private void setPCacheCopEntrys(String copentrys) {
        this.getPageCache().put("pc_ecoBomCopEntryIdSet", copentrys);
    }

    private String getCacheCopEntrys() {
        return this.getPageCache().get("pc_ecoBomCopEntryIdSet");
    }

    private void setCacheLockMaps(Map<String, Set<Long>> successIdMaps) {
        String lockMaps = "";
        if (successIdMaps != null && !successIdMaps.isEmpty()) {
            lockMaps = SerializationUtils.serializeToBase64(successIdMaps);
        }
        this.getPageCache().put("pc_lockmaps", lockMaps);
    }

    private boolean isCanEffectOrder() {
        Set<Long> ids = this.getQueryEcoBomEntryIdSet();
        return !PlatformUtils.isNullSet(ids);
    }

    private Map<String, Set<Long>> getCacheLockMaps() {
        String lockMaps = this.getPageCache().get("pc_lockmaps");
        if (StringUtils.isEmpty((String)lockMaps)) {
            return new HashMap<String, Set<Long>>(16);
        }
        return (Map)SerializationUtils.deSerializeFromBase64((String)lockMaps);
    }

    private void setCacheLogId(String logIds) {
        this.getPageCache().put("pc_logid", logIds);
    }

    private Long getCacheLogId() {
        String logIds = this.getPageCache().get("pc_logid");
        if (StringUtils.isEmpty((String)logIds)) {
            return 0L;
        }
        return Long.parseLong(logIds);
    }

    private void setCacheData() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (params != null) {
            this.setCacheEntrys(((JSONArray)params.get("entrys")).toJSONString());
            this.setPCacheEntrys(((JSONArray)params.get("pentrys")).toJSONString());
            this.setCacheOrgId(params.get("orgid").toString());
            this.setCacheChangeType(params.get("changetype").toString());
            this.setPCacheCopEntrys(((JSONArray)params.get("copentrys")).toJSONString());
        }
    }

    private Set<Long> getQueryEcoBomEntryIdSet() {
        String entrys = this.getCacheEntrys();
        if (StringUtils.isEmpty((String)entrys)) {
            return new HashSet<Long>(16);
        }
        return PlatformUtils.ParseStringToLongSet((String)entrys);
    }

    private Set<Long> getQueryEcoBomCopEntryIdSet() {
        String entrys = this.getCacheCopEntrys();
        if (StringUtils.isEmpty((String)entrys)) {
            return new HashSet<Long>(16);
        }
        return PlatformUtils.ParseStringToLongSet((String)entrys);
    }

    private Set<Long> getQueryEcnPEntryIdSet() {
        String pentrys = this.getPCacheEntrys();
        if (StringUtils.isEmpty((String)pentrys)) {
            return new HashSet<Long>(16);
        }
        return PlatformUtils.ParseStringToLongSet((String)pentrys);
    }

    public void initialize() {
        super.initialize();
        this.setCacheData();
    }

    public void tabSelected(TabSelectEvent event) {
        if (event == null) {
            return;
        }
        String tabPageKey = event.getTabKey();
        if (MMCUtils.isEmptyString((String)tabPageKey)) {
            return;
        }
        if (!this.isFirstLoadTab(tabPageKey)) {
            return;
        }
        if (tabPageKey.equalsIgnoreCase(TABPAGE_EFFECTORDER)) {
            this.getMftStockData();
        } else if (tabPageKey.equalsIgnoreCase(TABPAGE_EFFECTMANFTECH)) {
            this.getManftechData();
        }
        this.setFirstLoadTab(tabPageKey);
    }

    public Long startEffectRangeData(Set<Long> ecoBomEntryIdSet, Set<Long> ecoBomCopEntryIdSet, Set<Long> ecnPEntryIdSet) {
        Long planProgramId = this.getPlanprogramId();
        if (PlatformUtils.isNullLong((Long)planProgramId)) {
            Long orgId = this.getCacheOrgId();
            DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org", (String)"number,name");
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f9d\u636e\u53d8\u66f4\u7ec4\u7ec7\u201c%1$s\u201d\u672a\u627e\u5230\u5ba1\u6838\u53ef\u7528\u7684\u5f71\u54cd\u8303\u56f4\u65b9\u6848\u3002", (String)"EcoBomEffectOrderPlugin_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), org.getString("name")));
            return 0L;
        }
        Long logid = (Long)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IMRPCalcRuntimeService", (String)"initRuntime", (Object[])new Object[]{"mrp_caculate_log"});
        DynamicObject log = this.writeLog(logid, planProgramId);
        DynamicObject org = log.getDynamicObject("createorg");
        String title = ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5f71\u54cd\u8303\u56f4", (String)"EcoBomEffectOrderPlugin_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
        this.cacheRedisBomEntryIdSet(ecoBomEntryIdSet, ecoBomCopEntryIdSet, ecnPEntryIdSet, logid);
        Long evntid = (Long)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IMRPCalcRuntimeService", (String)"startCalc", (Object[])new Object[]{logid, null, org.getLong("id"), org.getString("name"), "pdm_ecoeffectrange_exec", title, "mrp_caculate_log"});
        return evntid;
    }

    private void cacheRedisBomEntryIdSet(Set<Long> ecoBomEntryIdSet, Set<Long> ecoBomCopEntryIdSet, Set<Long> ecnPEntryIdSet, Long logid) {
        DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("mmc-pdm-ecoestimate");
        String keyStringA = EstimateUtils.genRedisEcoBomEntryIdKey((Long)logid);
        String keyStringB = EstimateUtils.genRedisEcnPEntryIdKey((Long)logid);
        String keyStringC = EstimateUtils.genRedisIsParentQueryKey((Long)logid);
        String keyStringD = EstimateUtils.genRedisEcoBomCopEntryIdKey((Long)logid);
        String valueA = ecoBomEntryIdSet.toString();
        String valueB = ecnPEntryIdSet.toString();
        String valueC = "B".equals(this.getCacheChangeType()) ? "true" : "false";
        String valueD = ecoBomCopEntryIdSet.toString();
        int redisTimeLong = EstimateUtils.getRedisTimeLong();
        if (EstimateUtils.getRedisByteMode()) {
            redisCache.put(keyStringA, PlatformUtils.encode((Object)valueA), redisTimeLong);
            redisCache.put(keyStringB, PlatformUtils.encode((Object)valueB), redisTimeLong);
            redisCache.put(keyStringC, PlatformUtils.encode((Object)valueC), redisTimeLong);
            redisCache.put(keyStringD, PlatformUtils.encode((Object)valueD), redisTimeLong);
        } else {
            redisCache.put(keyStringA, (Object)valueA, redisTimeLong);
            redisCache.put(keyStringB, (Object)valueB, redisTimeLong);
            redisCache.put(keyStringC, (Object)valueC, redisTimeLong);
            redisCache.put(keyStringD, (Object)valueD, redisTimeLong);
        }
    }

    public void queryDiffData(Set<Long> ecoEntryIdSet, String changeType) {
        int taskNum = PdmParamSetHelper.getIntParamValue((String)"ecoPlatFormEffectOrder_taskNum");
        this.setCacheGridList(null, changeType);
        if (ecoEntryIdSet.size() >= taskNum) {
            HashMap<String, String> para = new HashMap<String, String>();
            para.put("formId", "pdm_effectorderprogress");
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "pdm_effectorderprogress");
            showParameter.setCloseCallBack(closeCallBack);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("entrys", ecoEntryIdSet);
            showParameter.setCustomParam("rowSize", (Object)ecoEntryIdSet.size());
            showParameter.setCustomParam("operateKey", (Object)"");
            showParameter.setCustomParam("changeType", (Object)changeType);
            this.getView().showForm(showParameter);
        } else {
            List<Map<String, Object>> gridList = null;
            if ("A".equals(changeType)) {
                gridList = this.queryDataByEcoBomEntryId(ecoEntryIdSet, false);
            } else if ("B".equals(changeType)) {
                gridList = this.queryDataByEcoRouteEntryId(ecoEntryIdSet, false);
            }
            this.setCacheGridList(gridList, changeType);
            this.initEntryEntity(gridList, Boolean.TRUE, changeType);
        }
    }

    public Long getPlanprogramId() {
        Long orgId = this.getCacheOrgId();
        QFilter qFilter = new QFilter("orgentryentity.entrydemandorg", "=", (Object)orgId);
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("estimatetype", "=", (Object)"B"));
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"pdm_planprogram_eco", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (coll == null || coll.isEmpty()) {
            return 0L;
        }
        return ((DynamicObject)coll.get(0)).getLong("id");
    }

    private DynamicObject writeLog(Long logId, Long planProgramId) {
        String title = ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5f71\u54cd\u8303\u56f4", (String)"EcoBomEffectOrderPlugin_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
        DynamicObject schedulingScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)planProgramId, (String)"pdm_planprogram_eco");
        DynamicObject caculateLog = BusinessDataServiceHelper.loadSingleFromCache((Object)logId, (String)"mrp_caculate_log");
        DynamicObject org = schedulingScheme.getDynamicObject("createorg");
        Date currentDate = new Date();
        caculateLog.set("createorg", (Object)org);
        caculateLog.set("useorg", (Object)org);
        caculateLog.set("status", (Object)"C");
        caculateLog.set("enable", (Object)"1");
        caculateLog.set("plantype", (Object)title);
        caculateLog.set("plangram", (Object)schedulingScheme.getLong("id"));
        caculateLog.set("programname", (Object)schedulingScheme.getString("name"));
        caculateLog.set("programnumber", (Object)schedulingScheme.getString("number"));
        caculateLog.set("plangramentity", (Object)"pdm_planprogram_eco");
        caculateLog.set("plandate", (Object)currentDate);
        caculateLog.set("creator", (Object)RequestContext.get().getCurrUserId());
        caculateLog.set("startdate", (Object)currentDate);
        caculateLog.set("operatmode", (Object)title);
        caculateLog.set("operatmodekey", (Object)"pdm_ecoeffectrange_exec");
        caculateLog.set("runtype", (Object)"ER");
        SaveServiceHelper.update((DynamicObject)caculateLog);
        return caculateLog;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.queryEffectRangeData(0L, "");
        String changeType = this.getCacheChangeType();
        if ("B".equals(changeType)) {
            this.getModel().setValue(PROP_GETDATATYPE, (Object)"B");
            this.getView().updateView(PROP_GETDATATYPE);
            this.getView().setEnable(Boolean.FALSE, new String[]{PROP_GETDATATYPE});
        }
        this.setEffectOrderTagVisible(changeType, this.getDataType());
        this.setEffectManftechTagVisible(changeType, this.getDataType());
        this.loadEffectRangeData();
    }

    public void setEffectManftechTagVisible(String changeType, String getDateType) {
        boolean isVisible = "B".equals(getDateType) && "B".equals(changeType) && this.isCanEffectOrder();
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{TABPAGE_EFFECTMANFTECH});
    }

    public void setEffectOrderTagVisible(String changeType, String getDateType) {
        boolean isVisible = "A".equals(getDateType) && "A".equals(changeType) && this.isCanEffectOrder();
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{TABPAGE_EFFECTORDER});
    }

    public void loadEffectRangeData() {
        if (!this.isFirstLoadTab(TABPAGE_EFFECTRANGE)) {
            return;
        }
        Set<Long> ecoBomEntryIdSet = this.getQueryEcoBomEntryIdSet();
        Set<Long> ecoBomCopEntryIdSet = this.getQueryEcoBomCopEntryIdSet();
        if (PlatformUtils.isNullSet(ecoBomEntryIdSet) && PlatformUtils.isNullSet(ecoBomCopEntryIdSet)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u672a\u89e3\u6790\u51fa\u5de5\u7a0b\u53d8\u66f4\u5206\u5f55ID\u96c6\u5408\u6570\u636e\u3002", (String)"EcoBomEffectOrderPlugin_2", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return;
        }
        Set<Long> ecnPEntryIdSet = this.getQueryEcnPEntryIdSet();
        Long logId = this.startEffectRangeData(ecoBomEntryIdSet, ecoBomCopEntryIdSet, ecnPEntryIdSet);
        IFormView fv = this.getView();
        if (PlatformUtils.isNullLong((Long)logId)) {
            fv.setVisible(Boolean.FALSE, new String[]{"image_fail", "image_success", "calculatepro", "progressbarap", "stepname", "labelap1"});
            return;
        }
        fv.setVisible(Boolean.TRUE, new String[]{"image_fail", "image_success", "calculatepro", "progressbarap", "stepname", "labelap1"});
        this.setCacheLogId(String.valueOf(logId));
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        if (progressBar != null) {
            progressBar.setPercent(1);
            progressBar.start();
        }
        this.setFirstLoadTab(TABPAGE_EFFECTRANGE);
    }

    public void queryEffectRangeData(Long logId, String getDataType) {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        PageRowCacheUtils.clearPageRowcache((String)this.getView().getPageId(), (String)BILLLISTAP);
        QFilter qFilter = null;
        if (PlatformUtils.isNullLong((Long)logId)) {
            billList.setFilter(new QFilter("id", "=", (Object)0L));
            qFilter = new QFilter("id", "=", (Object)0L);
        } else {
            billList.setFilter(new QFilter("ecocallog.id", "=", (Object)logId));
            qFilter = new QFilter("ecocallog.id", "=", (Object)logId);
        }
        if (!StringUtils.isEmpty((String)getDataType)) {
            qFilter = qFilter.and(new QFilter(PROP_GETDATATYPE, "=", (Object)getDataType));
        }
        FilterParameter filterParameter = new FilterParameter();
        filterParameter.setFilter(qFilter);
        billList.setFilterParameter(filterParameter);
        billList.refreshData();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (this.getPageCache().get("isIgnoreChangeListener") == "true") {
            return;
        }
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object oldValue = changeData[0].getOldValue();
        Object newValue = changeData[0].getNewValue();
        if ("isshowchild".equals(name)) {
            if (Objects.equals(oldValue, newValue)) {
                return;
            }
            this.initEntryEntity(this.getCacheGridList(), Boolean.FALSE, "A");
        }
        if (PROP_GETDATATYPE.equals(name)) {
            if (Objects.equals(oldValue, newValue)) {
                return;
            }
            String changeType = (String)newValue;
            this.setEffectOrderTagVisible(this.getCacheChangeType(), changeType);
            this.setEffectManftechTagVisible(this.getCacheChangeType(), changeType);
            Long logId = this.getCacheLogId();
            if (PlatformUtils.isNullLong((Long)logId)) {
                return;
            }
            this.queryEffectRangeData(logId, changeType);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (PlatformUtils.isDisableGroupNo()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entrygroupno"});
        }
    }

    private void getMftStockData() {
        Set<Long> ecoBomEntryIdSet = this.getQueryEcoBomEntryIdSet();
        if (PlatformUtils.isNullSet(ecoBomEntryIdSet)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u672a\u89e3\u6790\u51fa\u5de5\u7a0b\u53d8\u66f4\u5206\u5f55ID\u96c6\u5408\u6570\u636e\u3002", (String)"EcoBomEffectOrderPlugin_2", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.queryDiffData(ecoBomEntryIdSet, "A");
    }

    private void getManftechData() {
        Set<Long> ecoRouteEntryIdSet = this.getQueryEcoBomEntryIdSet();
        if (PlatformUtils.isNullSet(ecoRouteEntryIdSet)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u672a\u89e3\u6790\u51fa\u5de5\u7a0b\u53d8\u66f4\u5206\u5f55ID\u96c6\u5408\u6570\u636e\u3002", (String)"EcoBomEffectOrderPlugin_2", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.queryDiffData(ecoRouteEntryIdSet, "B");
    }

    private List<Map<String, Object>> queryDataByEcoBomEntryId(Set<Long> ecoBomEntryIdSet, boolean isQueryRefData) {
        GetEcoEffectOrderBusiness business = GetEcoEffectOrderBusiness.getInstance();
        Map allData = business.getEffectAllData(ecoBomEntryIdSet, isQueryRefData, true);
        Set allEcoBillIdSet = (Set)allData.get("ecoBillIdSet");
        Set allChildBomIdSet = (Set)allData.get("childBomIdSet");
        Set allEcoBomEntryIdSet = (Set)allData.get("allEcoBomEntryIdSet");
        return business.genDiffStockData(allChildBomIdSet, allEcoBillIdSet, allEcoBomEntryIdSet, null);
    }

    private List<Map<String, Object>> queryDataByEcoRouteEntryId(Set<Long> ecoRouteEntryIdSet, boolean isQueryRefData) {
        GetEcoEffectManuftechBusiness business = GetEcoEffectManuftechBusiness.getInstance();
        Map allData = business.getEffectAllData(ecoRouteEntryIdSet, isQueryRefData, true);
        Set allEcoBillIdSet = (Set)allData.get("ecoBillIdSet");
        Set allRouteIdSet = (Set)allData.get("routeIdSet");
        Set allEcoRouteEntryIdSet = (Set)allData.get("allEcoRouteEntryIdSet");
        return business.genDiffManuftechData(allRouteIdSet, allEcoBillIdSet, allEcoRouteEntryIdSet, null);
    }

    private void setCacheGridList(List<Map<String, Object>> gridList, String changeType) {
        this.clearAllLocks(changeType);
        if (PlatformUtils.isNullList(gridList)) {
            this.getPageCache().put("pc_gridlistjsonstring", "");
            return;
        }
        String jsonString = JSONArray.toJSONString(gridList);
        this.getPageCache().put("pc_gridlistjsonstring", jsonString);
    }

    private List<Map<String, Object>> getCacheGridList() {
        String jsonString = this.getPageCache().get("pc_gridlistjsonstring");
        if (StringUtils.isEmpty((String)jsonString)) {
            return new ArrayList<Map<String, Object>>(16);
        }
        return JSONArray.parseArray((String)jsonString);
    }

    private QFilter getQueryFilter() {
        return null;
    }

    private boolean isContinueRow(Map<String, Object> dataMap) {
        Object parentStockEntryId = dataMap.get("parentstockentryid");
        if (parentStockEntryId instanceof Long) {
            return !((Long)parentStockEntryId).equals(0L);
        }
        return Boolean.FALSE;
    }

    private String getEntryEntityName(String changeType) {
        return this.isBomChange(changeType) ? "entryentity" : "entryentitysfc";
    }

    private boolean isBomChange(String changeType) {
        return "A".equals(changeType);
    }

    private void initEntryEntity(List<Map<String, Object>> gridList, boolean isAddLock, String changeType) {
        String lockMsg;
        String entryEntityName = this.getEntryEntityName(changeType);
        this.getModel().deleteEntryData(entryEntityName);
        EntryGrid entryEntity = (EntryGrid)this.getControl(entryEntityName);
        AbstractFormDataModel model = (AbstractFormDataModel)entryEntity.getModel();
        if (PlatformUtils.isNullList(gridList)) {
            return;
        }
        boolean isBomChange = this.isBomChange(changeType);
        if (isAddLock && !StringUtils.isEmpty((String)(lockMsg = this.addAllLocks(gridList, changeType)))) {
            if (isBomChange) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5df2\u9501\u5b9a\uff1a%1$s\u3002", (String)"EcoBomEffectOrderPlugin_3", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), lockMsg));
            } else {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u88ab\u9501\u5b9a\uff1a%1$s", (String)"EcoBomEffectOrderPlugin_21", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), lockMsg));
            }
        }
        Map<String, Object> dataMap = gridList.get(0);
        int fieldSize = dataMap.size();
        String[] fieldArray = new String[fieldSize];
        int seq = 0;
        for (Map.Entry<String, Object> maps : dataMap.entrySet()) {
            String field;
            fieldArray[seq] = field = maps.getKey();
            ++seq;
        }
        boolean isShowChild = this.getModel().getDataEntity().getBoolean("isshowchild");
        TableValueSetter vs = new TableValueSetter(fieldArray);
        model.beginInit();
        for (int i = 0; i < gridList.size(); ++i) {
            dataMap = gridList.get(i);
            if (isBomChange && !isShowChild && this.isContinueRow(dataMap)) continue;
            ArrayList<Object[]> listValues = new ArrayList<Object[]>(16);
            ArrayList<Object> listValue = new ArrayList<Object>(fieldSize);
            for (int j = 0; j < fieldSize; ++j) {
                String field = fieldArray[j];
                Object value = dataMap.get(field);
                listValue.add(value);
            }
            listValues.add(listValue.toArray());
            if (listValues.isEmpty()) continue;
            for (Object[] value : listValues) {
                vs.addRow(value);
            }
        }
        model.batchCreateNewEntryRow(entryEntityName, vs);
        model.endInit();
        this.getView().updateView(entryEntityName);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        if ("changeop".equalsIgnoreCase(operateKey) || "changeopsfc".equalsIgnoreCase(operateKey)) {
            boolean chkMsg;
            Set<Long> keyValues;
            boolean isBomChange = "changeop".equalsIgnoreCase(operateKey);
            RefObject afterConfirm = new RefObject();
            if (operate.getOption().tryGetVariableValue("afterconfirm", afterConfirm)) {
                return;
            }
            Set<Long> set = keyValues = isBomChange ? this.getKeyValues() : this.getKeyValuesSfc();
            if (keyValues == null) {
                e.setCancel(true);
                return;
            }
            if (keyValues.isEmpty()) {
                String msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u53d8\u66f4\u7684\u6570\u636e\u3002", (String)"EcoBomEffectOrderPlugin_4", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                e.setCancel(true);
                return;
            }
            List<Map<String, Object>> allData = this.getCacheGridList();
            if (isBomChange && !(chkMsg = this.checkData(e, allData))) {
                e.setCancel(true);
                return;
            }
            if (isBomChange) {
                this.dealEntryData(keyValues, e, allData);
            } else {
                this.dealEntryDataSfc(keyValues, e, allData);
            }
        } else if ("querywithlog".equalsIgnoreCase(operateKey) || "querywithlogsfc".equalsIgnoreCase(operateKey)) {
            Set<Long> ecoEntryIdSet = this.getQueryEcoBomEntryIdSet();
            if (PlatformUtils.isNullSet(ecoEntryIdSet)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u672a\u89e3\u6790\u51fa\u5de5\u7a0b\u53d8\u66f4\u5206\u5f55ID\u96c6\u5408\u6570\u636e\u3002", (String)"EcoBomEffectOrderPlugin_2", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            String logs = this.queryLogs(ecoEntryIdSet, "querywithlog".equalsIgnoreCase(operateKey) ? "A" : "B");
            if (logs == null || "".equals(logs)) {
                String msg = ResManager.loadKDString((String)"\u65e5\u5fd7\u5206\u6790\u6570\u636e\u7f3a\u5931\u3002", (String)"EcoBomEffectOrderPlugin_6", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                e.setCancel(true);
                return;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("pdm_ecologdetial");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.setCustomParam("msgString", (Object)logs);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pdm_ecologdetial"));
            this.getView().showForm(showParameter);
        } else if ("openlog".equalsIgnoreCase(operateKey)) {
            Long logId = this.getCacheLogId();
            if (PlatformUtils.isNullLong((Long)logId)) {
                e.setCancel(true);
                return;
            }
            BillShowParameter formShowParameter = new BillShowParameter();
            formShowParameter.setFormId("pdm_ecocal_log");
            formShowParameter.setStatus(OperationStatus.VIEW);
            formShowParameter.setPkId((Object)logId);
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setCustomParam("id", (Object)logId);
            formShowParameter.setCustomParam("forward", (Object)"ER");
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5f71\u54cd\u8303\u56f4", (String)"EcoBomEffectOrderPlugin_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            this.getView().showForm((FormShowParameter)formShowParameter);
        } else if ("refreshresult".equalsIgnoreCase(operateKey)) {
            Long logId = this.getCacheLogId();
            if (PlatformUtils.isNullLong((Long)logId)) {
                e.setCancel(true);
                return;
            }
            this.queryEffectRangeData(logId, this.getDataType());
        }
    }

    private String queryLogs(Set<Long> ecoEntryIdSet, String changeType) {
        if (this.isBomChange(changeType)) {
            GetEcoEffectOrderBusiness business = GetEcoEffectOrderBusiness.getInstance();
            Map allData = business.getEffectAllData(ecoEntryIdSet, false, true);
            Set allEcoBillIdSet = (Set)allData.get("ecoBillIdSet");
            Set allChildBomIdSet = (Set)allData.get("childBomIdSet");
            Set allEcoBomEntryIdSet = (Set)allData.get("allEcoBomEntryIdSet");
            if (PlatformUtils.isNullSet((Set)allEcoBomEntryIdSet)) {
                String msg = ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u5de5\u7a0b\u53d8\u66f4\u6570\u636e\u3002", (String)"EcoBomEffectOrderPlugin_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                return "";
            }
            return business.genDiffStockDataWithLog(allChildBomIdSet, allEcoBillIdSet, allEcoBomEntryIdSet, "");
        }
        GetEcoEffectManuftechBusiness business = GetEcoEffectManuftechBusiness.getInstance();
        Map allData = business.getEffectAllData(ecoEntryIdSet, false, true);
        Set allEcoBillIdSet = (Set)allData.get("ecoBillIdSet");
        Set routeIdSet = (Set)allData.get("routeIdSet");
        Set allEcoRouteEntryIdSet = (Set)allData.get("allEcoRouteEntryIdSet");
        if (PlatformUtils.isNullSet((Set)allEcoRouteEntryIdSet)) {
            String msg = ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u5de5\u7a0b\u53d8\u66f4\u6570\u636e\u3002", (String)"EcoBomEffectOrderPlugin_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            return "";
        }
        return business.genDiffManuftechDataWithLog(routeIdSet, allEcoBillIdSet, allEcoRouteEntryIdSet, "");
    }

    private String getDataType() {
        return (String)this.getModel().getValue(PROP_GETDATATYPE);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("changeop".equalsIgnoreCase(operateKey)) {
            this.toMftStockChange();
        } else if ("changeopsfc".equalsIgnoreCase(operateKey)) {
            this.toManftechChange();
        }
    }

    private String getMaterialNumber(Long materialId) {
        DynamicObject material = BusinessDataServiceHelper.loadSingleFromCache((Object)materialId, (String)"bd_material", (String)"number");
        return material == null ? "" : material.getString("number");
    }

    private boolean checkData(BeforeDoOperationEventArgs evt, List<Map<String, Object>> allData) {
        Set<Long> keyValues = this.getKeyValues();
        if (keyValues == null) {
            evt.setCancel(true);
            return false;
        }
        if (keyValues.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u5de5\u5355\u6570\u636e\u3002", (String)"EcoBomEffectOrderPlugin_7", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return false;
        }
        HashMap<String, Long> stockEntryMap = new HashMap<String, Long>(16);
        HashMap<String, HashSet<Long>> mutexParentChildMap = new HashMap<String, HashSet<Long>>(16);
        int gridCount = allData.size();
        for (int row = 0; row < gridCount; ++row) {
            Map<String, Object> dynamicObject = allData.get(row);
            Long sameBatchId = PlatformUtils.getLongValue(dynamicObject, (String)"samebatchid");
            if (!keyValues.contains(sameBatchId)) continue;
            String orderType = PlatformUtils.getStringValue(dynamicObject, (String)"ordertype");
            Long stockId = PlatformUtils.getLongValue(dynamicObject, (String)"stockid");
            Long materialMftId = PlatformUtils.getLongValue(dynamicObject, (String)"material");
            String keyString = orderType + "_" + stockId + "_" + materialMftId;
            HashSet<Long> sameBatchIdSet = (HashSet<Long>)mutexParentChildMap.get(keyString);
            if (sameBatchIdSet == null) {
                sameBatchIdSet = new HashSet<Long>(16);
            }
            sameBatchIdSet.add(sameBatchId);
            mutexParentChildMap.put(keyString, sameBatchIdSet);
        }
        for (Long sameBatchId : keyValues) {
            HashSet<Long> actimeSet = new HashSet<Long>(16);
            int seq = 0;
            for (int row = 0; row < gridCount; ++row) {
                Map<String, Object> dynamicObject = allData.get(row);
                if (!sameBatchId.equals(PlatformUtils.getLongValue(dynamicObject, (String)"samebatchid"))) continue;
                Date actTime = PlatformUtils.getDateValue(dynamicObject, (String)"acttime");
                actimeSet.add(actTime.getTime());
                seq = PlatformUtils.getIntValue(dynamicObject, (String)"seq");
                String orderType = PlatformUtils.getStringValue(dynamicObject, (String)"ordertype");
                boolean isAddMaterial = "C".equals(PlatformUtils.getStringValue(dynamicObject, (String)"changetype"));
                Long stockId = PlatformUtils.getLongValue(dynamicObject, (String)"stockid");
                Long bomentryId = PlatformUtils.getLongValue(dynamicObject, (String)"bomentryid");
                Long parentmaterial = PlatformUtils.getLongValue(dynamicObject, (String)"parentmaterial");
                Long stockEntryId = PlatformUtils.getLongValue(dynamicObject, (String)"stockentryid");
                Long bomWorkStationId = PlatformUtils.getLongValue(dynamicObject, (String)"bomworkstation");
                Long materialId = PlatformUtils.getLongValue(dynamicObject, (String)"materialmasterid");
                String keyString = orderType + "_" + stockId;
                keyString = !isAddMaterial ? keyString + "_" + stockEntryId : keyString + "_" + bomentryId + "_" + materialId + "_" + (bomWorkStationId == null ? 0L : bomWorkStationId);
                if (stockEntryMap.containsKey(keyString) && !sameBatchId.equals(stockEntryMap.get(keyString))) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u201c%1$s\u201d\u7684\u5206\u5f55\u7269\u6599\u201c%2$s\u201d\u5bf9\u5e94\u7684\u6570\u636e\u5b58\u5728\u591a\u6b21\u53d8\u66f4\uff0c\u8bf7\u5206\u6279\u9009\u62e9\u5904\u7406\u3002", (String)"EcoBomEffectOrderPlugin_8", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), PlatformUtils.getStringValue(dynamicObject, (String)"stockno"), this.getMaterialNumber(materialId)));
                    evt.setCancel(true);
                    return false;
                }
                if (PlatformUtils.getBooleanValue(dynamicObject, (String)"islock")) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u201c%1$s\u201d\u5df2\u88ab\u9501\u5b9a\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u53d8\u66f4\u3002", (String)"EcoBomEffectOrderPlugin_9", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), PlatformUtils.getStringValue(dynamicObject, (String)"stockno")));
                    evt.setCancel(true);
                    return false;
                }
                stockEntryMap.put(keyString, sameBatchId);
                keyString = orderType + "_" + stockId + "_" + parentmaterial;
                Set sameBatchIdSet = (Set)mutexParentChildMap.get(keyString);
                if (sameBatchIdSet == null || sameBatchIdSet.isEmpty() || sameBatchIdSet.contains(sameBatchId)) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u201c%1$s\u201d\u7684\u5206\u5f55\u7269\u6599\u201c%2$s\u201d\u4e0e\u524d\u9762\u6240\u9009\u7684\u6570\u636e\u5b58\u5728\u4e0a\u4e0b\u5c42\u7ea7\u5173\u7cfb\uff0c\u8bf7\u5206\u6279\u9009\u62e9\u5904\u7406\u3002", (String)"EcoBomEffectOrderPlugin_28", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), PlatformUtils.getStringValue(dynamicObject, (String)"stockno"), this.getMaterialNumber(materialId)));
                evt.setCancel(true);
                return false;
            }
            if (actimeSet.size() <= 1) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c %s \u884c\u5206\u5f55\u5bf9\u5e94\u7684\u5de5\u7a0b\u53d8\u66f4\u5b9e\u65bd\u65f6\u95f4\u4e0e\u5176\u5b83\u884c\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"EcoBomEffectOrderPlugin_10", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), seq));
            evt.setCancel(true);
            return false;
        }
        return true;
    }

    private Set<Long> getKeyValues() {
        int[] rows;
        HashSet<Long> keyValues = new HashSet<Long>(16);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        for (int row : rows = entryGrid.getSelectRows()) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(row);
            Long sameBatchId = dynamicObject.getLong("samebatchid");
            if (PlatformUtils.isNullLong((Long)sameBatchId)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7a0b\u5e8f\u6570\u636e\u5f02\u5e38\uff0c\u5b58\u5728sameBatchId\u4e3a0\u7684\u60c5\u51b5\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u5206\u6790\u5904\u7406\u3002", (String)"EcoBomEffectOrderPlugin_11", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), row + 1));
                return null;
            }
            if (dynamicObject.getBoolean("islock")) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7ec4\u4ef6\u6e05\u5355\u201c%2$s\u201d\u5df2\u88ab\u9501\u5b9a\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"EcoBomEffectOrderPlugin_12", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), row + 1, dynamicObject.get("stockno")));
                return null;
            }
            if (!this.isAuditStatus(dynamicObject.getString("ecochangebillstatus"))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7ec4\u4ef6\u6e05\u5355[%2$s]\u5bf9\u5e94\u7684\u5de5\u7a0b\u53d8\u66f4\u5355\u636e\u72b6\u6001\u4e0d\u662f\u5df2\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u53d8\u66f4\u64cd\u4f5c\u3002", (String)"EcoBomEffectOrderPlugin_27", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), row + 1, dynamicObject.get("stockno")));
                return null;
            }
            keyValues.add(sameBatchId);
        }
        return keyValues;
    }

    private Set<Long> getKeyValuesSfc() {
        int[] rows;
        HashSet<Long> keyValues = new HashSet<Long>(16);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentitysfc");
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentitysfc");
        for (int row : rows = entryGrid.getSelectRows()) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(row);
            Long sfcManftechEntryId = dynamicObject.getLong("techentryidsfc");
            if (dynamicObject.getBoolean("islocksfc")) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5de5\u5e8f\u8ba1\u5212[%2$s]\u5df2\u88ab\u9501\u5b9a\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u53d8\u66f4\u64cd\u4f5c\u3002", (String)"EcoBomEffectOrderPlugin_23", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), row + 1, dynamicObject.get("technosfc")));
                return null;
            }
            if (!this.isAuditStatus(dynamicObject.getString("ecochangebillstatussfc"))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5de5\u5e8f\u8ba1\u5212[%2$s]\u5bf9\u5e94\u7684\u5de5\u7a0b\u53d8\u66f4\u5355\u636e\u72b6\u6001\u4e0d\u662f\u5df2\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u53d8\u66f4\u64cd\u4f5c\u3002", (String)"EcoBomEffectOrderPlugin_26", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), row + 1, dynamicObject.get("technosfc")));
                return null;
            }
            keyValues.add(sfcManftechEntryId);
        }
        return keyValues;
    }

    private boolean isAuditStatus(String status) {
        return "C".equals(status);
    }

    private Set<String> getGroupNoKeyValues() {
        int[] rows;
        HashSet<String> keyValues = new HashSet<String>(16);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        for (int row : rows = entryGrid.getSelectRows()) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(row);
            String groupNo = dynamicObject.getString("entrygroupno");
            if (PlatformUtils.isNullString((String)groupNo)) continue;
            Long ecoPEntryId = dynamicObject.getLong("ecopentyrid");
            keyValues.add(PlatformUtils.getUnionString((Object)ecoPEntryId, (Object)groupNo));
        }
        return keyValues;
    }

    private Set<String> getRefNoKeyValues() {
        int[] rows;
        HashSet<String> keyValues = new HashSet<String>(16);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        for (int row : rows = entryGrid.getSelectRows()) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(row);
            String refNo = dynamicObject.getString("entryrefno");
            if (PlatformUtils.isNullString((String)refNo)) continue;
            keyValues.add(refNo);
        }
        return keyValues;
    }

    private void dealEntryData(Set<Long> keyValues, BeforeDoOperationEventArgs e, List<Map<String, Object>> allData) {
        int count = 0;
        Set<String> groupNoSet = this.getGroupNoKeyValues();
        Set<String> refNoSet = this.getRefNoKeyValues();
        HashSet<Integer> execIdSet = new HashSet<Integer>(16);
        for (Long sameBatchId : keyValues) {
            for (int i = 0; i < allData.size(); ++i) {
                String refNo;
                Map<String, Object> dataMap = allData.get(i);
                if (!((Long)dataMap.get("samebatchid")).equals(sameBatchId)) continue;
                if (execIdSet.add(i)) {
                    ++count;
                    continue;
                }
                if (!groupNoSet.isEmpty()) {
                    Long ecoPEntryId;
                    String groupNo;
                    String string = groupNo = dataMap.get("entrygroupno") == null ? "" : dataMap.get("entrygroupno").toString();
                    if (!PlatformUtils.isNullString((String)groupNo) && groupNoSet.contains(PlatformUtils.getUnionString((Object)(ecoPEntryId = Long.valueOf(dataMap.get("ecopentyrid") == null ? 0L : Long.parseLong(dataMap.get("ecopentyrid").toString()))), (Object)groupNo)) && execIdSet.add(i)) {
                        ++count;
                        continue;
                    }
                }
                if (refNoSet.isEmpty()) continue;
                String string = refNo = dataMap.get("entryrefno") == null ? "" : dataMap.get("entryrefno").toString();
                if (PlatformUtils.isNullString((String)refNo) || !refNoSet.contains(refNo) || !execIdSet.add(i)) continue;
                ++count;
            }
        }
        StringBuilder errMsg = new StringBuilder();
        errMsg.append(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u5c06\u751f\u6210\u201c%1$s\u201d\u6761\u7ec4\u4ef6\u6e05\u5355\u53d8\u66f4\u5355\u5206\u5f55\u6570\u636e\uff0c\u5305\u62ec\u8df3\u5c42\u4ef6\u5b50\u9879\u3001\u5173\u8054\u6570\u636e\u548c\u6210\u7ec4\u6570\u636e\u3002\u662f\u5426\u786e\u8ba4\u6267\u884c\u64cd\u4f5c\uff1f", (String)"EcoBomEffectOrderPlugin_13", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), count));
        ConfirmCallBackListener listener = new ConfirmCallBackListener("toMftStockChange", (IFormPlugin)this);
        this.getView().showConfirm(errMsg.toString(), MessageBoxOptions.YesNo, listener);
        e.setCancel(true);
    }

    private void dealEntryDataSfc(Set<Long> keyValues, BeforeDoOperationEventArgs e, List<Map<String, Object>> allData) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentitysfc");
        int[] rows = entryGrid.getSelectRows();
        StringBuilder errMsg = new StringBuilder();
        errMsg.append(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u5171\u5c06\u751f\u6210[%1$s]\u6761\u5de5\u5e8f\u8ba1\u5212\u53d8\u66f4\u5355\u5206\u5f55\u6570\u636e\uff0c\u60a8\u786e\u5b9a\u8981\u6267\u884c\u64cd\u4f5c\u5417\uff1f", (String)"EcoBomEffectOrderPlugin_24", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), rows.length));
        ConfirmCallBackListener listener = new ConfirmCallBackListener("toManftechChange", (IFormPlugin)this);
        this.getView().showConfirm(errMsg.toString(), MessageBoxOptions.YesNo, listener);
        e.setCancel(true);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult result;
        String changeOp;
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        String string = "toMftStockChange".equals(callBackId) ? "changeop" : (changeOp = "toManftechChange".equals(callBackId) ? "changeopsfc" : "");
        if (!StringUtils.isEmpty((String)changeOp) && MessageBoxResult.Yes.equals((Object)(result = messageBoxClosedEvent.getResult()))) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("afterconfirm", "true");
            this.getView().invokeOperation(changeOp, operateOption);
        }
    }

    private void refreshDataA() {
        this.getMftStockData();
    }

    private void refreshDataB() {
        this.getManftechData();
    }

    private void toMftStockChange() {
        AddEffectOrderBillBusiness addBusiness;
        List resultList;
        Set<Long> keyValues = this.getKeyValues();
        if (keyValues == null) {
            return;
        }
        List<Map<String, Object>> allData = this.getCacheGridList();
        ArrayList<Map<String, Object>> listData = new ArrayList<Map<String, Object>>(128);
        Set<String> groupNoSet = this.getGroupNoKeyValues();
        Set<String> refNoSet = this.getRefNoKeyValues();
        HashSet<Integer> execIdSet = new HashSet<Integer>(16);
        for (Long sameBatchId : keyValues) {
            for (int i = 0; i < allData.size(); ++i) {
                String refNo;
                Map<String, Object> dataMap = allData.get(i);
                if (!((Long)dataMap.get("samebatchid")).equals(sameBatchId)) continue;
                if (execIdSet.add(i)) {
                    listData.add(dataMap);
                    continue;
                }
                if (!groupNoSet.isEmpty()) {
                    Long ecoPEntryId;
                    String groupNo;
                    String string = groupNo = dataMap.get("entrygroupno") == null ? "" : dataMap.get("entrygroupno").toString();
                    if (!PlatformUtils.isNullString((String)groupNo) && groupNoSet.contains(PlatformUtils.getUnionString((Object)(ecoPEntryId = Long.valueOf(dataMap.get("ecopentyrid") == null ? 0L : Long.parseLong(dataMap.get("ecopentyrid").toString()))), (Object)groupNo)) && execIdSet.add(i)) {
                        listData.add(dataMap);
                        continue;
                    }
                }
                if (refNoSet.isEmpty()) continue;
                String string = refNo = dataMap.get("entryrefno") == null ? "" : dataMap.get("entryrefno").toString();
                if (PlatformUtils.isNullString((String)refNo) || !refNoSet.contains(refNo) || !execIdSet.add(i)) continue;
                listData.add(dataMap);
            }
        }
        String changeType = "A";
        if (!listData.isEmpty() && (resultList = (addBusiness = new AddEffectOrderBillBusiness()).addData(listData, changeType)) != null && !resultList.isEmpty()) {
            String errorString = "";
            try {
                Map resultMap = addBusiness.genNextBillData(resultList, changeType);
                GetEcoEffectOrderBusiness.getInstance().submitAndAuditXStock(resultMap);
                errorString = resultMap.get("errormsg") == null ? "" : resultMap.get("errormsg").toString();
            }
            catch (Exception e) {
                log.error((Throwable)e);
                addBusiness.deleteNextBillData(resultList);
                throw e;
            }
            if (StringUtils.isEmpty((String)errorString)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4e0b\u6e38\u7ec4\u4ef6\u6570\u636e\u66f4\u65b0\u6210\u529f\u3002", (String)"EcoBomEffectOrderPlugin_14", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(errorString);
            }
            this.refreshDataA();
        }
    }

    private void toManftechChange() {
        AddEffectOrderBillBusiness addBusiness;
        List resultList;
        Set<Long> keyValues = this.getKeyValuesSfc();
        if (keyValues == null) {
            return;
        }
        List<Map<String, Object>> allData = this.getCacheGridList();
        ArrayList<Map<String, Object>> listData = new ArrayList<Map<String, Object>>(128);
        for (Long sfcManftechEntryId : keyValues) {
            for (int i = 0; i < allData.size(); ++i) {
                Map<String, Object> dataMap = allData.get(i);
                if (!((Long)dataMap.get("techentryidsfc")).equals(sfcManftechEntryId)) continue;
                listData.add(dataMap);
            }
        }
        String changeType = "B";
        if (!listData.isEmpty() && (resultList = (addBusiness = new AddEffectOrderBillBusiness()).addData(listData, changeType)) != null && !resultList.isEmpty()) {
            String errorString = "";
            try {
                Map resultMap = addBusiness.genNextBillData(resultList, changeType);
                GetEcoEffectManuftechBusiness.getInstance().submitAndAuditXTech(resultMap);
                errorString = resultMap.get("errormsg") == null ? "" : resultMap.get("errormsg").toString();
            }
            catch (Exception e) {
                log.error((Throwable)e);
                addBusiness.deleteNextBillData(resultList);
                throw e;
            }
            if (StringUtils.isEmpty((String)errorString)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u4e0b\u6e38\u5de5\u5e8f\u8ba1\u5212\u6570\u636e\u6210\u529f\u3002", (String)"EcoBomEffectOrderPlugin_25", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(errorString);
            }
            this.refreshDataB();
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        if (e == null || e.getFieldName() == null) {
            return;
        }
        String fieldName = e.getFieldName();
        if ("billno".equals(fieldName)) {
            BillList billList = (BillList)e.getSource();
            Object focusRowPkId = billList.getFocusRowPkId();
            Long pkId = 0L;
            if (focusRowPkId instanceof Long) {
                pkId = (Long)focusRowPkId;
            }
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("pdm_ecoeffectrange_result");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setPkId((Object)pkId);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pdm_ecoeffectrange_result"));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public Map<String, Object> queryLogStatusAndSetValue(IFormView fv, Long id) {
        String fieldSelctProperties = "id,calculatestatus,calculatepro,entryentity.entrystepseq entrystepseq ,entryentity.entrystepname entrystepname ";
        QFilter[] qfilter = new QFilter[]{new QFilter("id", "=", (Object)id)};
        String maxStepName = ResManager.loadKDString((String)"\u5f00\u59cb\u8ba1\u7b97\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"EcoBomEffectOrderPlugin_15", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
        String status = "D";
        BigDecimal calculatepro = BigDecimal.ZERO;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(EcoBomEffectOrderPlugin.class.getName() + "_queryLogStatusAndSetValue"), (String)"mrp_caculate_log", (String)fieldSelctProperties, (QFilter[])qfilter, (String)"entryentity.entrystepseq");){
            while (ds.hasNext()) {
                Row arow = ds.next();
                status = arow.getString("calculatestatus");
                calculatepro = arow.getBigDecimal("calculatepro");
                maxStepName = arow.getString("entrystepname");
            }
        }
        fv.setVisible(Boolean.FALSE, new String[]{"image_fail"});
        fv.setVisible(Boolean.TRUE, new String[]{"image_success"});
        Label lab = (Label)this.getControl("stepname");
        String color = "#1BA854";
        if ("A".equals(status)) {
            maxStepName = ResManager.loadKDString((String)"\u6b63\u5e38\u7ed3\u675f", (String)"EcoBomEffectOrderPlugin_16", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
        } else if ("B".equals(status)) {
            maxStepName = ResManager.loadKDString((String)"\u5f02\u5e38\u7ec8\u6b62", (String)"EcoBomEffectOrderPlugin_17", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
            fv.setVisible(Boolean.TRUE, new String[]{"image_fail"});
            fv.setVisible(Boolean.FALSE, new String[]{"image_success"});
            color = "rgba(255,0,0,0.7)";
        } else if ("C".equals(status)) {
            maxStepName = ResManager.loadKDString((String)"\u624b\u5de5\u7ec8\u6b62", (String)"EcoBomEffectOrderPlugin_18", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
            fv.setVisible(Boolean.TRUE, new String[]{"image_fail"});
            fv.setVisible(Boolean.FALSE, new String[]{"image_success"});
            color = "rgba(255,0,0,0.7)";
        }
        lab.setText(maxStepName);
        this.getModel().setValue("calculatepro", (Object)calculatepro);
        fv.updateView("calculatepro");
        ProgressBar progressBar = (ProgressBar)fv.getControl("progressbarap");
        int newPercent = calculatepro.intValue();
        progressBar.setPercent(newPercent);
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        fieldMap.put("fc", color);
        fv.updateControlMetadata("progressbarap", fieldMap);
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("calculatestatus", status);
        resultMap.put("newPercent", newPercent);
        return resultMap;
    }

    public int updateData(IFormView fv, Long id) {
        Map<String, Object> dynamicObject = this.queryLogStatusAndSetValue(fv, id);
        String status = dynamicObject.get("calculatestatus").toString();
        if (!"D".equalsIgnoreCase(status)) {
            ProgressBar progressBar = (ProgressBar)fv.getControl("progressbarap");
            progressBar.stop();
            this.queryEffectRangeData(id, this.getDataType());
        }
        return Integer.parseInt(dynamicObject.get("newPercent").toString());
    }

    public void onProgress(ProgressEvent progressEvent) {
        Long logId = this.getCacheLogId();
        progressEvent.setProgress(this.updateData(this.getView(), logId));
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("pdm_effectorderprogress".equalsIgnoreCase(actionId)) {
            String opexception = this.getView().getPageCache().get("opexception");
            if (!StringUtils.isEmpty((String)opexception)) {
                this.getView().showTipNotification(opexception);
            } else {
                List<Map<String, Object>> gridList = this.getCacheGridList();
                if (PlatformUtils.isNullList(gridList)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u5b58\u5728\u5dee\u5f02\u7684\u7ec4\u4ef6\u6570\u636e\u3002", (String)"EcoBomEffectOrderPlugin_19", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
                }
                String changeType = this.getCacheChangeType();
                this.setCacheGridList(gridList, changeType);
                this.initEntryEntity(gridList, Boolean.TRUE, changeType);
            }
        }
    }

    private String addAllLocks(List<Map<String, Object>> allData, String billType) {
        HashMap<String, Set<Long>> successIdMaps = new HashMap<String, Set<Long>>(16);
        String lockErrorMsg = OrderMutexLockUtils.addAllLocks(allData, successIdMaps, (String)billType);
        this.setCacheLockMaps(successIdMaps);
        return lockErrorMsg;
    }

    private void clearAllLocks(String billType) {
        Map<String, Set<Long>> stockMap = this.getCacheLockMaps();
        OrderMutexLockUtils.clearAllLocks(stockMap, (String)billType);
        this.setCacheLockMaps(null);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String changeType = this.getCacheChangeType();
        this.clearAllLocks(changeType);
    }
}

