/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.ecoplatform;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.Plugin;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class EcoBomEffectRangeFormExportPlugin
extends AbstractFormPlugin
implements ICloseCallBack,
IConfirmCallBack {
    private static final String BILLLISTAP = "billlistap";
    public static final String EXPORT_ENTITY = "pdm_effectrange_export";

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        if ("listexport".equalsIgnoreCase(operateKey)) {
            BillList billList = (BillList)this.getControl(BILLLISTAP);
            int billNum = billList.getSelectedRows().getPrimaryKeyValues().length;
            if (billNum == 0 && (billNum = billList.queryBillDataCount()) <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa\u3002", (String)"EcoBomEffectRangeFormExportPlugin_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            String showMsg = MessageFormat.format(ResManager.loadKDString((String)"\u5bfc\u51fa{0}\u5f20\u5355\u636e\uff0c\u786e\u5b9a\u8981\u7ee7\u7eed\u64cd\u4f5c\u5417\uff1f", (String)"EcoBomEffectRangeFormExportPlugin_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), billNum);
            this.getView().showConfirm(showMsg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("ExportListConfirmCallBack", (IConfirmCallBack)this));
            return;
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (messageBoxClosedEvent.getResult() != MessageBoxResult.Yes) {
            return;
        }
        if ("ExportListConfirmCallBack".equalsIgnoreCase(messageBoxClosedEvent.getCallBackId())) {
            this.export();
        }
    }

    private Long getCacheLogId() {
        String logIds = this.getPageCache().get("pc_logid");
        return Long.parseLong(logIds);
    }

    private Set<Long> getAllPkIds() {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        HashSet<Long> idSet = new HashSet<Long>(64);
        Object[] selectRows = billList.getSelectedRows().getPrimaryKeyValues();
        if (selectRows.length == 0) {
            Long logId = this.getCacheLogId();
            QFilter[] qfilter = new QFilter[]{new QFilter("ecocallog.id", "=", (Object)logId)};
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)EcoBomEffectRangeFormExportPlugin.class.getName(), (String)"pdm_ecoestimate_result", (String)"id", (QFilter[])qfilter, (String)"");){
                while (ds.hasNext()) {
                    Row arow = ds.next();
                    idSet.add(arow.getLong("id"));
                }
            }
        } else {
            for (Object id : selectRows) {
                idSet.add((Long)id);
            }
        }
        return idSet;
    }

    private void export() {
        Set<Long> allPkIds = this.getAllPkIds();
        HashMap<String, String> para = new HashMap<String, String>(16);
        para.put("formId", EXPORT_ENTITY);
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        Plugin plugin = new Plugin();
        plugin.setClassName("kd.mmc.pdm.formplugin.ecoplatform.EcoEffectRangeDataExportProgressPlugin");
        plugin.setEnabled(true);
        showParameter.setCustomParam("pkids", allPkIds);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u201c\u5f71\u54cd\u8303\u56f4\u201d\u5bfc\u51fa\u8fdb\u5ea6\u3002", (String)"EcoBomEffectRangeFormExportPlugin_2", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        showParameter.getFormConfig().getPlugins().add(plugin);
        this.getView().showForm(showParameter);
    }
}

