/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.ecoplatform;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.IReportView;
import kd.bos.report.filter.ReportFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.business.ecoplatform.ActTimeBean;
import kd.mmc.pdm.business.ecoplatform.ActTimeCopBean;
import kd.mmc.pdm.business.ecoplatform.ActTimeCopValidataBusiness;
import kd.mmc.pdm.business.ecoplatform.ActTimeRouteBean;
import kd.mmc.pdm.business.ecoplatform.ActTimeRouteValidataBusiness;
import kd.mmc.pdm.business.ecoplatform.ActTimeValidataBusiness;
import kd.mmc.pdm.business.ecoplatform.AddEcoLogUtils;
import kd.mmc.pdm.business.ecoplatform.EcoCopUtils;
import kd.mmc.pdm.business.ecoplatform.EcoRouteUtils;
import kd.mmc.pdm.business.ecoplatform.EcoUtils;
import kd.mmc.pdm.business.ecoplatform.GetEcoEffectManuftechBusiness;
import kd.mmc.pdm.business.ecoplatform.GetEcoEffectOrderBusiness;
import kd.mmc.pdm.business.ecoplatform.ext.AbstractEstimateEndExtPlugin;
import kd.mmc.pdm.business.ecoplatform.ext.EcoEstimateStatusUpdateUtils;
import kd.mmc.pdm.common.bom.ecoplatform.EcoBomPlatformConst;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.common.util.MMCUtils;
import kd.mmc.pdm.common.util.PdmParamSetHelper;
import kd.mmc.pdm.formplugin.eco.ECNAfterAuditUtils;
import kd.mmc.pdm.formplugin.ecoplatform.EcoPlatFormQueryBasePlugin;
import kd.mmc.pdm.formplugin.ecoplatform.PlatFormQueryDataHelper;

public class EcoBomPlatFormQueryPlugin
extends EcoPlatFormQueryBasePlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final Log log = LogFactory.getLog(EcoBomPlatFormQueryPlugin.class);
    public static final String CACHE_LASTQUERYTYPE = "cachelastquerytype";

    public void registerListener(EventObject e) {
        BasedataEdit org;
        super.registerListener(e);
        EntryGrid grid = (EntryGrid)this.getControl("entryentitys");
        if (grid != null) {
            grid.addHyperClickListener((HyperLinkClickListener)this);
        }
        this.addClickListeners(new String[]{"head", "front", "back", "atlast"});
        BasedataEdit ecoType = (BasedataEdit)this.getControl("ecotype");
        if (ecoType != null) {
            ecoType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((org = (BasedataEdit)this.getControl("org_filter")) != null) {
            org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (this.getPageCache().get("isIgnoreChangeListener") == "true") {
            return;
        }
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object oldValue = changeData[0].getOldValue();
        Object newValue = changeData[0].getNewValue();
        int rowIndex = changeData[0].getRowIndex();
        if ("org_filter".equals(name)) {
            MulBasedataDynamicObjectCollection strs = (MulBasedataDynamicObjectCollection)newValue;
            if (strs != null && !strs.isEmpty()) {
                DynamicObject dynamicObject = (DynamicObject)strs.get(0);
                DynamicObject orgId = dynamicObject.getDynamicObject("fbasedataid");
                this.getModel().setValue("org_permitem", (Object)orgId);
            } else {
                this.getModel().setValue("org_permitem", null);
            }
        } else if ("bomecofrom_filter".equals(name)) {
            MulBasedataDynamicObjectCollection strs = (MulBasedataDynamicObjectCollection)newValue;
            if (strs != null && strs.size() > 1) {
                this.getModel().setValue("bomecoto_filter", null);
                this.getView().setEnable(Boolean.FALSE, new String[]{"bomecoto_filter"});
                this.getView().updateView("bomecoto_filter");
            } else if (strs != null && strs.size() == 1) {
                this.getModel().setValue("bomecoto_filter", null);
                DynamicObject dynamicObject = (DynamicObject)strs.get(0);
                DynamicObject bomecof7 = dynamicObject.getDynamicObject("fbasedataid");
                this.getModel().setValue("bomecoto_filter", (Object)bomecof7);
                this.getView().setEnable(Boolean.TRUE, new String[]{"bomecoto_filter"});
                this.getView().updateView("bomecoto_filter");
            } else {
                this.getModel().setValue("bomecoto_filter", null);
                this.getView().setEnable(Boolean.TRUE, new String[]{"bomecoto_filter"});
                this.getView().updateView("bomecoto_filter");
            }
        } else if ("materialinfofrom_filter".equals(name) || "materialfrom_filter".equals(name) || "featurefrom_filter".equals(name)) {
            String toName = this.getFilterToFilterName(name);
            DynamicObjectCollection col = (DynamicObjectCollection)newValue;
            if (col != null && col.size() > 1) {
                this.getModel().setValue(toName, null);
                this.getView().setEnable(Boolean.FALSE, new String[]{toName});
            } else {
                Long id = this.getFirstId(col);
                DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)this.getEntityName(name));
                this.getModel().setValue(toName, (Object)obj);
                this.getView().setEnable(Boolean.TRUE, new String[]{toName});
            }
        } else if ("ecotype".equals(name)) {
            if (newValue != null && oldValue != null) {
                IPageCache pc = this.getPageCache();
                DynamicObject oldEcoType = (DynamicObject)oldValue;
                DynamicObject newEcoType = (DynamicObject)newValue;
                boolean adjustActTimeOld = ((DynamicObject)oldValue).getBoolean("adjustacttime");
                boolean adjustActTimeNew = ((DynamicObject)newValue).getBoolean("adjustacttime");
                if (!adjustActTimeNew && adjustActTimeOld) {
                    pc.put("ecotype", String.valueOf(oldEcoType.getPkValue()));
                    pc.put("ecotypenew", String.valueOf(newEcoType.getPkValue()));
                    pc.put("ecotype-row", String.valueOf(rowIndex));
                    String number = newEcoType.getString("number");
                    String msgInfo = String.format(ResManager.loadKDString((String)"%s\u53d8\u66f4\u7c7b\u578b\u5bf9\u5e94\u201c\u5141\u8bb8\u5b9e\u65bd\u8c03\u6574\u65f6\u95f4\u201d\u5b57\u6bb5\u5df2\u53d8\u66f4\uff0c\u662f\u5426\u5c06\u7ec4\u4ef6\u5b9e\u65bd\u65f6\u95f4\u66f4\u65b0\u4e3a\u4ea7\u54c1\u4fe1\u606f\u751f\u6548\u65f6\u95f4\uff1f", (String)"EcoBomPlatFormQueryPlugin_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), number);
                    if (this.isRouteChange(rowIndex)) {
                        msgInfo = String.format(ResManager.loadKDString((String)"%s\u53d8\u66f4\u7c7b\u578b\u5bf9\u5e94\u201c\u5141\u8bb8\u5b9e\u65bd\u8c03\u6574\u65f6\u95f4\u201d\u5b57\u6bb5\u5df2\u53d8\u66f4\uff0c\u662f\u5426\u5c06\u5de5\u5e8f\u4fe1\u606f\u7684\u5b9e\u65bd\u65f6\u95f4\u66f4\u65b0\u4e3a\u4ea7\u54c1\u4fe1\u606f\u751f\u6548\u65f6\u95f4\uff1f", (String)"EcoBomPlatFormQueryPlugin_78", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), number);
                    }
                    this.getView().showConfirm(msgInfo, MessageBoxOptions.YesNo, new ConfirmCallBackListener("ecotypechange"));
                    return;
                }
            }
            DynamicObject newEcoType = (DynamicObject)newValue;
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentitys");
            int[] selectRows = entryGrid.getSelectRows();
            Long ecopentryid = this.getLongValue("ecopentryid", rowIndex);
            String[] filedArray = new String[]{"ecotype"};
            Object[] valueArray = new Object[]{newEcoType};
            this.updateSameRowDataByPentry(selectRows, ecopentryid, filedArray, valueArray);
            this.updateSameRowDataBySelect(selectRows, filedArray, valueArray, rowIndex);
        } else if ("acttime".equals(name)) {
            this.updateOtherByActtime(newValue, rowIndex);
            String replaceGroupNo = this.getStringValue("entryreplacegroup", rowIndex);
            if (!StringUtils.isEmpty((String)replaceGroupNo)) {
                Long ecoPentryId = this.getLongValue("ecopentryid", rowIndex);
                String[] filedArray = new String[]{"acttime"};
                Object[] valueArray = new Object[]{newValue};
                this.getPageCache().put("isIgnoreChangeListener", "true");
                this.updateSameRowDataByReplaceGroupNo(replaceGroupNo, ecoPentryId, filedArray, valueArray, rowIndex);
                this.getPageCache().put("isIgnoreChangeListener", "false");
            }
        } else if ("pentryvaliddate".equals(name)) {
            if (newValue != null && oldValue != null && !newValue.equals(oldValue)) {
                if (this.isAddStatus(null, rowIndex)) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    IPageCache pc = this.getPageCache();
                    pc.put("entryvaliddate", sdf.format(newValue));
                    pc.put("oldentryvaliddate", sdf.format(oldValue));
                    pc.put("entryvaliddate-row", String.valueOf(rowIndex));
                    String number = this.getStringValue("billno", rowIndex);
                    String msgInfo = String.format(ResManager.loadKDString((String)"%1$s\u5de5\u7a0b\u53d8\u66f4\u5355\uff0c\u4ea7\u54c1\u5206\u5f55\u7b2c\u201c%2$s\u201d\u884c\uff0c\u4fee\u6539\u201c\u751f\u6548\u65f6\u95f4\u201d\uff0c\u4f1a\u81ea\u52a8\u5220\u9664\u8be5\u4ea7\u54c1\u5206\u5f55\u5bf9\u5e94\u7684\u975e\u65b0\u589e\u7684\u7ec4\u4ef6\u5206\u5f55\uff0c\u786e\u5b9a\u4fee\u6539\uff1f", (String)"EcoBomPlatFormQueryPlugin_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), number, rowIndex + 1);
                    if (this.isRouteChange(rowIndex)) {
                        msgInfo = String.format(ResManager.loadKDString((String)"\u4fee\u6539%1$s\u5de5\u7a0b\u53d8\u66f4\u5355\u4e2d\u7b2c\u201c%2$s\u201d\u884c\u4ea7\u54c1\u7684\u201c\u751f\u6548\u65f6\u95f4\u201d\uff0c\u5c06\u81ea\u52a8\u5220\u9664\u8be5\u4ea7\u54c1\u5206\u5f55\u4e2d\u975e\u65b0\u589e\u7684\u5de5\u5e8f\u4fe1\u606f\u5206\u5f55\u3002\u662f\u5426\u786e\u5b9a\u4fee\u6539\uff1f", (String)"EcoBomPlatFormQueryPlugin_79", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), number, rowIndex + 1);
                    }
                    this.getView().showConfirm(msgInfo, MessageBoxOptions.YesNo, new ConfirmCallBackListener("pentryvaliddate"));
                } else {
                    this.pentryValidDateChangeUpdate((Date)newValue, rowIndex);
                }
            }
        } else if ("tranqty".equals(name)) {
            BigDecimal tranqty = newValue == null ? BigDecimal.ZERO : (BigDecimal)newValue;
            BigDecimal useqty = this.getBigDecimalValue("useqty", rowIndex);
            if (useqty == null) {
                useqty = BigDecimal.ZERO;
            }
            if (tranqty.compareTo(useqty) < 0) {
                String msgInfo = ResManager.loadKDString((String)"\u5f85\u6d88\u8017\u6570\u91cf\u5e94\u5927\u4e8e\u7b49\u4e8e\u5df2\u6d88\u8017\u6570\u91cf\u3002", (String)"EcoBomPlatFormQueryPlugin_2", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msgInfo);
                this.getPageCache().put("isIgnoreChangeListener", "true");
                this.setValue("tranqty", oldValue, rowIndex);
                this.getPageCache().put("isIgnoreChangeListener", "false");
                return;
            }
            this.setValue("remainderqty", tranqty.subtract(useqty), rowIndex);
            if (BigDecimal.ZERO.compareTo(tranqty) != 0) {
                this.setValue("progress", useqty.multiply(new BigDecimal("100")).divide(tranqty, new MathContext(10)).setScale(10, RoundingMode.HALF_UP), rowIndex);
            } else {
                this.setValue("progress", null, rowIndex);
            }
        } else if ("entryrefno".equals(name)) {
            String refNo;
            String string = refNo = newValue == null ? "" : (String)newValue;
            if (!PlatformUtils.isNullString((String)refNo) && this.isUnEstimateStatus(rowIndex)) {
                HashSet<String> refNoSet = new HashSet<String>(16);
                refNoSet.add(refNo);
                Set existsSet = null;
                if (this.isEstimateStatusA(rowIndex)) {
                    existsSet = EcoUtils.checkRefnoIsEnd(refNoSet, (boolean)true);
                } else if (this.isEstimateStatusB(rowIndex)) {
                    existsSet = EcoUtils.checkRefnoIsEnd(refNoSet, (boolean)false);
                }
                if (existsSet != null && !existsSet.isEmpty()) {
                    String msgInfo = "";
                    if (this.isEstimateStatusA(rowIndex)) {
                        msgInfo = String.format(ResManager.loadKDString((String)"\u5173\u8054\u5b9e\u65bd\u53f7%s\u5df2\u5b58\u5728\u8bc4\u4f30\u4e2d\u6216\u8bc4\u4f30\u5b8c\u6210\u7684\u6570\u636e\uff0c\u672c\u6b21\u4e0d\u5141\u8bb8\u5f55\u5165\u3002", (String)"EcoBomPlatFormQueryPlugin_3", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), existsSet.toString());
                    } else if (this.isEstimateStatusB(rowIndex)) {
                        msgInfo = String.format(ResManager.loadKDString((String)"\u5173\u8054\u5b9e\u65bd\u53f7%1$s\u5df2\u5b58\u5728\u8bc4\u4f30\u5b8c\u6210\u7684\u6570\u636e\u3002", (String)"EcoBomPlatFormQueryPlugin_4", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), existsSet.toString());
                    }
                    this.getView().showTipNotification(msgInfo);
                    this.getPageCache().put("isIgnoreChangeListener", "true");
                    this.setValue("entryrefno", oldValue, rowIndex);
                    this.getPageCache().put("isIgnoreChangeListener", "false");
                    return;
                }
            }
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentitys");
            int[] selectRows = entryGrid.getSelectRows();
            String[] filedArray = new String[]{"entryrefno"};
            Object[] valueArray = new Object[]{newValue};
            this.updateSameRowDataBySelect(selectRows, filedArray, valueArray, rowIndex);
        } else if ("entrygroupno".equals(name)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentitys");
            int[] selectRows = entryGrid.getSelectRows();
            String[] filedArray = new String[]{"entrygroupno"};
            Object[] valueArray = new Object[]{newValue};
            this.updateSameRowDataBySelect(selectRows, filedArray, valueArray, rowIndex);
        } else if ("refkey".equals(name)) {
            boolean isRefKey = (Boolean)newValue;
            String refNo = this.getStringValue("entryrefno", rowIndex);
            if (isRefKey && !PlatformUtils.isNullString((String)refNo)) {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentitys");
                int[] selectRows = entryGrid.getSelectRows();
                String[] filedArray = new String[]{"refkey"};
                Object[] valueArray = new Object[]{Boolean.FALSE};
                this.getPageCache().put("isIgnoreChangeListener", "true");
                this.updateKeyUnSelectByRefNo(selectRows, refNo, filedArray, valueArray, rowIndex);
                this.getPageCache().put("isIgnoreChangeListener", "false");
            }
        } else if ("groupkey".equals(name)) {
            boolean isGroupKey = (Boolean)newValue;
            String groupNo = this.getStringValue("entrygroupno", rowIndex);
            Long ecoPentryId = this.getLongValue("ecopentryid", rowIndex);
            if (isGroupKey && !PlatformUtils.isNullString((String)groupNo)) {
                String[] filedArray = new String[]{"groupkey"};
                Object[] valueArray = new Object[]{Boolean.FALSE};
                this.getPageCache().put("isIgnoreChangeListener", "true");
                this.updateSameRowDataByGroupNo(groupNo, ecoPentryId, filedArray, valueArray, rowIndex);
                this.getPageCache().put("isIgnoreChangeListener", "false");
            }
        } else if ("pageindex".equals(name)) {
            PlatFormQueryDataHelper.toPageIndex((IFormView)this.getView(), (AbstractFormDataModel)this.getModel(), (Integer)this.getModel().getValue("pageindex"));
        } else if ("pagesize".equals(name)) {
            if (newValue != null) {
                int pagesize = Integer.parseInt((String)newValue);
                PlatFormQueryDataHelper.toPageSize((IFormView)this.getView(), (AbstractFormDataModel)this.getModel(), pagesize);
            }
        } else if ("createtimeselect".equals(name)) {
            String dataType = (String)newValue;
            if ("D".equals(dataType)) {
                this.initCreateRange();
            }
        } else if ("changetype_filter".equals(name)) {
            String changeTypes = (String)newValue;
            this.changeTypeValueChange(changeTypes);
        }
    }

    public void updateOtherByActtime(Object newValue, int rowIndex) {
        String entrymode = this.getStringValue("entrymode", rowIndex);
        if (!values.contains(entrymode)) {
            this.setValue("entryvaliddate", newValue, rowIndex);
            this.getView().updateView("entryvaliddate", rowIndex, 0);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        if (e == null || e.getFieldName() == null) {
            return;
        }
        String fieldName = e.getFieldName();
        if ("changedetails".equals(fieldName)) {
            this.toPdmEcoLogView(e);
        } else if ("billno".equals(fieldName)) {
            this.toPdmBomEcoBillView(e);
        }
    }

    private void toPdmBomEcoBillView(HyperLinkClickEvent e) {
        int rowIndex = e.getRowIndex();
        String message = "";
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity("entryentitys", rowIndex);
        if (dynamicObject == null) {
            message = ResManager.loadKDString((String)"\u67e5\u8be2\u5206\u5f55\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u65e0\u6570\u636e\uff0c\u8bf7\u6838\u5bf9\u3002", (String)"EcoBomPlatFormQueryPlugin_6", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
        } else {
            Long billId = dynamicObject.getLong("ecoid");
            if (billId != null && !billId.equals(0L)) {
                boolean isExists = PlatformUtils.checkBillExist((Long)billId);
                if (!isExists) {
                    message = ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355\u5df2\u4e0d\u5b58\u5728,\u8bf7\u5237\u65b0\u91cd\u8bd5\u3002", (String)"EcoBomPlatFormQueryPlugin_7", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                } else {
                    OperationStatus value = OperationStatus.EDIT;
                    if ("C".equals(dynamicObject.getString("billstatus"))) {
                        value = OperationStatus.VIEW;
                    }
                    PlatformUtils.openBillInfoShowPage((String)"pdm_bom_eco", (Long)billId, (IReportView)this.getView(), (OperationStatus)value);
                }
            } else {
                message = ResManager.loadKDString((String)"\u65e0\u6cd5\u67e5\u8be2\u53d8\u66f4\u5355ID\u4e3a\u7a7a\u7684\u5206\u5f55\u884c\u3002", (String)"EcoBomPlatFormQueryPlugin_8", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
            }
        }
        if (!StringUtils.isEmpty((String)message)) {
            this.getView().showTipNotification(message);
        }
    }

    private void toPdmEcoLogView(HyperLinkClickEvent e) {
        int rowIndex = e.getRowIndex();
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity("entryentitys", rowIndex);
        if (dynamicObject == null) {
            return;
        }
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("pdm_ecochangelog");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ListFilterParameter listFilter = new ListFilterParameter();
        Long ecobomid = dynamicObject.getLong("ecoid");
        Long ecobomentryid = dynamicObject.getLong("ecoentryid");
        QFilter qFilter = new QFilter("bomecoid", "=", (Object)ecobomid);
        qFilter.and(new QFilter("ecobomentryid", "=", (Object)ecobomentryid));
        listFilter.setFilter(qFilter);
        listShowParameter.setListFilterParameter(listFilter);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String srcDEPName;
        int rowIndex = event.getRow();
        IDataEntityProperty srcDEP = event.getProperty();
        String string = srcDEPName = srcDEP == null ? null : srcDEP.getName();
        if (MMCUtils.isEmptyString((String)srcDEPName)) {
            return;
        }
        if ("ecotype".equalsIgnoreCase(srcDEPName) && rowIndex >= 0) {
            this.createEcoTypef7(event);
        }
        if ("org_filter".equalsIgnoreCase(srcDEPName)) {
            this.createOrgf7(event);
        }
    }

    private void createEcoTypef7(BeforeF7SelectEvent e) {
        int rowIndex = e.getRow();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if (this.isRouteChange(rowIndex)) {
            QFilter filter = new QFilter("statustype", "=", (Object)"A");
            showParameter.getListFilterParameter().getQFilters().add(filter);
        }
    }

    private void createOrgf7(BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        HasPermOrgResult hasPermOrgResult = this.getPermissionOrgs("47150e89000000ac");
        QFilter filter = new QFilter("id", ">", (Object)0L);
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            List perOrgIdList = hasPermOrgResult.getHasPermOrgs();
            filter.and(new QFilter("id", "in", (Object)perOrgIdList));
        }
        showParameter.getListFilterParameter().getQFilters().add(filter);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initOrg();
        if (this.isDisableGroupNo()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entrygroupno", "groupkey"});
        }
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        if (!this.verifyOrgisNull()) {
            ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
            rptFilter.search();
        }
    }

    public void querydata() {
        PlatFormQueryDataHelper.fillDatas((IFormView)this.getView(), (AbstractFormDataModel)this.getModel());
    }

    public void initCreateRange() {
        DateRangeEdit createRangeEdit = (DateRangeEdit)this.getView().getControl("createtime_filter");
        String key_createdatestart = createRangeEdit.getStartDateFieldKey();
        String key_createdateend = createRangeEdit.getEndDateFieldKey();
        Date createdateend = new Date();
        this.getModel().setValue(key_createdatestart, (Object)createdateend);
        this.getModel().setValue(key_createdateend, (Object)createdateend);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        String changeTypes = (String)this.getModel().getValue("changetype_filter");
        String cacheChangeTypes = this.getPageCache().get(CACHE_LASTQUERYTYPE);
        if (changeTypes != null && !changeTypes.equals(cacheChangeTypes)) {
            this.changeTypeValueChange(changeTypes);
            this.getPageCache().put(CACHE_LASTQUERYTYPE, changeTypes);
        }
        this.querydata();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        if ("saveeco".equalsIgnoreCase(operateKey)) {
            this.doBeforeVerfiy("save", e);
        } else if ("submiteco".equalsIgnoreCase(operateKey)) {
            this.doBeforeVerfiy("submit", e);
        } else if ("unsubmiteco".equalsIgnoreCase(operateKey)) {
            this.doBeforeVerfiy("unsubmit", e);
        } else if ("deleteeco".equalsIgnoreCase(operateKey)) {
            this.doBeforeVerfiy("delete", e);
        } else if ("auditeco".equalsIgnoreCase(operateKey)) {
            this.doBeforeVerfiy("audit", e);
        } else if ("updatebomdata".equalsIgnoreCase(operateKey)) {
            this.doBeforeVerfiy("updatebom", e);
        } else if ("handestimateend".equalsIgnoreCase(operateKey)) {
            this.doBeforeVerfiy("handestimateend", e);
        } else if ("updateorder".equalsIgnoreCase(operateKey)) {
            this.doBeforeUpdateOrderData(e);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("saveeco".equalsIgnoreCase(operateKey)) {
            this.doAfterExecOp("save", e);
        } else if ("submiteco".equalsIgnoreCase(operateKey)) {
            this.doAfterExecOp("submit", e);
        } else if ("unsubmiteco".equalsIgnoreCase(operateKey)) {
            this.doAfterExecOp("unsubmit", e);
        } else if ("deleteeco".equalsIgnoreCase(operateKey)) {
            this.doAfterExecOp("delete", e);
        } else if ("auditeco".equalsIgnoreCase(operateKey)) {
            this.doAfterExecOp("audit", e);
        } else if ("updatebomdata".equalsIgnoreCase(operateKey)) {
            this.doAfterExecOp("updatebom", e);
        } else if ("handestimateend".equalsIgnoreCase(operateKey)) {
            this.doAfterExecOp("handestimateend", e);
        } else if ("updateorder".equalsIgnoreCase(operateKey) && e.getOperationResult().isSuccess()) {
            this.doAfterUpdateOrderData(operateKey);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String btnKey = source.getKey();
        IDataModel model = this.getModel();
        switch (btnKey) {
            case "head": {
                PlatFormQueryDataHelper.atFirst(model);
                break;
            }
            case "front": {
                PlatFormQueryDataHelper.toFront(model);
                break;
            }
            case "back": {
                if (this.getPageCache().get("count_cache") == null) break;
                PlatFormQueryDataHelper.toBack(model, Integer.parseInt(this.getPageCache().get("count_cache")));
                break;
            }
            case "atlast": {
                if (this.getPageCache().get("count_cache") == null) break;
                PlatFormQueryDataHelper.toLast(model, Integer.parseInt(this.getPageCache().get("count_cache")));
                break;
            }
        }
    }

    private Set<Long> getSelectBillIdSet() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentitys");
        if (entryGrid.getSelectRows().length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u4e2d\u4e00\u6761\u53d8\u66f4\u5355\u6570\u636e\u3002", (String)"EcoBomPlatFormQueryPlugin_9", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return Collections.emptySet();
        }
        int[] selectRows = entryGrid.getSelectRows();
        return this.getIdSet(selectRows, "ecoid");
    }

    private boolean verifySubmitData(Set<Long> idSet, int[] selectRows) {
        StringBuilder message = new StringBuilder();
        for (int i = 0; i < selectRows.length; ++i) {
            int rowIndex = selectRows[i];
            int realSeq = rowIndex + 1;
            if (!this.isAddStatus(null, rowIndex)) {
                String ecnBillNo = this.getStringValue("billno", rowIndex);
                message.append(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u5355\u636e\u201c%2$s\u201d\u4e0d\u662f\u6682\u5b58\u72b6\u6001\u3002", (String)"EcoBomPlatFormQueryPlugin_10", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), realSeq, ecnBillNo));
                continue;
            }
            String mustInput = this.checkMustInput(rowIndex);
            if (mustInput.length() > 0) {
                message.append(mustInput);
                continue;
            }
            String dataValide = this.checkDataValidate(rowIndex);
            if (dataValide.length() <= 0) continue;
            message.append(dataValide);
        }
        if (message.length() > 0) {
            this.getView().showTipNotification(message.toString());
            return false;
        }
        return true;
    }

    private boolean verifyAuditData(Set<Long> idSet, int[] selectRows) {
        StringBuilder message = new StringBuilder();
        for (int i = 0; i < selectRows.length; ++i) {
            int rowIndex = selectRows[i];
            int realSeq = rowIndex + 1;
            if (!this.isSubmitStatus(null, rowIndex)) {
                String ecnBillNo = this.getStringValue("billno", rowIndex);
                message.append(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u5355\u636e\u201c%2$s\u201d\u4e0d\u662f\u63d0\u4ea4\u72b6\u6001\u3002", (String)"EcoBomPlatFormQueryPlugin_11", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), realSeq, ecnBillNo));
                continue;
            }
            String mustInput = this.checkMustInput(rowIndex);
            if (mustInput.length() > 0) {
                message.append(mustInput);
                continue;
            }
            String dataValide = this.checkDataValidate(rowIndex);
            if (dataValide.length() <= 0) continue;
            message.append(dataValide);
        }
        if (message.length() > 0) {
            this.getView().showTipNotification(message.toString());
            return false;
        }
        return true;
    }

    private boolean verifyUnSubmitData(Set<Long> idSet, int[] selectRows) {
        StringBuilder message = new StringBuilder();
        for (int i = 0; i < selectRows.length; ++i) {
            int rowIndex = selectRows[i];
            int realSeq = rowIndex + 1;
            if (this.isSubmitStatus(null, rowIndex)) continue;
            String ecnBillNo = this.getStringValue("billno", rowIndex);
            message.append(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u5355\u636e\u201c%2$s\u201d\u4e0d\u662f\u63d0\u4ea4\u72b6\u6001\u3002", (String)"EcoBomPlatFormQueryPlugin_11", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), realSeq, ecnBillNo));
        }
        if (message.length() > 0) {
            this.getView().showTipNotification(message.toString());
            return false;
        }
        return true;
    }

    private boolean verifyDeleteData(Set<Long> idSet, int[] selectRows) {
        StringBuilder message = new StringBuilder();
        for (int i = 0; i < selectRows.length; ++i) {
            int rowIndex = selectRows[i];
            int realSeq = rowIndex + 1;
            if (this.isAddStatus(null, rowIndex)) continue;
            String ecnBillNo = this.getStringValue("billno", rowIndex);
            message.append(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u5355\u636e\u201c%2$s\u201d\u4e0d\u662f\u6682\u5b58\u72b6\u6001\u3002", (String)"EcoBomPlatFormQueryPlugin_10", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), realSeq, ecnBillNo));
        }
        if (message.length() > 0) {
            this.getView().showTipNotification(message.toString());
            return false;
        }
        return true;
    }

    private String checkMustInput(int rowIndex) {
        StringBuilder message = new StringBuilder();
        if (this.getValue("acttime", rowIndex) == null) {
            message.append(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%s\u201d\u884c\u5355\u636e\u7684\u201c\u5b9e\u65bd\u65f6\u95f4\u201d\u5fc5\u5f55\u3002", (String)"EcoBomPlatFormQueryPlugin_12", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), rowIndex + 1));
        }
        if (this.isBomChange(rowIndex) && !this.isCopChange(rowIndex) && this.getValue("useqty", rowIndex) == null) {
            message.append(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%s\u201d\u884c\u5355\u636e\u7684\u201c\u6d88\u8017\u6570\u91cf\u201d\u5fc5\u5f55\u3002", (String)"EcoBomPlatFormQueryPlugin_13", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), rowIndex + 1));
        }
        return message.toString();
    }

    private String checkDataValidate(int rowIndex) {
        DynamicObject ecoType;
        ActTimeCopBean bean;
        if (this.getValue("acttime", rowIndex) == null) {
            return "";
        }
        String chkMsg = "";
        if (this.isBomChange(rowIndex)) {
            if (this.isCopChange(rowIndex)) {
                bean = this.genActtimeBomCopBean(rowIndex);
                chkMsg = ActTimeCopValidataBusiness.getInstance().checkValidData(bean);
            } else {
                bean = this.genActtimeBean(rowIndex);
                chkMsg = ActTimeValidataBusiness.getInstance().checkValidData((ActTimeBean)bean);
            }
        } else if (this.isRouteChange(rowIndex)) {
            bean = this.genActtimeRouteBean(rowIndex);
            chkMsg = ActTimeRouteValidataBusiness.getInstance().checkValidData((ActTimeRouteBean)bean);
        }
        if (!StringUtils.isEmpty((String)chkMsg)) {
            return String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a%2$s\u3002", (String)"EcoBomPlatFormQueryPlugin_14", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), rowIndex + 1, chkMsg);
        }
        if (this.getValue("pentryvaliddate", rowIndex) == null && (ecoType = this.getDynamicObjectValue("ecotype", rowIndex)) != null && "B".equals(ecoType.getString("adjusttype"))) {
            return String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c:\u201c\u4ea7\u54c1\u4fe1\u606f-\u751f\u6548\u65f6\u95f4\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EcoBomPlatFormQueryPlugin_15", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), rowIndex + 1);
        }
        return chkMsg;
    }

    private boolean checkSelectDataCoType(int[] selectRows) {
        StringBuilder message = new StringBuilder();
        HashMap<Long, Long> selectMap = new HashMap<Long, Long>(16);
        for (int i = 0; i < selectRows.length; ++i) {
            Long ecoTypeOldId;
            int rowIndex = selectRows[i];
            int realSeq = rowIndex + 1;
            Long pentryId = this.getLongValue("ecopentryid", rowIndex);
            DynamicObject ecoType = this.getDynamicObjectValue("ecotype", rowIndex);
            Long ecoTypeId = 0L;
            if (ecoType != null) {
                ecoTypeId = ecoType.getLong("id");
            }
            if ((ecoTypeOldId = (Long)selectMap.get(pentryId)) == null) {
                selectMap.put(pentryId, ecoTypeId);
                continue;
            }
            if (ecoTypeId.equals(ecoTypeOldId)) continue;
            message.append(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%s\u201d\u884c\u53d8\u66f4\u5355\u7684\u540c\u4e00\u4ea7\u54c1\u7c7b\u578b\uff0c\u5b58\u5728\u4e0d\u540c\u7684\u53d8\u66f4\u7c7b\u578b\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"EcoBomPlatFormQueryPlugin_16", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), realSeq));
        }
        if (message.length() > 0) {
            this.getView().showTipNotification(message.toString());
            return false;
        }
        return true;
    }

    private boolean checkSelectDataGroupNo(int[] selectRows, String opKey, BeforeDoOperationEventArgs e) {
        Set<Long> allEcoEntryIdSet;
        Long pentryid;
        String groupNo;
        Long pentryId;
        if (this.isDisableGroupNo()) {
            return true;
        }
        StringBuilder message = new StringBuilder();
        HashMap<String, String> addMap = new HashMap<String, String>(16);
        HashMap<String, String> disableMap = new HashMap<String, String>(16);
        HashMap<String, Date> maxActtimeMap = new HashMap<String, Date>(16);
        HashMap<String, Date> maxValidDateMap = new HashMap<String, Date>(16);
        HashMap<String, Date> minInValidDateMap = new HashMap<String, Date>(16);
        HashMap<String, Date> keyDateMap = new HashMap<String, Date>(16);
        HashMap<Long, Integer> rowMap = new HashMap<Long, Integer>(16);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashSet<Long> selectEcoEntryIdSet = new HashSet<Long>(16);
        HashSet<Long> updateEcoEntryIdSet = new HashSet<Long>(16);
        HashSet<Long> updatePEntryIdSet = new HashSet<Long>(16);
        HashMap<String, String> keyStringActTimeMap = new HashMap<String, String>(16);
        HashMap<String, String> groupMap = new HashMap<String, String>(16);
        HashMap<String, Long> keyRowMap = new HashMap<String, Long>(16);
        HashMap<String, Boolean> hasKeyMap = new HashMap<String, Boolean>(16);
        HashSet<Long> noGroupNoEntryIdSet = new HashSet<Long>(16);
        for (int i = 0; i < selectRows.length; ++i) {
            Date minEntryInValidDate;
            Date maxEntryValidDate;
            int rowIndex = selectRows[i];
            int realSeq = rowIndex + 1;
            if (this.isRouteChange(rowIndex) || this.isCopChange(rowIndex)) continue;
            Long ecoEntryId = this.getLongValue("ecoentryid", rowIndex);
            pentryId = this.getLongValue("ecopentryid", rowIndex);
            groupNo = this.getStringValue("entrygroupno", rowIndex);
            String refNo = this.getStringValue("entryrefno", rowIndex);
            String entrymode = this.getStringValue("entrymode", rowIndex);
            Date actTime = this.getDateValue("acttime", rowIndex);
            Date entryValidDate = this.getDateValue("entryvaliddate", rowIndex);
            Date entryInValidDate = this.getDateValue("entryinvaliddate", rowIndex);
            boolean isGroupKey = this.getBooleanValue("groupkey", rowIndex);
            boolean isEditGroupKey = this.isEditGroupKey(rowIndex);
            updateEcoEntryIdSet.add(ecoEntryId);
            updatePEntryIdSet.add(pentryId);
            rowMap.put(pentryId, rowIndex);
            if (isGroupKey && PlatformUtils.isNullString((String)groupNo) && isEditGroupKey) {
                message.append(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u53d8\u66f4\u5355\u4e3a\u6210\u7ec4\u4e3b\u952e\u884c\uff0c\u4e0d\u5141\u8bb8\u672a\u5f55\u5165\u6210\u7ec4\u53f7\u3002", (String)"EcoBomPlatFormQueryPlugin_17", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), realSeq));
                continue;
            }
            if (PlatformUtils.isNullString((String)groupNo)) {
                noGroupNoEntryIdSet.add(ecoEntryId);
                continue;
            }
            if ("B".equals(entrymode) || "C".equals(entrymode)) continue;
            if (actTime == null) {
                message.append(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u53d8\u66f4\u5355\u5b58\u5728\u6210\u7ec4\u53f7\u201c%2$s\u201d\uff0c\u4e0d\u5141\u8bb8\u5b9e\u65bd\u65f6\u95f4\u4e3a\u7a7a\u3002", (String)"EcoBomPlatFormQueryPlugin_18", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), realSeq, groupNo));
                continue;
            }
            selectEcoEntryIdSet.add(ecoEntryId);
            String keyString = PlatformUtils.getUnionString((Object)pentryId, (Object)groupNo);
            if (isGroupKey) {
                Long keyRowEntryId = (Long)keyRowMap.get(keyString);
                if (!PlatformUtils.isNullLong((Long)keyRowEntryId)) {
                    message.append(String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u7b2c\u201c%1$s\u201d\u884c\u53d8\u66f4\u5355\u7684\u6210\u7ec4\u53f7\u201c%2$s\u201d\u5b58\u5728\u591a\u884c\u6210\u7ec4\u4e3b\u952e\u3002", (String)"EcoBomPlatFormQueryPlugin_19", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), realSeq, groupNo));
                    continue;
                }
                keyRowMap.put(keyString, ecoEntryId);
                keyDateMap.put(keyString, actTime);
            }
            if ((maxEntryValidDate = (Date)maxValidDateMap.get(keyString)) == null || maxEntryValidDate.compareTo(entryValidDate) < 0) {
                maxValidDateMap.put(keyString, entryValidDate);
            }
            if ((minEntryInValidDate = (Date)minInValidDateMap.get(keyString)) == null || minEntryInValidDate.compareTo(entryInValidDate) > 0) {
                minInValidDateMap.put(keyString, entryInValidDate);
            }
            String actTimeString = sdf.format(actTime);
            Date oldActtime = (Date)maxActtimeMap.get(keyString);
            if (oldActtime == null || oldActtime.before(actTime)) {
                maxActtimeMap.put(keyString, actTime);
            }
            if (keyStringActTimeMap.get(keyString) == null) {
                keyStringActTimeMap.put(keyString, actTimeString);
            }
            if ("A".equals(entrymode)) {
                addMap.put(keyString, actTimeString);
            } else if ("E".equals(entrymode)) {
                disableMap.put(keyString, actTimeString);
            }
            if (!PlatformUtils.isNullString((String)refNo)) {
                String oldEntryrefno;
                if (groupMap.containsKey(keyString) && !(oldEntryrefno = (String)groupMap.get(keyString)).equals(refNo)) {
                    message.append(String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u7b2c\u201c%1$s\u201d\u884c\u53d8\u66f4\u5355\u7684\u6210\u7ec4\u53f7\u201c%2$s\u201d\u5b58\u5728\u591a\u4e2a\u5173\u8054\u5b9e\u65bd\u53f7\u3002", (String)"EcoBomPlatFormQueryPlugin_20", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), realSeq, groupNo));
                    continue;
                }
                groupMap.put(keyString, refNo);
            }
            if (!isEditGroupKey) continue;
            if (!hasKeyMap.containsKey(keyString)) {
                hasKeyMap.put(keyString, false);
            }
            if (!isGroupKey || PlatformUtils.isNullString((String)groupNo)) continue;
            hasKeyMap.put(keyString, true);
        }
        if (message.length() > 0) {
            this.getView().showTipNotification(message.toString());
            return false;
        }
        for (Map.Entry keyMaps : hasKeyMap.entrySet()) {
            String keyString = (String)keyMaps.getKey();
            boolean isKey = (Boolean)keyMaps.getValue();
            if (isKey || EcoUtils.checkHasGroupKey((Long)(pentryId = PlatformUtils.getEcoBomId((String)keyString)), (String)(groupNo = PlatformUtils.getGroupNo((String)keyString)), selectEcoEntryIdSet)) continue;
            message.append(String.format(ResManager.loadKDString((String)"\u6210\u7ec4\u53f7\u201c%1$s\u201d\u4e0d\u5b58\u5728\u6210\u7ec4\u4e3b\u952e\u3002", (String)"EcoBomPlatFormQueryPlugin_21", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), groupNo));
        }
        if (message.length() > 0) {
            this.getView().showTipNotification(message.toString());
            return false;
        }
        for (int i = 0; i < selectRows.length; ++i) {
            int rowIndex = selectRows[i];
            int realSeq = rowIndex + 1;
            if (this.isRouteChange(rowIndex)) continue;
            Long pentryId2 = this.getLongValue("ecopentryid", rowIndex);
            String groupNo2 = this.getStringValue("entrygroupno", rowIndex);
            String entrymode = this.getStringValue("entrymode", rowIndex);
            Date actTime = this.getDateValue("acttime", rowIndex);
            boolean isGroupKey = this.getBooleanValue("groupkey", rowIndex);
            if (PlatformUtils.isNullString((String)groupNo2) || "B".equals(entrymode) || "C".equals(entrymode)) continue;
            String keyString = PlatformUtils.getUnionString((Object)pentryId2, (Object)groupNo2);
            Date maxEntryValidDate = (Date)maxValidDateMap.get(keyString);
            Date minEntryInValidDate = (Date)minInValidDateMap.get(keyString);
            if (maxEntryValidDate != null && minEntryInValidDate != null && (actTime.before(maxEntryValidDate) || actTime.after(minEntryInValidDate))) {
                message.append(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u53d8\u66f4\u5355\u5b58\u5728\u6210\u7ec4\u53f7\u201c%2$s\u201d\uff0c\u4f46\u5b9e\u65bd\u65f6\u95f4\u201c%3$s\u201d\u5e94\u4ecb\u4e8e\u6210\u7ec4\u53f7\u5bf9\u5e94\u7684\u6700\u5927\u751f\u6548\u65f6\u95f4\u201c%4$s\u201d\u4e0e\u6700\u5c0f\u5931\u6548\u65f6\u95f4\u201c%5$s\u201d\u4e4b\u95f4\u3002", (String)"EcoBomPlatFormQueryPlugin_22", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), realSeq, groupNo2, sdf.format(actTime), sdf.format(maxEntryValidDate), sdf.format(minEntryInValidDate)));
                continue;
            }
            if (isGroupKey || !this.isAuditStatus(null, rowIndex)) continue;
            Date keyRowActTime = (Date)keyDateMap.get(keyString);
            if (keyRowActTime == null) {
                keyRowActTime = EcoUtils.getGroupNoEcoBomKeyActtime((Long)pentryId2, (String)groupNo2);
            }
            if (keyRowActTime == null || sdf.format(actTime).equals(sdf.format(keyRowActTime))) continue;
            message.append(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u53d8\u66f4\u5355\u5b58\u5728\u6210\u7ec4\u53f7\u201c%2$s\u201d\uff0c\u5b9e\u65bd\u65f6\u95f4\u201c%3$s\u201d\u5e94\u7b49\u4e8e\u6210\u7ec4\u4e3b\u952e\u884c\u7684\u5b9e\u65bd\u65f6\u95f4\u201c%4$s\u201d\u3002", (String)"EcoBomPlatFormQueryPlugin_23", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), realSeq, groupNo2, sdf.format(actTime), sdf.format(keyRowActTime)));
        }
        if (message.length() > 0) {
            this.getView().showTipNotification(message.toString());
            return false;
        }
        Map typeMap = EcoUtils.getOtherGroupNos(updatePEntryIdSet, updateEcoEntryIdSet, noGroupNoEntryIdSet);
        if (typeMap != null) {
            EcoUtils.addToMap((Map)((Map)typeMap.get("A")), addMap);
            EcoUtils.addToMap((Map)((Map)typeMap.get("E")), disableMap);
        }
        for (Map.Entry addEntrys : addMap.entrySet()) {
            String keyString = (String)addEntrys.getKey();
            if (disableMap.containsKey(keyString)) continue;
            pentryid = PlatformUtils.getEcoBomId((String)keyString);
            groupNo = PlatformUtils.getGroupNo((String)keyString);
            int rowIndex = (Integer)rowMap.get(pentryid);
            Long ecoBomId = this.getLongValue("ecobomid", rowIndex);
            allEcoEntryIdSet = PlatFormQueryDataHelper.getEcoBomEntryAllGroupNoData(ecoBomId, groupNo, "E");
            if (allEcoEntryIdSet != null && !allEcoEntryIdSet.isEmpty() && noGroupNoEntryIdSet != null && !noGroupNoEntryIdSet.isEmpty()) {
                allEcoEntryIdSet.removeAll(noGroupNoEntryIdSet);
            }
            if (allEcoEntryIdSet != null && !allEcoEntryIdSet.isEmpty()) continue;
            message.append(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u6570\u636e\u7684\u6210\u7ec4\u53f7\u201c%2$s\u201d\u6ca1\u6709\u540c\u65f6\u5b58\u5728\u65b0\u589e\u4e0e\u5931\u6548\u7684\u7ec4\u4ef6\u6570\u636e\u3002", (String)"EcoBomPlatFormQueryPlugin_24", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), rowIndex + 1, groupNo));
        }
        for (Map.Entry disableEntrys : disableMap.entrySet()) {
            String keyString = (String)disableEntrys.getKey();
            if (addMap.containsKey(keyString)) continue;
            pentryid = PlatformUtils.getEcoBomId((String)keyString);
            groupNo = PlatformUtils.getGroupNo((String)keyString);
            int rowIndex = (Integer)rowMap.get(pentryid);
            Long ecoBomId = this.getLongValue("ecobomid", rowIndex);
            allEcoEntryIdSet = PlatFormQueryDataHelper.getEcoBomEntryAllGroupNoData(ecoBomId, groupNo, "A");
            if (allEcoEntryIdSet != null && !allEcoEntryIdSet.isEmpty() && noGroupNoEntryIdSet != null && !noGroupNoEntryIdSet.isEmpty()) {
                allEcoEntryIdSet.removeAll(noGroupNoEntryIdSet);
            }
            if (allEcoEntryIdSet != null && !allEcoEntryIdSet.isEmpty()) continue;
            message.append(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u6570\u636e\u7684\u6210\u7ec4\u53f7\u201c%2$s\u201d\u6ca1\u6709\u540c\u65f6\u5b58\u5728\u65b0\u589e\u4e0e\u5931\u6548\u7684\u7ec4\u4ef6\u6570\u636e\u3002", (String)"EcoBomPlatFormQueryPlugin_24", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), rowIndex + 1, groupNo));
        }
        if (message.length() > 0) {
            this.getView().showTipNotification(message.toString());
            return false;
        }
        return true;
    }

    private boolean checkSelectDataRefNo(int[] selectRows, String opKey, BeforeDoOperationEventArgs e) {
        Date actTime;
        String refNo;
        StringBuilder message = new StringBuilder();
        HashSet<String> refNoSet = new HashSet<String>(16);
        HashSet<String> refNoSetA = new HashSet<String>(16);
        HashSet<String> refNoSetB = new HashSet<String>(16);
        HashMap<String, Long> keyRowMap = new HashMap<String, Long>(16);
        HashMap<String, Date> keyDateMap = new HashMap<String, Date>(16);
        HashSet<Long> noRefEcoEntryIdSet = new HashSet<Long>(16);
        HashSet<Long> ecoEntryIdSet = new HashSet<Long>(16);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashMap<String, Boolean> hasKeyMap = new HashMap<String, Boolean>(16);
        HashMap<Long, String> pMap = new HashMap<Long, String>(16);
        HashMap refNoEcoTypeMap = new HashMap(16);
        HashSet<Long> ecoBomIdSet = new HashSet<Long>(16);
        for (int i = 0; i < selectRows.length; ++i) {
            Set tSet;
            String entryMode;
            int rowIndex = selectRows[i];
            int realSeq = rowIndex + 1;
            if (this.isRouteChange(rowIndex) || this.isCopChange(rowIndex)) continue;
            Long ecoEntryId = this.getLongValue("ecoentryid", rowIndex);
            refNo = this.getStringValue("entryrefno", rowIndex);
            boolean isRefKey = this.getBooleanValue("refkey", rowIndex);
            actTime = this.getDateValue("acttime", rowIndex);
            DynamicObject ecoType = this.getDynamicObjectValue("ecotype", rowIndex);
            Long ecoBomId = this.getLongValue("ecobomid", rowIndex);
            boolean isEditRefKey = this.isEditRefKey(rowIndex);
            if (isRefKey && PlatformUtils.isNullString((String)refNo) && isEditRefKey) {
                message.append(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u53d8\u66f4\u5355\u4e3a\u5173\u8054\u4e3b\u952e\u884c\uff0c\u4e0d\u5141\u8bb8\u672a\u5f55\u5165\u5173\u8054\u5b9e\u65bd\u53f7\u3002", (String)"EcoBomPlatFormQueryPlugin_25", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), realSeq));
                continue;
            }
            if (PlatformUtils.isNullString((String)refNo)) continue;
            if (actTime == null) {
                message.append(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u53d8\u66f4\u5355\u5b58\u5728\u5173\u8054\u5b9e\u65bd\u53f7\u201c%2$s\u201d\uff0c\u4e0d\u5141\u8bb8\u5b9e\u65bd\u65f6\u95f4\u4e3a\u7a7a\u3002", (String)"EcoBomPlatFormQueryPlugin_26", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), realSeq, refNo));
                continue;
            }
            if (ecoType != null) {
                Long oldEcotypeId;
                HashMap<Long, Long> oldEcoBomMap = (HashMap<Long, Long>)refNoEcoTypeMap.get(refNo);
                if (oldEcoBomMap == null) {
                    oldEcoBomMap = new HashMap<Long, Long>(16);
                }
                if (!PlatformUtils.isNullLong((Long)(oldEcotypeId = this.getFirstLongValueFromMap((Map<Long, Long>)oldEcoBomMap))) && !oldEcotypeId.equals(ecoType.getLong("id"))) {
                    message.append(String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u7b2c\u201c%1$s\u201d\u884c\u53d8\u66f4\u5355\u5173\u8054\u5b9e\u65bd\u53f7\u201c%2$s\u201d\u5b58\u5728\u4e0d\u540c\u7684\u53d8\u66f4\u7c7b\u578b\u3002", (String)"EcoBomPlatFormQueryPlugin_27", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), realSeq, refNo));
                    continue;
                }
                oldEcoBomMap.put(ecoBomId, ecoType.getLong("id"));
                refNoEcoTypeMap.put(refNo, oldEcoBomMap);
                ecoBomIdSet.add(ecoBomId);
            }
            refNoSet.add(refNo);
            if (this.isEstimateStatusB(rowIndex)) {
                refNoSetB.add(refNo);
            } else if (this.isEstimateStatusA(rowIndex)) {
                refNoSetA.add(refNo);
            }
            if (isRefKey) {
                Long keyRowEntryId = (Long)keyRowMap.get(refNo);
                if (!PlatformUtils.isNullLong((Long)keyRowEntryId)) {
                    message.append(String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u7b2c\u201c%1$s\u201d\u884c\u53d8\u66f4\u5355\u7684\u5173\u8054\u5b9e\u65bd\u53f7\u201c%2$s\u201d\u5b58\u5728\u591a\u884c\u5173\u8054\u4e3b\u952e\u3002", (String)"EcoBomPlatFormQueryPlugin_28", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), realSeq, refNo));
                    continue;
                }
                keyRowMap.put(refNo, ecoEntryId);
                keyDateMap.put(refNo, actTime);
            } else {
                noRefEcoEntryIdSet.add(ecoEntryId);
            }
            if (isEditRefKey) {
                ecoEntryIdSet.add(ecoEntryId);
                if (!hasKeyMap.containsKey(refNo)) {
                    hasKeyMap.put(refNo, false);
                }
                if (isRefKey && !PlatformUtils.isNullString((String)refNo)) {
                    hasKeyMap.put(refNo, true);
                }
            }
            if (!"E".equals(entryMode = this.getStringValue("entrymode", rowIndex)) && !"A".equals(entryMode)) continue;
            pMap.put(ecoEntryId, refNo);
            HashSet<Long> mftBomEntryIdSet = new HashSet<Long>(16);
            Long mftBomEntryId = this.getLongValue("bomentryid", rowIndex);
            Long ecoId = this.getLongValue("ecoid", rowIndex);
            mftBomEntryIdSet.add(mftBomEntryId);
            Map chkRefPointMaps = EcoUtils.getRefNoContinuPointEcnData((String)refNo, mftBomEntryIdSet, (Long)ecoId);
            if (chkRefPointMaps != null && chkRefPointMaps.get(mftBomEntryId) != null) {
                String otherEcnNo = (String)chkRefPointMaps.get(mftBomEntryId);
                message.append(String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u201c%1$s\u201d\u884c\u53d8\u66f4\u5355\u7684\u5173\u8054\u5b9e\u65bd\u53f7\u201c%2$s\u201d\u4e0e\u8fde\u7eed\u65ad\u70b9\u53d8\u66f4\u5355\u201c%3$s\u201d\u7684\u5173\u8054\u5b9e\u65bd\u53f7\u4e00\u81f4\u3002", (String)"EcoBomPlatFormQueryPlugin_29", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), realSeq, refNo, otherEcnNo));
                continue;
            }
            HashSet<Long> sSet = new HashSet<Long>(16);
            sSet.add(ecoEntryId);
            Map pointMap = EcoUtils.getContinuityEcnIdMap(sSet);
            if (pointMap == null || (tSet = (Set)pointMap.get(ecoEntryId)) == null || tSet.isEmpty()) continue;
            for (Long tid : tSet) {
                String tRefNo = (String)pMap.get(tid);
                if (tRefNo == null || !tRefNo.equals(refNo)) continue;
                message.append(String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u201c%1$s\u201d\u884c\u53d8\u66f4\u5355\u7684\u5173\u8054\u5b9e\u65bd\u53f7\u201c%2$s\u201d\u4e0e\u8fde\u7eed\u65ad\u70b9\u53d8\u66f4\u5355\u201c%3$s\u201d\u7684\u5173\u8054\u5b9e\u65bd\u53f7\u4e00\u81f4\u3002", (String)"EcoBomPlatFormQueryPlugin_30", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), realSeq, refNo));
            }
        }
        if (message.length() > 0) {
            this.getView().showTipNotification(message.toString());
            return false;
        }
        for (Map.Entry keyMaps : hasKeyMap.entrySet()) {
            String keyString = (String)keyMaps.getKey();
            boolean isKey = (Boolean)keyMaps.getValue();
            if (isKey || EcoUtils.checkHasRefKey((String)keyString, ecoEntryIdSet)) continue;
            message.append(String.format(ResManager.loadKDString((String)"\u5173\u8054\u5b9e\u65bd\u53f7\u201c%1$s\u201d\u4e0d\u5b58\u5728\u5173\u8054\u4e3b\u952e\u3002", (String)"EcoBomPlatFormQueryPlugin_31", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), keyString));
        }
        if (message.length() > 0) {
            this.getView().showTipNotification(message.toString());
            return false;
        }
        if (!refNoSet.isEmpty()) {
            Map refNoEcoTypeMap2;
            Set existEndSet;
            if (!refNoSetA.isEmpty() && (existEndSet = EcoUtils.checkRefnoIsEnd(refNoSetA, (boolean)true)) != null && !existEndSet.isEmpty()) {
                message.append(String.format(ResManager.loadKDString((String)"\u5173\u8054\u5b9e\u65bd\u53f7%1$s\u5df2\u7ecf\u5b58\u5728\u5904\u4e8e\u8bc4\u4f30\u4e2d\u6216\u8bc4\u4f30\u5b8c\u6210\u7684\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u3002", (String)"EcoBomPlatFormQueryPlugin_32", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), existEndSet.toString()));
                this.getView().showTipNotification(message.toString());
                return false;
            }
            if (!refNoSetB.isEmpty() && (existEndSet = EcoUtils.checkRefnoIsEnd(refNoSetB, (boolean)false)) != null && !existEndSet.isEmpty()) {
                message.append(String.format(ResManager.loadKDString((String)"\u5173\u8054\u5b9e\u65bd\u53f7%1$s\u5df2\u7ecf\u5b58\u5728\u5904\u4e8e\u8bc4\u4f30\u5b8c\u6210\u7684\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u3002", (String)"EcoBomPlatFormQueryPlugin_33", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), existEndSet.toString()));
                this.getView().showTipNotification(message.toString());
                return false;
            }
            Map otherKeyEntryIdMap = EcoUtils.getRefKeyEntryIdSet(refNoSet);
            if (otherKeyEntryIdMap != null && !otherKeyEntryIdMap.isEmpty()) {
                for (Map.Entry rowKeyMaps : keyRowMap.entrySet()) {
                    String refNo2 = (String)rowKeyMaps.getKey();
                    Long rowKeyEntryId = (Long)rowKeyMaps.getValue();
                    for (Map.Entry entrys : otherKeyEntryIdMap.entrySet()) {
                        Long rowKeyEntryId2 = (Long)entrys.getKey();
                        String refNo22 = (String)entrys.getValue();
                        if (!refNo22.equals(refNo2) || rowKeyEntryId2.equals(rowKeyEntryId) || noRefEcoEntryIdSet.contains(rowKeyEntryId2)) continue;
                        message.append(String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5173\u8054\u5b9e\u65bd\u53f7\u201c%1$s\u201d\u5b58\u5728\u5176\u5b83\u53d8\u66f4\u5355\u4e2d\u7684\u5173\u8054\u4e3b\u952e\u884c\u3002", (String)"EcoBomPlatFormQueryPlugin_34", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), entrys.getValue()));
                        this.getView().showTipNotification(message.toString());
                        return false;
                    }
                }
            }
            if ((refNoEcoTypeMap2 = EcoUtils.getRefnoEcoTypeMap(refNoSet, ecoBomIdSet)) != null && !refNoEcoTypeMap2.isEmpty()) {
                for (Map.Entry refNoEcoTypeMap2s : refNoEcoTypeMap2.entrySet()) {
                    refNo = (String)refNoEcoTypeMap2s.getKey();
                    Map ecoBomDataMap = (Map)refNoEcoTypeMap.get(refNo);
                    if (ecoBomDataMap == null) continue;
                    Long currentEcoTypeId = this.getFirstLongValueFromMap(ecoBomDataMap);
                    Map ecoBomDataMap2 = (Map)refNoEcoTypeMap2s.getValue();
                    for (Map.Entry ecoBomDataMap2s : ecoBomDataMap2.entrySet()) {
                        Long ecoBomId = (Long)ecoBomDataMap2s.getKey();
                        Long ecoTypeId = (Long)ecoBomDataMap2s.getValue();
                        if (ecoTypeId == null || ecoTypeId.equals(0L) || currentEcoTypeId.equals(ecoTypeId) || ecoBomDataMap.containsKey(ecoBomId)) continue;
                        message.append(String.format(ResManager.loadKDString((String)"\u5173\u8054\u5b9e\u65bd\u53f7\u201c%1$s\u201d\u5bf9\u5e94\u7684\u53d8\u66f4\u7c7b\u578b\u4e0d\u552f\u4e00\u3002", (String)"EcoBomPlatFormQueryPlugin_35", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), refNo));
                        this.getView().showTipNotification(message.toString());
                        return false;
                    }
                }
            }
        }
        Map dbRefNoActtimeMap = EcoUtils.getRefEcoBomKeyActtime(refNoSet);
        for (int i = 0; i < selectRows.length; ++i) {
            int rowIndex = selectRows[i];
            int realSeq = rowIndex + 1;
            if (this.isRouteChange(rowIndex)) continue;
            refNo = this.getStringValue("entryrefno", rowIndex);
            boolean isRefKey = this.getBooleanValue("refkey", rowIndex);
            actTime = this.getDateValue("acttime", rowIndex);
            if (PlatformUtils.isNullString((String)refNo) || isRefKey || !this.isAuditStatus(null, rowIndex)) continue;
            Date keyRowActTime = (Date)keyDateMap.get(refNo);
            if (keyRowActTime == null) {
                keyRowActTime = (Date)dbRefNoActtimeMap.get(refNo);
            }
            if (keyRowActTime == null || sdf.format(actTime).equals(sdf.format(keyRowActTime))) continue;
            message.append(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u53d8\u66f4\u5355\u5b58\u5728\u5173\u8054\u5b9e\u65bd\u53f7\u201c%2$s\u201d\uff0c\u5b9e\u65bd\u65f6\u95f4\u201c%3$s\u201d\u5e94\u7b49\u4e8e\u5173\u8054\u4e3b\u952e\u884c\u7684\u5b9e\u65bd\u65f6\u95f4\u201c%4$s\u201d\u3002", (String)"EcoBomPlatFormQueryPlugin_36", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), realSeq, refNo, sdf.format(actTime), sdf.format(keyRowActTime)));
        }
        if (message.length() > 0) {
            this.getView().showTipNotification(message.toString());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAfterExecOp(String opKey, AfterDoOperationEventArgs e) {
        if (e.getOperationResult().isSuccess()) {
            HashSet<Long> lockSuccessfulIdSet;
            Map<Long, String> selectMap;
            String message;
            Set<Long> idSet = this.getSelectBillIdSet();
            if (idSet == null || idSet.isEmpty()) {
                return;
            }
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentitys");
            int[] selectRows = entryGrid.getSelectRows();
            boolean isExecOp = false;
            if ("submit".equalsIgnoreCase(opKey) || "audit".equalsIgnoreCase(opKey) || "unsubmit".equalsIgnoreCase(opKey) || "delete".equalsIgnoreCase(opKey)) {
                isExecOp = true;
            }
            if (!StringUtils.isEmpty((String)(message = this.batchRequire(selectMap = this.getSelectDataMap(selectRows), lockSuccessfulIdSet = new HashSet<Long>(selectRows.length))))) {
                this.getView().showTipNotification(message);
                return;
            }
            if (isExecOp && !lockSuccessfulIdSet.isEmpty()) {
                this.releaseLock(lockSuccessfulIdSet);
                lockSuccessfulIdSet.clear();
            }
            String errorMsg = "";
            List<Object> successIds = null;
            List auditSuccessIds = null;
            int saveBomDataExecResult = 0;
            try {
                if ("save".equals(opKey) || "updatebom".equals(opKey)) {
                    saveBomDataExecResult = this.saveData(idSet, selectRows);
                    if (saveBomDataExecResult == 2) {
                        successIds = new ArrayList<Long>(idSet);
                    }
                } else if ("handestimateend".equals(opKey)) {
                    saveBomDataExecResult = this.handEstimateEnd(idSet, selectRows);
                    if (saveBomDataExecResult == 2) {
                        successIds = new ArrayList<Long>(idSet);
                    }
                } else {
                    if ("submit".equals(opKey) && (saveBomDataExecResult = this.saveData(idSet, selectRows)) == -1) {
                        return;
                    }
                    Map<String, Object> returnMap = PlatFormQueryDataHelper.executeOperation(idSet, opKey);
                    if (returnMap == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u6536\u5230\u4efb\u4f55\u6267\u884c\u6570\u636e\u7ed3\u679c\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"EcoBomPlatFormQueryPlugin_37", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (returnMap.get("msg") != null) {
                        errorMsg = returnMap.get("msg").toString();
                    }
                    if ((successIds = (List)returnMap.get("successpkids")) != null && !successIds.isEmpty() && "submit".equals(opKey) && this.getSubmitAndAudit()) {
                        Set auditIds = PlatformUtils.ListToSet(successIds);
                        returnMap = PlatFormQueryDataHelper.executeOperation(auditIds, "audit");
                        if (returnMap == null) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u6536\u5230\u4efb\u4f55\u6267\u884c\u6570\u636e\u7ed3\u679c\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"EcoBomPlatFormQueryPlugin_37", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        if (returnMap.get("msg") != null) {
                            errorMsg = errorMsg + " " + returnMap.get("msg").toString();
                        }
                        auditSuccessIds = (List)returnMap.get("successpkids");
                    }
                    if ("audit".equals(opKey)) {
                        auditSuccessIds = successIds;
                    }
                }
            }
            finally {
                this.releaseLock(lockSuccessfulIdSet);
            }
            if (saveBomDataExecResult == -1) {
                return;
            }
            if (saveBomDataExecResult == 1 && !"submit".equals(opKey)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4fee\u6539\u4efb\u4f55\u6570\u636e,\u672a\u89e6\u53d1\u4fdd\u5b58\u64cd\u4f5c\u3002", (String)"EcoBomPlatFormQueryPlugin_38", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!StringUtils.isEmpty((String)errorMsg)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u53d1\u751f\u9519\u8bef", (String)"EcoBomPlatFormQueryPlugin_39", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), errorMsg, MessageTypes.Default);
            } else {
                if ("save".equals(opKey)) {
                    errorMsg = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"EcoBomPlatFormQueryPlugin_40", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                } else if ("submit".equals(opKey)) {
                    errorMsg = ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"EcoBomPlatFormQueryPlugin_41", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                } else if ("audit".equals(opKey)) {
                    errorMsg = ResManager.loadKDString((String)"\u5ba1\u6838\u6210\u529f", (String)"EcoBomPlatFormQueryPlugin_42", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                    ECNAfterAuditUtils.throwMsg(auditSuccessIds, this.getView());
                } else if ("unsubmit".equals(opKey)) {
                    errorMsg = ResManager.loadKDString((String)"\u64a4\u9500\u6210\u529f", (String)"EcoBomPlatFormQueryPlugin_43", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                } else if ("delete".equals(opKey)) {
                    errorMsg = ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"EcoBomPlatFormQueryPlugin_44", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                } else if ("updatebom".equals(opKey)) {
                    errorMsg = ResManager.loadKDString((String)"\u66f4\u65b0\u6570\u636e\u6210\u529f", (String)"EcoBomPlatFormQueryPlugin_45", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                } else if ("handestimateend".equals(opKey)) {
                    errorMsg = ResManager.loadKDString((String)"\u624b\u5de5\u8bc4\u4f30\u5df2\u6210\u529f\u5b8c\u6210\u3002", (String)"EcoBomPlatFormQueryPlugin_46", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                }
                if (!StringUtils.isEmpty((String)errorMsg)) {
                    this.getView().showSuccessNotification(errorMsg);
                }
            }
            if ("delete".equals(opKey) || "audit".equals(opKey) || "updatebom".equals(opKey) || "unsubmit".equals(opKey) || "handestimateend".equals(opKey) || "submit".equals(opKey)) {
                this.getView().invokeOperation("refresh");
            } else {
                this.afterOpRefreshBill(successIds, selectRows);
            }
        }
    }

    private void doBeforeVerfiy(String opKey, BeforeDoOperationEventArgs e) {
        int updateSize;
        Set<Long> idSet = this.getSelectBillIdSet();
        if (idSet == null || idSet.isEmpty()) {
            e.setCancel(true);
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentitys");
        int[] selectRows = entryGrid.getSelectRows();
        if (!this.verifyPermissionData(opKey, selectRows)) {
            e.setCancel(true);
            return;
        }
        if ("save".equals(opKey) || "submit".equals(opKey)) {
            if (!this.verifySubmitData(idSet, selectRows)) {
                e.setCancel(true);
                return;
            }
            if (!this.checkSelectDataCoType(selectRows)) {
                e.setCancel(true);
                return;
            }
            if (!this.checkSelectDataGroupNo(selectRows, opKey, e)) {
                e.setCancel(true);
                return;
            }
            if (!this.checkSelectDataRefNo(selectRows, opKey, e)) {
                e.setCancel(true);
            }
            if (!this.checkSelectDataReplaceGroupNo(selectRows)) {
                e.setCancel(true);
                return;
            }
        } else if ("audit".equals(opKey)) {
            if (!this.verifyAuditData(idSet, selectRows)) {
                e.setCancel(true);
            }
        } else if ("unsubmit".equals(opKey)) {
            if (!this.verifyUnSubmitData(idSet, selectRows)) {
                e.setCancel(true);
            }
        } else if ("delete".equals(opKey)) {
            if (!this.verifyDeleteData(idSet, selectRows)) {
                e.setCancel(true);
            }
        } else if ("updatebom".equals(opKey)) {
            if (!this.verifyUpdateBomData(idSet, selectRows)) {
                e.setCancel(true);
                return;
            }
            if (!this.checkSelectDataCoType(selectRows)) {
                e.setCancel(true);
                return;
            }
            if (!this.checkSelectDataGroupNo(selectRows, opKey, e)) {
                e.setCancel(true);
                return;
            }
            if (!this.checkSelectDataRefNo(selectRows, opKey, e)) {
                e.setCancel(true);
                return;
            }
            if (!this.checkSelectDataPEntryValidDate(selectRows)) {
                e.setCancel(true);
                return;
            }
            if (!this.checkSelectDataReplaceGroupNo(selectRows)) {
                e.setCancel(true);
                return;
            }
            String actIsAdjust = this.checkActtimeIsChange(selectRows);
            if (!StringUtils.isEmpty((String)actIsAdjust)) {
                this.getView().showTipNotification(actIsAdjust);
                e.setCancel(true);
            }
        } else if ("handestimateend".equals(opKey) && (updateSize = this.verifyHandEstimateEnd(idSet, selectRows)) == 0) {
            e.setCancel(true);
        }
    }

    private void afterOpRefreshBill(List<Object> successIds, int[] selectRows) {
        if (successIds != null && !successIds.isEmpty()) {
            Map<Long, Map<String, Object>> dataMap = PlatFormQueryDataHelper.getEcoBillEntryNewData(successIds);
            int rowCount = this.getModel().getEntryRowCount("entryentitys");
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            this.getPageCache().put("isIgnoreChangeListener", "true");
            model.beginInit();
            HashSet<Integer> updateRowSet = new HashSet<Integer>(16);
            if (rowCount <= 100 || selectRows.length < 2) {
                for (int i = 0; i < rowCount; ++i) {
                    this.updateRowDataById(i, dataMap, updateRowSet);
                }
            } else {
                for (int rowIndex : selectRows) {
                    this.updateRowDataById(rowIndex, dataMap, updateRowSet);
                }
            }
            model.endInit();
            if (!updateRowSet.isEmpty()) {
                this.refreshFiledValue(updateRowSet, fieldArray);
            }
            this.getPageCache().put("isIgnoreChangeListener", "false");
        }
    }

    private void updateRowDataById(int rowIndex, Map<Long, Map<String, Object>> dataMap, Set<Integer> updateRowSet) {
        Long id = this.getLongValue("ecopentryid", rowIndex);
        Map<String, Object> newMap = dataMap.get(id);
        if (newMap != null) {
            this.setValue("billstatus", newMap.get("billstatus"), rowIndex);
            this.setValue("auditdate", newMap.get("auditdate"), rowIndex);
            this.setValue("ecotype", newMap.get("ecotype"), rowIndex);
            updateRowSet.add(rowIndex);
        }
    }

    private void updateSameRowDataByPentry(int[] selectRows, Long pentryId, String[] fieldArray, Object[] valueArray) {
        int rowCount = this.getModel().getEntryRowCount("entryentitys");
        this.getPageCache().put("isIgnoreChangeListener", "true");
        HashSet<Integer> updateRowSet = new HashSet<Integer>(16);
        if (rowCount <= 100 || selectRows.length < 2) {
            for (int i = 0; i < rowCount; ++i) {
                this.updateRowDataByPentryId(i, fieldArray, valueArray, pentryId, updateRowSet);
            }
        } else {
            for (int rowIndex : selectRows) {
                this.updateRowDataByPentryId(rowIndex, fieldArray, valueArray, pentryId, updateRowSet);
            }
        }
        this.refreshFiledValue(updateRowSet, fieldArray);
        this.getPageCache().put("isIgnoreChangeListener", "false");
    }

    private void updateSameRowDataBySelect(int[] selectRows, String[] fieldArray, Object[] valueArray, int exceptionRow) {
        int rowCount = this.getModel().getEntryRowCount("entryentitys");
        this.getPageCache().put("isIgnoreChangeListener", "true");
        HashSet<Integer> updateRowSet = new HashSet<Integer>(16);
        rowCount = selectRows.length;
        for (int i = 0; i < rowCount; ++i) {
            int rowIndex = selectRows[i];
            if (exceptionRow >= 0 && exceptionRow == rowIndex) continue;
            for (int j = 0; j < fieldArray.length; ++j) {
                this.setValue(fieldArray[j], valueArray[j], rowIndex);
                if ("acttime".equalsIgnoreCase(fieldArray[i])) {
                    this.updateOtherByActtime(valueArray[i], rowIndex);
                }
                updateRowSet.add(rowIndex);
            }
        }
        this.refreshFiledValue(updateRowSet, fieldArray);
        this.getPageCache().put("isIgnoreChangeListener", "false");
    }

    private void updateSameRowDataByGroupNo(String groupNo, Long pentryId, String[] fieldArray, Object[] valueArray, int exceptionRow) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        int rowCount = this.getModel().getEntryRowCount("entryentitys");
        this.getPageCache().put("isIgnoreChangeListener", "true");
        HashSet<Integer> updateRowSet = new HashSet<Integer>(16);
        model.beginInit();
        for (int i = 0; i < rowCount; ++i) {
            if (exceptionRow == i) continue;
            this.updateRowDataByGroupNo(i, fieldArray, valueArray, pentryId, groupNo, updateRowSet);
        }
        model.endInit();
        this.refreshFiledValue(updateRowSet, fieldArray);
        this.getPageCache().put("isIgnoreChangeListener", "false");
    }

    private void updateSameRowDataByReplaceGroupNo(String replaceGroupNo, Long pentryId, String[] fieldArray, Object[] valueArray, int exceptionRow) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        int rowCount = this.getModel().getEntryRowCount("entryentitys");
        this.getPageCache().put("isIgnoreChangeListener", "true");
        HashSet<Integer> updateRowSet = new HashSet<Integer>(16);
        model.beginInit();
        for (int i = 0; i < rowCount; ++i) {
            if (exceptionRow == i) continue;
            this.updateRowDataByReplaceGroupNo(i, fieldArray, valueArray, pentryId, replaceGroupNo, updateRowSet);
        }
        model.endInit();
        this.refreshFiledValue(updateRowSet, fieldArray);
        this.getPageCache().put("isIgnoreChangeListener", "false");
    }

    private void updateRowDataByPentryId(int rowIndex, String[] fieldArray, Object[] valueArray, Long pentryId, Set<Integer> updateRowSet) {
        Long currentPentryId = this.getLongValue("ecopentryid", rowIndex);
        if (currentPentryId.equals(pentryId)) {
            for (int i = 0; i < fieldArray.length; ++i) {
                this.setValue(fieldArray[i], valueArray[i], rowIndex);
                if ("acttime".equalsIgnoreCase(fieldArray[i])) {
                    this.updateOtherByActtime(valueArray[i], rowIndex);
                }
                updateRowSet.add(rowIndex);
            }
        }
    }

    private void updateRowDataByReplaceGroupNo(int rowIndex, String[] fieldArray, Object[] valueArray, Long pentryId, String replaceGroupNo, Set<Integer> updateRowSet) {
        Long currentPentryId = this.getLongValue("ecopentryid", rowIndex);
        String currentReplaceGroupNo = this.getStringValue("entryreplacegroup", rowIndex);
        if (currentPentryId.equals(pentryId) && currentReplaceGroupNo.equals(replaceGroupNo) && this.isUnEstimateStatus(rowIndex)) {
            for (int i = 0; i < fieldArray.length; ++i) {
                this.setValue(fieldArray[i], valueArray[i], rowIndex);
                updateRowSet.add(rowIndex);
            }
        }
    }

    private void updateRowDataByGroupNo(int rowIndex, String[] fieldArray, Object[] valueArray, Long pentryId, String groupNo, Set<Integer> updateRowSet) {
        if (this.isDisableGroupNo()) {
            return;
        }
        Long currentPentryId = this.getLongValue("ecopentryid", rowIndex);
        String currentGroupNo = this.getStringValue("entrygroupno", rowIndex);
        if (currentPentryId.equals(pentryId) && currentGroupNo.equals(groupNo) && this.isUnEstimateStatus(rowIndex)) {
            for (int i = 0; i < fieldArray.length; ++i) {
                this.setValue(fieldArray[i], valueArray[i], rowIndex);
                updateRowSet.add(rowIndex);
            }
        }
    }

    private void updateRowDataByRefNo(int rowIndex, String[] fieldArray, Object[] valueArray, String refNo, Set<Integer> updateRowSet) {
        String currentRefNo = this.getStringValue("entryrefno", rowIndex);
        String entrymode = this.getStringValue("entrymode", rowIndex);
        if (currentRefNo.equals(refNo) && this.isUnEstimateStatus(rowIndex) && ("A".equals(entrymode) || "E".equals(entrymode))) {
            for (int i = 0; i < fieldArray.length; ++i) {
                this.setValue(fieldArray[i], valueArray[i], rowIndex);
                updateRowSet.add(rowIndex);
            }
        }
    }

    private int saveData(Set<Long> idSet, int[] selectRows) {
        int selectSize = selectRows.length;
        HashSet<Long> ecoIdSet = new HashSet<Long>(selectSize);
        HashSet<Long> ecoBomentryIdSet = new HashSet<Long>(selectSize);
        HashSet<Long> ecoBomCopentryIdSet = new HashSet<Long>(selectSize);
        HashSet<Long> ecoRouteEntryIdSet = new HashSet<Long>(selectSize);
        HashSet<Long> auditEcoIdSet = new HashSet<Long>(selectSize);
        HashSet<Long> auditEcoBomentryIdSet = new HashSet<Long>(selectSize);
        HashSet<Long> auditEcoBomCopentryIdSet = new HashSet<Long>(selectSize);
        HashSet<Long> auditEcoRouteEntryIdSet = new HashSet<Long>(selectSize);
        HashMap<Long, Set<String>> ecoBomRefNoMap = new HashMap<Long, Set<String>>(16);
        this.initDealSaveData(selectRows, ecoIdSet, ecoBomentryIdSet, ecoBomCopentryIdSet, ecoRouteEntryIdSet, auditEcoIdSet, auditEcoBomentryIdSet, auditEcoBomCopentryIdSet, auditEcoRouteEntryIdSet);
        Map<Long, DynamicObject> keyMap = this.getTempKeyData(auditEcoIdSet, auditEcoBomentryIdSet, selectRows);
        Map<Long, DynamicObject> ecoBillDataMap = PlatFormQueryDataHelper.getEcoBillData(ecoIdSet);
        Map<Long, DynamicObject> ecoBomEntryDataMap = PlatFormQueryDataHelper.getEcoBomData(ecoBomentryIdSet);
        Map<Long, DynamicObject> ecoBomCopEntryDataMap = PlatFormQueryDataHelper.getEcoBomCopData(ecoBomCopentryIdSet);
        Map<Long, DynamicObject> ecoRouteEntryDataMap = PlatFormQueryDataHelper.getEcoRouteData(ecoRouteEntryIdSet);
        ArrayList updateEcoBillList = new ArrayList(selectSize);
        ArrayList updateEcoBomEntryList = new ArrayList(selectSize);
        ArrayList updateEcoBomCopEntryList = new ArrayList(selectSize);
        ArrayList updateEcoRouteEntryList = new ArrayList(selectSize);
        ArrayList ecoRecordLogList = new ArrayList(selectSize);
        HashMap ecoRecordLogMap = new HashMap(selectSize);
        boolean hasChange = false;
        ArrayList<String> updateExtDBList = new ArrayList<String>(16);
        HashSet<Long> updateEcoBomEntryIdSet = new HashSet<Long>(16);
        HashSet<Long> updateEcoBomCopEntryIdSet = new HashSet<Long>(16);
        HashSet<Long> updateEcoRouteEntryIdSet = new HashSet<Long>(16);
        HashSet<Long> allEcoBomEntryIdSet = new HashSet<Long>(16);
        HashSet<Long> allEcoRouteEntryIdSet = new HashSet<Long>(16);
        HashSet<Long> updateKeyEcoBomIdSet = new HashSet<Long>(16);
        StringBuilder acttimeAutoAdjustSb = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String logremark = ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u63a7\u5236\u5e73\u53f0-\u5b9e\u65bd\u8c03\u6574", (String)"EcoBomPlatFormQueryPlugin_47", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
        ArrayList<DynamicObject> updateUnGroupKeyList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> updateUnRefKeyList = new ArrayList<DynamicObject>(16);
        for (int i = 0; i < selectSize; ++i) {
            DynamicObject oldEcoType;
            int diffType;
            int rowIndex = selectRows[i];
            Long ecoId = this.getLongValue("ecoid", rowIndex);
            Long ecoPEntryId = this.getLongValue("ecopentryid", rowIndex);
            Long ecoBomEntryId = this.getLongValue("ecoentryid", rowIndex);
            Long ecoBomEntryAfterId = this.getLongValue("ecoentryafterid", rowIndex);
            String entryGroupno = this.getStringValue("entrygroupno", rowIndex);
            String entryRefno = this.getStringValue("entryrefno", rowIndex);
            boolean isRefKey = this.getBooleanValue("refkey", rowIndex);
            boolean isGroupKey = this.getBooleanValue("groupkey", rowIndex);
            String estimateStatus = this.getStringValue("estimatestatus", rowIndex);
            DynamicObject ecoType = this.getDynamicObjectValue("ecotype", rowIndex);
            Date transtartdate = this.getDateValue("transtartdate", rowIndex);
            Date acttime = this.getDateValue("acttime", rowIndex);
            Date pentryValidDate = this.getDateValue("pentryvaliddate", rowIndex);
            BigDecimal tranQty = this.getBigDecimalValue("tranqty", rowIndex);
            String extchangejson = this.getStringValue("extchangejson", rowIndex);
            String changeType = this.getStringValue("changetype", rowIndex);
            String productType = this.getStringValue("producttype", rowIndex);
            boolean isBomChange = this.isBomChange(rowIndex);
            boolean isRouteChange = this.isRouteChange(rowIndex);
            boolean isCopChange = this.isCopChange(productType);
            DynamicObject keyDy = keyMap.get(ecoBomEntryId);
            if (keyDy != null) {
                Long entryId = keyDy.getLong("entryid");
                if (entryId.equals(ecoBomEntryId)) {
                    keyDy.set("acttime", (Object)acttime);
                } else {
                    Date acttime2 = keyDy.getDate("acttime");
                    if (acttime2 != null) {
                        if (PlatformUtils.isDiffDate((Date)acttime2, (Date)acttime)) {
                            acttimeAutoAdjustSb.append(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u7684\u5b9e\u65bd\u65f6\u95f4\u201c%2$s\u201d\u4e0e\u4e3b\u952e\u884c\u7684\u5b9e\u65bd\u65f6\u95f4\u201c%3$s\u201d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8c03\u6574\u3002", (String)"EcoBomPlatFormQueryPlugin_48", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), rowIndex + 1, sdf.format(acttime), sdf.format(acttime2)));
                        }
                        this.setValue("acttime", acttime2, rowIndex);
                    }
                }
            }
            if ((diffType = this.isDiff(rowIndex, ecoBillDataMap, ecoBomEntryDataMap, ecoBomCopEntryDataMap, ecoRouteEntryDataMap)) == -1) {
                return -1;
            }
            if (diffType == 0 && StringUtils.isEmpty((String)extchangejson)) continue;
            this.genExtUpdateSql(extchangejson, "fentryid", "fentryid", ecoPEntryId, ecoBomEntryAfterId == null || ecoBomEntryAfterId.equals(0L) ? ecoBomEntryId : ecoBomEntryAfterId, updateExtDBList, changeType, productType);
            hasChange = true;
            DynamicObject ecoBill = ecoBillDataMap.get(ecoId);
            DynamicObject ecoBillEntry = this.getEcoBillEntryDynamicObject(ecoBill, ecoPEntryId);
            DynamicObject dynamicObject = oldEcoType = ecoBillEntry == null ? null : ecoBillEntry.getDynamicObject("ecotype");
            if (ecoBillEntry != null && (diffType == 1 || diffType == 3)) {
                ecoBillEntry.set("ecotype", (Object)ecoType);
                ecoBillEntry.set("pentryvaliddate", (Object)pentryValidDate);
                PlatformUtils.addList(updateEcoBillList, (DynamicObject)ecoBill);
            }
            if (diffType == 2 || diffType == 3 || !StringUtils.isEmpty((String)extchangejson)) {
                if (isBomChange) {
                    DynamicObject ecoBomEntry = this.getEntryFromMap(ecoBomEntryDataMap, ecoBomCopEntryDataMap, ecoBomEntryId, isCopChange);
                    Long ecoBomId = ecoBomEntry.getLong("ecobomid");
                    DynamicObject oldEcoBomEntry = null;
                    if (this.isAuditStatus(ecoBill, -1)) {
                        oldEcoBomEntry = PlatformUtils.copyDynamicObject((DynamicObject)ecoBomEntry);
                    }
                    if (!isCopChange && this.isEcoBomEntryReSetKeyDiff(ecoBomEntry, rowIndex)) {
                        updateKeyEcoBomIdSet.add(ecoBomId);
                        this.initEcoBomRefNoMap(ecoBomEntry, rowIndex, ecoBomRefNoMap);
                    }
                    boolean isReComputeKet = updateKeyEcoBomIdSet.contains(ecoBomId);
                    DynamicObject ecoBomEntryAfter = null;
                    String entrymode = ecoBomEntry.getString(this.getEntryModeField(isCopChange));
                    String estimateStatusNew = estimateStatus;
                    if (this.isAuditStatus(ecoBill, -1)) {
                        estimateStatusNew = EcoUtils.getEstimateStatusByEcoType((DynamicObject)ecoType, (String)estimateStatus);
                    }
                    if ("B".equals(entrymode) && (ecoBomEntryAfter = this.getEntryFromMap(ecoBomEntryDataMap, ecoBomCopEntryDataMap, ecoBomEntryAfterId, isCopChange)) != null) {
                        if (!isCopChange) {
                            ecoBomEntryAfter.set("entryvaliddate", (Object)acttime);
                            ecoBomEntryAfter.set("acttime", (Object)acttime);
                            ecoBomEntryAfter.set("estimatestatus", (Object)estimateStatusNew);
                            ecoBomEntryAfter.set("entryrefno", (Object)entryRefno);
                            ecoBomEntryAfter.set("entrygroupno", (Object)entryGroupno);
                            PlatformUtils.addList(updateEcoBomEntryList, (DynamicObject)ecoBomEntryAfter);
                        } else {
                            ecoBomEntryAfter.set("copentryvaliddate", (Object)acttime);
                            ecoBomEntryAfter.set("copacttime", (Object)acttime);
                            ecoBomEntryAfter.set("estimatestatus", (Object)estimateStatusNew);
                            PlatformUtils.addList(updateEcoBomCopEntryList, (DynamicObject)ecoBomEntryAfter);
                        }
                    }
                    if (!isCopChange) {
                        ecoBomEntry.set("entrygroupno", (Object)entryGroupno);
                        ecoBomEntry.set("groupkey", (Object)isGroupKey);
                        ecoBomEntry.set("transtartdate", (Object)transtartdate);
                        ecoBomEntry.set("acttime", (Object)acttime);
                        ecoBomEntry.set("tranqty", (Object)tranQty);
                        ecoBomEntry.set("entryrefno", (Object)entryRefno);
                        ecoBomEntry.set("refkey", (Object)isRefKey);
                        ecoBomEntry.set("estimatestatus", (Object)estimateStatusNew);
                        if (this.isAuditStatus(ecoBill, -1)) {
                            EcoUtils.setMinActtime((DynamicObject)ecoBomEntry);
                        }
                        PlatformUtils.addList(updateEcoBomEntryList, (DynamicObject)ecoBomEntry);
                    } else {
                        ecoBomEntry.set("copacttime", (Object)acttime);
                        ecoBomEntry.set("estimatestatus", (Object)estimateStatusNew);
                        PlatformUtils.addList(updateEcoBomCopEntryList, (DynamicObject)ecoBomEntry);
                    }
                    if (oldEcoBomEntry != null) {
                        AddEcoLogUtils.addEcoLog((DynamicObject)oldEcoBomEntry, (DynamicObject)ecoBomEntry, (DynamicObject)ecoBill, (DynamicObject)ecoBillEntry, ecoRecordLogMap, ecoRecordLogList, (String)logremark, (DynamicObject)oldEcoType, (DynamicObject)ecoType, this.genNewValueMap(keyDy, ecoBomEntryId, isReComputeKet, oldEcoBomEntry));
                    }
                    if (isGroupKey && !isReComputeKet) {
                        this.genUpdateGroupKeyEcoBomEntrys(ecoBomId, entryGroupno, ecoBomEntryId, updateUnGroupKeyList);
                    }
                    if (isRefKey && !isReComputeKet) {
                        this.genUpdateRefKeyEcoBomEntrys(entryRefno, ecoBomEntryId, updateUnRefKeyList);
                    }
                } else if (isRouteChange) {
                    DynamicObject ecoRouteEntry = ecoRouteEntryDataMap.get(ecoBomEntryId);
                    DynamicObject oldEcoRouteEntry = null;
                    if (this.isAuditStatus(ecoBill, -1)) {
                        oldEcoRouteEntry = PlatformUtils.copyDynamicObject((DynamicObject)ecoRouteEntry);
                    }
                    DynamicObject ecoRouteEntryAfter = null;
                    String entrymode = ecoRouteEntry.getString("entrymode");
                    String estimateStatusNew = estimateStatus;
                    if (this.isAuditStatus(ecoBill, -1)) {
                        estimateStatusNew = EcoUtils.getEstimateStatusByEcoType((DynamicObject)ecoType, (String)estimateStatus);
                    }
                    if ("B".equals(entrymode) && (ecoRouteEntryAfter = ecoRouteEntryDataMap.get(ecoBomEntryAfterId)) != null) {
                        ecoRouteEntryAfter.set("entryvaliddate", (Object)acttime);
                        ecoRouteEntryAfter.set("acttime", (Object)acttime);
                        ecoRouteEntryAfter.set("estimatestatus", (Object)estimateStatusNew);
                        PlatformUtils.addList(updateEcoRouteEntryList, (DynamicObject)ecoRouteEntryAfter);
                    }
                    ecoRouteEntry.set("acttime", (Object)acttime);
                    ecoRouteEntry.set("estimatestatus", (Object)estimateStatusNew);
                    if (this.isAuditStatus(ecoBill, -1)) {
                        EcoUtils.setMinActtime((DynamicObject)ecoRouteEntry);
                    }
                    PlatformUtils.addList(updateEcoRouteEntryList, (DynamicObject)ecoRouteEntry);
                    if (oldEcoRouteEntry != null) {
                        AddEcoLogUtils.addEcoLog((DynamicObject)oldEcoRouteEntry, (DynamicObject)ecoRouteEntry, (DynamicObject)ecoBill, (DynamicObject)ecoBillEntry, ecoRecordLogMap, ecoRecordLogList, (String)logremark, (DynamicObject)oldEcoType, (DynamicObject)ecoType, null);
                    }
                }
            }
            if (!this.isAuditStatus(ecoBill, -1)) continue;
            if (isBomChange) {
                if (isCopChange) {
                    updateEcoBomCopEntryIdSet.add(ecoBomEntryId);
                    continue;
                }
                updateEcoBomEntryIdSet.add(ecoBomEntryId);
                if (ecoType == null || !ecoType.getBoolean("autoupdateorder")) continue;
                allEcoBomEntryIdSet.add(ecoBomEntryId);
                if (PlatformUtils.isNullLong((Long)ecoBomEntryAfterId)) continue;
                allEcoBomEntryIdSet.add(ecoBomEntryAfterId);
                continue;
            }
            if (!isRouteChange) continue;
            updateEcoRouteEntryIdSet.add(ecoBomEntryId);
            if (ecoType == null || !ecoType.getBoolean("autoupdateorder")) continue;
            allEcoRouteEntryIdSet.add(ecoBomEntryId);
            if (PlatformUtils.isNullLong((Long)ecoBomEntryAfterId)) continue;
            allEcoRouteEntryIdSet.add(ecoBomEntryAfterId);
        }
        if (hasChange) {
            Map xMap;
            String errorMsg;
            try (TXHandle required = TX.requiresNew((String)"mmc-pdm-EcoBomPlatFormQueryPlugin-saveData");){
                try {
                    if (!updateEcoBillList.isEmpty()) {
                        SaveServiceHelper.update((DynamicObject[])updateEcoBillList.toArray(new DynamicObject[updateEcoBillList.size()]), (OperateOption)OperateOption.create());
                    }
                    if (!updateEcoBomEntryList.isEmpty()) {
                        SaveServiceHelper.update((DynamicObject[])updateEcoBomEntryList.toArray(new DynamicObject[updateEcoBomEntryList.size()]), (OperateOption)OperateOption.create());
                    }
                    if (!updateEcoBomCopEntryList.isEmpty()) {
                        SaveServiceHelper.update((DynamicObject[])updateEcoBomCopEntryList.toArray(new DynamicObject[updateEcoBomCopEntryList.size()]), (OperateOption)OperateOption.create());
                    }
                    if (!updateEcoRouteEntryList.isEmpty()) {
                        SaveServiceHelper.update((DynamicObject[])updateEcoRouteEntryList.toArray(new DynamicObject[updateEcoRouteEntryList.size()]), (OperateOption)OperateOption.create());
                    }
                    if (!ecoRecordLogList.isEmpty()) {
                        SaveServiceHelper.save((DynamicObject[])ecoRecordLogList.toArray(new DynamicObject[ecoRecordLogList.size()]), (OperateOption)OperateOption.create());
                    }
                    if (!updateExtDBList.isEmpty()) {
                        for (String sqls : updateExtDBList) {
                            this.execSql(sqls);
                        }
                    }
                    this.saveUnKeyAndAddLogs(updateUnGroupKeyList, "groupkey");
                    this.saveUnKeyAndAddLogs(updateUnGroupKeyList, "refkey");
                    if (!updateKeyEcoBomIdSet.isEmpty()) {
                        EcoUtils.updateEcoBomKeyByEcoBomId(updateKeyEcoBomIdSet, ecoBomRefNoMap, (String)"updatebom");
                    }
                    String fromType = "updatebom";
                    if (!updateEcoBomEntryIdSet.isEmpty()) {
                        List othersEcoBomEntryList = EcoUtils.updateRefDataActtime(updateEcoBomEntryIdSet, (String)fromType);
                        EcoUtils.updateMftBomData((List)othersEcoBomEntryList, (String)fromType);
                    }
                    if (!updateEcoBomCopEntryIdSet.isEmpty()) {
                        List othersEcoBomCopEntryList = EcoCopUtils.updateRefDataActtime(updateEcoBomCopEntryIdSet, (String)fromType);
                        EcoCopUtils.updateMftBomData((List)othersEcoBomCopEntryList, (String)fromType);
                    }
                    if (!updateEcoRouteEntryIdSet.isEmpty()) {
                        List othersEcoRouteEntryList = EcoRouteUtils.updateRefDataActtime(updateEcoRouteEntryIdSet, (String)fromType);
                        EcoRouteUtils.updateRouteEntryData((List)othersEcoRouteEntryList, (String)fromType);
                    }
                }
                catch (Exception e) {
                    required.markRollback();
                    throw e;
                }
            }
            if (!allEcoBomEntryIdSet.isEmpty()) {
                errorMsg = "";
                try {
                    xMap = GetEcoEffectOrderBusiness.getInstance().createStockChangeByKey(allEcoBomEntryIdSet, true);
                    errorMsg = xMap.get("errormsg") == null ? "" : xMap.get("errormsg").toString();
                }
                catch (Exception e1) {
                    log.error((Throwable)e1);
                    errorMsg = PlatformUtils.getSimpleExceptionString((Exception)e1);
                }
                if (!StringUtils.isEmpty((String)errorMsg)) {
                    this.getView().showTipNotification(errorMsg);
                }
            }
            if (!allEcoRouteEntryIdSet.isEmpty()) {
                errorMsg = "";
                try {
                    xMap = GetEcoEffectManuftechBusiness.getInstance().createManftechChangeByKey(allEcoRouteEntryIdSet, true);
                    errorMsg = xMap.get("errormsg") == null ? "" : xMap.get("errormsg").toString();
                }
                catch (Exception e1) {
                    log.error((Throwable)e1);
                    errorMsg = PlatformUtils.getSimpleExceptionString((Exception)e1);
                }
                if (!StringUtils.isEmpty((String)errorMsg)) {
                    this.getView().showTipNotification(errorMsg);
                }
            }
        }
        if (acttimeAutoAdjustSb.length() > 1) {
            this.getView().showTipNotification(acttimeAutoAdjustSb.toString());
        }
        return hasChange ? 2 : 1;
    }

    private void initDealSaveData(int[] selectRows, Set<Long> ecoIdSet, Set<Long> ecoBomentryIdSet, Set<Long> ecoBomCopentryIdSet, Set<Long> ecoRouteEntryIdSet, Set<Long> auditEcoIdSet, Set<Long> auditEcoBomentryIdSet, Set<Long> auditEcoBomCopentryIdSet, Set<Long> auditEcoRouteEntryIdSet) {
        for (int rowIndex : selectRows) {
            Long ecoId = this.getLongValue("ecoid", rowIndex);
            ecoIdSet.add(ecoId);
            boolean isBomChange = this.isBomChange(rowIndex);
            boolean isRouteChange = this.isRouteChange(rowIndex);
            boolean isCopChange = this.isCopChange(rowIndex);
            Long ecoBomEntryId = this.getLongValue("ecoentryid", rowIndex);
            Long ecoBomEntryAfterId = this.getLongValue("ecoentryafterid", rowIndex);
            if (isBomChange) {
                if (!isCopChange) {
                    this.addToSet(ecoBomentryIdSet, ecoBomEntryId, ecoBomEntryAfterId);
                } else {
                    this.addToSet(ecoBomCopentryIdSet, ecoBomEntryId, ecoBomEntryAfterId);
                }
            } else if (isRouteChange) {
                this.addToSet(ecoRouteEntryIdSet, ecoBomEntryId, ecoBomEntryAfterId);
            }
            if (isBomChange && !isCopChange) {
                boolean isEditGroupKey = this.isEditGroupKey(rowIndex);
                boolean isEditRefKey = this.isEditRefKey(rowIndex);
                if (!isEditRefKey) {
                    String refNo = this.getStringValue("entryrefno", rowIndex);
                    boolean isRefKey = this.getBooleanValue("refkey", rowIndex);
                    if (isRefKey && PlatformUtils.isNullString((String)refNo)) {
                        this.setValue("refkey", Boolean.FALSE, rowIndex);
                    }
                }
                if (!isEditGroupKey) {
                    String groupNo = this.getStringValue("entrygroupno", rowIndex);
                    boolean isGroupGKey = this.getBooleanValue("groupkey", rowIndex);
                    if (isGroupGKey && PlatformUtils.isNullString((String)groupNo)) {
                        this.setValue("groupkey", Boolean.FALSE, rowIndex);
                    }
                }
            }
            if (!this.isAuditStatus(null, rowIndex)) continue;
            auditEcoIdSet.add(ecoId);
            if (isBomChange) {
                if (!isCopChange) {
                    this.addToSet(auditEcoBomentryIdSet, ecoBomEntryId, ecoBomEntryAfterId);
                    continue;
                }
                this.addToSet(auditEcoBomCopentryIdSet, ecoBomEntryId, ecoBomEntryAfterId);
                continue;
            }
            if (!isRouteChange) continue;
            this.addToSet(auditEcoRouteEntryIdSet, ecoBomEntryId, ecoBomEntryAfterId);
        }
    }

    private String getNoDataMsgA(int rowIndex) {
        return String.format(ResManager.loadKDString((String)"\u7b2c\u201c%s\u201d\u884c\uff0c\u65e0\u6cd5\u4ece\u6570\u636e\u5e93\u627e\u5230\u5bf9\u5e94\u7684\u53d8\u66f4\u5355\u5206\u5f55\u4fe1\u606f\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\u3002", (String)"EcoBomPlatFormQueryPlugin_49", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), rowIndex + 1);
    }

    private String getNoDataMsgB(int rowIndex) {
        return String.format(ResManager.loadKDString((String)"\u7b2c\u201c%s\u201d\u884c\uff0c\u65e0\u6cd5\u4ece\u6570\u636e\u5e93\u4e2d\u627e\u5230\u5bf9\u5e94\u53d8\u66f4\u5355\u7684ECOBom\u4fe1\u606f\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\u3002", (String)"EcoBomPlatFormQueryPlugin_51", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), rowIndex + 1);
    }

    private String getNoDataMsgC(int rowIndex) {
        return String.format(ResManager.loadKDString((String)"\u7b2c\u201c%s\u201d\u884c\uff0c\u65e0\u6cd5\u4ece\u6570\u636e\u5e93\u4e2d\u627e\u5230\u5bf9\u5e94\u53d8\u66f4\u5355\u7684\u5de5\u827a\u8def\u7ebf\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"EcoBomPlatFormQueryPlugin_81", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), rowIndex + 1);
    }

    private String getNoDataMsgD(int rowIndex) {
        return String.format(ResManager.loadKDString((String)"\u7b2c\u201c%s\u201d\u884c\uff0c\u53d8\u66f4\u5355\u7684\u5355\u636e\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\u3002", (String)"EcoBomPlatFormQueryPlugin_50", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), rowIndex + 1);
    }

    private int isDiff(int rowIndex, Map<Long, DynamicObject> ecoBillDataMap, Map<Long, DynamicObject> ecoBomEntryDataMap, Map<Long, DynamicObject> ecoBomCopEntryDataMap, Map<Long, DynamicObject> ecoRouteEntryDataMap) {
        Long ecoId = this.getLongValue("ecoid", rowIndex);
        Long ecoPEntryId = this.getLongValue("ecopentryid", rowIndex);
        Long ecoBomEntryId = this.getLongValue("ecoentryid", rowIndex);
        Long ecoBomEntryAfterId = this.getLongValue("ecoentryafterid", rowIndex);
        String billStatus = this.getStringValue("billstatus", rowIndex);
        DynamicObject ecoBill = ecoBillDataMap.get(ecoId);
        if (ecoBill == null) {
            return this.returnAndShowMessage(-1, this.getNoDataMsgA(rowIndex));
        }
        DynamicObject ecoBillPEntry = this.getEcoBillEntryDynamicObject(ecoBill, ecoPEntryId);
        if (ecoBillPEntry == null) {
            return this.returnAndShowMessage(-1, this.getNoDataMsgA(rowIndex));
        }
        String billStatusOld = ecoBill.getString("billStatus");
        if (!billStatusOld.equals(billStatus)) {
            return this.returnAndShowMessage(-1, this.getNoDataMsgD(rowIndex));
        }
        boolean isCopChange = this.isCopChange(rowIndex);
        boolean isPentryDiff = this.isEcnPentryDiff(ecoBillPEntry, rowIndex);
        if (this.isBomChange(rowIndex)) {
            DynamicObject ecoBomEntry = this.getEntryFromMap(ecoBomEntryDataMap, ecoBomCopEntryDataMap, ecoBomEntryId, isCopChange);
            if (ecoBomEntry == null) {
                return this.returnAndShowMessage(-1, this.getNoDataMsgB(rowIndex));
            }
            String entrymodeField = this.getEntryModeField(isCopChange);
            DynamicObject ecoBomEntryAfter = null;
            if ("B".equals(ecoBomEntry.getString(entrymodeField)) && (ecoBomEntryAfter = this.getEntryFromMap(ecoBomEntryDataMap, ecoBomCopEntryDataMap, ecoBomEntryAfterId, isCopChange)) == null) {
                return this.returnAndShowMessage(-1, this.getNoDataMsgB(rowIndex));
            }
            if (!isCopChange) {
                if (this.isEcoBomEntryDiff(ecoBomEntry, rowIndex)) {
                    return isPentryDiff ? 3 : 2;
                }
                return isPentryDiff ? 1 : 0;
            }
            if (this.isEcoBomCopEntryDiff(ecoBomEntry, rowIndex)) {
                return isPentryDiff ? 3 : 2;
            }
            return isPentryDiff ? 1 : 0;
        }
        if (this.isRouteChange(rowIndex)) {
            DynamicObject ecoRouteEntry = ecoRouteEntryDataMap.get(ecoBomEntryId);
            if (ecoRouteEntry == null) {
                return this.returnAndShowMessage(-1, this.getNoDataMsgC(rowIndex));
            }
            DynamicObject ecoRouteEntryAfter = null;
            if ("B".equals(ecoRouteEntry.getString("entrymode")) && (ecoRouteEntryAfter = ecoRouteEntryDataMap.get(ecoBomEntryAfterId)) == null) {
                return this.returnAndShowMessage(-1, this.getNoDataMsgC(rowIndex));
            }
            if (this.isEcoRouteEntryDiff(ecoRouteEntry, rowIndex)) {
                return isPentryDiff ? 3 : 2;
            }
            return isPentryDiff ? 1 : 0;
        }
        return 0;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        IPageCache pc = this.getPageCache();
        String callBackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        if ("ecotypechange".equalsIgnoreCase(callBackId)) {
            long ecoTyeNew;
            String rowStr = pc.get("ecotype-row");
            String ecotypeStr = pc.get("ecotype");
            String ecotypeNewStr = pc.get("ecotypenew");
            int rowIndex = StringUtils.isEmpty((String)rowStr) ? -1 : Integer.parseInt(rowStr);
            long ecoType = StringUtils.isEmpty((String)ecotypeStr) ? -1L : Long.parseLong(ecotypeStr);
            long l = ecoTyeNew = StringUtils.isEmpty((String)ecotypeNewStr) ? -1L : Long.parseLong(ecotypeNewStr);
            if (rowIndex < 0) {
                return;
            }
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentitys");
            int[] selectRows = entryGrid.getSelectRows();
            Long ecopentryid = this.getLongValue("ecopentryid", rowIndex);
            String[] filedArray = new String[]{"ecotype"};
            Object[] valueArray = new Object[]{ecoType};
            if (result != MessageBoxResult.No) {
                Date pentryvaliddate = this.getDateValue("pentryvaliddate", rowIndex);
                filedArray = new String[]{"ecotype", "acttime"};
                valueArray = new Object[]{ecoTyeNew, pentryvaliddate};
            }
            this.updateSameRowDataByPentry(selectRows, ecopentryid, filedArray, valueArray);
            this.updateSameRowDataBySelect(selectRows, filedArray, valueArray, rowIndex);
        } else if ("autoAdjustActTime".equalsIgnoreCase(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                String opKey = this.getPageCache().get("autoAdjustopKey");
                if (StringUtils.isEmpty((String)opKey)) {
                    return;
                }
                if ("save".equalsIgnoreCase(opKey)) {
                    opKey = "saveeco";
                } else if ("updatebom".equalsIgnoreCase(opKey)) {
                    opKey = "updatebomdata";
                }
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("afterconfirm", "true");
                this.getView().invokeOperation(opKey, operateOption);
            }
        } else if ("handestimateend".equals(callBackId)) {
            OperateOption operateOption = OperateOption.create();
            if (MessageBoxResult.No.equals((Object)result)) {
                operateOption.setVariableValue("afterconfirm_handestimateend", "no");
            } else {
                operateOption.setVariableValue("afterconfirm_handestimateend", "yes");
            }
            this.getView().invokeOperation("handestimateend", operateOption);
        } else if ("pentryvaliddate".equalsIgnoreCase(callBackId)) {
            String rowStr = pc.get("entryvaliddate-row");
            String pentryvaliddates = pc.get("entryvaliddate");
            String oldpentryvaliddates = pc.get("oldentryvaliddate");
            int rowIndex = StringUtils.isEmpty((String)rowStr) ? -1 : Integer.parseInt(rowStr);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date pentryValidDate = null;
            Date oldPentryValidDate = null;
            try {
                if (!StringUtils.isEmpty((String)oldpentryvaliddates)) {
                    oldPentryValidDate = sdf.parse(oldpentryvaliddates);
                }
                if (!StringUtils.isEmpty((String)pentryvaliddates)) {
                    pentryValidDate = sdf.parse(pentryvaliddates);
                }
            }
            catch (ParseException e1) {
                log.error((Throwable)e1);
            }
            if (MessageBoxResult.No.equals((Object)result)) {
                this.getPageCache().put("isIgnoreChangeListener", "true");
                this.setValue("pentryvaliddate", oldPentryValidDate, rowIndex);
                this.getPageCache().put("isIgnoreChangeListener", "false");
            } else {
                this.pentryValidDateChangeUpdate(pentryValidDate, rowIndex);
            }
        }
    }

    private boolean verifySelectMulChangeType(int[] selectRows) {
        HashSet<String> changeTypeSet = new HashSet<String>(4);
        for (int i = 0; i < selectRows.length; ++i) {
            int rowIndex = selectRows[i];
            int realSeq = rowIndex + 1;
            changeTypeSet.add(this.getStringValue("changetype", rowIndex));
            if (changeTypeSet.size() <= 1) continue;
            String message = String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u5355\u636e\u4e0e\u524d\u9762\u6240\u9009\u7684\u5355\u636e\u7684\u53d8\u66f4\u5bf9\u8c61\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"EcoBomPlatFormQueryPlugin_80", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), realSeq);
            this.getView().showTipNotification(message);
            return false;
        }
        return true;
    }

    private boolean verifyUpdateBomData(Set<Long> idSet, int[] selectRows) {
        StringBuilder message = new StringBuilder();
        for (int i = 0; i < selectRows.length; ++i) {
            int rowIndex = selectRows[i];
            int realSeq = rowIndex + 1;
            String ecnBillNo = this.getStringValue("billno", rowIndex);
            if (!this.isAuditStatus(null, rowIndex)) {
                message.append(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u5355\u636e\u201c%2$s\u201d\u4e0d\u662f\u5ba1\u6838\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u5b9e\u65bd\u8c03\u6574\u64cd\u4f5c\u3002", (String)"EcoBomPlatFormQueryPlugin_53", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), realSeq, ecnBillNo));
                continue;
            }
            String mustInput = this.checkMustInput(rowIndex);
            if (mustInput.length() > 0) {
                message.append(mustInput);
                continue;
            }
            String dataValide = this.checkDataValidate(rowIndex);
            if (dataValide.length() <= 0) continue;
            message.append(dataValide);
        }
        if (message.length() > 0) {
            this.getView().showTipNotification(message.toString());
            return false;
        }
        return true;
    }

    private boolean verifyUpdateOrderData(Set<Long> idSet, int[] selectRows) {
        if (!this.verifySelectMulChangeType(selectRows)) {
            return false;
        }
        StringBuilder message = new StringBuilder();
        HashSet<Long> orgIdSet = new HashSet<Long>(16);
        for (int i = 0; i < selectRows.length; ++i) {
            int rowIndex = selectRows[i];
            int realSeq = rowIndex + 1;
            String ecnBillNo = this.getStringValue("billno", rowIndex);
            Long orgId = this.getOrgId(rowIndex);
            orgIdSet.add(orgId);
            if (orgIdSet.size() <= 1) continue;
            message.append(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u5355\u636e\u201c%2$s\u201d\u7684\u53d8\u66f4\u7ec4\u7ec7\u4e0e\u5176\u5b83\u884c\u7684\u53d8\u66f4\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"EcoBomPlatFormQueryPlugin_54", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), realSeq, ecnBillNo));
        }
        if (message.length() > 0) {
            this.getView().showTipNotification(message.toString());
            return false;
        }
        return true;
    }

    private int verifyHandEstimateEnd(Set<Long> idSet, int[] selectRows) {
        DynamicObject[] ecoBill;
        Set allEcoBomEntryIdSet;
        DynamicObject[] dycoll;
        StringBuilder message = new StringBuilder();
        HashMap<String, String> groupNoRefMap = new HashMap<String, String>(16);
        HashSet<Long> ecoBomEntryIdSet = new HashSet<Long>(16);
        String chkChangeMsg = this.checkDataChange(selectRows);
        if (!StringUtils.isEmpty((String)chkChangeMsg)) {
            this.getView().showTipNotification(chkChangeMsg);
            return 0;
        }
        for (int i = 0; i < selectRows.length; ++i) {
            int rowIndex = selectRows[i];
            int realSeq = rowIndex + 1;
            String ecnBillNo = this.getStringValue("billno", rowIndex);
            if (this.isRouteChange(rowIndex)) {
                message.append(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u5355\u636e\u201c%2$s\u201d\u7684\u53d8\u66f4\u5bf9\u8c61\u4e3a\u5de5\u827a\u8def\u7ebf\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u624b\u5de5\u8bc4\u4f30\u5b8c\u6210\u64cd\u4f5c\u3002", (String)"EcoBomPlatFormQueryPlugin_83", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), realSeq, ecnBillNo));
                continue;
            }
            if (this.isCopChange(rowIndex)) {
                message.append(String.format(ResManager.loadKDString((String)"\u7b2c[%1$s]\u884c\u5355\u636e[%2$s]\u4e3a\u8054\u526f\u4ea7\u54c1\u53d8\u66f4\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u624b\u5de5\u8bc4\u4f30\u5b8c\u6210\u64cd\u4f5c\u3002", (String)"EcoBomPlatFormQueryPlugin_84", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), realSeq, ecnBillNo));
                continue;
            }
            if (!this.isAuditStatus(null, rowIndex)) {
                message.append(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u5355\u636e\u201c%2$s\u201d\u4e0d\u662f\u5ba1\u6838\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u624b\u5de5\u8bc4\u4f30\u5b8c\u6210\u64cd\u4f5c\u3002", (String)"EcoBomPlatFormQueryPlugin_55", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), realSeq, ecnBillNo));
                continue;
            }
            if (this.isEstimateStatusC(rowIndex)) {
                message.append(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u5355\u636e\u201c%2$s\u201d\u5df2\u5b8c\u6210\u8bc4\u4f30\uff0c\u65e0\u6cd5\u624b\u52a8\u5b8c\u6210\u8bc4\u4f30\u64cd\u4f5c\u3002", (String)"EcoBomPlatFormQueryPlugin_56", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), realSeq, ecnBillNo));
                continue;
            }
            Long ecoBomId = this.getLongValue("ecobomid", rowIndex);
            String groupNo = this.getStringValue("entrygroupno", rowIndex);
            String refNo = this.getStringValue("entryrefno", rowIndex);
            ecoBomEntryIdSet.add(this.getLongValue("ecoentryid", rowIndex));
            if (PlatformUtils.isNullString((String)groupNo) || PlatformUtils.isNullString((String)refNo)) continue;
            String groupKeyString = PlatformUtils.getUnionString((Object)ecoBomId, (Object)groupNo);
            String oldRefNo = (String)groupNoRefMap.get(groupKeyString);
            if (PlatformUtils.isNullString((String)oldRefNo)) {
                groupNoRefMap.put(groupKeyString, refNo);
                continue;
            }
            if (oldRefNo.equals(refNo)) continue;
            message.append(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u6210\u7ec4\u53f7\u201c%2$s\u201d\u5173\u8054\u5b9e\u65bd\u53f7\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u624b\u52a8\u5b8c\u6210\u8bc4\u4f30\u3002", (String)"EcoBomPlatFormQueryPlugin_57", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), realSeq, groupNo));
        }
        if (message.length() > 0) {
            this.getView().showTipNotification(message.toString());
            return 0;
        }
        int updateSize = 0;
        HashSet<Long> ecoBomIdSet = new HashSet<Long>(16);
        if (!ecoBomEntryIdSet.isEmpty() && (dycoll = EcoUtils.getAllEcoBomEntryDynamicObject((Set)(allEcoBomEntryIdSet = EcoUtils.getAllEcoBomEntryIdSet(ecoBomEntryIdSet)))) != null && dycoll.length > 0) {
            for (DynamicObject dy : dycoll) {
                if ("C".equals(dy.getString("estimatestatus"))) continue;
                Long ecoBomId = dy.getLong("ecobomid");
                ecoBomIdSet.add(ecoBomId);
                String groupNo = dy.getString("entrygroupno");
                String refNo = dy.getString("entryrefno");
                if (!PlatformUtils.isNullString((String)groupNo) && !PlatformUtils.isNullString((String)refNo)) {
                    String groupKeyString = PlatformUtils.getUnionString((Object)ecoBomId, (Object)groupNo);
                    String oldRefNo = (String)groupNoRefMap.get(groupKeyString);
                    if (PlatformUtils.isNullString((String)oldRefNo)) {
                        groupNoRefMap.put(groupKeyString, refNo);
                    } else if (!oldRefNo.equals(refNo)) {
                        message.append(String.format(ResManager.loadKDString((String)"\u6210\u7ec4\u53f7\u201c%1$s\u201d\u4e0e\u5173\u8054\u5b9e\u65bd\u53f7\u201c%2$s\u201d\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u624b\u52a8\u5b8c\u6210\u8bc4\u4f30\u3002", (String)"EcoBomPlatFormQueryPlugin_58", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), groupNo, oldRefNo + " " + refNo));
                        continue;
                    }
                }
                ++updateSize;
            }
        }
        if (!ecoBomIdSet.isEmpty() && (ecoBill = EcoUtils.getEcoChangeBillData(ecoBomIdSet)) != null && ecoBill.length > 0) {
            int allSize = ecoBill.length;
            HashSet<Long> repeatIdSet = new HashSet<Long>(16);
            for (int i = 0; i < allSize; ++i) {
                DynamicObject dy;
                dy = ecoBill[i];
                if ("C".equals(dy.getString("billstatus")) || !repeatIdSet.add(dy.getLong("id"))) continue;
                message.append(String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355\u201c%1$s\u201d\u7684\u5355\u636e\u72b6\u6001\u4e0d\u7b49\u4e8e\u201c\u5df2\u5ba1\u6838\u201d\uff0c\u65e0\u6cd5\u8fdb\u884c\u201c\u624b\u5de5\u8bc4\u4f30\u5b8c\u6210\u201d\u3002", (String)"EcoBomPlatFormQueryPlugin_59", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), dy.getString("billno")));
            }
        }
        if (message.length() > 0) {
            this.getView().showTipNotification(message.toString());
            return 0;
        }
        return updateSize;
    }

    private void doBeforeUpdateOrderData(BeforeDoOperationEventArgs e) {
        Set<Long> pdmBomEcoIds = this.getSelectBillIdSet();
        if (pdmBomEcoIds == null || pdmBomEcoIds.isEmpty()) {
            e.setCancel(true);
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentitys");
        int[] selectRows = entryGrid.getSelectRows();
        if (!this.verifyPermissionData("updateorder", selectRows)) {
            e.setCancel(true);
            return;
        }
        if (!this.verifyUpdateOrderData(pdmBomEcoIds, selectRows)) {
            e.setCancel(true);
        }
    }

    private void doAfterUpdateOrderData(String operateKey) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentitys");
        int[] selectRows = entryGrid.getSelectRows();
        Set<Long> entrys = this.genEcoBomEntryIdSet(selectRows, this.genBomEntryProductType());
        Set<Long> copentrys = this.genEcoBomEntryIdSet(selectRows, this.genBomCopEntryProductType());
        Set<Long> pentrys = this.getIdSet(selectRows, "ecopentryid");
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("entrys", entrys);
        map.put("copentrys", copentrys);
        map.put("pentrys", pentrys);
        map.put("orgid", this.getOrgId(selectRows[0]));
        map.put("changetype", this.getChangeType(selectRows[0]));
        this.showEffectOrderFrom(map);
    }

    private void showEffectOrderFrom(Map<String, Object> map) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParams(map);
        showParameter.setFormId("pdm_ecoplatform_order");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(showParameter);
    }

    private void updateKeyUnSelectByRefNo(int[] selectRows, String refNo, String[] fieldArray, Object[] valueArray, int exceptionRow) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        int rowCount = this.getModel().getEntryRowCount("entryentitys");
        this.getPageCache().put("isIgnoreChangeListener", "true");
        HashSet<Integer> updateRowSet = new HashSet<Integer>(16);
        model.beginInit();
        if (rowCount <= 100 || selectRows.length < 2) {
            for (int i = 0; i < rowCount; ++i) {
                if (exceptionRow == i) continue;
                this.updateRowDataByRefNo(i, fieldArray, valueArray, refNo, updateRowSet);
            }
        } else {
            for (int rowIndex : selectRows) {
                if (exceptionRow == rowIndex) continue;
                this.updateRowDataByRefNo(rowIndex, fieldArray, valueArray, refNo, updateRowSet);
            }
        }
        model.endInit();
        this.refreshFiledValue(updateRowSet, fieldArray);
        this.getPageCache().put("isIgnoreChangeListener", "false");
    }

    private int handEstimateEnd(Set<Long> idSet, int[] selectRows) {
        block24: {
            HashSet<Long> ecoBomEntryIdSet = new HashSet<Long>(16);
            for (int i = 0; i < selectRows.length; ++i) {
                int rowIndex = selectRows[i];
                if (this.isCopChange(rowIndex) || this.isRouteChange(rowIndex)) continue;
                ecoBomEntryIdSet.add(this.getLongValue("ecoentryid", rowIndex));
            }
            if (ecoBomEntryIdSet.isEmpty()) {
                return 2;
            }
            String execname = ResManager.loadKDString((String)"\u624b\u5de5\u8bc4\u4f30\u5b8c\u6210", (String)"EcoBomPlatFormQueryPlugin_61", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
            String logremark = ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u63a7\u5236\u5e73\u53f0\u201c\u624b\u5de5\u8bc4\u4f30\u5b8c\u6210\u201d\u3002", (String)"EcoBomPlatFormQueryPlugin_62", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
            Set allEcoBomEntryIdSet = EcoUtils.getAllEcoBomEntryIdSet(ecoBomEntryIdSet);
            DynamicObject[] dycoll = EcoUtils.getAllEcoBomEntryDynamicObject((Set)allEcoBomEntryIdSet);
            if (dycoll == null || dycoll.length < 1) {
                return 2;
            }
            int allSize = dycoll.length;
            ArrayList<DynamicObject> updateDyList = new ArrayList<DynamicObject>(allSize);
            DynamicObject ecoBill = null;
            HashMap ecoRecordLogMap = new HashMap(16);
            ArrayList ecoRecordLogList = new ArrayList(16);
            for (int i = 0; i < allSize; ++i) {
                DynamicObject dy = dycoll[i];
                String estimateStatus = dy.getString("estimatestatus");
                if ("C".equals(estimateStatus)) continue;
                Long ecoBomId = dy.getLong("ecobomid");
                HashSet<Long> ecoBomIdSet = new HashSet<Long>(16);
                ecoBomIdSet.add(ecoBomId);
                DynamicObject[] ecoBills = EcoUtils.getEcoChangeBillData(ecoBomIdSet);
                ecoBill = ecoBills[0];
                DynamicObject ecoPentry = EcoUtils.getEcoPEntry((DynamicObject)ecoBill, (Long)ecoBomId);
                if (ecoPentry == null) continue;
                dy.set("estimatestatus", (Object)"C");
                updateDyList.add(dy);
                AddEcoLogUtils.addEcoLogByActtime((DynamicObject)dy, (DynamicObject)ecoBill, (DynamicObject)ecoPentry, ecoRecordLogMap, ecoRecordLogList, (String)logremark, (Date)dy.getDate("acttime"), (String)estimateStatus);
            }
            try (TXHandle required = TX.requiresNew((String)"mmc-pdm-EcoBomPlatFormQueryPlugin-handEstimateEnd");){
                try {
                    if (!updateDyList.isEmpty()) {
                        List pointList = EcoUtils.updateContinuityPointEcnData(updateDyList, (String)"handEstimateEnd", ecoBomEntryIdSet);
                        SaveServiceHelper.update((DynamicObject[])updateDyList.toArray(new DynamicObject[updateDyList.size()]), (OperateOption)OperateOption.create());
                        if (!PlatformUtils.isNullList((List)pointList)) {
                            EcoUtils.updateRefDataByPoint((List)pointList, ecoBomEntryIdSet, updateDyList);
                            EcoUtils.updateMftBomData(updateDyList, (String)"handEstimateEnd");
                        }
                    }
                    if (!ecoRecordLogList.isEmpty()) {
                        SaveServiceHelper.save((DynamicObject[])ecoRecordLogList.toArray(new DynamicObject[ecoRecordLogList.size()]), (OperateOption)OperateOption.create());
                    }
                    if (allEcoBomEntryIdSet.isEmpty()) break block24;
                    EcoEstimateStatusUpdateUtils.addEsEndRecord((Set)allEcoBomEntryIdSet);
                    String extClassPlugin = PdmParamSetHelper.getStringParamValue((String)"ECNEstimateEndExecPlugin");
                    if (StringUtils.isEmpty((String)extClassPlugin)) break block24;
                    try {
                        Object object = Class.forName(extClassPlugin).newInstance();
                        if (AbstractEstimateEndExtPlugin.class.isInstance(object)) {
                            log.info(" begin exec extplugin:" + extClassPlugin);
                            long startTime = System.currentTimeMillis();
                            String extResult = ((AbstractEstimateEndExtPlugin)object).exec(allEcoBomEntryIdSet);
                            long exextimelong = System.currentTimeMillis() - startTime;
                            log.info(" end exec extplugin:" + extClassPlugin + ",extResult=" + extResult + ",costs=" + exextimelong + "ms");
                        }
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        log.error((Throwable)e);
                    }
                }
                catch (Exception e) {
                    required.markRollback();
                    throw e;
                }
            }
        }
        return 2;
    }

    private Map<Long, DynamicObject> getTempKeyData(Set<Long> ecoIdSet, Set<Long> ecoBomentryIdSet, int[] selectRows) {
        if (PlatformUtils.isNullSet(ecoBomentryIdSet)) {
            return new HashMap<Long, DynamicObject>(16);
        }
        Map<Long, DynamicObject> ecoBillDataMap = PlatFormQueryDataHelper.getEcoBillData(ecoIdSet);
        Map<Long, DynamicObject> ecoBomEntryDataMap = PlatFormQueryDataHelper.getEcoBomData(ecoBomentryIdSet);
        int selectSize = selectRows.length;
        ArrayList updateEcoBillList = new ArrayList(16);
        ArrayList updateEcoBomEntryList = new ArrayList(16);
        HashSet<Long> updateKeyEcoBomIdSet = new HashSet<Long>(16);
        HashMap<Long, Set<String>> ecoBomRefNoMap = new HashMap<Long, Set<String>>(16);
        for (int i = 0; i < selectSize; ++i) {
            DynamicObject ecoBomEntryAfter;
            DynamicObject ecoBomEntry;
            int rowIndex = selectRows[i];
            if (!this.isBomChange(rowIndex) || this.isCopChange(rowIndex) || !this.isAuditStatus(null, rowIndex)) continue;
            DynamicObject ecoType = this.getDynamicObjectValue("ecotype", rowIndex);
            Long ecoBomEntryId = this.getLongValue("ecoentryid", rowIndex);
            Long ecoBomEntryAfterId = this.getLongValue("ecoentryafterid", rowIndex);
            Long ecoId = this.getLongValue("ecoid", rowIndex);
            Long ecoPentryId = this.getLongValue("ecopentryid", rowIndex);
            String entryGroupno = this.getStringValue("entrygroupno", rowIndex);
            String entryRefno = this.getStringValue("entryrefno", rowIndex);
            boolean isRefKey = this.getBooleanValue("refkey", rowIndex);
            boolean isGroupKey = this.getBooleanValue("groupkey", rowIndex);
            Date acttime = this.getDateValue("acttime", rowIndex);
            Date pentrtValidDate = this.getDateValue("pentryvaliddate", rowIndex);
            BigDecimal tranQty = this.getBigDecimalValue("tranqty", rowIndex);
            DynamicObject ecoBill = ecoBillDataMap.get(ecoId);
            DynamicObject ecoBillPentry = this.getEcoBillEntryDynamicObject(ecoBill, ecoPentryId);
            if (ecoBillPentry == null) continue;
            String entrymode = this.getStringValue("entrymode", rowIndex);
            if (this.isEcnPentryDiff(ecoBillPentry, rowIndex)) {
                ecoBillPentry.set("ecotype", (Object)ecoType);
                ecoBillPentry.set("pentryvaliddate", (Object)pentrtValidDate);
                PlatformUtils.addList(updateEcoBillList, (DynamicObject)ecoBill);
            }
            if (!this.isEcoBomEntryDiff(ecoBomEntry = ecoBomEntryDataMap.get(ecoBomEntryId), rowIndex)) continue;
            if (this.isEcoBomEntryReSetKeyDiff(ecoBomEntry, rowIndex)) {
                updateKeyEcoBomIdSet.add(ecoBomEntry.getLong("ecobomid"));
            }
            ecoBomEntry.set("acttime", (Object)acttime);
            ecoBomEntry.set("entryrefno", (Object)entryRefno);
            ecoBomEntry.set("entrygroupno", (Object)entryGroupno);
            ecoBomEntry.set("refkey", (Object)isRefKey);
            ecoBomEntry.set("groupkey", (Object)isGroupKey);
            ecoBomEntry.set("tranqty", (Object)tranQty);
            PlatformUtils.addList(updateEcoBomEntryList, (DynamicObject)ecoBomEntry);
            if ("B".equals(entrymode) && (ecoBomEntryAfter = ecoBomEntryDataMap.get(ecoBomEntryAfterId)) != null) {
                ecoBomEntryAfter.set("entryrefno", (Object)entryRefno);
                ecoBomEntryAfter.set("entrygroupno", (Object)entryGroupno);
                ecoBomEntryAfter.set("acttime", (Object)acttime);
                ecoBomEntryAfter.set("tranqty", (Object)tranQty);
                PlatformUtils.addList(updateEcoBomEntryList, (DynamicObject)ecoBomEntryAfter);
            }
            this.initEcoBomRefNoMap(ecoBomEntry, rowIndex, ecoBomRefNoMap);
        }
        Map<Long, Object> keyDyMap = new HashMap<Long, DynamicObject>(16);
        if (!updateEcoBillList.isEmpty() || !updateEcoBomEntryList.isEmpty()) {
            try (TXHandle required = TX.requiresNew((String)"mmc-pdm-EcoBomPlatFormQueryPlugin-TempSave");){
                try {
                    if (!updateEcoBillList.isEmpty()) {
                        SaveServiceHelper.update((DynamicObject[])updateEcoBillList.toArray(new DynamicObject[updateEcoBillList.size()]), (OperateOption)OperateOption.create());
                    }
                    if (!updateEcoBomEntryList.isEmpty()) {
                        SaveServiceHelper.update((DynamicObject[])updateEcoBomEntryList.toArray(new DynamicObject[updateEcoBomEntryList.size()]), (OperateOption)OperateOption.create());
                    }
                    if (!updateKeyEcoBomIdSet.isEmpty()) {
                        EcoUtils.updateEcoBomKeyByEcoBomId(updateKeyEcoBomIdSet, ecoBomRefNoMap, (String)"");
                    }
                    HashMap cacheAllRefIdMap = new HashMap(16);
                    keyDyMap = EcoUtils.getKeyEcoBomEntry(ecoBomentryIdSet, cacheAllRefIdMap);
                    required.markRollback();
                }
                catch (Exception e) {
                    required.markRollback();
                    throw e;
                }
            }
        }
        return keyDyMap;
    }

    private String checkDataChange(int[] selectRows) {
        int selectSize = selectRows.length;
        HashSet<Long> ecoIdSet = new HashSet<Long>(selectSize);
        HashSet<Long> ecoBomentryIdSet = new HashSet<Long>(selectSize);
        HashSet<Long> ecoRouteEntryIdSet = new HashSet<Long>(selectSize);
        for (int i = 0; i < selectSize; ++i) {
            int rowIndex = selectRows[i];
            Long ecoId = this.getLongValue("ecoid", rowIndex);
            ecoIdSet.add(ecoId);
            Long ecoBomEntryId = this.getLongValue("ecoentryid", rowIndex);
            Long ecoBomEntryAfterId = this.getLongValue("ecoentryafterid", rowIndex);
            if (this.isRouteChange(rowIndex)) {
                ecoRouteEntryIdSet.add(ecoBomEntryId);
            } else {
                if (this.isCopChange(rowIndex)) continue;
                ecoBomentryIdSet.add(ecoBomEntryId);
            }
            if (ecoBomEntryAfterId.equals(0L)) continue;
            if (this.isRouteChange(rowIndex)) {
                ecoRouteEntryIdSet.add(ecoBomEntryAfterId);
                continue;
            }
            ecoBomentryIdSet.add(ecoBomEntryAfterId);
        }
        Map<Long, DynamicObject> ecoBillDataMap = PlatFormQueryDataHelper.getEcoBillData(ecoIdSet);
        Map<Long, DynamicObject> ecoBomEntryDataMap = PlatFormQueryDataHelper.getEcoBomData(ecoBomentryIdSet);
        Map<Long, DynamicObject> ecoRouteEntryDataMap = PlatFormQueryDataHelper.getEcoRouteData(ecoRouteEntryIdSet);
        StringBuilder allString = new StringBuilder();
        for (int i = 0; i < selectSize; ++i) {
            int rowIndex = selectRows[i];
            if (this.isCopChange(rowIndex)) continue;
            Long ecoPEntryId = this.getLongValue("ecopentryid", rowIndex);
            Long ecoId = this.getLongValue("ecoid", rowIndex);
            Long ecoBomEntryId = this.getLongValue("ecoentryid", rowIndex);
            Long ecoBomEntryAfterId = this.getLongValue("ecoentryafterid", rowIndex);
            DynamicObject ecoType = this.getDynamicObjectValue("ecotype", rowIndex);
            Date transtartdate = this.getDateValue("transtartdate", rowIndex);
            Date acttime = this.getDateValue("acttime", rowIndex);
            BigDecimal tranQty = this.getBigDecimalValue("tranqty", rowIndex);
            String billStatus = this.getStringValue("billstatus", rowIndex);
            String entryGroupno = this.getStringValue("entrygroupno", rowIndex);
            String entryRefno = this.getStringValue("entryrefno", rowIndex);
            boolean isRefKey = this.getBooleanValue("refkey", rowIndex);
            boolean isGroupKey = this.getBooleanValue("groupkey", rowIndex);
            String estimateStatus = this.getStringValue("estimatestatus", rowIndex);
            boolean isBomChange = this.isBomChange(rowIndex);
            boolean isRouteChange = this.isRouteChange(rowIndex);
            DynamicObject ecoBill = ecoBillDataMap.get(ecoId);
            if (ecoBill == null) {
                return this.getNoDataMsgA(rowIndex);
            }
            DynamicObject ecoBillEntry = this.getEcoBillEntryDynamicObject(ecoBill, ecoPEntryId);
            if (ecoBillEntry == null) {
                return this.getNoDataMsgA(rowIndex);
            }
            String billStatusOld = ecoBill.getString("billStatus");
            if (!billStatusOld.equals(billStatus)) {
                return this.getNoDataMsgD(rowIndex);
            }
            StringBuilder sb = new StringBuilder();
            if (PlatformUtils.isDiffDynamicObject((DynamicObject)ecoBillEntry.getDynamicObject("ecotype"), (DynamicObject)ecoType)) {
                sb.append(ResManager.loadKDString((String)"\u53d8\u66f4\u7c7b\u578b", (String)"EcoBomPlatFormQueryPlugin_63", (String)"mmc-pdm-formplugin", (Object[])new Object[0])).append(" ");
            }
            if (isBomChange) {
                DynamicObject ecoBomEntry = ecoBomEntryDataMap.get(ecoBomEntryId);
                if (ecoBomEntry == null) {
                    return this.getNoDataMsgB(rowIndex);
                }
                DynamicObject ecoBomEntryAfter = null;
                if ("B".equals(ecoBomEntry.getString("entrymode")) && (ecoBomEntryAfter = ecoBomEntryDataMap.get(ecoBomEntryAfterId)) == null) {
                    return this.getNoDataMsgB(rowIndex);
                }
                Date transtartdateOld = ecoBomEntry.getDate("transtartdate");
                Date acttimeOld = ecoBomEntry.getDate("acttime");
                BigDecimal tranQtyOld = ecoBomEntry.getBigDecimal("tranqty");
                String oldEntryGroupno = ecoBomEntry.get("entrygroupno") == null ? "" : ecoBomEntry.getString("entrygroupno");
                String oldEntryRefNo = ecoBomEntry.get("entryrefno") == null ? "" : ecoBomEntry.getString("entryrefno");
                boolean isRefKeyOld = ecoBomEntry.getBoolean("refkey");
                boolean isGroupKeyOld = ecoBomEntry.getBoolean("groupkey");
                String estimateStatusNew = EcoUtils.getEstimateStatusByEcoType((DynamicObject)ecoType, (String)estimateStatus);
                if (PlatformUtils.isDiffDate((Date)transtartdate, (Date)transtartdateOld)) {
                    sb.append(ResManager.loadKDString((String)"\u5f00\u59cb\u8fc7\u6e21\u65f6\u95f4", (String)"EcoBomPlatFormQueryPlugin_64", (String)"mmc-pdm-formplugin", (Object[])new Object[0])).append(" ");
                }
                if (PlatformUtils.isDiffDate((Date)acttime, (Date)acttimeOld)) {
                    sb.append(ResManager.loadKDString((String)"\u5b9e\u65bd\u65f6\u95f4", (String)"EcoBomPlatFormQueryPlugin_65", (String)"mmc-pdm-formplugin", (Object[])new Object[0])).append(" ");
                }
                if (tranQty.compareTo(tranQtyOld) != 0) {
                    sb.append(ResManager.loadKDString((String)"\u5f85\u6d88\u8017\u6570\u91cf", (String)"EcoBomPlatFormQueryPlugin_66", (String)"mmc-pdm-formplugin", (Object[])new Object[0])).append(" ");
                }
                if (!entryGroupno.equals(oldEntryGroupno)) {
                    sb.append(ResManager.loadKDString((String)"\u6210\u7ec4\u53f7", (String)"EcoBomPlatFormQueryPlugin_67", (String)"mmc-pdm-formplugin", (Object[])new Object[0])).append(" ");
                }
                if (!entryRefno.equals(oldEntryRefNo)) {
                    sb.append(ResManager.loadKDString((String)"\u5173\u8054\u5b9e\u65bd\u53f7", (String)"EcoBomPlatFormQueryPlugin_68", (String)"mmc-pdm-formplugin", (Object[])new Object[0])).append(" ");
                }
                if (PlatformUtils.isDiffBoolean((boolean)isRefKey, (boolean)isRefKeyOld)) {
                    sb.append(ResManager.loadKDString((String)"\u6210\u7ec4\u4e3b\u952e", (String)"EcoBomPlatFormQueryPlugin_69", (String)"mmc-pdm-formplugin", (Object[])new Object[0])).append(" ");
                }
                if (PlatformUtils.isDiffBoolean((boolean)isGroupKey, (boolean)isGroupKeyOld)) {
                    sb.append(ResManager.loadKDString((String)"\u5173\u8054\u4e3b\u952e", (String)"EcoBomPlatFormQueryPlugin_70", (String)"mmc-pdm-formplugin", (Object[])new Object[0])).append(" ");
                }
                if (!estimateStatusNew.equals(estimateStatus)) {
                    sb.append(ResManager.loadKDString((String)"\u8bc4\u4f30\u72b6\u6001", (String)"EcoBomPlatFormQueryPlugin_71", (String)"mmc-pdm-formplugin", (Object[])new Object[0])).append(" ");
                }
            } else if (isRouteChange) {
                DynamicObject ecoRouteEntry = ecoRouteEntryDataMap.get(ecoBomEntryId);
                if (ecoRouteEntry == null) {
                    return this.getNoDataMsgC(rowIndex);
                }
                DynamicObject ecoRouteEntryAfter = null;
                if ("B".equals(ecoRouteEntry.getString("entrymode")) && (ecoRouteEntryAfter = ecoRouteEntryDataMap.get(ecoBomEntryAfterId)) == null) {
                    return this.getNoDataMsgC(rowIndex);
                }
                Date acttimeOld = ecoRouteEntry.getDate("acttime");
                String estimateStatusNew = EcoUtils.getEstimateStatusByEcoType((DynamicObject)ecoType, (String)estimateStatus);
                if (PlatformUtils.isDiffDate((Date)acttime, (Date)acttimeOld)) {
                    sb.append(ResManager.loadKDString((String)"\u5b9e\u65bd\u65f6\u95f4", (String)"EcoBomPlatFormQueryPlugin_65", (String)"mmc-pdm-formplugin", (Object[])new Object[0])).append(" ");
                }
                if (!estimateStatusNew.equals(estimateStatus)) {
                    sb.append(ResManager.loadKDString((String)"\u8bc4\u4f30\u72b6\u6001", (String)"EcoBomPlatFormQueryPlugin_71", (String)"mmc-pdm-formplugin", (Object[])new Object[0])).append(" ");
                }
            }
            if (sb.length() <= 1) continue;
            allString.append(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u5b57\u6bb5\uff1a%2$s\u4e0d\u662f\u6709\u6548\u7684\u3002", (String)"EcoBomPlatFormQueryPlugin_72", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), rowIndex + 1, sb));
        }
        if (allString.length() > 1) {
            allString.append(ResManager.loadKDString((String)"\u53d1\u751f\u4e86\u53d8\u5316,\u8bf7\u5148\u4fdd\u5b58BOM\u6216\u5237\u65b0\u6570\u636e\u540e\u518d\u91cd\u8bd5.", (String)"EcoBomPlatFormQueryPlugin_73", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        }
        return allString.toString();
    }

    private String checkActtimeIsChange(int[] selectRows) {
        if (!PdmParamSetHelper.getBooleanParamValue((String)"ECN_ActtimeAdjustRemark")) {
            return null;
        }
        int selectSize = selectRows.length;
        HashSet<Long> ecoBomentryIdSet = new HashSet<Long>(selectSize);
        HashSet<Long> ecoRouteEntryIdSet = new HashSet<Long>(selectSize);
        HashSet<Integer> cSet = new HashSet<Integer>(selectSize);
        for (int i = 0; i < selectSize; ++i) {
            int rowIndex = selectRows[i];
            Long ecoBomEntryId = this.getLongValue("ecoentryid", rowIndex);
            String actTimeRemark = this.getStringValue("acttimeadjustremark", rowIndex);
            boolean isBomChange = this.isBomChange(rowIndex);
            if (!StringUtils.isEmpty((String)actTimeRemark)) continue;
            Long ecoBomEntryAfterId = this.getLongValue("ecoentryafterid", rowIndex);
            if (isBomChange) {
                ecoBomentryIdSet.add(ecoBomEntryId);
                if (ecoBomEntryAfterId.equals(0L)) continue;
                ecoBomentryIdSet.add(ecoBomEntryAfterId);
                continue;
            }
            ecoRouteEntryIdSet.add(ecoBomEntryId);
            if (ecoBomEntryAfterId.equals(0L)) continue;
            ecoRouteEntryIdSet.add(ecoBomEntryAfterId);
        }
        if (!ecoBomentryIdSet.isEmpty() || !ecoRouteEntryIdSet.isEmpty()) {
            Map<Long, DynamicObject> ecoBomEntryDataMap = PlatFormQueryDataHelper.getEcoBomData(ecoBomentryIdSet);
            Map<Long, DynamicObject> ecoRouteEntryDataMap = PlatFormQueryDataHelper.getEcoRouteData(ecoRouteEntryIdSet);
            for (int i = 0; i < selectSize; ++i) {
                Date acttimeOld;
                String actTimeRemark;
                int rowIndex = selectRows[i];
                Long ecoBomEntryId = this.getLongValue("ecoentryid", rowIndex);
                Date acttime = this.getDateValue("acttime", rowIndex);
                DynamicObject ecoBomEntry = null;
                ecoBomEntry = this.isBomChange(rowIndex) ? ecoBomEntryDataMap.get(ecoBomEntryId) : ecoRouteEntryDataMap.get(ecoBomEntryId);
                if (ecoBomEntry == null || !StringUtils.isEmpty((String)(actTimeRemark = this.getStringValue("acttimeadjustremark", rowIndex))) || !PlatformUtils.isDiffDate((Date)acttime, (Date)(acttimeOld = ecoBomEntry.getDate("acttime")))) continue;
                cSet.add(i + 1);
            }
        }
        if (!cSet.isEmpty()) {
            return String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6570\u636e\u5df2\u8c03\u6574\u5b9e\u65bd\u65f6\u95f4\uff0c\u8bf7\u5f55\u5165\u201c\u5b9e\u65bd\u65f6\u95f4\u8c03\u6574\u5907\u6ce8\u201d\u3002", (String)"EcoBomPlatFormQueryPlugin_74", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), ((Object)cSet).toString());
        }
        return null;
    }

    private void pentryValidDateChangeUpdate(Date pentryInvalidDate, int rowIndex) {
        if (rowIndex < 0 || pentryInvalidDate == null) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentitys");
        Long ecopentryid = this.getLongValue("ecopentryid", rowIndex);
        boolean isAddStatus = this.isAddStatus(null, rowIndex);
        if (isAddStatus) {
            Long ecoBillId = this.getLongValue("ecoid", rowIndex);
            Long ecoBomId = this.getLongValue("ecobomid", rowIndex);
            DynamicObject ecoType = this.getDynamicObjectValue("ecotype", rowIndex);
            boolean isUpdate = false;
            isUpdate = this.isBomChange(rowIndex) ? this.updateEcoBomEntryByPvalidDate(pentryInvalidDate, ecoBillId, ecopentryid, ecoBomId, ecoType) : this.updateEcoRouteEntryByPvalidDate(pentryInvalidDate, ecoBillId, ecopentryid, ecoBomId, ecoType);
            if (isUpdate) {
                this.getView().invokeOperation("refresh");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8c03\u6574\u751f\u6548\u65f6\u95f4\uff0c\u4fdd\u5b58\u6210\u529f\u3002", (String)"EcoBomPlatFormQueryPlugin_75", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            }
        } else {
            int[] selectRows = entryGrid.getSelectRows();
            String[] filedArray = new String[]{"pentryvaliddate", "acttime"};
            Object[] valueArray = new Object[]{pentryInvalidDate, pentryInvalidDate};
            this.updateSameRowDataByPentry(selectRows, ecopentryid, filedArray, valueArray);
            this.updateSameRowDataBySelect(selectRows, filedArray, valueArray, rowIndex);
        }
    }

    private boolean checkSelectDataPEntryValidDate(int[] selectRows) {
        QFilter filter;
        StringBuilder message = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashMap<Long, Date> newDataMap = new HashMap<Long, Date>(16);
        HashMap<Long, HashSet<Long>> selectMap = new HashMap<Long, HashSet<Long>>(16);
        HashSet<Long> ecoBomIdSet = new HashSet<Long>(16);
        HashSet<Long> ecoRouteIdSet = new HashSet<Long>(16);
        HashSet<Long> ecoIdSet = new HashSet<Long>(16);
        for (int i = 0; i < selectRows.length; ++i) {
            int rowIndex = selectRows[i];
            int realSeq = rowIndex + 1;
            Long pentryId = this.getLongValue("ecopentryid", rowIndex);
            Long ecoEntryId = this.getLongValue("ecoentryid", rowIndex);
            Long ecoEntryAfterId = this.getLongValue("ecoentryafterid", rowIndex);
            Date pentryValidDate = this.getDateValue("pentryvaliddate", rowIndex);
            Long ecoId = this.getLongValue("ecoid", rowIndex);
            Long ecoBomId = this.getLongValue("ecobomid", rowIndex);
            Date oldPentryValidDate = (Date)newDataMap.get(pentryId);
            if (oldPentryValidDate == null) {
                newDataMap.put(pentryId, pentryValidDate);
            } else if (PlatformUtils.isDiffDate((Date)oldPentryValidDate, (Date)pentryValidDate)) {
                message.append(String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u7b2c\u201c%1$s\u201d\u884c\u53d8\u66f4\u5355\u7684\u4ea7\u54c1\u751f\u6548\u65f6\u95f4\u201c%2$s\u201d\u4e0e\u5176\u5b83\u884c\u4e0d\u4e00\u81f4\u201c%3$s\u201d\u3002", (String)"EcoBomPlatFormQueryPlugin_76", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), realSeq, sdf.format(pentryValidDate), sdf.format(oldPentryValidDate)));
                continue;
            }
            HashSet<Long> selectSet = (HashSet<Long>)selectMap.get(pentryId);
            if (selectSet == null) {
                selectSet = new HashSet<Long>(16);
            }
            selectSet.add(ecoEntryId);
            if (!ecoEntryAfterId.equals(0L)) {
                selectSet.add(ecoEntryAfterId);
            }
            selectMap.put(pentryId, selectSet);
            if (this.isBomChange(rowIndex)) {
                ecoBomIdSet.add(ecoBomId);
            } else {
                ecoRouteIdSet.add(ecoBomId);
            }
            ecoIdSet.add(ecoId);
        }
        if (message.length() > 0) {
            this.getView().showTipNotification(message.toString());
            return false;
        }
        if (ecoBomIdSet.isEmpty() && ecoRouteIdSet.isEmpty()) {
            return true;
        }
        Map<Long, DynamicObject> ecoBillDataMap = PlatFormQueryDataHelper.getEcoBillData(ecoIdSet);
        HashMap<Long, DynamicObject> ecoBomEntryDataMap = new HashMap(16);
        HashMap<Long, DynamicObject> ecoBomCopEntryDataMap = new HashMap(16);
        HashMap<Long, DynamicObject> ecoRouteEntryDataMap = new HashMap(16);
        if (!ecoBomIdSet.isEmpty()) {
            filter = new QFilter("ecobomid", "in", ecoBomIdSet);
            ecoBomEntryDataMap = PlatFormQueryDataHelper.getEcoBomData(filter);
            ecoBomCopEntryDataMap = PlatFormQueryDataHelper.getEcoBomCopData(filter);
        }
        if (!ecoRouteIdSet.isEmpty()) {
            filter = new QFilter("ecorouteid", "in", ecoRouteIdSet);
            ecoRouteEntryDataMap = PlatFormQueryDataHelper.getEcoRouteData(filter);
        }
        HashSet<Long> execPEntryIdSet = new HashSet<Long>(16);
        for (int i = 0; i < selectRows.length; ++i) {
            DynamicObject ecoType;
            int rowIndex = selectRows[i];
            int realSeq = rowIndex + 1;
            Long pentryId = this.getLongValue("ecopentryid", rowIndex);
            if (!execPEntryIdSet.add(pentryId)) continue;
            Date pentryValidDate = this.getDateValue("pentryvaliddate", rowIndex);
            Long ecoId = this.getLongValue("ecoid", rowIndex);
            Long ecoBomId = this.getLongValue("ecobomid", rowIndex);
            DynamicObject ecoBill = ecoBillDataMap.get(ecoId);
            DynamicObject ecoPEntry = this.getEcoBillEntryDynamicObject(ecoBill, pentryId);
            Date oldPentryValidDate = null;
            if (ecoPEntry != null) {
                oldPentryValidDate = ecoPEntry.getDate("pentryvaliddate");
            }
            if ((ecoType = this.getDynamicObjectValue("ecotype", rowIndex)) == null || !"B".equals(ecoType.getString("adjusttype")) || !PlatformUtils.isDiffDate((Date)oldPentryValidDate, (Date)pentryValidDate)) continue;
            Set<Long> allEcoBomEntryIdSet = this.getAllEcoBomEntryIdSet(ecoBomEntryDataMap, ecoBomCopEntryDataMap, ecoRouteEntryDataMap, ecoBomId, rowIndex);
            Set selectEcoBomEntryIdSet = (Set)selectMap.get(pentryId);
            if (allEcoBomEntryIdSet.size() <= selectEcoBomEntryIdSet.size()) continue;
            message.append(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u53d8\u66f4\u5355\u8fdb\u884c\u4e86\u4ea7\u54c1\u751f\u6548\u65f6\u95f4\u4fee\u6539\uff0c\u4e0d\u5141\u8bb8\u672c\u6b21\u66f4\u65b0\u672a\u9009\u62e9\u8be5\u4ea7\u54c1\u5bf9\u5e94\u7684\u7ec4\u4ef6\u5206\u5f55\u3002", (String)"EcoBomPlatFormQueryPlugin_77", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), realSeq));
        }
        if (message.length() > 0) {
            this.getView().showTipNotification(message.toString());
            return false;
        }
        return true;
    }

    private boolean checkSelectDataReplaceGroupNo(int[] selectRows) {
        StringBuilder message = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashMap<String, Date> newDataMap = new HashMap<String, Date>(16);
        HashMap<String, String> newRefNoMap = new HashMap<String, String>(16);
        HashMap<String, HashSet<Long>> selectMap = new HashMap<String, HashSet<Long>>(16);
        HashSet<Long> ecoBomIdSet = new HashSet<Long>(16);
        for (int i = 0; i < selectRows.length; ++i) {
            String oldRefno;
            String entryMode;
            int rowIndex = selectRows[i];
            int realSeq = rowIndex + 1;
            String replaceGroupNo = this.getStringValue("entryreplacegroup", rowIndex);
            if (StringUtils.isEmpty((String)replaceGroupNo) || "B".equals(entryMode = this.getStringValue("entrymode", rowIndex)) || "C".equals(entryMode)) continue;
            Long pentryId = this.getLongValue("ecopentryid", rowIndex);
            Long ecoBomEntryId = this.getLongValue("ecoentryid", rowIndex);
            Date actTime = this.getDateValue("acttime", rowIndex);
            Long ecoBomId = this.getLongValue("ecobomid", rowIndex);
            String reKeys = pentryId + "_" + replaceGroupNo;
            Date oldActtime = (Date)newDataMap.get(reKeys);
            if (oldActtime == null) {
                newDataMap.put(reKeys, actTime);
            } else if (PlatformUtils.isDiffDate((Date)oldActtime, (Date)actTime)) {
                message.append(String.format(ResManager.loadKDString((String)"\u7b2c[%1$s]\u884c\u53d8\u66f4\u5355\u5b58\u5728\u66ff\u4ee3\u7ec4\u53f7\uff0c\u4f46\u5176\u5b9e\u65bd\u65f6\u95f4[%2$s]\u4e0e\u5176\u5b83\u76f8\u540c\u66ff\u4ee3\u7ec4\u53f7\u7684\u884c\u4e0d\u4e00\u81f4[%3$s]\uff0c\u4e0d\u5141\u8bb8\u3002", (String)"EcoBomPlatFormQueryPlugin_85", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), realSeq, sdf.format(actTime), sdf.format(oldActtime)));
                continue;
            }
            String entryRefNo = this.getStringValue("entryrefno", rowIndex);
            if (entryRefNo == null) {
                entryRefNo = "";
            }
            if ((oldRefno = (String)newRefNoMap.get(reKeys)) == null) {
                newRefNoMap.put(reKeys, entryRefNo);
            } else if (PlatformUtils.isDiffString((String)oldRefno, (String)entryRefNo)) {
                message.append(String.format(ResManager.loadKDString((String)"\u7b2c[%1$s]\u884c\u53d8\u66f4\u5355\u5b58\u5728\u66ff\u4ee3\u7ec4\u53f7\uff0c\u4f46\u5176\u5173\u8054\u5b9e\u65bd\u53f7[%2$s]\u4e0e\u5176\u5b83\u76f8\u540c\u66ff\u4ee3\u7ec4\u53f7\u7684\u884c\u4e0d\u4e00\u81f4[%3$s]\uff0c\u4e0d\u5141\u8bb8\u3002", (String)"EcoBomPlatFormQueryPlugin_87", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), realSeq, entryRefNo, oldRefno));
                continue;
            }
            HashSet<Long> selectSet = (HashSet<Long>)selectMap.get(reKeys);
            if (selectSet == null) {
                selectSet = new HashSet<Long>(16);
            }
            selectSet.add(ecoBomEntryId);
            selectMap.put(reKeys, selectSet);
            ecoBomIdSet.add(ecoBomId);
        }
        if (message.length() > 0) {
            this.getView().showTipNotification(message.toString());
            return false;
        }
        if (ecoBomIdSet.isEmpty()) {
            return true;
        }
        HashMap<Long, DynamicObject> ecoBomEntryDataMap = new HashMap(16);
        if (!ecoBomIdSet.isEmpty()) {
            QFilter filter = new QFilter("ecobomid", "in", ecoBomIdSet);
            ecoBomEntryDataMap = PlatFormQueryDataHelper.getEcoBomData(filter);
        }
        HashSet<Long> execPEntryIdSet = new HashSet<Long>(16);
        for (int i = 0; i < selectRows.length; ++i) {
            Long pentryId;
            String entryMode;
            int rowIndex = selectRows[i];
            int realSeq = rowIndex + 1;
            String replaceGroupNo = this.getStringValue("entryreplacegroup", rowIndex);
            if (StringUtils.isEmpty((String)replaceGroupNo) || "B".equals(entryMode = this.getStringValue("entrymode", rowIndex)) || "C".equals(entryMode) || !execPEntryIdSet.add(pentryId = this.getLongValue("ecopentryid", rowIndex))) continue;
            Date actTime = this.getDateValue("acttime", rowIndex);
            Long ecoBomEntryId = this.getLongValue("ecoentryid", rowIndex);
            String entryRefNo = this.getStringValue("entryrefno", rowIndex);
            DynamicObject ecoBomEntry = this.getEcoBomEntryFromMap(ecoBomEntryDataMap, ecoBomEntryId);
            if (ecoBomEntry == null) continue;
            Date oldActtime = ecoBomEntry.getDate("acttime");
            String oldEntryRefNo = ecoBomEntry.getString("entryrefno");
            if (!PlatformUtils.isDiffDate((Date)oldActtime, (Date)actTime) && !PlatformUtils.isDiffString((String)oldEntryRefNo, (String)entryRefNo)) continue;
            Set<Long> allEcoBomEntryIdSet = this.getSameReplaceGroupIdSet(ecoBomEntryDataMap, replaceGroupNo);
            String reKeys = pentryId + "_" + replaceGroupNo;
            Set selectEcoBomEntryIdSet = (Set)selectMap.get(reKeys);
            if (allEcoBomEntryIdSet.size() <= selectEcoBomEntryIdSet.size()) continue;
            message.append(String.format(ResManager.loadKDString((String)"\u7b2c[%1$s]\u884c\u53d8\u66f4\u5355\u8fdb\u884c\u4e86\u5b9e\u65bd\u65f6\u95f4\u6216\u5173\u8054\u5b9e\u65bd\u53f7\u5b57\u6bb5\u4fee\u6539\uff0c\u4e14\u672c\u884c\u5b58\u5728\u66ff\u4ee3\u7ec4\u53f7\uff0c\u4f46\u662f\u672c\u6b21\u66f4\u65b0\u672a\u9009\u62e9\u8be5\u66ff\u4ee3\u7ec4\u53f7\u5bf9\u5e94\u7684\u5168\u90e8\u7ec4\u4ef6\u5206\u5f55\uff0c\u4e0d\u5141\u8bb8\u3002", (String)"EcoBomPlatFormQueryPlugin_86", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), realSeq));
        }
        if (message.length() > 0) {
            this.getView().showTipNotification(message.toString());
            return false;
        }
        return true;
    }

    private void changeTypeValueChange(String changeType) {
        if (StringUtils.isEmpty((String)changeType)) {
            return;
        }
        Set types = Arrays.stream(changeType.split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
        if (!types.isEmpty()) {
            this.showFieldVisible(EcoBomPlatformConst.BOMCHANGETYPE_FIELDS, changeType.contains("A"));
            this.showFieldVisible(EcoBomPlatformConst.ROUTECHANGETYPE_FIELDS, changeType.contains("B"));
        }
    }

    private void showFieldVisible(String[] fields, boolean isVisible) {
        this.getView().setVisible(Boolean.valueOf(isVisible), fields);
        if (isVisible && this.isDisableGroupNo()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entrygroupno", "groupkey"});
        }
    }

    public void saveUnKeyAndAddLogs(List<DynamicObject> updateUnKeyList, String keyField) {
        if (updateUnKeyList.isEmpty()) {
            return;
        }
        List<Object[]> sqlParamList = this.getEcoBomEntryIdParam(updateUnKeyList);
        HashMap ecoBillMap = new HashMap(16);
        ArrayList ecoRecordLogList = new ArrayList(16);
        HashMap ecoRecordLogMap = new HashMap(16);
        String logremark = ResManager.loadKDString((String)"\u5b9e\u65bd\u8c03\u6574\u4e3b\u952e\u884c\u540e\uff0c\u81ea\u52a8\u66f4\u65b0\u5176\u4ed6\u884c\u4e3a\u975e\u4e3b\u952e\u3002", (String)"EcoBomPlatFormQueryPlugin_90", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
        for (DynamicObject ecoBomEntry : updateUnKeyList) {
            Long ecoBomId = ecoBomEntry.getLong("ecobomid");
            DynamicObject ecoBill = EcoUtils.getEcoBillDynamicObject((Long)ecoBomId, ecoBillMap);
            DynamicObject ecoPEntry = EcoUtils.getEcoPEntry((DynamicObject)ecoBill, (Long)ecoBomId);
            AddEcoLogUtils.addEcoLogByField((DynamicObject)ecoBomEntry, (Object)true, (Object)false, (String)keyField, (String)this.getFieldName(keyField), (DynamicObject)ecoBill, (DynamicObject)ecoPEntry, ecoRecordLogMap, ecoRecordLogList, (String)logremark);
        }
        if ("groupkey".equals(keyField)) {
            DB.executeBatch((DBRoute)scmDBRoute, (String)" update t_fmm_ecobomentry set fgroupkey = '0' where fentryid = ?  ", sqlParamList);
        }
        if ("refkey".equals(keyField)) {
            DB.executeBatch((DBRoute)scmDBRoute, (String)" update t_fmm_ecobomentry set frefkey = '0' where fentryid = ? ", sqlParamList);
        }
        if (!ecoRecordLogList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])ecoRecordLogList.toArray(new DynamicObject[ecoRecordLogList.size()]), (OperateOption)OperateOption.create());
        }
    }

    private String getFieldName(String keyField) {
        if ("groupkey".equals(keyField)) {
            return ResManager.loadKDString((String)"\u6210\u7ec4\u4e3b\u952e", (String)"EcoBomPlatFormQueryPlugin_88", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
        }
        if ("refkey".equals(keyField)) {
            return ResManager.loadKDString((String)"\u5173\u8054\u4e3b\u952e", (String)"EcoBomPlatFormQueryPlugin_89", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
        }
        return keyField;
    }

    public List<Object[]> getEcoBomEntryIdParam(List<DynamicObject> updateUnKeyList) {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(updateUnKeyList.size());
        for (DynamicObject entry : updateUnKeyList) {
            paramList.add(new Object[]{entry.getLong("entryid")});
        }
        return paramList;
    }
}

