/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.ecoplatform;

import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPools;

public class EcoEstimateExecPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(EcoEstimateExecPlugin.class);
    private static final String SCHEDULING_ORG = "scheduling_org";
    private static final String PDM_ECOESTIMATE_EXEC = "pdm_ecoestimate_exec";
    private static final String CACULATE_LOG = "mrp_caculate_log";
    private static final String PLANGRAMENTITY = "pdm_planprogram_eco";
    private String schedulingSchemeId = null;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button runitem = (Button)this.getControl("btncalc");
        runitem.addClickListener((ClickListener)this);
        this.addClickListeners(new String[]{"billnos"});
    }

    public static Set<Long> getOrgIdsByProductView() {
        HashSet<Long> idSet = new HashSet<Long>();
        QFilter viewfilter = new QFilter("view", "=", (Object)4L);
        QFilter ctrlfilter = new QFilter("isctrlunit", "=", (Object)Boolean.TRUE);
        String selectProperties = "org,isctrlunit";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getOrgIdsByProductView", (String)"bos_org_structure", (String)selectProperties, (QFilter[])new QFilter[]{viewfilter, ctrlfilter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                long id = row.getLong("org");
                idSet.add(id);
            }
        }
        return idSet;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue(SCHEDULING_ORG);
        DynamicObject program = (DynamicObject)this.getModel().getValue("scheduling_scheme");
        if (org != null && program == null) {
            QFilter qFilter = new QFilter("status", "=", (Object)"C");
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            qFilter.and(new QFilter("estimatetype", "=", (Object)"A"));
            qFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)PLANGRAMENTITY, (Long)org.getLong("id")));
            Map masp = BusinessDataServiceHelper.loadFromCache((String)PLANGRAMENTITY, (QFilter[])new QFilter[]{qFilter});
            if (masp != null && !masp.isEmpty() && (program = (DynamicObject)masp.entrySet().iterator().next().getValue()) != null) {
                this.getModel().setValue("scheduling_scheme", (Object)program);
                this.getView().updateView("scheduling_scheme");
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long userId = RequestContext.get().getCurrUserId();
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)BizAppServiceHelp.getAppIdByAppNumber((String)"pdm"), (String)PDM_ECOESTIMATE_EXEC, (String)"47150e89000000ac");
        List orgIds = result.getHasPermOrgs();
        Set<Long> productViewOrgIds = EcoEstimateExecPlugin.getOrgIdsByProductView();
        long orgid = RequestContext.get().getOrgId();
        if (!orgIds.isEmpty()) {
            this.setOrgByPermission(orgid, orgIds, productViewOrgIds);
        } else if (result.hasAllOrgPerm() && productViewOrgIds.contains(orgid)) {
            this.getModel().setValue(SCHEDULING_ORG, (Object)RequestContext.get().getOrgId());
        }
    }

    public void setOrgByPermission(long orgid, List<Long> orgIds, Set<Long> productViewOrgIds) {
        if (orgIds.contains(orgid) && productViewOrgIds.contains(orgid)) {
            this.getModel().setValue(SCHEDULING_ORG, (Object)RequestContext.get().getOrgId());
        } else {
            this.getModel().setValue(SCHEDULING_ORG, (Object)orgIds.get(0));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (SCHEDULING_ORG.equals(key)) {
            this.getModel().setValue("scheduling_scheme", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        String key = op.getOperateKey();
        if ("exec".equals(key)) {
            if (!this.validate(e)) {
                return;
            }
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u8ba1\u7b97\u51c6\u5907\u4e2d\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"EcoEstimateExecPlugin_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0])));
            try {
                this.beforeCalculate(e);
            }
            finally {
                this.getView().hideLoading();
            }
        }
    }

    private boolean validate(BeforeDoOperationEventArgs e) {
        return true;
    }

    private void beforeCalculate(BeforeDoOperationEventArgs e) {
        if (!this.addDataMutex()) {
            return;
        }
        try {
            Long logid = (Long)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IMRPCalcRuntimeService", (String)"initRuntime", (Object[])new Object[]{CACULATE_LOG});
            this.writeLog(logid);
            this.execSchedulingScheme(logid);
        }
        catch (Exception exception) {
            this.release();
            throw exception;
        }
    }

    private boolean addDataMutex() {
        StringBuilder errMsg = new StringBuilder();
        DynamicObject schedulingScheme = (DynamicObject)this.getModel().getValue("scheduling_scheme");
        this.schedulingSchemeId = schedulingScheme.getPkValue().toString();
        if (!MutexHelper.require((String)PLANGRAMENTITY, (Object)String.valueOf(this.schedulingSchemeId), (String)"releasemutex", (boolean)true, (StringBuilder)errMsg)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u5b58\u5728\u6b63\u5728\u8fd0\u884c\u7684\u8ba1\u5212\uff0c\u8bf7\u7b49\u5f85\u8fd0\u7b97\u7ed3\u675f\u6216\u7ec8\u6b62\u8fd0\u7b97\u540e\u518d\u8fdb\u884c\u8ba1\u7b97\u3002", (String)"EcoEstimateExecPlugin_4", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void execSchedulingScheme(long ctxId) {
        DynamicObject org = (DynamicObject)this.getModel().getValue(SCHEDULING_ORG);
        String title = ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u8bc4\u4f30", (String)"EcoEstimateExecPlugin_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
        Long evntid = (Long)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IMRPCalcRuntimeService", (String)"startCalc", (Object[])new Object[]{ctxId, null, org.getLong("id"), org.getString("name"), this.getView().getFormShowParameter().getFormId(), title, CACULATE_LOG});
        this.showLogForm(evntid);
    }

    private DynamicObject writeLog(Long ctxId) {
        this.putAlgoCacheId(ctxId);
        String title = ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u8bc4\u4f30", (String)"EcoEstimateExecPlugin_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
        DynamicObject schedulingScheme = (DynamicObject)this.getModel().getValue("scheduling_scheme");
        DynamicObject caculateLog = BusinessDataServiceHelper.loadSingle((Object)ctxId, (String)CACULATE_LOG);
        DynamicObject org = (DynamicObject)this.getModel().getValue(SCHEDULING_ORG);
        caculateLog.set("createorg", (Object)org);
        caculateLog.set("useorg", (Object)org);
        caculateLog.set("status", (Object)"C");
        caculateLog.set("enable", (Object)"1");
        caculateLog.set("plantype", (Object)title);
        caculateLog.set("plangram", (Object)schedulingScheme.getLong("id"));
        caculateLog.set("programname", (Object)schedulingScheme.getString("name"));
        caculateLog.set("programnumber", (Object)schedulingScheme.getString("number"));
        caculateLog.set("plangramentity", (Object)PLANGRAMENTITY);
        caculateLog.set("plandate", this.getModel().getValue("plandate"));
        caculateLog.set("creator", (Object)RequestContext.get().getCurrUserId());
        caculateLog.set("startdate", (Object)new Date());
        caculateLog.set("operatmode", (Object)title);
        caculateLog.set("operatmodekey", (Object)this.getView().getFormShowParameter().getFormId());
        caculateLog.set("runtype", (Object)"ECO");
        SaveServiceHelper.update((DynamicObject)caculateLog);
        return caculateLog;
    }

    private void putAlgoCacheId(Long ctxId) {
        FormShowParameter param = this.getView().getFormShowParameter();
        String algoCacheId = (String)param.getCustomParam("algoCacheId");
        if (StringUtils.isNotEmpty((CharSequence)algoCacheId)) {
            DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(CACULATE_LOG);
            cache.put(ctxId.toString(), "algoCacheId", (Object)algoCacheId);
        }
    }

    private void showLogForm(Long id) {
        this.getView().close();
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId("pdm_ecocal_log");
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setPkId((Object)id);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam("id", (Object)id);
        formShowParameter.setCustomParam("forward", (Object)"eco");
        formShowParameter.setCaption(this.getView().getFormShowParameter().getFormName());
        this.getView().showForm((FormShowParameter)formShowParameter);
        ThreadPools.executeOnce((String)"EcoEstimateExecPlugin", () -> this.doRelease(id));
    }

    private void doRelease(Long id) {
        String status = this.getCalcStatus(id);
        int i = 0;
        while ("D".equals(status)) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            status = this.getCalcStatus(id);
            if (++i <= 10000) continue;
        }
        this.release();
    }

    private void release() {
        MutexHelper.release((String)PLANGRAMENTITY, (String)"releasemutex", (String)String.valueOf(this.schedulingSchemeId));
    }

    private String getCalcStatus(Long id) {
        String status = "";
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)CACULATE_LOG, (String)"calculatestatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (dynamicObject != null) {
            status = dynamicObject.getString("calculatestatus");
        }
        return status;
    }
}

