/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.ecoplatform;

import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.common.util.MMCUtils;

public class EcoEstimateResultPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final Log log = LogFactory.getLog(EcoEstimateResultPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"supplybillno"});
        this.addClickListeners(new String[]{"updateecoresultmsg"});
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        grid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        if (e == null || e.getFieldName() == null) {
            return;
        }
        String fieldName = e.getFieldName();
        if ("requirebillno".equals(fieldName)) {
            int rowIndex = e.getRowIndex();
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity("entryentity", rowIndex);
            if (dynamicObject == null) {
                return;
            }
            Long reqBillId = dynamicObject.getLong("requirebillid");
            if (PlatformUtils.isNullLong((Long)reqBillId)) {
                return;
            }
            DynamicObject billType = dynamicObject.getDynamicObject("requirebilltype");
            if (billType == null) {
                return;
            }
            String entityName = (String)billType.getDynamicObject("billformid").getPkValue();
            if (StringUtils.isEmpty((String)entityName)) {
                return;
            }
            this.openBillInfoShowPage(entityName, reqBillId);
        }
    }

    public void openBillInfoShowPage(String billNumber, Long billId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(billNumber);
        showParameter.setPkId((Object)billId);
        showParameter.setAppId(BizAppServiceHelp.getAppIdByFormNum((String)billNumber));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object propertyOldValueObj;
        super.propertyChanged(e);
        if (this.getPageCache().get("isIgnoreChangeListener") == "true") {
            return;
        }
        ChangeData[] changeDatas = e.getChangeSet();
        IDataEntityProperty dataEntityProperty = e.getProperty();
        String propertyName = dataEntityProperty.getName();
        if (MMCUtils.isEmptyString((String)propertyName)) {
            return;
        }
        ChangeData changeData = changeDatas[0];
        Object object = propertyOldValueObj = changeData == null ? null : changeData.getOldValue();
        if (propertyName.equalsIgnoreCase("supplybillno")) {
            this.getPageCache().put("isIgnoreChangeListener", "true");
            this.getModel().setValue("supplybillno", propertyOldValueObj);
            this.getView().updateView("supplybillno");
            this.getPageCache().put("isIgnoreChangeListener", "false");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        int ordinal = this.getModel().getProperty("supplybillno").getOrdinal();
        this.getModel().getDataEntity().getDataEntityState().setBizChanged(ordinal, false);
        ordinal = this.getModel().getProperty("updateecoresultmsg").getOrdinal();
        this.getModel().getDataEntity().getDataEntityState().setBizChanged(ordinal, false);
    }

    public void click(EventObject event) {
        String msg;
        super.click(event);
        if (event == null) {
            return;
        }
        Object srcObj = event.getSource();
        Control srcC = srcObj instanceof Control ? (Control)srcObj : null;
        String srcKey = srcC == null ? null : srcC.getKey();
        IFormView fv = this.getView();
        if (fv == null) {
            return;
        }
        if (StringUtils.isBlank((String)srcKey)) {
            return;
        }
        if ("supplybillno".equalsIgnoreCase(srcKey)) {
            Long billId = (Long)this.getModel().getValue("supplybillid");
            if (PlatformUtils.isNullLong((Long)billId)) {
                return;
            }
            DynamicObject billType = (DynamicObject)this.getModel().getValue("supplybilltype");
            String entityName = (String)billType.getDynamicObject("billformid").getPkValue();
            if (StringUtils.isEmpty((String)entityName)) {
                return;
            }
            this.openBillInfoShowPage(entityName, billId);
        } else if ("updateecoresultmsg".equalsIgnoreCase(srcKey) && !StringUtils.isEmpty((String)(msg = (String)this.getModel().getValue("updateecoresult")))) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("pdm_ecologdetial");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.setCustomParam("msgString", (Object)msg);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pdm_ecologdetial"));
            this.getView().showForm(showParameter);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (PlatformUtils.isDisableGroupNo()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"groupkeynumbers", "entrygroupno", "requiregroupkey", "groupnokey"});
        }
    }
}

