/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.ecoplatform;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.mmc.pdm.business.ecoplatform.EcoFilterHelper;
import kd.mmc.pdm.common.util.MMCUtils;
import kd.mpscmm.msplan.mrp.business.helper.BillFieldEntityHelper;

public class EcoRequireFilterPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"filterrule"});
        this.addClickListeners(new String[]{"srcfieldnumber", "tragetfieldnumber"});
        BasedataEdit objectEntity = (BasedataEdit)this.getControl("objectentity");
        if (objectEntity != null) {
            objectEntity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().setValue("sysdefault", (Object)Boolean.FALSE);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet.length <= 0) {
            return;
        }
        Object oldValue = changeSet[0].getOldValue();
        Object newValue = changeSet[0].getNewValue();
        int rowIndex = changeSet[0].getRowIndex();
        if (Objects.equals(oldValue, newValue)) {
            return;
        }
        if ("objectentity".equals(proName)) {
            this.getModel().setValue("filterrule", null);
            this.getModel().setValue("filterrulevalue_tag", null);
            this.getModel().deleteEntryData("matchentry");
            this.getView().updateView("matchentry");
        } else if ("changeobject".equals(proName)) {
            this.setObjectEntityByChangeObject((String)newValue);
            this.setMsg(this.getIsForward(), (String)newValue);
            this.setUnTransmitDealModeDisplayName();
        } else if ("srcfieldnumber".equals(proName)) {
            if (newValue == null) {
                this.getModel().setValue("leftfieldname", null, rowIndex);
            } else {
                DynamicObject srcObjectEntity = (DynamicObject)this.getModel().getValue("srcobjectentity");
                String fieldName = EcoFilterHelper.getFieldName((String)((String)srcObjectEntity.getPkValue()), (String)((String)newValue));
                this.getModel().setValue("leftfieldname", (Object)fieldName, rowIndex);
            }
        } else if ("tragetfieldnumber".equals(proName)) {
            if (newValue == null) {
                this.getModel().setValue("targetfieldname", null, rowIndex);
            } else {
                DynamicObject targetObjectEntity = (DynamicObject)this.getModel().getValue("objectentity");
                String fieldName = EcoFilterHelper.getFieldName((String)((String)targetObjectEntity.getPkValue()), (String)((String)newValue));
                this.getModel().setValue("targetfieldname", (Object)fieldName, rowIndex);
            }
        } else if ("isforward".equals(proName)) {
            boolean isForward = (Boolean)newValue;
            this.setMsg(isForward, this.getChangeObject());
            this.setDataMatchFilterByBom(isForward);
            this.setDataMatchFilterByRoute(isForward);
        }
    }

    private String getChangeObject() {
        return (String)this.getModel().getValue("changeobject");
    }

    private boolean getIsForward() {
        return (Boolean)this.getModel().getValue("isforward");
    }

    private ComboItem genCombItemData(String keyString, String displayName) {
        ComboItem comboItem = new ComboItem();
        comboItem.setCaption(new LocaleString(displayName));
        comboItem.setValue(keyString);
        return comboItem;
    }

    private void setDataMatchFilterByBom(boolean isFroward) {
        if (!"A".equals(this.getChangeObject())) {
            return;
        }
        ComboEdit combAdd = (ComboEdit)this.getControl("datematchadd");
        ComboEdit combEdit = (ComboEdit)this.getControl("datematchedit");
        ArrayList<ComboItem> listAdd = new ArrayList<ComboItem>(16);
        ArrayList<ComboItem> listEdit = new ArrayList<ComboItem>(16);
        if (isFroward) {
            listAdd.add(this.genCombItemData("A", ResManager.loadKDString((String)"\u5b9e\u65bd\u65f6\u95f4\u5c0f\u4e8e\u7b49\u4e8e\u8ba1\u5212\u5f00\u5de5\u65f6\u95f4", (String)"EcoRequireFilterPlugin_9", (String)"mmc-pdm-formplugin", (Object[])new Object[0])));
            listAdd.add(this.genCombItemData("C", this.getNotLimitMsg()));
            listEdit.add(this.genCombItemData("A", ResManager.loadKDString((String)"\u5b9e\u65bd\u65f6\u95f4\u5c0f\u4e8e\u7b49\u4e8e\u9700\u6c42\u65f6\u95f4", (String)"EcoRequireFilterPlugin_12", (String)"mmc-pdm-formplugin", (Object[])new Object[0])));
            listEdit.add(this.genCombItemData("C", this.getNotLimitMsg()));
        } else {
            listAdd.add(this.genCombItemData("B", ResManager.loadKDString((String)"\u5b9e\u65bd\u65f6\u95f4\u5927\u4e8e\u9700\u6c42\u65f6\u95f4", (String)"EcoRequireFilterPlugin_10", (String)"mmc-pdm-formplugin", (Object[])new Object[0])));
            listAdd.add(this.genCombItemData("C", this.getNotLimitMsg()));
            listEdit.add(this.genCombItemData("B", ResManager.loadKDString((String)"\u5b9e\u65bd\u65f6\u95f4\u5927\u4e8e\u9700\u6c42\u65f6\u95f4", (String)"EcoRequireFilterPlugin_10", (String)"mmc-pdm-formplugin", (Object[])new Object[0])));
            listEdit.add(this.genCombItemData("C", this.getNotLimitMsg()));
        }
        combAdd.setComboItems(listAdd);
        combEdit.setComboItems(listEdit);
    }

    private void setDataMatchFilterByRoute(boolean isFroward) {
        if (!"B".equals(this.getChangeObject())) {
            return;
        }
        ComboEdit comb = (ComboEdit)this.getControl("datematchbysfc");
        ArrayList<ComboItem> listComb = new ArrayList<ComboItem>(16);
        if (isFroward) {
            listComb.add(this.genCombItemData("A", ResManager.loadKDString((String)"\u5b9e\u65bd\u65f6\u95f4\u5c0f\u4e8e\u7b49\u4e8e\u8ba1\u5212\u5f00\u5de5\u65f6\u95f4", (String)"EcoRequireFilterPlugin_9", (String)"mmc-pdm-formplugin", (Object[])new Object[0])));
            listComb.add(this.genCombItemData("C", this.getNotLimitMsg()));
        } else {
            listComb.add(this.genCombItemData("B", ResManager.loadKDString((String)"\u5b9e\u65bd\u65f6\u95f4\u5927\u4e8e\u8ba1\u5212\u5f00\u5de5\u65f6\u95f4", (String)"EcoRequireFilterPlugin_15", (String)"mmc-pdm-formplugin", (Object[])new Object[0])));
            listComb.add(this.genCombItemData("C", this.getNotLimitMsg()));
        }
        comb.setComboItems(listComb);
    }

    private void setMsg(boolean isFroward, String changeObject) {
        String addMsg1 = "";
        String addMsg2 = "";
        String editMsg = "";
        if (isFroward) {
            if ("A".equals(changeObject)) {
                addMsg1 = ResManager.loadKDString((String)"\uff08BOMID = \u7ec4\u4ef6\u6e05\u5355BOMID \u5e76\u4e14 BOM\u5206\u5f55ID <> \u7ec4\u4ef6\u6e05\u5355\u5b50\u9879BOM\u5206\u5f55ID\uff09", (String)"EcoRequireFilterPlugin_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                addMsg2 = ResManager.loadKDString((String)"\u6216\u8005\uff08BOM\u5206\u5f55ID = \u7ec4\u4ef6\u6e05\u5355\u5b50\u9879BOM\u5206\u5f55ID \u5e76\u4e14 \u7ec4\u4ef6\u6e05\u5355\u5b50\u9879\u5206\u5b50 = 0\uff09", (String)"EcoRequireFilterPlugin_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                editMsg = ResManager.loadKDString((String)"BOM\u5206\u5f55ID = \u7ec4\u4ef6\u6e05\u5355\u5b50\u9879BOM\u5206\u5f55ID \u5e76\u4e14 \u7ec4\u4ef6\u6e05\u5355\u5b50\u9879\u5206\u5b50 <> 0", (String)"EcoRequireFilterPlugin_2", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
            } else {
                addMsg1 = ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebfID = \u5de5\u5e8f\u8ba1\u5212\u5de5\u827a\u8def\u7ebfID \u5e76\u4e14 \u5de5\u827a\u8def\u7ebf\u5206\u5f55ID <> \u5de5\u5e8f\u8ba1\u5212\u5de5\u827a\u8def\u7ebf\u5206\u5f55ID", (String)"EcoRequireFilterPlugin_13", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                addMsg2 = "";
                editMsg = this.getRouteChangeEntryEqualMsg();
            }
        } else if ("A".equals(changeObject)) {
            addMsg1 = ResManager.loadKDString((String)"BOM\u5206\u5f55ID = \u7ec4\u4ef6\u6e05\u5355\u5b50\u9879BOM\u5206\u5f55ID \u5e76\u4e14 \u7ec4\u4ef6\u6e05\u5355\u5206\u5b50 <> 0", (String)"EcoRequireFilterPlugin_3", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
            editMsg = ResManager.loadKDString((String)"BOM\u5206\u5f55ID\u4e3a\u7ec4\u4ef6\u6e05\u5355\u5b50\u9879\u7684ID\uff0c\u4e14\u7ec4\u4ef6\u6e05\u5355\u5206\u5b50\u4e3a0\u3002", (String)"EcoRequireFilterPlugin_4", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
        } else {
            addMsg1 = this.getRouteChangeEntryEqualMsg();
            editMsg = this.getRouteChangeEntryEqualMsg();
        }
        Label labaddlabelap1 = (Label)this.getControl("addlabelap1");
        Label labaddlabelap2 = (Label)this.getControl("addlabelap2");
        Label labeditlabelap = (Label)this.getControl("editlabelap");
        labaddlabelap1.setText(addMsg1);
        labaddlabelap2.setText(addMsg2);
        labeditlabelap.setText(editMsg);
    }

    private String getRouteChangeEntryEqualMsg() {
        return ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u5206\u5f55ID = \u5de5\u5e8f\u8ba1\u5212\u5de5\u827a\u8def\u7ebf\u5206\u5f55ID", (String)"EcoRequireFilterPlugin_14", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
    }

    private String getNotLimitMsg() {
        return ResManager.loadKDString((String)"\u4e0d\u9650\u5236", (String)"EcoRequireFilterPlugin_11", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
    }

    private void setUnTransmitDealModeDisplayName() {
        ComboEdit unTransmitDealModeField = (ComboEdit)this.getControl("untransmitdealmode");
        if ("A".equals(this.getChangeObject())) {
            unTransmitDealModeField.setCaption(new LocaleString(ResManager.loadKDString((String)"\u672a\u4e0b\u8fbe\u7684\u7ec4\u4ef6\u6e05\u5355\u5904\u7406\u65b9\u5f0f", (String)"EcoRequireFilterPlugin_16", (String)"mmc-pdm-formplugin", (Object[])new Object[0])));
        } else {
            unTransmitDealModeField.setCaption(new LocaleString(ResManager.loadKDString((String)"\u672a\u4e0b\u8fbe\u7684\u5de5\u5e8f\u8ba1\u5212\u5904\u7406\u65b9\u5f0f", (String)"EcoRequireFilterPlugin_17", (String)"mmc-pdm-formplugin", (Object[])new Object[0])));
        }
    }

    public void click(EventObject event) {
        super.click(event);
        if (event == null) {
            return;
        }
        Object srcObj = event.getSource();
        Control srcC = srcObj instanceof Control ? (Control)srcObj : null;
        String srcKey = srcC == null ? null : srcC.getKey();
        IFormView fv = this.getView();
        if (fv == null) {
            return;
        }
        if (kd.bos.util.StringUtils.isBlank((String)srcKey)) {
            return;
        }
        if ("filterrule".equalsIgnoreCase(srcKey)) {
            DynamicObject objectentity = this.getAndCheckObjectEntity();
            if (objectentity == null) {
                return;
            }
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("mpdm_datacondition");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "conditiondatacallback"));
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            String status = (String)this.getModel().getValue("status");
            Object filterds = this.getModel().getValue("filterrulevalue_tag");
            params.put("filter", filterds);
            params.put("number", objectentity.get("number"));
            params.put("status", status);
            params.put("row", 0);
            fsp.setCustomParams(params);
            this.getView().showForm(fsp);
        } else if ("srcfieldnumber".equalsIgnoreCase(srcKey)) {
            DynamicObject objectentity = (DynamicObject)this.getModel().getValue("srcobjectentity");
            if (objectentity == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u5de5\u7a0b\u53d8\u66f4\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"EcoRequireFilterPlugin_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.openBillFieldList((String)objectentity.getPkValue());
        } else if ("tragetfieldnumber".equalsIgnoreCase(srcKey)) {
            DynamicObject objectentity = this.getAndCheckObjectEntity();
            if (objectentity == null) {
                return;
            }
            this.openBillFieldList((String)objectentity.getPkValue());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean isForward = this.getIsForward();
        String changeObject = this.getChangeObject();
        this.setMsg(isForward, changeObject);
        this.setDataMatchFilterByBom(isForward);
        this.setDataMatchFilterByRoute(isForward);
        this.setUnTransmitDealModeDisplayName();
    }

    public DynamicObject getAndCheckObjectEntity() {
        DynamicObject objectentity = (DynamicObject)this.getModel().getValue("objectentity");
        if (objectentity == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u5de5\u7a0b\u53d8\u66f4\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"EcoRequireFilterPlugin_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return null;
        }
        return objectentity;
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if ("conditiondatacallback".equals(event.getActionId())) {
            Map data = (Map)event.getReturnData();
            if (data != null) {
                String filter = (String)data.get("filter");
                String number = (String)data.get("number");
                String filterDesc = this.translateJsonString(filter, number);
                this.getModel().setValue("filterrule", (Object)filterDesc);
                this.getModel().setValue("filterrulevalue_tag", (Object)filter);
            }
        } else if (this.isSrcBill(event.getActionId()) || this.isTargetBill(event.getActionId())) {
            Object returnData = event.getReturnData();
            if (returnData == null || StringUtils.isBlank((Object)returnData)) {
                return;
            }
            boolean isSrcBill = this.isSrcBill(event.getActionId());
            String fieldNumber = (String)returnData;
            String fieldCaption = EcoFilterHelper.getFieldName((String)event.getActionId(), (String)fieldNumber);
            int row = this.getModel().getEntryCurrentRowIndex("matchentry");
            String numberField = isSrcBill ? "srcfieldnumber" : "tragetfieldnumber";
            String nameField = isSrcBill ? "leftfieldname" : "targetfieldname";
            this.getModel().setValue(numberField, (Object)fieldNumber, row);
            this.getModel().setValue(nameField, (Object)fieldCaption, row);
        }
    }

    protected String translateJsonString(String filters, String number) {
        if (StringUtils.isBlank((CharSequence)filters) || StringUtils.isBlank((CharSequence)number)) {
            return null;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filters, FilterCondition.class);
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)number);
        String filterStr = this.convertFilterCondition(filterCondition, mainType);
        FilterBuilder fb = new FilterBuilder(mainType, filterCondition, false);
        UserService userService = new UserService();
        fb.setUserService((IUserService)userService);
        fb.buildFilter(false);
        return filterStr;
    }

    protected String convertFilterCondition(FilterCondition filterCondition, MainEntityType mainType) {
        List simpleFilterRows = filterCondition.getFilterRow();
        Iterator simpleFilterRowIterator = simpleFilterRows.iterator();
        StringBuilder filterStr = new StringBuilder();
        ArrayList<SimpleFilterRow> filterRow = new ArrayList<SimpleFilterRow>(16);
        FilterCondition fc = new FilterCondition();
        int row = 1;
        int size = simpleFilterRows.size();
        while (simpleFilterRowIterator.hasNext()) {
            SimpleFilterRow simpleFilterRow = (SimpleFilterRow)simpleFilterRowIterator.next();
            String leftBracket = simpleFilterRow.getLeftBracket();
            String rightBracket = simpleFilterRow.getRightBracket();
            simpleFilterRow.setLeftBracket("");
            simpleFilterRow.setRightBracket("");
            String logicDesc = "";
            String logic = simpleFilterRow.getLogic();
            logicDesc = "1".equals(logic) ? ResManager.loadKDString((String)" \u6216\u8005", (String)"EcoRequireFilterPlugin_6", (String)"mmc-pdm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)" \u5e76\u4e14", (String)"EcoRequireFilterPlugin_7", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
            String fieldName = simpleFilterRow.getFieldName();
            List filterValues = simpleFilterRow.getValue();
            UserService userService = new UserService();
            if (fieldName.endsWith("_mmc_formula") && filterValues != null && !filterValues.isEmpty()) {
                String value = ((FilterValue)filterValues.get(0)).getValue() == null ? "" : (String)((FilterValue)filterValues.get(0)).getValue();
                fieldName = fieldName.replaceAll("_mmc_formula", "");
                if (value.contains("@this")) {
                    value = value.replaceAll("\"@this\"", fieldName);
                }
                value = value.replaceAll("\\s+", " ");
                value = fieldName.concat(" ").concat(ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f", (String)"EcoRequireFilterPlugin_8", (String)"mmc-pdm-formplugin", (Object[])new Object[0])).concat(" ").concat(value);
                filterStr.append(leftBracket);
                if (value.length() > 0) {
                    String[] strlen;
                    for (String str : strlen = value.split(" ")) {
                        DynamicProperty dynamicProperty = mainType.getProperty(str);
                        if (dynamicProperty != null && dynamicProperty.getDisplayName() != null) {
                            String displayName = dynamicProperty.getDisplayName().toString();
                            filterStr.append(displayName).append(' ');
                            continue;
                        }
                        filterStr.append(str).append(' ');
                    }
                }
                if (size == row) {
                    filterStr.append(rightBracket).append(' ');
                } else {
                    filterStr.append(rightBracket).append(logicDesc).append(' ');
                }
                simpleFilterRow.setCompareType("37");
                simpleFilterRow.setFieldName(fieldName);
                simpleFilterRow.setValue(new ArrayList(0));
            } else {
                filterRow.add(simpleFilterRow);
                fc.setFilterRow(filterRow);
                FilterBuilder fb = new FilterBuilder(mainType, fc, false);
                fb.setUserService((IUserService)userService);
                fb.buildFilter(false);
                filterRow.clear();
                if (size == row) {
                    filterStr.append(leftBracket).append(fb.getFilterString().trim()).append(rightBracket).append(' ');
                } else {
                    filterStr.append(leftBracket).append(fb.getFilterString().trim()).append(rightBracket).append(logicDesc).append(' ');
                }
            }
            simpleFilterRow.setLeftBracket(leftBracket);
            simpleFilterRow.setRightBracket(rightBracket);
            ++row;
        }
        return filterStr.toString();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String srcDEPName;
        int rowIndex = e.getRow();
        IDataEntityProperty srcDEP = e.getProperty();
        String string = srcDEPName = srcDEP == null ? null : srcDEP.getName();
        if (MMCUtils.isEmptyString((String)srcDEPName)) {
            return;
        }
        if ("objectentity".equalsIgnoreCase(srcDEPName)) {
            ListFilterParameter lfp;
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
            ArrayList<String> filterEntityList = new ArrayList<String>(16);
            if ("A".equals(this.getChangeObject())) {
                filterEntityList.add("om_mftstock");
                filterEntityList.add("pom_mftstock");
            } else {
                filterEntityList.add("om_mfttechnics");
                filterEntityList.add("sfc_manftech");
            }
            qFilterList.add(new QFilter("id", "in", filterEntityList));
            FormShowParameter fsp = e.getFormShowParameter();
            ListShowParameter lsp = fsp instanceof ListShowParameter ? (ListShowParameter)fsp : null;
            ListFilterParameter listFilterParameter = lfp = lsp == null ? null : lsp.getListFilterParameter();
            if (lfp == null) {
                return;
            }
            lfp.setQFilters(qFilterList);
            lsp.setListFilterParameter(lfp);
            e.setFormShowParameter((FormShowParameter)lsp);
        }
    }

    private IDataEntityProperty getSrcFieldProp(int row) {
        String srcFieldNumber = (String)this.getModel().getValue("srcfieldnumber", row);
        if (kd.bos.util.StringUtils.isEmpty((String)srcFieldNumber)) {
            return null;
        }
        DynamicObject srcEntity = (DynamicObject)this.getModel().getValue("srcobjectentity");
        String entityNumber = (String)srcEntity.getPkValue();
        if (srcFieldNumber.contains(".")) {
            String[] split = srcFieldNumber.split("[.]");
            srcFieldNumber = split[split.length - 1];
        }
        return EcoFilterHelper.getFieldDataEntityProperty((String)entityNumber, (String)srcFieldNumber);
    }

    private boolean isSrcBill(String entityNumber) {
        DynamicObject srcEntity = (DynamicObject)this.getModel().getValue("srcobjectentity");
        return entityNumber.equals((String)srcEntity.getPkValue());
    }

    private boolean isTargetBill(String entityNumber) {
        DynamicObject srcEntity = (DynamicObject)this.getModel().getValue("objectentity");
        return entityNumber.equals((String)srcEntity.getPkValue());
    }

    private void openBillFieldList(String entityNumber) {
        int row = this.getModel().getEntryCurrentRowIndex("matchentry");
        MainEntityType billMainType = EcoFilterHelper.getMainEntityType((String)entityNumber);
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(billMainType);
        parameter.setIncludePKField(true);
        parameter.setOnlyPhysicsField(true);
        if (row >= 0) {
            TreeNode srcBillNode = this.buildBillTreeNodes(parameter, "");
            String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
            this.showBillFieldForm(nodesJson, entityNumber);
        }
    }

    private void showBillFieldForm(String nodesJson, String custumparam) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("msplan_billfieldselect");
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, custumparam));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private TreeNode buildBillTreeNodes(BillTreeBuildParameter parameter, String field) {
        MainEntityType mainType = parameter.getMainType();
        TreeNode billNode = new TreeNode("", mainType.getName(), mainType.getDisplayName().toString());
        billNode.setIsOpened(true);
        List fldNodes = BillFieldEntityHelper.buildFldTreeNodes((BillTreeBuildParameter)parameter);
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(16);
        for (TreeNode node : fldNodes) {
            nodeMap.put(node.getId(), node);
        }
        for (TreeNode node : fldNodes) {
            TreeNode parentNode = (TreeNode)nodeMap.get(node.getParentid());
            if (parentNode == null) {
                node.setParentid(billNode.getId());
                billNode.addChild(node);
                continue;
            }
            parentNode.addChild(node);
        }
        return billNode;
    }

    private void setObjectEntityByChangeObject(String changeObject) {
        String srcObjectEntity = "pdm_ecobom_entryf7";
        String objectEntity = "pom_mftstock";
        if ("B".equals(changeObject)) {
            srcObjectEntity = "pdm_ecoroute_entryf7";
            objectEntity = "sfc_manftech";
        }
        this.getModel().setValue("srcobjectentity", (Object)srcObjectEntity);
        this.getModel().setValue("objectentity", (Object)objectEntity);
        this.getView().updateView("srcobjectentity");
        this.getView().updateView("objectentity");
    }
}

